/*
 * Decompiled with CFR 0.152.
 */
package de.core;

import de.core.DeepEdit;
import de.core.DeepEditFrame;
import de.core.GraphicsUtil;
import de.core.MMTool;
import de.core.OutputPin;
import de.core.Pin;
import de.core.comp;
import de.core.hdb_paspur;
import de.core.hdb_res;
import de.core.hdb_ser;
import de.core.hdb_unit;
import de.core.ndb_inj;
import de.data.DE_GeneralEnums;
import de.data.ParameterData;
import de.utils.StringUtil;
import java.awt.Color;
import java.awt.Graphics2D;
import java.io.PrintStream;
import java.sql.SQLException;
import java.sql.Statement;

public class Generator
extends ndb_inj {
    protected double del_max = 90.0;
    protected double xd = 0.0;
    protected double xd1 = 0.0;
    protected double xd2 = 0.0;
    protected double CvPLP = 0.0;
    protected double xs = 1.5;
    protected double emin = 0.15;
    protected double emax = 1.96;
    protected double gradU = 10.0;
    protected double gradD = 10.0;
    protected String invstate;
    protected String source;
    protected int firstannyear;
    protected int firstannmonth;
    private hdb_unit lhydunit = null;

    public Generator(Pin[][] PinGrid, int x, int y, int entryperiod, int exitperiod, int entrymonth, int exitmonth) {
        super(x, y, 4, 7, 1, 1, 4, 7, 0, 1, entryperiod, exitperiod, entrymonth, exitmonth);
        this.OPin[0] = new OutputPin("Generator", 3, 8, 0, -3, 0, 0, 2);
        this.setName("Generator");
        this.ClassName = "Generator";
        this.inv_type = "Thermal";
        this.inv_owner = "None";
        this.invstate = MMTool.invstate()[0];
        this.source = "None";
        this.firstannyear = entryperiod;
        this.firstannmonth = entrymonth;
        this.pmax = 100.0;
        this.us = 1.0;
        this.qmax = 100.0;
        this.qmin = -100.0;
        this.sn = 100.0;
        this.smax = 200.0;
        this.xs = 1.5;
        this.emin = 0.15;
        this.emax = 1.96;
        this.gradU = 10.0;
        this.gradD = 10.0;
        this.RegisterPins(PinGrid, x, y);
        this.lhydunit = null;
    }

    public Generator(int x, int y, int w, int h, int xh, int yh, int wh, int hh, int i, int o, int entryperiod, int exitperiod, int entrymonth, int exitmonth) {
        super(x, y, w, h, xh, yh, wh, hh, i, o, entryperiod, exitperiod, entrymonth, exitmonth);
    }

    public Generator(Pin[][] PinGrid, int x, int y, String Name, String type, String alias, String owner, String ctrla, double cost, double un1, double un2, double ssmax, int lifetime, int entryperiod, int exitperiod, int entrymonth, int exitmonth, double ppmin, double ppmax, double qqmin, double qqmax, double pp0, double qq0, double aalpha, double bbeta, double ggamma, double sn, double st, int lftype, int lftypes, double uus, double latitude, double longitude, boolean iinservice, double xxd, double xxd1, double xxd2, double CCvPLP, double xxs, double eemin, double eemax, double ggradU, double ggradD, String iinvstate, String ssource, int ffirstannyear, int ffirstannmonth) {
        super(x, y, 4, 7, 1, 1, 4, 7, 0, 1, Name, type, alias, owner, ctrla, cost, un1, un2, ssmax, lifetime, entryperiod, exitperiod, entrymonth, exitmonth, ppmin, ppmax, qqmin, qqmax, aalpha, bbeta, ggamma, sn, st, latitude, longitude);
        this.p0 = pp0;
        this.q0 = qq0;
        this.us = uus;
        this.lf_type = lftype;
        this.lf_type_s = lftypes;
        this.inservice = iinservice;
        this.xd = xxd;
        this.xd1 = xxd1;
        this.xd2 = xxd2;
        this.xs = xxs;
        this.emin = eemin;
        this.emax = eemax;
        this.gradU = ggradU;
        this.gradD = ggradD;
        this.invstate = iinvstate;
        this.source = ssource;
        this.firstannyear = ffirstannyear;
        this.firstannmonth = ffirstannmonth;
        this.CvPLP = CCvPLP;
        this.OPin[0] = new OutputPin(Name, 3, 8, 0, -3, 0, 0, 2);
        this.ClassName = "Generator";
        this.RegisterPins(PinGrid, x, y);
        this.lhydunit = null;
    }

    public Generator(int x, int y, String Name, String type, String owner, String ctrla, double cost, double un1, double un2, double ssmax, int lifetime, int entryperiod, int exitperiod, int entrymonth, int exitmonth, double ppmin, double ppmax, double qqmin, double qqmax, double pp0, double qq0, double aalpha, double bbeta, double ggamma, double sn, double st, int lftype, int lftypes, double uus, double latitude, double longitude, boolean iinservice, double xxd, double xxd1, double xxd2, double CCvPLP, double xxs, double eemin, double eemax, String iinvstate, String ssource, int ffirstannyear, int ffirstannmonth) {
        super(x, y, 4, 7, 1, 1, 4, 7, 0, 1, Name, type, owner, ctrla, cost, un1, un2, ssmax, lifetime, entryperiod, exitperiod, entrymonth, exitmonth, ppmin, ppmax, qqmin, qqmax, aalpha, bbeta, ggamma, sn, st, latitude, longitude);
        this.p0 = pp0;
        this.q0 = qq0;
        this.us = uus;
        this.lf_type = lftype;
        this.lf_type_s = lftypes;
        this.inservice = iinservice;
        this.xd = xxd;
        this.xd1 = xxd1;
        this.xd2 = xxd2;
        this.xs = xxs;
        this.emin = eemin;
        this.emax = eemax;
        this.invstate = iinvstate;
        this.source = ssource;
        this.firstannyear = ffirstannyear;
        this.firstannmonth = ffirstannmonth;
        this.CvPLP = CCvPLP;
        this.lhydunit = null;
    }

    public Generator(int x, int y, String Name, String type, String owner, String ctrla, double cost, double un1, double un2, double ssmax, int lifetime, int entryperiod, int exitperiod, int entrymonth, int exitmonth, double ppmin, double ppmax, double qqmin, double qqmax, double pp0, double qq0, double aalpha, double bbeta, double ggamma, double sn, double st, int lftype, int lftypes, double uus, double latitude, double longitude, boolean iinservice, double xxd, double xxd1, double xxd2, double CCvPLP, String iinvstate, String ssource, int ffirstannyear, int ffirstannmonth) {
        super(x, y, 4, 7, 1, 1, 4, 7, 0, 1, Name, type, owner, ctrla, cost, un1, un2, ssmax, lifetime, entryperiod, exitperiod, entrymonth, exitmonth, ppmin, ppmax, qqmin, qqmax, aalpha, bbeta, ggamma, sn, st, latitude, longitude);
        this.p0 = pp0;
        this.q0 = qq0;
        this.us = uus;
        this.lf_type = lftype;
        this.lf_type_s = lftypes;
        this.inservice = iinservice;
        this.xd = xxd;
        this.xd1 = xxd1;
        this.xd2 = xxd2;
        this.invstate = iinvstate;
        this.source = ssource;
        this.firstannyear = ffirstannyear;
        this.firstannmonth = ffirstannmonth;
        this.CvPLP = CCvPLP;
        this.lhydunit = null;
    }

    public Generator(int x, int y, int w, int h, int xh, int yh, int wh, int hh, int i, int o, String Name, String type, String owner, String ctrla, double cost, double un1, double un2, double ssmax, int lifetime, int entryperiod, int exitperiod, int entrymonth, int exitmonth, double ppmin, double ppmax, double qqmin, double eemax, double eemin, double xxs, double qqmax, double aalpha, double bbeta, double ggamma, double ssn, double sst, double latitude, double longitude, boolean inservice, double xd, double xd1, double xd2) {
        super(x, y, w, h, xh, yh, wh, hh, i, o, Name, type, owner, ctrla, cost, un1, un2, ssmax, lifetime, entryperiod, exitperiod, entrymonth, exitmonth, ppmin, ppmax, qqmin, qqmax, aalpha, bbeta, ggamma, ssn, sst, latitude, longitude);
        this.lhydunit = null;
    }

    public Generator(comp CompToCopy, int xo, int yo) {
        super(CompToCopy, xo, yo);
    }

    public double getdel_max() {
        return this.del_max;
    }

    public double getxd() {
        return this.xd;
    }

    public double getxd1() {
        return this.xd1;
    }

    public double getxd2() {
        return this.xd2;
    }

    public double getxs() {
        return this.xs;
    }

    public double getemin() {
        return this.emin;
    }

    public double getemax() {
        return this.emax;
    }

    public double getgradU() {
        return this.gradU;
    }

    public double getgradD() {
        return this.gradD;
    }

    public double getCvPLP() {
        return this.CvPLP;
    }

    public double getCvSEEDS() {
        return this.CvPLP;
    }

    public String getinvstate() {
        return this.invstate;
    }

    public String getsource() {
        return this.source;
    }

    public int getfirstannyear() {
        return this.firstannyear;
    }

    public int getfirstannmonth() {
        return this.firstannmonth;
    }

    public hdb_unit getLHydUnit() {
        return this.lhydunit;
    }

    public void setdel_max(double n) {
        this.del_max = n;
    }

    public void setxd(double n) {
        this.xd = n;
    }

    public void setxd1(double n) {
        this.xd1 = n;
    }

    public void setxd2(double n) {
        this.xd2 = n;
    }

    public void setxs(double n) {
        this.xs = n;
    }

    public void setemin(double n) {
        this.emin = n;
    }

    public void setemax(double n) {
        this.emax = n;
    }

    public void setgradU(double n) {
        this.gradU = n;
    }

    public void setgradD(double n) {
        this.gradD = n;
    }

    public void setCvPLP(double n) {
        this.CvPLP = n;
    }

    public void setCvSEEDS(double n) {
        this.CvPLP = n;
    }

    public void setinvstate(String n) {
        this.invstate = n;
    }

    public void setsource(String n) {
        this.source = n;
    }

    public void setfirstannyear(int n) {
        this.firstannyear = n;
    }

    public void setfirstannmonth(int n) {
        this.firstannmonth = n;
    }

    public void setLHydUnit(hdb_unit phunit) {
        if (phunit != null && (phunit instanceof hdb_ser || phunit instanceof hdb_res || phunit instanceof hdb_paspur)) {
            this.lhydunit = phunit;
            this.inv_type = phunit instanceof hdb_ser || phunit instanceof hdb_paspur ? "HydroS" : "HydroR";
        }
    }

    public void finalize() {
        if (this.lhydunit != null) {
            this.lhydunit.setLElGen(null);
        }
    }

    @Override
    public comp Copy(int xo, int yo) {
        Generator NewComponent = new Generator(this, xo, yo);
        NewComponent.setCvPLP(this.getCvPLP());
        NewComponent.setsn(this.getsn());
        NewComponent.setlf_type(this.getlf_type());
        NewComponent.setlf_type_s(this.getlf_type_s());
        NewComponent.setun1(this.getun1());
        NewComponent.setus(this.getus());
        NewComponent.setst(this.getst());
        NewComponent.setsmax(this.getsmax());
        NewComponent.setalpha(this.getalpha());
        NewComponent.setbeta(this.getbeta());
        NewComponent.setgamma(this.getgamma());
        NewComponent.setpmax(this.getpmax());
        NewComponent.setp0(this.getp0());
        NewComponent.setq0(this.getq0());
        NewComponent.setpmin(this.getpmin());
        NewComponent.setqmax(this.getqmax());
        NewComponent.setqmin(this.getqmin());
        NewComponent.setlife_time(this.getlife_time());
        NewComponent.setentry_period(this.getentry_period());
        NewComponent.setexit_period(this.getexit_period());
        NewComponent.setentry_month(this.getentry_month());
        NewComponent.setexit_month(this.getexit_month());
        NewComponent.setinv_cost(this.getinv_cost());
        NewComponent.setinv_type(this.getinv_type());
        NewComponent.setalias(this.getalias());
        NewComponent.setinv_owner("None");
        NewComponent.setlatitude(this.getlatitude());
        NewComponent.setlongitude(this.getlongitude());
        NewComponent.setctrla(this.getctrla());
        NewComponent.setxd(this.getxd());
        NewComponent.setxd1(this.getxd1());
        NewComponent.setxd2(this.getxd2());
        NewComponent.setinvstate(this.getinvstate());
        NewComponent.setsource(this.getsource());
        NewComponent.setfirstannyear(this.getfirstannyear());
        NewComponent.setfirstannmonth(this.getfirstannmonth());
        return NewComponent;
    }

    @Override
    public void SimulateSetUpFlows(double sref) {
        double belastung = Math.sqrt(Math.abs(this.p) * Math.abs(this.p) + Math.abs(this.q) * Math.abs(this.q));
        if (this.getsmax() > 0.0) {
            belastung = this.q != 0.0 ? (belastung /= this.getsmax()) : (belastung /= this.getpmax());
        } else {
            return;
        }
        this.auxcolor = belastung >= 0.9 ? Color.red : (belastung >= 0.5 ? Color.orange : Color.green);
    }

    @Override
    public void draw(Graphics2D g, int xp, int yp, int gs, boolean Modifiedstate, boolean Simulate, boolean cycle, double sref, int actperiod, int actmonth, int typsim) {
        super.draw(g, xp, yp, gs);
        int x = this.Pos.x - xp;
        int y = this.Pos.y - yp;
        String letra = MMTool.linvstate()[0];
        for (int i = 0; i < MMTool.invstate().length; ++i) {
            if (!this.invstate.equals(MMTool.invstate()[i])) continue;
            letra = MMTool.linvstate()[i];
        }
        this.auxs = DeepEdit.ShowAlias ? this.alias : this.ComponentName;
        if (this.getlf_type() == 3 && this.inservice) {
            g.setColor(Color.red);
            g.fillOval((x + 1) * gs, (y + 1) * gs, 4 * gs, 4 * gs);
        }
        if (!Simulate) {
            if (!this.inservice) {
                g.setColor(Color.white);
            } else {
                g.setColor(TextColor2);
            }
            if (gs > 2 && gs < 4) {
                g.setFont(Font8);
                g.drawString(letra, (int)(((double)x + 2.75) * (double)gs), (int)(((double)y + 3.75) * (double)gs));
            } else if (gs >= 4 && gs < 8) {
                g.setFont(Font9);
                g.drawString(letra, (int)(((double)x + 2.75) * (double)gs), (int)(((double)y + 3.75) * (double)gs));
            } else if (gs >= 8 && gs < 10) {
                g.setFont(Font11);
                g.drawString(letra, (int)(((double)x + 2.75) * (double)gs), (int)(((double)y + 3.75) * (double)gs));
                g.drawString(this.auxs, (x + 1) * gs, y * gs);
            } else if (gs >= 10 && gs < 14) {
                g.setFont(Font12);
                g.drawString(letra, (int)(((double)x + 2.75) * (double)gs), (int)(((double)y + 3.75) * (double)gs));
                g.drawString(this.auxs, (x + 1) * gs, y * gs);
            } else if (gs >= 14 && gs < 18) {
                g.setFont(Font16);
                g.drawString(letra, (int)(((double)x + 2.75) * (double)gs), (int)(((double)y + 3.75) * (double)gs));
                g.drawString(this.auxs, (x + 1) * gs, y * gs);
            }
            if (gs >= 6 && !Modifiedstate && this.getinservice()) {
                if (gs >= 12) {
                    g.setFont(Font10);
                } else {
                    g.setFont(Font9);
                }
                if (!this.inservice) {
                    g.setColor(Color.black);
                } else {
                    g.setColor(Color1);
                }
                g.drawString(StringUtil.numformat(this.p, 7, 2), (int)(((double)x + 3.0) * (double)gs), (int)(((double)y + 6.75) * (double)gs));
                if (typsim != 1 && typsim != 2 && typsim != 6 && typsim != 7) {
                    if (!this.inservice) {
                        g.setColor(Color.white);
                    } else {
                        g.setColor(TextColor1);
                    }
                    g.drawString(StringUtil.numformat(this.q, 7, 2), (int)(((double)x + 3.0) * (double)gs), (int)(((double)y + 7.75) * (double)gs));
                }
            }
            if (!this.inservice) {
                g.setColor(Color.black);
            } else {
                g.setColor(this.getkv_color1());
            }
            g.drawOval((x + 1) * gs, (y + 1) * gs, 4 * gs, 4 * gs);
            this.DrawOutputPins(g, x, y, gs);
        } else if (this.p > 0.0) {
            g.setColor(this.auxcolor);
            if (cycle) {
                GraphicsUtil.drawArrow(g, (int)(((double)x + 3.0) * (double)gs), (int)(((double)y + 4.25) * (double)gs), (int)(((double)x + 3.0) * (double)gs), (int)(((double)y + 7.5) * (double)gs), 1, (int)((double)gs * 1.5));
            } else {
                GraphicsUtil.drawArrow(g, (int)(((double)x + 3.0) * (double)gs), (int)(((double)y + 7.5) * (double)gs), (int)(((double)x + 3.0) * (double)gs), (int)(((double)y + 10.5) * (double)gs), 1, (int)((double)gs * 1.5));
            }
        }
    }

    @Override
    public void Save(PrintStream myPrintStream) {
        myPrintStream.println("describe component " + this.ClassName);
        myPrintStream.println(" pos " + this.Pos.x + " " + this.Pos.y);
        myPrintStream.println(" Name " + this.ComponentName);
        myPrintStream.println(" type " + this.inv_type);
        myPrintStream.println(" alias " + this.alias);
        myPrintStream.println(" owner " + this.inv_owner);
        myPrintStream.println(" cost " + this.inv_cost);
        myPrintStream.println(" un1 " + this.un[0]);
        myPrintStream.println(" us  " + this.us);
        myPrintStream.println(" smax " + this.smax);
        myPrintStream.println(" lifetime " + this.life_time);
        myPrintStream.println(" entryperiod " + this.entry_period);
        myPrintStream.println(" exitperiod " + this.exit_period);
        myPrintStream.println(" entrymonth " + this.entry_month);
        myPrintStream.println(" exitmonth " + this.exit_month);
        myPrintStream.println(" pmin " + this.pmin);
        myPrintStream.println(" pmax " + this.pmax);
        myPrintStream.println(" qmin " + this.qmin);
        myPrintStream.println(" qmax " + this.qmax);
        myPrintStream.println(" emax " + this.emax);
        myPrintStream.println(" emin " + this.emin);
        myPrintStream.println(" gradU " + this.gradU);
        myPrintStream.println(" gradD " + this.gradD);
        myPrintStream.println(" p0 " + this.p0);
        myPrintStream.println(" q0 " + this.q0);
        myPrintStream.println(" alpha " + this.alpha);
        myPrintStream.println(" beta " + this.beta);
        myPrintStream.println(" gamma " + this.gamma);
        myPrintStream.println(" sn  " + this.sn);
        myPrintStream.println(" st  " + this.st);
        myPrintStream.println(" lftype  " + this.lf_type);
        myPrintStream.println(" lftypes  " + this.lf_type_s);
        myPrintStream.println(" latitude  " + this.latitude);
        myPrintStream.println(" longitude  " + this.longitude);
        myPrintStream.println(" ctrla " + this.ctrla);
        myPrintStream.println(" inservice " + this.inservice);
        myPrintStream.println(" xd " + this.xd);
        myPrintStream.println(" xd1 " + this.xd1);
        myPrintStream.println(" xd2 " + this.xd2);
        myPrintStream.println(" xs " + this.xs);
        myPrintStream.println(" CvPLP " + this.CvPLP);
        myPrintStream.println(" invstate " + this.invstate);
        myPrintStream.println(" source " + this.source);
        myPrintStream.println(" firstannyear " + this.firstannyear);
        myPrintStream.println(" firstannmonth " + this.firstannmonth);
        myPrintStream.println("end describe");
    }

    @Override
    public void SaveDatabase() throws SQLException {
        int x = 0;
        Statement stmt = DeepEditFrame.con.createStatement();
        String query = "INSERT INTO Generator (XPos,YPos,Name,type,alias,owner,ctrla,cost,un1,smax,lifetime,entryperiod,exitperiod,entrymonth, exitmonth,pmin,pmax,qmin,qmax,p0,q0,alpha,beta,gamma,sn,st,lftype,lftypes,us,latitude,longitude,U,delta,p,q,spotp,spotq,con2,inservice,xd,xd1,xd2,CvPLP,xs,emin,emax,gradU,gradD, invstate, source, firstannyear, firstannmonth) VALUES (" + String.valueOf(this.Pos.x) + "," + String.valueOf(this.Pos.y) + ",'" + this.ComponentName + "','" + this.inv_type + "','" + this.alias + "','" + this.inv_owner + "','" + this.ctrla + "'," + String.valueOf(this.inv_cost) + "," + String.valueOf(this.un[0]) + "," + String.valueOf(this.smax) + "," + String.valueOf(this.life_time) + "," + String.valueOf(this.entry_period) + "," + String.valueOf(this.exit_period) + "," + String.valueOf(this.entry_month) + "," + String.valueOf(this.exit_month) + "," + String.valueOf(this.pmin) + "," + String.valueOf(this.pmax) + "," + String.valueOf(this.qmin) + "," + String.valueOf(this.qmax) + "," + String.valueOf(this.p0) + "," + String.valueOf(this.q0) + "," + String.valueOf(this.alpha) + "," + String.valueOf(this.beta) + "," + String.valueOf(this.gamma) + "," + String.valueOf(this.sn) + "," + String.valueOf(this.st) + "," + String.valueOf(this.lf_type) + "," + String.valueOf(this.lf_type_s) + "," + String.valueOf(this.us) + "," + String.valueOf(this.latitude) + "," + String.valueOf(this.longitude) + "," + String.valueOf(this.getun2()) + "," + String.valueOf(this.getdelta2()) + "," + String.valueOf(this.p) + "," + String.valueOf(this.q) + "," + String.valueOf(this.spot_p) + "," + String.valueOf(this.spot_q) + ",'" + this.con2 + "'," + (this.inservice ? 1 : 0) + "," + String.valueOf(this.xd) + "," + String.valueOf(this.xd1) + "," + String.valueOf(this.xd2) + "," + String.valueOf(this.CvPLP) + "," + String.valueOf(this.xs) + "," + String.valueOf(this.emin) + "," + String.valueOf(this.emax) + "," + String.valueOf(this.gradU) + "," + String.valueOf(this.gradD) + ",'" + this.invstate + "','" + this.source + "'," + this.firstannyear + "," + this.firstannmonth + ")";
        x = stmt.executeUpdate(query);
        stmt.close();
    }

    public String Statistic(int ix, double sref) {
        this.InformAllComponents();
        return "Generator: " + StringUtil.printf(this.getName(), 40) + StringUtil.printf(this.con2, 40);
    }

    @Override
    public boolean getParameterInfo(String sParameterName, ParameterData oData) {
        String sValue = null;
        DE_GeneralEnums.databaseDataType eDataType = null;
        DE_GeneralEnums.parameterGroup eGroup = null;
        oData.seteGroup(DE_GeneralEnums.parameterGroup.Operation);
        if (sParameterName.equalsIgnoreCase("Name")) {
            sValue = this.getName();
            eDataType = DE_GeneralEnums.databaseDataType.StringValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("con2")) {
            sValue = this.getcon2();
            eDataType = DE_GeneralEnums.databaseDataType.StringValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("alias")) {
            sValue = this.getalias();
            eDataType = DE_GeneralEnums.databaseDataType.StringValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("p")) {
            sValue = String.valueOf(this.getp());
            eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("q")) {
            sValue = String.valueOf(this.getq());
            eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("p0")) {
            sValue = String.valueOf(this.getp0());
            eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("q0")) {
            sValue = String.valueOf(this.getq0());
            eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("un1")) {
            sValue = String.valueOf(this.getun1());
            eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("us")) {
            sValue = String.valueOf(this.getus());
            eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("smax")) {
            sValue = String.valueOf(this.getsmax());
            eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("pmin")) {
            sValue = String.valueOf(this.getpmin());
            eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("pmax")) {
            sValue = String.valueOf(this.getpmax());
            eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("qmin")) {
            sValue = String.valueOf(this.getqmin());
            eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("qmax")) {
            sValue = String.valueOf(this.getqmax());
            eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("sn")) {
            sValue = String.valueOf(this.getsn());
            eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("st")) {
            sValue = String.valueOf(this.getst());
            eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("lftype")) {
            sValue = String.valueOf(this.getlf_type());
            eDataType = DE_GeneralEnums.databaseDataType.IntegerValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("lftypes")) {
            sValue = String.valueOf(this.getlf_type_s());
            eDataType = DE_GeneralEnums.databaseDataType.IntegerValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("U")) {
            sValue = String.valueOf(this.getub());
            eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("delta")) {
            sValue = String.valueOf(this.getdelta1());
            eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("spotp")) {
            sValue = String.valueOf(this.getspot_p());
            eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("spotq")) {
            sValue = String.valueOf(this.getspot_q());
            eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("inservicei")) {
            sValue = String.valueOf(this.getinservicei());
            eDataType = DE_GeneralEnums.databaseDataType.IntegerValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("inservice")) {
            sValue = String.valueOf(this.getinservice());
            eDataType = DE_GeneralEnums.databaseDataType.BooleanValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("xs")) {
            sValue = String.valueOf(this.getxs());
            eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("xd")) {
            sValue = String.valueOf(this.getxd());
            eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("xd1")) {
            sValue = String.valueOf(this.getxd1());
            eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("emin")) {
            sValue = String.valueOf(this.getemin());
            eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("emax")) {
            sValue = String.valueOf(this.getemax());
            eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("xd2")) {
            sValue = String.valueOf(this.getxd2());
            eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("gradU")) {
            sValue = String.valueOf(this.getgradU());
            eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("gradD")) {
            sValue = String.valueOf(this.getgradD());
            eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("type")) {
            sValue = this.getinv_type();
            eDataType = DE_GeneralEnums.databaseDataType.StringValue;
            eGroup = DE_GeneralEnums.parameterGroup.Economic;
        } else if (sParameterName.equalsIgnoreCase("owner")) {
            sValue = this.getinv_owner();
            eDataType = DE_GeneralEnums.databaseDataType.StringValue;
            eGroup = DE_GeneralEnums.parameterGroup.Economic;
        } else if (sParameterName.equalsIgnoreCase("invstate")) {
            sValue = this.getinvstate();
            eDataType = DE_GeneralEnums.databaseDataType.StringValue;
            eGroup = DE_GeneralEnums.parameterGroup.Economic;
        } else if (sParameterName.equalsIgnoreCase("lifetime")) {
            sValue = String.valueOf(this.getlife_time());
            eDataType = DE_GeneralEnums.databaseDataType.IntegerValue;
            eGroup = DE_GeneralEnums.parameterGroup.Economic;
        } else if (sParameterName.equalsIgnoreCase("entryperiod")) {
            sValue = String.valueOf(this.getentry_period());
            eDataType = DE_GeneralEnums.databaseDataType.IntegerValue;
            eGroup = DE_GeneralEnums.parameterGroup.Economic;
        } else if (sParameterName.equalsIgnoreCase("exitperiod")) {
            sValue = String.valueOf(this.getexit_period());
            eDataType = DE_GeneralEnums.databaseDataType.IntegerValue;
            eGroup = DE_GeneralEnums.parameterGroup.Economic;
        } else if (sParameterName.equalsIgnoreCase("cost")) {
            sValue = String.valueOf(this.getinv_cost());
            eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
            eGroup = DE_GeneralEnums.parameterGroup.Economic;
        } else if (sParameterName.equalsIgnoreCase("firstannyear")) {
            sValue = String.valueOf(this.getfirstannyear());
            eDataType = DE_GeneralEnums.databaseDataType.IntegerValue;
            eGroup = DE_GeneralEnums.parameterGroup.Economic;
        } else if (sParameterName.equalsIgnoreCase("firstannmonth")) {
            sValue = String.valueOf(this.getfirstannmonth());
            eDataType = DE_GeneralEnums.databaseDataType.IntegerValue;
            eGroup = DE_GeneralEnums.parameterGroup.Economic;
        } else if (sParameterName.equalsIgnoreCase("entrymonth")) {
            sValue = String.valueOf(this.getentry_month());
            eDataType = DE_GeneralEnums.databaseDataType.IntegerValue;
            eGroup = DE_GeneralEnums.parameterGroup.Economic;
        } else if (sParameterName.equalsIgnoreCase("exitmonth")) {
            sValue = String.valueOf(this.getexit_month());
            eDataType = DE_GeneralEnums.databaseDataType.IntegerValue;
            eGroup = DE_GeneralEnums.parameterGroup.Economic;
        } else if (sParameterName.equalsIgnoreCase("CvPLP")) {
            sValue = String.valueOf(this.getCvPLP());
            eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
            eGroup = DE_GeneralEnums.parameterGroup.Economic;
        } else if (sParameterName.equalsIgnoreCase("alpha")) {
            sValue = String.valueOf(this.getalpha());
            eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
            eGroup = DE_GeneralEnums.parameterGroup.Economic;
        } else if (sParameterName.equalsIgnoreCase("beta")) {
            sValue = String.valueOf(this.getbeta());
            eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
            eGroup = DE_GeneralEnums.parameterGroup.Economic;
        } else if (sParameterName.equalsIgnoreCase("gamma")) {
            sValue = String.valueOf(this.getgamma());
            eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
            eGroup = DE_GeneralEnums.parameterGroup.Economic;
        } else if (sParameterName.equalsIgnoreCase("ctrla")) {
            sValue = this.getctrla();
            eDataType = DE_GeneralEnums.databaseDataType.StringValue;
            eGroup = DE_GeneralEnums.parameterGroup.Location;
        } else if (sParameterName.equalsIgnoreCase("latitude")) {
            sValue = String.valueOf(this.getlatitude());
            eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
            eGroup = DE_GeneralEnums.parameterGroup.Location;
        } else if (sParameterName.equalsIgnoreCase("longitude")) {
            sValue = String.valueOf(this.getlongitude());
            eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
            eGroup = DE_GeneralEnums.parameterGroup.Location;
        } else if (sParameterName.equalsIgnoreCase("Xpos")) {
            sValue = String.valueOf(this.getxpos());
            eDataType = DE_GeneralEnums.databaseDataType.IntegerValue;
            eGroup = DE_GeneralEnums.parameterGroup.Location;
        } else if (sParameterName.equalsIgnoreCase("Ypos")) {
            sValue = String.valueOf(this.getypos());
            eDataType = DE_GeneralEnums.databaseDataType.IntegerValue;
            eGroup = DE_GeneralEnums.parameterGroup.Location;
        } else if (sParameterName.equalsIgnoreCase("source")) {
            sValue = this.getsource();
            eDataType = DE_GeneralEnums.databaseDataType.StringValue;
            eGroup = DE_GeneralEnums.parameterGroup.Specific;
        }
        if (sValue != null) {
            oData.setValue(sValue, eDataType, eGroup);
        } else {
            ParameterData oDataOld = (ParameterData)this.mData.get(sParameterName);
            if (oDataOld == null && (oDataOld = DeepEdit.getDefaultParameterInfo(this.ClassName, sParameterName)) == null) {
                assert (false) : "Why are you looking for parameter '" + sParameterName + "' if it is not supported by object '" + this.ClassName + "?";
                return false;
            }
            oDataOld.copyParameterInto(oData);
        }
        return true;
    }

    @Override
    public boolean setParameterInfo(String sParameterName, ParameterData pData) {
        String sValue = pData.getValue();
        if (sParameterName.equalsIgnoreCase("Name")) {
            this.setName(sValue);
            return true;
        }
        if (sParameterName.equalsIgnoreCase("con2")) {
            this.setcon2(sValue);
            return true;
        }
        if (sParameterName.equalsIgnoreCase("alias")) {
            this.setalias(sValue);
            return true;
        }
        if (sParameterName.equalsIgnoreCase("p")) {
            this.setp(Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("q")) {
            this.setq(Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("p0")) {
            this.setp0(Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("q0")) {
            this.setq0(Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("un1")) {
            this.setun1(Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("us")) {
            this.setus(Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("smax")) {
            this.setsmax(Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("pmin")) {
            this.setpmin(Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("pmax")) {
            this.setpmax(Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("qmin")) {
            this.setqmin(Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("qmax")) {
            this.setqmax(Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("sn")) {
            this.setsn(Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("st")) {
            this.setst(Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("lftype")) {
            this.setlf_type((int)Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("lftypes")) {
            this.setlf_type_s((int)Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("U")) {
            this.setub(Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("delta")) {
            this.setdelta1(Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("spotp")) {
            this.setspot_p(Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("spotq")) {
            this.setspot_q(Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("inservicei")) {
            this.setinservicei(Integer.parseInt(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("inservice")) {
            this.setinservice(Boolean.parseBoolean(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("xs")) {
            this.setxs(Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("xd")) {
            this.setxd(Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("xd1")) {
            this.setxd1(Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("emin")) {
            this.setemin(Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("emax")) {
            this.setemax(Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("xd2")) {
            this.setxd2(Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("gradU")) {
            this.setgradU(Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("gradD")) {
            this.setgradD(Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("type")) {
            this.setinv_type(sValue);
            return true;
        }
        if (sParameterName.equalsIgnoreCase("owner")) {
            this.setinv_owner(sValue);
            return true;
        }
        if (sParameterName.equalsIgnoreCase("invstate")) {
            this.setinvstate(sValue);
            return true;
        }
        if (sParameterName.equalsIgnoreCase("lifetime")) {
            this.setlife_time((int)Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("entryperiod")) {
            this.setentry_period((int)Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("exitperiod")) {
            this.setexit_period((int)Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("cost")) {
            this.setinv_cost((int)Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("firstannyear")) {
            this.setfirstannyear((int)Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("firstannmonth")) {
            this.setfirstannmonth((int)Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("entrymonth")) {
            this.setentry_month((int)Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("exitmonth")) {
            this.setexit_month((int)Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("CvPLP")) {
            this.setCvPLP(Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("alpha")) {
            this.setalpha(Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("beta")) {
            this.setbeta(Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("gamma")) {
            this.setgamma(Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("ctrla")) {
            this.setctrla(sValue);
            return true;
        }
        if (sParameterName.equalsIgnoreCase("latitude")) {
            this.setlatitude(Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("longitude")) {
            this.setlongitude(Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("Xpos")) {
            this.setxpos((int)Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("Ypos")) {
            this.setypos((int)Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("source")) {
            this.setsource(sValue);
            return true;
        }
        ParameterData pDataOld = (ParameterData)this.mData.get(sParameterName);
        if (pDataOld != null) {
            pDataOld.setValue(sValue);
        } else {
            this.mData.put(sParameterName, pData);
        }
        return true;
    }
}

