/*
 * Decompiled with CFR 0.152.
 */
package de.core;

import de.core.DeepEdit;
import de.core.agent;

public class GaGeneration {
    protected int genNumber = 0;
    protected int popSize = 0;
    protected agent[] population;
    protected int xGeneCount;
    protected double Pc;
    protected double Pm;
    protected double fitness = -1.0E9;
    protected double improvement = 0.0;
    protected int best;
    DeepEdit applet;

    public GaGeneration() {
        this.xGeneCount = 0;
        this.Pc = 0.0;
        this.Pm = 0.0;
    }

    public GaGeneration(int xGcount, double newC, double newM) {
        this.xGeneCount = xGcount;
        this.Pc = newC;
        this.Pm = newM;
    }

    public void initPopulation(DeepEdit app) {
        this.applet = app;
        long maxLSB = (long)Math.pow(2.0, this.xGeneCount / 2);
        int odd = this.xGeneCount % 2;
        long maxMSB = odd != 0 ? maxLSB << 1 : maxLSB;
        for (int i = 0; i < this.popSize; ++i) {
            long gene = (long)((double)maxLSB * Math.random());
            if (this.check(gene += maxLSB * (long)(Math.random() * (double)maxMSB), this.applet)) {
                this.population[i].setGenes(gene);
                continue;
            }
            System.out.println("correccion del population");
            this.population[i].setGenes(this.fix(gene));
        }
    }

    public void setPopSize(int sizeOfpop) {
        this.popSize = sizeOfpop;
        this.population = new agent[this.popSize];
        for (int i = 0; i < this.popSize; ++i) {
            this.population[i] = new agent();
        }
    }

    public void setGeneCount(int xGcount) {
        this.xGeneCount = xGcount;
    }

    public void setCrossOverRate(double newC) {
        this.Pc = newC;
    }

    public void setMutateRate(double newM) {
        this.Pm = newM;
    }

    public double getImprovement() {
        return this.improvement;
    }

    public double getCrossOverRate() {
        return this.Pc;
    }

    public double getMutateRate() {
        return this.Pm;
    }

    public int getGenNumber() {
        return this.genNumber;
    }

    public void setGenNumber(int newGen) {
        this.genNumber = newGen;
    }

    public void incGenNumber() {
        ++this.genNumber;
    }

    void evaluate(double baseX, double incX, DeepEdit app) {
        this.applet = app;
        for (int i = 0; i < this.popSize; ++i) {
            this.population[i].evaluate(this.population[i].getGenes(), baseX, incX, this.applet);
        }
    }

    public double getWorstAnswer() {
        double worstAnswer = -1.0E7;
        for (int i = 0; i < this.popSize; ++i) {
            double answer = this.population[i].getAnswer();
            if (!(answer < worstAnswer)) continue;
            worstAnswer = answer;
        }
        return worstAnswer;
    }

    public void calcCumFitnesses() {
        int i;
        double prevFitness = this.fitness;
        double worstAnswer = this.getWorstAnswer();
        this.fitness = 0.0;
        for (i = 0; i < this.popSize; ++i) {
            this.fitness += this.population[i].getAnswer() - worstAnswer;
        }
        double totalFitness = 0.0;
        for (i = 0; i < this.popSize; ++i) {
            this.population[i].calcFitness(this.fitness, worstAnswer);
            this.population[i].setCumFitness(totalFitness += this.population[i].getFitness());
        }
        this.improvement = this.fitness - prevFitness;
    }

    public void ordenar(long[] atributos, double[] atrib, agent[] pop, int large) {
        int j;
        int i;
        agent[] auxpop = new agent[this.popSize];
        this.calcCumFitnesses();
        int cont = 0;
        for (i = 0; i < this.popSize - 1; ++i) {
            for (j = i + 1; j < this.popSize; ++j) {
                if (!(this.population[i].getFitness() < this.population[j].getFitness())) continue;
                agent auxpopulation = this.population[i];
                this.population[i] = this.population[j];
                this.population[j] = auxpopulation;
            }
        }
        for (i = 0; i < this.popSize; ++i) {
            auxpop[i] = new agent();
            agent.copy(this.population[i], auxpop[i]);
        }
        for (i = 0; i < this.popSize - 1; ++i) {
            for (j = i + 1; j < this.popSize && auxpop[i].getAnswer() != 25.0; ++j) {
                if (auxpop[i].getGenes() != auxpop[j].getGenes()) continue;
                agent.copynull(auxpop[j]);
            }
        }
        for (i = 0; i < large; ++i) {
            pop[i] = new agent();
            atrib[i] = 25.0;
        }
        i = 0;
        while (cont < large && i + cont != this.popSize) {
            if (auxpop[i + cont].getAnswer() != 25.0) {
                atributos[cont] = auxpop[i + cont].getGenes();
                atrib[cont] = auxpop[i + cont].getAnswer();
                agent.copy(auxpop[i + cont], pop[cont]);
                ++cont;
                continue;
            }
            ++i;
        }
        this.applet.myPrintStream1.println("Generaci\u00f3n Actual");
        for (i = 0; i < large; ++i) {
            this.applet.myPrintStream1.println(atributos[i] + "--->" + atrib[i]);
        }
    }

    public void elitismo(agent[] pop, int elitico) {
        int i;
        this.calcCumFitnesses();
        for (i = 0; i < this.popSize - 1; ++i) {
            for (int j = i + 1; j < this.popSize; ++j) {
                if (!(this.population[i].getFitness() < this.population[j].getFitness())) continue;
                agent auxpopulation = this.population[i];
                this.population[i] = this.population[j];
                this.population[j] = auxpopulation;
            }
        }
        for (i = this.popSize - elitico; i < this.popSize; ++i) {
            agent.copy(pop[i - (this.popSize - elitico)], this.population[i]);
        }
    }

    public double calcmean() {
        double mean = 0.0;
        for (int i = 0; i < this.popSize; ++i) {
            mean += this.population[i].getAnswer();
        }
        return mean /= (double)this.popSize;
    }

    public void select() {
        int i;
        agent[] newPop = new agent[this.popSize];
        for (i = 0; i < this.popSize; ++i) {
            newPop[i] = new agent();
        }
        this.calcCumFitnesses();
        block1: for (i = 0; i < this.popSize; ++i) {
            double random = Math.random();
            for (int j = 0; j < this.popSize; ++j) {
                if (!(random < this.population[j].getCumFitness())) continue;
                newPop[i].setGenes(this.population[j].getGenes());
                newPop[i].setAnswer(this.population[j].getAnswer());
                newPop[i].setFitness(this.population[j].getFitness());
                continue block1;
            }
        }
        for (i = 0; i < this.popSize; ++i) {
            this.population[i].setGenes(newPop[i].getGenes());
            this.population[i].setAnswer(newPop[i].getAnswer());
            this.population[i].setFitness(newPop[i].getFitness());
        }
    }

    public void genCrossOver() {
        int i;
        int[] crossList = new int[this.popSize];
        agent aux1 = new agent();
        agent aux2 = new agent();
        int crossCount = 0;
        for (i = 0; i < this.popSize; ++i) {
            double random = Math.random();
            if (!(random < this.Pc)) continue;
            crossList[crossCount] = i;
            ++crossCount;
        }
        for (i = 0; i < crossCount - 1; i += 2) {
            int bitnum = (int)(Math.random() * (double)(this.xGeneCount - 1) + 1.0);
            int index1 = crossList[i];
            int index2 = crossList[i + 1];
            agent.copy(this.population[index1], aux1);
            agent.copy(this.population[index2], aux2);
            agent.crossOver(aux1, aux2, bitnum);
            if (this.check(aux1.getGenes(), this.applet) & this.check(aux2.getGenes(), this.applet)) {
                agent.crossOver(this.population[index1], this.population[index2], bitnum);
                continue;
            }
            i += 2;
        }
    }

    public void mutate() {
        agent aux = new agent();
        for (int i = 0; i < this.popSize; ++i) {
            for (int j = 0; j < this.xGeneCount; ++j) {
                if (!(Math.random() < this.Pm)) continue;
                agent.copy(this.population[i], aux);
                aux.flip(j);
                if (this.check(aux.getGenes(), this.applet)) {
                    this.population[i].flip(j);
                    continue;
                }
                System.out.println("Esta Malo el Mutate");
                ++j;
            }
        }
    }

    public boolean check(long gen_check, DeepEdit app) {
        this.applet = app;
        int jr = 0;
        int numbit_plan = DeepEdit.MySchematic.getcodebit();
        int numplanes = DeepEdit.MySchematic.getnumoptimize();
        int horizonte = DeepEdit.MySchematic.getendperiod() - DeepEdit.MySchematic.getiniperiod() + 1;
        int largo = numplanes * numbit_plan;
        long BIT = (long)Math.pow(2.0, largo) - 1L;
        long bit = BIT << numbit_plan;
        bit ^= 0xFFFFFFFFFFFFFFFFL;
        for (int ir = 0; ir < numplanes; ++ir) {
            int aux_check = (int)(gen_check & bit);
            gen_check >>= numbit_plan;
            if (aux_check <= horizonte) continue;
            ++jr;
        }
        return jr == 0;
    }

    public long fix(long gen_check) {
        int ir;
        boolean jr = false;
        long gen_new = 0L;
        int corte = 0;
        int numplanes = DeepEdit.MySchematic.getnumoptimize();
        int numbit_plan = DeepEdit.MySchematic.getcodebit();
        int horizonte = DeepEdit.MySchematic.getendperiod() - DeepEdit.MySchematic.getiniperiod() + 1;
        int largo = numplanes * numbit_plan;
        System.out.println("Viejo Gen :" + gen_check);
        long BIT = (long)Math.pow(2.0, largo) - 1L;
        long bit = BIT << numbit_plan;
        bit ^= 0xFFFFFFFFFFFFFFFFL;
        for (ir = 0; ir < numbit_plan - 1; ++ir) {
            corte += (int)Math.pow(2.0, ir);
        }
        for (ir = 0; ir < numplanes; ++ir) {
            int aux_g;
            int h;
            int aux_check = (int)(gen_check & bit);
            gen_check >>= numbit_plan;
            if (aux_check > horizonte) {
                aux_check &= corte;
                for (h = 0; h < numbit_plan; ++h) {
                    aux_g = aux_check & 1;
                    gen_new = (long)((double)gen_new + Math.pow(2.0, h + ir * numbit_plan) * (double)aux_g);
                    aux_check >>= 1;
                }
                continue;
            }
            for (h = 0; h < numbit_plan; ++h) {
                aux_g = aux_check & 1;
                gen_new = (long)((double)gen_new + Math.pow(2.0, h + ir * numbit_plan) * (double)aux_g);
                aux_check >>= 1;
            }
        }
        System.out.println("Nuevo Gen :" + gen_new);
        return gen_new;
    }

    public long getBestGene() {
        this.best = 0;
        double bestFit = this.population[this.best].getFitness();
        for (int i = 1; i < this.popSize; ++i) {
            double currFit = this.population[i].getFitness();
            if (!(currFit > bestFit)) continue;
            this.best = i;
            bestFit = this.population[this.best].getFitness();
        }
        long bestGenes = this.population[this.best].getGenes();
        return bestGenes;
    }

    public double getBestAnswer() {
        int best = 0;
        double bestFit = this.population[best].getFitness();
        for (int i = 1; i < this.popSize; ++i) {
            double currFit = this.population[i].getFitness();
            if (!(currFit > bestFit)) continue;
            best = i;
            bestFit = currFit;
        }
        double bestAns = this.population[best].getAnswer();
        return bestAns;
    }

    public void printPopulation() {
        for (int i = 0; i < this.popSize; ++i) {
            this.population[i].print(this.xGeneCount);
            System.out.println();
        }
    }
}

