/*
 * Decompiled with CFR 0.152.
 */
package de.core;

import de.core.DeepEdit;
import de.core.GISFrame;
import de.utils.Utils;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

class GISTFrame
extends Frame
implements KeyListener,
ActionListener {
    protected Font TextDialogFont;
    protected FontMetrics TextDialogFontMetrics;
    DeepEdit applet;
    GISFrame gf;
    Checkbox Centroids;
    Checkbox Nodes;
    Checkbox Arcs;
    Button button1;
    Button button2;

    public GISTFrame(GISFrame ggf, DeepEdit aapplet) {
        super("Transport GIS Parameters");
        this.setBackground(Color.lightGray);
        this.setLocation(300, 365);
        this.applet = aapplet;
        this.gf = ggf;
        this.TextDialogFont = new Font("TimesRoman", 0, 10);
        this.TextDialogFontMetrics = this.getFontMetrics(this.TextDialogFont);
        this.setFont(this.TextDialogFont);
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        this.setLayout(gridbag);
        c.fill = 0;
        c.weightx = 1.0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.anchor = 10;
        c.gridwidth = 0;
        Utils.makeLabel((Frame)this, "TRANSPORT NETWORK GIS OPTIONS", gridbag, c, Color.blue);
        c.gridwidth = 6;
        c.gridx = -1;
        c.weightx = 0.0;
        c.gridwidth = 0;
        Utils.makeLabel(this, " ", gridbag, c);
        c.gridwidth = 6;
        c.anchor = 17;
        Utils.makeLabel(this, " ", gridbag, c);
        Utils.makeLabel(this, "Centroids", gridbag, c);
        this.Centroids = Utils.makeCheckbox(this, "", gridbag, c, Utils.get_State(this.applet.GISDL, 10));
        Utils.makeLabel(this, " ", gridbag, c);
        c.gridwidth = 0;
        Utils.makeLabel(this, " ", gridbag, c);
        c.gridwidth = 6;
        c.anchor = 17;
        Utils.makeLabel(this, " ", gridbag, c);
        Utils.makeLabel(this, "Nodes", gridbag, c);
        this.Nodes = Utils.makeCheckbox(this, "", gridbag, c, Utils.get_State(this.applet.GISDL, 11));
        Utils.makeLabel(this, " ", gridbag, c);
        c.gridwidth = 0;
        Utils.makeLabel(this, " ", gridbag, c);
        c.gridwidth = 6;
        c.anchor = 17;
        Utils.makeLabel(this, " ", gridbag, c);
        Utils.makeLabel(this, "Arcs", gridbag, c);
        this.Arcs = Utils.makeCheckbox(this, "", gridbag, c, Utils.get_State(this.applet.GISDL, 12));
        Utils.makeLabel(this, " ", gridbag, c);
        Utils.makeLabel(this, " ", gridbag, c);
        c.gridwidth = 0;
        Utils.makeLabel(this, " ", gridbag, c);
        c.gridwidth = 6;
        c.anchor = 17;
        Utils.makeLabel(this, " ", gridbag, c);
        Utils.makeLabel(this, " ", gridbag, c);
        c.gridwidth = 0;
        Utils.makeLabel(this, " ", gridbag, c);
        c.anchor = 10;
        c.gridwidth = 6;
        Utils.makeLabel(this, " ", gridbag, c);
        Utils.makeLabel(this, " ", gridbag, c);
        Utils.makeLabel(this, " ", gridbag, c);
        Button button1 = new Button("OK");
        button1.setActionCommand("OK");
        button1.addActionListener(this);
        gridbag.setConstraints(button1, c);
        this.add(button1);
        Utils.makeLabel(this, " ", gridbag, c);
        Utils.makeLabel(this, " ", gridbag, c);
        Button button2 = new Button("Cancel");
        button2.setActionCommand("Cancel");
        button2.addActionListener(this);
        gridbag.setConstraints(button2, c);
        this.add(button2);
        c.gridwidth = 0;
        Utils.makeLabel(this, " ", gridbag, c);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent event) {
                GISTFrame.this.setVisible(false);
                GISTFrame.this.applet.UserWantsGIS(false);
            }
        });
        this.setIconImage(this.applet.getFrameIconImage());
        this.pack();
        this.setVisible(true);
    }

    @Override
    public void keyPressed(KeyEvent event) {
        if (event.getKeyCode() == 27) {
            this.setVisible(false);
            this.applet.UserWantsGIS(false);
        }
    }

    @Override
    public void keyReleased(KeyEvent event) {
    }

    @Override
    public void keyTyped(KeyEvent event) {
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        Object obj = ev.getSource();
        String label = ev.getActionCommand();
        if (obj instanceof Button) {
            if (label.equals("Cancel")) {
                this.setVisible(false);
            } else if (label.equals("OK")) {
                this.applet.GISDL = this.Centroids.getState() ? Utils.replaceIntPosition(this.applet.GISDL, 10, 1.0) : Utils.replaceIntPosition(this.applet.GISDL, 10, 0.0);
                this.applet.GISDL = this.Nodes.getState() ? Utils.replaceIntPosition(this.applet.GISDL, 11, 1.0) : Utils.replaceIntPosition(this.applet.GISDL, 11, 0.0);
                this.applet.GISDL = this.Arcs.getState() ? Utils.replaceIntPosition(this.applet.GISDL, 12, 1.0) : Utils.replaceIntPosition(this.applet.GISDL, 12, 0.0);
                DeepEdit.MySchematic.changeGIS = true;
                if (this.applet.MyGIS != null) {
                    this.applet.MyGIS.canvasMap.repaint();
                }
                this.repaint();
                this.setVisible(false);
            }
        }
    }
}

