/*
 * Decompiled with CFR 0.152.
 */
package de.core;

import de.core.CFuzzytri;
import drasys.or.linear.algebra.Algebra;
import drasys.or.matrix.DenseMatrix;
import drasys.or.matrix.MatrixI;

public class FuzzyLinearSystem2 {
    Algebra al;
    DenseMatrix s;
    DenseMatrix invs;
    DenseMatrix p;
    DenseMatrix xres;
    int n = 0;

    public static void main(String[] args) {
        new FuzzyLinearSystem2();
    }

    public void creaS(double[][] b) {
        this.n = b.length;
        this.s = new DenseMatrix(2 * this.n, 2 * this.n);
        for (int i = 0; i < this.n; ++i) {
            for (int j = 0; j < b.length; ++j) {
                if (b[i][j] > 0.0) {
                    this.s.setElementAt(i, j, b[i][j]);
                    this.s.setElementAt(i + this.n, j + this.n, b[i][j]);
                    continue;
                }
                this.s.setElementAt(i + this.n, j, -b[i][j]);
                this.s.setElementAt(i, j + this.n, -b[i][j]);
            }
        }
    }

    public void creaVector(double[][] PP) {
        this.p = new DenseMatrix(2 * this.n, 2);
        for (int i = 0; i < this.n; ++i) {
            CFuzzytri temp = new CFuzzytri(PP[i][0], PP[i][1], PP[i][2]);
            this.p.setElementAt(i, 0, temp.getn1());
            this.p.setElementAt(i, 1, temp.getm1());
            this.p.setElementAt(i + this.n, 0, -temp.getn2());
            this.p.setElementAt(i + this.n, 1, -temp.getm2());
        }
    }

    public double[][] solveSystem(double[][] bb, double[][] pp) {
        this.creaS(bb);
        this.creaVector(pp);
        this.al = new Algebra();
        double[][] res = new double[this.n][3];
        this.invs = new DenseMatrix(2 * this.n, 2 * this.n);
        try {
            this.invs = this.al.invert((MatrixI)this.s);
            this.xres = new DenseMatrix(2 * this.n, 2);
            this.xres = this.al.multiply((MatrixI)this.invs, (MatrixI)this.p);
        }
        catch (Exception e) {
            // empty catch block
        }
        for (int i = 0; i < this.n; ++i) {
            CFuzzytri temp = this.xres.elementAt(i, 1) >= 0.0 && -this.xres.elementAt(i + this.n, 1) < 0.0 ? new CFuzzytri(this.xres.elementAt(i, 0), this.xres.elementAt(i, 1), -this.xres.elementAt(i + this.n, 0), -this.xres.elementAt(i + this.n, 1), 1.0) : new CFuzzytri(-this.xres.elementAt(i + this.n, 0), -this.xres.elementAt(i + this.n, 1), this.xres.elementAt(i, 0), this.xres.elementAt(i, 1), 1.0);
            res[i][0] = temp.a;
            res[i][1] = temp.b;
            res[i][2] = temp.c;
        }
        return res;
    }
}

