/*
 * Decompiled with CFR 0.152.
 */
package de.core;

import de.core.DeepEdit;
import de.core.Example;
import de.core.SimpleDialog;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Event;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.List;
import java.awt.Panel;
import java.io.DataInputStream;
import java.io.StringBufferInputStream;
import java.util.Vector;

class ExamplesFrame
extends Frame {
    DeepEdit applet;
    Choice c;
    List l;
    Vector ExamplesVector;
    String WaitMessage = "Please wait, loading available examples.";

    public ExamplesFrame(DeepEdit app) {
        super("DeepEdit examples");
        this.applet = app;
        Button OKButton = new Button("OK");
        Button CancelButton = new Button("Cancel");
        OKButton.setEnabled(false);
        this.ExamplesVector = new Vector();
        this.setBackground(Color.lightGray);
        Panel p1 = new Panel();
        p1.setLayout(new FlowLayout());
        this.c = new Choice();
        this.c.addItem("all");
        p1.add(this.c);
        p1.add(OKButton);
        p1.add(CancelButton);
        Panel p2 = new Panel();
        p2.setLayout(new GridLayout(0, 1));
        this.l = new List(10, false);
        this.l.addItem(this.WaitMessage);
        p2.add(this.l);
        this.setLayout(new BorderLayout());
        this.add("North", p2);
        this.add("South", p1);
        this.pack();
        this.setVisible(true);
        this.LoadExamples();
        this.ShowCategorys();
        if (this.c.countItems() > 0) {
            this.ShowExamples(this.c.getItem(0));
        }
        this.l.select(0);
        OKButton.enable();
        p1.layout();
        this.setIconImage(app.getFrameIconImage());
    }

    public void ShowExamples(String Category2) {
        if (this.ExamplesVector.size() == 0) {
            return;
        }
        this.l.delItems(0, this.l.countItems() - 1);
        for (int ix = 0; ix < this.ExamplesVector.size(); ++ix) {
            Example TempExample = (Example)this.ExamplesVector.elementAt(ix);
            if (!Category2.equals(TempExample.getType()) && !Category2.equals("all")) continue;
            this.l.addItem(TempExample.getDescription());
        }
    }

    public void ShowCategorys() {
        if (this.ExamplesVector.size() == 0) {
            return;
        }
        for (int ix = 0; ix < this.ExamplesVector.size(); ++ix) {
            Example TempExample = (Example)this.ExamplesVector.elementAt(ix);
            boolean exist = false;
            for (int cl = 0; cl < this.c.countItems(); ++cl) {
                if (!this.c.getItem(cl).equals(TempExample.getType())) continue;
                exist = true;
            }
            if (exist) continue;
            this.c.addItem(TempExample.getType());
        }
    }

    public void LoadExamples() {
        String ExampleType = null;
        String ExampleDescription = null;
        String ExampleLocation = null;
        while (this.applet.TextFileRequested != null) {
            try {
                Thread.currentThread();
                Thread.sleep(250L);
            }
            catch (Exception e) {}
        }
        this.applet.RequestedTextFileRead = false;
        this.applet.RequestedTextFileError = false;
        this.applet.TextFileRequested = "examples/description.txt";
        this.setVisible(true);
        do {
            try {
                Thread.currentThread();
                Thread.sleep(250L);
            }
            catch (Exception e) {
                // empty catch block
            }
        } while (!this.applet.RequestedTextFileRead && !this.applet.RequestedTextFileError);
        if (this.applet.RequestedText == null || this.applet.RequestedTextFileError) {
            this.applet.TextFileRequested = null;
            String[] DlgButtons = new String[]{"OK"};
            String message = "Can't read file examples/description.txt";
            SimpleDialog ExceptionDialog = new SimpleDialog(DeepEdit.frame, "Loading examples", message, DlgButtons, 1, 0, 0, 1);
            return;
        }
        String PlainText = this.applet.RequestedText;
        this.applet.TextFileRequested = null;
        StringBufferInputStream sis = new StringBufferInputStream(PlainText);
        DataInputStream dis = new DataInputStream(sis);
        do {
            try {
                ExampleType = null;
                ExampleDescription = null;
                ExampleLocation = null;
                ExampleType = dis.readLine();
                if (ExampleType != null) {
                    ExampleDescription = dis.readLine();
                }
                if (ExampleType != null && ExampleDescription != null) {
                    ExampleLocation = dis.readLine();
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            if (ExampleType == null || ExampleDescription == null || ExampleLocation == null) continue;
            Example NewExample = new Example(ExampleType, ExampleDescription, ExampleLocation);
            this.ExamplesVector.addElement(NewExample);
        } while (ExampleType != null && ExampleDescription != null && ExampleLocation != null);
    }

    @Override
    public boolean handleEvent(Event ev) {
        if (ev.id == 201) {
            this.setVisible(false);
            this.applet.MyExamplesFrame = null;
            return true;
        }
        return super.handleEvent(ev);
    }

    public String getFileName(String example) {
        for (int ix = 0; ix < this.ExamplesVector.size(); ++ix) {
            Example TempExample = (Example)this.ExamplesVector.elementAt(ix);
            if (!example.equals(TempExample.getDescription())) continue;
            return TempExample.getLocation();
        }
        return null;
    }

    @Override
    public boolean action(Event ev, Object arg) {
        if (ev.target instanceof Button) {
            String label = (String)arg;
            if (label.equals("Cancel")) {
                this.setVisible(false);
                this.applet.MyExamplesFrame = null;
                return true;
            }
            if (label.equals("OK")) {
                int s = this.l.getSelectedIndex();
                if (s == -1) {
                    return true;
                }
                String FileName = this.getFileName(this.l.getSelectedItem());
                this.setVisible(false);
                this.applet.UserWantsOpenExample(FileName);
                this.applet.MyExamplesFrame = null;
                return true;
            }
        } else {
            if (ev.target instanceof Choice) {
                this.ShowExamples((String)arg);
                return true;
            }
            if (ev.target instanceof List) {
                if (this.WaitMessage.equals((String)arg)) {
                    return true;
                }
                String FileName = this.getFileName((String)arg);
                this.setVisible(false);
                this.applet.UserWantsOpenExample(FileName);
                this.applet.MyExamplesFrame = null;
                return true;
            }
        }
        return false;
    }
}

