/*
 * Decompiled with CFR 0.152.
 */
package de.core;

import JSci.maths.Complex;
import JSci.maths.matrices.AbstractComplexMatrix;
import JSci.maths.matrices.ComplexMatrix;
import JSci.maths.matrices.ComplexSquareMatrix;
import JSci.maths.vectors.AbstractComplexVector;
import JSci.maths.vectors.ComplexVector;
import de.core.AnalysisTool;
import de.core.Busbar;
import de.core.DeepEdit;
import de.core.EquivalentsFrame;
import de.core.Line;
import de.core.Load;
import de.core.Schematic;
import de.core.SimpleDialog;
import de.core.Trafo;
import de.core.comp;
import de.core.ndb_branch;
import de.core.ndb_inj;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.Vector;

public class Equivalents
extends AnalysisTool {
    EquivalentsFrame MyEquivalentsFrame = null;
    String ctrla = null;
    ComplexMatrix MatYBB;
    ComplexVector I;
    ComplexVector IB;
    ComplexVector IB1;
    ComplexVector IE;
    ComplexVector V;
    ComplexVector VB;
    ComplexVector SB;
    ComplexVector SB1;
    ComplexVector SB2;
    ComplexMatrix MatYBE;
    ComplexMatrix MatYIB;
    ComplexMatrix MatYII;
    ComplexMatrix MatYEB;
    ComplexSquareMatrix MatYEE;
    ComplexMatrix MatYBEEE;
    ComplexMatrix MatYBEEB;
    ComplexMatrix MatY;
    int numi = 0;
    int numb = 0;
    int nume = 0;
    protected Vector BusbarVectorI;
    protected Vector BusbarVectorB;
    protected Vector BusbarVectorE;
    int numbran = 0;
    double[] BranchR;
    double[] BranchX;
    double[] BranchB;
    double[] node_p;
    double[] node_pl;
    double[] node_pg;
    int[] BranchI;
    int[] BranchJ;
    int[] VarNode;
    boolean rep = true;

    public Equivalents(Schematic sch) {
        super(sch);
        System.out.println("---------- In Equivalent Calculation Tool ------------");
        if (this.MyEquivalentsFrame == null) {
            this.MyEquivalentsFrame = new EquivalentsFrame(this);
        } else {
            this.MyEquivalentsFrame.setVisible(true);
        }
    }

    public void Calculate(String cctrla, boolean sino, int modelo, boolean reporte) {
        FileOutputStream osYII;
        FileOutputStream osYIB;
        FileOutputStream osY;
        FileOutputStream osI;
        FileOutputStream osB;
        FileOutputStream os;
        this.ctrla = cctrla;
        String YBBmat = WORK_FOLDER + File.separator + "ward.dat";
        String BMod = "./results/EqBML.dat";
        String IMod = "./results/EqIML.dat";
        String YBBMod = "./results/EqYBBML.dat";
        String YIBMod = "./results/EqYIBML.dat";
        String YIIMod = "./results/EqYIIML.dat";
        this.rep = reporte;
        try {
            AnalysisTool.CreateDirectory(WORK_FOLDER);
            os = new FileOutputStream(YBBmat);
            osB = new FileOutputStream(BMod);
            osI = new FileOutputStream(IMod);
            osY = new FileOutputStream(YBBMod);
            osYIB = new FileOutputStream(YIBMod);
            osYII = new FileOutputStream(YIIMod);
            this.InitNetwork(os, osB, osI, osY, osYIB, osYII);
            os.close();
            osB.close();
            osI.close();
            osY.close();
            osYIB.close();
            osYII.close();
        }
        catch (Exception e) {
            String message = e.toString();
            String[] DlgButtons = new String[]{"OK"};
            SimpleDialog ExceptionDialog = new SimpleDialog(DeepEdit.frame, "Equivalents", message, DlgButtons, 1, 0, 0, 1);
            return;
        }
        try {
            if (os != null) {
                os.close();
            }
            if (osB != null) {
                osB.close();
            }
            if (osI != null) {
                osI.close();
            }
            if (osY != null) {
                osY.close();
            }
            if (osYIB != null) {
                osYIB.close();
            }
            if (osYII != null) {
                osYII.close();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        this.DoListResults(YBBmat);
        if (this.rep) {
            this.DoListResults("./results/EqBML.dat");
            this.DoListResults("./results/EqIML.dat");
            this.DoListResults("./results/EqYBBML.dat");
            this.DoListResults("./results/EqYIBML.dat");
            this.DoListResults("./results/EqYIIML.dat");
        }
    }

    public void InitNetwork(FileOutputStream os, FileOutputStream osB, FileOutputStream osI, FileOutputStream osY, FileOutputStream osYIB, FileOutputStream osYII) {
        Complex auxc2;
        Complex auxc1;
        Line TempLine;
        comp TempComponent;
        PrintStream myPrintStream = new PrintStream(os);
        PrintStream myPrintB = new PrintStream(osB);
        PrintStream myPrintI = new PrintStream(osI);
        PrintStream myPrintY = new PrintStream(osY);
        PrintStream myPrintYIB = new PrintStream(osYIB);
        PrintStream myPrintYII = new PrintStream(osYII);
        myPrintStream.println("Datos, System Name:  " + this.ActSchematic.getsysname());
        int ix = 0;
        int i = 0;
        int j = 0;
        int count = 0;
        boolean count1 = false;
        this.BusbarVectorI = new Vector();
        this.BusbarVectorB = new Vector();
        this.BusbarVectorE = new Vector();
        double ueb = 0.0;
        double res = 0.0;
        double z = 0.0;
        double reac = 0.0;
        double yy = 0.0;
        double y1 = 0.0;
        double y2 = 0.0;
        double b = 0.0;
        for (ix = 0; ix < this.ActSchematic.Components.size(); ++ix) {
            TempComponent = (comp)this.ActSchematic.Components.elementAt(ix);
            if (!TempComponent.getactive() || !TempComponent.getvalid() || !TempComponent.getinservice()) continue;
            if (TempComponent instanceof Busbar) {
                TempComponent.InformAllComponents();
                Busbar TempBusbar = (Busbar)TempComponent;
                ++this.numnod;
                if (TempBusbar.getctrla().equals("I")) {
                    myPrintStream.println(this.numnod + "\t" + TempComponent.getName() + "\t" + TempBusbar.getctrla() + "\t" + "Barra Interna");
                    myPrintI.println(TempComponent.getName());
                    ++this.numi;
                    this.BusbarVectorI.addElement(TempComponent);
                } else if (TempBusbar.getctrla().equals("B")) {
                    myPrintStream.println(this.numnod + "\t" + TempComponent.getName() + "\t" + TempBusbar.getctrla() + "\t" + "Barra Lim\u0081\u00edtrofe");
                    myPrintB.println(TempComponent.getName());
                    ++this.numb;
                    this.BusbarVectorB.addElement(TempComponent);
                } else if (TempBusbar.getctrla().equals("E")) {
                    myPrintStream.println(this.numnod + "\t" + TempComponent.getName() + "\t" + TempBusbar.getctrla() + "\t" + "Barra Externa");
                    ++this.nume;
                    this.BusbarVectorE.addElement(TempComponent);
                } else {
                    myPrintStream.println(this.numnod + "\t" + TempComponent.getName() + "\t" + TempBusbar.getctrla() + "\t" + "Error: Barra no asignada!!");
                    return;
                }
            }
            if (TempComponent instanceof ndb_branch) {
                if (TempComponent instanceof Line) {
                    TempLine = (Line)TempComponent;
                    TempLine.InformPartner(TempLine.ConnComps1, TempLine.getx1(), TempLine.gety1(), 1);
                    TempLine.InformPartner(TempLine.ConnComps2, TempLine.getx2(), TempLine.gety2(), 2);
                    ++this.numlin;
                }
                if (TempComponent instanceof Trafo) {
                    TempComponent.InformAllComponents();
                    ++this.numtran;
                }
                ++this.numbran;
            }
            if (TempComponent instanceof ndb_inj) {
                TempComponent.InformAllComponents();
                ++this.numgen;
            }
            if (!(TempComponent instanceof Load)) continue;
            TempComponent.InformAllComponents();
            ++this.numload;
        }
        System.out.println("numnod = " + this.numnod);
        System.out.println("numbran= " + this.numbran);
        System.out.println("numlin = " + this.numlin);
        System.out.println("numtran= " + this.numtran);
        System.out.println("numload= " + this.numload);
        this.BranchR = new double[this.numbran];
        this.BranchX = new double[this.numbran];
        this.BranchB = new double[this.numbran];
        this.BranchI = new int[this.numbran];
        this.BranchJ = new int[this.numbran];
        this.node_p = new double[this.numnod];
        this.node_pl = new double[this.numnod];
        this.node_pg = new double[this.numnod];
        this.MatY = new ComplexMatrix(this.numnod, this.numnod);
        this.I = new ComplexVector(this.numnod);
        this.IB = new ComplexVector(this.numb);
        this.IB1 = new ComplexVector(this.numb);
        this.VB = new ComplexVector(this.numb);
        this.SB = new ComplexVector(this.numb);
        this.SB1 = new ComplexVector(this.numb);
        this.SB2 = new ComplexVector(this.numnod);
        this.IE = new ComplexVector(this.nume);
        this.V = new ComplexVector(this.numnod);
        this.MatYBB = new ComplexMatrix(this.numb, this.numb);
        this.MatYBE = new ComplexMatrix(this.numb, this.nume);
        this.MatYEB = new ComplexMatrix(this.nume, this.numb);
        this.MatYIB = new ComplexMatrix(this.numi, this.numb);
        this.MatYII = new ComplexMatrix(this.numi, this.numi);
        this.MatYEE = new ComplexSquareMatrix(this.nume);
        this.MatYBEEE = new ComplexMatrix(this.numb, this.nume);
        this.MatYBEEB = new ComplexMatrix(this.numb, this.numb);
        for (i = 0; i < this.numnod; ++i) {
            for (j = 0; j < this.numnod; ++j) {
                this.MatY.setElement(i, j, new Complex(0.0, 0.0));
            }
        }
        for (ix = 0; ix < this.ActSchematic.Components.size(); ++ix) {
            TempComponent = (comp)this.ActSchematic.Components.elementAt(ix);
            if (!TempComponent.getactive() || !TempComponent.getvalid() || !TempComponent.getinservice()) continue;
            if (TempComponent instanceof Line) {
                TempLine = (Line)TempComponent;
                this.BranchX[count] = TempLine.getxx1() * TempLine.getlen() * this.getSref() / (TempLine.getun1() * TempLine.getun1());
                this.BranchR[count] = TempLine.getr1() * TempLine.getlen() * this.getSref() / (TempLine.getun1() * TempLine.getun1());
                if (this.BranchX[count] < 1.0E-4) {
                    myPrintStream.println("Line " + TempComponent.getName() + "Problema en Valor de X: " + this.BranchX[count]);
                }
                this.BranchB[count] = TempLine.getb1() * TempLine.getlen() / 2.0 / this.getSref() * (TempLine.getun1() * TempLine.getun1());
                this.BranchI[count] = this.numbus(TempLine.getcon1());
                this.BranchJ[count] = this.numbus(TempLine.getcon2());
                auxc1 = new Complex(this.BranchR[count], this.BranchX[count]);
                auxc2 = new Complex(1.0, 0.0);
                auxc1 = auxc2.divide(auxc1);
                auxc2 = new Complex(0.0, this.BranchB[count]);
                System.out.println("auxc1 " + auxc1.toString());
                System.out.println("auxc2 " + auxc2.toString());
                System.out.println("branchi " + this.BranchI[count]);
                System.out.println("branchj " + this.BranchJ[count]);
                this.MatY.setElement(this.BranchJ[count], this.BranchI[count], this.MatY.getElement(this.BranchJ[count], this.BranchI[count]).subtract(auxc1));
                this.MatY.setElement(this.BranchI[count], this.BranchJ[count], this.MatY.getElement(this.BranchI[count], this.BranchJ[count]).subtract(auxc1));
                this.MatY.setElement(this.BranchI[count], this.BranchI[count], this.MatY.getElement(this.BranchI[count], this.BranchI[count]).add(auxc1.add(auxc2)));
                this.MatY.setElement(this.BranchJ[count], this.BranchJ[count], this.MatY.getElement(this.BranchJ[count], this.BranchJ[count]).add(auxc1.add(auxc2)));
                ++count;
            }
            if (!(TempComponent instanceof Trafo)) continue;
            Trafo TempTrafo = (Trafo)TempComponent;
            TempTrafo.actualizet();
            ueb = TempTrafo.getun1() / TempTrafo.getun2() / (TempTrafo.getur1() / TempTrafo.getur2());
            res = TempTrafo.getpcu() * 0.001 * ueb * ueb / TempTrafo.getsn() * this.getSref() / TempTrafo.getsn();
            z = TempTrafo.getuk() * 0.01 * ueb * ueb * this.getSref() / TempTrafo.getsn();
            b = TempTrafo.geti0() * 0.01 * 0.5 / this.getSref() * TempTrafo.getsn();
            reac = TempTrafo.getuk() >= 0.0 ? Math.sqrt(z * z - res * res) : -Math.sqrt(z * z - res * res);
            this.BranchX[count] = reac;
            if (this.BranchX[count] < 1.0E-4) {
                myPrintStream.println("Trafo " + TempComponent.getName() + "Problema en Valor de X: " + this.BranchX[count]);
            }
            this.BranchR[count] = res;
            this.BranchB[count] = b;
            this.BranchI[count] = this.numbus(TempTrafo.getcon1());
            this.BranchJ[count] = this.numbus(TempTrafo.getcon2());
            auxc1 = new Complex(this.BranchR[count], this.BranchX[count]);
            auxc2 = new Complex(1.0, 0.0);
            auxc1 = auxc2.divide(auxc1);
            auxc2 = new Complex(0.0, this.BranchB[count]);
            this.MatY.setElement(this.BranchJ[count], this.BranchI[count], this.MatY.getElement(this.BranchJ[count], this.BranchI[count]).subtract(auxc1.divide(TempTrafo.gett_re())));
            this.MatY.setElement(this.BranchI[count], this.BranchJ[count], this.MatY.getElement(this.BranchI[count], this.BranchJ[count]).subtract(auxc1.divide(TempTrafo.gett_re())));
            this.MatY.setElement(this.BranchI[count], this.BranchI[count], this.MatY.getElement(this.BranchI[count], this.BranchI[count]).add(auxc1.add(auxc2).divide(TempTrafo.gett_re() * TempTrafo.gett_re())));
            this.MatY.setElement(this.BranchJ[count], this.BranchJ[count], this.MatY.getElement(this.BranchJ[count], this.BranchJ[count]).add(auxc1.add(auxc2)));
            ++count;
        }
        System.out.println("Fin armado matriz Y");
        myPrintStream.println("------------------------------------------------");
        myPrintStream.println("Matriz de admitancia Y (pu)");
        if (this.numb + this.numi <= 40) {
            Equivalents.printMatrix(myPrintStream, this.MatY, this.numnod, this.numnod);
        }
        myPrintStream.println("------------------------------------------------");
        this.assignvoltages();
        this.printBuses(myPrintStream);
        this.I = (ComplexVector)this.MatY.multiply((AbstractComplexVector)this.V);
        for (i = this.numi; i < this.numi + this.numb; ++i) {
            this.IB.setComponent(i - this.numi, this.I.getComponent(i));
        }
        for (i = this.numi + this.numb; i < this.numnod; ++i) {
            this.IE.setComponent(i - this.numi - this.numb, this.I.getComponent(i));
        }
        for (i = this.numi; i < this.numi + this.numb; ++i) {
            for (j = this.numi; j < this.numi + this.numb; ++j) {
                this.MatYBB.setElement(i - this.numi, j - this.numi, this.MatY.getElement(i, j));
            }
        }
        System.out.println("Fin armado matriz YBB");
        for (i = 0; i < this.numi; ++i) {
            for (j = this.numi; j < this.numi + this.numb; ++j) {
                this.MatYIB.setElement(i, j - this.numi, this.MatY.getElement(i, j));
            }
        }
        System.out.println("Fin armado matriz YIB");
        for (i = 0; i < this.numi; ++i) {
            for (j = 0; j < this.numi; ++j) {
                this.MatYII.setElement(i, j - this.numi, this.MatY.getElement(i, j));
            }
        }
        System.out.println("Fin armado matriz YII");
        for (i = this.numi; i < this.numi + this.numb; ++i) {
            for (j = this.numi + this.numb; j < this.numnod; ++j) {
                this.MatYBE.setElement(i - this.numi, j - this.numi - this.numb, this.MatY.getElement(i, j));
            }
        }
        System.out.println("Fin armado matriz YBE");
        for (i = this.numi + this.numb; i < this.numnod; ++i) {
            for (j = this.numi; j < this.numi + this.numb; ++j) {
                this.MatYEB.setElement(i - this.numi - this.numb, j - this.numi, this.MatY.getElement(i, j));
            }
        }
        System.out.println("Fin armado matriz YEB");
        for (i = this.numi + this.numb; i < this.numnod; ++i) {
            for (j = this.numi + this.numb; j < this.numnod; ++j) {
                this.MatYEE.setElement(i - this.numi - this.numb, j - this.numi - this.numb, this.MatY.getElement(i, j));
            }
        }
        System.out.println("Fin armado matriz YEE");
        myPrintStream.println("------------------------------------------------");
        myPrintStream.println("Matriz YBB (pu)");
        if (this.numb + this.numi <= 40) {
            Equivalents.printMatrix(myPrintStream, this.MatYBB, this.numb, this.numb);
        }
        System.out.println("Fin Escritura YBB");
        myPrintStream.println("------------------------------------------------");
        myPrintStream.println("Matriz inversa YEE-1 (pu)");
        try {
            this.MatYEE = (ComplexSquareMatrix)this.MatYEE.inverse();
            System.out.println("Fin Inversa YEE");
            if (this.numb + this.numi <= 40) {
                Equivalents.printSquareMatrix(myPrintStream, this.MatYEE, this.nume);
            }
            this.MatYBEEE = (ComplexMatrix)this.MatYBE.multiply((AbstractComplexMatrix)this.MatYEE);
            System.out.println("Fin Calculo YBEEE");
            this.MatYBEEB = (ComplexMatrix)this.MatYBEEE.multiply(this.MatYEB);
            System.out.println("Fin C\u00e1lculo YEB");
            this.MatYBB = this.MatYBB.subtract(this.MatYBEEB);
            System.out.println("Fin C\u00e1lculo YBEEB");
            myPrintStream.println("------------------------------------------------");
            myPrintStream.println("Nueva Matriz YBB' (pu) !!!!");
            System.out.println("Nueva Matriz YBB' (pu) !!!!");
            if (this.numb + this.numi <= 40) {
                Equivalents.printMatrix(myPrintStream, this.MatYBB, this.numb, this.numb);
            }
            myPrintStream.println("------------------------------------------------");
            myPrintStream.println("Vector de corrientes (I) (pu)!!!!");
            Equivalents.printVector(myPrintStream, this.I, this.numnod);
            myPrintStream.println("------------------------------------------------");
            myPrintStream.println("Potencias netas iniciales en nodos (V*I*) (pu)!!!!");
            for (i = 0; i < this.numnod; ++i) {
                this.SB2.setComponent(i, this.V.getComponent(i).multiply(this.I.getComponent(i).conjugate()));
            }
            Equivalents.printVector(myPrintStream, this.SB2, this.numnod);
            myPrintStream.println("------------------------------------------------");
            myPrintStream.println("Vector de corrientes en sistema externo (IE) (pu) !!!!");
            Equivalents.printVector(myPrintStream, this.IE, this.nume);
            myPrintStream.println("------------------------------------------------");
            myPrintStream.println("Nuevo Vector de Corrientes IB' (IB'=IB-YBE*YEE-1*IE) (pu)!!!!");
            this.IB1 = (ComplexVector)this.IB.subtract(this.MatYBEEE.multiply((AbstractComplexVector)this.IE));
            Equivalents.printVector(myPrintStream, this.IB1, this.numb);
            myPrintStream.println("------------------------------------------------");
            myPrintStream.println("Potencias netas iniciales nodos limitrofes VB*IB* (pu)!!!!");
            for (i = 0; i < this.numb; ++i) {
                this.SB.setComponent(i, this.VB.getComponent(i).multiply(this.IB.getComponent(i).conjugate()));
            }
            Equivalents.printVector(myPrintStream, this.SB, this.numb);
            myPrintStream.println("------------------------------------------------");
            myPrintStream.println("Potencias netas nuevas en nodos limitrofes VB*IB'* (pu)!!!!");
            for (i = 0; i < this.numb; ++i) {
                this.SB1.setComponent(i, this.VB.getComponent(i).multiply(this.IB1.getComponent(i).conjugate()));
            }
            Equivalents.printVector(myPrintStream, this.SB1, this.numb);
            myPrintStream.println("------------------------------------------------");
            myPrintStream.println("Nuevas potencias que deben restarse en nodos limitrofes VB*IB*-VB*IB'* (pu)!!!!");
            Equivalents.printVector(myPrintStream, this.SB.subtract(this.SB1), this.numb);
            if (this.numb == 2) {
                myPrintStream.println("---------------------------------------------------------------------");
                myPrintStream.println("SALIDA PARA CASO ESPECIAL NUMERO NODOS FRONTERA =2 (valores en pu)");
                auxc2 = new Complex(-1.0, 0.0);
                auxc1 = auxc2.divide(this.MatYBB.getElement(0, 1));
                myPrintStream.println("Z12= " + auxc1);
                auxc1 = this.MatYBB.getElement(0, 1).add(this.MatYBB.getElement(0, 0));
                auxc2 = this.MatYBB.getElement(1, 0).add(this.MatYBB.getElement(1, 1));
                myPrintStream.println("Comparaci\u0081\u00f3n del grado de asimetr\u0081\u00eda");
                myPrintStream.println("B00= " + auxc1);
                myPrintStream.println("B11= " + auxc2);
                myPrintStream.println("Se desprecia parte real -->");
                myPrintStream.println("B00= " + auxc1.imag());
                myPrintStream.println("B11= " + auxc2.imag());
                double auxr1 = Math.min(auxc1.imag(), auxc2.imag());
                myPrintStream.println("B/2= " + auxr1);
                myPrintStream.println("B  = " + auxr1 * 2.0);
                myPrintStream.println("Compensaci\u0081\u00f3n pu (supone voltaje nominal)= " + (Math.max(auxc1.imag(), auxc2.imag()) - auxr1));
                myPrintStream.println("------------------------------------------------");
            }
            myPrintStream.println("---------------------------------------------------------------------");
            myPrintStream.println("SALIDA NUEVA MATRIZ BOUNDARY YBB");
            this.printMatrixNameYBB(myPrintStream, this.MatYBB, this.numb, this.numb);
            myPrintStream.println("---------------------------------------------------------------------");
            myPrintStream.println("SALIDA DE MATRIZ YII");
            this.printMatrixNameYII(myPrintStream, this.MatY, this.numi, this.numi);
            myPrintStream.println("---------------------------------------------------------------------");
            myPrintStream.println("SALIDA DE MATRIZ YIB");
            this.printMatrixNameYIB(myPrintStream, this.MatY, this.numi, this.numb);
            if (this.rep) {
                Complex auxcc2;
                Complex auxcc;
                for (i = this.numi; i < this.numi + this.numb; ++i) {
                    for (j = this.numi; j < this.numi + this.numb; ++j) {
                        auxcc = this.MatYBB.getElement(i - this.numi, j - this.numi);
                        auxcc2 = (Complex)auxcc.inverse();
                        if (!(auxcc2.imag() * auxcc2.imag() < 100.0)) continue;
                        if (i == this.numi && j == this.numi) {
                            myPrintY.print(" " + auxcc);
                            continue;
                        }
                        if (i > this.numi && j == this.numi) {
                            myPrintY.print(" " + auxcc);
                            continue;
                        }
                        if (i >= this.numi && j > this.numi && j < this.numi + this.numb - 1) {
                            myPrintY.print(" " + auxcc);
                            continue;
                        }
                        if (i < this.numi + this.numb - 1 && j == this.numi + this.numb - 1) {
                            myPrintY.println(" " + auxcc + " ");
                            continue;
                        }
                        if (i != this.numi + this.numb - 1 || j != this.numi + this.numb - 1) continue;
                        myPrintY.print(" " + auxcc + " ");
                    }
                }
                for (i = 0; i < this.numi; ++i) {
                    for (j = 0; j < this.numb; ++j) {
                        auxcc = this.MatYIB.getElement(i, j);
                        auxcc2 = (Complex)auxcc.inverse();
                        if (!(auxcc2.imag() * auxcc2.imag() < 100.0)) continue;
                        if (i == 0 && j == 0) {
                            myPrintYIB.print(" " + auxcc);
                            continue;
                        }
                        if (i > 0 && j == 0) {
                            myPrintYIB.print(" " + auxcc);
                            continue;
                        }
                        if (i >= 0 && j > 0 && j < this.numb - 1) {
                            myPrintYIB.print(" " + auxcc);
                            continue;
                        }
                        if (i < this.numi - 1 && j == this.numb - 1) {
                            myPrintYIB.println(" " + auxcc + " ");
                            continue;
                        }
                        if (i != this.numi - 1 || j != this.numb - 1) continue;
                        myPrintYIB.print(" " + auxcc + " ");
                    }
                }
                for (i = 0; i < this.numi; ++i) {
                    for (j = 0; j < this.numi; ++j) {
                        auxcc = this.MatYII.getElement(i, j);
                        auxcc2 = (Complex)auxcc.inverse();
                        if (!(auxcc2.imag() * auxcc2.imag() < 100.0)) continue;
                        if (i == 0 && j == 0) {
                            myPrintYII.print(" " + auxcc);
                            continue;
                        }
                        if (i > 0 && j == 0) {
                            myPrintYII.print(" " + auxcc);
                            continue;
                        }
                        if (i >= 0 && j > 0 && j < this.numi - 1) {
                            myPrintYII.print(" " + auxcc);
                            continue;
                        }
                        if (i < this.numi - 1 && j == this.numi - 1) {
                            myPrintYII.println(" " + auxcc + " ");
                            continue;
                        }
                        if (i != this.numi - 1 || j != this.numi - 1) continue;
                        myPrintYII.print(" " + auxcc + " ");
                    }
                }
            }
        }
        catch (Exception e) {
            System.err.println("Error processing Matrix: " + e);
        }
    }

    public static void printMatrix(PrintStream myPrintStream, ComplexMatrix m, int ii, int jj) {
        for (int i = 0; i < ii; ++i) {
            for (int j = 0; j < jj; ++j) {
                myPrintStream.print(m.getElement(i, j) + "\t");
            }
            myPrintStream.println();
        }
        myPrintStream.println();
    }

    public static void printSquareMatrix(PrintStream myPrintStream, ComplexSquareMatrix m, int ii) {
        for (int i = 0; i < ii; ++i) {
            for (int j = 0; j < ii; ++j) {
                myPrintStream.print(m.getElement(i, j) + "\t");
            }
            myPrintStream.println();
        }
        myPrintStream.println();
    }

    public void printMatrixNameYBB(PrintStream myPrintStream, ComplexMatrix m, int ii, int jj) {
        for (int i = 0; i < ii; ++i) {
            comp TempComponent = (comp)this.BusbarVectorB.elementAt(i);
            myPrintStream.println("---------------------------------------------------------");
            myPrintStream.println(" BARRA: " + TempComponent.getName());
            for (int j = 0; j < jj; ++j) {
                TempComponent = (comp)this.BusbarVectorB.elementAt(j);
                Complex auxc2 = new Complex(-1.0, 0.0);
                Complex auxc1 = auxc2.divide(m.getElement(i, j));
                if (m.getElement(i, j).real() != 0.0 || m.getElement(i, j).imag() != 0.0) {
                    myPrintStream.println("---> " + TempComponent.getName() + " \t yij= " + m.getElement(i, j) + "\t Zij= " + auxc1);
                }
                if (!(auxc1.real() < 0.0) && !(auxc1.imag() < 0.0) || i == j) continue;
                myPrintStream.println("---> XXXXXXXXXXX POSIBLE ERROR XXXXXXXXXXX");
            }
        }
        myPrintStream.println();
    }

    public void printMatrixNameYII(PrintStream myPrintStream, ComplexMatrix m, int ii, int jj) {
        for (int i = 0; i < ii; ++i) {
            comp TempComponent = (comp)this.BusbarVectorI.elementAt(i);
            myPrintStream.println("---------------------------------------------------------");
            myPrintStream.println(" BARRA: " + TempComponent.getName());
            for (int j = 0; j < jj; ++j) {
                TempComponent = (comp)this.BusbarVectorI.elementAt(j);
                Complex auxc2 = new Complex(-1.0, 0.0);
                Complex auxc1 = auxc2.divide(m.getElement(i, j));
                if (m.getElement(i, j).real() != 0.0 || m.getElement(i, j).imag() != 0.0) {
                    myPrintStream.println("---> " + TempComponent.getName() + " \t yij= " + m.getElement(i, j) + "\t Zij= " + auxc1);
                }
                if (!(auxc1.real() < 0.0) && !(auxc1.imag() < 0.0) || i == j) continue;
                myPrintStream.println("---> XXXXXXXXXXX POSIBLE ERROR XXXXXXXXXXX");
            }
        }
        myPrintStream.println();
    }

    public void printMatrixNameYIB(PrintStream myPrintStream, ComplexMatrix m, int ii, int jj) {
        for (int i = 0; i < ii; ++i) {
            comp TempComponent = (comp)this.BusbarVectorI.elementAt(i);
            myPrintStream.println("---------------------------------------------------------");
            myPrintStream.println(" BARRA: " + TempComponent.getName());
            for (int j = ii; j < jj + ii; ++j) {
                TempComponent = (comp)this.BusbarVectorB.elementAt(j - ii);
                Complex auxc2 = new Complex(-1.0, 0.0);
                Complex auxc1 = auxc2.divide(m.getElement(i, j));
                if (m.getElement(i, j).real() != 0.0 || m.getElement(i, j).imag() != 0.0) {
                    myPrintStream.println("---> " + TempComponent.getName() + " \t yij= " + m.getElement(i, j) + "\t Zij= " + auxc1);
                }
                if (!(auxc1.real() < 0.0) && !(auxc1.imag() < 0.0) || i == j) continue;
                myPrintStream.println("---> XXXXXXXXXXX POSIBLE ERROR XXXXXXXXXXX");
            }
        }
        myPrintStream.println();
    }

    public static void printVector(PrintStream myPrintStream, ComplexVector v, int ii) {
        for (int i = 0; i < ii; ++i) {
            myPrintStream.print(i + "\t" + v.getComponent(i) + "\t");
            myPrintStream.println();
        }
        myPrintStream.println();
    }

    public int numbus(String Busbarname) {
        comp TempComponent;
        int ix;
        int ixx = 0;
        for (ix = 0; ix < this.BusbarVectorI.size(); ++ix) {
            ++ixx;
            TempComponent = (comp)this.BusbarVectorI.elementAt(ix);
            if (TempComponent.getName().hashCode() != Busbarname.hashCode() || !TempComponent.getName().equals(Busbarname)) continue;
            return ixx - 1;
        }
        for (ix = 0; ix < this.BusbarVectorB.size(); ++ix) {
            ++ixx;
            TempComponent = (comp)this.BusbarVectorB.elementAt(ix);
            if (TempComponent.getName().hashCode() != Busbarname.hashCode() || !TempComponent.getName().equals(Busbarname)) continue;
            return ixx - 1;
        }
        for (ix = 0; ix < this.BusbarVectorE.size(); ++ix) {
            ++ixx;
            TempComponent = (comp)this.BusbarVectorE.elementAt(ix);
            if (TempComponent.getName().hashCode() != Busbarname.hashCode() || !TempComponent.getName().equals(Busbarname)) continue;
            return ixx - 1;
        }
        System.out.println(" No Busbar name found !! (" + Busbarname + ")");
        return 0;
    }

    public void assignvoltages() {
        Busbar TempBusbar;
        comp TempComponent;
        int ix;
        int ixx = 0;
        for (ix = 0; ix < this.BusbarVectorI.size(); ++ix) {
            ++ixx;
            TempComponent = (comp)this.BusbarVectorI.elementAt(ix);
            if (!(TempComponent instanceof Busbar)) continue;
            TempBusbar = (Busbar)TempComponent;
            this.V.setComponent(ixx - 1, new Complex(TempBusbar.getun2() / TempBusbar.getun1() * Math.cos(TempBusbar.getdelta2() / 180.0 * Math.PI), TempBusbar.getun2() / TempBusbar.getun1() * Math.sin(TempBusbar.getdelta2() / 180.0 * Math.PI)));
        }
        for (ix = 0; ix < this.BusbarVectorB.size(); ++ix) {
            ++ixx;
            TempComponent = (comp)this.BusbarVectorB.elementAt(ix);
            if (!(TempComponent instanceof Busbar)) continue;
            TempBusbar = (Busbar)TempComponent;
            this.V.setComponent(ixx - 1, new Complex(TempBusbar.getun2() / TempBusbar.getun1() * Math.cos(TempBusbar.getdelta2() / 180.0 * Math.PI), TempBusbar.getun2() / TempBusbar.getun1() * Math.sin(TempBusbar.getdelta2() / 180.0 * Math.PI)));
            this.VB.setComponent(ix, this.V.getComponent(ixx - 1));
        }
        for (ix = 0; ix < this.BusbarVectorE.size(); ++ix) {
            ++ixx;
            TempComponent = (comp)this.BusbarVectorE.elementAt(ix);
            if (!(TempComponent instanceof Busbar)) continue;
            TempBusbar = (Busbar)TempComponent;
            this.V.setComponent(ixx - 1, new Complex(TempBusbar.getun2() / TempBusbar.getun1() * Math.cos(TempBusbar.getdelta2() / 180.0 * Math.PI), TempBusbar.getun2() / TempBusbar.getun1() * Math.sin(TempBusbar.getdelta2() / 180.0 * Math.PI)));
        }
    }

    public void printBuses(PrintStream myPrintStream) {
        Busbar TempBusbar;
        comp TempComponent;
        int ix;
        int ixx = 0;
        myPrintStream.println("-------------------------------");
        myPrintStream.println("ORDEN SUPUESTO PARA LAS BARRAS ");
        myPrintStream.println("-------------------------------");
        myPrintStream.println("# \t Tipo \t Nombre \t Voltaje \t Voltage pu");
        for (ix = 0; ix < this.BusbarVectorI.size(); ++ix) {
            ++ixx;
            TempComponent = (comp)this.BusbarVectorI.elementAt(ix);
            if (!(TempComponent instanceof Busbar)) continue;
            TempBusbar = (Busbar)TempComponent;
            myPrintStream.println(ixx + "\t Internal \t" + TempBusbar.getName() + "\t" + TempBusbar.getun2() + "\t \t angulo " + TempBusbar.getdelta2() + "\t \t  |V|pu " + TempBusbar.getun2() / TempBusbar.getun1());
        }
        for (ix = 0; ix < this.BusbarVectorB.size(); ++ix) {
            ++ixx;
            TempComponent = (comp)this.BusbarVectorB.elementAt(ix);
            if (!(TempComponent instanceof Busbar)) continue;
            TempBusbar = (Busbar)TempComponent;
            myPrintStream.println(ixx + "\t Boundary \t" + TempBusbar.getName() + "\t" + TempBusbar.getun2() + "\t  \t angulo " + TempBusbar.getdelta2() + "\t  \t |V|pu " + TempBusbar.getun2() / TempBusbar.getun1());
        }
        for (ix = 0; ix < this.BusbarVectorE.size(); ++ix) {
            ++ixx;
            TempComponent = (comp)this.BusbarVectorE.elementAt(ix);
            if (!(TempComponent instanceof Busbar)) continue;
            TempBusbar = (Busbar)TempComponent;
            myPrintStream.println(ixx + "\t External \t" + TempBusbar.getName() + "\t" + TempBusbar.getun2() + "\t  \t angulo " + TempBusbar.getdelta2() + "\t  \t |V|pu " + TempBusbar.getun2() / TempBusbar.getun1());
        }
    }
}

