/*
 * Decompiled with CFR 0.152.
 */
package de.core;

import de.core.DeepEdit;
import de.core.ECD;
import de.core.SimpleDialog;
import de.utils.Utils;
import java.awt.Button;
import java.awt.Color;
import java.awt.Event;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;

class ECDOptionsFrame
extends Frame {
    ECD appl;
    int tiposimula;
    protected Font TextDialogFont;
    protected FontMetrics TextDialogFontMetrics;

    public ECDOptionsFrame(ECD app) {
        super("DeepEdit Economic Dispatch Options");
        this.appl = app;
        this.setBackground(Color.lightGray);
        this.tiposimula = this.appl.ActSchematic.gettiposimula();
        this.TextDialogFont = DeepEdit.TextFont;
        this.TextDialogFontMetrics = this.getFontMetrics(this.TextDialogFont);
        this.setFont(this.TextDialogFont);
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        this.setLayout(gridbag);
        c.fill = 0;
        c.weightx = 1.0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.anchor = 10;
        c.gridwidth = 0;
        Utils.makeLabel((Frame)this, "Run a constrained economic dispatch without losses?", gridbag, c, Color.blue);
        c.gridx = -1;
        c.weightx = 0.0;
        c.gridwidth = 0;
        Utils.makeLabel(this, " ", gridbag, c);
        c.anchor = 10;
        c.gridwidth = 4;
        Utils.makeButton(this, "OK", gridbag, c);
        c.gridwidth = 0;
        Utils.makeButton(this, "Cancel", gridbag, c);
        this.pack();
        this.setVisible(true);
    }

    @Override
    public boolean handleEvent(Event ev) {
        if (ev.id == 201) {
            this.setVisible(false);
            this.appl.MyECDOptionsFrame = null;
            return true;
        }
        return super.handleEvent(ev);
    }

    public void SetNewValues() {
        try {
            this.appl.ActSchematic.settiposimula(0);
        }
        catch (Exception e) {
            String message = e.toString();
            String[] DlgButtons = new String[]{"OK"};
            SimpleDialog ExceptionDialog = new SimpleDialog(DeepEdit.frame, "Reading ECD information", message, DlgButtons, 1, 0, 0, 1);
        }
        this.repaint();
    }

    @Override
    public boolean action(Event ev, Object arg) {
        if (ev.target instanceof Button) {
            String label = (String)arg;
            if (arg.equals("Cancel")) {
                this.setVisible(false);
                this.appl.MyECDOptionsFrame = null;
                return true;
            }
            if (arg.equals("OK")) {
                this.SetNewValues();
                this.setVisible(false);
                DeepEdit.MySchematicPanel.repaint();
                this.appl.Calculate(true);
                this.appl.MyECDOptionsFrame = null;
                return true;
            }
        }
        return false;
    }
}

