/*
 * Decompiled with CFR 0.152.
 */
package de.core;

import de.core.AnalysisTool;
import de.core.Busbar;
import de.core.DeepEdit;
import de.core.EBDGFrame;
import de.core.EBGrafFrame;
import de.core.Generator;
import de.core.GeneratorCHP;
import de.core.GeneratorDG;
import de.core.GeneratorEO;
import de.core.GeneratorPV;
import de.core.Load;
import de.core.Schematic;
import de.core.SimpleDialog;
import de.core.ZFileViewer;
import de.core.comp;
import de.core.mdb_cont;
import de.core.mdb_cust;
import de.core.mdb_sup;
import de.core.mdb_wheel;
import de.core.ndb_1pol;
import de.utils.StringUtil;
import java.awt.Font;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Vector;

public class EBDG
extends AnalysisTool {
    private int numbus = 0;
    private int numgen = 0;
    private int numPgen = 0;
    private int numload = 0;
    private int numcontract = 0;
    private int numsup = 0;
    private int numcust = 0;
    private comp[][] contract;
    double[] Pot_Cont;
    int FirstMonth;
    int FirstDay;
    int FirstHour;
    int TotNumMonths;
    int TotNumDays;
    int TotNumHours;
    int From_dispatch;
    int EBmonth;
    int EBday;
    int EBhour;
    int EBtype;
    protected Vector BusbarVectorI;
    String[][] GenName;
    double[][][] GenSales;
    double[][][] GenPurch;
    double[][][] GenBalance;
    String[][] P_GenName;
    double[][][] P_GenSales;
    double[][][] P_GenPurch;
    double[][][] P_GenBalance;
    String[] GenCoName;
    double[][][] GenCoSales;
    double[][][] GenCoPurch;
    double[][][] GenCoBalance;
    String[] LoadName;
    double[][][] LoadDemand;
    String[] DisCoName;
    double[][][] DisCoDemand;
    double[][][] DisCo_DG;
    double[] DisCo_K;
    double[][] Busbar_Penalty;
    double[][][] Spot_Price;
    double[][][] Generation;
    double[][][] PG_Generation;
    double[] Total_Balance;
    double[][] Transf_Matrix;
    String[] GenCo_Pos;
    String[] GenCo_Neg;
    private String Archivo = "./results/EBResult.csv";
    Connection DBEnBal;
    Statement stmt;
    String query;
    ResultSet rs;
    DeepEdit deepEdApp;
    ZFileViewer MyZFileViewer;
    EBDGFrame MyEBDGFrame;
    EBGrafFrame MyEBGrafFrame;
    private FileOutputStream os = null;
    private boolean permiso = false;

    public EBDG(DeepEdit deep, Schematic sch) {
        super(sch);
        this.deepEdApp = deep;
        this.BusbarVectorI = new Vector();
        System.out.println("---------- In  E B D G  Calculation Tool ----------");
        if (this.MyEBDGFrame == null) {
            this.MyEBDGFrame = new EBDGFrame(this.deepEdApp, this);
        } else {
            this.MyEBDGFrame.setVisible(true);
        }
    }

    public Connection OpenDataBase(String DBName, String user, String password) throws SQLException {
        try {
            Class.forName("sun.jdbc.odbc.JdbcOdbcDriver");
        }
        catch (Exception e) {
            String message = e.toString();
            System.out.println("Error: en Connection OpenDatabase " + message);
            return null;
        }
        String dsn = "jdbc:odbc:" + DBName;
        return DriverManager.getConnection(dsn, user, password);
    }

    public void Calculate(int Month, int Day, int Hour, boolean showgraf, boolean showtext, boolean savedb, int Simtype) throws Exception {
        this.EBmonth = Month + 1;
        this.EBday = Day + 1;
        this.EBhour = Hour + 1;
        this.EBtype = Simtype;
        System.out.println("");
        System.out.println("");
        System.out.println("");
        System.out.println("");
        System.out.println("-------------------------------------------");
        if (this.EBtype == 0) {
            System.out.println("Balance de Energia Horario");
        }
        if (this.EBtype == 1) {
            System.out.println("Balance de Energia Mensual");
        }
        if (this.EBtype == 2) {
            System.out.println("Balance de Energia Horario a partir de despacho");
        }
        System.out.println("-------------------------------------------");
        System.out.println("");
        this.GenName = null;
        this.GenSales = null;
        this.GenPurch = null;
        this.GenBalance = null;
        this.P_GenName = null;
        this.P_GenSales = null;
        this.P_GenPurch = null;
        this.P_GenBalance = null;
        this.GenCoName = null;
        this.GenCoSales = null;
        this.GenCoPurch = null;
        this.GenCoBalance = null;
        this.LoadName = null;
        this.LoadDemand = null;
        this.DisCoName = null;
        this.DisCoDemand = null;
        this.Spot_Price = null;
        this.Generation = null;
        this.contract = null;
        this.numbus = 0;
        this.numgen = 0;
        this.numPgen = 0;
        this.numload = 0;
        this.numcontract = 0;
        this.numsup = 0;
        this.numcust = 0;
        try {
            this.EnergyBalance();
            System.out.println("");
            System.out.println("* Fin Calculo Balances");
            System.out.println("");
            System.out.println("-------------------------------------------");
            System.out.println("----------------- - o - -------------------");
            System.out.println("-------------------------------------------");
            System.out.println("");
            DeepEdit.MySchematicPanel.repaint();
            this.permiso = true;
            if (showtext) {
                this.ShowTextResult();
            }
            if (savedb) {
                this.SaveInDataBase();
            }
            if (showgraf) {
                this.ShowGraf();
            }
        }
        catch (Exception e) {
            String message = e.toString();
            String[] DlgButtons = new String[]{"OK"};
            SimpleDialog ExceptionDialog = new SimpleDialog(DeepEdit.frame, "EBDG", message, DlgButtons, 1, 0, 0, 1);
            e.printStackTrace();
            return;
        }
    }

    public void EnergyBalance() {
        int j;
        int k;
        int i;
        comp TempComponent;
        if (this.EBtype == 0) {
            this.FirstDay = this.EBday;
            this.FirstHour = this.EBhour;
            this.TotNumDays = 1;
            this.TotNumHours = 1;
            this.From_dispatch = 0;
        } else if (this.EBtype == 1) {
            this.FirstDay = 1;
            this.FirstHour = 1;
            this.TotNumDays = this.MonthDays(this.EBmonth);
            this.TotNumHours = 24;
            this.From_dispatch = 0;
        } else {
            this.FirstDay = 1;
            this.FirstHour = 1;
            this.TotNumDays = 1;
            this.TotNumHours = 1;
            this.From_dispatch = 1;
        }
        System.out.println("");
        if (this.EBtype != 1) {
            System.out.println("Dia \t:\t" + this.FirstDay);
        }
        System.out.println("Mes \t:\t" + this.MonthName(this.EBmonth, "es"));
        if (this.EBtype != 1) {
            System.out.println("Hora\t:\t" + this.EBhour + ":00");
        }
        System.out.println("");
        System.out.println("-------------------------------------------");
        for (int ix = 0; ix < this.ActSchematic.Components.size(); ++ix) {
            TempComponent = (comp)this.ActSchematic.Components.elementAt(ix);
            if (TempComponent instanceof Busbar) {
                TempComponent.InformAllComponents();
                this.BusbarVectorI.addElement(TempComponent);
                ++this.numbus;
                continue;
            }
            if (TempComponent instanceof Load) {
                TempComponent.InformAllComponents();
                ++this.numload;
                continue;
            }
            if (TempComponent instanceof GeneratorCHP || TempComponent instanceof GeneratorEO || TempComponent instanceof GeneratorPV || TempComponent instanceof GeneratorDG) {
                TempComponent.InformAllComponents();
                ++this.numPgen;
                continue;
            }
            if (TempComponent instanceof Generator) {
                TempComponent.InformAllComponents();
                String con = TempComponent.getcon2();
                ++this.numgen;
                continue;
            }
            if (TempComponent instanceof mdb_cont) {
                ++this.numcontract;
                continue;
            }
            if (TempComponent instanceof mdb_sup) {
                ++this.numsup;
                continue;
            }
            if (!(TempComponent instanceof mdb_cust)) continue;
            ++this.numcust;
        }
        System.out.println("");
        System.out.println("Numero de Barras               :" + this.numbus);
        System.out.println("Numero de Consumos             :" + this.numload);
        System.out.println("Numero de Generadores          :" + this.numgen);
        System.out.println("Numero de Pequenos Generadores :" + this.numPgen);
        System.out.println("Numero de Distribuidoras       :" + this.numcust);
        System.out.println("Numero de Empresas Generadoras :" + this.numsup);
        System.out.println("Contratos                      :" + this.numcontract);
        System.out.println("");
        this.GenName = new String[this.numgen][2];
        this.GenSales = new double[this.numgen][this.TotNumHours][this.TotNumDays];
        this.GenPurch = new double[this.numgen][this.TotNumHours][this.TotNumDays];
        this.GenBalance = new double[this.numgen][this.TotNumHours][this.TotNumDays];
        this.P_GenName = new String[this.numPgen][2];
        this.P_GenSales = new double[this.numPgen][this.TotNumHours][this.TotNumDays];
        this.P_GenPurch = new double[this.numPgen][this.TotNumHours][this.TotNumDays];
        this.P_GenBalance = new double[this.numPgen][this.TotNumHours][this.TotNumDays];
        this.GenCoName = new String[this.numsup + 1];
        this.GenCoSales = new double[this.numsup][this.TotNumHours][this.TotNumDays];
        this.GenCoPurch = new double[this.numsup][this.TotNumHours][this.TotNumDays];
        this.GenCoBalance = new double[this.numsup][this.TotNumHours][this.TotNumDays];
        this.Busbar_Penalty = new double[this.numbus][2];
        this.LoadName = new String[this.numload];
        this.LoadDemand = new double[this.numload][this.TotNumHours][this.TotNumDays];
        this.DisCoName = new String[this.numcust];
        this.DisCoDemand = new double[this.numcust][this.TotNumHours][this.TotNumDays];
        this.DisCo_DG = new double[this.numcust][this.TotNumHours][this.TotNumDays];
        this.DisCo_K = new double[this.numcust];
        this.contract = new comp[this.numcontract][3];
        this.Pot_Cont = new double[this.numcontract];
        this.Total_Balance = new double[this.numsup + 1];
        System.out.println("");
        System.out.println("-------------------------------------------");
        System.out.println("===\t\tContratos\t\t===");
        System.out.println("-------------------------------------------");
        System.out.println("");
        System.out.println("Generador\t-\tConsumo");
        System.out.println("");
        int countwheel = 0;
        int countgen = 0;
        int countload = 0;
        int countPgen = 0;
        int countGenco = 0;
        int countDisco = 0;
        for (int ix = 0; ix < this.ActSchematic.Components.size(); ++ix) {
            TempComponent = (comp)this.ActSchematic.Components.elementAt(ix);
            if (TempComponent instanceof mdb_wheel) {
                mdb_wheel TempContract = (mdb_wheel)TempComponent;
                this.deepEdApp.SimulateSetUpOnePoint(TempContract.getx1(), TempContract.gety1());
                this.deepEdApp.SimulateSetUpOnePoint(TempContract.getx2(), TempContract.gety2());
                TempContract.InformPartner(TempContract.ConnComps1, TempContract.getx1(), TempContract.gety1(), 1);
                TempContract.InformPartner(TempContract.ConnComps2, TempContract.getx2(), TempContract.gety2(), 2);
                if (TempContract.getparty1() instanceof Generator) {
                    this.contract[countwheel][0] = TempContract;
                    this.contract[countwheel][1] = TempContract.getparty1();
                    this.contract[countwheel][2] = TempContract.getparty2();
                    System.out.println(this.contract[countwheel][1].getName() + " (" + this.contract[countwheel][1].getinv_owner() + ")\t-\t" + this.contract[countwheel][2].getName() + " (" + this.contract[countwheel][2].getinv_owner() + ")");
                    ++countwheel;
                    continue;
                }
                if (!(TempContract.getparty1() instanceof Load)) continue;
                this.contract[countwheel][0] = TempContract;
                this.contract[countwheel][1] = TempContract.getparty2();
                this.contract[countwheel][2] = TempContract.getparty1();
                System.out.println(this.contract[countwheel][1].getName() + " (" + this.contract[countwheel][1].getinv_owner() + ")\t-\t" + this.contract[countwheel][2].getName() + " (" + this.contract[countwheel][2].getinv_owner() + ")");
                ++countwheel;
                continue;
            }
            if (TempComponent instanceof mdb_sup) {
                this.GenCoName[countGenco] = TempComponent.getName();
                ++countGenco;
                continue;
            }
            if (TempComponent instanceof mdb_cust) {
                this.DisCoName[countDisco] = TempComponent.getName();
                ++countDisco;
                continue;
            }
            if (TempComponent instanceof GeneratorCHP || TempComponent instanceof GeneratorEO || TempComponent instanceof GeneratorPV || TempComponent instanceof GeneratorDG) {
                this.P_GenName[countPgen][0] = TempComponent.getName();
                this.P_GenName[countPgen][1] = TempComponent.getinv_owner();
                ++countPgen;
                continue;
            }
            if (TempComponent instanceof Generator) {
                this.GenName[countgen][0] = TempComponent.getName();
                this.GenName[countgen][1] = TempComponent.getinv_owner();
                ++countgen;
                continue;
            }
            if (!(TempComponent instanceof Load)) continue;
            this.LoadName[countload] = TempComponent.getName();
            ++countload;
        }
        System.out.println("");
        System.out.println("-------------------------------------------");
        countgen = 0;
        countload = 0;
        countPgen = 0;
        if (this.From_dispatch == 0) {
            this.Spot_Price = new double[this.numbus][this.TotNumHours][this.TotNumDays];
            this.Generation = new double[this.numgen][this.TotNumHours][this.TotNumDays];
            if (this.numPgen != 0) {
                this.PG_Generation = new double[this.numPgen][this.TotNumHours][this.TotNumDays];
            }
            System.out.println("");
            System.out.println("* Cargando informacion de Base de Datos... ");
            System.out.println("");
            if (this.EBtype == 0) {
                this.LoadMeasures(this.EBmonth, this.EBday, 1, this.EBhour, 1);
            } else {
                this.LoadMeasures(this.EBmonth, 1, this.TotNumDays, 1, 24);
            }
        }
        System.out.println("* Calculando Balances...");
        System.out.println("");
        double SpotP = 0.0;
        double pot_con = 1.0;
        double fp_PG = 1.0;
        double fp_SubTx = 1.0;
        double Inv_SubTx = 0.0;
        double factor_K = 0.0;
        double Piny = 0.0;
        for (int d = this.FirstDay; d < this.FirstDay + this.TotNumDays; ++d) {
            for (int h = this.FirstHour; h < this.FirstHour + this.TotNumHours; ++h) {
                int j2;
                int k2;
                String Ctrl_Area;
                Generator TempGenerator;
                int ix;
                countgen = 0;
                countload = 0;
                countPgen = 0;
                if (this.From_dispatch == 0) {
                    this.SetValues(h, d);
                }
                for (ix = 0; ix < this.ActSchematic.Components.size(); ++ix) {
                    TempComponent = (comp)this.ActSchematic.Components.elementAt(ix);
                    if (TempComponent instanceof GeneratorCHP || TempComponent instanceof GeneratorEO || TempComponent instanceof GeneratorPV || TempComponent instanceof GeneratorDG) {
                        TempGenerator = (Generator)TempComponent;
                        Ctrl_Area = ((ndb_1pol)this.BusbarVectorI.elementAt(this.numbus(TempGenerator.getcon2()))).getctrla();
                        for (k2 = 0; k2 < this.numcust; ++k2) {
                            if (!Ctrl_Area.equals(this.DisCoName[k2])) continue;
                            double[] dArray = this.DisCo_DG[k2][h - this.FirstHour];
                            int n = d - this.FirstDay;
                            dArray[n] = dArray[n] + TempGenerator.getp();
                        }
                        ++countPgen;
                        continue;
                    }
                    if (TempComponent instanceof Generator) {
                        TempGenerator = (Generator)TempComponent;
                        SpotP = ((ndb_1pol)this.BusbarVectorI.elementAt(this.numbus(TempGenerator.getcon2()))).getspot_p();
                        this.GenSales[countgen][h - this.FirstHour][d - this.FirstDay] = TempGenerator.getp() * SpotP;
                        for (int i2 = 0; i2 < this.numcontract; ++i2) {
                            if (!this.contract[i2][1].getName().equals(TempGenerator.getName())) continue;
                            if (this.From_dispatch == 0) {
                                pot_con = ((mdb_wheel)this.contract[i2][0]).getpcontract();
                            }
                            SpotP = ((ndb_1pol)this.BusbarVectorI.elementAt(this.numbus(this.contract[i2][2].getcon2()))).getspot_p();
                            double[] dArray = this.GenPurch[countgen][h - this.FirstHour];
                            int n = d - this.FirstDay;
                            dArray[n] = dArray[n] + ((Load)this.contract[i2][2]).getp() * SpotP * pot_con;
                        }
                        for (j2 = 0; j2 < this.numsup; ++j2) {
                            if (!TempGenerator.getinv_owner().equals(this.GenCoName[j2])) continue;
                            double[] dArray = this.GenCoSales[j2][h - this.FirstHour];
                            int n = d - this.FirstDay;
                            dArray[n] = dArray[n] + this.GenSales[countgen][h - this.FirstHour][d - this.FirstDay];
                            double[] dArray2 = this.GenCoPurch[j2][h - this.FirstHour];
                            int n2 = d - this.FirstDay;
                            dArray2[n2] = dArray2[n2] + this.GenPurch[countgen][h - this.FirstHour][d - this.FirstDay];
                        }
                        ++countgen;
                        continue;
                    }
                    if (!(TempComponent instanceof Load)) continue;
                    Load TempLoad = (Load)TempComponent;
                    this.LoadDemand[countload][h - this.FirstHour][d - this.FirstDay] = TempLoad.getp0();
                    for (k2 = 0; k2 < this.numcust; ++k2) {
                        if (!TempLoad.getinv_owner().equals(this.DisCoName[k2])) continue;
                        double[] dArray = this.DisCoDemand[k2][h - this.FirstHour];
                        int n = d - this.FirstDay;
                        dArray[n] = dArray[n] + this.LoadDemand[countload][h - this.FirstHour][d - this.FirstDay];
                    }
                    ++countload;
                }
                countPgen = 0;
                for (ix = 0; ix < this.ActSchematic.Components.size(); ++ix) {
                    TempComponent = (comp)this.ActSchematic.Components.elementAt(ix);
                    if (!(TempComponent instanceof GeneratorCHP) && !(TempComponent instanceof GeneratorEO) && !(TempComponent instanceof GeneratorPV) && !(TempComponent instanceof GeneratorDG)) continue;
                    TempGenerator = (Generator)TempComponent;
                    SpotP = ((ndb_1pol)this.BusbarVectorI.elementAt(this.numbus(TempGenerator.getcon2()))).getspot_p();
                    Ctrl_Area = ((ndb_1pol)this.BusbarVectorI.elementAt(this.numbus(TempGenerator.getcon2()))).getctrla();
                    for (k2 = 0; k2 < this.numcust; ++k2) {
                        if (!Ctrl_Area.equals(this.DisCoName[k2])) continue;
                        if (this.From_dispatch == 0) {
                            factor_K = this.DisCo_K[k2];
                            fp_SubTx = this.Busbar_Penalty[this.numbus(TempGenerator.getcon2())][0];
                            Inv_SubTx = this.Busbar_Penalty[this.numbus(TempGenerator.getcon2())][1];
                        }
                        Piny = this.DisCoDemand[k2][h - this.FirstHour][d - this.FirstDay] - this.DisCo_DG[k2][h - this.FirstHour][d - this.FirstDay];
                        fp_PG = Math.sqrt(1.0 + 4.0 * factor_K * Piny);
                    }
                    this.P_GenSales[countPgen][h - this.FirstHour][d - this.FirstDay] = (SpotP * fp_SubTx * fp_PG + Inv_SubTx) * TempGenerator.getp();
                    this.P_GenPurch[countPgen][h - this.FirstHour][d - this.FirstDay] = 0.0;
                    this.P_GenBalance[countPgen][h - this.FirstHour][d - this.FirstDay] = this.P_GenSales[countPgen][h - this.FirstHour][d - this.FirstDay];
                    for (j2 = 0; j2 < this.numsup; ++j2) {
                        if (!TempGenerator.getinv_owner().equals(this.GenCoName[j2])) continue;
                        double[] dArray = this.GenCoSales[j2][h - this.FirstHour];
                        int n = d - this.FirstDay;
                        dArray[n] = dArray[n] + this.P_GenSales[countPgen][h - this.FirstHour][d - this.FirstDay];
                        double[] dArray3 = this.GenCoPurch[j2][h - this.FirstHour];
                        int n3 = d - this.FirstDay;
                        dArray3[n3] = dArray3[n3] + this.P_GenPurch[countPgen][h - this.FirstHour][d - this.FirstDay];
                    }
                    ++countPgen;
                }
            }
        }
        System.out.println("");
        System.out.println("");
        System.out.println("Balance Generadores:");
        System.out.println("");
        for (int i3 = 0; i3 < this.numgen; ++i3) {
            System.out.println("");
            System.out.println("Generador " + this.GenName[i3]);
            for (int k3 = 0; k3 < this.TotNumDays; ++k3) {
                for (int j3 = 0; j3 < this.TotNumHours; ++j3) {
                    System.out.println("Dia " + (k3 + 1) + " Hora " + (j3 + 1));
                    System.out.println("\tVentas: " + StringUtil.numformat(this.GenSales[i3][j3][0], 12, 3) + " [US$]");
                    System.out.println("\tCompras: " + StringUtil.numformat(this.GenPurch[i3][j3][0], 12, 3) + " [US$]");
                    this.GenBalance[i3][j3][k3] = this.GenSales[i3][j3][k3] - this.GenPurch[i3][j3][k3];
                    System.out.println("\tBalance: " + StringUtil.numformat(this.GenBalance[i3][j3][k3], 12, 3) + " [US$]");
                }
            }
        }
        System.out.println("");
        System.out.println("");
        System.out.println("Balance Total Empresas Generadoras:");
        System.out.println("");
        for (i = 0; i < this.numsup; ++i) {
            System.out.println("");
            System.out.println("Empresa :" + this.GenCoName[i]);
            System.out.println("");
            double totV = 0.0;
            double totC = 0.0;
            double totB = 0.0;
            for (k = 0; k < this.TotNumDays; ++k) {
                for (j = 0; j < this.TotNumHours; ++j) {
                    this.GenCoBalance[i][j][k] = this.GenCoSales[i][j][k] - this.GenCoPurch[i][j][k];
                    totB += this.GenCoBalance[i][j][k];
                    totV += this.GenCoSales[i][j][k];
                    totC += this.GenCoPurch[i][j][k];
                }
            }
            System.out.println("\tVentas \t\t\t: " + StringUtil.numformat(totV, 12, 3) + " [US$]");
            System.out.println("\tCompras\t\t\t: " + StringUtil.numformat(totC, 12, 3) + " [US$]");
            System.out.println("\tBalance\t\t\t: " + StringUtil.numformat(totB, 12, 3) + " [US$]");
            this.Total_Balance[i] = totB;
        }
        System.out.println("");
        System.out.println("");
        System.out.println("");
        System.out.println("");
        System.out.println("Empresas Distribuidoras:");
        System.out.println("");
        for (i = 0; i < this.numcust; ++i) {
            System.out.println("");
            System.out.println("Empresa :" + this.DisCoName[i]);
            System.out.println("");
            double totD = 0.0;
            double totPi = 0.0;
            double totPG = 0.0;
            for (k = 0; k < this.TotNumDays; ++k) {
                for (j = 0; j < this.TotNumHours; ++j) {
                    totD += this.DisCoDemand[i][j][k];
                    totPG += this.DisCo_DG[i][j][k];
                    totPi += this.DisCoDemand[i][j][k] - this.DisCo_DG[i][j][k];
                }
            }
            System.out.println("\tDemanda + Perdidas\t: " + StringUtil.numformat(totD, 12, 3) + " [MWh]");
            System.out.println("\tRetiros\t\t\t: " + StringUtil.numformat(totPi, 12, 3) + " [MWh]");
            System.out.println("\tGeneracion Distribuida\t: " + StringUtil.numformat(totPG, 12, 3) + " [MWh]");
        }
    }

    public int MonthDays(int mes) {
        if (mes == 1 || mes == 3 || mes == 5 || mes == 7 || mes == 8 || mes == 10 || mes == 12) {
            return 31;
        }
        if (mes == 4 || mes == 6 || mes == 9 || mes == 11) {
            return 30;
        }
        if (mes == 2) {
            return 28;
        }
        return 0;
    }

    public String MonthName(int mes, String lang) {
        String NombreMes = "";
        if (lang.equals("e")) {
            switch (mes) {
                case 1: {
                    NombreMes = "January";
                    break;
                }
                case 2: {
                    NombreMes = "February";
                    break;
                }
                case 3: {
                    NombreMes = "March";
                    break;
                }
                case 4: {
                    NombreMes = "April";
                    break;
                }
                case 5: {
                    NombreMes = "May";
                    break;
                }
                case 6: {
                    NombreMes = "June";
                    break;
                }
                case 7: {
                    NombreMes = "July";
                    break;
                }
                case 8: {
                    NombreMes = "August";
                    break;
                }
                case 9: {
                    NombreMes = "September";
                    break;
                }
                case 10: {
                    NombreMes = "October";
                    break;
                }
                case 11: {
                    NombreMes = "November";
                    break;
                }
                case 12: {
                    NombreMes = "December";
                }
            }
        } else {
            switch (mes) {
                case 1: {
                    NombreMes = "Enero";
                    break;
                }
                case 2: {
                    NombreMes = "Febrero";
                    break;
                }
                case 3: {
                    NombreMes = "Marzo";
                    break;
                }
                case 4: {
                    NombreMes = "Abril";
                    break;
                }
                case 5: {
                    NombreMes = "Mayo";
                    break;
                }
                case 6: {
                    NombreMes = "Junio";
                    break;
                }
                case 7: {
                    NombreMes = "Julio";
                    break;
                }
                case 8: {
                    NombreMes = "Agosto";
                    break;
                }
                case 9: {
                    NombreMes = "Septiembre";
                    break;
                }
                case 10: {
                    NombreMes = "Octubre";
                    break;
                }
                case 11: {
                    NombreMes = "Noviembre";
                    break;
                }
                case 12: {
                    NombreMes = "Deciembre";
                }
            }
        }
        return NombreMes;
    }

    public void SetValues(int hourr, int dayy) {
        int countg = 0;
        int countPg = 0;
        int countl = 0;
        int countb = 0;
        int countm = 0;
        for (int ix = 0; ix < this.ActSchematic.Components.size(); ++ix) {
            Generator TempG;
            comp TempC = (comp)this.ActSchematic.Components.elementAt(ix);
            if (TempC instanceof Load) {
                Load TempL = (Load)TempC;
                TempL.setp0(this.LoadDemand[countl][hourr - this.FirstHour][dayy - this.FirstDay]);
                TempL.setp(this.LoadDemand[countl][hourr - this.FirstHour][dayy - this.FirstDay]);
                ++countl;
                continue;
            }
            if (TempC instanceof Busbar) {
                Busbar TempB = (Busbar)TempC;
                TempB.setspot_p(this.Spot_Price[countb][hourr - this.FirstHour][dayy - this.FirstDay]);
                ++countb;
                continue;
            }
            if (TempC instanceof GeneratorCHP || TempC instanceof GeneratorEO || TempC instanceof GeneratorPV || TempC instanceof GeneratorDG) {
                TempG = (Generator)TempC;
                TempG.setp(this.PG_Generation[countPg][hourr - this.FirstHour][dayy - this.FirstDay]);
                TempG.setp0(this.PG_Generation[countPg][hourr - this.FirstHour][dayy - this.FirstDay]);
                ++countPg;
                continue;
            }
            if (TempC instanceof Generator) {
                TempG = (Generator)TempC;
                TempG.setp(this.Generation[countg][hourr - this.FirstHour][dayy - this.FirstDay]);
                TempG.setp0(this.Generation[countg][hourr - this.FirstHour][dayy - this.FirstDay]);
                ++countg;
                continue;
            }
            if (!(TempC instanceof mdb_wheel)) continue;
            mdb_wheel TempM = (mdb_wheel)TempC;
            TempM.setpcontract(this.Pot_Cont[countm]);
            ++countm;
        }
    }

    public void LoadMeasures(int Month, int InitialDay, int NumberOfDays, int InitialHours, int NumberOfHours) {
        int d = 0;
        try {
            this.DBEnBal = this.OpenDataBase("EBDG_DB", "", "");
            this.DBEnBal.setAutoCommit(true);
            this.stmt = this.DBEnBal.createStatement();
            boolean salir = false;
            String gen = "";
            for (int h = InitialHours; h < InitialHours + NumberOfHours; ++h) {
                for (int g = 0; g < this.numgen; ++g) {
                    salir = false;
                    this.query = "SELECT * FROM EB_Gen WHERE (Generador='" + this.GenName[g][0] + "') AND (Mes=" + Month + ") ORDER BY Dia";
                    this.rs = this.stmt.executeQuery(this.query);
                    while (this.rs.next() & !salir) {
                        d = this.rs.getInt("Dia");
                        if (this.EBtype != 1 && (this.EBtype == 1 || d != InitialDay)) continue;
                        this.Generation[g][h - InitialHours][d - InitialDay] = h < 10 ? this.rs.getDouble("H0" + h) : this.rs.getDouble("H" + h);
                        if (this.EBtype == 1) continue;
                        salir = true;
                    }
                }
                for (int l = 0; l < this.numload; ++l) {
                    salir = false;
                    this.query = "SELECT * FROM EB_Load WHERE (Consumo='" + this.LoadName[l] + "') AND (Mes=" + Month + ") ORDER BY Dia";
                    this.rs = this.stmt.executeQuery(this.query);
                    while (this.rs.next() & !salir) {
                        d = this.rs.getInt("Dia");
                        if (this.EBtype != 1 && (this.EBtype == 1 || d != InitialDay)) continue;
                        this.LoadDemand[l][h - InitialHours][d - InitialDay] = h < 10 ? this.rs.getDouble("H0" + h) : this.rs.getDouble("H" + h);
                        if (this.EBtype == 1) continue;
                        salir = true;
                    }
                }
                for (int b = 0; b < this.numbus; ++b) {
                    salir = false;
                    comp TempComponent = (comp)this.BusbarVectorI.elementAt(b);
                    this.query = "SELECT * FROM EB_Cmg_Barras WHERE (Barra='" + TempComponent.getName() + "') AND (Mes=" + Month + ") ORDER BY Dia";
                    this.rs = this.stmt.executeQuery(this.query);
                    while (this.rs.next() & !salir) {
                        d = this.rs.getInt("Dia");
                        if (this.EBtype != 1 && (this.EBtype == 1 || d != InitialDay)) continue;
                        this.Spot_Price[b][h - InitialHours][d - InitialDay] = h < 10 ? this.rs.getDouble("H0" + h) : this.rs.getDouble("H" + h);
                        if (this.EBtype == 1) continue;
                        salir = true;
                    }
                    this.query = "SELECT * FROM EB_Recargos WHERE (Barra='" + TempComponent.getName() + "')";
                    this.rs = this.stmt.executeQuery(this.query);
                    while (this.rs.next()) {
                        this.Busbar_Penalty[b][0] = this.rs.getDouble("Factor_Penalizacion");
                        this.Busbar_Penalty[b][1] = this.rs.getDouble("Recargo_SubTx");
                    }
                }
                for (int p = 0; p < this.numPgen; ++p) {
                    salir = false;
                    this.query = "SELECT * FROM EB_PG_Gen WHERE (Generador='" + this.P_GenName[p][0] + "') AND (Mes=" + Month + ") ORDER BY Dia";
                    this.rs = this.stmt.executeQuery(this.query);
                    while (this.rs.next() & !salir) {
                        d = this.rs.getInt("Dia");
                        if (this.EBtype != 1 && (this.EBtype == 1 || d != InitialDay)) continue;
                        this.PG_Generation[p][h - InitialHours][d - InitialDay] = h < 10 ? this.rs.getDouble("H0" + h) : this.rs.getDouble("H" + h);
                        if (this.EBtype == 1) continue;
                        salir = true;
                    }
                }
                for (int c = 0; c < this.numcust; ++c) {
                    salir = false;
                    this.query = "SELECT * FROM EB_factor_K WHERE (EDE='" + this.DisCoName[c] + "')";
                    this.rs = this.stmt.executeQuery(this.query);
                    while (this.rs.next()) {
                        this.DisCo_K[c] = this.rs.getDouble("factor_K");
                    }
                }
                for (int m = 0; m < this.numcontract; ++m) {
                    salir = false;
                    this.query = "SELECT * FROM EB_Contratos WHERE (Consumo='" + ((Load)this.contract[m][2]).getName() + "')";
                    this.rs = this.stmt.executeQuery(this.query);
                    while (this.rs.next()) {
                        gen = this.rs.getString("Generador");
                        if (!this.contract[m][1].getName().equals(gen)) continue;
                        this.Pot_Cont[m] = this.rs.getDouble("Potencia_Contratada");
                    }
                }
            }
            this.rs.close();
            this.stmt.close();
        }
        catch (SQLException e) {
            System.out.println(this.query);
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("@ Exception in EBDG-LoadProfiles");
        }
    }

    public int numbus(String Busbarname) {
        int ix = 0;
        for (ix = 0; ix < this.BusbarVectorI.size(); ++ix) {
            comp TempComponent = (comp)this.BusbarVectorI.elementAt(ix);
            if (TempComponent.getName().hashCode() != Busbarname.hashCode() || !TempComponent.getName().equals(Busbarname)) continue;
            return ix;
        }
        System.out.println(" No Busbar name found !! (" + Busbarname + ")");
        return 0;
    }

    public void SaveInDataBase() {
    }

    public void ShowGraf() {
        if (!this.permiso) {
            return;
        }
        this.MyEBGrafFrame = new EBGrafFrame(this, this.GenCoName, this.GenCoSales, this.GenCoPurch, this.GenCoBalance, this.EBtype, this.numsup, this.TotNumDays, this.EBhour);
    }

    public void ToFrame() {
        if (this.MyEBDGFrame != null) {
            this.MyEBDGFrame.setVisible(true);
        }
    }

    public void ShowTextResult() {
        if (!this.permiso) {
            return;
        }
        try {
            this.os = new FileOutputStream(this.Archivo);
            this.WriteReport(this.os);
            this.os.close();
            if (this.MyZFileViewer == null) {
                this.MyZFileViewer = new ZFileViewer(DeepEdit.frame, this.Archivo);
                this.MyZFileViewer.setSize(610, 440);
                this.MyZFileViewer.setfont(new Font("Courier", 0, 12));
                this.MyZFileViewer.setVisible(true);
            } else {
                this.MyZFileViewer.openFile(this.Archivo);
            }
            this.MyZFileViewer.setVisible(true);
        }
        catch (Exception e) {
            String message = e.toString();
            String[] DlgButtons = new String[]{"OK"};
            SimpleDialog ExceptionDialog = new SimpleDialog(DeepEdit.frame, "EBDG", message, DlgButtons, 1, 0, 0, 1);
            return;
        }
    }

    public void WriteReport(FileOutputStream os) {
        int j;
        int i;
        int j2;
        int k;
        int i2;
        int k2;
        int i3;
        int format_a = 12;
        int format_b = 2;
        PrintWriter myPrintStream = new PrintWriter(os, true);
        myPrintStream.println("------------------------------------------------------------------------------------------------------");
        myPrintStream.println("      E N E R G Y  B A L A N C E  T O O L");
        myPrintStream.println("              ");
        myPrintStream.println("                          January 2005  ");
        myPrintStream.println("              ");
        myPrintStream.println("-------------------------------------------------------------------------------------------------------");
        myPrintStream.println("");
        if (this.EBtype == 0) {
            myPrintStream.println("Selected day:");
        }
        myPrintStream.println("  Month                         :" + this.MonthName(this.EBmonth, "e"));
        if (this.EBtype == 0) {
            myPrintStream.println("  Day in month                  :" + this.EBday);
            myPrintStream.println("  Hour in Day                   :" + this.EBhour + ":00");
        }
        myPrintStream.println("");
        myPrintStream.println("Network Statistics:");
        myPrintStream.println("-------------------------------------");
        myPrintStream.println("");
        myPrintStream.println("    |-Busbar    = " + this.numbus);
        myPrintStream.println("    |-Load      = " + this.numload);
        myPrintStream.println("    |-Generator = " + this.numgen);
        myPrintStream.println("         |-DGs       = " + this.numPgen);
        myPrintStream.println("-------------------------------------");
        myPrintStream.println("");
        myPrintStream.println("");
        myPrintStream.println("ENERGY BALANCES: ");
        myPrintStream.println("");
        myPrintStream.println("");
        myPrintStream.println("BALANCE GENERADORES:");
        myPrintStream.println("");
        for (i3 = 0; i3 < this.numgen; ++i3) {
            myPrintStream.println("");
            myPrintStream.println("GENERADOR " + this.GenName[i3][0] + " (" + this.GenName[i3][1] + ")");
            myPrintStream.println("");
            if (this.EBtype == 1) {
                myPrintStream.println("VENTAS [US$]");
                myPrintStream.println("");
                myPrintStream.println("Hora,        H01,          H02,          H03,          H04,          H05,          H06,          H07,          H08,          H09,          H10,          H11,          H12,          H13,          H14,          H15,          H16,          H17,          H18,          H19,          H20,          H21,          H22,          H23,          H24");
                myPrintStream.println("Dia");
                for (k2 = 0; k2 < this.TotNumDays; ++k2) {
                    myPrintStream.println(StringUtil.numformat(k2 + 1, 2, 0) + ", " + StringUtil.numformat(this.GenSales[i3][0][k2], format_a, format_b) + ", " + StringUtil.numformat(this.GenSales[i3][1][k2], format_a, format_b) + ", " + StringUtil.numformat(this.GenSales[i3][2][k2], format_a, format_b) + ", " + StringUtil.numformat(this.GenSales[i3][3][k2], format_a, format_b) + ", " + StringUtil.numformat(this.GenSales[i3][4][k2], format_a, format_b) + ", " + StringUtil.numformat(this.GenSales[i3][5][k2], format_a, format_b) + ", " + StringUtil.numformat(this.GenSales[i3][6][k2], format_a, format_b) + ", " + StringUtil.numformat(this.GenSales[i3][7][k2], format_a, format_b) + ", " + StringUtil.numformat(this.GenSales[i3][8][k2], format_a, format_b) + ", " + StringUtil.numformat(this.GenSales[i3][9][k2], format_a, format_b) + ", " + StringUtil.numformat(this.GenSales[i3][10][k2], format_a, format_b) + ", " + StringUtil.numformat(this.GenSales[i3][11][k2], format_a, format_b) + ", " + StringUtil.numformat(this.GenSales[i3][12][k2], format_a, format_b) + ", " + StringUtil.numformat(this.GenSales[i3][13][k2], format_a, format_b) + ", " + StringUtil.numformat(this.GenSales[i3][14][k2], format_a, format_b) + ", " + StringUtil.numformat(this.GenSales[i3][15][k2], format_a, format_b) + ", " + StringUtil.numformat(this.GenSales[i3][16][k2], format_a, format_b) + ", " + StringUtil.numformat(this.GenSales[i3][17][k2], format_a, format_b) + ", " + StringUtil.numformat(this.GenSales[i3][18][k2], format_a, format_b) + ", " + StringUtil.numformat(this.GenSales[i3][19][k2], format_a, format_b) + ", " + StringUtil.numformat(this.GenSales[i3][20][k2], format_a, format_b) + ", " + StringUtil.numformat(this.GenSales[i3][21][k2], format_a, format_b) + ", " + StringUtil.numformat(this.GenSales[i3][22][k2], format_a, format_b) + ", " + StringUtil.numformat(this.GenSales[i3][23][k2], format_a, format_b) + ", ");
                }
            } else {
                myPrintStream.println("Ventas\t\t:" + StringUtil.numformat(this.GenSales[i3][0][0], format_a, format_b) + " [US$]");
            }
            if (this.EBtype == 1) {
                myPrintStream.println("");
                myPrintStream.println("COMPRAS [US$]");
                myPrintStream.println("");
                myPrintStream.println("Hora,        H01,          H02,          H03,          H04,          H05,          H06,          H07,          H08,          H09,          H10,          H11,          H12,          H13,          H14,          H15,          H16,          H17,          H18,          H19,          H20,          H21,          H22,          H23,          H24");
                myPrintStream.println("Dia");
                for (k2 = 0; k2 < this.TotNumDays; ++k2) {
                    myPrintStream.println(StringUtil.numformat(k2 + 1, 2, 0) + ", " + StringUtil.numformat(this.GenPurch[i3][0][k2], format_a, format_b) + ", " + StringUtil.numformat(this.GenPurch[i3][1][k2], format_a, format_b) + ", " + StringUtil.numformat(this.GenPurch[i3][2][k2], format_a, format_b) + ", " + StringUtil.numformat(this.GenPurch[i3][3][k2], format_a, format_b) + ", " + StringUtil.numformat(this.GenPurch[i3][4][k2], format_a, format_b) + ", " + StringUtil.numformat(this.GenPurch[i3][5][k2], format_a, format_b) + ", " + StringUtil.numformat(this.GenPurch[i3][6][k2], format_a, format_b) + ", " + StringUtil.numformat(this.GenPurch[i3][7][k2], format_a, format_b) + ", " + StringUtil.numformat(this.GenPurch[i3][8][k2], format_a, format_b) + ", " + StringUtil.numformat(this.GenPurch[i3][9][k2], format_a, format_b) + ", " + StringUtil.numformat(this.GenPurch[i3][10][k2], format_a, format_b) + ", " + StringUtil.numformat(this.GenPurch[i3][11][k2], format_a, format_b) + ", " + StringUtil.numformat(this.GenPurch[i3][12][k2], format_a, format_b) + ", " + StringUtil.numformat(this.GenPurch[i3][13][k2], format_a, format_b) + ", " + StringUtil.numformat(this.GenPurch[i3][14][k2], format_a, format_b) + ", " + StringUtil.numformat(this.GenPurch[i3][15][k2], format_a, format_b) + ", " + StringUtil.numformat(this.GenPurch[i3][16][k2], format_a, format_b) + ", " + StringUtil.numformat(this.GenPurch[i3][17][k2], format_a, format_b) + ", " + StringUtil.numformat(this.GenPurch[i3][18][k2], format_a, format_b) + ", " + StringUtil.numformat(this.GenPurch[i3][19][k2], format_a, format_b) + ", " + StringUtil.numformat(this.GenPurch[i3][20][k2], format_a, format_b) + ", " + StringUtil.numformat(this.GenPurch[i3][21][k2], format_a, format_b) + ", " + StringUtil.numformat(this.GenPurch[i3][22][k2], format_a, format_b) + ", " + StringUtil.numformat(this.GenPurch[i3][23][k2], format_a, format_b) + ", ");
                }
            } else {
                myPrintStream.println("Compras\t:" + StringUtil.numformat(this.GenPurch[i3][0][0], format_a, format_b) + " [US$]");
            }
            if (this.EBtype == 1) {
                myPrintStream.println("");
                myPrintStream.println("BALANCE [US$]");
                myPrintStream.println("");
                myPrintStream.println("Hora,        H01,          H02,          H03,          H04,          H05,          H06,          H07,          H08,          H09,          H10,          H11,          H12,          H13,          H14,          H15,          H16,          H17,          H18,          H19,          H20,          H21,          H22,          H23,          H24");
                myPrintStream.println("Dia");
                for (k2 = 0; k2 < this.TotNumDays; ++k2) {
                    myPrintStream.println(StringUtil.numformat(k2 + 1, 2, 0) + ", " + StringUtil.numformat(this.GenBalance[i3][0][k2], format_a, format_b) + ", " + StringUtil.numformat(this.GenBalance[i3][1][k2], format_a, format_b) + ", " + StringUtil.numformat(this.GenBalance[i3][2][k2], format_a, format_b) + ", " + StringUtil.numformat(this.GenBalance[i3][3][k2], format_a, format_b) + ", " + StringUtil.numformat(this.GenBalance[i3][4][k2], format_a, format_b) + ", " + StringUtil.numformat(this.GenBalance[i3][5][k2], format_a, format_b) + ", " + StringUtil.numformat(this.GenBalance[i3][6][k2], format_a, format_b) + ", " + StringUtil.numformat(this.GenBalance[i3][7][k2], format_a, format_b) + ", " + StringUtil.numformat(this.GenBalance[i3][8][k2], format_a, format_b) + ", " + StringUtil.numformat(this.GenBalance[i3][9][k2], format_a, format_b) + ", " + StringUtil.numformat(this.GenBalance[i3][10][k2], format_a, format_b) + ", " + StringUtil.numformat(this.GenBalance[i3][11][k2], format_a, format_b) + ", " + StringUtil.numformat(this.GenBalance[i3][12][k2], format_a, format_b) + ", " + StringUtil.numformat(this.GenBalance[i3][13][k2], format_a, format_b) + ", " + StringUtil.numformat(this.GenBalance[i3][14][k2], format_a, format_b) + ", " + StringUtil.numformat(this.GenBalance[i3][15][k2], format_a, format_b) + ", " + StringUtil.numformat(this.GenBalance[i3][16][k2], format_a, format_b) + ", " + StringUtil.numformat(this.GenBalance[i3][17][k2], format_a, format_b) + ", " + StringUtil.numformat(this.GenBalance[i3][18][k2], format_a, format_b) + ", " + StringUtil.numformat(this.GenBalance[i3][19][k2], format_a, format_b) + ", " + StringUtil.numformat(this.GenBalance[i3][20][k2], format_a, format_b) + ", " + StringUtil.numformat(this.GenBalance[i3][21][k2], format_a, format_b) + ", " + StringUtil.numformat(this.GenBalance[i3][22][k2], format_a, format_b) + ", " + StringUtil.numformat(this.GenBalance[i3][23][k2], format_a, format_b) + ", ");
                }
                continue;
            }
            myPrintStream.println("Balance\t:" + StringUtil.numformat(this.GenBalance[i3][0][0], format_a, format_b) + " [US$]");
        }
        myPrintStream.println("");
        myPrintStream.println("");
        myPrintStream.println("BALANCE PEQUE\u00d1OS GENERADORES:");
        myPrintStream.println("");
        for (i3 = 0; i3 < this.numPgen; ++i3) {
            myPrintStream.println("");
            myPrintStream.println("GENERADOR " + this.P_GenName[i3][0] + " (" + this.P_GenName[i3][1] + ")");
            myPrintStream.println("");
            if (this.EBtype == 1) {
                myPrintStream.println("VENTAS [US$]");
                myPrintStream.println("");
                myPrintStream.println("Hora,        H01,          H02,          H03,          H04,          H05,          H06,          H07,          H08,          H09,          H10,          H11,          H12,          H13,          H14,          H15,          H16,          H17,          H18,          H19,          H20,          H21,          H22,          H23,          H24");
                myPrintStream.println("Dia");
                for (k2 = 0; k2 < this.TotNumDays; ++k2) {
                    myPrintStream.println(StringUtil.numformat(k2 + 1, 2, 0) + ", " + StringUtil.numformat(this.P_GenSales[i3][0][k2], format_a, format_b) + ", " + StringUtil.numformat(this.P_GenSales[i3][1][k2], format_a, format_b) + ", " + StringUtil.numformat(this.P_GenSales[i3][2][k2], format_a, format_b) + ", " + StringUtil.numformat(this.P_GenSales[i3][3][k2], format_a, format_b) + ", " + StringUtil.numformat(this.P_GenSales[i3][4][k2], format_a, format_b) + ", " + StringUtil.numformat(this.P_GenSales[i3][5][k2], format_a, format_b) + ", " + StringUtil.numformat(this.P_GenSales[i3][6][k2], format_a, format_b) + ", " + StringUtil.numformat(this.P_GenSales[i3][7][k2], format_a, format_b) + ", " + StringUtil.numformat(this.P_GenSales[i3][8][k2], format_a, format_b) + ", " + StringUtil.numformat(this.P_GenSales[i3][9][k2], format_a, format_b) + ", " + StringUtil.numformat(this.P_GenSales[i3][10][k2], format_a, format_b) + ", " + StringUtil.numformat(this.P_GenSales[i3][11][k2], format_a, format_b) + ", " + StringUtil.numformat(this.P_GenSales[i3][12][k2], format_a, format_b) + ", " + StringUtil.numformat(this.P_GenSales[i3][13][k2], format_a, format_b) + ", " + StringUtil.numformat(this.P_GenSales[i3][14][k2], format_a, format_b) + ", " + StringUtil.numformat(this.P_GenSales[i3][15][k2], format_a, format_b) + ", " + StringUtil.numformat(this.P_GenSales[i3][16][k2], format_a, format_b) + ", " + StringUtil.numformat(this.P_GenSales[i3][17][k2], format_a, format_b) + ", " + StringUtil.numformat(this.P_GenSales[i3][18][k2], format_a, format_b) + ", " + StringUtil.numformat(this.P_GenSales[i3][19][k2], format_a, format_b) + ", " + StringUtil.numformat(this.P_GenSales[i3][20][k2], format_a, format_b) + ", " + StringUtil.numformat(this.P_GenSales[i3][21][k2], format_a, format_b) + ", " + StringUtil.numformat(this.P_GenSales[i3][22][k2], format_a, format_b) + ", " + StringUtil.numformat(this.P_GenSales[i3][23][k2], format_a, format_b) + ", ");
                }
            } else {
                myPrintStream.println("Ventas\t\t:" + StringUtil.numformat(this.P_GenSales[i3][0][0], format_a, format_b) + " [US$]");
            }
            if (this.EBtype == 1) {
                myPrintStream.println("");
                myPrintStream.println("COMPRAS [US$]");
                myPrintStream.println("");
                myPrintStream.println("Hora,        H01,          H02,          H03,          H04,          H05,          H06,          H07,          H08,          H09,          H10,          H11,          H12,          H13,          H14,          H15,          H16,          H17,          H18,          H19,          H20,          H21,          H22,          H23,          H24");
                myPrintStream.println("Dia");
                for (k2 = 0; k2 < this.TotNumDays; ++k2) {
                    myPrintStream.println(StringUtil.numformat(k2 + 1, 2, 0) + ", " + StringUtil.numformat(this.P_GenPurch[i3][0][k2], format_a, format_b) + ", " + StringUtil.numformat(this.P_GenPurch[i3][1][k2], format_a, format_b) + ", " + StringUtil.numformat(this.P_GenPurch[i3][2][k2], format_a, format_b) + ", " + StringUtil.numformat(this.P_GenPurch[i3][3][k2], format_a, format_b) + ", " + StringUtil.numformat(this.P_GenPurch[i3][4][k2], format_a, format_b) + ", " + StringUtil.numformat(this.P_GenPurch[i3][5][k2], format_a, format_b) + ", " + StringUtil.numformat(this.P_GenPurch[i3][6][k2], format_a, format_b) + ", " + StringUtil.numformat(this.P_GenPurch[i3][7][k2], format_a, format_b) + ", " + StringUtil.numformat(this.P_GenPurch[i3][8][k2], format_a, format_b) + ", " + StringUtil.numformat(this.P_GenPurch[i3][9][k2], format_a, format_b) + ", " + StringUtil.numformat(this.P_GenPurch[i3][10][k2], format_a, format_b) + ", " + StringUtil.numformat(this.P_GenPurch[i3][11][k2], format_a, format_b) + ", " + StringUtil.numformat(this.P_GenPurch[i3][12][k2], format_a, format_b) + ", " + StringUtil.numformat(this.P_GenPurch[i3][13][k2], format_a, format_b) + ", " + StringUtil.numformat(this.P_GenPurch[i3][14][k2], format_a, format_b) + ", " + StringUtil.numformat(this.P_GenPurch[i3][15][k2], format_a, format_b) + ", " + StringUtil.numformat(this.P_GenPurch[i3][16][k2], format_a, format_b) + ", " + StringUtil.numformat(this.P_GenPurch[i3][17][k2], format_a, format_b) + ", " + StringUtil.numformat(this.P_GenPurch[i3][18][k2], format_a, format_b) + ", " + StringUtil.numformat(this.P_GenPurch[i3][19][k2], format_a, format_b) + ", " + StringUtil.numformat(this.P_GenPurch[i3][20][k2], format_a, format_b) + ", " + StringUtil.numformat(this.P_GenPurch[i3][21][k2], format_a, format_b) + ", " + StringUtil.numformat(this.P_GenPurch[i3][22][k2], format_a, format_b) + ", " + StringUtil.numformat(this.P_GenPurch[i3][23][k2], format_a, format_b) + ", ");
                }
            } else {
                myPrintStream.println("Compras\t:" + StringUtil.numformat(this.P_GenPurch[i3][0][0], format_a, format_b) + " [US$]");
            }
            if (this.EBtype == 1) {
                myPrintStream.println("");
                myPrintStream.println("BALANCE [US$]");
                myPrintStream.println("");
                myPrintStream.println("Hora,        H01,          H02,          H03,          H04,          H05,          H06,          H07,          H08,          H09,          H10,          H11,          H12,          H13,          H14,          H15,          H16,          H17,          H18,          H19,          H20,          H21,          H22,          H23,          H24");
                myPrintStream.println("Dia");
                for (k2 = 0; k2 < this.TotNumDays; ++k2) {
                    myPrintStream.println(StringUtil.numformat(k2 + 1, 2, 0) + ", " + StringUtil.numformat(this.P_GenBalance[i3][0][k2], format_a, format_b) + ", " + StringUtil.numformat(this.P_GenBalance[i3][1][k2], format_a, format_b) + ", " + StringUtil.numformat(this.P_GenBalance[i3][2][k2], format_a, format_b) + ", " + StringUtil.numformat(this.P_GenBalance[i3][3][k2], format_a, format_b) + ", " + StringUtil.numformat(this.P_GenBalance[i3][4][k2], format_a, format_b) + ", " + StringUtil.numformat(this.P_GenBalance[i3][5][k2], format_a, format_b) + ", " + StringUtil.numformat(this.P_GenBalance[i3][6][k2], format_a, format_b) + ", " + StringUtil.numformat(this.P_GenBalance[i3][7][k2], format_a, format_b) + ", " + StringUtil.numformat(this.P_GenBalance[i3][8][k2], format_a, format_b) + ", " + StringUtil.numformat(this.P_GenBalance[i3][9][k2], format_a, format_b) + ", " + StringUtil.numformat(this.P_GenBalance[i3][10][k2], format_a, format_b) + ", " + StringUtil.numformat(this.P_GenBalance[i3][11][k2], format_a, format_b) + ", " + StringUtil.numformat(this.P_GenBalance[i3][12][k2], format_a, format_b) + ", " + StringUtil.numformat(this.P_GenBalance[i3][13][k2], format_a, format_b) + ", " + StringUtil.numformat(this.P_GenBalance[i3][14][k2], format_a, format_b) + ", " + StringUtil.numformat(this.P_GenBalance[i3][15][k2], format_a, format_b) + ", " + StringUtil.numformat(this.P_GenBalance[i3][16][k2], format_a, format_b) + ", " + StringUtil.numformat(this.P_GenBalance[i3][17][k2], format_a, format_b) + ", " + StringUtil.numformat(this.P_GenBalance[i3][18][k2], format_a, format_b) + ", " + StringUtil.numformat(this.P_GenBalance[i3][19][k2], format_a, format_b) + ", " + StringUtil.numformat(this.P_GenBalance[i3][20][k2], format_a, format_b) + ", " + StringUtil.numformat(this.P_GenBalance[i3][21][k2], format_a, format_b) + ", " + StringUtil.numformat(this.P_GenBalance[i3][22][k2], format_a, format_b) + ", " + StringUtil.numformat(this.P_GenBalance[i3][23][k2], format_a, format_b) + ", ");
                }
                continue;
            }
            myPrintStream.println("Balance\t:" + StringUtil.numformat(this.P_GenBalance[i3][0][0], format_a, format_b) + " [US$]");
        }
        myPrintStream.println("");
        myPrintStream.println("");
        myPrintStream.println("BALANCE EMPRESAS GENERADORAS:");
        myPrintStream.println("");
        for (i3 = 0; i3 < this.numsup; ++i3) {
            myPrintStream.println("");
            myPrintStream.println("EMPRESA :" + this.GenCoName[i3]);
            myPrintStream.println("");
            if (this.EBtype == 1) {
                myPrintStream.println("VENTAS [US$]");
                myPrintStream.println("");
                myPrintStream.println("Hora,        H01,          H02,          H03,          H04,          H05,          H06,          H07,          H08,          H09,          H10,          H11,          H12,          H13,          H14,          H15,          H16,          H17,          H18,          H19,          H20,          H21,          H22,          H23,          H24");
                myPrintStream.println("Dia");
                for (k2 = 0; k2 < this.TotNumDays; ++k2) {
                    myPrintStream.println(StringUtil.numformat(k2 + 1, 2, 0) + ", " + StringUtil.numformat(this.GenCoSales[i3][0][k2], format_a, format_b) + ", " + StringUtil.numformat(this.GenCoSales[i3][1][k2], format_a, format_b) + ", " + StringUtil.numformat(this.GenCoSales[i3][2][k2], format_a, format_b) + ", " + StringUtil.numformat(this.GenCoSales[i3][3][k2], format_a, format_b) + ", " + StringUtil.numformat(this.GenCoSales[i3][4][k2], format_a, format_b) + ", " + StringUtil.numformat(this.GenCoSales[i3][5][k2], format_a, format_b) + ", " + StringUtil.numformat(this.GenCoSales[i3][6][k2], format_a, format_b) + ", " + StringUtil.numformat(this.GenCoSales[i3][7][k2], format_a, format_b) + ", " + StringUtil.numformat(this.GenCoSales[i3][8][k2], format_a, format_b) + ", " + StringUtil.numformat(this.GenCoSales[i3][9][k2], format_a, format_b) + ", " + StringUtil.numformat(this.GenCoSales[i3][10][k2], format_a, format_b) + ", " + StringUtil.numformat(this.GenCoSales[i3][11][k2], format_a, format_b) + ", " + StringUtil.numformat(this.GenCoSales[i3][12][k2], format_a, format_b) + ", " + StringUtil.numformat(this.GenCoSales[i3][13][k2], format_a, format_b) + ", " + StringUtil.numformat(this.GenCoSales[i3][14][k2], format_a, format_b) + ", " + StringUtil.numformat(this.GenCoSales[i3][15][k2], format_a, format_b) + ", " + StringUtil.numformat(this.GenCoSales[i3][16][k2], format_a, format_b) + ", " + StringUtil.numformat(this.GenCoSales[i3][17][k2], format_a, format_b) + ", " + StringUtil.numformat(this.GenCoSales[i3][18][k2], format_a, format_b) + ", " + StringUtil.numformat(this.GenCoSales[i3][19][k2], format_a, format_b) + ", " + StringUtil.numformat(this.GenCoSales[i3][20][k2], format_a, format_b) + ", " + StringUtil.numformat(this.GenCoSales[i3][21][k2], format_a, format_b) + ", " + StringUtil.numformat(this.GenCoSales[i3][22][k2], format_a, format_b) + ", " + StringUtil.numformat(this.GenCoSales[i3][23][k2], format_a, format_b) + ", ");
                }
            } else {
                myPrintStream.println("Ventas\t\t:" + StringUtil.numformat(this.GenCoSales[i3][0][0], format_a, format_b) + " [US$]");
            }
            if (this.EBtype == 1) {
                myPrintStream.println("");
                myPrintStream.println("COMPRAS [US$]");
                myPrintStream.println("");
                myPrintStream.println("Hora,        H01,          H02,          H03,          H04,          H05,          H06,          H07,          H08,          H09,          H10,          H11,          H12,          H13,          H14,          H15,          H16,          H17,          H18,          H19,          H20,          H21,          H22,          H23,          H24");
                myPrintStream.println("Dia");
                for (k2 = 0; k2 < this.TotNumDays; ++k2) {
                    myPrintStream.println(StringUtil.numformat(k2 + 1, 2, 0) + ", " + StringUtil.numformat(this.GenCoPurch[i3][0][k2], format_a, format_b) + ", " + StringUtil.numformat(this.GenCoPurch[i3][1][k2], format_a, format_b) + ", " + StringUtil.numformat(this.GenCoPurch[i3][2][k2], format_a, format_b) + ", " + StringUtil.numformat(this.GenCoPurch[i3][3][k2], format_a, format_b) + ", " + StringUtil.numformat(this.GenCoPurch[i3][4][k2], format_a, format_b) + ", " + StringUtil.numformat(this.GenCoPurch[i3][5][k2], format_a, format_b) + ", " + StringUtil.numformat(this.GenCoPurch[i3][6][k2], format_a, format_b) + ", " + StringUtil.numformat(this.GenCoPurch[i3][7][k2], format_a, format_b) + ", " + StringUtil.numformat(this.GenCoPurch[i3][8][k2], format_a, format_b) + ", " + StringUtil.numformat(this.GenCoPurch[i3][9][k2], format_a, format_b) + ", " + StringUtil.numformat(this.GenCoPurch[i3][10][k2], format_a, format_b) + ", " + StringUtil.numformat(this.GenCoPurch[i3][11][k2], format_a, format_b) + ", " + StringUtil.numformat(this.GenCoPurch[i3][12][k2], format_a, format_b) + ", " + StringUtil.numformat(this.GenCoPurch[i3][13][k2], format_a, format_b) + ", " + StringUtil.numformat(this.GenCoPurch[i3][14][k2], format_a, format_b) + ", " + StringUtil.numformat(this.GenCoPurch[i3][15][k2], format_a, format_b) + ", " + StringUtil.numformat(this.GenCoPurch[i3][16][k2], format_a, format_b) + ", " + StringUtil.numformat(this.GenCoPurch[i3][17][k2], format_a, format_b) + ", " + StringUtil.numformat(this.GenCoPurch[i3][18][k2], format_a, format_b) + ", " + StringUtil.numformat(this.GenCoPurch[i3][19][k2], format_a, format_b) + ", " + StringUtil.numformat(this.GenCoPurch[i3][20][k2], format_a, format_b) + ", " + StringUtil.numformat(this.GenCoPurch[i3][21][k2], format_a, format_b) + ", " + StringUtil.numformat(this.GenCoPurch[i3][22][k2], format_a, format_b) + ", " + StringUtil.numformat(this.GenCoPurch[i3][23][k2], format_a, format_b) + ", ");
                }
            } else {
                myPrintStream.println("Compras\t:" + StringUtil.numformat(this.GenCoPurch[i3][0][0], format_a, format_b) + " [US$]");
            }
            if (this.EBtype == 1) {
                myPrintStream.println("");
                myPrintStream.println("BALANCE [US$]");
                myPrintStream.println("");
                myPrintStream.println("Hora,        H01,          H02,          H03,          H04,          H05,          H06,          H07,          H08,          H09,          H10,          H11,          H12,          H13,          H14,          H15,          H16,          H17,          H18,          H19,          H20,          H21,          H22,          H23,          H24");
                myPrintStream.println("Dia");
                for (k2 = 0; k2 < this.TotNumDays; ++k2) {
                    myPrintStream.println(StringUtil.numformat(k2 + 1, 2, 0) + ", " + StringUtil.numformat(this.GenCoBalance[i3][0][k2], format_a, format_b) + ", " + StringUtil.numformat(this.GenCoBalance[i3][1][k2], format_a, format_b) + ", " + StringUtil.numformat(this.GenCoBalance[i3][2][k2], format_a, format_b) + ", " + StringUtil.numformat(this.GenCoBalance[i3][3][k2], format_a, format_b) + ", " + StringUtil.numformat(this.GenCoBalance[i3][4][k2], format_a, format_b) + ", " + StringUtil.numformat(this.GenCoBalance[i3][5][k2], format_a, format_b) + ", " + StringUtil.numformat(this.GenCoBalance[i3][6][k2], format_a, format_b) + ", " + StringUtil.numformat(this.GenCoBalance[i3][7][k2], format_a, format_b) + ", " + StringUtil.numformat(this.GenCoBalance[i3][8][k2], format_a, format_b) + ", " + StringUtil.numformat(this.GenCoBalance[i3][9][k2], format_a, format_b) + ", " + StringUtil.numformat(this.GenCoBalance[i3][10][k2], format_a, format_b) + ", " + StringUtil.numformat(this.GenCoBalance[i3][11][k2], format_a, format_b) + ", " + StringUtil.numformat(this.GenCoBalance[i3][12][k2], format_a, format_b) + ", " + StringUtil.numformat(this.GenCoBalance[i3][13][k2], format_a, format_b) + ", " + StringUtil.numformat(this.GenCoBalance[i3][14][k2], format_a, format_b) + ", " + StringUtil.numformat(this.GenCoBalance[i3][15][k2], format_a, format_b) + ", " + StringUtil.numformat(this.GenCoBalance[i3][16][k2], format_a, format_b) + ", " + StringUtil.numformat(this.GenCoBalance[i3][17][k2], format_a, format_b) + ", " + StringUtil.numformat(this.GenCoBalance[i3][18][k2], format_a, format_b) + ", " + StringUtil.numformat(this.GenCoBalance[i3][19][k2], format_a, format_b) + ", " + StringUtil.numformat(this.GenCoBalance[i3][20][k2], format_a, format_b) + ", " + StringUtil.numformat(this.GenCoBalance[i3][21][k2], format_a, format_b) + ", " + StringUtil.numformat(this.GenCoBalance[i3][22][k2], format_a, format_b) + ", " + StringUtil.numformat(this.GenCoBalance[i3][23][k2], format_a, format_b) + ", ");
                }
                continue;
            }
            myPrintStream.println("Balance\t:" + StringUtil.numformat(this.GenCoBalance[i3][0][0], format_a, format_b) + " [US$]");
        }
        myPrintStream.println("");
        myPrintStream.println("");
        myPrintStream.println("EMPRESAS DISTRIBUIDORAS:");
        myPrintStream.println("");
        for (i3 = 0; i3 < this.numcust; ++i3) {
            myPrintStream.println("");
            myPrintStream.println("EMPRESA :" + this.DisCoName[i3]);
            myPrintStream.println("");
            if (this.EBtype == 1) {
                myPrintStream.println("DEMANDA [MW]");
                myPrintStream.println("");
                myPrintStream.println("Hora,        H01,          H02,          H03,          H04,          H05,          H06,          H07,          H08,          H09,          H10,          H11,          H12,          H13,          H14,          H15,          H16,          H17,          H18,          H19,          H20,          H21,          H22,          H23,          H24");
                myPrintStream.println("Dia");
                for (k2 = 0; k2 < this.TotNumDays; ++k2) {
                    myPrintStream.println(StringUtil.numformat(k2 + 1, 2, 0) + ", " + StringUtil.numformat(this.DisCoDemand[i3][0][k2], format_a, format_b) + ", " + StringUtil.numformat(this.DisCoDemand[i3][1][k2], format_a, format_b) + ", " + StringUtil.numformat(this.DisCoDemand[i3][2][k2], format_a, format_b) + ", " + StringUtil.numformat(this.DisCoDemand[i3][3][k2], format_a, format_b) + ", " + StringUtil.numformat(this.DisCoDemand[i3][4][k2], format_a, format_b) + ", " + StringUtil.numformat(this.DisCoDemand[i3][5][k2], format_a, format_b) + ", " + StringUtil.numformat(this.DisCoDemand[i3][6][k2], format_a, format_b) + ", " + StringUtil.numformat(this.DisCoDemand[i3][7][k2], format_a, format_b) + ", " + StringUtil.numformat(this.DisCoDemand[i3][8][k2], format_a, format_b) + ", " + StringUtil.numformat(this.DisCoDemand[i3][9][k2], format_a, format_b) + ", " + StringUtil.numformat(this.DisCoDemand[i3][10][k2], format_a, format_b) + ", " + StringUtil.numformat(this.DisCoDemand[i3][11][k2], format_a, format_b) + ", " + StringUtil.numformat(this.DisCoDemand[i3][12][k2], format_a, format_b) + ", " + StringUtil.numformat(this.DisCoDemand[i3][13][k2], format_a, format_b) + ", " + StringUtil.numformat(this.DisCoDemand[i3][14][k2], format_a, format_b) + ", " + StringUtil.numformat(this.DisCoDemand[i3][15][k2], format_a, format_b) + ", " + StringUtil.numformat(this.DisCoDemand[i3][16][k2], format_a, format_b) + ", " + StringUtil.numformat(this.DisCoDemand[i3][17][k2], format_a, format_b) + ", " + StringUtil.numformat(this.DisCoDemand[i3][18][k2], format_a, format_b) + ", " + StringUtil.numformat(this.DisCoDemand[i3][19][k2], format_a, format_b) + ", " + StringUtil.numformat(this.DisCoDemand[i3][20][k2], format_a, format_b) + ", " + StringUtil.numformat(this.DisCoDemand[i3][21][k2], format_a, format_b) + ", " + StringUtil.numformat(this.DisCoDemand[i3][22][k2], format_a, format_b) + ", " + StringUtil.numformat(this.DisCoDemand[i3][23][k2], format_a, format_b) + ", ");
                }
                continue;
            }
            myPrintStream.println("Demanda,:" + StringUtil.numformat(this.DisCoDemand[i3][0][0], format_a, format_b) + " [MWh]");
        }
        myPrintStream.println("");
        myPrintStream.println("");
        myPrintStream.println("TOTALES:");
        myPrintStream.println("");
        myPrintStream.println("");
        myPrintStream.println("");
        myPrintStream.println("Balance Total Empresas Generadoras:");
        myPrintStream.println("");
        for (i2 = 0; i2 < this.numsup; ++i2) {
            myPrintStream.println("");
            myPrintStream.println("Empresa :" + this.GenCoName[i2]);
            myPrintStream.println("");
            double totV = 0.0;
            double totC = 0.0;
            double totB = 0.0;
            for (k = 0; k < this.TotNumDays; ++k) {
                for (j2 = 0; j2 < this.TotNumHours; ++j2) {
                    this.GenCoBalance[i2][j2][k] = this.GenCoSales[i2][j2][k] - this.GenCoPurch[i2][j2][k];
                    totB += this.GenCoBalance[i2][j2][k];
                    totV += this.GenCoSales[i2][j2][k];
                    totC += this.GenCoPurch[i2][j2][k];
                }
            }
            myPrintStream.println("Ventas :," + StringUtil.numformat(totV, 12, 3) + ", [US$]");
            myPrintStream.println("Compras:," + StringUtil.numformat(totC, 12, 3) + ", [US$]");
            myPrintStream.println("Balance:," + StringUtil.numformat(totB, 12, 3) + ", [US$]");
        }
        myPrintStream.println("");
        myPrintStream.println("");
        myPrintStream.println("");
        myPrintStream.println("");
        myPrintStream.println("Empresas Distribuidoras:");
        myPrintStream.println("");
        for (i2 = 0; i2 < this.numcust; ++i2) {
            myPrintStream.println("");
            myPrintStream.println("Empresa :" + this.DisCoName[i2]);
            myPrintStream.println("");
            double totD = 0.0;
            double totPi = 0.0;
            double totPG = 0.0;
            for (k = 0; k < this.TotNumDays; ++k) {
                for (j2 = 0; j2 < this.TotNumHours; ++j2) {
                    totD += this.DisCoDemand[i2][j2][k];
                    totPG += this.DisCo_DG[i2][j2][k];
                    totPi += this.DisCoDemand[i2][j2][k] - this.DisCo_DG[i2][j2][k];
                }
            }
            myPrintStream.println("Dem + Perd:," + StringUtil.numformat(totD, 12, 3) + ", [MWh]");
            myPrintStream.println("Retiros   :," + StringUtil.numformat(totPi, 12, 3) + ", [MWh]");
            myPrintStream.println("G.Distrib.:," + StringUtil.numformat(totPG, 12, 3) + ", [MWh]");
        }
        int count_pos = 0;
        int count_neg = 0;
        double Tx_Balance = 0.0;
        this.GenCo_Pos = new String[this.numsup + 1];
        this.GenCo_Neg = new String[this.numsup + 1];
        for (i = 0; i < this.numsup; ++i) {
            if (this.Total_Balance[i] >= 0.0) {
                this.GenCo_Pos[count_pos] = this.GenCoName[i];
                Tx_Balance -= this.Total_Balance[i];
                ++count_pos;
                continue;
            }
            this.GenCo_Neg[count_neg] = this.GenCoName[i];
            Tx_Balance -= this.Total_Balance[i];
            ++count_neg;
        }
        if (Tx_Balance >= 0.0) {
            this.GenCo_Pos[count_pos] = "Transmision";
            ++count_pos;
        } else {
            this.GenCo_Neg[count_neg] = "Transmision";
            ++count_neg;
        }
        this.Total_Balance[this.numsup] = Tx_Balance;
        this.GenCoName[this.numsup] = "Transmision";
        this.Transf_Matrix = new double[count_neg + 1][count_pos + 1];
        for (i = 0; i < count_pos; ++i) {
            for (j = 0; j < this.numsup + 1; ++j) {
                if (!this.GenCo_Pos[i].equals(this.GenCoName[j])) continue;
                this.Transf_Matrix[count_neg][i] = this.Total_Balance[j];
            }
        }
        for (i = 0; i < count_neg; ++i) {
            for (j = 0; j < this.numsup + 1; ++j) {
                if (!this.GenCo_Neg[i].equals(this.GenCoName[j])) continue;
                this.Transf_Matrix[i][count_pos] = -1.0 * this.Total_Balance[j];
                double[] dArray = this.Transf_Matrix[count_neg];
                int n = count_pos;
                dArray[n] = dArray[n] - this.Total_Balance[j];
            }
        }
        for (i = 0; i < count_neg; ++i) {
            for (j = 0; j < count_pos; ++j) {
                this.Transf_Matrix[i][j] = this.Transf_Matrix[i][count_pos] * this.Transf_Matrix[count_neg][j] / this.Transf_Matrix[count_neg][count_pos];
            }
        }
        myPrintStream.println();
        myPrintStream.print(" ,Reciben");
        myPrintStream.println();
        myPrintStream.print("Pagan,");
        for (i = 0; i < count_pos; ++i) {
            myPrintStream.print(this.GenCo_Pos[i] + ",");
        }
        myPrintStream.print("Total");
        for (i = 0; i < count_neg; ++i) {
            myPrintStream.println();
            myPrintStream.print(this.GenCo_Neg[i] + ",");
            for (j = 0; j < count_pos + 1; ++j) {
                myPrintStream.print(StringUtil.numformat(this.Transf_Matrix[i][j], 12, 3) + ",");
            }
        }
        myPrintStream.println();
        myPrintStream.print("Total,");
        for (i = 0; i < count_pos + 1; ++i) {
            myPrintStream.print(StringUtil.numformat(this.Transf_Matrix[count_neg][i], 12, 3) + ",");
        }
        myPrintStream.println();
        myPrintStream.println("----   E N D   --------------------------------------------------------------------");
    }
}

