/*
 * Decompiled with CFR 0.152.
 */
package de.core;

import de.core.DeepEdit;
import de.core.GraphicsUtil;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Panel;

class DisplayLDC
extends Panel {
    double ldcmin;
    double ldcmax;
    double ldctime;
    double m0;
    double m;
    double a;
    double b;
    double t;
    double ts;
    String Name;
    int year;
    double sref;

    DisplayLDC(double lldcmin, double lldcmax, double lldctime, String NName, int yyear, double ssref) {
        this.ldcmin = lldcmin;
        this.ldcmax = lldcmax;
        this.ldctime = lldctime;
        this.m0 = this.ldcmax == 0.0 ? 1.0E9 : this.ldcmin / this.ldcmax;
        this.m = this.ldctime / 8760.0;
        this.a = (1.0 - this.m) / ((1.0 - this.m0) * (this.m - this.m0) * (this.m - this.m0));
        this.b = (this.m - this.m0) / ((1.0 - this.m0) * (1.0 - this.m) * (1.0 - this.m));
        this.ts = (this.m - this.m0) / (1.0 - this.m0);
        this.Name = NName;
        this.year = yyear;
        this.sref = ssref;
    }

    @Override
    public void paint(Graphics g) {
        Font ff = DeepEdit.TextFont;
        FontMetrics fm = this.getFontMetrics(ff);
        g.setFont(ff);
        String str = "Load Duration Curve";
        String str1 = String.valueOf(this.year);
        g.setColor(Color.lightGray);
        g.fillRect(0, 0, 249, 249);
        g.setColor(Color.black);
        g.drawRect(0, 0, 249, 249);
        GraphicsUtil.drawArrow((Graphics2D)g, 18, 220, 18, 25, 1, 6);
        GraphicsUtil.drawArrow((Graphics2D)g, 18, 220, 228, 220, 1, 6);
        g.drawString(str, 70, 15);
        g.drawString(this.Name, 105, 25);
        g.drawString(str1, 106, 35);
        g.drawString("[MW]", 5, 25);
        g.drawString("[hr]", 226, 232);
        g.setColor(Color.red);
        g.drawString("8760", 198, 232);
        g.drawString("0", 20, 232);
        double fac = 200 / this.f(0.0);
        str1 = String.valueOf(this.ldcmax * this.sref);
        g.drawString(str1, 23, 30);
        str1 = String.valueOf(this.ldcmin * this.sref);
        g.drawString(str1, 23, 230 - (int)(fac * (double)this.f(200.0)));
        g.setColor(Color.blue);
        for (int x = 0; x < 200; ++x) {
            g.drawLine(x + 20, 230 - (int)(fac * (double)this.f(x)), x + 1 + 20, 230 - (int)(fac * (double)this.f(x + 1)));
        }
    }

    public int f(double x) {
        int valor = x / 200.0 >= this.ts ? (int)(100.0 * (this.m0 + Math.sqrt((1.0 - x / 200.0) / this.a))) : (int)(100.0 * (1.0 - Math.sqrt(x / 200.0 / this.b)));
        return valor;
    }
}

