/*
 * Decompiled with CFR 0.152.
 */
package de.core;

import de.core.WizardTask;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JPanel;

class DeepEditWizardModel {
    List<WizardTask> mTasks = new LinkedList<WizardTask>();

    DeepEditWizardModel() {
    }

    void registerPanel(WizardTask task) {
        this.mTasks.add(task);
    }

    WizardTask getTask(String name) {
        if (name == null) {
            return null;
        }
        for (WizardTask task : this.mTasks) {
            if (!task.getTaskName().equalsIgnoreCase(name)) continue;
            return task;
        }
        return null;
    }

    JPanel nextPanel(String id) {
        int index = this.mTasks.indexOf(this.getTask(id));
        if (index == -1) {
            return null;
        }
        if (index + 1 >= this.mTasks.size()) {
            return null;
        }
        return this.mTasks.get(index + 1).getTaskPnl();
    }

    WizardTask nextTask(String id) {
        int index = this.mTasks.indexOf(this.getTask(id));
        if (index == -1) {
            return null;
        }
        if (index + 1 >= this.mTasks.size()) {
            return null;
        }
        return this.mTasks.get(index + 1);
    }

    JPanel prevPanel(String id) {
        int index = this.mTasks.indexOf(this.getTask(id));
        if (index == -1) {
            return null;
        }
        if (index - 1 < 0) {
            return null;
        }
        return this.mTasks.get(index - 1).getTaskPnl();
    }

    WizardTask prevTask(String id) {
        int index = this.mTasks.indexOf(this.getTask(id));
        if (index == -1) {
            return null;
        }
        if (index - 1 < 0) {
            return null;
        }
        return this.mTasks.get(index - 1);
    }

    int getTotalPanels() {
        return this.mTasks.size();
    }
}

