/*
 * Decompiled with CFR 0.152.
 */
package de.core;

import de.core.DeepEdit;
import de.data.DE_GeneralEnums;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.NumberFormatter;

public class DeepEditOptionsJDialog
extends JDialog {
    private final DeepEdit MyDeepEdit;
    private JPanel ColorlPanel;
    private JPanel ConfirmPanel;
    private JPanel DatabasePanel;
    private JPanel GeneralPanel;
    private JPanel LanguagePanel;
    private JCheckBox ShowAliasCheckbox;
    private JCheckBox ShowGridCheckbox;
    private JCheckBox ShowPinCheckbox;
    private JCheckBox ShowReactiveCheckbox;
    private JButton btnGrid;
    private JButton btnHydro;
    private JButton btnMarket;
    private JButton btnOK;
    private JButton btnPower;
    private JButton btnTextCaption;
    private JButton btnTextLabel;
    private JComboBox cbLanguage;
    private JComboBox cbTextSize;
    private JComboBox cboChoiceOwner;
    private JComboBox cboColorStyle;
    private JComboBox cboDailyToolsDB;
    private JComboBox cboDeepDB;
    private JComboBox cboIconSize;
    private JComboBox cboYearlyToolsDB;
    private JCheckBox chkHighLightPin;
    private JCheckBox chkNavigateWhenClick;
    private JCheckBox chkPrintConnWarning;
    private JCheckBox chkUseDeepDB;
    private JCheckBox chkUseOldCompWindow;
    private JLabel jLabel1;
    private JLabel jLabel11;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel lbDailyTooldsBD;
    private JLabel lbPagelHeight;
    private JLabel lbYearlyTooldsBD;
    private JLabel lblColorStyle;
    private JLabel lblDeepDB;
    private JLabel lblIconSize;
    private JLabel lblMaxPageHeight;
    private JLabel lblMaxPageWidth;
    private JLabel lblMyChoiceOwner;
    private JLabel lblPageWidth;
    private JList lstOptions;
    private JPanel pnlAdvance;
    private JPanel pnlDimension;
    private JPanel pnlGrid;
    private JPanel pnlHydro;
    private JPanel pnlMarket;
    private JPanel pnlOptions;
    private JPanel pnlPower;
    private JPanel pnlTextCaption;
    private JPanel pnlTextLabel;
    private JScrollPane scrOptions;
    private JFormattedTextField txtPageHeight;
    private JFormattedTextField txtPageWidth;

    public DeepEditOptionsJDialog(DeepEdit app, Frame parent, boolean modal) {
        super(parent, modal);
        this.MyDeepEdit = app;
        this.initComponents();
        this.lstOptions.setSelectedIndex(0);
        this.initProperties();
    }

    private void initComponents() {
        this.scrOptions = new JScrollPane();
        this.lstOptions = new JList();
        this.ConfirmPanel = new JPanel();
        this.btnOK = new JButton();
        this.pnlOptions = new JPanel();
        this.GeneralPanel = new JPanel();
        this.ShowGridCheckbox = new JCheckBox();
        this.ShowAliasCheckbox = new JCheckBox();
        this.ShowReactiveCheckbox = new JCheckBox();
        this.ShowPinCheckbox = new JCheckBox();
        this.chkHighLightPin = new JCheckBox();
        this.chkPrintConnWarning = new JCheckBox();
        this.lblIconSize = new JLabel();
        this.cboIconSize = new JComboBox();
        this.ColorlPanel = new JPanel();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.btnPower = new JButton();
        this.pnlPower = new JPanel();
        this.pnlMarket = new JPanel();
        this.btnMarket = new JButton();
        this.btnHydro = new JButton();
        this.pnlHydro = new JPanel();
        this.pnlGrid = new JPanel();
        this.btnGrid = new JButton();
        this.pnlTextCaption = new JPanel();
        this.btnTextCaption = new JButton();
        this.jLabel6 = new JLabel();
        this.pnlTextLabel = new JPanel();
        this.btnTextLabel = new JButton();
        this.lblColorStyle = new JLabel();
        this.cboColorStyle = new JComboBox();
        this.LanguagePanel = new JPanel();
        this.cbLanguage = new JComboBox();
        this.jLabel7 = new JLabel();
        this.jLabel11 = new JLabel();
        this.cbTextSize = new JComboBox();
        this.jLabel8 = new JLabel();
        this.DatabasePanel = new JPanel();
        this.chkUseDeepDB = new JCheckBox();
        this.lblDeepDB = new JLabel();
        this.cboDeepDB = new JComboBox();
        this.lbDailyTooldsBD = new JLabel();
        this.cboDailyToolsDB = new JComboBox();
        this.lbYearlyTooldsBD = new JLabel();
        this.cboYearlyToolsDB = new JComboBox();
        this.pnlDimension = new JPanel();
        this.lblPageWidth = new JLabel();
        this.lbPagelHeight = new JLabel();
        this.lblMaxPageWidth = new JLabel();
        this.lblMaxPageHeight = new JLabel();
        this.lblMyChoiceOwner = new JLabel();
        this.cboChoiceOwner = new JComboBox();
        this.txtPageWidth = new JFormattedTextField();
        this.txtPageHeight = new JFormattedTextField();
        this.pnlAdvance = new JPanel();
        this.chkNavigateWhenClick = new JCheckBox();
        this.chkUseOldCompWindow = new JCheckBox();
        this.setDefaultCloseOperation(2);
        this.setTitle("Deep-Editor Options");
        this.lstOptions.setModel(new AbstractListModel(){
            String[] strings = new String[]{"General", "Color", "Language", "Database", "Page_Size", "Advanced"};

            @Override
            public int getSize() {
                return this.strings.length;
            }

            @Override
            public Object getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.lstOptions.setSelectionMode(0);
        this.lstOptions.setToolTipText("");
        this.lstOptions.setRequestFocusEnabled(false);
        this.lstOptions.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                DeepEditOptionsJDialog.this.SelectedOption(evt);
            }
        });
        this.scrOptions.setViewportView(this.lstOptions);
        this.btnOK.setText("OK");
        this.btnOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DeepEditOptionsJDialog.this.btnOKActionPerformed(evt);
            }
        });
        GroupLayout ConfirmPanelLayout = new GroupLayout(this.ConfirmPanel);
        this.ConfirmPanel.setLayout(ConfirmPanelLayout);
        ConfirmPanelLayout.setHorizontalGroup(ConfirmPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, ConfirmPanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.btnOK, -2, 67, -2).addContainerGap()));
        ConfirmPanelLayout.setVerticalGroup(ConfirmPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(ConfirmPanelLayout.createSequentialGroup().addComponent(this.btnOK).addContainerGap(-1, Short.MAX_VALUE)));
        this.pnlOptions.setLayout(new CardLayout());
        this.GeneralPanel.setBorder(BorderFactory.createTitledBorder(null, "General Settings", 2, 0, null, Color.blue));
        this.ShowGridCheckbox.setSelected(this.MyDeepEdit.ShowGrid);
        this.ShowGridCheckbox.setText("Show Grid in the Schematic");
        this.ShowAliasCheckbox.setSelected(DeepEdit.ShowAlias);
        this.ShowAliasCheckbox.setText("Show Alias in the Schematic");
        this.ShowReactiveCheckbox.setSelected(DeepEdit.MySchematic.ShowReactive);
        this.ShowReactiveCheckbox.setText("Show Reactive Power Flows in the Schematic");
        this.ShowPinCheckbox.setSelected(DeepEdit.ShowPins);
        this.ShowPinCheckbox.setText("Show Pins in Schematic");
        this.chkHighLightPin.setSelected(DeepEdit.HighLightPins);
        this.chkHighLightPin.setText("Highlight Pins when mouse-over");
        this.chkPrintConnWarning.setSelected(DeepEdit.PrintConnecWarnings);
        this.chkPrintConnWarning.setText("Print Connection Warnings");
        this.lblIconSize.setText("Toolbar Icons Size");
        this.cboIconSize.setModel(new DefaultComboBoxModel<String>(new String[]{"Small [24 pixels]", "Large [32 pixels]"}));
        GroupLayout GeneralPanelLayout = new GroupLayout(this.GeneralPanel);
        this.GeneralPanel.setLayout(GeneralPanelLayout);
        GeneralPanelLayout.setHorizontalGroup(GeneralPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GeneralPanelLayout.createSequentialGroup().addGap(30, 30, 30).addGroup(GeneralPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GeneralPanelLayout.createSequentialGroup().addComponent(this.lblIconSize).addGap(18, 18, 18).addComponent(this.cboIconSize, -2, 106, -2)).addComponent(this.chkPrintConnWarning).addComponent(this.chkHighLightPin).addComponent(this.ShowPinCheckbox).addComponent(this.ShowReactiveCheckbox).addComponent(this.ShowAliasCheckbox).addComponent(this.ShowGridCheckbox))));
        GeneralPanelLayout.setVerticalGroup(GeneralPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GeneralPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.ShowGridCheckbox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.ShowAliasCheckbox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.ShowReactiveCheckbox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.ShowPinCheckbox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.chkHighLightPin).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.chkPrintConnWarning).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 64, Short.MAX_VALUE).addGroup(GeneralPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cboIconSize, -2, -1, -2).addComponent(this.lblIconSize)).addContainerGap()));
        this.pnlOptions.add((Component)this.GeneralPanel, "general");
        this.ColorlPanel.setBorder(BorderFactory.createTitledBorder(null, "Color Settings", 2, 0, null, Color.blue));
        this.ColorlPanel.setPreferredSize(new Dimension(271, 201));
        this.jLabel1.setText("Power Editor Background:");
        this.jLabel2.setText("Grid:");
        this.jLabel3.setText("Caption Text:");
        this.jLabel3.setToolTipText("This is the text color for Captions (Special Text Objects)");
        this.jLabel4.setText("Hydro Background:");
        this.jLabel5.setText("Market Background:");
        this.btnPower.setFont(new Font("Tahoma", 0, 8));
        this.btnPower.setText("Browse");
        this.btnPower.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DeepEditOptionsJDialog.this.btnPowerActionPerformed(evt);
            }
        });
        this.pnlPower.setBackground(Color.blue);
        this.pnlPower.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        GroupLayout pnlPowerLayout = new GroupLayout(this.pnlPower);
        this.pnlPower.setLayout(pnlPowerLayout);
        pnlPowerLayout.setHorizontalGroup(pnlPowerLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 10, Short.MAX_VALUE));
        pnlPowerLayout.setVerticalGroup(pnlPowerLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 10, Short.MAX_VALUE));
        this.pnlMarket.setBackground(Color.blue);
        this.pnlMarket.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        GroupLayout pnlMarketLayout = new GroupLayout(this.pnlMarket);
        this.pnlMarket.setLayout(pnlMarketLayout);
        pnlMarketLayout.setHorizontalGroup(pnlMarketLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 10, Short.MAX_VALUE));
        pnlMarketLayout.setVerticalGroup(pnlMarketLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 10, Short.MAX_VALUE));
        this.btnMarket.setFont(new Font("Tahoma", 0, 8));
        this.btnMarket.setText("Browse");
        this.btnMarket.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DeepEditOptionsJDialog.this.btnMarketActionPerformed(evt);
            }
        });
        this.btnHydro.setFont(new Font("Tahoma", 0, 8));
        this.btnHydro.setText("Browse");
        this.btnHydro.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DeepEditOptionsJDialog.this.btnHydroActionPerformed(evt);
            }
        });
        this.pnlHydro.setBackground(Color.blue);
        this.pnlHydro.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        GroupLayout pnlHydroLayout = new GroupLayout(this.pnlHydro);
        this.pnlHydro.setLayout(pnlHydroLayout);
        pnlHydroLayout.setHorizontalGroup(pnlHydroLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 10, Short.MAX_VALUE));
        pnlHydroLayout.setVerticalGroup(pnlHydroLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 10, Short.MAX_VALUE));
        this.pnlGrid.setBackground(Color.blue);
        this.pnlGrid.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        GroupLayout pnlGridLayout = new GroupLayout(this.pnlGrid);
        this.pnlGrid.setLayout(pnlGridLayout);
        pnlGridLayout.setHorizontalGroup(pnlGridLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 10, Short.MAX_VALUE));
        pnlGridLayout.setVerticalGroup(pnlGridLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 10, Short.MAX_VALUE));
        this.btnGrid.setFont(new Font("Tahoma", 0, 8));
        this.btnGrid.setText("Browse");
        this.btnGrid.setEnabled(false);
        this.pnlTextCaption.setBackground(Color.blue);
        this.pnlTextCaption.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        GroupLayout pnlTextCaptionLayout = new GroupLayout(this.pnlTextCaption);
        this.pnlTextCaption.setLayout(pnlTextCaptionLayout);
        pnlTextCaptionLayout.setHorizontalGroup(pnlTextCaptionLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 10, Short.MAX_VALUE));
        pnlTextCaptionLayout.setVerticalGroup(pnlTextCaptionLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 10, Short.MAX_VALUE));
        this.btnTextCaption.setFont(new Font("Tahoma", 0, 8));
        this.btnTextCaption.setText("Browse");
        this.btnTextCaption.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DeepEditOptionsJDialog.this.btnTextCaptionActionPerformed(evt);
            }
        });
        this.jLabel6.setText("Component Labels:");
        this.jLabel6.setToolTipText("This is the color of the component's text name or alias");
        this.pnlTextLabel.setBackground(Color.blue);
        this.pnlTextLabel.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        GroupLayout pnlTextLabelLayout = new GroupLayout(this.pnlTextLabel);
        this.pnlTextLabel.setLayout(pnlTextLabelLayout);
        pnlTextLabelLayout.setHorizontalGroup(pnlTextLabelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 10, Short.MAX_VALUE));
        pnlTextLabelLayout.setVerticalGroup(pnlTextLabelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 10, Short.MAX_VALUE));
        this.btnTextLabel.setFont(new Font("Tahoma", 0, 8));
        this.btnTextLabel.setText("Browse");
        this.btnTextLabel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DeepEditOptionsJDialog.this.btnTextLabelActionPerformed(evt);
            }
        });
        this.lblColorStyle.setText("Schematic Style:");
        this.cboColorStyle.setModel(new DefaultComboBoxModel<String>(new String[]{"Style"}));
        GroupLayout ColorlPanelLayout = new GroupLayout(this.ColorlPanel);
        this.ColorlPanel.setLayout(ColorlPanelLayout);
        ColorlPanelLayout.setHorizontalGroup(ColorlPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(ColorlPanelLayout.createSequentialGroup().addGap(30, 30, 30).addGroup(ColorlPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(ColorlPanelLayout.createSequentialGroup().addComponent(this.jLabel4).addContainerGap(-1, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, ColorlPanelLayout.createSequentialGroup().addGroup(ColorlPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(ColorlPanelLayout.createSequentialGroup().addComponent(this.lblColorStyle).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.cboColorStyle, -2, 100, -2)).addGroup(ColorlPanelLayout.createSequentialGroup().addGroup(ColorlPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel3).addComponent(this.jLabel5).addComponent(this.jLabel1).addComponent(this.jLabel2).addComponent(this.jLabel6)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 44, Short.MAX_VALUE).addGroup(ColorlPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addGroup(ColorlPanelLayout.createSequentialGroup().addComponent(this.pnlTextCaption, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnTextCaption, -2, 20, -2)).addGroup(GroupLayout.Alignment.LEADING, ColorlPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(ColorlPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(ColorlPanelLayout.createSequentialGroup().addComponent(this.pnlPower, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnPower, -2, 20, -2)).addGroup(GroupLayout.Alignment.TRAILING, ColorlPanelLayout.createSequentialGroup().addComponent(this.pnlHydro, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnHydro, -2, 20, -2))).addGroup(ColorlPanelLayout.createSequentialGroup().addComponent(this.pnlMarket, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnMarket, -2, 20, -2)).addGroup(GroupLayout.Alignment.LEADING, ColorlPanelLayout.createSequentialGroup().addComponent(this.pnlGrid, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnGrid, -2, 20, -2))).addGroup(ColorlPanelLayout.createSequentialGroup().addComponent(this.pnlTextLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnTextLabel, -2, 20, -2))))).addGap(41, 41, 41)))));
        ColorlPanelLayout.setVerticalGroup(ColorlPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(ColorlPanelLayout.createSequentialGroup().addContainerGap().addGroup(ColorlPanelLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.btnPower).addComponent(this.pnlPower, -2, -1, -2).addComponent(this.jLabel1)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(ColorlPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(ColorlPanelLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.pnlMarket, -2, -1, -2).addComponent(this.btnMarket)).addComponent(this.jLabel5)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(ColorlPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel4).addGroup(ColorlPanelLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.pnlHydro, -2, -1, -2).addComponent(this.btnHydro))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(ColorlPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(ColorlPanelLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.pnlGrid, -2, -1, -2).addComponent(this.btnGrid)).addComponent(this.jLabel2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(ColorlPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel3).addGroup(ColorlPanelLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.pnlTextCaption, -2, -1, -2).addComponent(this.btnTextCaption))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(ColorlPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel6).addGroup(ColorlPanelLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.pnlTextLabel, -2, -1, -2).addComponent(this.btnTextLabel))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 54, Short.MAX_VALUE).addGroup(ColorlPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblColorStyle).addComponent(this.cboColorStyle, -2, -1, -2)).addContainerGap()));
        this.pnlOptions.add((Component)this.ColorlPanel, "color");
        this.LanguagePanel.setBorder(BorderFactory.createTitledBorder(null, "Language Settings", 2, 0, null, Color.blue));
        this.LanguagePanel.setPreferredSize(new Dimension(271, 201));
        this.cbLanguage.setModel(new DefaultComboBoxModel<String>(new String[]{"English", "Spanish"}));
        this.jLabel7.setText("Editor Language:");
        this.jLabel11.setText("Text size:");
        this.cbTextSize.setModel(new DefaultComboBoxModel<String>(new String[]{"Small", "Medium", "Large"}));
        this.jLabel8.setFont(new Font("Tahoma", 0, 8));
        this.jLabel8.setForeground(new Color(204, 0, 0));
        this.jLabel8.setText("[Requires restart]");
        GroupLayout LanguagePanelLayout = new GroupLayout(this.LanguagePanel);
        this.LanguagePanel.setLayout(LanguagePanelLayout);
        LanguagePanelLayout.setHorizontalGroup(LanguagePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, LanguagePanelLayout.createSequentialGroup().addGroup(LanguagePanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(LanguagePanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.jLabel8)).addGroup(LanguagePanelLayout.createSequentialGroup().addGap(24, 24, 24).addGroup(LanguagePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel7).addComponent(this.jLabel11)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 26, Short.MAX_VALUE).addGroup(LanguagePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.cbLanguage, -2, 106, -2).addComponent(this.cbTextSize, -2, 106, -2)))).addGap(39, 39, 39)));
        LanguagePanelLayout.setVerticalGroup(LanguagePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(LanguagePanelLayout.createSequentialGroup().addContainerGap().addGroup(LanguagePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel7, GroupLayout.Alignment.TRAILING).addComponent(this.cbLanguage, GroupLayout.Alignment.TRAILING, -2, -1, -2)).addGap(2, 2, 2).addComponent(this.jLabel8).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(LanguagePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel11, GroupLayout.Alignment.TRAILING).addComponent(this.cbTextSize, GroupLayout.Alignment.TRAILING, -2, -1, -2)).addContainerGap(171, Short.MAX_VALUE)));
        this.pnlOptions.add((Component)this.LanguagePanel, "language");
        this.DatabasePanel.setBorder(BorderFactory.createTitledBorder(null, "Database Settings", 2, 0, null, Color.blue));
        this.chkUseDeepDB.setSelected(true);
        this.chkUseDeepDB.setText("Use DeepDB");
        this.chkUseDeepDB.setEnabled(false);
        this.lblDeepDB.setText("Static DB [Object]:");
        this.cboDeepDB.setModel(new DefaultComboBoxModel<String>(new String[]{"DeepDB.db", "DeepDB.mdb"}));
        this.cboDeepDB.setToolTipText("Requires restart for changes to take effect");
        this.lbDailyTooldsBD.setText("Daily Tools DB:");
        this.cboDailyToolsDB.setModel(new DefaultComboBoxModel<String>(new String[]{"TPDB.mdb"}));
        this.cboDailyToolsDB.setEnabled(false);
        this.lbYearlyTooldsBD.setText("Yearly Tools DB:");
        this.cboYearlyToolsDB.setModel(new DefaultComboBoxModel<String>(new String[]{"TPDB3.3.mdb", "TPDB.mdb", "TPDB.sqlite"}));
        GroupLayout DatabasePanelLayout = new GroupLayout(this.DatabasePanel);
        this.DatabasePanel.setLayout(DatabasePanelLayout);
        DatabasePanelLayout.setHorizontalGroup(DatabasePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(DatabasePanelLayout.createSequentialGroup().addGap(22, 22, 22).addGroup(DatabasePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.chkUseDeepDB).addComponent(this.lblDeepDB, -2, 104, -2).addComponent(this.lbDailyTooldsBD, -2, 107, -2).addComponent(this.lbYearlyTooldsBD, -2, 107, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(DatabasePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.cboYearlyToolsDB, -2, 106, -2).addComponent(this.cboDailyToolsDB, -2, 106, -2).addComponent(this.cboDeepDB, -2, 106, -2)).addContainerGap(32, Short.MAX_VALUE)));
        DatabasePanelLayout.setVerticalGroup(DatabasePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(DatabasePanelLayout.createSequentialGroup().addContainerGap().addComponent(this.chkUseDeepDB).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(DatabasePanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblDeepDB).addComponent(this.cboDeepDB, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(DatabasePanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lbDailyTooldsBD).addComponent(this.cboDailyToolsDB, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(DatabasePanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lbYearlyTooldsBD).addComponent(this.cboYearlyToolsDB, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.pnlOptions.add((Component)this.DatabasePanel, "database");
        this.pnlDimension.setBorder(BorderFactory.createTitledBorder(null, "Page Dimension", 2, 0, null, Color.blue));
        this.lblPageWidth.setText("Width:");
        this.lbPagelHeight.setText("Height:");
        this.lblMaxPageWidth.setText("[max 2000]");
        this.lblMaxPageHeight.setText("[max 8000]");
        this.lblMyChoiceOwner.setText("Select Focus Owner:");
        this.cboChoiceOwner.setModel(new DefaultComboBoxModel<String>(new String[]{"NO FOCUS"}));
        this.txtPageWidth.setFormatterFactory(new DefaultFormatterFactory(new NumberFormatter(new DecimalFormat("#0"))));
        this.txtPageWidth.setText("2000");
        this.txtPageHeight.setFormatterFactory(new DefaultFormatterFactory(new NumberFormatter(new DecimalFormat("#0"))));
        this.txtPageHeight.setText("8000");
        GroupLayout pnlDimensionLayout = new GroupLayout(this.pnlDimension);
        this.pnlDimension.setLayout(pnlDimensionLayout);
        pnlDimensionLayout.setHorizontalGroup(pnlDimensionLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlDimensionLayout.createSequentialGroup().addGap(28, 28, 28).addGroup(pnlDimensionLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlDimensionLayout.createSequentialGroup().addComponent(this.lblMyChoiceOwner).addGap(18, 18, 18).addComponent(this.cboChoiceOwner, -2, 106, -2).addContainerGap(-1, Short.MAX_VALUE)).addGroup(pnlDimensionLayout.createSequentialGroup().addGroup(pnlDimensionLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.lblPageWidth, -1, -1, Short.MAX_VALUE).addComponent(this.lbPagelHeight, -1, 72, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(pnlDimensionLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.txtPageWidth, -2, 92, -2).addComponent(this.txtPageHeight, -2, 92, -2)).addGap(21, 21, 21).addGroup(pnlDimensionLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblMaxPageWidth).addComponent(this.lblMaxPageHeight)).addGap(82, 82, 82)))));
        pnlDimensionLayout.setVerticalGroup(pnlDimensionLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlDimensionLayout.createSequentialGroup().addGap(20, 20, 20).addGroup(pnlDimensionLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblPageWidth).addComponent(this.lblMaxPageWidth).addComponent(this.txtPageWidth, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pnlDimensionLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lbPagelHeight).addComponent(this.lblMaxPageHeight).addComponent(this.txtPageHeight, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 143, Short.MAX_VALUE).addGroup(pnlDimensionLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblMyChoiceOwner, GroupLayout.Alignment.TRAILING).addComponent(this.cboChoiceOwner, GroupLayout.Alignment.TRAILING, -2, -1, -2)).addContainerGap()));
        this.pnlOptions.add((Component)this.pnlDimension, "dimension");
        this.pnlAdvance.setBorder(BorderFactory.createTitledBorder(null, "General Settings", 2, 0, null, Color.blue));
        this.chkNavigateWhenClick.setSelected(this.MyDeepEdit.ShowGrid);
        this.chkNavigateWhenClick.setText("Navigate Schematic when click on Tree");
        this.chkUseOldCompWindow.setSelected(DeepEdit.ShowAlias);
        this.chkUseOldCompWindow.setText("Show 'old' Parameter Component Window");
        GroupLayout pnlAdvanceLayout = new GroupLayout(this.pnlAdvance);
        this.pnlAdvance.setLayout(pnlAdvanceLayout);
        pnlAdvanceLayout.setHorizontalGroup(pnlAdvanceLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlAdvanceLayout.createSequentialGroup().addGap(30, 30, 30).addGroup(pnlAdvanceLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.chkUseOldCompWindow).addComponent(this.chkNavigateWhenClick)).addGap(16, 16, 16)));
        pnlAdvanceLayout.setVerticalGroup(pnlAdvanceLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlAdvanceLayout.createSequentialGroup().addContainerGap().addComponent(this.chkNavigateWhenClick).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.chkUseOldCompWindow).addContainerGap(187, Short.MAX_VALUE)));
        this.pnlOptions.add((Component)this.pnlAdvance, "advanced");
        this.pnlAdvance.getAccessibleContext().setAccessibleName("Advanced Settings");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.ConfirmPanel, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.scrOptions, -2, 105, -2).addGap(18, 18, 18).addComponent(this.pnlOptions, -2, 289, -2).addContainerGap(-1, Short.MAX_VALUE)))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.pnlOptions, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGap(6, 6, 6).addComponent(this.scrOptions))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.ConfirmPanel, -2, -1, -2)));
        this.pack();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void btnOKActionPerformed(ActionEvent evt) {
        try {
            this.setProperties();
        }
        catch (Exception e) {
            System.err.println("Error closing DE Option window: " + e.getMessage());
        }
        finally {
            this.dispose();
        }
    }

    private void SelectedOption(ListSelectionEvent evt) {
        this.selectPanel(this.lstOptions.getSelectedIndex());
    }

    private void btnTextLabelActionPerformed(ActionEvent evt) {
        Color newColor = JColorChooser.showDialog(this, "Color for Components Labels", this.pnlTextLabel.getBackground());
        if (newColor != null) {
            this.pnlTextLabel.setBackground(newColor);
        }
    }

    private void btnTextCaptionActionPerformed(ActionEvent evt) {
        Color newColor = JColorChooser.showDialog(this, "Caption Color", this.pnlTextCaption.getBackground());
        if (newColor != null) {
            this.pnlTextCaption.setBackground(newColor);
        }
    }

    private void btnHydroActionPerformed(ActionEvent evt) {
        Color newColor = JColorChooser.showDialog(this, "Hydro Editor Background", this.pnlHydro.getBackground());
        if (newColor != null) {
            this.pnlHydro.setBackground(newColor);
        }
    }

    private void btnMarketActionPerformed(ActionEvent evt) {
        Color newColor = JColorChooser.showDialog(this, "Market Editor Background", this.pnlMarket.getBackground());
        if (newColor != null) {
            this.pnlMarket.setBackground(newColor);
        }
    }

    private void btnPowerActionPerformed(ActionEvent evt) {
        Color newColor = JColorChooser.showDialog(this, "Power Editor Background", this.pnlPower.getBackground());
        if (newColor != null) {
            this.pnlPower.setBackground(newColor);
        }
    }

    private void selectPanel(int index) {
        CardLayout card = (CardLayout)this.pnlOptions.getLayout();
        switch (index) {
            case 0: {
                card.show(this.pnlOptions, "general");
                break;
            }
            case 1: {
                card.show(this.pnlOptions, "color");
                break;
            }
            case 2: {
                card.show(this.pnlOptions, "language");
                break;
            }
            case 3: {
                card.show(this.pnlOptions, "database");
                break;
            }
            case 4: {
                card.show(this.pnlOptions, "dimension");
                break;
            }
            case 5: {
                card.show(this.pnlOptions, "advanced");
            }
        }
    }

    private void initProperties() {
        int nIconSize = this.MyDeepEdit.getToolbarIconSize();
        if (nIconSize == 24) {
            this.cboIconSize.setSelectedIndex(0);
        } else if (nIconSize == 32) {
            this.cboIconSize.setSelectedIndex(1);
        } else assert (false) : "Why you are trying a different unsopported icon size? Size: " + nIconSize;
        DE_GeneralEnums.Language lg = DeepEdit.getEditorLanguage();
        this.cbLanguage.setSelectedItem(lg.toString());
        DE_GeneralEnums.FontSize fs = DeepEdit.getFontSize();
        if (fs != null) {
            this.cbTextSize.setSelectedItem(fs.toString());
        }
        this.pnlPower.setBackground(DeepEdit.getPowerEditorColor());
        this.pnlMarket.setBackground(DeepEdit.getMarketEditorColor());
        this.pnlHydro.setBackground(DeepEdit.getHydroEditorColor());
        this.pnlGrid.setBackground(DeepEdit.getGridColor());
        this.pnlTextCaption.setBackground(DeepEdit.getDefaultCaptionColor());
        this.pnlTextLabel.setBackground(DeepEdit.getDefaultLabelTextColor());
        this.cboColorStyle.removeAllItems();
        for (DE_GeneralEnums.VoltageColorStyle cvs : DE_GeneralEnums.VoltageColorStyle.values()) {
            this.cboColorStyle.addItem(cvs);
        }
        this.cboColorStyle.setSelectedItem((Object)DeepEdit.getVoltageColorStyle());
        this.cboDeepDB.setSelectedItem(DeepEdit.getDeepDBName());
        this.cboDailyToolsDB.setSelectedItem(DeepEdit.getDailyDBName());
        this.cboYearlyToolsDB.setSelectedItem(DeepEdit.getYearlyDBName());
        this.txtPageWidth.setValue(DeepEdit.getMaxXPoints());
        this.txtPageHeight.setValue(DeepEdit.getMaxYPoints());
        this.chkNavigateWhenClick.setSelected(DeepEdit.getBooleanOptionValue("NavWhenSelected"));
        this.chkUseOldCompWindow.setSelected(DeepEdit.getBooleanOptionValue("UseOldComponentGUI"));
    }

    private void setProperties() {
        int GridStep = DeepEdit.getGridStep();
        this.MyDeepEdit.ShowGrid = this.ShowGridCheckbox.isSelected();
        DeepEdit.ShowPins = this.ShowPinCheckbox.isSelected();
        DeepEdit.ShowAlias = this.ShowAliasCheckbox.isSelected();
        if (this.MyDeepEdit.ShowGrid) {
            this.MyDeepEdit.SetUpImages(GridStep);
        }
        DeepEdit.MySchematic.ShowReactive = this.ShowReactiveCheckbox.isSelected();
        DeepEdit.HighLightPins = this.chkHighLightPin.isSelected();
        DeepEdit.PrintConnecWarnings = this.chkPrintConnWarning.isSelected();
        if (this.cboIconSize.getSelectedIndex() == 0) {
            this.MyDeepEdit.setToolbarIconSize(24);
        } else if (this.cboIconSize.getSelectedIndex() == 1) {
            this.MyDeepEdit.setToolbarIconSize(32);
        }
        DeepEdit.setPowerEditorColor(this.pnlPower.getBackground());
        DeepEdit.setMarketEditorColor(this.pnlMarket.getBackground());
        DeepEdit.setHydroEditorColor(this.pnlHydro.getBackground());
        this.MyDeepEdit.setEditor(DeepEdit.getEditor());
        DeepEdit.setGridColor(this.pnlGrid.getBackground());
        DeepEdit.SetAllComponentsCaptionColor(this.pnlTextCaption.getBackground());
        DeepEdit.setDefaultLabelTextColor(this.pnlTextLabel.getBackground());
        DE_GeneralEnums.VoltageColorStyle oldStyle = DeepEdit.getVoltageColorStyle();
        DE_GeneralEnums.VoltageColorStyle newStyle = (DE_GeneralEnums.VoltageColorStyle)((Object)this.cboColorStyle.getSelectedItem());
        if (oldStyle != newStyle) {
            this.MyDeepEdit.setVoltageColorStyle(newStyle);
        }
        if (this.cbLanguage.getSelectedIndex() == 0) {
            this.MyDeepEdit.setEditorLanguage(DE_GeneralEnums.Language.English);
        } else {
            this.MyDeepEdit.setEditorLanguage(DE_GeneralEnums.Language.Spanish);
        }
        if (this.cbTextSize.getSelectedIndex() == 0) {
            this.MyDeepEdit.setFontSize(DE_GeneralEnums.FontSize.Small);
        } else if (this.cbTextSize.getSelectedIndex() == 1) {
            this.MyDeepEdit.setFontSize(DE_GeneralEnums.FontSize.Medium);
        } else {
            this.MyDeepEdit.setFontSize(DE_GeneralEnums.FontSize.Large);
        }
        DeepEdit.setDeepDBName(this.cboDeepDB.getSelectedItem().toString());
        DeepEdit.setDailyDBName(this.cboDailyToolsDB.getSelectedItem().toString());
        DeepEdit.setYearlyDBName(this.cboYearlyToolsDB.getSelectedItem().toString());
        DeepEdit.setMaxXPoints(Integer.parseInt(this.txtPageWidth.getValue().toString()));
        DeepEdit.setMaxYPoints(Integer.parseInt(this.txtPageHeight.getValue().toString()));
        DeepEdit.MySchematic.setfocusowner((String)this.cboChoiceOwner.getSelectedItem());
        DeepEdit.setOptionValue("NavWhenSelected", this.chkNavigateWhenClick.isSelected());
        DeepEdit.setOptionValue("UseOldComponentGUI", this.chkUseOldCompWindow.isSelected());
        DeepEdit.MySchematicPanel.repaint();
    }
}

