/*
 * Decompiled with CFR 0.152.
 */
package de.core;

import de.core.Constraint;
import de.core.DeepEdit;
import de.core.JImagePanel;
import de.core.JXParameterTreeTable;
import de.core.MessageTabPane;
import de.core.MyRenderer;
import de.core.SchematicPanel;
import de.core.Simulation;
import de.core.comp;
import de.core.vsi.VSI_mainPanel;
import de.core.vsi.VSI_report;
import de.data.ParameterData;
import de.utils.ExcelUtil;
import de.utils.StringUtil;
import de.utils.Utils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellEditor;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jdesktop.swingx.JXTreeTable;

public class DeepEditMainPane
extends JPanel {
    public static final int COL_PARAMETER_NAME = 0;
    public static final int COL_PARAMETER_VALUE = 1;
    public static final int MIN_COLUMN_WIDTH = 0;
    public static final int MAX_COLUMN_WIDTH = 500;
    public static final String MAIN_COLUMN_NAME = "Name";
    public static final String OBJECT_COLUMN_NAME = "comp";
    private final DeepEdit myDeepEdit;
    private Icon folderImageIcon;
    private CellEditorListener lCellEdit;
    private JXParameterTreeTable jXTreeParameter;
    private int selectedDBViewColumn = -1;
    private comp selectedComp;
    private static Properties GUIProperties;
    private final ArrayList<comp> lDBViewComp = new ArrayList();
    private final ArrayList<String> lmsgTabs = new ArrayList();
    private final ArrayList<String> loutTabs = new ArrayList();
    private JPanel AppendDataTabPane;
    private JPanel DatabaseEditTabPane;
    private JPanel DatabaseViewTabPane;
    private JSplitPane MainEditorScrollPane;
    private JTree NavTree;
    private JSplitPane NavegationScrollPane;
    private JTabbedPane ObjectViewPane;
    private JTabbedPane OutputPane;
    private JPanel OutputTabPane;
    private JPanel OverviewPane;
    private JPanel PropertyTabPane;
    private JTabbedPane PropertyViewPane;
    private JPanel SchematicEditTabPane;
    private JTabbedPane SchematicPane;
    private JSplitPane WorkScrollPane;
    private JMenu chkHidden;
    private JMenuItem chkHide;
    private JCheckBoxMenuItem chkLock;
    private JMenuItem chkSelect;
    private JMenuItem chkShowAll;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane3;
    private JScrollPane jScrollPane4;
    private JScrollPane jScrollPane5;
    private JScrollPane jScrollPane6;
    private JScrollPane jScrollPane7;
    private JPopupMenu.Separator jspEdit;
    private JMenuItem menuTreeCopy;
    private JMenuItem menuTreeDelete;
    private JMenuItem menuTreeNew;
    private JMenuItem menuTreePaste;
    private JMenuItem menuTreeProperties;
    private JMenuItem menuTreeRename;
    private JPopupMenu popDBViewHeader;
    private JPopupMenu popTreeView;
    private JTable tblDatabaseEdit;
    private JTextArea txtMainOutputArea;

    public DeepEditMainPane(DeepEdit myDeepEdit) {
        this.myDeepEdit = myDeepEdit;
        this.initComponents();
        this.initNavTree();
        this.iniTreeTableProperty();
        this.iniDBViewTable();
    }

    private void initNavTree() {
        if (this.folderImageIcon == null) {
            this.folderImageIcon = new ImageIcon(this.getClass().getResource("/images/g_16x-folder_closed.gif"));
        }
        this.NavTree.setCellRenderer(new MyRenderer(this.folderImageIcon));
    }

    private void iniTreeTableProperty() {
        this.jXTreeParameter = (JXParameterTreeTable)DeepEditMainPane.createParameterTable(this.selectedComp);
        this.jXTreeParameter.getTreeTableModel().addTreeModelListener(new TreeModelListener(){

            @Override
            public void treeNodesChanged(TreeModelEvent e) {
                DeepEditMainPane.this.jXTreeParameterValueChanged(e);
            }

            @Override
            public void treeNodesInserted(TreeModelEvent e) {
            }

            @Override
            public void treeNodesRemoved(TreeModelEvent e) {
            }

            @Override
            public void treeStructureChanged(TreeModelEvent e) {
            }
        });
        this.jScrollPane3.setViewportView((Component)((Object)this.jXTreeParameter));
    }

    private void iniDBViewTable() {
        this.tblDatabaseEdit.getTableHeader().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                DeepEditMainPane.this.showDBViewHeaderPopup(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                DeepEditMainPane.this.showDBViewHeaderPopup(e);
            }
        });
        this.tblDatabaseEdit.getModel().addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                int nFirstRow = e.getFirstRow();
                int nColumn = e.getColumn();
                int nType = e.getType();
                if (nType == 0 && nFirstRow != -1 && nColumn != -1) {
                    TableModel model = (TableModel)e.getSource();
                    Object edit_data = model.getValueAt(nFirstRow, nColumn);
                    String edit_parameterName = model.getColumnName(nColumn);
                    comp edit_comp = DeepEditMainPane.this.getCompInDBViewRow(nFirstRow);
                    if (!DeepEditMainPane.this.setParameterInfo(edit_comp, edit_parameterName, edit_data.toString())) {
                        throw new NumberFormatException("Unsupported value '" + edit_data + "' for parameter " + edit_parameterName + ". Object " + edit_comp.getName() + " wasn't updated");
                    }
                }
                if (nType == -1) {
                    // empty if block
                }
                if (nType == 1) {
                    // empty if block
                }
            }
        });
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                DeepEditMainPane.this.pasteInDBView();
            }
        };
        KeyStroke stroke = KeyStroke.getKeyStroke(86, 2, false);
        this.tblDatabaseEdit.registerKeyboardAction(listener, "Paste", stroke, 0);
        try {
            DeepEditMainPane.loadGUIPropetyFile();
        }
        catch (IOException ex) {
            System.err.println("Error loading gui-config file: " + ex.getMessage());
        }
    }

    private static void loadGUIPropetyFile() throws FileNotFoundException, IOException {
        String strfileGUIProperties = DeepEdit.getGUIConfigFileFullPath();
        File fileGUIProperties = new File(strfileGUIProperties);
        GUIProperties = new Properties();
        if (fileGUIProperties.exists()) {
            FileInputStream in = new FileInputStream(fileGUIProperties);
            GUIProperties.loadFromXML(in);
            in.close();
        }
    }

    public static void saveGUIPropertyFile() throws FileNotFoundException, IOException {
        String strfileGUIProperties = DeepEdit.getGUIConfigFileFullPath();
        FileOutputStream out = new FileOutputStream(strfileGUIProperties);
        GUIProperties.storeToXML(out, "---DEEP-EDITOR GUI FILE---");
        out.close();
    }

    public static String getOptionValue(String property) {
        if (GUIProperties == null) {
            return null;
        }
        return GUIProperties.getProperty(property);
    }

    public static void setOptionValue(String key, String propertyValue) {
        if (GUIProperties != null && key != null && propertyValue != null) {
            GUIProperties.setProperty(key, propertyValue);
        }
    }

    public static void removeOptionValue(String key) {
        if (GUIProperties != null && key != null) {
            GUIProperties.remove(key);
        }
    }

    private void setBDViewHeader(String className) {
    }

    private void setDBViewHeader(String[] header) {
        if (header == null) {
            return;
        }
        if (header.length == 0) {
            this.addColumnToDBView("Parameter");
        } else {
            for (String s : header) {
                this.addColumnToDBView(s);
            }
        }
    }

    private void addColumnToDBView(String sColumnName) {
        DefaultTableModel model = (DefaultTableModel)this.tblDatabaseEdit.getModel();
        TableColumn col = new TableColumn(this.tblDatabaseEdit.getColumnModel().getColumnCount());
        col.setHeaderValue(sColumnName);
        col.setIdentifier(sColumnName);
        col.setMaxWidth(500);
        this.tblDatabaseEdit.getColumnModel().addColumn(col);
        model.addColumn(sColumnName);
    }

    private void adjustDBViewColumnWidth() {
        TableColumnModel columnModel = this.tblDatabaseEdit.getColumnModel();
        for (int col = 0; col < this.tblDatabaseEdit.getColumnCount(); ++col) {
            int maxWidth = 0;
            TableColumn column = columnModel.getColumn(col);
            TableCellRenderer headerRenderer = column.getHeaderRenderer();
            if (headerRenderer == null) {
                headerRenderer = this.tblDatabaseEdit.getTableHeader().getDefaultRenderer();
            }
            Object headerValue = column.getHeaderValue();
            Component headerComp = headerRenderer.getTableCellRendererComponent(this.tblDatabaseEdit, headerValue, false, false, 0, col);
            if (MAIN_COLUMN_NAME.equals(headerValue.toString())) {
                maxWidth = this.getDBViewMaxColumnWidth(col);
            } else if (OBJECT_COLUMN_NAME.equals(headerValue.toString())) {
                column.setMinWidth(0);
                column.setMaxWidth(0);
            }
            maxWidth = Math.max(maxWidth, headerComp.getPreferredSize().width);
            column.setPreferredWidth(maxWidth + 6);
        }
    }

    private int getDBViewMaxColumnWidth(int nCol) {
        int maxWidth = 0;
        for (int row = 0; row < this.tblDatabaseEdit.getRowCount(); ++row) {
            TableCellRenderer rend = this.tblDatabaseEdit.getCellRenderer(row, nCol);
            Object value = this.tblDatabaseEdit.getValueAt(row, nCol);
            Component comp2 = rend.getTableCellRendererComponent(this.tblDatabaseEdit, value, false, false, row, nCol);
            maxWidth = Math.max(comp2.getPreferredSize().width, maxWidth);
        }
        return maxWidth;
    }

    private void hideDBViewColumns() {
        for (String s : this.getCurrentHiddenColumns()) {
            this.hideDBViewColumn(s);
        }
    }

    private List<String> getMustHideColumns(String className) {
        ArrayList<String> lHidden = new ArrayList<String>();
        List<String> lParameters = DeepEdit.getParameterNameList(className);
        for (String s : lParameters) {
            if (DeepEdit.isParameterShowInGUI(className, s)) continue;
            lHidden.add(s);
        }
        return lHidden;
    }

    private String[] getHiddenColumns(String className) {
        LinkedHashSet<String> lHidden = new LinkedHashSet<String>(this.getMustHideColumns(className));
        assert (className != null) : "Why are you passing a null argument??";
        for (String s : GUIProperties.stringPropertyNames()) {
            String possibleClassName;
            String[] line = s.split("/");
            if (line.length != 2 || !line[0].contains("hide_") || !(possibleClassName = line[0].replaceFirst("hide_", "")).equalsIgnoreCase(className) || !Boolean.parseBoolean(DeepEditMainPane.getOptionValue(s))) continue;
            lHidden.add(line[1]);
        }
        return lHidden.toArray(new String[lHidden.size()]);
    }

    private String[] getCurrentHiddenColumns() {
        String className = this.getSelectedClassName();
        if (className != null) {
            return this.getHiddenColumns(className);
        }
        return new String[0];
    }

    private boolean isColumnHidden(int nColumn) {
        String colName = this.tblDatabaseEdit.getColumnName(nColumn);
        if (OBJECT_COLUMN_NAME.equalsIgnoreCase(colName)) {
            return true;
        }
        List<String> col = Arrays.asList(this.getCurrentHiddenColumns());
        return col.contains(colName);
    }

    public void setCompInDBView(List<comp> lComp) {
        this.removeAllRowsFromDBView();
        this.removeAllColumnsFromDBView();
        boolean isFirstComp = true;
        for (comp c : lComp) {
            List<ParameterData> lData = c.getAllParametersInfo();
            if (isFirstComp) {
                String[] sHeader = new String[lData.size() + 1];
                for (int i = 0; i < lData.size(); ++i) {
                    sHeader[i] = lData.get((int)i).Name;
                }
                sHeader[lData.size()] = OBJECT_COLUMN_NAME;
                this.setDBViewHeader(sHeader);
                isFirstComp = false;
            }
            this.addCompToDBView(c);
        }
        this.adjustDBViewColumnWidth();
        this.hideDBViewColumns();
    }

    public void addCompToDBView(comp oComp) {
        List<ParameterData> lData = oComp.getAllParametersInfo();
        int nTotalRows = lData.size() + 1;
        Object[] rowData = new Object[nTotalRows];
        for (ParameterData pData : lData) {
            int nCol = this.tblDatabaseEdit.getColumnModel().getColumnIndex(pData.Name);
            rowData[nCol] = pData.getValue();
        }
        rowData[nTotalRows - 1] = oComp;
        if (rowData.length > 0) {
            DefaultTableModel model = (DefaultTableModel)this.tblDatabaseEdit.getModel();
            model.addRow(rowData);
            this.tblDatabaseEdit.setModel(model);
        }
    }

    public void removeAllRowsFromDBView() {
        DefaultTableModel model = (DefaultTableModel)this.tblDatabaseEdit.getModel();
        int rows = model.getRowCount();
        for (int i = rows - 1; i >= 0; --i) {
            model.removeRow(i);
        }
        this.tblDatabaseEdit.setModel(model);
    }

    public void removeAllColumnsFromDBView() {
        DefaultTableModel model = (DefaultTableModel)this.tblDatabaseEdit.getModel();
        model.setColumnCount(0);
        this.tblDatabaseEdit.setModel(model);
    }

    private void renameCompInNavTree() {
        TreePath path = this.NavTree.getSelectionPath();
        if (path != null) {
            this.NavTree.setEditable(true);
            this.NavTree.startEditingAtPath(path);
            if (this.lCellEdit != null) {
                this.NavTree.getCellEditor().removeCellEditorListener(this.lCellEdit);
            }
            this.lCellEdit = new CellEditorListener(){

                @Override
                public void editingStopped(ChangeEvent e) {
                    DefaultMutableTreeNode node;
                    DefaultTreeCellEditor editor2 = (DefaultTreeCellEditor)DeepEditMainPane.this.NavTree.getCellEditor();
                    Object o = editor2.getCellEditorValue();
                    if (DeepEditMainPane.this.NavTree.getSelectionPath() != null && o != null && (node = (DefaultMutableTreeNode)DeepEditMainPane.this.NavTree.getSelectionPath().getLastPathComponent()) != null && node.getUserObject() instanceof comp) {
                        comp editComp = (comp)node.getUserObject();
                        editComp.setName(o.toString());
                        node.setUserObject(editComp);
                    }
                    DeepEditMainPane.this.NavTree.setEditable(false);
                }

                @Override
                public void editingCanceled(ChangeEvent e) {
                }
            };
            DefaultTreeCellEditor editor2 = (DefaultTreeCellEditor)this.NavTree.getCellEditor();
            editor2.addCellEditorListener(this.lCellEdit);
        }
    }

    private void showDBViewHeaderPopup(MouseEvent evt) {
        int col = this.tblDatabaseEdit.columnAtPoint(evt.getPoint());
        int row = this.tblDatabaseEdit.rowAtPoint(evt.getPoint());
        String name = this.tblDatabaseEdit.getColumnName(col);
        String className = this.getSelectedClassName();
        if (className == null) {
            return;
        }
        this.chkHide.setEnabled(!MAIN_COLUMN_NAME.equalsIgnoreCase(name));
        if (evt.isPopupTrigger()) {
            this.selectedDBViewColumn = col;
            this.chkHidden.removeAll();
            for (String s : this.getHiddenColumns(className)) {
                JMenuItem myMenu = new JMenuItem(s);
                myMenu.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        JMenuItem me = (JMenuItem)e.getSource();
                        DeepEditMainPane.this.showDBViewColumn(me.getText());
                    }
                });
                this.chkHidden.add(myMenu);
            }
            this.popDBViewHeader.show(evt.getComponent(), evt.getX(), evt.getY());
        }
    }

    private void showNavTreePopup(MouseEvent evt) {
    }

    private String getSelectedClassName() {
        DefaultMutableTreeNode node;
        String navTreeClass = null;
        if (this.NavTree.getSelectionPath() != null && (node = (DefaultMutableTreeNode)this.NavTree.getSelectionPath().getLastPathComponent()) != null && !node.isRoot() && node.getParent().equals(this.NavTree.getModel().getRoot())) {
            navTreeClass = node.getUserObject().toString();
        }
        String DBViewClass = null;
        if (!this.lDBViewComp.isEmpty()) {
            DBViewClass = this.lDBViewComp.get(0).getClassName();
        }
        if (navTreeClass == null && DBViewClass == null) {
            return null;
        }
        if (navTreeClass != null && DBViewClass == null) {
            return navTreeClass;
        }
        if (navTreeClass == null && DBViewClass != null) {
            return DBViewClass;
        }
        if (navTreeClass != null && DBViewClass != null) {
            if (this.SchematicPane.getSelectedIndex() == 0) {
                return navTreeClass;
            }
            return DBViewClass;
        }
        return null;
    }

    private comp getSelectedCompInNavTree() {
        TreePath tp = this.NavTree.getSelectionPath();
        if (tp == null) {
            return null;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)tp.getLastPathComponent();
        if (node == null) {
            return null;
        }
        if (node.isRoot()) {
            return null;
        }
        if (node.isLeaf() && !node.getParent().equals(node.getRoot())) {
            return (comp)node.getUserObject();
        }
        return null;
    }

    private void setSelectedComp(comp DEcomp) {
        this.selectedComp = DEcomp;
        if (DEcomp != null) {
            if (DeepEdit.getBooleanOptionValue("NavWhenSelected") && DEcomp.isDrawnInSchematic()) {
                this.myDeepEdit.UserWantsAdjustSearchName(DEcomp.getName());
            }
            this.setParameterGUIValues(DEcomp);
        }
    }

    public comp getCompInDBViewRow(int nRowNumber) {
        if (nRowNumber >= 0 && nRowNumber < this.lDBViewComp.size() && this.tblDatabaseEdit.getColumnCount() > 0) {
            int nColNumber = this.tblDatabaseEdit.getColumnCount() - 1;
            String sColName = this.tblDatabaseEdit.getColumnName(nColNumber);
            Object o = this.tblDatabaseEdit.getModel().getValueAt(nRowNumber, nColNumber);
            assert (o instanceof comp) : "Last column should always be an instance to component!!. Why it is " + o + "??";
            assert (OBJECT_COLUMN_NAME.equals(sColName)) : "Last column should always be an instance to component!!. Why it is " + sColName + "??";
            return (comp)o;
        }
        return null;
    }

    private String getDBViewColumnName(String fullColumnName, String className) {
        String[] line = fullColumnName.split("/");
        if (line.length == 2 && line[0].contains(className) && Boolean.parseBoolean(DeepEditMainPane.getOptionValue(fullColumnName))) {
            return line[1];
        }
        return null;
    }

    private String getFullDBViewColumnName(String sColumnName) {
        if (this.lDBViewComp.size() > 0) {
            if (sColumnName == null) {
                int[] selectedColumns = this.tblDatabaseEdit.getColumnModel().getSelectedColumns();
                if (selectedColumns.length > 0) {
                    return this.lDBViewComp.get(0).getClassName() + "/" + this.tblDatabaseEdit.getColumnModel().getColumn(selectedColumns[0]).getHeaderValue();
                }
            } else {
                return this.lDBViewComp.get(0).getClassName() + "/" + sColumnName;
            }
        }
        return null;
    }

    private void hideDBViewColumn(String sColumnName) {
        String fullColumnName = this.getFullDBViewColumnName(sColumnName);
        if (fullColumnName == null) {
            return;
        }
        fullColumnName = "hide_" + fullColumnName;
        int columnIndex = this.tblDatabaseEdit.getColumnModel().getColumnIndex(sColumnName);
        this.tblDatabaseEdit.getColumnModel().getColumn(columnIndex).setMinWidth(0);
        this.tblDatabaseEdit.getColumnModel().getColumn(columnIndex).setMaxWidth(0);
        DeepEditMainPane.setOptionValue(fullColumnName, String.valueOf(true));
    }

    private void showDBViewColumn(String sColumnName) {
        int columnIndex = this.tblDatabaseEdit.getColumnModel().getColumnIndex(sColumnName);
        this.tblDatabaseEdit.getColumnModel().getColumn(columnIndex).setMinWidth(0);
        this.tblDatabaseEdit.getColumnModel().getColumn(columnIndex).setMaxWidth(500);
        String fullColumnName = this.getFullDBViewColumnName(sColumnName);
        if (fullColumnName == null) {
            return;
        }
        fullColumnName = "hide_" + fullColumnName;
        DeepEditMainPane.removeOptionValue(fullColumnName);
        this.adjustDBViewColumnWidth();
    }

    public void pasteInDBView() {
        String[][] rawData = ExcelUtil.clipboardExcel2Array();
        if (rawData != null) {
            this.pasteInDBView(rawData);
        }
    }

    public void pasteInDBView(String[][] rawData) {
        int nrawDataRows = rawData.length;
        int nrawDataColumns = rawData[0].length;
        if (!this.isPastingAreaFeasible(nrawDataRows, nrawDataColumns)) {
            System.out.println("Pasting areas don't match. No values were updated to model");
            return;
        }
        int nIniRow = this.tblDatabaseEdit.getSelectedRow();
        int nIniCol = this.tblDatabaseEdit.getSelectedColumn();
        int nDataRow = 0;
        int nDataCol = 0;
        int nTblRow = nIniRow;
        int nTblCol = nIniCol;
        while (nDataRow < nrawDataRows) {
            nDataCol = 0;
            nTblCol = nIniCol;
            while (nDataCol < nrawDataColumns) {
                if (!this.isColumnHidden(nTblCol) && this.tblDatabaseEdit.isCellEditable(nTblRow, nTblCol)) {
                    this.tblDatabaseEdit.setValueAt(rawData[nDataRow][nDataCol], nTblRow, nTblCol);
                    if (this.tblDatabaseEdit.getEditingRow() == nTblRow && this.tblDatabaseEdit.getEditingColumn() == nTblCol) {
                        TableCellEditor editor2 = this.tblDatabaseEdit.getCellEditor();
                        editor2.cancelCellEditing();
                        this.tblDatabaseEdit.editCellAt(nTblRow, nTblCol);
                    }
                    ++nDataCol;
                }
                ++nTblCol;
            }
            ++nDataRow;
            ++nTblRow;
        }
        this.tblDatabaseEdit.repaint();
    }

    private boolean isPastingAreaFeasible(int nRequiredRows, int nRequiredCols) {
        int nEndSelectedRow;
        int nEndSelectedCol;
        int nIniSelectedCol = this.tblDatabaseEdit.getSelectedColumn();
        int nIniSelectedRow = this.tblDatabaseEdit.getSelectedRow();
        if (nIniSelectedCol == -1 || nIniSelectedRow == -1) {
            return false;
        }
        if (this.tblDatabaseEdit.getSelectedColumnCount() > 1 || this.tblDatabaseEdit.getSelectedRowCount() > 1) {
            nEndSelectedCol = nIniSelectedCol + this.tblDatabaseEdit.getSelectedColumnCount();
            nEndSelectedRow = nIniSelectedRow + this.tblDatabaseEdit.getSelectedRowCount();
        } else {
            nEndSelectedCol = this.tblDatabaseEdit.getColumnCount();
            nEndSelectedRow = this.tblDatabaseEdit.getRowCount();
        }
        int nVisibleCol = 0;
        for (int i = nIniSelectedCol; i < nEndSelectedCol; ++i) {
            if (this.isColumnHidden(i)) continue;
            ++nVisibleCol;
        }
        int nVisibleRow = nEndSelectedRow - nIniSelectedRow;
        return nVisibleCol >= nRequiredCols && nVisibleRow >= nRequiredRows;
    }

    private void initComponents() {
        this.popDBViewHeader = new JPopupMenu();
        this.chkSelect = new JMenuItem();
        this.chkHide = new JMenuItem();
        this.chkShowAll = new JMenuItem();
        this.chkLock = new JCheckBoxMenuItem();
        this.chkHidden = new JMenu();
        this.popTreeView = new JPopupMenu();
        this.menuTreeNew = new JMenuItem();
        this.menuTreeRename = new JMenuItem();
        this.menuTreeDelete = new JMenuItem();
        this.menuTreeCopy = new JMenuItem();
        this.menuTreePaste = new JMenuItem();
        this.jspEdit = new JPopupMenu.Separator();
        this.menuTreeProperties = new JMenuItem();
        this.MainEditorScrollPane = new JSplitPane();
        this.NavegationScrollPane = new JSplitPane();
        this.ObjectViewPane = new JTabbedPane();
        this.DatabaseViewTabPane = new JPanel();
        this.jScrollPane4 = new JScrollPane();
        this.NavTree = new JTree();
        this.OverviewPane = new JPanel();
        this.jScrollPane5 = new JScrollPane();
        this.PropertyViewPane = new JTabbedPane();
        this.PropertyTabPane = new JPanel();
        this.jScrollPane3 = new JScrollPane();
        this.AppendDataTabPane = new JPanel();
        this.jScrollPane7 = new JScrollPane();
        this.WorkScrollPane = new JSplitPane();
        this.SchematicPane = new JTabbedPane();
        this.SchematicEditTabPane = new JPanel();
        this.jScrollPane2 = new JScrollPane();
        this.DatabaseEditTabPane = new JPanel();
        this.jScrollPane6 = new JScrollPane();
        this.tblDatabaseEdit = new JTable();
        this.OutputPane = new JTabbedPane();
        this.OutputTabPane = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.txtMainOutputArea = new JTextArea();
        this.chkSelect.setText("Select");
        this.chkSelect.setToolTipText("");
        this.chkSelect.setSelected(true);
        this.chkSelect.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DeepEditMainPane.this.chkSelectActionPerformed(evt);
            }
        });
        this.popDBViewHeader.add(this.chkSelect);
        this.chkHide.setText("Hide");
        this.chkHide.setToolTipText("");
        this.chkHide.setSelected(true);
        this.chkHide.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DeepEditMainPane.this.chkHideActionPerformed(evt);
            }
        });
        this.popDBViewHeader.add(this.chkHide);
        this.chkShowAll.setText("Show All");
        this.chkShowAll.setToolTipText("");
        this.chkShowAll.setSelected(true);
        this.chkShowAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DeepEditMainPane.this.chkShowAllActionPerformed(evt);
            }
        });
        this.popDBViewHeader.add(this.chkShowAll);
        this.chkLock.setText("Lock");
        this.chkLock.setEnabled(false);
        this.popDBViewHeader.add(this.chkLock);
        this.chkHidden.setText("Hidden");
        this.popDBViewHeader.add(this.chkHidden);
        this.popTreeView.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuCanceled(PopupMenuEvent evt) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent evt) {
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent evt) {
                DeepEditMainPane.this.popTreeViewPopupMenuWillBecomeVisible(evt);
            }
        });
        this.menuTreeNew.setText("New comp");
        this.menuTreeNew.setEnabled(false);
        this.popTreeView.add(this.menuTreeNew);
        this.menuTreeRename.setText("Rename");
        this.menuTreeRename.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DeepEditMainPane.this.menuTreeRenameActionPerformed(evt);
            }
        });
        this.popTreeView.add(this.menuTreeRename);
        this.menuTreeDelete.setText("Delete");
        this.menuTreeDelete.setToolTipText("");
        this.menuTreeDelete.setEnabled(false);
        this.menuTreeDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DeepEditMainPane.this.menuTreeDeleteActionPerformed(evt);
            }
        });
        this.popTreeView.add(this.menuTreeDelete);
        this.menuTreeCopy.setText("Copy");
        this.menuTreeCopy.setEnabled(false);
        this.popTreeView.add(this.menuTreeCopy);
        this.menuTreePaste.setText("Paste");
        this.menuTreePaste.setToolTipText("");
        this.menuTreePaste.setEnabled(false);
        this.popTreeView.add(this.menuTreePaste);
        this.popTreeView.add(this.jspEdit);
        this.menuTreeProperties.setText("Properties");
        this.menuTreeProperties.setToolTipText("");
        this.menuTreeProperties.setEnabled(false);
        this.menuTreeProperties.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DeepEditMainPane.this.menuTreePropertiesActionPerformed(evt);
            }
        });
        this.popTreeView.add(this.menuTreeProperties);
        this.MainEditorScrollPane.setDividerSize(4);
        this.MainEditorScrollPane.setToolTipText("");
        this.NavegationScrollPane.setOrientation(0);
        this.ObjectViewPane.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                DeepEditMainPane.this.ObjectViewPaneMouseClicked(evt);
            }
        });
        DefaultMutableTreeNode treeNode1 = new DefaultMutableTreeNode("Database");
        this.NavTree.setModel(new DefaultTreeModel(treeNode1));
        this.NavTree.setName("NavTree");
        this.NavTree.addTreeWillExpandListener(new TreeWillExpandListener(){

            @Override
            public void treeWillCollapse(TreeExpansionEvent evt) throws ExpandVetoException {
            }

            @Override
            public void treeWillExpand(TreeExpansionEvent evt) throws ExpandVetoException {
                DeepEditMainPane.this.NavTreeTreeWillExpand(evt);
            }
        });
        this.NavTree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                DeepEditMainPane.this.NavTreeMouseClicked(evt);
            }
        });
        this.NavTree.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                DeepEditMainPane.this.NavTreeKeyPressed(evt);
            }
        });
        this.jScrollPane4.setViewportView(this.NavTree);
        GroupLayout DatabaseViewTabPaneLayout = new GroupLayout(this.DatabaseViewTabPane);
        this.DatabaseViewTabPane.setLayout(DatabaseViewTabPaneLayout);
        DatabaseViewTabPaneLayout.setHorizontalGroup(DatabaseViewTabPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane4, GroupLayout.Alignment.TRAILING, -1, 142, Short.MAX_VALUE));
        DatabaseViewTabPaneLayout.setVerticalGroup(DatabaseViewTabPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane4, -1, 292, Short.MAX_VALUE));
        this.ObjectViewPane.addTab("Component", this.DatabaseViewTabPane);
        GroupLayout OverviewPaneLayout = new GroupLayout(this.OverviewPane);
        this.OverviewPane.setLayout(OverviewPaneLayout);
        OverviewPaneLayout.setHorizontalGroup(OverviewPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane5, -1, 142, Short.MAX_VALUE));
        OverviewPaneLayout.setVerticalGroup(OverviewPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane5, -1, 292, Short.MAX_VALUE));
        this.ObjectViewPane.addTab("Overview", this.OverviewPane);
        this.NavegationScrollPane.setTopComponent(this.ObjectViewPane);
        GroupLayout PropertyTabPaneLayout = new GroupLayout(this.PropertyTabPane);
        this.PropertyTabPane.setLayout(PropertyTabPaneLayout);
        PropertyTabPaneLayout.setHorizontalGroup(PropertyTabPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane3, -1, 142, Short.MAX_VALUE));
        PropertyTabPaneLayout.setVerticalGroup(PropertyTabPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane3, -1, 287, Short.MAX_VALUE));
        this.PropertyViewPane.addTab("Parameters", this.PropertyTabPane);
        GroupLayout AppendDataTabPaneLayout = new GroupLayout(this.AppendDataTabPane);
        this.AppendDataTabPane.setLayout(AppendDataTabPaneLayout);
        AppendDataTabPaneLayout.setHorizontalGroup(AppendDataTabPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane7, -1, 142, Short.MAX_VALUE));
        AppendDataTabPaneLayout.setVerticalGroup(AppendDataTabPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane7, -1, 287, Short.MAX_VALUE));
        this.PropertyViewPane.addTab("Data", this.AppendDataTabPane);
        this.NavegationScrollPane.setRightComponent(this.PropertyViewPane);
        this.MainEditorScrollPane.setLeftComponent(this.NavegationScrollPane);
        this.WorkScrollPane.setOrientation(0);
        GroupLayout SchematicEditTabPaneLayout = new GroupLayout(this.SchematicEditTabPane);
        this.SchematicEditTabPane.setLayout(SchematicEditTabPaneLayout);
        SchematicEditTabPaneLayout.setHorizontalGroup(SchematicEditTabPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane2, -1, 635, Short.MAX_VALUE));
        SchematicEditTabPaneLayout.setVerticalGroup(SchematicEditTabPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane2, -1, 318, Short.MAX_VALUE));
        this.SchematicPane.addTab("Schematic", this.SchematicEditTabPane);
        this.DatabaseEditTabPane.setAutoscrolls(true);
        this.tblDatabaseEdit.setAutoCreateRowSorter(true);
        this.tblDatabaseEdit.setModel(new DefaultTableModel(new Object[0][], new String[]{"Parameter"}));
        this.tblDatabaseEdit.setAutoResizeMode(0);
        this.tblDatabaseEdit.setColumnSelectionAllowed(true);
        this.tblDatabaseEdit.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                DeepEditMainPane.this.tblDatabaseEditMouseClicked(evt);
            }

            @Override
            public void mousePressed(MouseEvent evt) {
                DeepEditMainPane.this.tblDatabaseEditMousePressed(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                DeepEditMainPane.this.tblDatabaseEditMouseReleased(evt);
            }
        });
        this.tblDatabaseEdit.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                DeepEditMainPane.this.tblDatabaseEditKeyPressed(evt);
            }

            @Override
            public void keyReleased(KeyEvent evt) {
                DeepEditMainPane.this.tblDatabaseEditKeyReleased(evt);
            }
        });
        this.jScrollPane6.setViewportView(this.tblDatabaseEdit);
        this.tblDatabaseEdit.getColumnModel().getSelectionModel().setSelectionMode(1);
        if (this.tblDatabaseEdit.getColumnModel().getColumnCount() > 0) {
            this.tblDatabaseEdit.getColumnModel().getColumn(0).setMaxWidth(100000);
        }
        GroupLayout DatabaseEditTabPaneLayout = new GroupLayout(this.DatabaseEditTabPane);
        this.DatabaseEditTabPane.setLayout(DatabaseEditTabPaneLayout);
        DatabaseEditTabPaneLayout.setHorizontalGroup(DatabaseEditTabPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 635, Short.MAX_VALUE).addGroup(DatabaseEditTabPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane6, GroupLayout.Alignment.TRAILING, -1, 635, Short.MAX_VALUE)));
        DatabaseEditTabPaneLayout.setVerticalGroup(DatabaseEditTabPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 318, Short.MAX_VALUE).addGroup(DatabaseEditTabPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane6, -1, 318, Short.MAX_VALUE)));
        this.SchematicPane.addTab("Database", this.DatabaseEditTabPane);
        this.WorkScrollPane.setLeftComponent(this.SchematicPane);
        this.txtMainOutputArea.setColumns(20);
        this.txtMainOutputArea.setRows(5);
        this.jScrollPane1.setViewportView(this.txtMainOutputArea);
        GroupLayout OutputTabPaneLayout = new GroupLayout(this.OutputTabPane);
        this.OutputTabPane.setLayout(OutputTabPaneLayout);
        OutputTabPaneLayout.setHorizontalGroup(OutputTabPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 635, Short.MAX_VALUE));
        OutputTabPaneLayout.setVerticalGroup(OutputTabPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 261, Short.MAX_VALUE));
        this.OutputPane.addTab("Output", this.OutputTabPane);
        this.WorkScrollPane.setRightComponent(this.OutputPane);
        this.MainEditorScrollPane.setRightComponent(this.WorkScrollPane);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.MainEditorScrollPane, GroupLayout.Alignment.TRAILING));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.MainEditorScrollPane, GroupLayout.Alignment.TRAILING));
    }

    private void NavTreeMouseClicked(MouseEvent evt) {
        TreePath tp = this.NavTree.getPathForLocation(evt.getX(), evt.getY());
        if (tp == null) {
            return;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)tp.getLastPathComponent();
        if (node == null) {
            return;
        }
        if (node.isRoot()) {
            return;
        }
        if (SwingUtilities.isLeftMouseButton(evt) && evt.getClickCount() == 1) {
            if (!node.isLeaf() && node.getParent().equals(this.NavTree.getModel().getRoot())) {
                this.lDBViewComp.clear();
                for (int i = 0; i < node.getChildCount(); ++i) {
                    Object o = ((DefaultMutableTreeNode)node.getChildAt(i)).getUserObject();
                    this.lDBViewComp.add((comp)o);
                }
                this.setCompInDBView(this.lDBViewComp);
                this.emptyTableTree();
                this.setSelectedComp(null);
                return;
            }
            if (node.isLeaf() && !node.getParent().equals(node.getRoot())) {
                this.setSelectedComp((comp)node.getUserObject());
                return;
            }
        }
        if (SwingUtilities.isLeftMouseButton(evt) && evt.getClickCount() == 2 && node.isLeaf() && !node.getParent().equals(node.getRoot())) {
            comp TempComponent = (comp)node.getUserObject();
            this.setSelectedComp(TempComponent);
            this.showParameterGUIpopup();
            return;
        }
        if (SwingUtilities.isRightMouseButton(evt)) {
            this.NavTree.setSelectionPath(tp);
            if (node.isLeaf() && !node.getParent().equals(node.getRoot())) {
                comp TempComponent = (comp)node.getUserObject();
                this.setSelectedComp(TempComponent);
                this.popTreeView.show(evt.getComponent(), evt.getX(), evt.getY());
                return;
            }
        }
        this.emptyTableTree();
        this.setSelectedComp(null);
    }

    private void NavTreeTreeWillExpand(TreeExpansionEvent evt) throws ExpandVetoException {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)evt.getPath().getLastPathComponent();
        if (node == null) {
            return;
        }
        if (!node.isLeaf()) {
            Enumeration<TreeNode> e = node.children();
            ArrayList<TreeNode> l = Collections.list(e);
            Utils.sortCompListByName(l);
            node.removeAllChildren();
            for (DefaultMutableTreeNode defaultMutableTreeNode : l) {
                node.add(defaultMutableTreeNode);
            }
        }
    }

    private void ObjectViewPaneMouseClicked(MouseEvent evt) {
        if (this.ObjectViewPane.getSelectedIndex() == 1) {
            this.myDeepEdit.refreshOverviewPanel();
        }
    }

    private void tblDatabaseEditMouseClicked(MouseEvent evt) {
    }

    private void chkSelectActionPerformed(ActionEvent evt) {
        int nCol = this.selectedDBViewColumn;
        if (nCol == -1) {
            return;
        }
        int nTotalRows = this.tblDatabaseEdit.getRowCount();
        this.tblDatabaseEdit.setColumnSelectionInterval(nCol, nCol);
        this.tblDatabaseEdit.setRowSelectionInterval(0, nTotalRows - 1);
        this.selectedDBViewColumn = -1;
    }

    private void tblDatabaseEditMousePressed(MouseEvent evt) {
    }

    private void tblDatabaseEditMouseReleased(MouseEvent evt) {
    }

    private void chkShowAllActionPerformed(ActionEvent evt) {
        for (String s : this.getCurrentHiddenColumns()) {
            this.showDBViewColumn(s);
        }
    }

    private void chkHideActionPerformed(ActionEvent evt) {
        int nCol = this.selectedDBViewColumn;
        if (nCol == -1) {
            return;
        }
        String sColName = this.tblDatabaseEdit.getColumnName(nCol);
        this.hideDBViewColumn(sColName);
        this.selectedDBViewColumn = -1;
    }

    private void tblDatabaseEditKeyReleased(KeyEvent evt) {
        if (evt.isActionKey()) {
            if (evt.getKeyCode() == 65487) {
                System.out.println("Paste action unsupported...");
            }
        } else if (evt.getKeyCode() == 10) {
            // empty if block
        }
    }

    private void tblDatabaseEditKeyPressed(KeyEvent evt) {
        if (evt.isActionKey() ? evt.getKeyCode() == 65487 : evt.getKeyCode() == 10) {
            // empty if block
        }
    }

    private void menuTreeDeleteActionPerformed(ActionEvent evt) {
        int yesNo;
        if (this.selectedComp != null && (yesNo = JOptionPane.showConfirmDialog(this, "Are you sure you want to delete component '" + this.selectedComp + "?", "Delete comp", 0, 2)) == 0) {
            this.myDeepEdit.UserWantsDeleteComponent(this.selectedComp);
        }
    }

    private void popTreeViewPopupMenuWillBecomeVisible(PopupMenuEvent evt) {
        this.menuTreeNew.setText("New Comp");
        if (this.getSelectedClassName() != null && this.menuTreeNew != null) {
            this.menuTreeNew.setText("New " + this.getSelectedClassName());
        }
        if (this.getSelectedCompInNavTree() != null) {
            if (this.menuTreeNew != null) {
                this.menuTreeNew.setText("New " + this.getSelectedCompInNavTree().getClassName());
                this.menuTreeNew.setEnabled(false);
            }
            if (this.menuTreeDelete != null) {
                this.menuTreeDelete.setEnabled(true);
            }
            if (this.menuTreeProperties != null) {
                this.menuTreeProperties.setEnabled(true);
            }
        }
    }

    private void menuTreePropertiesActionPerformed(ActionEvent evt) {
        if (this.getSelectedCompInNavTree() != null) {
            this.myDeepEdit.UserWantsComponentFrame(this.getSelectedCompInNavTree());
        }
    }

    private void menuTreeRenameActionPerformed(ActionEvent evt) {
        this.renameCompInNavTree();
    }

    private void NavTreeKeyPressed(KeyEvent evt) {
        comp editComp;
        if (!(evt.getSource() instanceof JTree)) {
            return;
        }
        int keyCode = evt.getKeyCode();
        if (keyCode == 113 && (editComp = this.getSelectedCompInNavTree()) != null) {
            this.renameCompInNavTree();
        }
    }

    public JTextArea getOutputTextArea() {
        return this.txtMainOutputArea;
    }

    public void setSchematicPane(SchematicPanel sch) {
        this.jScrollPane2.setViewportView(sch);
    }

    public void setDBViewPane(JTable pnlDatabaseView) {
        this.jScrollPane6.setViewportView(pnlDatabaseView);
    }

    public JImagePanel getOverviewPane() {
        if (this.jScrollPane5.getComponentCount() > 0 && this.jScrollPane5.getComponent(0) instanceof JImagePanel) {
            return (JImagePanel)this.jScrollPane5.getComponent(0);
        }
        return null;
    }

    public void setOverviewPane(JImagePanel overviewPane) {
        this.jScrollPane5.setViewportView(overviewPane);
    }

    public JTable getDataTabPane() {
        if (this.jScrollPane7.getComponentCount() > 0 && this.jScrollPane7.getComponent(0) instanceof JTable) {
            return (JTable)this.jScrollPane7.getComponent(0);
        }
        return null;
    }

    public void setDataTabPane(JTable tblDataView) {
        this.jScrollPane7.setViewportView(tblDataView);
    }

    public void removeDataTabPane() {
        this.jScrollPane7.removeAll();
    }

    public JTree getDataTreeGUI() {
        return this.NavTree;
    }

    public void selectObjectinTreeNav(comp DEComponent) {
        if (DEComponent == null) {
            return;
        }
        this.selectedComp = DEComponent;
        TreePath compPath = this.findTreeNavPath(DEComponent);
        assert (compPath != null) : "How could this have happened? Why object " + DEComponent.getClassName() + "/" + DEComponent.getName() + " is not in the tree?";
        this.NavTree.setSelectionPath(compPath);
        this.NavTree.scrollPathToVisible(compPath);
    }

    private boolean setParameterInfo(comp DEComponent, String parameterName, String parameterValue) {
        return this.myDeepEdit.setParameterInfo(DEComponent, parameterName, parameterValue);
    }

    public void showParameterGUIpopup() {
        if (this.selectedComp != null) {
            boolean bUseOldCompGUI = DeepEdit.getBooleanOptionValue("UseOldComponentGUI");
            if (this.selectedComp instanceof Constraint || bUseOldCompGUI && !(this.selectedComp instanceof Simulation)) {
                this.myDeepEdit.UserWantsComponentFrame(this.selectedComp);
            } else {
                JDialog w = new JDialog((Frame)DeepEdit.frame, true);
                this.jXTreeParameter.setPreferredScrollableViewportSize(new Dimension(250, 400));
                w.add(new JScrollPane((Component)((Object)this.jXTreeParameter)));
                w.setTitle(this.selectedComp.getClassName() + "::" + this.selectedComp.getName());
                w.pack();
                w.setLocationRelativeTo(DeepEdit.frame);
                w.setDefaultCloseOperation(0);
                w.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent evt) {
                        DeepEditMainPane.this.parameterWindowClosing(evt);
                    }
                });
                w.setVisible(true);
            }
        }
    }

    private void parameterWindowClosing(WindowEvent evt) {
        this.jScrollPane3.setViewportView((Component)((Object)this.jXTreeParameter));
        Window w = evt.getWindow();
        w.dispose();
    }

    public JXTreeTable getParameterTableinGUI() {
        if (this.selectedComp != null) {
            return this.jXTreeParameter;
        }
        return null;
    }

    public static JXTreeTable createParameterTable(comp oComp) {
        if (oComp == null) {
            return new JXParameterTreeTable(oComp);
        }
        return new JXParameterTreeTable();
    }

    public static JXTreeTable createParameterTable(String className, String compName, List<ParameterData> lData) {
        JXParameterTreeTable jXTreeParamGUI;
        comp TempComp = DeepEdit.getComponent(compName, className);
        if (TempComp == null) {
            jXTreeParamGUI = new JXParameterTreeTable(className, compName);
            for (ParameterData pdata : lData) {
                jXTreeParamGUI.addParameter(pdata);
            }
            if (jXTreeParamGUI.getRowCount() > 0) {
                jXTreeParamGUI.expandRow(0);
            }
        } else {
            jXTreeParamGUI = new JXParameterTreeTable(TempComp);
        }
        return jXTreeParamGUI;
    }

    private void jXTreeParameterValueChanged(TreeModelEvent e) {
        int c = this.jXTreeParameter.getSelectedColumn();
        int r = this.jXTreeParameter.getSelectedRow();
        String strName = this.jXTreeParameter.getValueAt(r, 0).toString();
        String strVal = this.jXTreeParameter.getValueAt(r, 1).toString();
        if (Utils.IsAttributeValidGroup(strName)) {
            return;
        }
        if (this.selectedComp == null) {
            if (this.NavTree.isSelectionEmpty()) {
                return;
            }
            DefaultMutableTreeNode oNode = (DefaultMutableTreeNode)this.NavTree.getSelectionPath().getLastPathComponent();
            if (oNode == null) {
                return;
            }
            if (oNode.isLeaf()) {
                comp TempComponent;
                this.selectedComp = TempComponent = (comp)oNode.getUserObject();
            }
        }
        this.setParameterInfo(this.selectedComp, strName, strVal);
    }

    public void setParameterGUIValues(comp DEComp) {
        this.selectedComp = DEComp;
        this.jXTreeParameter.setComponent(DEComp);
    }

    public static void addParameterTableEntry(JXTreeTable jxTreeTbl, ParameterData pData) {
        if (jxTreeTbl instanceof JXParameterTreeTable) {
            ((JXParameterTreeTable)jxTreeTbl).addParameter(pData);
        } else assert (false) : "Why are you trying to use a tree table different from own custom DeepEdit 'JXParameterTreeTable'? Always use method createParameterTable to create tree tables to hold parameters!";
    }

    public void clearGUI() {
        this.removeAllRowsFromDBView();
        this.removeAllColumnsFromDBView();
        this.emptyTableTree();
        this.removeDataTabPane();
    }

    private void emptyTableTree() {
        this.jXTreeParameter.clear();
    }

    private TreePath findTreeNavPath(comp DEComp) {
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.NavTree.getModel().getRoot();
        Enumeration<TreeNode> e = root.depthFirstEnumeration();
        while (e.hasMoreElements()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)e.nextElement();
            Object o = node.getUserObject();
            if (!(o instanceof comp) || !((comp)o).equals(DEComp)) continue;
            return new TreePath(node.getPath());
        }
        return null;
    }

    public String addReportTab(String sLabel, VSI_report report) {
        assert (report != null) : "Never load null reports!";
        String uniqueLabel = StringUtil.createUniqueNameFromList(sLabel, this.loutTabs);
        this.loutTabs.add(uniqueLabel);
        this.SchematicPane.addTab(uniqueLabel, new VSI_mainPanel(report));
        int index = this.SchematicPane.indexOfTab(uniqueLabel);
        assert (index >= 0) : "What went wrong with tabbedpane add function??";
        JPanel pnlTab = this.closeBtnToPnl(uniqueLabel);
        this.SchematicPane.setTabComponentAt(index, pnlTab);
        this.SchematicPane.setSelectedIndex(index);
        return uniqueLabel;
    }

    public boolean removeReportTab(String sLabel) {
        int index = this.SchematicPane.indexOfTab(sLabel);
        if (index >= 0) {
            this.SchematicPane.removeTabAt(index);
            return this.loutTabs.remove(sLabel);
        }
        return false;
    }

    public String addMessageTab(String sLabel) {
        String uniqueLabel = StringUtil.createUniqueNameFromList(sLabel, this.lmsgTabs);
        this.lmsgTabs.add(uniqueLabel);
        this.OutputPane.addTab(uniqueLabel, new MessageTabPane());
        int index = this.OutputPane.indexOfTab(uniqueLabel);
        assert (index >= 0) : "What went wrong with tabbedpane add function??";
        JPanel pnlTab = this.closeBtnToPnl(uniqueLabel);
        this.OutputPane.setTabComponentAt(index, pnlTab);
        this.OutputPane.setSelectedIndex(index);
        return uniqueLabel;
    }

    public void printlnToMessageTab(String sLine, String sMessageTabName) {
        if (!this.lmsgTabs.contains(sMessageTabName)) {
            sMessageTabName = this.addMessageTab(sMessageTabName);
        }
        int index = this.OutputPane.indexOfTab(sMessageTabName);
        assert (index >= 0) : "What went wrong with tabbedpane add function??";
        if (index != -1) {
            this.OutputPane.setSelectedIndex(index);
            MessageTabPane tabPane = (MessageTabPane)this.OutputPane.getComponentAt(index);
            tabPane.appendLine(sLine);
        }
    }

    public void printlnToMessageTab(String sLine) {
        int index = this.OutputPane.getSelectedIndex();
        if (this.OutputPane.getSelectedIndex() <= 0) {
            System.out.println(sLine);
            return;
        }
        MessageTabPane tabPane = (MessageTabPane)this.OutputPane.getComponentAt(index);
        tabPane.appendLine(sLine);
    }

    public boolean removeMessageTab(String sLabel) {
        int index = this.OutputPane.indexOfTab(sLabel);
        if (index >= 0) {
            this.OutputPane.removeTabAt(index);
            return this.lmsgTabs.remove(sLabel);
        }
        return false;
    }

    public List<String> getAllMessageTabNames() {
        return this.lmsgTabs;
    }

    public void removeAllMessageTabs() {
        for (String sTabName : this.lmsgTabs) {
            this.removeMessageTab(sTabName);
        }
        this.lmsgTabs.clear();
    }

    private JPanel closeBtnToPnl(String uniqueLabel) {
        JPanel pnlTab = new JPanel(new GridBagLayout());
        pnlTab.setOpaque(false);
        JButton btnClose = this.getTabCloseButton();
        btnClose.setActionCommand(uniqueLabel);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        JLabel lblTitle = new JLabel(uniqueLabel);
        pnlTab.add((Component)lblTitle, gbc);
        ++gbc.gridx;
        gbc.weightx = 0.0;
        pnlTab.add((Component)btnClose, gbc);
        return pnlTab;
    }

    private JButton getTabCloseButton() {
        final JButton btnClose = new JButton(" x ");
        btnClose.setFont(Font.getFont("Monospaced"));
        btnClose.setContentAreaFilled(false);
        btnClose.setOpaque(true);
        btnClose.setFocusPainted(false);
        btnClose.setBorder(BorderFactory.createEmptyBorder());
        btnClose.setToolTipText("Click to close");
        btnClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String label = e.getActionCommand();
                assert (label != null) : "Why did you change the action command of the tab-closing icon???";
                if (!DeepEditMainPane.this.removeMessageTab(label)) {
                    DeepEditMainPane.this.removeReportTab(label);
                }
            }
        });
        final Color defaultBckColor = btnClose.getBackground();
        final Color defaultForeColor = btnClose.getForeground();
        btnClose.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                btnClose.setBackground(Color.RED);
                btnClose.setForeground(Color.WHITE);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                btnClose.setBackground(defaultBckColor);
                btnClose.setForeground(defaultForeColor);
            }

            @Override
            public void mousePressed(MouseEvent evt) {
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
            }
        });
        return btnClose;
    }
}

