/*
 * Decompiled with CFR 0.152.
 */
package de.core;

import de.core.DeepEdit;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.net.URL;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;

public class DeepEditAboutJPane
extends JPanel {
    Image imageBackground;
    private JScrollPane ScrollPaneAboutText;
    private JButton btnReleaseNotes;
    private JLabel lblClose;
    private JTextArea txtAboutInfo;

    public DeepEditAboutJPane() {
        this.initComponents();
        this.ShowAboutText("./help/About_Deep-Editor.help");
        URL imageURL = this.getClass().getResource("/images/SplashDeepEdit.png");
        try {
            this.imageBackground = Toolkit.getDefaultToolkit().getImage(imageURL);
        }
        catch (SecurityException e) {
            System.out.println("Problem loading 'About' image: " + e.getMessage());
            e.printStackTrace(System.out);
        }
        JScrollBar vsb = this.ScrollPaneAboutText.getVerticalScrollBar();
        vsb.setPreferredSize(new Dimension(5, 0));
        JScrollBar hsb = this.ScrollPaneAboutText.getHorizontalScrollBar();
        hsb.setPreferredSize(new Dimension(0, 5));
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(450, 330);
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        g.drawImage(this.imageBackground, 0, 0, this);
    }

    private void ShowAboutText(String strCsvFileName) {
        if (this.txtAboutInfo == null) {
            return;
        }
        try {
            File inputFile = new File(strCsvFileName);
            BufferedReader in = new BufferedReader(new FileReader(inputFile));
            this.txtAboutInfo.read(in, null);
        }
        catch (FileNotFoundException e) {
            System.out.println("Error showing about text. About text source file not found: " + strCsvFileName);
            e.printStackTrace(System.out);
        }
        catch (IOException e) {
            System.out.println("Error showing about text. Error reading file: " + strCsvFileName);
            e.printStackTrace(System.out);
        }
    }

    private void CloseParentJDialog() {
        Window myParentWindow;
        Container c = this.getParent();
        if (c != null && c instanceof JDialog) {
            JDialog myDialog = (JDialog)c;
            myDialog.dispose();
        }
        if ((myParentWindow = SwingUtilities.windowForComponent(this)) != null && myParentWindow instanceof JDialog) {
            myParentWindow.dispose();
        }
    }

    private void initComponents() {
        this.ScrollPaneAboutText = new JScrollPane();
        this.txtAboutInfo = new JTextArea();
        this.lblClose = new JLabel();
        this.btnReleaseNotes = new JButton();
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                DeepEditAboutJPane.this.formMouseClicked(evt);
            }
        });
        this.txtAboutInfo.setEditable(false);
        this.txtAboutInfo.setColumns(20);
        this.txtAboutInfo.setFont(new Font("Courier New", 0, 10));
        this.txtAboutInfo.setRows(5);
        this.ScrollPaneAboutText.setViewportView(this.txtAboutInfo);
        this.lblClose.setForeground(new Color(255, 255, 255));
        this.lblClose.setText("Click to close [x]");
        this.lblClose.setToolTipText("");
        this.lblClose.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                DeepEditAboutJPane.this.CloseClick(evt);
            }
        });
        this.btnReleaseNotes.setForeground(new Color(204, 204, 255));
        this.btnReleaseNotes.setText("<HTML><U>Release Notes</U></FONT>\n</HTML>");
        this.btnReleaseNotes.setToolTipText("");
        this.btnReleaseNotes.setBorderPainted(false);
        this.btnReleaseNotes.setContentAreaFilled(false);
        this.btnReleaseNotes.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DeepEditAboutJPane.this.DisplayReleaseNotes(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.ScrollPaneAboutText, -1, 430, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblClose, GroupLayout.Alignment.TRAILING).addComponent(this.btnReleaseNotes, GroupLayout.Alignment.TRAILING, -2, -1, -2)))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.lblClose).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 191, Short.MAX_VALUE).addComponent(this.btnReleaseNotes, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.ScrollPaneAboutText, -2, 74, -2).addContainerGap()));
    }

    private void CloseClick(MouseEvent evt) {
        this.CloseParentJDialog();
    }

    private void formMouseClicked(MouseEvent evt) {
        this.CloseParentJDialog();
    }

    private void DisplayReleaseNotes(ActionEvent evt) {
        DeepEdit.UserWantsReleaseNotes();
    }
}

