/*
 * Decompiled with CFR 0.152.
 */
package de.core;

import de.core.AGCServer;
import de.core.AnalysisTool;
import de.core.BalanceFrame;
import de.core.Busbar;
import de.core.CBT;
import de.core.ConsoleOutputStream;
import de.core.Constraint;
import de.core.ConstraintBuilderFrame;
import de.core.ControlAreaFrame;
import de.core.DCLF;
import de.core.DailySimulation;
import de.core.DailySimulationFrame;
import de.core.DeepEditAboutFrame;
import de.core.DeepEditFrame;
import de.core.DeepEditMainPane;
import de.core.DeepEditOptionsJDialog;
import de.core.ExamplesFrame;
import de.core.GISFrame;
import de.core.GaRunFrame;
import de.core.GaStart;
import de.core.Generator;
import de.core.GeneratorCHP;
import de.core.GeneratorDG;
import de.core.GeneratorEO;
import de.core.GeneratorPV;
import de.core.GeoMap;
import de.core.GeoMapFrame;
import de.core.HelpDialog;
import de.core.HtmlHelp;
import de.core.Injection;
import de.core.JImagePanel;
import de.core.JavaLF;
import de.core.JavaShCFrame;
import de.core.LaunchProgressFrame;
import de.core.LineDC;
import de.core.Load;
import de.core.LoadDispatchFrame;
import de.core.LoadScalingFrame;
import de.core.LoadTGDFrame;
import de.core.MMCredibility;
import de.core.MMCredibilityFrame;
import de.core.MMMarketController;
import de.core.MMMarketShare;
import de.core.MMMarketShareFrame;
import de.core.MMReservoirLevel;
import de.core.MMReservoirLevelFrame;
import de.core.MMS2;
import de.core.MMS2Frame;
import de.core.MMSpotPrice;
import de.core.MMSpotPriceFrame;
import de.core.OPF;
import de.core.Obj;
import de.core.OptimalFeeder;
import de.core.OptimiseServer;
import de.core.OptionsFrame;
import de.core.OverviewFrame;
import de.core.PIETException;
import de.core.PIETStudiesFrame;
import de.core.PLPStudiesFrame;
import de.core.PietEditFrame;
import de.core.Pin;
import de.core.PrintOptionsFrame;
import de.core.Probe;
import de.core.SFT;
import de.core.SFTFrame;
import de.core.SQPVOptionsFrame;
import de.core.SVC;
import de.core.Schematic;
import de.core.SchematicPanel;
import de.core.SearchNameFrame;
import de.core.Server;
import de.core.SimpleDialog;
import de.core.Simulation;
import de.core.SpeedFrame;
import de.core.StatusJPanel;
import de.core.TAMainFrame;
import de.core.TextDialog;
import de.core.ThreeWindingTrafo;
import de.core.TimeFrame;
import de.core.ToolBarJPanel;
import de.core.Trafo;
import de.core.Upfc;
import de.core.ViewDBFrame;
import de.core.VisualImportFrame;
import de.core.YearlyDCLFStatistics;
import de.core.YearlyDCLFStatisticsFrame;
import de.core.YearlySimulation;
import de.core.YearlySimulationFrame;
import de.core.ZoomFrame;
import de.core.agreement;
import de.core.comp;
import de.core.hdb_affl;
import de.core.hdb_irr;
import de.core.hdb_paspur;
import de.core.hdb_res;
import de.core.hdb_ser;
import de.core.mdb_cust;
import de.core.mdb_inv;
import de.core.mdb_iso;
import de.core.mdb_sup;
import de.core.planpro;
import de.core.seeds.SEEDS_StudiesFrame;
import de.core.vsi.VSI_report;
import de.data.DE_GeneralEnums;
import de.data.ParameterData;
import de.data.ParameterInfo;
import de.data.ValidationRule;
import de.utils.ExcelUtil;
import de.utils.StringUtil;
import de.utils.Utils;
import java.awt.Color;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.SplashScreen;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.geom.Rectangle2D;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import java.io.Writer;
import java.net.URL;
import java.nio.charset.Charset;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;

public class DeepEdit
implements Runnable {
    private static final boolean USE_NEW_SCHEMATIC_VERSION = true;
    public static final int MAJOR_REVISION_VERSION = 3;
    public static final int MINOR_REVISION_VERSION = 4;
    public static final int MINOR_COMPILE_VERSION = 0;
    public static final boolean IS_32BITS_VERSION = true;
    public static DeepEditFrame frame;
    public static boolean ViewMode;
    private static boolean isJRE32Bits;
    protected ToolBarJPanel MyControlPanel = null;
    static StatusJPanel MyStatusPanel;
    public static SchematicPanel MySchematicPanel;
    public int idioma = 1;
    public int font = 0;
    Thread killme = null;
    public static String PathDOS;
    public static String PathUNIX;
    public static final String DATABASE_FOLDER = "database";
    public static final String CONFIG_FOLDER = "config";
    public static final String HELP_FOLDER = "help";
    public static final String LIBRARY_FOLDER = "lib";
    String MapName = null;
    String Grilla = "6";
    public static Schematic MySchematic;
    public static Pin[][] PinGrid;
    String message = null;
    public static final int MAX_PAGE_WIDTH = 2000;
    public static final int MAX_PAGE_HEIGHT = 8000;
    static Image GridImage;
    static Image ImageBuffer;
    static Image ImageBuffer1;
    private Image FrameIconImage = null;
    Graphics ibg;
    Graphics gg;
    int OffScreenWidth = 0;
    int OffScreenHeight = 0;
    public Color BackGroundColor = new Color(0, 0, 90);
    static int GridStep;
    static int GridStepPower;
    static int GridStepMarket;
    int hgs = GridStep / 2;
    static final int MAX_GRIDSTEP = 16;
    static final int MIN_GRIDSTEP = 1;
    boolean ShowMap = false;
    public static boolean ShowAlias;
    boolean ShowGrid = false;
    public static boolean ShowPins;
    public static boolean HighLightPins;
    public static boolean PrintConnecWarnings;
    private static DE_GeneralEnums.editor NEditor;
    public boolean stopGA = false;
    boolean SchematicPanelPainted = false;
    boolean HelpWanted = false;
    public String TextFileRequested = null;
    boolean EnableFileOperations = true;
    ExamplesFrame MyExamplesFrame = null;
    public String RequestedText = null;
    public boolean RequestedTextFileRead = false;
    public boolean RequestedTextFileError = false;
    PrintOptionsFrame MyPrintOptionsFrame = null;
    OptionsFrame MyOptionsFrame = null;
    PLPStudiesFrame MyPLPStudiesFrame = null;
    public SEEDS_StudiesFrame MySEEDS_StudiesFrame = null;
    PIETStudiesFrame MyPIETStudiesFrame = null;
    OverviewFrame MyOverviewFrame = null;
    BalanceFrame MyBalanceFrame = null;
    HtmlHelp MyHtmlHelpFrame = null;
    ViewDBFrame MyViewDBFrame = null;
    SearchNameFrame MySearchNameFrame = null;
    ControlAreaFrame MyControlAreaToolFrame = null;
    LoadScalingFrame MyLoadScalingFrame = null;
    LoadDispatchFrame MyLoadDispatchFrame = null;
    LoadTGDFrame MyLoadTGDFrame = null;
    SFTFrame MySFTFrame = null;
    SFT MySFT = null;
    DailySimulationFrame MyDailySimulationFrame = null;
    DailySimulation MyDailySimulation = null;
    CBT MyCBT = null;
    YearlySimulationFrame MyYearlySimulationFrame = null;
    YearlyDCLFStatisticsFrame MyYearlyDCLFStatisticsFrame = null;
    MMS2Frame MyMMS2Frame = null;
    MMMarketShareFrame MyMMMarketShareFrame = null;
    MMReservoirLevelFrame MyMMReservoirLevelFrame = null;
    MMSpotPriceFrame MyMMSpotPriceFrame = null;
    MMCredibilityFrame MyMMCredibilityFrame = null;
    YearlySimulation MyYearlySimulation = null;
    YearlyDCLFStatistics MyYearlyDCLFStatistics = null;
    MMS2 MyMMS2 = null;
    MMMarketShare MyMMMarketShare = null;
    MMCredibility MyMMCredibility = null;
    MMReservoirLevel MyMMReservoirLevel = null;
    MMSpotPrice MyMMSpotPrice = null;
    MMMarketController MyMMMarketController = null;
    SQPVOptionsFrame MySQPVOptionsFrame = null;
    GaRunFrame MyrunGaFrame = null;
    private static VisualImportFrame myVisualImportFrame;
    GeoMap MyGIS = null;
    GISFrame MyGISFrame = null;
    GeoMapFrame MyGeoMapFrame = null;
    public int GISDL = 1023;
    public String GISprojection = "Equirectangle";
    public int GISscreenw = 300;
    public int GISscreenh = 700;
    Server MyServer;
    OptimiseServer MyOptimiseServer;
    AGCServer MyAGCServer;
    DeepEditOptionsJDialog MyDeepOptionsFrame = null;
    ZoomFrame MyZoomFrame = null;
    SpeedFrame MySpeedFrame = null;
    TimeFrame MyTimeFrame = null;
    private TAMainFrame myTAMainFrame;
    public int SimulationSpeed = 50;
    boolean StopAtShortCircuit = true;
    boolean StopAtLoop = true;
    GaStart mystartGA = null;
    OptimalFeeder myOptimalFeeder = null;
    PrintStream myPrintStream;
    PrintStream myPrintStream1;
    private static Properties DEDefaultProperties;
    private static ParameterInfo DEParameterInfo;
    private static JTextArea textArea;
    private static JTree MyDataTree;
    public static boolean isGUI;
    public static Font Font8;
    public static Font Font9;
    public static Font Font10;
    public static Font Font12;
    public static Font Font14;
    public static Font Font16;
    public static Font Font18;
    public static Font TextFont;
    public static Font CodeFont;
    public static final String CSV_LIST_SEPARATOR = ",";
    private static String DeepDBName;
    private static String DailyDBName;
    private static String YearlyDBName;
    private static final boolean USE_CONSOLE_ERROR = false;
    private static LaunchProgressFrame schProgressFrame;
    private static SplashScreen myDESplash;
    private static Graphics2D splashGraphics;
    private static Rectangle2D.Double splashTextArea;
    private static Rectangle2D.Double splashProgressArea;
    private static List<File> lTempFiles;

    public DeepEdit() {
        this("");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DeepEdit(String SchematicFileName) {
        if (!SchematicFileName.isEmpty()) {
            isGUI = true;
        }
        this.init();
        try {
            this.start();
            System.out.println("Program Started");
            if (!SchematicFileName.equals("")) {
                long time = System.currentTimeMillis();
                while (!this.ImagesReady()) {
                    Thread.sleep(250L);
                }
                System.out.println("Time waiting: " + (System.currentTimeMillis() - time));
                Schematic sch = new Schematic(PinGrid, SchematicFileName);
                sch.FileName = SchematicFileName;
                sch.FileDir = "";
                if (MySchematic != null) {
                    MySchematic = sch;
                    MySchematic.setEditor(DE_GeneralEnums.editor.Power);
                    DeepEdit.SimulateSetUp();
                    MySchematicPanel.repaint();
                    DeepEdit.updateTime();
                }
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace(System.err);
        }
        catch (IOException e) {
            e.printStackTrace(System.err);
        }
        catch (NumberFormatException e) {
            e.printStackTrace(System.err);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
        finally {
            DeepEdit.hideProgressBar();
            DeepEdit.hideProgressFrame();
        }
    }

    public final void init() {
        String DEVersion;
        block27: {
            try {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace(System.err);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace(System.err);
            }
            catch (InstantiationException e) {
                e.printStackTrace(System.err);
            }
            catch (UnsupportedLookAndFeelException e) {
                e.printStackTrace(System.err);
            }
            if (MySchematic != null) {
                return;
            }
            DEVersion = "3.4.0";
            DEVersion = DEVersion + "(32bits)";
            myDESplash = SplashScreen.getSplashScreen();
            if (myDESplash != null) {
                Dimension ssDim = myDESplash.getSize();
                int height = ssDim.height;
                int width = ssDim.width;
                splashTextArea = new Rectangle2D.Double(15.0, (double)height * 0.88, (double)width * 0.45, 26.0);
                splashProgressArea = new Rectangle2D.Double((double)width * 0.55, (double)height * 0.92, (double)width * 0.4, 8.0);
                splashGraphics = myDESplash.createGraphics();
                Font fontSplash = new Font("Dialog", 0, 10);
                splashGraphics.setFont(fontSplash);
                DeepEdit.splashText("Starting DeepEdit v" + DEVersion);
                DeepEdit.splashProgress(0);
            } else {
                System.out.println("problem loading Splash");
            }
            if (myDESplash != null) {
                DeepEdit.splashProgress(20);
            }
            try {
                GregorianCalendar actCalendar = new GregorianCalendar();
                File expFile = new File(System.getProperty("user.dir") + File.separator + "lxmoslog.sys");
                if (actCalendar.after(Obj.expDate)) {
                    if (!expFile.exists()) {
                        expFile.createNewFile();
                        FileOutputStream fos = new FileOutputStream(expFile);
                        ObjectOutputStream oos = new ObjectOutputStream(fos);
                        oos.writeObject(Obj.expDate);
                        oos.close();
                        fos.close();
                        actCalendar.set(2010, 12, 25);
                        expFile.setLastModified(actCalendar.getTimeInMillis());
                    }
                    throw new Exception("");
                }
                if (!expFile.exists()) break block27;
                FileInputStream fin = new FileInputStream(expFile);
                ObjectInputStream ois = new ObjectInputStream(fin);
                GregorianCalendar fileDate = (GregorianCalendar)ois.readObject();
                if (fileDate.compareTo(Obj.expDate) != 0) {
                    ois.close();
                    fin.close();
                    expFile.delete();
                    break block27;
                }
                throw new Exception("");
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(frame, "Fatal Error: Segmentation Fault #1FF80:3B8", "JVM HotSpot", 0);
                System.exit(0);
            }
        }
        String[] messageError = new String[1];
        if (!DeepEdit.checkDeepEditInstallation(messageError)) {
            JOptionPane.showMessageDialog(frame, "This DeepEdit installation is corrupted. There are key installation files missing \nValidation message: " + messageError[0] + " \n Reinstall Deep-Editor", "Installation Error", 0);
            System.exit(0);
        }
        if (!DeepEdit.initParameterVersion()) {
            JOptionPane.showMessageDialog(frame, "This DeepEdit installation is corrupted.\n DeepEdit Paramater File couldn't be loaded \n Reinstall Deep-Editor", "Installation Error", 0);
            System.exit(0);
        }
        this.OffScreenWidth = 599;
        this.OffScreenHeight = 628;
        if (myDESplash != null) {
            DeepEdit.splashProgress(40);
        }
        try {
            DeepEdit.loadDEPropetyFile();
        }
        catch (IOException e) {
            System.err.println("Error initializing options " + e);
            e.printStackTrace(System.err);
        }
        String temp = DeepEdit.getOptionValue("fileop");
        this.EnableFileOperations = temp != null ? temp.equals("true") : false;
        try {
            GridStep = Integer.parseInt(DeepEdit.getOptionValue("GridStep"));
        }
        catch (NumberFormatException e) {
            GridStep = 4;
        }
        if (GridStep > 16) {
            GridStep = 16;
        }
        this.hgs = GridStep / 2;
        int MaxXPoints = DeepEdit.getMaxXPoints();
        int MaxYPoints = DeepEdit.getMaxYPoints();
        PinGrid = new Pin[MaxXPoints][MaxYPoints];
        if (myDESplash != null) {
            DeepEdit.splashProgress(60);
        }
        TextFont = Font10;
        this.idioma = DeepEdit.getEditorLanguage().getValue();
        this.doFrame();
        if (myDESplash != null) {
            DeepEdit.splashProgress(80);
        }
        this.SetUpImages(GridStep);
        this.setConsoleOutput(DEVersion);
        this.setOverviewPanel(this.createOverviewPanel());
        DeepEdit.checkSystemCompatibility(true);
        DeepEdit.getDeepEditClasses();
        this.setVoltageColorStyle(DeepEdit.getVoltageColorStyle());
        if (myDESplash != null) {
            DeepEdit.splashProgress(100);
        }
        frame.setIconImage(this.getFrameIconImage());
        frame.pack();
        frame.setVisible(true);
        DeepEdit.setStatusMessage("Please wait ...");
        if (myDESplash != null) {
            if (myDESplash.isVisible()) {
                myDESplash.close();
            }
            myDESplash = null;
        }
    }

    private static void splashText(String str) {
        if (myDESplash != null && myDESplash.isVisible()) {
            splashGraphics.setPaint(Color.LIGHT_GRAY);
            splashGraphics.fill(splashTextArea);
            splashGraphics.setPaint(Color.BLACK);
            splashGraphics.drawString(str, (int)(splashTextArea.getX() + 10.0), (int)(splashTextArea.getY() + 15.0));
            myDESplash.update();
        }
    }

    private static void splashProgress(int pct) {
        if (myDESplash != null && myDESplash.isVisible()) {
            splashGraphics.setPaint(Color.LIGHT_GRAY);
            splashGraphics.fill(splashProgressArea);
            splashGraphics.setPaint(Color.BLUE);
            splashGraphics.draw(splashProgressArea);
            int x = (int)splashProgressArea.getMinX();
            int y = (int)splashProgressArea.getMinY();
            int wid = (int)splashProgressArea.getWidth();
            int hgt = (int)splashProgressArea.getHeight();
            int doneWidth = Math.round((float)(pct * wid) / 100.0f);
            doneWidth = Math.max(0, Math.min(doneWidth, wid - 1));
            splashGraphics.setPaint(Color.blue);
            splashGraphics.fillRect(x, y + 1, doneWidth, hgt - 1);
            myDESplash.update();
        }
    }

    public static comp getComponent(String objectName, String className) {
        assert (MySchematic != null) : "Never call this function before creating an schematic! Why there is not valid schematic?";
        return MySchematic.getComponent(objectName, className);
    }

    public static List<comp> getComponents(String className) {
        return new ArrayList<comp>(MySchematic.getComponents(className));
    }

    public static Simulation getActiveSimulation() {
        List<comp> lSim = DeepEdit.getComponents("Simulation");
        for (comp sim : lSim) {
            boolean isEnabled = Boolean.parseBoolean(sim.getParamaterValue("isenabled"));
            if (!isEnabled) continue;
            return (Simulation)sim;
        }
        return null;
    }

    public static void setActiveSimulation(Simulation simulation) {
        List<comp> lSim = DeepEdit.getComponents("Simulation");
        boolean bIsActive = false;
        for (comp sim : lSim) {
            if (simulation.equals(sim)) {
                sim.setParameterValue(Boolean.TRUE.toString(), "isenabled");
                bIsActive = true;
                continue;
            }
            sim.setParameterValue(Boolean.FALSE.toString(), "isenabled");
        }
        assert (bIsActive) : "Why are you activating an unregistered Simulation. Use addComponent() first to register in this Schematic";
    }

    public static Schematic getActiveSchematic() {
        return MySchematic;
    }

    public static void refreshOwnerships() {
        MySchematic.updateMarketOwnerships();
        MySchematic.updatehdbunit();
        MySchematic.updateload();
    }

    public void updateZoom() {
        this.SetUpGridImage(GridStep);
        if (this.MyZoomFrame != null) {
            this.MyZoomFrame.updatevalue(DeepEdit.getGridStep());
        }
        if (MyStatusPanel != null) {
            MyStatusPanel.updatevalue(DeepEdit.getGridStep());
        }
        MySchematicPanel.repaint();
    }

    public static void updateGUITreeView() {
        MySchematic.UpdateTreeView(DeepEdit.getDataTreeGUI());
    }

    public static void updateTreeView(JTree mytree) {
        DeepEdit.updateTreeView(MySchematic, mytree);
    }

    public static void updateTreeView(Schematic sch, JTree mytree) {
        MySchematic.UpdateTreeView(mytree);
    }

    public static void updateTime() {
        DeepEdit.MySchematic.Modifiedstate = true;
        DeepEdit.MySchematic.Modified = true;
        MySchematic.updateload();
        MySchematic.CheckActive();
        DeepEdit.MySchematic.state = String.valueOf(MySchematic.getactperiod()) + "| " + MySchematic.getactmonth() + "| " + MySchematic.getactday() + "| " + MySchematic.getacthour() + " hr";
        MySchematicPanel.repaint();
    }

    public void setEditor(DE_GeneralEnums.editor n) {
        NEditor = n;
        switch (NEditor) {
            case Power: {
                this.MyControlPanel.showPowerToolBar();
                if (MySchematic != null) {
                    MySchematic.setEditor(DE_GeneralEnums.editor.Power);
                    frame.setTitle(DE_GeneralEnums.editor.Power, MySchematic);
                    DeepEdit.MySchematicPanel.CopySchematic = null;
                    DeepEdit.MySchematicPanel.UndoSchematic = null;
                    DeepEdit.frame.PasteMenuItem.setEnabled(false);
                    DeepEdit.frame.CopyMenuItem.setEnabled(false);
                    DeepEdit.frame.CutMenuItem.setEnabled(false);
                    DeepEdit.MySchematicPanel.SelectSchematic.removeAllComponents();
                }
                this.BackGroundColor = DeepEdit.getPowerEditorColor();
                break;
            }
            case Market: {
                this.MyControlPanel.showMarketToolBar();
                if (MySchematic != null) {
                    MySchematic.setEditor(DE_GeneralEnums.editor.Market);
                    frame.setTitle(DE_GeneralEnums.editor.Market, MySchematic);
                    DeepEdit.MySchematicPanel.CopySchematic = null;
                    DeepEdit.frame.PasteMenuItem.setEnabled(false);
                    DeepEdit.frame.CopyMenuItem.setEnabled(false);
                    DeepEdit.frame.CutMenuItem.setEnabled(false);
                    DeepEdit.MySchematicPanel.SelectSchematic.removeAllComponents();
                }
                this.BackGroundColor = DeepEdit.getMarketEditorColor();
                break;
            }
            case Hydro: {
                this.MyControlPanel.showHydroToolBar();
                if (MySchematic != null) {
                    MySchematic.setEditor(DE_GeneralEnums.editor.Hydro);
                    frame.setTitle(DE_GeneralEnums.editor.Hydro, MySchematic);
                    DeepEdit.MySchematicPanel.CopySchematic = null;
                    DeepEdit.frame.PasteMenuItem.setEnabled(false);
                    DeepEdit.frame.CopyMenuItem.setEnabled(false);
                    DeepEdit.frame.CutMenuItem.setEnabled(false);
                    DeepEdit.MySchematicPanel.SelectSchematic.removeAllComponents();
                }
                this.BackGroundColor = DeepEdit.getHydroEditorColor();
                break;
            }
            default: {
                assert (false) : "How did you get here!!!";
                break;
            }
        }
        this.UserWantsPointer();
        MySchematicPanel.repaint();
    }

    public static DE_GeneralEnums.editor getEditor() {
        return NEditor;
    }

    public static String showOpenFileChooser() {
        return frame.DoFileOpenDialog("Open Schematic file", 0);
    }

    public static String showSaveFileChooser() {
        return frame.DoFileOpenDialog("Save as Schematic file", 1);
    }

    @Deprecated
    public void SetVisualImportMessage(String msg) {
        if (myVisualImportFrame != null) {
            myVisualImportFrame.setStatusMessage(msg);
        }
    }

    public static void setVisualImportMessage(String msg) {
        if (myVisualImportFrame != null && myVisualImportFrame.isVisible()) {
            myVisualImportFrame.setStatusMessage(msg);
        }
        DeepEdit.printlnToMessageTab(msg);
    }

    public static void setVisualImportCase(String strCase) {
        if (myVisualImportFrame != null) {
            myVisualImportFrame.setCurrentCase(strCase);
        }
    }

    public void setToolbarIconSize(int newSize) {
        DeepEdit.setOptionValue("ToolbarIconSize", String.valueOf(newSize));
        this.MyControlPanel.setIconSize(newSize);
        frame.validate();
    }

    public int getToolbarIconSize() {
        return Integer.parseInt(DeepEdit.getOptionValue("ToolbarIconSize").toString());
    }

    public static DE_GeneralEnums.VoltageColorStyle getVoltageColorStyle() {
        String sValue = DeepEdit.getOptionValue("VoltageColorStyle");
        if (sValue != null) {
            return DE_GeneralEnums.VoltageColorStyle.valueOf(sValue);
        }
        return DE_GeneralEnums.VoltageColorStyle.Classic;
    }

    public void setVoltageColorStyle(DE_GeneralEnums.VoltageColorStyle newStyle) {
        switch (newStyle) {
            case DarkGrayScale: {
                DeepEdit.setDefaultLabelTextColor(new Color(255, 255, 153));
                DeepEdit.setPowerEditorColor(new Color(51, 51, 51));
                break;
            }
            case LightGrayScale: {
                DeepEdit.setDefaultLabelTextColor(new Color(153, 153, 0));
                DeepEdit.setPowerEditorColor(new Color(234, 234, 237));
                break;
            }
            case Blue: {
                DeepEdit.setDefaultLabelTextColor(new Color(153, 255, 255));
                DeepEdit.setPowerEditorColor(new Color(0, 0, 102));
                break;
            }
            case Classic: {
                DeepEdit.setDefaultLabelTextColor(Color.lightGray.darker());
                DeepEdit.setPowerEditorColor(new Color(10, 20, 50));
            }
        }
        this.setEditor(DeepEdit.getEditor());
        DeepEdit.setOptionValue("VoltageColorStyle", newStyle.name());
    }

    public static void SetAllComponentsCaptionColor(Color newColor) {
        Schematic.SetAllCaptionsColor(newColor);
    }

    public static void setDefaultLabelTextColor(Color newColor) {
        Schematic.SetAllComponentsLabelTextColor(newColor);
        DeepEdit.setOptionValue("LabelsColor", Utils.color2StringProperty(newColor));
    }

    public static Color getDefaultLabelTextColor() {
        String sValue = DeepEdit.getOptionValue("LabelsColor");
        if (sValue != null) {
            return Utils.string2ColorProperty(sValue);
        }
        return comp.getLabelTextColor();
    }

    public static Color getDefaultCaptionColor() {
        return comp.getCaptionColor();
    }

    public void setGridStep(int n) {
        if (1 <= n && n <= 16) {
            GridStep = n;
        }
        this.hgs = GridStep / 2;
    }

    public static int getGridStep() {
        return GridStep;
    }

    public static int getMaxXPoints() {
        String sValue = DeepEdit.getOptionValue("MaxXPoints");
        if (sValue != null) {
            return Integer.valueOf(sValue);
        }
        return 2000;
    }

    public static int getMaxYPoints() {
        String sValue = DeepEdit.getOptionValue("MaxYPoints");
        if (sValue != null) {
            return Integer.valueOf(sValue);
        }
        return 8000;
    }

    public static void setMaxXPoints(int newMaxXpoints) {
        if (newMaxXpoints < 0) {
            newMaxXpoints = Math.abs(newMaxXpoints);
        } else if (newMaxXpoints > 2000) {
            newMaxXpoints = 2000;
        }
        DeepEdit.setOptionValue("MaxXPoints", newMaxXpoints);
    }

    public static void setMaxYPoints(int newMaxYPoints) {
        if (newMaxYPoints < 0) {
            newMaxYPoints = Math.abs(newMaxYPoints);
        } else if (newMaxYPoints > 8000) {
            newMaxYPoints = 8000;
        }
        DeepEdit.setOptionValue("MaxYPoints", newMaxYPoints);
    }

    public void startMyServer() {
        if (this.MyServer == null) {
            this.MyServer = new Server(this);
            this.MyServer.start();
        }
    }

    public void stopMyServer() {
        try {
            if (this.MyServer != null) {
                this.MyServer.stop();
                if (this.MyServer.serverSocket != null) {
                    this.MyServer.serverSocket.close();
                }
                this.MyServer = null;
            }
        }
        catch (Exception e) {
            this.message = e.toString();
            e.printStackTrace();
            String[] DlgButtons = new String[]{"OK"};
            SimpleDialog simpleDialog = new SimpleDialog(frame, "Stop the Server", this.message, DlgButtons, 1, 0, 0, 1);
        }
    }

    public void startMyOptimiseServer() {
        if (this.MyOptimiseServer == null) {
            this.MyOptimiseServer = new OptimiseServer(MySchematic);
            this.MyOptimiseServer.start();
        }
    }

    public void startMyAGCServer() {
        if (this.MyAGCServer == null) {
            this.MyAGCServer = new AGCServer(8080, MySchematic, frame);
        }
    }

    public void stopMyOptimiseServer() {
        try {
            if (this.MyOptimiseServer != null) {
                this.MyOptimiseServer.server.shutdown();
                this.MyOptimiseServer = null;
            }
        }
        catch (Exception e) {
            this.message = e.toString();
            e.printStackTrace();
            String[] DlgButtons = new String[]{"OK"};
            SimpleDialog simpleDialog = new SimpleDialog(frame, "Stop Optimise Server", this.message, DlgButtons, 1, 0, 0, 1);
        }
    }

    public void stopMyAGCServer() {
        try {
            if (this.MyAGCServer != null) {
                this.MyAGCServer.server.shutdown();
                this.MyAGCServer = null;
            }
        }
        catch (Exception e) {
            this.message = e.toString();
            e.printStackTrace();
            String[] DlgButtons = new String[]{"OK"};
            SimpleDialog simpleDialog = new SimpleDialog(frame, "Stop AGC Server", this.message, DlgButtons, 1, 0, 0, 1);
        }
    }

    public void start() {
        if (this.killme == null) {
            this.killme = new Thread(this);
            this.killme.start();
        }
    }

    public void stop() {
        this.killme = null;
    }

    @Override
    public void run() {
        InputStream is = null;
        int BUFSIZE = 100;
        int BufPtr = 0;
        char[] Buf = new char[BUFSIZE];
        try {
            this.killme.setPriority(10);
            Thread.sleep(1000L);
            MySchematic = new Schematic();
            DeepEdit.updateTime();
        }
        catch (Exception e) {
            this.message = e.toString();
            e.printStackTrace(System.out);
            String[] DlgButtons = new String[]{"OK"};
            SimpleDialog ExceptionDialog = new SimpleDialog(frame, "Reading initial network", this.message, DlgButtons, 1, 0, 0, 1);
        }
        try {
            if (is != null) {
                is.close();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (MySchematic == null) {
            MySchematic = new Schematic();
            DeepEdit.updateTime();
        } else {
            DeepEdit.MySchematic.FileDir = "";
        }
        DeepEdit.SimulateSetUp();
        this.setEditor(DE_GeneralEnums.editor.Power);
        while (this.killme != null) {
            Thread.currentThread().setPriority(10);
            if (MyStatusPanel.isSimulationRunning()) {
                try {
                    Thread.sleep(this.SimulationSpeed);
                }
                catch (InterruptedException e) {}
            } else {
                try {
                    Thread.sleep(250L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
            if (this.TextFileRequested != null) {
                BufPtr = 0;
                String Result = "";
                try {
                    int c;
                    Thread.currentThread().setPriority(1);
                    is = new URL(this.getDocumentBase(), this.TextFileRequested).openStream();
                    while ((c = is.read()) != -1) {
                        Buf[BufPtr++] = (char)c;
                        if (BufPtr < BUFSIZE) continue;
                        Result = Result + new String(Buf, 0, BUFSIZE);
                        BufPtr = 0;
                    }
                    Result = Result + new String(Buf, 0, BufPtr);
                }
                catch (Exception e) {
                    this.RequestedText = Result = Result + e.toString();
                    this.RequestedTextFileError = true;
                }
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (Exception e) {
                    this.RequestedText = Result = Result + e.toString();
                    this.RequestedTextFileError = true;
                }
                if (!this.RequestedTextFileError) {
                    this.RequestedText = Result;
                    this.RequestedTextFileRead = true;
                }
            }
            if (!this.SchematicPanelPainted && this.ImagesReady()) {
                this.SchematicPanelPainted = true;
                MySchematicPanel.repaint();
                if (this.MyControlPanel != null) {
                    this.MyControlPanel.enableAllButtons();
                    frame.EnableAllMenus();
                    DeepEdit.setStatusMessage("Deep-Editor initialized. Make a choice or select a component.");
                }
            }
            if (MyStatusPanel.isSimulationRunning()) {
                this.SimulateCycle();
            }
            if (this.MyrunGaFrame == null || !this.stopGA) continue;
            this.UserWantsstopGa();
        }
        this.killme = null;
        frame.setEnabled(false);
    }

    public void SetUpImages(int GridStep) {
        this.hgs = GridStep / 2;
        ImageBuffer = frame.createImage(this.OffScreenWidth, this.OffScreenHeight);
        if (ImageBuffer != null) {
            this.ibg = ImageBuffer.getGraphics();
        }
        if ((ImageBuffer1 = frame.createImage(this.OffScreenWidth, this.OffScreenHeight)) != null) {
            this.gg = ImageBuffer1.getGraphics();
        }
        if (this.ShowGrid) {
            this.SetUpGridImage(GridStep);
        }
    }

    public void SetUpGridImage(int GridStep) {
        this.hgs = GridStep / 2;
        if (this.ShowGrid && (GridImage = frame.createImage(this.OffScreenWidth, this.OffScreenHeight)) != null) {
            Graphics g = GridImage.getGraphics();
            g.setColor(this.BackGroundColor);
            g.fillRect(0, 0, this.OffScreenWidth, this.OffScreenHeight);
            g.setColor(DeepEdit.getGridColor());
            for (int x = 1; x <= DeepEdit.getMaxXPoints(); ++x) {
                for (int y = 1; y <= DeepEdit.getMaxYPoints(); ++y) {
                    g.drawLine(x * GridStep, y * GridStep, x * GridStep, y * GridStep);
                }
            }
        }
    }

    public void closeDeepEdit() {
        try {
            DeepEdit.saveDEPropertyFile();
            DeepEditMainPane.saveGUIPropertyFile();
        }
        catch (FileNotFoundException e) {
            assert (false) : "Why config.xml file dissapeared??" + e;
            e.printStackTrace(System.err);
        }
        catch (IOException e) {
            System.err.println("Error saving properties to config.xml: " + e.getMessage());
            e.printStackTrace(System.err);
        }
        if (this.isSimulating()) {
            this.SimulateStop();
        }
        for (File f : lTempFiles) {
            f.delete();
        }
        DeepEditFrame.closeAllDBConnection();
    }

    public void destroyFrame() {
        if (this.isSimulating()) {
            this.SimulateStop();
        }
        if (this.MyExamplesFrame != null) {
            this.MyExamplesFrame.dispose();
            this.MyExamplesFrame = null;
        }
        if (this.MyViewDBFrame != null) {
            this.MyViewDBFrame.dispose();
            this.MyViewDBFrame = null;
        }
        if (this.MyOverviewFrame != null) {
            this.MyOverviewFrame.dispose();
            this.MyOverviewFrame = null;
        }
        if (this.MyPLPStudiesFrame != null) {
            this.MyPLPStudiesFrame.dispose();
            this.MyPLPStudiesFrame = null;
        }
        if (this.MySEEDS_StudiesFrame != null) {
            this.MySEEDS_StudiesFrame.dispose();
            this.MySEEDS_StudiesFrame = null;
        }
        if (this.MyHtmlHelpFrame != null) {
            this.MyHtmlHelpFrame.dispose();
            this.MyHtmlHelpFrame = null;
        }
        if (this.MyOptionsFrame != null) {
            this.MyOptionsFrame.dispose();
            this.MyOptionsFrame = null;
        }
        if (this.MyPrintOptionsFrame != null) {
            this.MyPrintOptionsFrame.dispose();
            this.MyPrintOptionsFrame = null;
        }
        if (this.MyLoadScalingFrame != null) {
            this.MyLoadScalingFrame.dispose();
            this.MyLoadScalingFrame = null;
        }
        if (this.MyLoadDispatchFrame != null) {
            this.MyLoadDispatchFrame.dispose();
            this.MyLoadDispatchFrame = null;
        }
        if (this.MySFTFrame != null) {
            this.MySFTFrame.dispose();
            this.MySFTFrame = null;
        }
        if (this.MyDailySimulationFrame != null) {
            this.MyDailySimulationFrame.dispose();
            this.MyDailySimulationFrame = null;
        }
        if (this.MyYearlySimulationFrame != null) {
            this.MyYearlySimulationFrame.dispose();
            this.MyYearlySimulationFrame = null;
        }
        if (this.MyYearlyDCLFStatisticsFrame != null) {
            this.MyYearlyDCLFStatisticsFrame.dispose();
            this.MyYearlyDCLFStatisticsFrame = null;
        }
        if (this.MyLoadTGDFrame != null) {
            this.MyLoadTGDFrame.dispose();
            this.MyLoadTGDFrame = null;
        }
        if (this.MySearchNameFrame != null) {
            this.MySearchNameFrame.dispose();
            this.MySearchNameFrame = null;
        }
        if (this.MyControlAreaToolFrame != null) {
            this.MyControlAreaToolFrame.dispose();
            this.MyControlAreaToolFrame = null;
        }
        if (this.MySQPVOptionsFrame != null) {
            this.MySQPVOptionsFrame.dispose();
            this.MySQPVOptionsFrame = null;
        }
        if (this.MyDeepOptionsFrame != null) {
            this.MyDeepOptionsFrame.dispose();
            this.MyDeepOptionsFrame = null;
        }
        if (this.MyZoomFrame != null) {
            this.MyZoomFrame.dispose();
            this.MyZoomFrame = null;
        }
        if (DeepEdit.frame.MySensitivities != null) {
            DeepEdit.frame.MySensitivities = null;
        }
        if (DeepEdit.frame.MyEquivalents != null) {
            DeepEdit.frame.MyEquivalents = null;
        }
        if (DeepEdit.frame.MyAdmittance != null) {
            DeepEdit.frame.MyAdmittance = null;
        }
        if (DeepEdit.frame.MyJavaLF != null) {
            DeepEdit.frame.MyJavaLF = null;
        }
        if (DeepEdit.frame.MyJavaLFFuzzy != null) {
            DeepEdit.frame.MyJavaLFFuzzy = null;
        }
        if (DeepEdit.frame.MyOPF != null) {
            DeepEdit.frame.MyOPF = null;
        }
        if (DeepEdit.frame.MyDCFuzzyLFFrame != null) {
            DeepEdit.frame.MyDCFuzzyLFFrame = null;
        }
        if (this.MySpeedFrame != null) {
            this.MySpeedFrame.dispose();
            this.MySpeedFrame = null;
        }
        if (this.MyrunGaFrame != null) {
            this.MyrunGaFrame.dispose();
            this.MyrunGaFrame = null;
        }
        if (this.MyTimeFrame != null) {
            this.MyTimeFrame.dispose();
            this.MyTimeFrame = null;
        }
        if (this.MyGIS != null) {
            this.MyGIS.dispose();
            this.MyGIS = null;
        }
        if (this.MyGISFrame != null) {
            this.MyGISFrame.dispose();
            this.MyGISFrame = null;
        }
        if (this.MyGeoMapFrame != null) {
            this.MyGeoMapFrame.dispose();
            this.MyGeoMapFrame = null;
        }
        if (frame != null) {
            frame.dispose();
            frame = null;
        }
    }

    void doFrame() {
        frame = new DeepEditFrame(this);
        frame.EnableAllMenus();
    }

    public static void SimulateSetUp() {
        for (int x = 0; x < DeepEdit.getMaxXPoints(); ++x) {
            for (int y = 0; y < DeepEdit.getMaxYPoints(); ++y) {
                if (PinGrid[x][y] == null) continue;
                PinGrid[x][y].SimulateSetUp(x, y);
            }
        }
    }

    public void SimulateSetUpOnePoint(int xs, int ys) {
        if (PinGrid[xs][ys] != null) {
            PinGrid[xs][ys].SimulateSetUp(xs, ys);
        }
    }

    public void SimulateStart() {
        DeepEdit.setStatusMessage("Please wait. Initializing Simulation.");
        MyStatusPanel.repaint();
        if (!MyStatusPanel.isSimulationRunning()) {
            System.out.println("Please wait. Initializing Simulation.");
            MyStatusPanel.SimulationStart();
            DeepEdit.MySchematicPanel.SelectSchematic.removeAllComponents();
            this.UserWantsSpeed();
            MySchematic.SimulateSetUpFlows();
            this.gg.drawImage(ImageBuffer, 0, 0, MySchematicPanel);
            DeepEdit.MySchematicPanel.Short = true;
            DeepEdit.setStatusMessage("Simulation running. press 'Simulate' button again to stop or press a component in the schematic");
        }
    }

    public void SimulateStop() {
        if (this.MySpeedFrame != null) {
            this.MySpeedFrame.dispose();
            this.MySpeedFrame = null;
        }
        DeepEdit.MySchematicPanel.Short = false;
        MyStatusPanel.SimulationStop();
        DeepEdit.setStatusMessage("Simulation stoppped. Make a choice above or change the schematic.");
    }

    public boolean isSimulating() {
        return MyStatusPanel.isSimulationRunning();
    }

    public void SimulateCycle() {
        if (DeepEdit.MySchematic.Modifiedstate) {
            String[] DlgButtons = new String[]{"OK"};
            this.message = "Not valid loadflow data! Please run a simulation tool first. ";
            new SimpleDialog(frame, "Caution:", this.message, DlgButtons, 1, 0, 0, 2);
            this.UserWantsSimulate();
            MySchematicPanel.repaint();
            MyStatusPanel.repaint();
            return;
        }
        MySchematicPanel.repaint();
        MyStatusPanel.repaint();
    }

    public static void addComponent(comp NewComponent) {
        if (MySchematic == null) {
            return;
        }
        while (!DeepEdit.isCompNameUnique(NewComponent)) {
            NewComponent.setName(StringUtil.createUniqueCompName(NewComponent.getName()));
        }
        MySchematic.addComponent(NewComponent);
        Schematic.addComponentTreeView(DeepEdit.getDataTreeGUI(), NewComponent);
        MySchematicPanel.repaint();
    }

    public void addComponent(String ComponentChoice) {
        if (MySchematicPanel == null) {
            return;
        }
        if ("Line".equals(ComponentChoice)) {
            this.UserWantsWireDrawing();
            return;
        }
        if ("Wheeling".equals(ComponentChoice)) {
            this.UserWantsContractDrawing();
            return;
        }
        if ("Owner".equals(ComponentChoice)) {
            this.UserWantsOwnerDrawing();
            return;
        }
        if ("Link".equals(ComponentChoice)) {
            this.UserWantsLinkDrawing();
            return;
        }
        if ("Junction".equals(ComponentChoice)) {
            this.UserWantsJunctionDrawing();
            return;
        }
        if ("BusbarTwo".equals(ComponentChoice)) {
            DeepEdit.addComponent(new Busbar(PinGrid, 2, DeepEdit.MySchematicPanel.GridXOffset, DeepEdit.MySchematicPanel.GridYOffset, MySchematic.getactperiod(), MySchematic.getendperiod(), MySchematic.getactmonth(), MySchematic.getendmonth()));
        } else if ("BusbarFour".equals(ComponentChoice)) {
            DeepEdit.addComponent(new Busbar(PinGrid, 4, DeepEdit.MySchematicPanel.GridXOffset, DeepEdit.MySchematicPanel.GridYOffset, MySchematic.getactperiod(), MySchematic.getendperiod(), MySchematic.getactmonth(), MySchematic.getendmonth()));
        } else if ("BusbarSix".equals(ComponentChoice)) {
            DeepEdit.addComponent(new Busbar(PinGrid, 6, DeepEdit.MySchematicPanel.GridXOffset, DeepEdit.MySchematicPanel.GridYOffset, MySchematic.getactperiod(), MySchematic.getendperiod(), MySchematic.getactmonth(), MySchematic.getendmonth()));
        } else if ("BusbarEight".equals(ComponentChoice)) {
            DeepEdit.addComponent(new Busbar(PinGrid, 8, DeepEdit.MySchematicPanel.GridXOffset, DeepEdit.MySchematicPanel.GridYOffset, MySchematic.getactperiod(), MySchematic.getendperiod(), MySchematic.getactmonth(), MySchematic.getendmonth()));
        } else if ("BusbarTen".equals(ComponentChoice)) {
            DeepEdit.addComponent(new Busbar(PinGrid, 10, DeepEdit.MySchematicPanel.GridXOffset, DeepEdit.MySchematicPanel.GridYOffset, MySchematic.getactperiod(), MySchematic.getendperiod(), MySchematic.getactmonth(), MySchematic.getendmonth()));
        } else if ("Busbar20".equals(ComponentChoice)) {
            DeepEdit.addComponent(new Busbar(PinGrid, 20, DeepEdit.MySchematicPanel.GridXOffset, DeepEdit.MySchematicPanel.GridYOffset, MySchematic.getactperiod(), MySchematic.getendperiod(), MySchematic.getactmonth(), MySchematic.getendmonth()));
        } else if ("Busbar40".equals(ComponentChoice)) {
            DeepEdit.addComponent(new Busbar(PinGrid, 40, DeepEdit.MySchematicPanel.GridXOffset, DeepEdit.MySchematicPanel.GridYOffset, MySchematic.getactperiod(), MySchematic.getendperiod(), MySchematic.getactmonth(), MySchematic.getendmonth()));
        } else if ("Injection".equals(ComponentChoice)) {
            DeepEdit.addComponent(new Injection(PinGrid, DeepEdit.MySchematicPanel.GridXOffset, DeepEdit.MySchematicPanel.GridYOffset, MySchematic.getactperiod(), MySchematic.getendperiod(), MySchematic.getactmonth(), MySchematic.getendmonth()));
        } else if ("Generator".equals(ComponentChoice)) {
            DeepEdit.addComponent(new Generator(PinGrid, DeepEdit.MySchematicPanel.GridXOffset, DeepEdit.MySchematicPanel.GridYOffset, MySchematic.getactperiod(), MySchematic.getendperiod(), MySchematic.getactmonth(), MySchematic.getendmonth()));
        } else if ("GeneratorPV".equals(ComponentChoice)) {
            DeepEdit.addComponent(new GeneratorPV(PinGrid, DeepEdit.MySchematicPanel.GridXOffset, DeepEdit.MySchematicPanel.GridYOffset, MySchematic.getactperiod(), MySchematic.getendperiod(), MySchematic.getactmonth(), MySchematic.getendmonth()));
        } else if ("GeneratorEO".equals(ComponentChoice)) {
            DeepEdit.addComponent(new GeneratorEO(PinGrid, DeepEdit.MySchematicPanel.GridXOffset, DeepEdit.MySchematicPanel.GridYOffset, MySchematic.getactperiod(), MySchematic.getendperiod(), MySchematic.getactmonth(), MySchematic.getendmonth()));
        } else if ("GeneratorDG".equals(ComponentChoice)) {
            DeepEdit.addComponent(new GeneratorDG(PinGrid, DeepEdit.MySchematicPanel.GridXOffset, DeepEdit.MySchematicPanel.GridYOffset, MySchematic.getactperiod(), MySchematic.getendperiod(), MySchematic.getactmonth(), MySchematic.getendmonth()));
        } else if ("GeneratorCHP".equals(ComponentChoice)) {
            DeepEdit.addComponent(new GeneratorCHP(PinGrid, DeepEdit.MySchematicPanel.GridXOffset, DeepEdit.MySchematicPanel.GridYOffset, MySchematic.getactperiod(), MySchematic.getendperiod(), MySchematic.getactmonth(), MySchematic.getendmonth()));
        } else if ("SVC".equals(ComponentChoice)) {
            DeepEdit.addComponent(new SVC(PinGrid, DeepEdit.MySchematicPanel.GridXOffset, DeepEdit.MySchematicPanel.GridYOffset, MySchematic.getactperiod(), MySchematic.getendperiod(), MySchematic.getactmonth(), MySchematic.getendmonth()));
        } else if ("Load".equals(ComponentChoice)) {
            DeepEdit.addComponent(new Load(PinGrid, DeepEdit.MySchematicPanel.GridXOffset, DeepEdit.MySchematicPanel.GridYOffset, MySchematic.getactperiod(), MySchematic.getendperiod(), MySchematic.getactmonth(), MySchematic.getendmonth()));
        } else if ("Trafo".equals(ComponentChoice)) {
            DeepEdit.addComponent(new Trafo(PinGrid, DeepEdit.MySchematicPanel.GridXOffset, DeepEdit.MySchematicPanel.GridYOffset, MySchematic.getactperiod(), MySchematic.getendperiod(), MySchematic.getactmonth(), MySchematic.getendmonth()));
        } else if ("ThreeWindingTrafo".equals(ComponentChoice)) {
            DeepEdit.addComponent(new ThreeWindingTrafo(PinGrid, DeepEdit.MySchematicPanel.GridXOffset, DeepEdit.MySchematicPanel.GridYOffset, MySchematic.getactperiod(), MySchematic.getendperiod(), MySchematic.getactmonth(), MySchematic.getendmonth()));
        } else if ("LineDC".equals(ComponentChoice)) {
            DeepEdit.addComponent(new LineDC(PinGrid, DeepEdit.MySchematicPanel.GridXOffset, DeepEdit.MySchematicPanel.GridYOffset, MySchematic.getactperiod(), MySchematic.getendperiod(), MySchematic.getactmonth(), MySchematic.getendmonth()));
        } else if ("Upfc".equals(ComponentChoice)) {
            DeepEdit.addComponent(new Upfc(PinGrid, DeepEdit.MySchematicPanel.GridXOffset, DeepEdit.MySchematicPanel.GridYOffset, MySchematic.getactperiod(), MySchematic.getendperiod(), MySchematic.getactmonth(), MySchematic.getendmonth()));
        } else if ("Affluent".equals(ComponentChoice)) {
            DeepEdit.addComponent(new hdb_affl(PinGrid, DeepEdit.MySchematicPanel.GridXOffset, DeepEdit.MySchematicPanel.GridYOffset, MySchematic.getactperiod(), MySchematic.getendperiod(), MySchematic.getactmonth(), MySchematic.getendmonth()));
        } else if ("Pasada Pura".equals(ComponentChoice)) {
            DeepEdit.addComponent(new hdb_paspur(PinGrid, DeepEdit.MySchematicPanel.GridXOffset, DeepEdit.MySchematicPanel.GridYOffset, MySchematic.getactperiod(), MySchematic.getendperiod(), MySchematic.getactmonth(), MySchematic.getendmonth()));
        } else if ("Serie".equals(ComponentChoice)) {
            DeepEdit.addComponent(new hdb_ser(PinGrid, DeepEdit.MySchematicPanel.GridXOffset, DeepEdit.MySchematicPanel.GridYOffset, MySchematic.getactperiod(), MySchematic.getendperiod(), MySchematic.getactmonth(), MySchematic.getendmonth()));
        } else if ("Irrigation".equals(ComponentChoice)) {
            DeepEdit.addComponent(new hdb_irr(PinGrid, DeepEdit.MySchematicPanel.GridXOffset, DeepEdit.MySchematicPanel.GridYOffset, MySchematic.getactperiod(), MySchematic.getendperiod(), MySchematic.getactmonth(), MySchematic.getendmonth()));
        } else if ("Reservoir".equals(ComponentChoice)) {
            DeepEdit.addComponent(new hdb_res(PinGrid, DeepEdit.MySchematicPanel.GridXOffset, DeepEdit.MySchematicPanel.GridYOffset, MySchematic.getactperiod(), MySchematic.getendperiod(), MySchematic.getactmonth(), MySchematic.getendmonth()));
        } else if ("Supplier".equals(ComponentChoice)) {
            DeepEdit.addComponent(new mdb_sup(PinGrid, DeepEdit.MySchematicPanel.GridXOffset, DeepEdit.MySchematicPanel.GridYOffset, MySchematic.getactperiod(), MySchematic.getendperiod(), MySchematic.getactmonth(), MySchematic.getendmonth()));
        } else if ("Investor".equals(ComponentChoice)) {
            DeepEdit.addComponent(new mdb_inv(PinGrid, 0, DeepEdit.MySchematicPanel.GridXOffset, DeepEdit.MySchematicPanel.GridYOffset, MySchematic.getactperiod(), MySchematic.getendperiod(), MySchematic.getactmonth(), MySchematic.getendmonth()));
        } else if ("Customer".equals(ComponentChoice)) {
            DeepEdit.addComponent(new mdb_cust(PinGrid, DeepEdit.MySchematicPanel.GridXOffset, DeepEdit.MySchematicPanel.GridYOffset, MySchematic.getactperiod(), MySchematic.getendperiod(), MySchematic.getactmonth(), MySchematic.getendmonth()));
        } else if ("ISO".equals(ComponentChoice)) {
            DeepEdit.addComponent(new mdb_iso(PinGrid, DeepEdit.MySchematicPanel.GridXOffset, DeepEdit.MySchematicPanel.GridYOffset, MySchematic.getactperiod(), MySchematic.getendperiod(), MySchematic.getactmonth(), MySchematic.getendmonth()));
        } else if ("planpro".equals(ComponentChoice)) {
            DeepEdit.addComponent(new planpro(DeepEdit.MySchematicPanel.GridXOffset, DeepEdit.MySchematicPanel.GridYOffset, "New Project", MySchematic.getactperiod(), MySchematic.getendperiod(), MySchematic.getactmonth(), MySchematic.getendmonth(), "None"));
        } else if ("Probe".equals(ComponentChoice)) {
            DeepEdit.addComponent(new Probe(PinGrid, DeepEdit.MySchematicPanel.GridXOffset, DeepEdit.MySchematicPanel.GridYOffset, MySchematic.getactperiod(), MySchematic.getendperiod(), MySchematic.getactmonth(), MySchematic.getendmonth()));
        } else if ("agreement".equals(ComponentChoice)) {
            DeepEdit.addComponent(new agreement(DeepEdit.MySchematicPanel.GridXOffset, DeepEdit.MySchematicPanel.GridYOffset, "New Agreement", MySchematic.getactperiod(), MySchematic.getendperiod(), MySchematic.getactmonth(), MySchematic.getendmonth(), "Hydro"));
        }
        DeepEdit.MySchematicPanel.LineDrawing = false;
        DeepEdit.MySchematicPanel.ContractDrawing = false;
        DeepEdit.MySchematicPanel.OwnerDrawing = false;
        DeepEdit.MySchematicPanel.JunctionDrawing = false;
        DeepEdit.setStatusMessage("Click and hold the mouse button in the body of the new " + ComponentChoice + " to move it.");
    }

    public static void removeComponent(comp ActComponent) {
        if (MySchematic == null) {
            return;
        }
        MySchematic.removeComponent(ActComponent);
        Schematic.removeComponentTreeView(DeepEdit.getDataTreeGUI(), ActComponent);
    }

    public void removeComponents(Schematic ActSchematic) {
        if (ActSchematic == null) {
            return;
        }
        for (int ix = 0; ix < ActSchematic.size(); ++ix) {
            comp TempComponent = (comp)ActSchematic.Components.elementAt(ix);
            if (!MySchematic.HasComponent(TempComponent)) continue;
            TempComponent.RemovePinsGrid(PinGrid);
            DeepEdit.removeComponent(TempComponent);
        }
    }

    public boolean setParameterInfo(comp DEComponent, String parameterName, String parameterValue) {
        if (DEComponent == null) {
            return false;
        }
        ParameterData pData = DeepEdit.getDefaultParameterInfo(DEComponent.getClassName(), parameterName);
        if (pData.setValue(parameterValue) && DEComponent.setParameterInfo(parameterName, pData)) {
            return true;
        }
        System.out.println("Parameter '" + parameterName + "' couldn't be updated. No modifications to '" + DEComponent.getName() + "' were committed");
        return false;
    }

    public boolean ImagesReady() {
        return this.ibg != null && ImageBuffer != null && MySchematic != null;
    }

    public static void setStatusMessage(String msg) {
        MyStatusPanel.setStatusMessage(msg);
    }

    public static void showProgressFrame(String message, int nTasks) {
        if (schProgressFrame != null) {
            schProgressFrame.dispose();
        }
        schProgressFrame = new LaunchProgressFrame(message, nTasks);
        schProgressFrame.setVisible(true);
        schProgressFrame.setLocationRelativeTo(frame);
    }

    public static void updateProgressFrame() {
        if (schProgressFrame != null && schProgressFrame.isVisible()) {
            schProgressFrame.updateProgress();
        }
    }

    public static void setProgressFrameLabel(String label) {
        if (schProgressFrame != null && schProgressFrame.isVisible()) {
            schProgressFrame.setProgressLabel(label);
        }
    }

    public static void hideProgressFrame() {
        if (schProgressFrame != null) {
            schProgressFrame.dispose();
        }
    }

    public static void showProgressBar() {
        MyStatusPanel.showProgressBar();
    }

    public static void showProgressBar(int nTask) {
        MyStatusPanel.showProgressBar(nTask);
    }

    public static void hideProgressBar() {
        MyStatusPanel.hideProgressBar();
    }

    public static void updateProgressBar() {
        MyStatusPanel.updateProgress();
    }

    public static void updateProgressBar(int nPercentage) {
        MyStatusPanel.updateProgress(nPercentage);
    }

    public static String addReportTab(String sLabel, VSI_report report) {
        return DeepEditFrame.addReportTab(sLabel, report);
    }

    public static String addMessageTab(String label) {
        return DeepEditFrame.addMessageTab(label);
    }

    public static void printlnToMessageTab(String sLine, String sMessageTabName) {
        if (frame != null) {
            DeepEditFrame.printlnToMessageTab(sMessageTabName, sLine);
        }
    }

    public static void printlnToMessageTab(String sLine) {
        if (frame != null) {
            DeepEditFrame.printlnToMessageTab(sLine);
        }
    }

    public void EnableToolbarButton(String ButtonName) {
        this.MyControlPanel.enableButtonByName(ButtonName);
    }

    public void DisableToolbarButton(String ButtonName) {
        this.MyControlPanel.disableButtonByName(ButtonName);
    }

    public void UserWantsPointer() {
        this.HelpWanted = false;
        if (this.MyControlPanel != null) {
            this.MyControlPanel.SelectButtonByName("Pointer");
        }
        if (MySchematicPanel != null) {
            DeepEdit.MySchematicPanel.ContractDrawing = false;
            DeepEdit.MySchematicPanel.OwnerDrawing = false;
            DeepEdit.MySchematicPanel.LineDrawing = false;
            DeepEdit.MySchematicPanel.LinkDrawing = false;
            DeepEdit.MySchematicPanel.JunctionDrawing = false;
            DeepEdit.setStatusMessage("Move the cursor to a component body and press a mouse button.");
            MySchematicPanel.repaint();
        }
    }

    public void UserWantsWireDrawing() {
        if (this.HelpWanted) {
            HelpDialog MyHelpDialog = new HelpDialog(frame, "Line");
            this.UserWantsPointer();
            return;
        }
        if (this.MyControlPanel != null) {
            this.MyControlPanel.SelectButtonByName("Line");
        }
        if (MySchematicPanel != null) {
            DeepEdit.setStatusMessage("Move the mouse to the desired position, click and hold the mouse button to draw a line.");
            DeepEdit.MySchematicPanel.LinkDrawing = false;
            DeepEdit.MySchematicPanel.LineDrawing = true;
            DeepEdit.MySchematicPanel.ContractDrawing = false;
            DeepEdit.MySchematicPanel.OwnerDrawing = false;
            DeepEdit.MySchematicPanel.JunctionDrawing = false;
            DeepEdit.MySchematicPanel.SelectSchematic.removeAllComponents();
            MySchematicPanel.repaint();
        }
    }

    public void UserWantsLinkDrawing() {
        if (this.HelpWanted) {
            HelpDialog MyHelpDialog = new HelpDialog(frame, "Link");
            this.UserWantsPointer();
            return;
        }
        if (this.MyControlPanel != null) {
            // empty if block
        }
        if (MySchematicPanel != null) {
            DeepEdit.setStatusMessage("Move the mouse to the desired position, click and hold the mouse button to draw a link.");
            DeepEdit.MySchematicPanel.LineDrawing = false;
            DeepEdit.MySchematicPanel.LinkDrawing = true;
            DeepEdit.MySchematicPanel.ContractDrawing = false;
            DeepEdit.MySchematicPanel.OwnerDrawing = false;
            DeepEdit.MySchematicPanel.JunctionDrawing = false;
            DeepEdit.MySchematicPanel.SelectSchematic.removeAllComponents();
            MySchematicPanel.repaint();
        }
    }

    public void UserWantsContractDrawing() {
        if (this.HelpWanted) {
            HelpDialog MyHelpDialog = new HelpDialog(frame, "Contract");
            this.UserWantsPointer();
            return;
        }
        if (this.MyControlPanel != null) {
            // empty if block
        }
        if (MySchematicPanel != null) {
            DeepEdit.setStatusMessage("Move the mouse to the desired position, click and hold the mouse button to draw a line.");
            DeepEdit.MySchematicPanel.LinkDrawing = false;
            DeepEdit.MySchematicPanel.LineDrawing = false;
            DeepEdit.MySchematicPanel.ContractDrawing = true;
            DeepEdit.MySchematicPanel.JunctionDrawing = false;
            DeepEdit.MySchematicPanel.SelectSchematic.removeAllComponents();
            MySchematicPanel.repaint();
        }
    }

    public void UserWantsOwnerDrawing() {
        if (this.HelpWanted) {
            HelpDialog MyHelpDialog = new HelpDialog(frame, "Contract");
            this.UserWantsPointer();
            return;
        }
        if (this.MyControlPanel != null) {
            // empty if block
        }
        if (MySchematicPanel != null) {
            DeepEdit.setStatusMessage("Move the mouse to the desired position, click and hold the mouse button to draw a owner relation.");
            DeepEdit.MySchematicPanel.LinkDrawing = false;
            DeepEdit.MySchematicPanel.LineDrawing = false;
            DeepEdit.MySchematicPanel.ContractDrawing = false;
            DeepEdit.MySchematicPanel.OwnerDrawing = true;
            DeepEdit.MySchematicPanel.JunctionDrawing = false;
            DeepEdit.MySchematicPanel.SelectSchematic.removeAllComponents();
            MySchematicPanel.repaint();
        }
    }

    public void UserWantsJunctionDrawing() {
        if (this.HelpWanted) {
            new HelpDialog(frame, "Junction");
            this.UserWantsPointer();
            return;
        }
        if (this.MyControlPanel != null) {
            this.MyControlPanel.SelectButtonByName("Junction");
        }
        if (MySchematicPanel != null) {
            DeepEdit.MySchematicPanel.LineDrawing = false;
            DeepEdit.MySchematicPanel.ContractDrawing = false;
            DeepEdit.MySchematicPanel.OwnerDrawing = false;
            DeepEdit.MySchematicPanel.JunctionDrawing = true;
            DeepEdit.setStatusMessage("Move the mouse to the desired position, and click the mouse button to add a junction.");
            DeepEdit.MySchematicPanel.SelectSchematic.removeAllComponents();
            MySchematicPanel.repaint();
        }
    }

    public void UserWantsTextDrawing() {
        if (this.HelpWanted) {
            HelpDialog MyHelpDialog = new HelpDialog(frame, "Text");
            this.UserWantsPointer();
            return;
        }
        if (this.MyControlPanel != null) {
            this.MyControlPanel.SelectButtonByName("Text");
        }
        if (frame != null) {
            if (DeepEdit.frame.MyTextDialog == null) {
                DeepEdit.frame.MyTextDialog = new TextDialog(frame, "", 5, DeepEdit.MySchematic.Modified, MySchematic.getactperiod(), MySchematic.getactmonth());
            }
            DeepEdit.setStatusMessage("Please type a new description text.");
            this.UserWantsPointer();
        }
    }

    public void UserWantsGeneratorDrawing() {
        if (this.HelpWanted) {
            new HelpDialog(frame, "Generator");
            this.UserWantsPointer();
            return;
        }
        if (MySchematicPanel != null) {
            DeepEdit.addComponent(new Generator(PinGrid, DeepEdit.MySchematicPanel.GridXOffset, DeepEdit.MySchematicPanel.GridYOffset, MySchematic.getactperiod(), MySchematic.getendperiod(), MySchematic.getactmonth(), MySchematic.getendmonth()));
            DeepEdit.setStatusMessage("Please select a position for the new Generator.");
            this.UserWantsPointer();
        }
    }

    public void UserWantsLineDCDrawing() {
        if (this.HelpWanted) {
            HelpDialog MyHelpDialog = new HelpDialog(frame, "LineDC");
            this.UserWantsPointer();
            return;
        }
        if (MySchematicPanel != null) {
            DeepEdit.addComponent(new LineDC(PinGrid, DeepEdit.MySchematicPanel.GridXOffset, DeepEdit.MySchematicPanel.GridYOffset, MySchematic.getactperiod(), MySchematic.getendperiod(), MySchematic.getactmonth(), MySchematic.getendmonth()));
            DeepEdit.setStatusMessage("Please select a position for the new Transformator.");
            this.UserWantsPointer();
        }
    }

    public void UserWantsTrafoDrawing() {
        if (this.HelpWanted) {
            HelpDialog MyHelpDialog = new HelpDialog(frame, "Trafo");
            this.UserWantsPointer();
            return;
        }
        if (MySchematicPanel != null) {
            DeepEdit.addComponent(new Trafo(PinGrid, DeepEdit.MySchematicPanel.GridXOffset, DeepEdit.MySchematicPanel.GridYOffset, MySchematic.getactperiod(), MySchematic.getendperiod(), MySchematic.getactmonth(), MySchematic.getendmonth()));
            DeepEdit.setStatusMessage("Please select a position for the new Transformator.");
            this.UserWantsPointer();
        }
    }

    public void UserWantsThreeWindingTrafoDrawing() {
        if (this.HelpWanted) {
            HelpDialog MyHelpDialog = new HelpDialog(frame, "Trafo");
            this.UserWantsPointer();
            return;
        }
        if (MySchematicPanel != null) {
            DeepEdit.addComponent(new ThreeWindingTrafo(PinGrid, DeepEdit.MySchematicPanel.GridXOffset, DeepEdit.MySchematicPanel.GridYOffset, MySchematic.getactperiod(), MySchematic.getendperiod(), MySchematic.getactmonth(), MySchematic.getendmonth()));
            DeepEdit.setStatusMessage("Please select a position for the new Transformator.");
            this.UserWantsPointer();
        }
    }

    public void UserWantsUpfcDrawing() {
        if (this.HelpWanted) {
            HelpDialog MyHelpDialog = new HelpDialog(frame, "Upfc");
            this.UserWantsPointer();
            return;
        }
        if (MySchematicPanel != null) {
            DeepEdit.addComponent(new Upfc(PinGrid, DeepEdit.MySchematicPanel.GridXOffset, DeepEdit.MySchematicPanel.GridYOffset, MySchematic.getactperiod(), MySchematic.getendperiod(), MySchematic.getactmonth(), MySchematic.getendmonth()));
            DeepEdit.setStatusMessage("Please select a position for the new Unified Power Flow Controller.");
            this.UserWantsPointer();
        }
    }

    public void UserWantsLoadDrawing() {
        if (this.HelpWanted) {
            HelpDialog MyHelpDialog = new HelpDialog(frame, "Load");
            this.UserWantsPointer();
            return;
        }
        if (MySchematicPanel != null) {
            DeepEdit.addComponent(new Load(PinGrid, DeepEdit.MySchematicPanel.GridXOffset, DeepEdit.MySchematicPanel.GridYOffset, MySchematic.getactperiod(), MySchematic.getendperiod(), MySchematic.getactmonth(), MySchematic.getendmonth()));
            DeepEdit.setStatusMessage("Please select a position for the new Load.");
            this.UserWantsPointer();
        }
    }

    public void UserWantsmdb_supDrawing() {
        if (this.HelpWanted) {
            HelpDialog MyHelpDialog = new HelpDialog(frame, "Supplier");
            this.UserWantsPointer();
            return;
        }
        if (MySchematicPanel != null) {
            DeepEdit.addComponent(new mdb_sup(PinGrid, DeepEdit.MySchematicPanel.GridXOffset, DeepEdit.MySchematicPanel.GridYOffset, MySchematic.getactperiod(), MySchematic.getendperiod(), MySchematic.getactmonth(), MySchematic.getendmonth()));
            DeepEdit.setStatusMessage("Please select a position for the new Supplier.");
            this.UserWantsPointer();
        }
    }

    public void UserWantsmdb_isoDrawing() {
        if (this.HelpWanted) {
            HelpDialog MyHelpDialog = new HelpDialog(frame, "ISO");
            this.UserWantsPointer();
            return;
        }
        if (MySchematicPanel != null) {
            DeepEdit.addComponent(new mdb_iso(PinGrid, DeepEdit.MySchematicPanel.GridXOffset, DeepEdit.MySchematicPanel.GridYOffset, MySchematic.getactperiod(), MySchematic.getendperiod(), MySchematic.getactmonth(), MySchematic.getendmonth()));
            DeepEdit.setStatusMessage("Please select a position for the new ISO.");
            this.UserWantsPointer();
        }
    }

    public void UserWantsmdb_custDrawing() {
        if (this.HelpWanted) {
            HelpDialog MyHelpDialog = new HelpDialog(frame, "Customer");
            this.UserWantsPointer();
            return;
        }
        if (MySchematicPanel != null) {
            DeepEdit.addComponent(new mdb_cust(PinGrid, DeepEdit.MySchematicPanel.GridXOffset, DeepEdit.MySchematicPanel.GridYOffset, MySchematic.getactperiod(), MySchematic.getendperiod(), MySchematic.getactmonth(), MySchematic.getendmonth()));
            DeepEdit.setStatusMessage("Please select a position for the new Customer.");
            this.UserWantsPointer();
        }
    }

    public void UserWantsBusbarFourDrawing() {
        if (this.HelpWanted) {
            HelpDialog MyHelpDialog = new HelpDialog(frame, "Busbar");
            this.UserWantsPointer();
            return;
        }
        if (MySchematicPanel != null) {
            DeepEdit.addComponent(new Busbar(PinGrid, 4, DeepEdit.MySchematicPanel.GridXOffset, DeepEdit.MySchematicPanel.GridYOffset, MySchematic.getactperiod(), MySchematic.getendperiod(), MySchematic.getactmonth(), MySchematic.getendmonth()));
            DeepEdit.setStatusMessage("Please select a position for the new Busbar.");
            this.UserWantsPointer();
        }
    }

    public void UserWantsContraintBuilder() {
        if (this.HelpWanted) {
            HelpDialog MyHelpDialog = new HelpDialog(frame, "Constraint");
            this.UserWantsPointer();
            return;
        }
        ConstraintBuilderFrame cWindow = new ConstraintBuilderFrame((Window)frame);
        cWindow.setLocationRelativeTo(frame);
        cWindow.setVisible(true);
        this.UserWantsPointer();
    }

    public void UserWantsHelp() {
        if (this.MyControlPanel != null) {
            this.MyControlPanel.SelectButtonByName("Help");
        }
        if (this.HelpWanted) {
            HelpDialog helpDialog = new HelpDialog(frame, "Help");
        } else {
            DeepEdit.setStatusMessage("Choose a component, menu or button to get help about it.");
            this.HelpWanted = true;
        }
    }

    public static void UserWantsReleaseNotes() {
        HelpDialog MyHelpDialog = new HelpDialog(frame, "ReleaseNotes");
    }

    public static void UserWantsValidateParameters() {
        DeepEdit.addMessageTab("Validation");
        DeepEdit.printlnToMessageTab("Validation Summary:");
        for (comp c : MySchematic.getComponents()) {
            for (ParameterData pData : c.getAllParametersInfo()) {
                String sRules = DeepEdit.getValidationRule(c.getClassName(), pData.Name);
                if (ValidationRule.isValid(pData.getValue(), sRules)) continue;
                DeepEdit.printlnToMessageTab(c.getClassName() + "." + pData.Name + "(" + c.getName() + ") : " + pData.getValue() + "| Rule : " + sRules);
            }
        }
        DeepEdit.printlnToMessageTab("Note: Values displayed didn't passed default parameter's validation rules");
    }

    public void UserWantsJavaDCLF() {
        if (this.HelpWanted) {
            HelpDialog helpDialog = new HelpDialog(frame, "DC Load Flow");
        } else {
            MySchematic.settypsim(DE_GeneralEnums.SimulationType.DCLF.getValue());
            MySchematic.settiposimula(0);
            DeepEdit.SimulateSetUp();
            if (DeepEdit.frame.MyDCLF != null) {
                DeepEdit.frame.MyDCLF = null;
            }
            DeepEdit.frame.MyDCLF = new DCLF(this, MySchematic);
        }
    }

    public void UserWantsJavaLF() {
        if (this.HelpWanted) {
            HelpDialog MyHelpDialog = new HelpDialog(frame, "Java Load Flow");
            this.UserWantsPointer();
            return;
        }
        MySchematic.settypsim(DE_GeneralEnums.SimulationType.JLF.getValue());
        MySchematic.settiposimula(0);
        DeepEdit.SimulateSetUp();
        if (DeepEdit.frame.MyJavaLF != null) {
            DeepEdit.frame.MyJavaLF = null;
        }
        DeepEdit cfr_ignored_0 = DeepEdit.frame.applet;
        DeepEdit.frame.MyJavaLF = new JavaLF(DeepEdit.frame.applet, MySchematic);
        this.UserWantsPointer();
    }

    public void UserWantsJavaOPF() {
        if (this.HelpWanted) {
            HelpDialog MyHelpDialog = new HelpDialog(frame, "OPF");
            this.UserWantsPointer();
            return;
        }
        MySchematic.settypsim(DE_GeneralEnums.SimulationType.OPF.getValue());
        MySchematic.settiposimula(0);
        if (DeepEdit.frame.MyOPF != null) {
            DeepEdit.frame.MyOPF = null;
        }
        DeepEdit.frame.MyOPF = new OPF(MySchematic, this);
        this.UserWantsPointer();
    }

    public void UserWantsJavaShC() {
        if (this.HelpWanted) {
            HelpDialog helpDialog = new HelpDialog(frame, "JavaShC");
        } else {
            MySchematic.settypsim(DE_GeneralEnums.SimulationType.JavaShC.getValue());
            MySchematic.settiposimula(0);
            if (DeepEdit.frame.MyJavaShC != null) {
                DeepEdit.frame.MyJavaShC = null;
            }
            DeepEdit.frame.MyJavaShC = new JavaShCFrame(this, MySchematic);
        }
    }

    public void UserWantsSimulate() {
        if (this.HelpWanted) {
            HelpDialog MyHelpDialog = new HelpDialog(frame, "Simulate");
            this.UserWantsPointer();
            return;
        }
        if (!this.isSimulating()) {
            this.MyControlPanel.disableAllButtons();
            this.MyControlPanel.enableButtonByName("Simulate");
            this.MyControlPanel.SelectButtonByName("Simulate");
            frame.DisableAllMenus();
            DeepEdit.frame.StartMenuItem.setEnabled(false);
            DeepEdit.frame.StopMenuItem.setEnabled(true);
            this.SimulateStart();
        } else {
            this.MyControlPanel.enableAllButtons();
            this.MyControlPanel.deselectButtonByName("Simulate");
            frame.EnableAllMenus();
            DeepEdit.frame.StartMenuItem.setEnabled(true);
            this.SimulateStop();
            this.UserWantsPointer();
        }
    }

    public void UserWantsNewSchematic() {
        if (MySchematic == null) {
            return;
        }
        if (this.HelpWanted) {
            HelpDialog MyHelpDialog = new HelpDialog(frame, "New");
        } else {
            int nYesNoAnswer = 0;
            if (DeepEdit.MySchematic.Modified) {
                nYesNoAnswer = JOptionPane.showConfirmDialog(frame, "Discard changes to active Schematic?", "Open Schematic", 0);
            }
            if (nYesNoAnswer == 0) {
                MySchematic.DestroyComponents(PinGrid);
                frame.setTitle(NEditor, MySchematic);
                DeepEdit.MySchematic.FileName = null;
                DeepEdit.MySchematic.Modified = false;
                DeepEdit.updateGUITreeView();
                DeepEdit.updateTime();
                MySchematicPanel.repaint();
                this.UserWantsPointer();
            }
        }
        this.UserWantsPointer();
    }

    public void UserWantsOpenSchematic() {
        if (MySchematic == null) {
            assert (false) : "Why there is not an instance of MySchematic???";
            return;
        }
        if (this.HelpWanted) {
            HelpDialog MyHelpDialog = new HelpDialog(frame, "Open");
        } else {
            String sFileName;
            int nYesNoAnswer = 0;
            if (DeepEdit.MySchematic.Modified) {
                nYesNoAnswer = JOptionPane.showConfirmDialog(frame, "Discard changes to active Schematic?", "Open Schematic", 0);
            }
            if (nYesNoAnswer == 0 && (sFileName = frame.DoFileOpenDialog("Open schematic", 0)) != null) {
                DeepEdit.loadSchematicFromFile(sFileName);
            }
        }
        this.UserWantsPointer();
    }

    public void UserWantsOpenDatabase() throws Exception {
        if (this.HelpWanted) {
            HelpDialog MyHelpDialog = new HelpDialog(frame, "OpenDatabase");
        } else {
            int nYesNoAnswer = 0;
            if (DeepEdit.MySchematic.Modified) {
                nYesNoAnswer = JOptionPane.showConfirmDialog(frame, "Discard changes to active Schematic?", "Open Schematic", 0);
            }
            if (nYesNoAnswer == 0) {
                Schematic OpenSchematic = this.OpenDatabase(PinGrid);
                if (OpenSchematic != null) {
                    MySchematic = OpenSchematic;
                    DeepEdit.MySchematic.FileName = "Database";
                    this.setEditor(DeepEdit.getEditor());
                    DeepEdit.updateGUITreeView();
                    DeepEdit.refreshOwnerships();
                    DeepEdit.SimulateSetUp();
                    MySchematicPanel.repaint();
                    DeepEdit.updateTime();
                }
                if (DeepEditFrame.MySEEDS_Frame != null) {
                    DeepEditFrame.MySEEDS_Frame.loadNewSch();
                }
            }
        }
        this.UserWantsPointer();
    }

    public void UserWantsPLPStudies() throws Exception {
        System.out.println("Calling PLP Studies");
        if (this.HelpWanted) {
            HelpDialog MyHelpDialog = new HelpDialog(frame, "PLPStudiesManager");
            this.UserWantsPointer();
            return;
        }
        if (DeepEdit.frame.MyPLPFrame != null) {
            DeepEdit.setStatusMessage("Please finish PLP Frame before ...");
            String[] DlgButtons = new String[]{"OK"};
            this.message = "Please finish PLP Frame before ... ";
            new SimpleDialog(frame, "Caution:", this.message, DlgButtons, 1, 0, 0, 2);
            return;
        }
        if (this.MyPLPStudiesFrame != null) {
            this.MyPLPStudiesFrame.dispose();
            this.MyPLPStudiesFrame = null;
        }
        this.MyPLPStudiesFrame = new PLPStudiesFrame(this);
        this.MyPLPStudiesFrame.setVisible(true);
    }

    public void UserWantsSEEDSStudies() throws Exception {
        System.out.println("Calling SEEDS Studies");
        if (this.HelpWanted) {
            HelpDialog MyHelpDialog = new HelpDialog(frame, "SEEDS_StudiesManager");
            this.UserWantsPointer();
            return;
        }
        if (DeepEditFrame.MySEEDS_Frame != null) {
            DeepEdit.setStatusMessage("Please finish SEEDS Frame before ...");
            DeepEditFrame.MySEEDS_Frame.requestFocus();
            String[] DlgButtons = new String[]{"OK"};
            this.message = "Please finish SEEDS Frame before ... ";
            new SimpleDialog(frame, "Caution:", this.message, DlgButtons, 1, 0, 0, 2);
            return;
        }
        if (this.MySEEDS_StudiesFrame != null) {
            this.MySEEDS_StudiesFrame.dispose();
            this.MySEEDS_StudiesFrame = null;
        }
        this.MySEEDS_StudiesFrame = new SEEDS_StudiesFrame(this);
        this.MySEEDS_StudiesFrame.setVisible(true);
    }

    public void UserWantsPIETStudies() throws Exception {
        System.out.println("Calling PIET Studies");
        if (this.HelpWanted) {
            HelpDialog MyHelpDialog = new HelpDialog(frame, "PIETStudiesManager");
            this.UserWantsPointer();
            return;
        }
        if (DeepEditFrame.MyPietEditFrame != null) {
            DeepEdit.setStatusMessage("Please finish PIET Frame before ...");
            String[] DlgButtons = new String[]{"OK"};
            this.message = "Please finish PIET Frame before ... ";
            SimpleDialog ExceptionDialog = new SimpleDialog(frame, "Caution:", this.message, DlgButtons, 1, 0, 0, 2);
            return;
        }
        if (this.MyPIETStudiesFrame != null) {
            this.MyPIETStudiesFrame.dispose();
            this.MyPIETStudiesFrame = null;
        }
        this.MyPIETStudiesFrame = new PIETStudiesFrame(this);
        this.MyPIETStudiesFrame.setVisible(true);
    }

    public void UserWantsPETStudies(String action) {
        assert (action != null) : "How a null got here? Did you modify frame? There has to be an action for PET manager to handle it!!!";
    }

    public void UserWantsSavePLPStudy() throws Exception {
        if (this.HelpWanted) {
            HelpDialog MyHelpDialog = new HelpDialog(frame, "SavePLPStudy");
            this.UserWantsPointer();
            return;
        }
        if (DeepEdit.frame.MyPLPFrame == null) {
            DeepEdit.setStatusMessage("Start PLP-Tool before ...");
            String[] DlgButtons = new String[]{"OK"};
            this.message = "Start PLP-Tool before ...";
            SimpleDialog ExceptionDialog = new SimpleDialog(frame, "Caution:", this.message, DlgButtons, 1, 0, 0, 2);
        } else {
            FileWriter f1 = new FileWriter("PLPFiles/Estudios/plp.bat");
            BufferedWriter f2 = new BufferedWriter(f1);
            System.out.println("Saving PLP Study: " + DeepEdit.frame.MyPLPFrame.Location);
            try {
                if (DeepEditFrame.conPLPDB != null) {
                    DeepEditFrame.conPLPDB.commit();
                    DeepEditFrame.conPLPDB.close();
                    DeepEditFrame.conPLPDB = null;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            f2.write("cd PLPFiles\\Estudios");
            f2.newLine();
            f2.write("move ..\\..\\database\\PLPDB.mdb .\\" + DeepEdit.frame.MyPLPFrame.Location + "\\PLPDB.mdb");
            f2.newLine();
            f2.write("move ..\\Resultados\\*.csv .\\" + DeepEdit.frame.MyPLPFrame.Location);
            f2.newLine();
            f2.write("move ..\\Resultados\\*.bin .\\" + DeepEdit.frame.MyPLPFrame.Location);
            f2.newLine();
            f2.write("del ..\\Resultados\\*.csv ");
            f2.newLine();
            f2.write("del ..\\..\\database\\PLPDB.mdb");
            f2.newLine();
            f2.write("del ..\\Resultados\\*.bin ");
            f2.newLine();
            f2.close();
            ((Writer)f1).close();
            f2 = null;
            f1 = null;
            AnalysisTool.Dorun(PathDOS + "PLPFiles\\Estudios\\plp.bat", PathUNIX + "PLPFiles/Estudios/plp.bat");
        }
    }

    public void UserWantsSaveSEEDSStudy() throws Exception {
        if (this.HelpWanted) {
            HelpDialog MyHelpDialog = new HelpDialog(frame, "SaveSEEDSStudy");
            this.UserWantsPointer();
            return;
        }
        if (DeepEditFrame.MySEEDS_Frame != null) {
            try {
                String studyDir = DeepEditFrame.MySEEDS_Frame.Location;
                System.out.println("Saving SEEDS Study: " + studyDir);
                DeepEditFrame.conSEEDSDB.commit();
                this.UserWantsSaveSchematic(true);
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(frame, "Error saving sudy " + e.toString(), "Seeds Manager", 0);
            }
        }
    }

    public void UserWantsSavePIETStudy() throws PIETException {
        try {
            if (this.HelpWanted) {
                HelpDialog MyHelpDialog = new HelpDialog(frame, "SavePIETStudy");
                this.UserWantsPointer();
                return;
            }
            if (PietEditFrame.MyPIETdata == null) {
                DeepEdit.setStatusMessage("Start PIET-Tool before ...");
                String[] DlgButtons = new String[]{"OK"};
                this.message = "Start PIET-Tool before ...";
                new SimpleDialog(frame, "Caution:", this.message, DlgButtons, 1, 0, 0, 2);
            } else {
                FileWriter f1 = new FileWriter("PIETFiles/Estudios/piet.bat");
                BufferedWriter f2 = new BufferedWriter(f1);
                System.out.println("Saving PIET Study: " + PietEditFrame.MyPIETdata.Location);
                this.UserWantsSaveSchematic(true);
                DeepEditFrame.MyPietEditFrame.UserWantsSaveSchematic();
                f2.write("cd PIETFiles\\Estudios");
                f2.newLine();
                f2.write("copy ..\\..\\database\\PIETDB.mdb .\\" + PietEditFrame.MyPIETdata.Location + "\\PIETDBresp.mdb");
                f2.newLine();
                f2.close();
                ((Writer)f1).close();
                f2 = null;
                f1 = null;
                AnalysisTool.Dorun(PathDOS + "PIETFiles\\Estudios\\piet.bat", PathUNIX + "PIETFiles/Estudios/piet.bat");
            }
        }
        catch (IOException e) {
            e.printStackTrace(System.out);
            throw new PIETException("unable to find file when saving batch process");
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            throw new PIETException("unable to execute batch script in file 'piet.bat'");
        }
    }

    public void UserWantsClosePIETStudy() throws PIETException {
        try {
            if (PietEditFrame.MyPIETdata == null) {
                DeepEdit.setStatusMessage("Start PIET-Tool before ...");
                String[] DlgButtons = new String[]{"OK"};
                this.message = "Start PIET-Tool before ...";
                new SimpleDialog(frame, "Caution:", this.message, DlgButtons, 1, 0, 0, 2);
            } else {
                FileWriter f1 = new FileWriter("PIETFiles/Estudios/piet.bat");
                BufferedWriter f2 = new BufferedWriter(f1);
                System.out.println("Closing PIET Study: " + PietEditFrame.MyPIETdata.Location);
                if (DeepEditFrame.conPIETDB != null) {
                    DeepEditFrame.conPIETDB.commit();
                    DeepEditFrame.conPIETDB.close();
                    DeepEditFrame.conPIETDB = null;
                }
                f2.write("cd PIETFiles\\Estudios");
                f2.newLine();
                f2.write("del ..\\..\\database\\PIETDB.mdb");
                f2.newLine();
                f2.write("copy .\\" + PietEditFrame.MyPIETdata.Location + "\\PIETDBresp.mdb .\\" + PietEditFrame.MyPIETdata.Location + "\\PIETDB.mdb");
                f2.newLine();
                f2.write("move ..\\Resultados\\*.csv .\\" + PietEditFrame.MyPIETdata.Location);
                f2.newLine();
                f2.write("move ..\\Resultados\\*.bin .\\" + PietEditFrame.MyPIETdata.Location);
                f2.newLine();
                f2.write("del ..\\Resultados\\*.csv ");
                f2.newLine();
                f2.write("del ..\\..\\database\\PIETDB.mdb");
                f2.newLine();
                f2.write("del ..\\Resultados\\*.bin ");
                f2.newLine();
                f2.close();
                ((Writer)f1).close();
                f2 = null;
                f1 = null;
                AnalysisTool.Dorun(PathDOS + "PIETFiles\\Estudios\\piet.bat", PathUNIX + "PIETFiles/Estudios/piet.bat");
                PietEditFrame.MyPIETdata = null;
                DeepEditFrame.MyPietEditFrame.dispose();
                DeepEditFrame.MyPietEditFrame = null;
                this.UserWantsNewSchematic();
                frame.togglePIETMenu();
            }
        }
        catch (IOException e) {
            e.printStackTrace(System.out);
            throw new PIETException("unable to execute closing batch process");
        }
        catch (SQLException e) {
            e.printStackTrace(System.out);
            throw new PIETException("unable to close PIET data Base Connection");
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            throw new PIETException("unable to execute batch script in file 'piet.bat'");
        }
    }

    public void UserWantsOverviewOptions() {
        if (this.HelpWanted) {
            HelpDialog MyHelpDialog = new HelpDialog(frame, "Overview");
            this.UserWantsPointer();
            return;
        }
        if (this.MyOverviewFrame != null) {
            this.MyOverviewFrame.dispose();
            this.MyOverviewFrame = null;
        }
        this.MyOverviewFrame = new OverviewFrame(this);
        this.MyOverviewFrame.setVisible(true);
    }

    public void UserWantsBalanceOptions() {
        if (this.HelpWanted) {
            HelpDialog MyHelpDialog = new HelpDialog(frame, "Balance Load Flow");
            this.UserWantsPointer();
            return;
        }
        if (this.MyBalanceFrame != null) {
            this.MyBalanceFrame.dispose();
            this.MyBalanceFrame = null;
        }
        this.MyBalanceFrame = new BalanceFrame(this);
        this.MyBalanceFrame.setVisible(true);
    }

    public void UserWantsHtmlHelp() throws Exception {
        if (this.MyHtmlHelpFrame != null) {
            this.MyHtmlHelpFrame.dispose();
            this.MyHtmlHelpFrame = null;
        } else {
            this.MyHtmlHelpFrame = new HtmlHelp(this);
            this.MyHtmlHelpFrame.pack();
            this.MyHtmlHelpFrame.setVisible(true);
        }
    }

    public void UserWantsSaveDatabase() throws Exception {
        if (MySchematic == null) {
            return;
        }
        if (this.HelpWanted) {
            HelpDialog MyHelpDialog = new HelpDialog(frame, "SaveDatabase");
            this.UserWantsPointer();
        } else {
            int nYesNo = JOptionPane.showConfirmDialog(frame, "Are you sure you want to save current schematic into DeepEdit database?", "Save Database", 0);
            if (nYesNo == 0) {
                try {
                    frame.SaveDatabase();
                }
                catch (SQLException e) {
                    System.out.println("Error: " + e.getMessage() + " " + e.getSQLState());
                }
            }
            this.UserWantsPointer();
        }
    }

    public void UserWantsViewDatabase() {
        if (this.MyViewDBFrame == null) {
            try {
                this.MyViewDBFrame = new ViewDBFrame(this);
            }
            catch (Exception e) {
                System.out.println("Error opening database using DBTable viewer. Details: " + e);
                e.printStackTrace(System.out);
            }
        }
    }

    public void UserWantsVisualImport() {
        if (myVisualImportFrame == null) {
            myVisualImportFrame = new VisualImportFrame(frame);
        }
        myVisualImportFrame.setLocationRelativeTo(frame);
        myVisualImportFrame.setVisible(true);
    }

    public void UserWantsTransmissionAnalysis() {
        if (this.myTAMainFrame == null) {
            this.myTAMainFrame = new TAMainFrame(frame, true);
        }
        this.myTAMainFrame.setLocationRelativeTo(frame);
        this.myTAMainFrame.setVisible(true);
    }

    public void UserWantsOpenExample(String FileName) {
        if (MySchematic == null) {
            return;
        }
        int nYesNoAnswer = 0;
        if (DeepEdit.MySchematic.Modified) {
            nYesNoAnswer = JOptionPane.showConfirmDialog(frame, "Discard changes to active Schematic?", "Open Schematic", 0);
        }
        if (nYesNoAnswer == 0) {
            DeepEdit.loadSchematicFromFile(FileName);
        }
        this.UserWantsPointer();
    }

    public void UserWantsSaveSchematic(boolean saveAs) {
        try {
            Runtime r = Runtime.getRuntime();
            r.gc();
        }
        catch (Exception e) {
            System.out.println("Error in Save" + e);
        }
        if (MySchematic == null) {
            assert (false) : "How could this happen?? You should never delete MySchematic object";
            return;
        }
        if (this.HelpWanted) {
            HelpDialog MyHelpDialog = new HelpDialog(frame, "Save");
            this.UserWantsPointer();
        } else {
            String sFileName = DeepEdit.MySchematic.FileName == null || DeepEdit.MySchematic.FileDir == null || saveAs ? frame.DoFileOpenDialog("Save schematic as", 1) : DeepEdit.MySchematic.FileDir + DeepEdit.MySchematic.FileName;
            if (sFileName != null) {
                try {
                    DeepEdit.saveSchematicToFile(MySchematic, sFileName);
                    System.out.println("Schematic '" + MySchematic.getsysname() + "' succesfully stored to file '" + sFileName + "'");
                }
                catch (FileNotFoundException e) {
                    String msg = "Destination file not found error. Message: " + e.getMessage() + " \nCheck error log for exception details";
                    JOptionPane.showMessageDialog(frame, msg, "File not found", 2);
                    System.out.println(msg);
                    e.printStackTrace(System.err);
                    return;
                }
                catch (IOException e) {
                    String msg = "Error trying to store values to file. Message: " + e.getMessage() + " \nCheck error log for exception details";
                    JOptionPane.showMessageDialog(frame, msg, "Error writing to file", 2);
                    System.out.println(msg);
                    e.printStackTrace(System.err);
                    return;
                }
                catch (InvalidFormatException e) {
                    String msg = "Error trying to store values to Exce file. Message: " + e.getMessage() + " \nCheck error log for exception details";
                    JOptionPane.showMessageDialog(frame, msg, "Error writing to Excel file", 2);
                    System.out.println(msg);
                    e.printStackTrace(System.err);
                    return;
                }
            } else {
                return;
            }
        }
        frame.setTitle(NEditor, MySchematic);
        MySchematicPanel.repaint();
        this.UserWantsPointer();
    }

    public void UserWantsCopySchematic() {
        if (this.HelpWanted) {
            HelpDialog helpDialog = new HelpDialog(frame, "Copy");
        } else {
            MySchematicPanel.Copy();
            DeepEdit.frame.PasteMenuItem.setEnabled(true);
            this.MyControlPanel.enableButtonByName("Paste");
        }
        this.UserWantsPointer();
    }

    public void UserWantsEditComponentSchematic() {
        if (this.HelpWanted) {
            HelpDialog helpDialog = new HelpDialog(frame, "EditComponent");
        } else {
            if (DeepEdit.frame.MyPLPFrame != null) {
                MySchematicPanel.EditComponentPLP();
            } else if (DeepEditFrame.MySEEDS_Frame != null) {
                MySchematicPanel.EditComponentSEEDS();
            } else {
                MySchematicPanel.EditComponent();
            }
            DeepEdit.frame.PasteMenuItem.setEnabled(true);
            this.MyControlPanel.enableButtonByName("Paste");
        }
        this.UserWantsPointer();
    }

    public void UserWantsBringToFrontComponent() {
        if (this.HelpWanted) {
            HelpDialog helpDialog = new HelpDialog(frame, "BringToFront");
        } else {
            MySchematicPanel.BringToFrontComponent();
        }
        this.UserWantsPointer();
    }

    public void UserWantsSendToBackComponent() {
        if (this.HelpWanted) {
            HelpDialog helpDialog = new HelpDialog(frame, "SendToBack");
        } else {
            MySchematicPanel.SendToBackComponent();
        }
        this.UserWantsPointer();
    }

    public void UserWantsPasteSchematic() {
        if (this.HelpWanted) {
            HelpDialog helpDialog = new HelpDialog(frame, "Paste");
        } else {
            MySchematicPanel.Paste();
            DeepEdit.frame.CutMenuItem.setEnabled(true);
            DeepEdit.frame.CopyMenuItem.setEnabled(true);
            if (this.EnableFileOperations) {
                DeepEdit.frame.CopyDiskMenuItem.setEnabled(true);
            }
            this.EnableToolbarButton("Cut");
            this.EnableToolbarButton("Copy");
        }
        this.UserWantsPointer();
    }

    public void UserWantsCutSchematic() {
        if (this.HelpWanted) {
            HelpDialog helpDialog = new HelpDialog(frame, "Cut");
        } else {
            MySchematicPanel.Cut();
            DeepEdit.frame.CutMenuItem.setEnabled(false);
            DeepEdit.frame.CopyMenuItem.setEnabled(true);
            DeepEdit.frame.PasteMenuItem.setEnabled(true);
            this.MyControlPanel.disableButtonByName("Cut");
            this.MyControlPanel.disableButtonByName("Copy");
            this.MyControlPanel.enableButtonByName("Paste");
        }
        this.UserWantsPointer();
    }

    public void UserWantsDeleteSchematic() {
        if (this.HelpWanted) {
            HelpDialog helpDialog = new HelpDialog(frame, "Delete");
        } else if (DeepEdit.MySchematicPanel.SelectSchematic != null) {
            MySchematicPanel.Delete();
            this.UserWantsPointer();
        }
    }

    public void UserWantsDeleteComponent(comp DEcomp) {
        if (DEcomp == null) {
            return;
        }
        if (DEcomp.isDrawnInSchematic()) {
            Schematic sel = DeepEdit.MySchematicPanel.SelectSchematic;
            DeepEdit.MySchematicPanel.PrevSelectedComponent = DEcomp;
        }
        DeepEdit.removeComponent(DEcomp);
        this.UserWantsPointer();
    }

    public void UserWantsOpenExample() {
        if (this.HelpWanted) {
            HelpDialog helpDialog = new HelpDialog(frame, "Open example");
        } else if (this.MyExamplesFrame == null) {
            this.MyExamplesFrame = new ExamplesFrame(this);
        } else {
            this.MyExamplesFrame.setLocationRelativeTo(frame);
            this.MyExamplesFrame.setVisible(true);
        }
    }

    public void UserWantsGISOptions() {
        if (this.HelpWanted) {
            HelpDialog MyHelpDialog = new HelpDialog(frame, "GIS_Options");
        } else {
            JFileChooser myJFileOpenDialog = new JFileChooser();
            myJFileOpenDialog.setDialogTitle("Selected Related GIS-Map Data File");
            FileNameExtensionFilter filterTxt = new FileNameExtensionFilter("Plain Text File (.txt)", "txt");
            myJFileOpenDialog.addChoosableFileFilter(filterTxt);
            FileNameExtensionFilter filterDat = new FileNameExtensionFilter("Map Data File (.dat)", "dat");
            myJFileOpenDialog.addChoosableFileFilter(filterDat);
            myJFileOpenDialog.setFileFilter(filterDat);
            if (this.MapName != null) {
                myJFileOpenDialog.setCurrentDirectory(new File(this.MapName));
            } else {
                File f = new File("./maps");
                myJFileOpenDialog.setCurrentDirectory(f);
            }
            int returnVal = myJFileOpenDialog.showOpenDialog(frame);
            if (returnVal != 0) {
                return;
            }
            this.MapName = myJFileOpenDialog.getSelectedFile().getAbsolutePath();
            if (this.MyGeoMapFrame == null) {
                this.MyGeoMapFrame = new GeoMapFrame(this);
            } else {
                this.MyGeoMapFrame.setVisible(true);
            }
        }
    }

    public void UserWantsGIS(boolean sino) {
        if (this.HelpWanted) {
            HelpDialog MyHelpDialog = new HelpDialog(frame, "GIS");
        } else if (sino) {
            if (this.MyGIS != null) {
                this.MyGIS.dispose();
                this.MyGIS = null;
            }
            if (this.MyGISFrame != null) {
                this.MyGISFrame.dispose();
                this.MyGISFrame = null;
            }
            if (this.MyGeoMapFrame != null) {
                this.MyGeoMapFrame.dispose();
                this.MyGeoMapFrame = null;
            }
            DeepEdit.frame.GISMenuItem.setLabel("Stop GIS");
            DeepEdit.frame.GISMenuItem.setActionCommand("Stop GIS");
            this.GISDL &= this.GISDL - 1;
            this.MyGIS = new GeoMap(this, this.GISscreenw, this.GISscreenh, this.GISprojection, this.MapName);
            this.MyGISFrame = new GISFrame(this);
        } else {
            if (this.MyGIS != null) {
                this.MyGIS.setVisible(false);
                if (this.MyGIS.canvasMap.os != null) {
                    try {
                        this.MyGIS.canvasMap.os.close();
                    }
                    catch (Exception e) {
                        System.out.println("Unexpected error closing temp file maps.tmp: " + e);
                    }
                }
                this.MyGIS.dispose();
                this.MyGIS = null;
            }
            if (this.MyGISFrame != null) {
                this.MyGISFrame.dispose();
                this.MyGISFrame = null;
            }
            DeepEdit.frame.GISMenuItem.setLabel("View GIS");
            DeepEdit.frame.GISMenuItem.setActionCommand("View GIS");
        }
    }

    public void UserWantsCopyToSchematic() {
        if (this.HelpWanted) {
            HelpDialog helpDialog = new HelpDialog(frame, "CopyTo");
        } else {
            MySchematicPanel.CopyTo();
            DeepEdit.frame.PasteMenuItem.setEnabled(true);
            this.MyControlPanel.enableButtonByName("Paste");
        }
        this.UserWantsPointer();
    }

    public void UserWantsPasteFromSchematic() {
        if (this.HelpWanted) {
            HelpDialog helpDialog = new HelpDialog(frame, "PasteFrom");
        } else {
            MySchematicPanel.PasteFrom();
        }
        this.UserWantsPointer();
    }

    public void UserWantsOptions() {
        if (this.HelpWanted) {
            HelpDialog helpDialog = new HelpDialog(frame, "Options");
        } else if (DeepEdit.getBooleanOptionValue("UseOldComponentGUI")) {
            this.MyOptionsFrame = new OptionsFrame(this);
        } else {
            DeepEdit.showSchematicParameterGUI();
        }
        this.UserWantsPointer();
    }

    public static void showSchematicParameterGUI() {
        MySchematic.showParameterGUI();
    }

    public void UserWantsPrintOptions() {
        if (this.HelpWanted) {
            HelpDialog helpDialog = new HelpDialog(frame, "Print_Options");
        } else if (this.MyPrintOptionsFrame == null) {
            this.MyPrintOptionsFrame = new PrintOptionsFrame(this);
        }
        this.UserWantsPointer();
    }

    public void UserWantsLoadScaling() {
        if (this.MyLoadScalingFrame == null) {
            this.MyLoadScalingFrame = new LoadScalingFrame(this);
        }
        this.UserWantsPointer();
    }

    public void UserWantsLoadTGD() {
        if (this.MyLoadTGDFrame == null) {
            try {
                DeepEditFrame.conTGD = DeepEdit.OpenODBC_JDBCConnection("TGD", true);
            }
            catch (Exception e) {
                e.printStackTrace(System.out);
            }
            if (DeepEditFrame.conTGD != null) {
                this.MyLoadTGDFrame = new LoadTGDFrame(this);
            }
        }
    }

    public void UserWantsDailySimulation(int Monat, int Tag, String CTRLA) {
        if (this.MyDailySimulation != null) {
            this.MyDailySimulation = null;
        }
        try {
            DeepEditFrame.conTGD = DeepEdit.OpenODBC_JDBCConnection("TGD", true);
            DeepEditFrame.conTLC = DeepEdit.OpenODBC_JDBCConnection("TLC", true);
            this.MyDailySimulation = new DailySimulation(MySchematic, frame, Monat, Tag, CTRLA);
        }
        catch (Exception e) {
            System.out.println("Error opening database or Daily Simulation Tools: " + e);
        }
    }

    public void UserWantsCBT(int probe) {
        if (this.MyCBT != null) {
            this.MyCBT = null;
        }
        System.out.println("In CBT !!!!!");
        this.MyCBT = new CBT(MySchematic, frame);
        System.out.println("Out from CBT !!!!");
    }

    public void UserWantsDailySimulation() {
        if (this.MyDailySimulationFrame != null) {
            this.MyDailySimulationFrame = null;
        }
        this.MyDailySimulationFrame = new DailySimulationFrame(this);
    }

    public void UserWantsYearlySimulation(String CTRLA, String LFType) {
        if (this.MyYearlySimulation != null) {
            this.MyYearlySimulation = null;
        }
        try {
            DeepEditFrame.conTGD = DeepEdit.OpenODBC_JDBCConnection("TGD", true);
            DeepEditFrame.conTLC = DeepEdit.OpenODBC_JDBCConnection("TLC", true);
            this.MyYearlySimulation = new YearlySimulation(MySchematic, frame, CTRLA, LFType);
        }
        catch (Exception e) {
            System.out.println("Error opening database or Yearly Simulation Tools: " + e);
        }
    }

    public void UserWantsYearlySimulation() {
        if (this.MyYearlySimulationFrame != null) {
            this.MyYearlySimulationFrame = null;
        }
        this.MyYearlySimulationFrame = new YearlySimulationFrame(this);
    }

    public void UserWantsYearlyDCLFStatistics() {
        if (this.MyYearlyDCLFStatistics != null) {
            this.MyYearlyDCLFStatistics = null;
        }
        if (DeepEdit.MySchematic.Components.size() < 3) {
            String strMessage = "Schematic has less than 3 components. Load valid Schematic and try again.";
            JOptionPane.showMessageDialog(frame, strMessage, "Invalid Schematic", 2);
            System.out.println(strMessage);
        } else {
            this.MyYearlyDCLFStatistics = new YearlyDCLFStatistics(MySchematic, this, DeepEdit.OpenODBC_JDBCConnection("TPDB", true));
        }
    }

    public void UserWantsMMS2() {
        if (this.MyMMS2 != null) {
            if (this.MyMMS2.MyMMS2Frame != null) {
                this.MyMMS2.MyMMS2Frame.dispose();
                this.MyMMS2.MyMMS2Frame = null;
            }
            this.MyMMS2 = null;
        }
        this.MyMMS2 = new MMS2(MySchematic, this);
    }

    public void UserWantsMarketShare() {
        if (this.MyMMMarketShare != null) {
            this.MyMMMarketShare = null;
        }
        this.MyMMMarketShare = new MMMarketShare(MySchematic, this);
    }

    public void UserWantsCredibility() {
        if (this.MyMMCredibility != null) {
            this.MyMMCredibility = null;
        }
        this.MyMMCredibility = new MMCredibility(MySchematic, this);
    }

    public void UserWantsReservoirLevel() {
        if (this.MyMMReservoirLevel != null) {
            this.MyMMReservoirLevel = null;
        }
        this.MyMMReservoirLevel = new MMReservoirLevel(MySchematic, this);
    }

    public void UserWantsSpotPrice() {
        if (this.MyMMSpotPrice != null) {
            this.MyMMSpotPrice = null;
        }
        this.MyMMSpotPrice = new MMSpotPrice(MySchematic, this);
    }

    public void UserWantsMarketController() {
        if (this.MyMMMarketController != null) {
            this.MyMMMarketController = null;
        }
        this.MyMMMarketController = new MMMarketController(MySchematic, this);
    }

    public void UserWantsLoadDispatch() {
        if (this.MyLoadDispatchFrame == null) {
            this.MyLoadDispatchFrame = new LoadDispatchFrame(this, DeepEdit.OpenODBC_JDBCConnection("TPDB", true));
        }
    }

    public void UserWantsSFT(int Monat, int Tag, String TN, String Load2, String Generator2) {
        if (this.MySFT != null) {
            this.MySFT = null;
        }
        try {
            DeepEditFrame.conTGD = DeepEdit.OpenODBC_JDBCConnection("TGD", true);
            DeepEditFrame.conTLC = DeepEdit.OpenODBC_JDBCConnection("TLC", true);
            DeepEditFrame.conFP = DeepEdit.OpenODBC_JDBCConnection("Fahrplaene", true);
            this.MySFT = new SFT(MySchematic, frame, Monat, Tag, TN, Load2, Generator2);
        }
        catch (Exception e) {
            System.out.println("Error opening database or SFT: " + e);
        }
    }

    public void UserWantsSFT() {
        if (this.MySFTFrame != null) {
            this.MySFTFrame = null;
        }
        this.MySFTFrame = new SFTFrame(this);
    }

    public void UserWantsSearchName() {
        if (this.HelpWanted) {
            HelpDialog helpDialog = new HelpDialog(frame, "SearchName");
        } else if (this.MySearchNameFrame == null) {
            this.MySearchNameFrame = new SearchNameFrame(this);
        }
        this.UserWantsPointer();
    }

    public void UserWantsSelectAll() {
        if (this.HelpWanted) {
            HelpDialog helpDialog = new HelpDialog(frame, "SelectAll");
        } else {
            MySchematicPanel.SelectAll();
        }
    }

    public void UserWantsControlAreaTool() {
        if (this.HelpWanted) {
            HelpDialog helpDialog = new HelpDialog(frame, "ControlAreaTool");
        } else if (this.MyControlAreaToolFrame == null) {
            this.MyControlAreaToolFrame = new ControlAreaFrame(this);
        } else {
            this.MyControlAreaToolFrame.setVisible(true);
        }
        this.UserWantsPointer();
    }

    public void UserWantsSQPVOptions() {
        if (this.HelpWanted) {
            HelpDialog helpDialog = new HelpDialog(frame, "SQPV_Options");
        } else if (this.MySQPVOptionsFrame == null) {
            this.MySQPVOptionsFrame = new SQPVOptionsFrame(this);
        }
        this.UserWantsPointer();
    }

    public void UserWantsDeepOptions() {
        if (this.HelpWanted) {
            HelpDialog helpDialog = new HelpDialog(frame, "DeepOptions");
        } else {
            this.MyDeepOptionsFrame = new DeepEditOptionsJDialog(this, frame, true);
            this.MyDeepOptionsFrame.setLocationRelativeTo(frame);
            this.MyDeepOptionsFrame.setVisible(true);
        }
        this.UserWantsPointer();
    }

    public void UserWantsZoom() {
        if (this.HelpWanted) {
            HelpDialog helpDialog = new HelpDialog(frame, "Zoom");
        } else if (this.MyZoomFrame == null) {
            this.MyZoomFrame = new ZoomFrame(this);
            this.MyZoomFrame.setResizable(false);
        } else {
            this.MyZoomFrame.setVisible(true);
        }
        this.UserWantsPointer();
    }

    public void UserWantsSpeed() {
        if (this.HelpWanted) {
            HelpDialog helpDialog = new HelpDialog(frame, "Simulation_Speed");
        } else if (this.MySpeedFrame == null) {
            this.MySpeedFrame = new SpeedFrame(this);
        } else {
            this.MySpeedFrame.setVisible(true);
        }
    }

    public void UserWantsrunGa() {
        this.stopGA = false;
        if (this.HelpWanted) {
            HelpDialog MyHelpDialog = new HelpDialog(frame, "runGa");
        } else if (this.MyrunGaFrame == null) {
            try {
                FileOutputStream os = new FileOutputStream("./results/GAReport.dat");
                BufferedOutputStream bos = new BufferedOutputStream(os, 32768);
                this.myPrintStream = new PrintStream(bos, false);
                FileOutputStream os1 = new FileOutputStream("./results/GAReportB.dat");
                BufferedOutputStream bos1 = new BufferedOutputStream(os1, 32768);
                this.myPrintStream1 = new PrintStream(bos1, false);
                this.mystartGA = new GaStart(this);
                this.mystartGA.start();
            }
            catch (Exception e) {
                System.out.println("Error: GAReport.dat " + e);
                return;
            }
        }
        this.UserWantsPointer();
    }

    public void UserWantsrunOptimalFeeder() {
        this.stopGA = false;
        if (this.HelpWanted) {
            HelpDialog MyHelpDialog = new HelpDialog(frame, "runOptimalFeeder");
        } else if (this.MyrunGaFrame == null) {
            try {
                FileOutputStream os = new FileOutputStream("./results/OptimalFeederReport.dat");
                BufferedOutputStream bos = new BufferedOutputStream(os, 32768);
                this.myPrintStream = new PrintStream(bos, false);
                FileOutputStream os1 = new FileOutputStream("./results/OptimalFeederB.dat");
                BufferedOutputStream bos1 = new BufferedOutputStream(os1, 32768);
                this.myPrintStream1 = new PrintStream(bos1, false);
                this.myOptimalFeeder = new OptimalFeeder(this);
                this.myOptimalFeeder.start();
            }
            catch (Exception e) {
                System.out.println("Error: OptimalFeeder.dat " + e);
                return;
            }
        }
        this.UserWantsPointer();
    }

    public void UserWantsstopGa() {
        try {
            this.myPrintStream.close();
            this.myPrintStream = null;
            this.myPrintStream1.close();
            this.myPrintStream1 = null;
            this.MyrunGaFrame.setVisible(false);
            this.mystartGA = null;
            this.MyrunGaFrame = null;
        }
        catch (Exception e) {
            System.out.println("Error: GAReport.dat close() " + e);
        }
    }

    public void UserWantsTime() {
        if (this.HelpWanted) {
            HelpDialog helpDialog = new HelpDialog(frame, "Time");
        } else if (this.MyTimeFrame == null) {
            this.MyTimeFrame = new TimeFrame(this);
            this.MyTimeFrame.setResizable(false);
        } else {
            this.MyTimeFrame.setVisible(true);
        }
        this.UserWantsPointer();
    }

    public void UserWantsAboutWindow() {
        DeepEditAboutFrame aboutDE = new DeepEditAboutFrame();
        aboutDE.setLocationRelativeTo(frame);
        aboutDE.setVisible(true);
    }

    public void UserWantsHelpFile() {
        if (Desktop.isDesktopSupported()) {
            try {
                File myFile = new File(HELP_FOLDER + File.separator + "DEEP-EDITOR_Manual.pdf");
                Desktop.getDesktop().open(myFile);
            }
            catch (IOException ex) {
                System.out.println("There are no applications registered for PDFs");
                System.out.println("Try opening the file using your SO explorer: DEEPEDIT_INSTALL_FOLDER/help/DEEP-EDITOR_Manual.pdf");
                System.out.println(ex.getMessage());
            }
        }
    }

    public void UserWantsAdjustTopLeft() {
        Point topleft = new Point();
        topleft = MySchematic.AdjustTopLeft();
        MySchematicPanel.AdjustPosition(topleft);
    }

    public boolean UserWantsAdjustSearchName(String searchname) {
        Point position = new Point();
        position = MySchematic.AdjustSearchName(searchname);
        DeepEdit.MySchematicPanel.PrevSelectedComponent = DeepEdit.MySchematic.TempComponent;
        if (position.x != 100000) {
            MySchematicPanel.AdjustPosition(position);
            MySchematicPanel.StatusMessage("Selected Component: " + DeepEdit.MySchematic.TempComponent.getClassName() + "| Name: " + DeepEdit.MySchematic.TempComponent.getName() + "| Entry: " + DeepEdit.MySchematic.TempComponent.getentry_period() + "| Exit: " + DeepEdit.MySchematic.TempComponent.getexit_period() + "| ");
            return true;
        }
        return false;
    }

    public void UserWantsComponentFrame(comp TempComponent) {
        if (TempComponent instanceof Constraint) {
            ConstraintBuilderFrame cWindow = new ConstraintBuilderFrame((Window)frame);
            cWindow.loadConstraint((Constraint)TempComponent);
            cWindow.setLocationRelativeTo(frame);
            cWindow.setVisible(true);
        }
        TempComponent.setSelected(true);
        DeepEdit.MySchematicPanel.PrevSelectedComponent = TempComponent;
        DeepEdit.MySchematic.TempComponent = TempComponent;
        this.UserWantsEditComponentSchematic();
    }

    public static DeepEdit matlabf(int ii) {
        DeepEdit myDE = new DeepEdit();
        return myDE;
    }

    public static void main(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            System.out.println("Input " + (i + 1) + " = " + args[i]);
        }
        String schematicFile = args.length == 1 ? args[0] : "";
        DeepEdit myDE = new DeepEdit(schematicFile);
    }

    public static Connection getDeepDBConnection() {
        if (DeepEditFrame.con == null) {
            DeepEditFrame.con = DeepEdit.OpenStaticDBConnection();
            return DeepEditFrame.con;
        }
        try {
            if (DeepEditFrame.con.isClosed()) {
                DeepEditFrame.con = DeepEdit.OpenStaticDBConnection();
            } else {
                String sDeepDBName = DeepEdit.getDeepDBName();
                if (!DeepEditFrame.con.getMetaData().getURL().contains(sDeepDBName)) {
                    DeepEditFrame.con = DeepEdit.OpenStaticDBConnection();
                }
            }
        }
        catch (SQLException ex) {
            System.out.println("Error trying to re-open database connection with DeepBD: " + ex.getMessage());
            ex.printStackTrace(System.out);
        }
        return DeepEditFrame.con;
    }

    public static boolean isMinosLinearInstalled() {
        File f = new File("lineal.exe");
        return f.exists();
    }

    public static boolean isMinosQuadraInstalled() {
        File f = new File("cuadra.exe");
        return f.exists();
    }

    public String getParameter(String request) {
        assert (false) : "Why are you requesting a deprecated configuration parameter function?";
        if (request.equals("schematic")) {
            return "schematics/start.sim";
        }
        if (request.equals("map")) {
            return "images/map.gif";
        }
        if (request.equals("Grilla")) {
            return "4";
        }
        if (request.equals("PathDOS")) {
            return ".\\";
        }
        if (request.equals("PathUNIX")) {
            return "./";
        }
        if (request.equals("fileop")) {
            return "true";
        }
        return "";
    }

    private static boolean checkDeepEditInstallation(String[] messageError) {
        String sDatabaseFolder = new File("").getAbsolutePath() + File.separator + DATABASE_FOLDER;
        String sConfigFolder = new File("").getAbsolutePath() + File.separator + CONFIG_FOLDER;
        String sHelpFolder = new File("").getAbsolutePath() + File.separator + HELP_FOLDER;
        String sResultsFolder = AnalysisTool.RESULT_FOLDER;
        messageError[0] = "";
        if (!AnalysisTool.DirectoryExist(sDatabaseFolder)) {
            messageError[0] = messageError[0] + "Missing 'Database' folder. Expected in the following path: \n" + sDatabaseFolder + "\n";
            return false;
        }
        if (!AnalysisTool.DirectoryExist(sConfigFolder)) {
            messageError[0] = messageError[0] + "Missing 'Configuration' folder. Expected in the following path: \n" + sConfigFolder + "\n";
            return false;
        }
        if (!AnalysisTool.DirectoryExist(sHelpFolder)) {
            messageError[0] = messageError[0] + "Missing 'Help' folder. Expected in the following path: \n" + sHelpFolder + "\n";
            return false;
        }
        if (!AnalysisTool.DirectoryExist(sResultsFolder)) {
            messageError[0] = messageError[0] + "Missing 'Results' folder. Expected in the following path: \n" + sResultsFolder + "\n";
            return false;
        }
        return true;
    }

    public static String getConfigFileFullPath() {
        String sConfigPath = new File("").getAbsolutePath() + File.separator + CONFIG_FOLDER;
        return sConfigPath + File.separator + "config.xml";
    }

    public static String getGUIConfigFileFullPath() {
        String sConfigPath = new File("").getAbsolutePath() + File.separator + CONFIG_FOLDER;
        return sConfigPath + File.separator + "gui-config.xml";
    }

    private static void loadDEPropetyFile() throws FileNotFoundException, IOException {
        File fileAppConfigProperties = new File(DeepEdit.getConfigFileFullPath());
        if (!fileAppConfigProperties.exists()) {
            String sDefaultConfigFile = new File("").getAbsolutePath() + File.separator + CONFIG_FOLDER + File.separator + "default-config.xml";
            FileInputStream in = new FileInputStream(sDefaultConfigFile);
            DEDefaultProperties = new Properties();
            DEDefaultProperties.loadFromXML(in);
            in.close();
            FileOutputStream out = new FileOutputStream(DeepEdit.getConfigFileFullPath());
            DEDefaultProperties.storeToXML(out, "---DEEP-EDITOR CONFIG FILE---");
            out.close();
        }
        DEDefaultProperties = new Properties();
        FileInputStream in = new FileInputStream(DeepEdit.getConfigFileFullPath());
        DEDefaultProperties.loadFromXML(in);
        in.close();
    }

    private static void saveDEPropertyFile() throws FileNotFoundException, IOException {
        FileOutputStream out = new FileOutputStream(DeepEdit.getConfigFileFullPath());
        DEDefaultProperties.storeToXML(out, "---DEEP-EDITOR CONFIG FILE---");
        out.close();
    }

    public static String getOptionValue(String property) {
        if (DEDefaultProperties == null) {
            return null;
        }
        return DEDefaultProperties.getProperty(property);
    }

    public static int getIntegerOptionValue(String property) {
        int nRetValue = 0;
        if (DEDefaultProperties == null) {
            return nRetValue;
        }
        try {
            nRetValue = Integer.parseInt(DEDefaultProperties.getProperty(property));
        }
        catch (NumberFormatException e) {
            System.err.println("Error parsing to integer config file property " + property + ". Details: " + e.getMessage());
            return nRetValue;
        }
        return nRetValue;
    }

    public static double getDoubleOptionValue(String property) {
        double nRetValue = 0.0;
        if (DEDefaultProperties == null) {
            return nRetValue;
        }
        try {
            nRetValue = Double.parseDouble(DEDefaultProperties.getProperty(property));
        }
        catch (NumberFormatException e) {
            System.err.println("Error parsing to integer config file property " + property + ". Details: " + e.getMessage());
            return nRetValue;
        }
        return nRetValue;
    }

    public static boolean getBooleanOptionValue(String property) {
        boolean bRetValue = true;
        if (DEDefaultProperties == null) {
            return bRetValue;
        }
        try {
            bRetValue = Boolean.parseBoolean(DEDefaultProperties.getProperty(property));
        }
        catch (NumberFormatException e) {
            System.err.println("Error parsing to integer config file property " + property + ". Details: " + e.getMessage());
            return bRetValue;
        }
        return bRetValue;
    }

    public static void setOptionValue(String key, String propertyValue) {
        if (DEDefaultProperties != null && key != null && propertyValue != null) {
            DEDefaultProperties.setProperty(key, propertyValue);
        }
    }

    public static void setOptionValue(String key, double propertyValue) {
        if (DEDefaultProperties != null && key != null) {
            DEDefaultProperties.setProperty(key, String.valueOf(propertyValue));
        }
    }

    public static void setOptionValue(String key, int propertyValue) {
        if (DEDefaultProperties != null && key != null) {
            DEDefaultProperties.setProperty(key, String.valueOf(propertyValue));
        }
    }

    public static void setOptionValue(String key, boolean propertyValue) {
        if (DEDefaultProperties != null && key != null) {
            DEDefaultProperties.setProperty(key, String.valueOf(propertyValue));
        }
    }

    public static boolean isCompNameUnique(comp DEComp) {
        return MySchematic.isCompNameUnique(DEComp);
    }

    public static boolean isCompNameUnique(String NewName, String className) {
        return MySchematic.isCompNameUnique(NewName, className);
    }

    public static boolean registerCompName(String oldName, String newName, comp DEComp) {
        return MySchematic.renameComp(oldName, newName, DEComp);
    }

    public static File createTempFile(String prefix, String suffix) throws IOException {
        File temp = File.createTempFile(prefix, suffix);
        temp.deleteOnExit();
        if (!temp.delete()) {
            throw new IOException("Could not delete temp file: " + temp.getAbsolutePath());
        }
        lTempFiles.add(temp);
        return temp;
    }

    public URL getDocumentBase() {
        URL tmpUrl;
        try {
            tmpUrl = new File("./").toURL();
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            return null;
        }
        return tmpUrl;
    }

    public URL getCodeBase() {
        URL tmpUrl;
        try {
            tmpUrl = new File("./").toURI().toURL();
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            return null;
        }
        return tmpUrl;
    }

    public Image getImage(URL theURL, String imagFileS) {
        Image tmpImg;
        try {
            URL imageURL = this.getClass().getResource("/" + imagFileS);
            if (imageURL == null) {
                return null;
            }
            tmpImg = Toolkit.getDefaultToolkit().getImage(imageURL);
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            return null;
        }
        return tmpImg;
    }

    public Image getFrameIconImage() {
        if (this.FrameIconImage == null) {
            this.FrameIconImage = this.getImage(this.getCodeBase(), "images/DEfavicon.png");
        }
        return this.FrameIconImage;
    }

    public JImagePanel createOverviewPanel() {
        if (this.MyOverviewFrame != null) {
            this.MyOverviewFrame.dispose();
            this.MyOverviewFrame = null;
        }
        this.MyOverviewFrame = new OverviewFrame(this);
        return this.MyOverviewFrame.getOverviewPane();
    }

    public void refreshOverviewPanel() {
        if (this.MyOverviewFrame != null) {
            this.MyOverviewFrame.dispose();
            this.MyOverviewFrame = null;
        }
        this.MyOverviewFrame = new OverviewFrame(this);
        this.setOverviewPanel(this.MyOverviewFrame.getOverviewPane());
    }

    public void setOverviewPanel(JImagePanel overviewPane) {
        if (frame != null) {
            frame.setOverviewPanel(overviewPane);
        }
    }

    public static void setDataTabPane(JTable tblDataView) {
        DeepEditFrame.setDataTabPane(tblDataView);
    }

    public static JTree getDataTreeGUI() {
        return frame.getDataTreeGUI();
    }

    public void setEditorLanguage(DE_GeneralEnums.Language language) {
        this.idioma = language.getValue();
        DeepEdit.setOptionValue("Language", language.toString());
    }

    public static DE_GeneralEnums.Language getEditorLanguage() {
        String sLanguage = DeepEdit.getOptionValue("Language");
        return DE_GeneralEnums.Language.valueOf(sLanguage);
    }

    public void setComponentInGUI(comp DEComp) {
        frame.setComponentInGUI(DEComp);
    }

    public static comp getComponentAt(int x, int y) {
        return MySchematic.getComponentAt(x, y);
    }

    public static List<String> getCtrlaList() {
        return MySchematic.getCtrlaList();
    }

    public static Color getPowerEditorColor() {
        return Utils.string2ColorProperty(DeepEdit.getOptionValue("PowerEditorColor"));
    }

    public static void setPowerEditorColor(Color PowerEditorColor) {
        DeepEdit.setOptionValue("PowerEditorColor", Utils.color2StringProperty(PowerEditorColor));
    }

    public static Color getMarketEditorColor() {
        return Utils.string2ColorProperty(DeepEdit.getOptionValue("MarketEditorColor"));
    }

    public static void setMarketEditorColor(Color MarketEditorColor) {
        DeepEdit.setOptionValue("MarketEditorColor", Utils.color2StringProperty(MarketEditorColor));
    }

    public static Color getHydroEditorColor() {
        return Utils.string2ColorProperty(DeepEdit.getOptionValue("HydroEditorColor"));
    }

    public static void setHydroEditorColor(Color HydroEditorColor) {
        DeepEdit.setOptionValue("HydroEditorColor", Utils.color2StringProperty(HydroEditorColor));
    }

    public static Color getGridColor() {
        return Utils.string2ColorProperty(DeepEdit.getOptionValue("GridColor"));
    }

    public static void setGridColor(Color GridColor) {
        DeepEdit.setOptionValue("GridColor", Utils.color2StringProperty(GridColor));
    }

    public static String getDeepDBName() {
        DeepDBName = DeepEdit.getOptionValue("DeepDBName");
        return DeepDBName;
    }

    public static void setDeepDBName(String DeepDBName) {
        if (DeepDBName == null) {
            return;
        }
        if (!DeepDBName.equals(DeepEdit.DeepDBName)) {
            DeepEdit.setOptionValue("DeepDBName", DeepDBName);
            DeepEdit.CloseJDBCConnection(DeepEditFrame.con);
            DeepEdit.DeepDBName = DeepDBName;
        }
    }

    public static String getDailyDBName() {
        DailyDBName = DeepEdit.getOptionValue("DailyDBName");
        return DailyDBName;
    }

    public static void setDailyDBName(String DailyDBName) {
        if (DailyDBName == null) {
            return;
        }
        DeepEdit.setOptionValue("DailyDBName", DailyDBName);
        DeepEdit.DailyDBName = DailyDBName;
    }

    public static String getYearlyDBName() {
        YearlyDBName = DeepEdit.getOptionValue("YearlyDBName");
        return YearlyDBName;
    }

    public static void setYearlyDBName(String YearlyDBName) {
        if (YearlyDBName == null) {
            return;
        }
        DeepEdit.setOptionValue("YearlyDBName", YearlyDBName);
        DeepEdit.YearlyDBName = YearlyDBName;
    }

    public void setFontSize(DE_GeneralEnums.FontSize newFontSize) {
        switch (newFontSize) {
            case Small: {
                TextFont = Font10;
                CodeFont = new Font("Courier", 0, 10);
                textArea.setFont(CodeFont);
                break;
            }
            case Medium: {
                TextFont = Font14;
                CodeFont = new Font("Courier", 0, 12);
                textArea.setFont(CodeFont);
                break;
            }
            case Large: {
                TextFont = Font18;
                CodeFont = new Font("Courier", 0, 14);
                textArea.setFont(CodeFont);
            }
        }
        DeepEdit.setOptionValue("EditorFontSize", newFontSize.toString());
        frame.repaint();
        frame.setVisible(true);
    }

    public static DE_GeneralEnums.FontSize getFontSize() {
        String fontSize = DeepEdit.getOptionValue("EditorFontSize");
        if (fontSize == null) {
            return DE_GeneralEnums.FontSize.Small;
        }
        return DE_GeneralEnums.FontSize.valueOf(fontSize);
    }

    private static void checkSystemCompatibility(boolean is32BitRequired) {
        String JREVersion;
        String JavaVersion = DeepEdit.getJavaVersion();
        if (JavaVersion != null) {
            if (!JavaVersion.startsWith("1.6") && !JavaVersion.startsWith("1.7")) {
                System.out.println("Java Version Warning: Version " + JavaVersion + " is either not supported or not fully tested.");
            }
        } else {
            System.err.println("Java version couldn't be checked. This application is tested under Oracle's Java 1.6 - 1.7.");
        }
        if ((JREVersion = DeepEdit.getJREVersion()) != null) {
            if ("32".equalsIgnoreCase(JREVersion)) {
                isJRE32Bits = true;
            } else if ("64".equalsIgnoreCase(JREVersion)) {
                isJRE32Bits = false;
                if (is32BitRequired) {
                    System.out.println("WARNING: JRE is not 32bits (or different from Oracle's implementation). Please install any 1.6 or 1.7 JRE 32bits.");
                    System.out.println("MS Access database functions and utilities dependent on MS Access may not work properly.");
                }
            } else assert (false) : "What JRE are you using?? " + JREVersion;
        } else {
            System.err.println("JRE version couldn't be checked. This application is recommended to work under Oracle's JRE 1.6 - 1.7 32 bits version");
        }
        if (JavaVersion != null && JREVersion != null) {
            System.out.println("DeepEdit running on Java " + JavaVersion + " " + JREVersion + " bits");
        }
    }

    private static String getJavaVersion() {
        String sJavaVersion = null;
        try {
            sJavaVersion = System.getProperty("java.version");
        }
        catch (SecurityException e) {
        }
        catch (NullPointerException e) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return sJavaVersion;
    }

    private static String getJREVersion() {
        String sJREVersion = null;
        try {
            sJREVersion = System.getProperty("sun.arch.data.model");
        }
        catch (SecurityException e) {
        }
        catch (NullPointerException e) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return sJREVersion;
    }

    private static boolean initParameterVersion() {
        String xmlParameterFilePath = new File("").getAbsolutePath() + File.separator + CONFIG_FOLDER;
        File xmlParameterFile = new File(xmlParameterFilePath + File.separator + "DeepEditParameter.xml");
        if (xmlParameterFile.exists()) {
            try {
                JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{ParameterInfo.class});
                Unmarshaller jaxbUnmarshaller = jaxbContext.createUnmarshaller();
                DEParameterInfo = (ParameterInfo)jaxbUnmarshaller.unmarshal(xmlParameterFile);
                return true;
            }
            catch (JAXBException ex) {
                System.err.println("Error parsing parameter config file: " + ex.getMessage());
                ex.printStackTrace(System.err);
            }
        }
        return false;
    }

    public static List<String> getDeepEditClasses() {
        if (DEParameterInfo == null) {
            DeepEdit.initParameterVersion();
        }
        return DEParameterInfo.getClassNameList();
    }

    public static boolean isSupportedParameter(String sParameterName, String sClassName) {
        List<String> lParam = DeepEdit.getParameterNameList(sClassName);
        return lParam.contains(sParameterName);
    }

    public static List<String> getParameterNameList(String className) {
        if (DEParameterInfo == null) {
            DeepEdit.initParameterVersion();
        }
        return DEParameterInfo.getParameterNameList(className);
    }

    public static ParameterData getDefaultParameterInfo(String className, String parameterName) {
        if (DEParameterInfo == null) {
            DeepEdit.initParameterVersion();
        }
        if (DEParameterInfo.isParameterSupported(className, parameterName)) {
            return DEParameterInfo.getDefaultParameterInfo(className, parameterName);
        }
        return null;
    }

    public static String getValidationRule(String className, String parameterName) {
        if (DEParameterInfo == null) {
            DeepEdit.initParameterVersion();
        }
        return DEParameterInfo.getValidationRule(className, parameterName);
    }

    public static boolean isParameterShowInGUI(String className, String parameterName) {
        if (DEParameterInfo == null) {
            DeepEdit.initParameterVersion();
        }
        return DEParameterInfo.isShowInGUI(className, parameterName);
    }

    private void setConsoleOutput(String DEVersion) {
        textArea = frame.getOutputTextArea();
        textArea.setEditable(false);
        textArea.setRows(20);
        textArea.setColumns(55);
        this.setFontSize(DE_GeneralEnums.FontSize.valueOf(DeepEdit.getOptionValue("EditorFontSize")));
        System.setOut(ConsoleOutputStream.createPStream(textArea, null));
        System.out.println("=================== DeepEdit v" + DEVersion + " Trial ================================");
        System.out.println("        Current date: " + new GregorianCalendar().getTime());
        System.out.println("        Expiration date: " + Obj.expDate.getTime());
        System.out.println("===========================================================================");
        System.out.println(" ");
        System.out.println("---------------------------------------------------------------------------");
        System.out.println("                   Console Output / Salida de sistema ");
        System.out.println("---------------------------------------------------------------------------");
        System.out.println(" ");
    }

    private static Connection OpenStaticDBConnection(boolean bAutoCommit) {
        String DBName = "." + File.separator + DATABASE_FOLDER + File.separator + DeepEdit.getDeepDBName();
        if (DBName.contains("DeepDB.db")) {
            return DeepEdit.OpenSQLLiteConnection(DBName, bAutoCommit);
        }
        if (DBName.contains("DeepDB.mdb") || DBName.contains("DeepDB.accdb")) {
            return DeepEdit.OpenODBC_JDBCConnection(DBName, bAutoCommit);
        }
        assert (false) : "Why you are looking for " + DBName + "? No other static databases are supported but .mdb, .db and .accdb are supported";
        return null;
    }

    private static Connection OpenStaticDBConnection() {
        String DBName = "." + File.separator + DATABASE_FOLDER + File.separator + DeepEdit.getDeepDBName();
        if (DBName.contains("DeepDB.db")) {
            return DeepEdit.OpenSQLLiteConnection(DBName, false);
        }
        if (DBName.contains("DeepDB.mdb") || DBName.contains("DeepDB.accdb")) {
            return DeepEdit.OpenODBC_JDBCConnection(DBName, true);
        }
        assert (false) : "Why you are looking for " + DBName + "? No other static databases are supported but .mdb, .db and .accdb are supported";
        return null;
    }

    public static Connection OpenODBC_JDBCConnection(String DBName, boolean bAutoCommit) {
        String strFullDBPath;
        try {
            Class.forName("sun.jdbc.odbc.JdbcOdbcDriver");
        }
        catch (ClassNotFoundException e) {
            System.out.println("Error loading JdbcOdbcDriver. Exception Details: " + e.getMessage());
            e.printStackTrace(System.out);
        }
        File f = new File(DBName);
        if (f.exists()) {
            strFullDBPath = f.getAbsolutePath();
        } else {
            File Access2003File = new File("." + File.separator + DATABASE_FOLDER + File.separator + DBName + ".mdb");
            File Access2007File = new File("." + File.separator + DATABASE_FOLDER + File.separator + DBName + ".accdb");
            if (Access2007File.exists()) {
                strFullDBPath = Access2007File.getAbsolutePath();
            } else if (Access2003File.exists()) {
                strFullDBPath = Access2003File.getAbsolutePath();
            } else {
                System.out.println("Invalid file path to: " + DBName);
                System.out.println("WARNING: Connection to database" + DBName + " failed...");
                return null;
            }
        }
        String dsn = isJRE32Bits ? "jdbc:odbc:Driver={Microsoft Access Driver (*.mdb)};DBQ=" + strFullDBPath : "jdbc:odbc:Driver={Microsoft Access Driver (*.mdb, *.accdb)};DBQ=" + strFullDBPath;
        String user = "Administrator";
        String password = "lilo";
        Connection myConnection = null;
        try {
            myConnection = DriverManager.getConnection(dsn, user, password);
            myConnection.setAutoCommit(bAutoCommit);
        }
        catch (SQLException ex) {
            System.out.println("Current work directory: " + System.getProperty("user.dir"));
            System.out.println("Error opening database: " + DBName + "=> " + ex.getMessage());
        }
        return myConnection;
    }

    public static Connection OpenJDBCConnection(String DBName, boolean bAutoCommit) {
        return DeepEdit.OpenJDBCConnection(DBName, null, bAutoCommit);
    }

    public static Connection OpenJDBCConnection(String DBName, DE_GeneralEnums.DatabaseVendor eDBType, boolean bAutoCommit) {
        if (eDBType == null) {
            eDBType = DBName.contains(".mdb") || DBName.contains(".accdb") ? DE_GeneralEnums.DatabaseVendor.MSAccess : DE_GeneralEnums.DatabaseVendor.SQLite;
        }
        if (eDBType.equals((Object)DE_GeneralEnums.DatabaseVendor.SQLite)) {
            return DeepEdit.OpenSQLLiteConnection(DBName, bAutoCommit);
        }
        if (eDBType.equals((Object)DE_GeneralEnums.DatabaseVendor.MSAccess)) {
            return DeepEdit.OpenODBC_JDBCConnection(DBName, bAutoCommit);
        }
        assert (false) : "Why are you trying to use an unsupported database type: " + eDBType.toString();
        return null;
    }

    public static void CloseJDBCConnection(Connection conn) {
        if (conn == null) {
            return;
        }
        try {
            if (conn.isClosed()) {
                return;
            }
        }
        catch (SQLException e) {
            System.out.println("Warning: Error getting open/close property. Database might not being fully updated. Check if changes were succesfully submitted.");
            System.out.println("Exception details: " + e.getMessage());
            e.printStackTrace(System.out);
        }
        boolean bAutoCommit = false;
        try {
            bAutoCommit = conn.getAutoCommit();
        }
        catch (SQLException e) {
            System.out.println("Warning: Error getting autocommit property. Database might not being fully updated. Check if changes were succesfully submitted.");
            System.out.println("Exception details: " + e.getMessage());
            e.printStackTrace(System.out);
        }
        if (!bAutoCommit) {
            try {
                conn.commit();
            }
            catch (SQLException e) {
                System.out.println("Error committing TPDB database transaction. Database might not being fully updated. Check if changes were succesfully submitted.");
                System.out.println("Exception details: " + e.getMessage());
                e.printStackTrace(System.out);
            }
        }
        try {
            conn.close();
        }
        catch (SQLException e) {
            System.out.println("Error closing TPDB database connection. Details: " + e.getMessage());
        }
    }

    public static Connection OpenSQLLiteConnection(String DBName, boolean bAutoCommit) {
        String strFullDBPath;
        try {
            Class.forName("org.sqlite.JDBC");
        }
        catch (ClassNotFoundException e) {
            System.out.println("Error loading sqlite driver. Exception Details: " + e.getMessage());
            e.printStackTrace(System.out);
        }
        File f = new File(DBName);
        if (f.exists()) {
            strFullDBPath = f.getAbsolutePath();
        } else {
            f = new File("." + File.separator + DATABASE_FOLDER + File.separator + DBName + ".db");
            if (f.exists()) {
                strFullDBPath = f.getAbsolutePath();
            } else {
                System.out.println("Invalid file path to: " + DBName);
                System.out.println("WARNING: Connection to database" + DBName + " failed...");
                return null;
            }
        }
        String dsn = "jdbc:sqlite:" + strFullDBPath;
        String user = "Administrator";
        String password = "lilo";
        Connection myConnection = null;
        try {
            myConnection = DriverManager.getConnection(dsn, user, password);
            myConnection.setAutoCommit(bAutoCommit);
        }
        catch (SQLException ex) {
            System.out.println("Current work directory: " + System.getProperty("user.dir"));
            System.out.println("Error opening database: " + DBName + "=> " + ex.getMessage());
        }
        return myConnection;
    }

    public static Connection OpenCSVasDB(String DBName) {
        System.out.println("---------- In " + DBName + " CSV as DB ------------");
        try {
            Class.forName("sun.jdbc.odbc.JdbcOdbcDriver").newInstance();
        }
        catch (Exception e) {
            String message = e.toString();
            String[] DlgButtons = new String[]{"OK"};
            SimpleDialog ExceptionDialog = new SimpleDialog(frame, "Open " + DBName + " as CSV DataBase", " ", DlgButtons, 1, 0, 0, 1);
            return null;
        }
        String dsn = "jdbc:odbc:Driver={Microsoft Text Driver (*.txt; *.csv)};DBQ=." + File.separator + DBName + File.separator + ";Extensions=asc,csv,dat,txt";
        String user = "";
        String password = "";
        System.out.println("Connection with: " + DBName + " as CSV Database is initialized.");
        DeepEditFrame.con = null;
        try {
            DeepEditFrame.con = DriverManager.getConnection(dsn, user, password);
        }
        catch (Exception ex) {
            System.out.println("Error opening database: " + DBName + "=> " + ex.getMessage());
        }
        return DeepEditFrame.con;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Schematic OpenDatabase(Pin[][] PinGrid) throws Exception {
        Schematic NewSchematic = null;
        DeepEditFrame.con = DeepEdit.getDeepDBConnection();
        if (DeepEditFrame.con != null) {
            if (PinGrid != null) {
                MySchematic.DestroyComponents(DeepEdit.PinGrid);
                try {
                    Runtime r = Runtime.getRuntime();
                    r.gc();
                }
                catch (Exception e) {
                    System.out.println("Error in Garbage Colector" + e);
                }
            }
            try {
                DeepEdit.showProgressFrame("Loading ODBC Database: ", 16);
                NewSchematic = new Schematic(PinGrid);
                DeepEditFrame.con.rollback();
            }
            catch (Exception e) {
                System.out.println("Unexpected error reading DeepDB. Details:" + e.getMessage());
                e.printStackTrace(System.err);
                MySchematicPanel.repaint();
                Schematic schematic = null;
                return schematic;
            }
            finally {
                DeepEdit.hideProgressFrame();
                DeepEdit.hideProgressBar();
            }
        }
        return NewSchematic;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadSchematicFromFile(String fileName) {
        long initime = System.currentTimeMillis();
        Schematic OpenSchematic = null;
        MySchematic.DestroyComponents(PinGrid);
        try {
            if (ExcelUtil.isExcel2007FileType(fileName)) {
                String[][] s = ExcelUtil.readExcel2007Data(fileName, "Schematic", 1, 1, -1, 1);
                if (s == null) {
                    System.out.println("No valid Schematic found in Excel file " + fileName);
                    System.out.println("No schematic has been loaded");
                    OpenSchematic = null;
                } else {
                    File tempFile = DeepEdit.createTempFile("temp", null);
                    FileOutputStream os = new FileOutputStream(tempFile);
                    for (String[] row : s) {
                        if (row[0].isEmpty()) break;
                        os.write(row[0].getBytes(Charset.defaultCharset()));
                        os.write(System.getProperty("line.separator").getBytes(Charset.defaultCharset()));
                    }
                    os.close();
                    OpenSchematic = new Schematic(PinGrid, tempFile.getAbsolutePath());
                    OpenSchematic.FileDir = new File(fileName).getParent() + File.separator;
                    OpenSchematic.FileName = new File(fileName).getName();
                }
            } else {
                OpenSchematic = new Schematic(PinGrid, fileName);
            }
        }
        catch (FileNotFoundException e) {
            System.out.println("Schematic file not found. Make sure file exists: " + e.getMessage());
        }
        catch (IOException e) {
            System.out.println("Error parsing Schematic file: " + e.getMessage());
        }
        catch (NumberFormatException e) {
            System.out.println("Parsing validation error. Details: " + e.getMessage());
        }
        catch (ExceptionInInitializerError e) {
            System.out.println(e.getMessage());
        }
        finally {
            DeepEdit.hideProgressBar();
            DeepEdit.hideProgressFrame();
        }
        if (OpenSchematic != null) {
            MySchematic = OpenSchematic;
            frame.setTitle(NEditor, MySchematic);
            DeepEdit.updateGUITreeView();
            DeepEdit.refreshOwnerships();
            MySchematic.setEditor(DeepEdit.getEditor());
            DeepEdit.SimulateSetUp();
            DeepEdit.updateTime();
            MySchematicPanel.repaint();
            System.out.println("Finished parsing Schematic file '" + DeepEdit.MySchematic.FileName + "'. Time: " + StringUtil.numformat((double)(System.currentTimeMillis() - initime) / 1000.0, 2) + "[sec]");
        }
    }

    public static void saveSchematicToFile(Schematic sch, String fileName) throws FileNotFoundException, IOException, InvalidFormatException {
        sch.saveToFile(fileName, false);
    }

    static {
        ViewMode = false;
        isJRE32Bits = true;
        MyStatusPanel = null;
        MySchematicPanel = null;
        PathDOS = ".\\";
        PathUNIX = "./";
        MySchematic = null;
        GridImage = null;
        ImageBuffer = null;
        ImageBuffer1 = null;
        GridStep = 6;
        GridStepPower = 6;
        GridStepMarket = 6;
        ShowAlias = false;
        ShowPins = true;
        HighLightPins = true;
        PrintConnecWarnings = false;
        NEditor = DE_GeneralEnums.editor.Power;
        myVisualImportFrame = null;
        MyDataTree = null;
        isGUI = true;
        Font8 = new Font("Arial", 0, 8);
        Font9 = new Font("Arial", 0, 9);
        Font10 = new Font("Arial", 0, 10);
        Font12 = new Font("Arial", 0, 12);
        Font14 = new Font("Arial", 0, 14);
        Font16 = new Font("Arial", 0, 16);
        Font18 = new Font("Arial", 0, 18);
        TextFont = Font10;
        CodeFont = new Font("Courier", 0, 11);
        DeepDBName = "DeepDB.db";
        DailyDBName = "TPDB3.3.mdb";
        YearlyDBName = "TPDB3.3.mdb";
        lTempFiles = new LinkedList<File>();
    }
}

