/*
 * Decompiled with CFR 0.152.
 */
package de.core;

import de.core.AnalysisTool;
import de.core.Busbar;
import de.core.DLFDGFrame;
import de.core.DalfoFrame;
import de.core.DeepEdit;
import de.core.GeneratorCHP;
import de.core.GeneratorDG;
import de.core.GeneratorEO;
import de.core.GeneratorPV;
import de.core.Line;
import de.core.Load;
import de.core.Schematic;
import de.core.SimpleDialog;
import de.core.Trafo;
import de.core.ZFileViewer;
import de.core.comp;
import de.core.mdb_wheel;
import de.core.ndb_1pol;
import de.core.ndb_2pol;
import de.core.ndb_branch;
import de.core.ndb_comp;
import de.core.ndb_inj;
import java.awt.Font;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Vector;

public class DLFDG
extends AnalysisTool {
    private String Archivo = "./results/DALFO.dat";
    private String db_cluster = "DLF_Cluster";
    private String db_dg = "DLF_DG";
    private String db_weather = "DLF_Weather";
    private String db_save = "DLF_Save";
    private String db_chp = "DLF_CHP";
    String nomB = "";
    String nomT = "";
    Connection DBDalfo;
    Connection DB_Weather;
    Connection DB_DG;
    Connection DB_Save;
    Connection DB_CHP;
    Statement stmt;
    Statement stmt_weather;
    Statement stmt_dg;
    Statement stmt_save;
    Statement stmt_chp;
    String query;
    String query_weather;
    String query_dg;
    String query_save;
    String query_chp;
    ResultSet rs;
    ResultSet rs_weather;
    ResultSet rs_dg;
    ResultSet rs_save;
    ResultSet rs_chp;
    DeepEdit deepEdApp;
    ZFileViewer MyZFileViewer;
    DLFDGFrame MyDLFDGFrame;
    DalfoFrame MyDalfoFrame;
    private Vector SubNetwork;
    private Vector name_load;
    private FileOutputStream os = null;
    private int n_bus = 0;
    private int n_gen = 0;
    private int n_load = 0;
    private int n_loadCHP;
    private int nlfix;
    private int n_tran = 0;
    private int n_line = 0;
    private int n_genDG = 0;
    private int n_genPV = 0;
    private int n_genEO = 0;
    private int n_genCHP = 0;
    private int n_subred = 0;
    private int n_tot = 0;
    private int n_DGs = 0;
    private int n_porcent = 0;
    private int m;
    private int d;
    private int n_d;
    private int ntimes = 96;
    private int simperiod = 0;
    private double[] dc1;
    private double[] dc2;
    private double[] dc3;
    private double pmc1;
    private double pmc2;
    private double pmc3;
    double[] zbal;
    double[] zcon;
    double[] zgendg;
    double[] zeo;
    double[] zchp;
    double[] zpv;
    double[] zpsh;
    double[] zdg;
    double[] zstore;
    double[] zapEO;
    double[] zapPV;
    double[] zapDG;
    double[] Zlocal;
    double[] Zutc;
    double[] tv;
    double[] tF;
    double[] dspeed;
    double[] dtemp;
    double[] t_dspeed;
    double[] t_cch;
    double[] t_ccm;
    double[] t_ccl;
    double[] sinphi;
    double[] t_trans;
    double[] t_rad;
    double sbal;
    double scon;
    double sgendg;
    double seo;
    double schp;
    double spv;
    double spsh;
    double sdg;
    double sstore;
    double sscon = 0.0;
    double ssgendg = 0.0;
    double sseo = 0.0;
    double sschp = 0.0;
    double sspv = 0.0;
    double sspsh = 0.0;
    double ssdg = 0.0;
    double ssbal = 0.0;
    double ssstore = 0.0;
    private double lat_tp = 0.409;
    private double dr = 173.0;
    private double dy = 365.25;
    private double Sol = 1.37;
    private int dUTC;
    private boolean permiso = false;
    public boolean onlysel = false;
    private int uutc;
    private int mmonth;
    private int dday;
    double t_coneff;
    double t_zonal;
    double t_h;
    double t_r;
    double t_sup;
    double t_pveff;
    double t_lat;
    double t_long;
    double t_CHPcoef;
    double decsol;
    double tPn;
    String nom_eot = "";
    String t_type = "";
    String t_wzone;
    String t_inv_type = "";
    GeneratorEO dgEO;
    GeneratorPV dgPV;
    GeneratorDG dgDG;
    double pm_load = 0.0;
    String tday = "";
    String tdayTd = "";
    String nom_db;
    String cluster_load = "";

    DLFDG(DeepEdit deep, Schematic sch) {
        super(sch);
        this.deepEdApp = deep;
        this.SubNetwork = new Vector();
        this.zcon = new double[this.ntimes];
        this.zbal = new double[this.ntimes];
        this.zgendg = new double[this.ntimes];
        this.zeo = new double[this.ntimes];
        this.zchp = new double[this.ntimes];
        this.zpv = new double[this.ntimes];
        this.zpsh = new double[this.ntimes];
        this.zdg = new double[this.ntimes];
        this.zstore = new double[this.ntimes];
        this.dc1 = new double[this.ntimes];
        this.dc2 = new double[this.ntimes];
        this.dc3 = new double[this.ntimes];
        this.Zlocal = new double[this.ntimes];
        this.Zutc = new double[this.ntimes];
        this.tv = new double[6];
        this.tF = new double[10];
        this.dspeed = new double[this.ntimes];
        this.dtemp = new double[this.ntimes];
        this.t_dspeed = new double[this.ntimes];
        this.t_cch = new double[this.ntimes];
        this.t_ccm = new double[this.ntimes];
        this.t_ccl = new double[this.ntimes];
        this.sinphi = new double[this.ntimes];
        this.t_trans = new double[this.ntimes];
        this.t_rad = new double[this.ntimes];
        this.zapEO = new double[this.ntimes];
        this.zapPV = new double[this.ntimes];
        this.zapDG = new double[this.ntimes];
        System.out.println("---------- In  D L F D G  Calculation Tool ----------");
        if (this.MyDLFDGFrame == null) {
            this.MyDLFDGFrame = new DLFDGFrame(this.deepEdApp, this);
        } else {
            this.MyDLFDGFrame.setVisible(true);
        }
    }

    public void Calculate(String nomTran, int utc, int month, int day, boolean primary, boolean showgraf, boolean showtext, boolean savedb, int ssimperiod) throws Exception {
        int ix;
        this.uutc = utc;
        this.mmonth = month;
        this.dday = day;
        this.n_bus = 0;
        this.n_gen = 0;
        this.n_load = 0;
        this.n_loadCHP = 0;
        this.nlfix = 0;
        this.n_tran = 0;
        this.n_line = 0;
        this.n_genDG = 0;
        this.n_genPV = 0;
        this.n_genEO = 0;
        this.n_genCHP = 0;
        this.n_subred = 0;
        this.n_tot = 0;
        this.n_DGs = 0;
        this.n_porcent = 0;
        this.sbal = 0.0;
        this.scon = 0.0;
        this.sgendg = 0.0;
        this.seo = 0.0;
        this.schp = 0.0;
        this.spv = 0.0;
        this.spsh = 0.0;
        this.sdg = 0.0;
        this.sstore = 0.0;
        this.pmc1 = 0.001;
        this.pmc2 = 0.001;
        this.pmc3 = 0.001;
        for (ix = 0; ix < this.ntimes; ++ix) {
            this.dspeed[ix] = 0.0;
            this.dtemp[ix] = 0.0;
            this.t_dspeed[ix] = 0.0;
            this.sinphi[ix] = 0.0;
            this.t_trans[ix] = 0.0;
            this.t_rad[ix] = 0.0;
            this.zcon[ix] = 0.0;
            this.zbal[ix] = 0.0;
            this.zgendg[ix] = 0.0;
            this.zeo[ix] = 0.0;
            this.zchp[ix] = 0.0;
            this.zpv[ix] = 0.0;
            this.zpsh[ix] = 0.0;
            this.zdg[ix] = 0.0;
            this.zstore[ix] = 0.0;
            this.zapEO[ix] = 0.0;
            this.zapPV[ix] = 0.0;
            this.zapDG[ix] = 0.0;
            this.Zutc[ix] = 0.0;
            this.Zlocal[ix] = 24.0 / (double)this.ntimes * (double)(ix + 1);
        }
        this.simperiod = ssimperiod > this.ntimes ? this.ntimes : (ssimperiod < 0 ? 0 : ssimperiod);
        this.SubNetwork.removeAllElements();
        try {
            this.AssignNetwork(nomTran, primary);
            DeepEdit.MySchematicPanel.repaint();
            this.LoadProfiles(month, day);
            this.PeakShavingModeBehaviour(utc, month, day);
            this.ElectricityOnlyModeBehaviour(utc, month, day);
            this.CHPModeBehaviour(utc, month, day);
            for (ix = 0; ix < this.ntimes; ++ix) {
                this.zgendg[ix] = this.zeo[ix] + this.zpv[ix] + this.zchp[ix] + this.zdg[ix] + this.zpsh[ix];
                this.zbal[ix] = this.zcon[ix] - this.zgendg[ix];
                this.zstore[ix] = 0.0;
                this.sbal += this.zbal[ix];
                this.scon += this.zcon[ix];
                this.sgendg += this.zgendg[ix];
                this.seo += this.zeo[ix];
                this.schp += this.zchp[ix];
                this.spv += this.zpv[ix];
                this.sdg += this.zdg[ix];
                this.spsh += this.zpsh[ix];
                this.sstore += this.zstore[ix];
            }
            this.permiso = true;
            if (showtext) {
                this.ShowTextResult();
            }
            if (savedb) {
                this.SaveInDataBase();
            }
            if (showgraf) {
                this.ShowGraf();
            }
            System.out.println("Algorithm has finished correctly.");
        }
        catch (Exception e) {
            this.message = e.toString();
            String[] DlgButtons = new String[]{"OK"};
            SimpleDialog ExceptionDialog = new SimpleDialog(DeepEdit.frame, "DLFDG", this.message, DlgButtons, 1, 0, 0, 1);
            e.printStackTrace();
            return;
        }
    }

    public void AssignNetwork(String nomTran, boolean primary) {
        int ix;
        comp TempComponent = null;
        this.nomT = nomTran;
        for (ix = 0; ix < this.ActSchematic.Components.size(); ++ix) {
            TempComponent = (comp)this.ActSchematic.Components.elementAt(ix);
            if (!(TempComponent instanceof ndb_comp)) continue;
            ++this.n_tot;
        }
        for (ix = 0; !(ix >= this.ActSchematic.Components.size() || (TempComponent = (comp)this.ActSchematic.Components.elementAt(ix)).getactive() && TempComponent.getvalid() && TempComponent.getinservice() && TempComponent instanceof Trafo && TempComponent.getName().equals(nomTran)); ++ix) {
        }
        if (this.onlysel) {
            for (ix = 0; ix < this.ActSchematic.Components.size(); ++ix) {
                TempComponent = (comp)this.ActSchematic.Components.elementAt(ix);
                if (!TempComponent.isSelected()) continue;
                this.SubNetwork.addElement(TempComponent);
                ++this.n_subred;
                if (TempComponent instanceof Busbar) {
                    ++this.n_bus;
                }
                if (TempComponent instanceof ndb_inj) {
                    ++this.n_gen;
                    if (TempComponent instanceof GeneratorDG) {
                        ++this.n_genDG;
                        ++this.n_DGs;
                    }
                    if (TempComponent instanceof GeneratorPV) {
                        ++this.n_genPV;
                        ++this.n_DGs;
                    }
                    if (TempComponent instanceof GeneratorEO) {
                        ++this.n_genEO;
                        ++this.n_DGs;
                    }
                    if (TempComponent instanceof GeneratorCHP) {
                        ++this.n_genCHP;
                        ++this.n_DGs;
                    }
                }
                if (TempComponent instanceof Load) {
                    ++this.n_load;
                    Load TempLoad = (Load)TempComponent;
                    if (TempLoad.getinv_type().startsWith("CHP")) {
                        ++this.n_loadCHP;
                    }
                }
                if (TempComponent instanceof Line) {
                    ++this.n_line;
                }
                if (!(TempComponent instanceof Trafo)) continue;
                ++this.n_tran;
            }
        } else if (TempComponent != null) {
            TempComponent.InformAllComponents();
            if (primary) {
                this.ExploreNetwork(TempComponent.getcon1());
                this.nomB = TempComponent.getcon1();
            } else {
                this.ExploreNetwork(TempComponent.getcon2());
                this.nomB = TempComponent.getcon1();
            }
        } else {
            System.out.println("Error: Selected Transformer is not valid !!!");
        }
    }

    public void ExploreNetwork(String nombus) {
        for (int ix = 0; ix < this.ActSchematic.Components.size(); ++ix) {
            Trafo thisT;
            comp TempComponent = (comp)this.ActSchematic.Components.elementAt(ix);
            if (TempComponent instanceof Busbar && !TempComponent.isSelected()) {
                if (!TempComponent.getName().equals(nombus)) continue;
                this.SubNetwork.addElement(TempComponent);
                ++this.n_bus;
                ++this.n_subred;
                TempComponent.setSelected(true);
                continue;
            }
            if (TempComponent instanceof ndb_1pol && !TempComponent.isSelected()) {
                if (!TempComponent.getactive() || !TempComponent.getvalid() || !TempComponent.getinservice()) continue;
                TempComponent.InformAllComponents();
                if (!TempComponent.getcon2().equals(nombus)) continue;
                this.SubNetwork.addElement(TempComponent);
                ++this.n_subred;
                TempComponent.setSelected(true);
                if (TempComponent instanceof ndb_inj) {
                    ++this.n_gen;
                    if (TempComponent instanceof GeneratorDG) {
                        ++this.n_genDG;
                        ++this.n_DGs;
                    }
                    if (TempComponent instanceof GeneratorPV) {
                        ++this.n_genPV;
                        ++this.n_DGs;
                    }
                    if (TempComponent instanceof GeneratorEO) {
                        ++this.n_genEO;
                        ++this.n_DGs;
                    }
                    if (TempComponent instanceof GeneratorCHP) {
                        ++this.n_genCHP;
                        ++this.n_DGs;
                    }
                }
                if (!(TempComponent instanceof Load)) continue;
                ++this.n_load;
                Load TempLoad = (Load)TempComponent;
                if (!TempLoad.getinv_type().startsWith("CHP")) continue;
                ++this.n_loadCHP;
                continue;
            }
            if (!(TempComponent instanceof ndb_2pol) || TempComponent.isSelected() || !(TempComponent instanceof ndb_branch) || !TempComponent.getactive() || !TempComponent.getvalid() || !TempComponent.getinservice()) continue;
            if (TempComponent instanceof Line) {
                Line TempLine = (Line)TempComponent;
                TempLine.InformPartner(TempLine.ConnComps1, TempLine.getx1(), TempLine.gety1(), 1);
                TempLine.InformPartner(TempLine.ConnComps2, TempLine.getx2(), TempLine.gety2(), 2);
                if (TempLine.getcon2().equals(nombus)) {
                    this.SubNetwork.addElement(TempComponent);
                    TempLine.setSelected(true);
                    ++this.n_subred;
                    ++this.n_line;
                    TempLine.ChangingWire = 3;
                    this.ExploreNetwork(TempComponent.getcon1());
                    continue;
                }
                if (!TempLine.getcon1().equals(nombus)) continue;
                this.SubNetwork.addElement(TempComponent);
                TempLine.setSelected(true);
                ++this.n_subred;
                ++this.n_line;
                TempLine.ChangingWire = 3;
                this.ExploreNetwork(TempComponent.getcon2());
                continue;
            }
            if (!(TempComponent instanceof Trafo) || (thisT = (Trafo)TempComponent).getctrla().equals("Arrow.1") || thisT.getctrla().equals("Arrow.2")) continue;
            TempComponent.InformAllComponents();
            if (TempComponent.getcon2().equals(nombus)) {
                this.SubNetwork.addElement(TempComponent);
                TempComponent.setSelected(true);
                ++this.n_subred;
                ++this.n_tran;
                this.ExploreNetwork(TempComponent.getcon1());
                continue;
            }
            if (!TempComponent.getcon1().equals(nombus)) continue;
            this.SubNetwork.addElement(TempComponent);
            TempComponent.setSelected(true);
            ++this.n_subred;
            ++this.n_tran;
            this.ExploreNetwork(TempComponent.getcon2());
        }
    }

    public void LoadProfiles(int month, int day) {
        double qfac = 0.484322;
        try {
            int iz;
            Load TempLoad;
            int ix;
            this.DBDalfo = DeepEdit.OpenODBC_JDBCConnection(this.db_cluster, true);
            this.stmt = this.DBDalfo.createStatement();
            this.query = "SELECT * FROM DAYS";
            this.rs = this.stmt.executeQuery(this.query);
            while (this.rs.next()) {
                if (day + 1 != this.rs.getInt("day") || month + 1 != this.rs.getInt("month")) continue;
                this.tday = this.rs.getString("Td");
                this.n_d = this.rs.getInt("d");
            }
            this.query = "SELECT * FROM C_" + this.tday;
            this.rs = this.stmt.executeQuery(this.query);
            int id = 0;
            while (this.rs.next()) {
                this.dc1[id] = this.rs.getDouble("C1");
                this.dc2[id] = this.rs.getDouble("C2");
                this.dc3[id] = this.rs.getDouble("C3");
                if (++id != this.ntimes) continue;
            }
            this.query = "SELECT * FROM PMC";
            this.rs = this.stmt.executeQuery(this.query);
            while (this.rs.next()) {
                this.tdayTd = this.rs.getString("Td");
                if (!this.tdayTd.equals(this.tday)) continue;
                this.pmc1 = this.rs.getDouble("C1");
                this.pmc2 = this.rs.getDouble("C2");
                this.pmc3 = this.rs.getDouble("C3");
            }
            this.name_load = new Vector();
            int nl = 0;
            for (ix = 0; ix < this.SubNetwork.size(); ++ix) {
                comp TempComponent = (comp)this.SubNetwork.elementAt(ix);
                if (!(TempComponent instanceof Load)) continue;
                TempComponent.auxs = "Deterministic";
                this.name_load.addElement(TempComponent);
                if (++nl == this.n_load) break;
            }
            this.query = "SELECT * FROM Loads";
            this.rs = this.stmt.executeQuery(this.query);
            while (this.rs.next()) {
                this.nom_db = this.rs.getString("Muestra");
                for (ix = 0; ix < this.n_load; ++ix) {
                    TempLoad = (Load)this.name_load.elementAt(ix);
                    if (!this.nom_db.equals(TempLoad.getName())) continue;
                    TempLoad.auxs = "Profile";
                    this.cluster_load = this.rs.getString(this.tday);
                    this.pm_load = this.rs.getDouble("Pm" + this.tday);
                    TempLoad.setgrate(0.0);
                    if (this.cluster_load.equals("C1")) {
                        for (iz = 0; iz < this.ntimes; ++iz) {
                            if (this.simperiod - 1 == iz) {
                                TempLoad.setpini(this.pm_load * this.dc1[iz] / this.pmc1 / 1000.0);
                                TempLoad.setp(this.pm_load * this.dc1[iz] / this.pmc1 / 1000.0);
                                TempLoad.setp0(this.pm_load * this.dc1[iz] / this.pmc1 / 1000.0);
                                TempLoad.setqini(this.pm_load * this.dc1[iz] / this.pmc1 / 1000.0 * qfac);
                                TempLoad.setq(this.pm_load * this.dc1[iz] / this.pmc1 / 1000.0 * qfac);
                                TempLoad.setq0(this.pm_load * this.dc1[iz] / this.pmc1 / 1000.0 * qfac);
                            }
                            int n = iz;
                            this.zcon[n] = this.zcon[n] + this.pm_load * this.dc1[iz] / this.pmc1;
                        }
                    }
                    if (this.cluster_load.equals("C2")) {
                        for (iz = 0; iz < this.ntimes; ++iz) {
                            if (this.simperiod - 1 == iz) {
                                TempLoad.setpini(this.pm_load * this.dc2[iz] / this.pmc2 / 1000.0);
                                TempLoad.setp(this.pm_load * this.dc2[iz] / this.pmc2 / 1000.0);
                                TempLoad.setp0(this.pm_load * this.dc2[iz] / this.pmc2 / 1000.0);
                                TempLoad.setqini(this.pm_load * this.dc2[iz] / this.pmc2 / 1000.0 * qfac);
                                TempLoad.setq(this.pm_load * this.dc2[iz] / this.pmc2 / 1000.0 * qfac);
                                TempLoad.setq0(this.pm_load * this.dc2[iz] / this.pmc2 / 1000.0 * qfac);
                            }
                            int n = iz;
                            this.zcon[n] = this.zcon[n] + this.pm_load * this.dc2[iz] / this.pmc2;
                        }
                    }
                    if (!this.cluster_load.equals("C3")) continue;
                    for (iz = 0; iz < this.ntimes; ++iz) {
                        if (this.simperiod - 1 == iz) {
                            TempLoad.setpini(this.pm_load * this.dc3[iz] / this.pmc3 / 1000.0);
                            TempLoad.setp(this.pm_load * this.dc3[iz] / this.pmc3 / 1000.0);
                            TempLoad.setp0(this.pm_load * this.dc3[iz] / this.pmc3 / 1000.0);
                            TempLoad.setqini(this.pm_load * this.dc3[iz] / this.pmc3 / 1000.0 * qfac);
                            TempLoad.setq(this.pm_load * this.dc3[iz] / this.pmc3 / 1000.0 * qfac);
                            TempLoad.setq0(this.pm_load * this.dc3[iz] / this.pmc3 / 1000.0 * qfac);
                        }
                        int n = iz;
                        this.zcon[n] = this.zcon[n] + this.pm_load * this.dc3[iz] / this.pmc3;
                    }
                }
            }
            this.nlfix = 0;
            for (ix = 0; ix < this.n_load; ++ix) {
                TempLoad = (Load)this.name_load.elementAt(ix);
                if (!TempLoad.auxs.equals("Deterministic")) continue;
                ++this.nlfix;
                iz = 0;
                while (iz < this.ntimes) {
                    int n = iz++;
                    this.zcon[n] = this.zcon[n] + TempLoad.getp() * 1000.0;
                }
            }
            this.DBDalfo.rollback();
            this.rs.close();
            this.stmt.close();
            this.DBDalfo.close();
        }
        catch (Exception e) {
            System.out.println(e);
            System.out.println("@ Exception in DLFDG-LoadProfiles");
            e.printStackTrace();
            try {
                this.DBDalfo.close();
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
    }

    public void ElectricityOnlyModeBehaviour(int utc, int month, int day) {
        int ix;
        boolean valida = false;
        int id = 0;
        this.dUTC = utc;
        for (ix = 0; ix < this.ntimes; ++ix) {
            this.Zutc[ix] = this.Zlocal[ix] + (double)this.dUTC;
        }
        for (ix = 0; ix < 6; ++ix) {
            this.tv[ix] = 0.0;
        }
        for (ix = 0; ix < 10; ++ix) {
            this.tF[ix] = 0.0;
        }
        try {
            int iz;
            comp TempComponent;
            this.DB_DG = DeepEdit.OpenODBC_JDBCConnection(this.db_dg, true);
            this.stmt_dg = this.DB_DG.createStatement();
            this.DB_Weather = DeepEdit.OpenODBC_JDBCConnection(this.db_weather, true);
            this.stmt_weather = this.DB_Weather.createStatement();
            this.query_weather = "SELECT * FROM Wind";
            this.rs_weather = this.stmt_weather.executeQuery(this.query_weather);
            id = 0;
            while (this.rs_weather.next()) {
                this.dspeed[id] = this.rs_weather.getDouble("vel@10mts");
                if (++id != this.ntimes) continue;
            }
            this.rs_weather.close();
            this.query_weather = "SELECT * FROM Clouds";
            this.rs_weather = this.stmt_weather.executeQuery(this.query_weather);
            id = 0;
            while (this.rs_weather.next()) {
                this.t_cch[id] = this.rs_weather.getDouble("cch");
                this.t_ccm[id] = this.rs_weather.getDouble("ccm");
                this.t_ccl[id] = this.rs_weather.getDouble("ccl");
                if (++id != this.ntimes) continue;
            }
            this.rs_weather.close();
            for (ix = 0; ix < this.SubNetwork.size(); ++ix) {
                TempComponent = (comp)this.SubNetwork.elementAt(ix);
                if (!(TempComponent instanceof GeneratorEO)) continue;
                TempComponent.InformAllComponents();
                this.dgEO = (GeneratorEO)TempComponent;
                this.t_zonal = this.dgEO.getzonalfactor();
                this.t_coneff = this.dgEO.getconeff();
                this.t_type = this.dgEO.geteotype();
                this.t_h = this.dgEO.geteoheight();
                this.t_r = this.dgEO.getrough();
                this.t_wzone = this.dgEO.getwzone();
                this.query_weather = "SELECT * FROM Wind";
                this.rs_weather = this.stmt_weather.executeQuery(this.query_weather);
                id = 0;
                while (this.rs_weather.next()) {
                    this.dspeed[id] = this.rs_weather.getDouble("vel@" + this.t_wzone);
                    if (++id != this.ntimes) continue;
                }
                this.rs_weather.close();
                for (iz = 0; iz < this.ntimes; ++iz) {
                    this.t_dspeed[iz] = this.dspeed[iz] * (Math.log(this.t_h / this.t_r) / Math.log(10.0 / this.t_r));
                }
                this.query_dg = "SELECT * FROM TypesEO";
                this.rs_dg = this.stmt_dg.executeQuery(this.query_dg);
                while (this.rs_dg.next()) {
                    this.nom_eot = this.rs_dg.getString("modelo");
                    if (!this.nom_eot.equals(this.t_type)) continue;
                    this.tPn = this.rs_dg.getDouble("Pn");
                    this.tv[0] = this.rs_dg.getDouble("v0");
                    this.tv[1] = this.rs_dg.getDouble("v1");
                    this.tv[2] = this.rs_dg.getDouble("v2");
                    this.tv[3] = this.rs_dg.getDouble("v3");
                    this.tv[4] = this.rs_dg.getDouble("v4");
                    this.tv[5] = this.rs_dg.getDouble("v5");
                    this.tF[0] = this.rs_dg.getDouble("F0");
                    this.tF[1] = this.rs_dg.getDouble("F1");
                    this.tF[2] = this.rs_dg.getDouble("F2");
                    this.tF[3] = this.rs_dg.getDouble("F3");
                    this.tF[4] = this.rs_dg.getDouble("F4");
                    this.tF[5] = this.rs_dg.getDouble("F5");
                    this.tF[6] = this.rs_dg.getDouble("F6");
                    this.tF[7] = this.rs_dg.getDouble("F7");
                    this.tF[8] = this.rs_dg.getDouble("F8");
                    this.tF[9] = this.rs_dg.getDouble("F9");
                }
                for (iz = 0; iz < this.ntimes; ++iz) {
                    this.zapEO[iz] = this.t_dspeed[iz] < this.tv[0] ? 0.0 : (this.t_dspeed[iz] < this.tv[1] ? this.tF[0] * this.t_dspeed[iz] + this.tF[1] : (this.t_dspeed[iz] < this.tv[2] ? this.tF[2] * this.t_dspeed[iz] + this.tF[3] : (this.t_dspeed[iz] < this.tv[3] ? this.tF[4] * this.t_dspeed[iz] + this.tF[5] : (this.t_dspeed[iz] < this.tv[4] ? this.tF[6] * this.t_dspeed[iz] + this.tF[7] : (this.t_dspeed[iz] < this.tv[5] ? this.tF[8] * this.t_dspeed[iz] + this.tF[9] : 0.0)))));
                }
                for (iz = 0; iz < this.ntimes; ++iz) {
                    if (this.simperiod - 1 == iz) {
                        this.dgEO.setp0(this.zapEO[iz] * this.t_coneff / 100.0 * this.t_zonal / 1000.0);
                        this.dgEO.setp(this.zapEO[iz] * this.t_coneff / 100.0 * this.t_zonal / 1000.0);
                    }
                    this.zeo[iz] = this.zeo[iz] + this.zapEO[iz] * this.t_coneff / 100.0 * this.t_zonal;
                }
            }
            this.rs_dg.close();
            this.stmt_dg.close();
            this.DB_DG.rollback();
            this.DB_DG.close();
            this.decsol = this.lat_tp * Math.cos(Math.PI * 2 * ((double)this.n_d - this.dr) / this.dy);
            for (ix = 0; ix < this.SubNetwork.size(); ++ix) {
                TempComponent = (comp)this.SubNetwork.elementAt(ix);
                if (!(TempComponent instanceof GeneratorPV)) continue;
                TempComponent.InformAllComponents();
                this.dgPV = (GeneratorPV)TempComponent;
                this.t_zonal = this.dgPV.getzonalfactor();
                this.t_coneff = this.dgPV.getconeff();
                this.t_sup = this.dgPV.geteqsurface();
                this.t_pveff = this.dgPV.getpveff();
                this.t_lat = this.dgPV.getlatitude();
                this.t_long = this.dgPV.getlongitude();
                this.t_wzone = this.dgPV.getwzone();
                this.query_weather = "SELECT * FROM Clouds";
                this.rs_weather = this.stmt_weather.executeQuery(this.query_weather);
                id = 0;
                while (this.rs_weather.next()) {
                    this.t_cch[id] = this.rs_weather.getDouble("cch@" + this.t_wzone);
                    this.t_ccm[id] = this.rs_weather.getDouble("ccm@" + this.t_wzone);
                    this.t_ccl[id] = this.rs_weather.getDouble("ccl@" + this.t_wzone);
                    if (++id != this.ntimes) continue;
                }
                this.rs_weather.close();
                for (iz = 0; iz < this.ntimes; ++iz) {
                    this.sinphi[iz] = Math.sin(this.t_lat * Math.PI / 180.0) * Math.sin(this.decsol) - Math.cos(this.t_lat * Math.PI / 180.0) * Math.cos(this.decsol) * Math.cos(Math.PI * this.Zutc[iz] / 12.0 - Math.PI * this.t_long / 180.0);
                    this.t_trans[iz] = this.sinphi[iz] < 0.0 ? 0.0 : (0.6 + 0.2 * this.sinphi[iz]) * (1.0 - 0.4 * this.t_cch[iz] / 100.0) * (1.0 - 0.7 * this.t_ccm[iz] / 100.0) * (1.0 - 0.4 * this.t_ccl[iz] / 100.0);
                    this.t_rad[iz] = this.Sol * this.t_trans[iz] * this.sinphi[iz];
                    this.zapPV[iz] = this.t_pveff / 100.0 * this.t_coneff / 100.0 * this.t_sup * this.t_zonal * this.t_rad[iz];
                }
                for (iz = 0; iz < this.ntimes; ++iz) {
                    if (this.simperiod - 1 == iz) {
                        this.dgPV.setp0(this.zapPV[iz] / 1000.0);
                        this.dgPV.setp(this.zapPV[iz] / 1000.0);
                    }
                    this.zpv[iz] = this.zpv[iz] + this.zapPV[iz];
                }
            }
            for (ix = 0; ix < this.SubNetwork.size(); ++ix) {
                TempComponent = (comp)this.SubNetwork.elementAt(ix);
                if (!(TempComponent instanceof GeneratorDG)) continue;
                TempComponent.InformAllComponents();
                this.dgDG = (GeneratorDG)TempComponent;
                this.t_inv_type = this.dgDG.getinv_type();
                valida = true;
                for (int ixx = 0; ixx < this.ActSchematic.Components.size(); ++ixx) {
                    comp TempComponent1 = (comp)this.ActSchematic.Components.elementAt(ix);
                    if (!(TempComponent1 instanceof mdb_wheel)) continue;
                    mdb_wheel TempCont = (mdb_wheel)TempComponent1;
                    this.deepEdApp.SimulateSetUpOnePoint(TempCont.getx1(), TempCont.gety1());
                    this.deepEdApp.SimulateSetUpOnePoint(TempCont.getx2(), TempCont.gety2());
                    TempCont.InformPartner(TempCont.ConnComps1, TempCont.getx1(), TempCont.gety1(), 1);
                    TempCont.InformPartner(TempCont.ConnComps2, TempCont.getx2(), TempCont.gety2(), 2);
                    if (TempCont.getparty1() != TempComponent) continue;
                    valida = false;
                    break;
                }
                if (!valida) continue;
                for (iz = 0; iz < this.ntimes; ++iz) {
                    this.zapDG[iz] = 1000.0 * this.dgDG.getp0();
                    this.dgDG.setp(this.zapDG[iz] / 1000.0);
                    this.zdg[iz] = this.zdg[iz] + this.zapDG[iz];
                }
            }
            this.DB_Weather.rollback();
            this.stmt_weather.close();
            this.DB_Weather.close();
        }
        catch (Exception e) {
            System.out.println(e);
            System.out.println("@ Exception in DLFDG-DGBehaviour");
            try {
                this.DB_Weather.close();
                this.DB_DG.close();
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
    }

    public void CHPModeBehaviour(int utc, int month, int day) {
        double taverage = 0.0;
        double hp = 0.0;
        double h = 0.0;
        double hpd = 0.0;
        double But = 0.0;
        double fv = 0.0;
        double Qn = 0.0;
        double Qd = 0.0;
        double As = 0.0;
        double Bs = 0.0;
        double Cs = 0.0;
        double Ds = 0.0;
        double equiv = 0.0;
        int id = 0;
        try {
            GeneratorCHP TempCHPGen;
            comp TempComponent;
            int ix;
            this.DB_Weather = DeepEdit.OpenODBC_JDBCConnection(this.db_weather, true);
            this.stmt_weather = this.DB_Weather.createStatement();
            this.DB_CHP = DeepEdit.OpenODBC_JDBCConnection(this.db_chp, true);
            this.stmt_chp = this.DB_CHP.createStatement();
            System.out.println("In simulation of the CHP operation mode ");
            for (ix = 0; ix < this.ActSchematic.Components.size(); ++ix) {
                TempComponent = (comp)this.ActSchematic.Components.elementAt(ix);
                if (!(TempComponent instanceof GeneratorCHP)) continue;
                TempCHPGen = (GeneratorCHP)TempComponent;
                TempCHPGen.setp(0.0);
                TempCHPGen.setp0(0.0);
            }
            for (ix = 0; ix < this.ActSchematic.Components.size(); ++ix) {
                TempComponent = (comp)this.ActSchematic.Components.elementAt(ix);
                taverage = 0.0;
                hp = 0.0;
                h = 0.0;
                hpd = 0.0;
                But = 0.0;
                fv = 0.0;
                Qn = 0.0;
                Qd = 0.0;
                As = 0.0;
                Bs = 0.0;
                Cs = 0.0;
                Ds = 0.0;
                equiv = 0.0;
                if (!(TempComponent instanceof mdb_wheel)) continue;
                mdb_wheel TempCont = (mdb_wheel)TempComponent;
                this.deepEdApp.SimulateSetUpOnePoint(TempCont.getx1(), TempCont.gety1());
                this.deepEdApp.SimulateSetUpOnePoint(TempCont.getx2(), TempCont.gety2());
                TempCont.InformPartner(TempCont.ConnComps1, TempCont.getx1(), TempCont.gety1(), 1);
                TempCont.InformPartner(TempCont.ConnComps2, TempCont.getx2(), TempCont.gety2(), 2);
                if (!TempCont.getName().startsWith("CHP") || TempCont.getparty1() == null || TempCont.getparty2() == null) continue;
                System.out.println("Contract Name : " + TempCont.getName());
                if (!TempCont.getparty1().isSelected() || !TempCont.getparty1().getactive() || !TempCont.getparty1().getvalid() || !TempCont.getparty1().getinservice()) continue;
                System.out.println("  -- Generator: " + TempCont.getparty1().getName());
                if (!TempCont.getparty2().getactive() || !TempCont.getparty2().getvalid() || !TempCont.getparty2().getinservice()) continue;
                TempCHPGen = (GeneratorCHP)TempCont.getparty1();
                this.t_coneff = TempCHPGen.getconeff();
                this.t_CHPcoef = TempCHPGen.getCHPcoef();
                System.out.println("     --      t_coneff                     : " + this.t_coneff);
                System.out.println("     --      t_CHPcoef                    : " + this.t_CHPcoef);
                Load TempCHPLoad = (Load)TempCont.getparty2();
                System.out.println("  --      Load: " + TempCont.getparty2().getName());
                this.t_wzone = this.getzone(TempCHPLoad.getlatitude(), TempCHPLoad.getlongitude());
                System.out.println("     --      Load related Weather Service: " + this.t_wzone);
                this.query_weather = "SELECT * FROM Temperature";
                this.rs_weather = this.stmt_weather.executeQuery(this.query_weather);
                id = 0;
                taverage = 0.0;
                while (this.rs_weather.next()) {
                    taverage += this.rs_weather.getDouble("T@" + this.t_wzone);
                    if (++id != this.ntimes) continue;
                }
                this.rs_weather.close();
                System.out.println("     --      Average daily temperature   : " + (taverage /= (double)this.ntimes) + " Cel");
                String mitype = TempCHPLoad.getinv_type().substring(3);
                System.out.println("     --      Load type                   : " + mitype);
                this.query_chp = "SELECT * FROM CHPtype WHERE (type='" + mitype + "') ORDER BY Qny";
                this.rs_chp = this.stmt_chp.executeQuery(this.query_chp);
                int auxyear = 0;
                while (this.rs_chp.next() && (auxyear = this.rs_chp.getInt("Qny")) < TempCHPLoad.getentry_period()) {
                }
                this.rs_chp.close();
                System.out.println("     --      Load year for type           : " + auxyear);
                this.query_chp = "SELECT * FROM CHPtype WHERE (type='" + mitype + "') AND (Qny=" + auxyear + ")";
                this.rs_chp = this.stmt_chp.executeQuery(this.query_chp);
                while (this.rs_chp.next()) {
                    But = this.rs_chp.getDouble("But");
                    Qn = this.rs_chp.getDouble("Qn");
                    As = this.rs_chp.getDouble("A");
                    Bs = this.rs_chp.getDouble("B");
                    Cs = this.rs_chp.getDouble("C");
                    Ds = this.rs_chp.getDouble("D");
                }
                this.rs_chp.close();
                System.out.println("     --      But                          : " + But);
                System.out.println("     --      Qn                           : " + Qn);
                System.out.println("     --      A                            : " + As);
                System.out.println("     --      B                            : " + Bs);
                System.out.println("     --      C                            : " + Cs);
                System.out.println("     --      D                            : " + Ds);
                this.query_chp = "SELECT * FROM CHPlocation WHERE (Zone='" + this.t_wzone + "') ORDER BY hpdy";
                this.rs_chp = this.stmt_chp.executeQuery(this.query_chp);
                auxyear = 0;
                while (this.rs_chp.next() && (auxyear = this.rs_chp.getInt("hpdy")) < TempCHPLoad.getentry_period()) {
                }
                this.rs_chp.close();
                System.out.println("     --      Load year for location       : " + auxyear);
                this.query_chp = "SELECT * FROM CHPlocation WHERE (Zone='" + this.t_wzone + "') AND (hpdy=" + auxyear + ")";
                this.rs_chp = this.stmt_chp.executeQuery(this.query_chp);
                while (this.rs_chp.next()) {
                    hpd = this.rs_chp.getDouble("hpd");
                    fv = this.rs_chp.getDouble("fv");
                }
                this.rs_chp.close();
                System.out.println("     --      hpd                          : " + hpd);
                System.out.println("     --      fv                           : " + fv);
                this.query_chp = "SELECT * FROM CHPequivalent WHERE (name='" + TempCHPLoad.getName() + "')";
                this.rs_chp = this.stmt_chp.executeQuery(this.query_chp);
                if (this.rs_chp.next()) {
                    equiv = this.rs_chp.getDouble("equiv");
                }
                this.rs_chp.close();
                System.out.println("     --      Load equiv. # of units       : " + equiv);
                this.t_coneff = TempCHPGen.getconeff();
                this.t_CHPcoef = TempCHPGen.getCHPcoef();
                System.out.println("     --      t_coneff                     : " + this.t_coneff);
                System.out.println("     --      t_CHPcoef                    : " + this.t_CHPcoef);
                System.out.println("  --      Calculation: ");
                hp = As / (1.0 + Math.pow(Bs / (taverage - 40.0), Cs)) + Ds;
                System.out.println("     --      hp                           : " + hp);
                h = hp / hpd;
                System.out.println("     --      h                            : " + h);
                Qd = h * fv * But * Qn * equiv / 365.0 / 1000.0;
                System.out.println("     --      Qd                           : " + Qd + " [kWh/day]");
                System.out.println("  --      Assign Profile: ");
                this.query_chp = "SELECT * FROM CHPprofile WHERE (type='" + mitype + "') ORDER BY year";
                this.rs_chp = this.stmt_chp.executeQuery(this.query_chp);
                auxyear = 0;
                while (this.rs_chp.next() && (auxyear = this.rs_chp.getInt("year")) < TempCHPLoad.getentry_period()) {
                }
                this.rs_chp.close();
                System.out.println("     --      Load year for type          : " + auxyear);
                this.query_chp = "SELECT * FROM CHPprofile WHERE (type='" + mitype + "') AND (year=" + auxyear + ") ORDER BY temperature";
                this.rs_chp = this.stmt_chp.executeQuery(this.query_chp);
                double auxtemp = 0.0;
                while (this.rs_chp.next() && !((auxtemp = this.rs_chp.getDouble("temperature")) >= taverage)) {
                }
                this.rs_chp.close();
                System.out.println("     --      temp. for type and year     : " + auxtemp);
                double auxf = 0.0;
                this.query_chp = "SELECT * FROM CHPprofile WHERE (type='" + mitype + "') AND (year=" + auxyear + ") AND (temperature=" + auxtemp + ")";
                this.rs_chp = this.stmt_chp.executeQuery(this.query_chp);
                while (this.rs_chp.next()) {
                    for (int iz = 0; iz < this.ntimes; ++iz) {
                        auxf = Qd * this.t_coneff / 100.0 * this.t_CHPcoef / 100.0 * 4.0 * this.rs_chp.getDouble("p" + (iz + 1)) / 100.0;
                        int n = iz;
                        this.zchp[n] = this.zchp[n] + auxf;
                        if (this.simperiod - 1 != iz) continue;
                        TempCHPGen.setp0(auxf / 1000.0 + TempCHPGen.getp0());
                        TempCHPGen.setp(TempCHPGen.getp0());
                    }
                }
                this.rs_chp.close();
                System.out.println("Finish with CHPagreement: " + TempCont.getName());
            }
            this.stmt_weather.close();
            this.stmt_chp.close();
            this.DB_Weather.rollback();
            this.DB_CHP.rollback();
            this.DB_Weather.close();
            this.DB_CHP.close();
        }
        catch (Exception e) {
            System.out.println(e);
            System.out.println("@ Exception in DLFDG-CHPModeBehaviour");
            try {
                this.DB_Weather.close();
                this.DB_CHP.close();
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
    }

    public String getzone(double lat0, double long0) throws SQLException {
        double lat1 = 0.0;
        double long1 = 0.0;
        double distance = 1.0E8;
        String mizone = "Zone0";
        String auxzone = "";
        this.query_weather = "SELECT * FROM Zone";
        this.rs_weather = this.stmt_weather.executeQuery(this.query_weather);
        while (this.rs_weather.next()) {
            lat1 = this.rs_weather.getDouble("latitude");
            long1 = this.rs_weather.getDouble("longitude");
            auxzone = this.rs_weather.getString("Zone");
            if (!(this.Distance(lat0, lat1, long0, long1) <= distance)) continue;
            mizone = auxzone;
            distance = this.Distance(lat0, lat1, long0, long1);
        }
        this.rs_weather.close();
        return mizone;
    }

    public double Distance(double L1, double L2, double G1, double G2) {
        double raux = 0.017453292522222223;
        double DG = G2 - G1;
        double D = 111.12 * Math.acos(Math.sin(L1 * raux) * Math.sin(L2 * raux) + Math.cos(L1 * raux) * Math.cos(L2 * raux) * Math.cos(DG * raux)) * 180.0 / 3.141592654;
        return D;
    }

    public void PeakShavingModeBehaviour(int utc, int month, int day) {
        double peak = 0.0;
        boolean id = false;
        try {
            System.out.println("In simulation of the Peak Shaving operation mode ");
            this.DBDalfo = DeepEdit.OpenODBC_JDBCConnection(this.db_cluster, true);
            this.stmt = this.DBDalfo.createStatement();
            for (int ixx = 0; ixx < this.ActSchematic.Components.size(); ++ixx) {
                comp TempComponent = (comp)this.ActSchematic.Components.elementAt(ixx);
                peak = 0.0;
                if (!(TempComponent instanceof mdb_wheel)) continue;
                mdb_wheel TempCont = (mdb_wheel)TempComponent;
                this.deepEdApp.SimulateSetUpOnePoint(TempCont.getx1(), TempCont.gety1());
                this.deepEdApp.SimulateSetUpOnePoint(TempCont.getx2(), TempCont.gety2());
                TempCont.InformPartner(TempCont.ConnComps1, TempCont.getx1(), TempCont.gety1(), 1);
                TempCont.InformPartner(TempCont.ConnComps2, TempCont.getx2(), TempCont.gety2(), 2);
                if (!TempCont.getName().startsWith("PSh") || TempCont.getparty1() == null || TempCont.getparty2() == null) continue;
                System.out.println("Contract Name : " + TempCont.getName());
                if (!TempCont.getparty1().isSelected() || !TempCont.getparty1().getactive() || !TempCont.getparty1().getvalid() || !TempCont.getparty1().getinservice()) continue;
                System.out.println("  -- Generator: " + TempCont.getparty1().getName());
                if (!TempCont.getparty2().getactive() || !TempCont.getparty2().getvalid() || !TempCont.getparty2().getinservice()) continue;
                GeneratorDG TempPShGen = (GeneratorDG)TempCont.getparty1();
                peak = 1000.0 * TempCont.getpmax();
                System.out.println("     --      Peak demand (kW)               : " + peak);
                Load TempPShLoad = (Load)TempCont.getparty2();
                System.out.println("  --      Load: " + TempCont.getparty2().getName());
                this.query = "SELECT * FROM Loads";
                this.rs = this.stmt.executeQuery(this.query);
                while (this.rs.next()) {
                    int iz;
                    this.nom_db = this.rs.getString("Muestra");
                    if (!this.nom_db.equals(TempPShLoad.getName())) continue;
                    this.cluster_load = this.rs.getString(this.tday);
                    this.pm_load = this.rs.getDouble("Pm" + this.tday);
                    if (this.cluster_load.equals("C1")) {
                        for (iz = 0; iz < this.ntimes; ++iz) {
                            if (!(this.pm_load * this.dc1[iz] / this.pmc1 > peak)) continue;
                            int n = iz;
                            this.zpsh[n] = this.zpsh[n] + (this.pm_load * this.dc1[iz] / this.pmc1 - peak);
                            if (this.simperiod - 1 != iz) continue;
                            TempPShGen.setp((this.pm_load * this.dc1[iz] / this.pmc1 - peak) / 1000.0);
                            TempPShGen.setp0(TempPShGen.getp());
                        }
                    }
                    if (this.cluster_load.equals("C2")) {
                        for (iz = 0; iz < this.ntimes; ++iz) {
                            if (!(this.pm_load * this.dc2[iz] / this.pmc2 > peak)) continue;
                            int n = iz;
                            this.zpsh[n] = this.zpsh[n] + (this.pm_load * this.dc2[iz] / this.pmc2 - peak);
                            if (this.simperiod - 1 != iz) continue;
                            TempPShGen.setp((this.pm_load * this.dc2[iz] / this.pmc2 - peak) / 1000.0);
                            TempPShGen.setp0(TempPShGen.getp());
                        }
                    }
                    if (!this.cluster_load.equals("C3")) continue;
                    for (iz = 0; iz < this.ntimes; ++iz) {
                        if (!(this.pm_load * this.dc3[iz] / this.pmc3 > peak)) continue;
                        int n = iz;
                        this.zpsh[n] = this.zpsh[n] + (this.pm_load * this.dc3[iz] / this.pmc3 - peak);
                        if (this.simperiod - 1 != iz) continue;
                        TempPShGen.setp((this.pm_load * this.dc3[iz] / this.pmc3 - peak) / 1000.0);
                        TempPShGen.setp0(TempPShGen.getp());
                    }
                }
                this.rs.close();
            }
            this.stmt.close();
            this.DBDalfo.rollback();
            this.DBDalfo.close();
        }
        catch (Exception e) {
            System.out.println(e);
            System.out.println("@ Exception in Peak Shaving Operation Mode");
            e.printStackTrace();
            try {
                this.DBDalfo.close();
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
    }

    public void SaveInDataBase() {
        if (!this.permiso) {
            return;
        }
        try {
            int iz;
            this.DB_Save = DeepEdit.OpenODBC_JDBCConnection(this.db_save, true);
            this.stmt_save = this.DB_Save.createStatement();
            for (iz = 0; iz < this.ntimes; ++iz) {
                this.query_save = "DELETE * FROM Statistic";
                this.stmt_save.executeUpdate(this.query_save);
            }
            for (iz = 0; iz < this.ntimes; ++iz) {
                this.query = "INSERT INTO Statistic (id,Consumo,Balance,GenDGs,GenEO,GenCHP,GenPV,GenPSh,GenDG) VALUES (" + (iz + 1) + "," + DLFDG.numformat(this.zcon[iz], 12, 2) + "," + DLFDG.numformat(this.zbal[iz], 12, 2) + "," + DLFDG.numformat(this.zgendg[iz], 12, 2) + "," + DLFDG.numformat(this.zeo[iz], 12, 2) + "," + DLFDG.numformat(this.zchp[iz], 12, 2) + "," + DLFDG.numformat(this.zpv[iz], 12, 2) + "," + DLFDG.numformat(this.zpsh[iz], 12, 2) + "," + DLFDG.numformat(this.zdg[iz], 12, 2) + ")";
                this.stmt_save.executeUpdate(this.query_save);
            }
            this.DB_Save.commit();
            this.stmt_save.close();
            this.DB_Save.close();
        }
        catch (Exception e) {
            System.out.println(e);
            System.out.println("@ Exception in DLFDG-SaveInDataBase");
            try {
                this.DB_Save.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void ShowGraf() {
        if (!this.permiso) {
            return;
        }
        this.MyDalfoFrame = new DalfoFrame(this, this.zbal, this.zcon, this.zgendg, this.zeo, this.zchp, this.zpv, this.zdg, this.zpsh);
    }

    public void ToFrame() {
        if (this.MyDLFDGFrame != null) {
            this.MyDLFDGFrame.setVisible(true);
        }
    }

    public void ShowTextResult() {
        if (!this.permiso) {
            return;
        }
        try {
            this.os = new FileOutputStream(this.Archivo);
            this.WriteReport(this.os);
            this.os.close();
            if (this.MyZFileViewer == null) {
                this.MyZFileViewer = new ZFileViewer(DeepEdit.frame, this.Archivo);
                this.MyZFileViewer.setSize(610, 440);
                this.MyZFileViewer.setfont(new Font("Courier", 0, 12));
                this.MyZFileViewer.setVisible(true);
            } else {
                this.MyZFileViewer.openFile(this.Archivo);
            }
            this.MyZFileViewer.setVisible(true);
        }
        catch (Exception e) {
            this.message = e.toString();
            String[] DlgButtons = new String[]{"OK"};
            SimpleDialog ExceptionDialog = new SimpleDialog(DeepEdit.frame, "DLFDG", this.message, DlgButtons, 1, 0, 0, 1);
            return;
        }
    }

    public void WriteReport(FileOutputStream os) {
        if (this.n_tot == 0) {
            return;
        }
        this.n_subred = this.n_bus + this.n_tran + this.n_line + this.n_gen + this.n_load;
        this.n_porcent = 100 * this.n_subred / this.n_tot;
        this.sscon = this.scon * 24.0 / (double)this.ntimes;
        this.ssgendg = this.sgendg * 24.0 / (double)this.ntimes;
        this.sseo = this.seo * 24.0 / (double)this.ntimes;
        this.sschp = this.schp * 24.0 / (double)this.ntimes;
        this.sspv = this.spv * 24.0 / (double)this.ntimes;
        this.sspsh = this.spsh * 24.0 / (double)this.ntimes;
        this.ssdg = this.sdg * 24.0 / (double)this.ntimes;
        this.ssbal = this.sbal * 24.0 / (double)this.ntimes;
        this.ssstore = this.sstore * 24.0 / (double)this.ntimes;
        PrintWriter myPrintStream = new PrintWriter(os, true);
        myPrintStream.println("------------------------------------------------------------------------------------------------------");
        myPrintStream.println("      D A I L Y   L O A D   F O R E C A S T I N G  T O O L");
        myPrintStream.println("              ");
        myPrintStream.println("                          February 2004  ");
        myPrintStream.println("              ");
        myPrintStream.println("       Prof. Dr.-Ing. Rodrigo Palma B., Eduardo Aranda B.               : University of Chile");
        myPrintStream.println("       Prof. Dr.-Ing. Edmund Handschin, Frank Uphaus, Erik Hauptmeier   : University of Dortmund");
        myPrintStream.println("-------------------------------------------------------------------------------------------------------");
        myPrintStream.println("");
        myPrintStream.println("Selected day:");
        myPrintStream.println("  Month                         :" + (this.mmonth + 1));
        myPrintStream.println("  Day in month                  :" + (this.dday + 1));
        myPrintStream.println("  Type of the day               :" + this.tday);
        myPrintStream.println("  Number of the day in the year :" + this.n_d);
        myPrintStream.println("  Selected time period          :" + this.simperiod);
        myPrintStream.println("");
        myPrintStream.println("Network Statistics:");
        myPrintStream.println("----------------------------------------------------------------");
        myPrintStream.println("Selected Transformer is                       : " + this.nomT);
        myPrintStream.println("First Busbar in Sub-Network is                : " + this.nomB);
        myPrintStream.println("Number of Components in the whole network     = " + this.n_tot);
        myPrintStream.println("Number of Components in the whole sub-network = " + this.n_subred + "   = " + this.n_porcent + " %");
        myPrintStream.println("----------------------------------------------------------------");
        myPrintStream.println("");
        myPrintStream.println("Sub-Network Statistic");
        myPrintStream.println("    |-Busbar    = " + this.n_bus);
        myPrintStream.println("    |-Load      = " + this.n_load);
        myPrintStream.println("         |-LoadCHP             = " + this.n_loadCHP);
        myPrintStream.println("         |-Deterministic Loads = " + this.nlfix);
        myPrintStream.println("         |-Load Profiles       = " + (this.n_load - this.nlfix));
        myPrintStream.println("    |-Trafo     = " + this.n_tran);
        myPrintStream.println("    |-Line      = " + this.n_line);
        myPrintStream.println("    |-Generator = " + this.n_gen);
        myPrintStream.println("         |-DGs       = " + this.n_DGs);
        myPrintStream.println("           |-GeneratorEO  = " + this.n_genEO);
        myPrintStream.println("           |-GeneratorPV  = " + this.n_genPV);
        myPrintStream.println("           |-GeneratorCHP = " + this.n_genCHP);
        myPrintStream.println("           |-GeneratorDG  = " + this.n_genDG);
        myPrintStream.println("-------------------------------------");
        myPrintStream.println("ENERGY BALANCES: ");
        myPrintStream.println("GeneratorEO  = " + DLFDG.numformat(this.sseo, 10, 2) + " kWh");
        myPrintStream.println("GeneratorPV  = " + DLFDG.numformat(this.sspv, 10, 2) + " kWh");
        myPrintStream.println("GeneratorPSh = " + DLFDG.numformat(this.sspsh, 10, 2) + " kWh");
        myPrintStream.println("GeneratorCHP = " + DLFDG.numformat(this.sschp, 10, 2) + " kWh");
        myPrintStream.println("GeneratorDG  = " + DLFDG.numformat(this.ssdg, 10, 2) + " kWh");
        myPrintStream.println("-------------------------------------");
        myPrintStream.println("EO+PV+DG+CHP+PSh = " + DLFDG.numformat(this.ssgendg, 10, 2) + " kWh");
        myPrintStream.println("    Demand   = " + DLFDG.numformat(this.sscon, 10, 2) + " kWh  (Consumo sin GD)");
        myPrintStream.println("    Balance  = " + DLFDG.numformat(this.ssbal, 10, 2) + " kWh  (Consumo con GD)");
        myPrintStream.println("    Storage  = " + DLFDG.numformat(this.ssstore, 10, 2) + " kWh (Storable energy)");
        myPrintStream.println("-------------------------------------");
        myPrintStream.println();
        myPrintStream.println(" Subnetwork Statitistic and Profiles:");
        myPrintStream.println("  (values in kW for each 1/4 hour from the day)");
        myPrintStream.println();
        myPrintStream.println("         Load    |    Balance |     GenDGs |      GenEO |     GenCHP |      GenPV |      GenPSh|      GenDG |");
        myPrintStream.println("                 |            |            |            |            |            |            |            |");
        for (int ix = 0; ix < this.ntimes; ++ix) {
            String pn = ix + 1 < 10 ? "P " : "P";
            myPrintStream.println(pn + (ix + 1) + " = " + DLFDG.numformat(this.zcon[ix], 10, 2) + " | " + DLFDG.numformat(this.zbal[ix], 10, 2) + " | " + DLFDG.numformat(this.zgendg[ix], 10, 2) + " | " + DLFDG.numformat(this.zeo[ix], 10, 2) + " | " + DLFDG.numformat(this.zchp[ix], 10, 2) + " | " + DLFDG.numformat(this.zpv[ix], 10, 2) + " | " + DLFDG.numformat(this.zpsh[ix], 10, 2) + " | " + DLFDG.numformat(this.zdg[ix], 10, 2) + " |");
        }
        myPrintStream.println();
        myPrintStream.println("----   E N D   --------------------------------------------------------------------");
    }
}

