/*
 * Decompiled with CFR 0.152.
 */
package de.core;

import VisualNumerics.math.Complex;
import de.core.AnalysisTool;
import de.core.Busbar;
import de.core.DCLFFrame;
import de.core.DeepEdit;
import de.core.Generator;
import de.core.JavaLFException;
import de.core.Line;
import de.core.Load;
import de.core.MMS;
import de.core.Schematic;
import de.core.SimpleDialog;
import de.core.ThreeWindingTrafo;
import de.core.Trafo;
import de.core.YearlyDCLFStatistics;
import de.core.comp;
import de.core.ndb_1pol;
import de.core.ndb_branch;
import de.core.ndb_comp;
import de.core.ndb_inj;
import de.utils.StringUtil;
import drasys.or.linear.algebra.Algebra;
import drasys.or.linear.algebra.CroutPivot;
import drasys.or.matrix.DenseVector;
import drasys.or.matrix.MatrixI;
import drasys.or.matrix.SparseMatrix;
import drasys.or.matrix.VectorI;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.sql.Statement;
import java.util.StringTokenizer;
import java.util.Vector;

public final class DCLF
extends AnalysisTool {
    DCLFFrame MyDCLFFrame = null;
    String errorMsg = null;
    String ctrla = null;
    protected Vector BusbarVector;
    double[] BranchR;
    double[] BranchX;
    double[] BranchB;
    int[] BranchI;
    int[] BranchJ;
    Complex[] ZthreeWinding;
    Complex[] Zreales;
    double[] react;
    double[] resistencias;
    int numbran = 0;
    private double[][] MxInvX;
    private double[] Pinj;
    private double Pslwol;
    private double[] BranchPLoss;
    private int indic_bSL = -1;
    private double angref = 0.0;
    private SparseMatrix B1;
    private SparseMatrix Bbus;
    private SparseMatrix Gbus;
    private Complex[][] Ybus;
    private boolean[][] matCx;
    final double eliminador = 1.0E200;
    private double[] dk;
    private double[] Pk;
    private CroutPivot LU_B1;
    protected DeepEdit deepEdApp;
    public boolean woutlosses = false;
    public boolean halfFDLF = true;
    private DenseVector e = null;
    private DenseVector f = null;
    private Algebra oper;
    PrintStream myPPrintStream;
    FileOutputStream os;
    String[] NomBra;
    double[] Flujos;
    boolean rep = true;
    int nbr;

    DCLF(DeepEdit deepApplet, Schematic sch) {
        super(sch);
        this.deepEdApp = deepApplet;
        System.out.println("---------- DC Load Flow Started ------------");
        if (this.MyDCLFFrame == null) {
            this.MyDCLFFrame = new DCLFFrame(this);
        } else {
            this.MyDCLFFrame.setVisible(true);
        }
    }

    DCLF(Schematic sch, String cctrla) throws JavaLFException {
        super(sch);
        this.woutlosses = true;
        this.halfFDLF = false;
        this.ctrla = cctrla;
        try {
            this.getNetwork();
            this.LU_B1 = new CroutPivot((MatrixI)this.B1);
        }
        catch (Exception ex) {
            String msg = "DCLF error on construction: " + ex;
            this.dcLF_Error(msg);
        }
    }

    DCLF(Schematic sch) throws JavaLFException {
        super(sch);
        this.ctrla = "ALL CONTROL AREAS";
        this.woutlosses = true;
        this.halfFDLF = false;
        try {
            this.getNetwork();
            this.LU_B1 = new CroutPivot((MatrixI)this.B1);
        }
        catch (Exception ex) {
            String msg = "DCLF error on construction: " + ex;
            this.dcLF_Error(msg);
        }
    }

    public void Calculate(String cctrla, boolean reporte) {
        boolean graf = true;
        this.ctrla = cctrla;
        this.rep = reporte;
        String file = "./results/DCLFFlujoRamas.dat";
        this.message = "Some problems, sorry!";
        try {
            this.getNetwork();
            long inicio = System.currentTimeMillis();
            if (this.woutlosses) {
                this.calcular_DCLF();
            } else {
                graf = this.halfFDLF ? this.calcular_PFDLF() : this.calcular_DCLFwCuadLoss();
            }
            System.out.println("\nExec Time= " + (System.currentTimeMillis() - inicio) + "ms.");
            if (graf) {
                this.writeresults();
                this.ActSchematic.Modified = false;
                this.ActSchematic.Modifiedstate = false;
                this.ActSchematic.changeGIS = true;
                DeepEdit.MySchematicPanel.repaint();
            }
        }
        catch (Exception e) {
            this.message = this.errorMsg != null ? this.errorMsg : e.toString();
            e.printStackTrace();
            String[] DlgButtons = new String[]{"OK"};
            SimpleDialog ExceptionDialog = new SimpleDialog(DeepEdit.frame, "DC Load Flow", this.message, DlgButtons, 1, 0, 0, 1);
        }
        if (this.rep) {
            try {
                this.os = new FileOutputStream(file);
                this.myPPrintStream = new PrintStream(this.os);
                this.myPPrintStream.println("Flujo por Ramas");
                this.myPPrintStream.println(" Nombre Rama              Flujo Rama (P) [pu]");
                for (int i = 0; i < this.nbr; ++i) {
                    this.myPPrintStream.println(StringUtil.strformat(this.NomBra[i], 10) + "              " + StringUtil.numformat(this.Flujos[i], 10, 3));
                }
                this.myPPrintStream.println("");
                this.myPPrintStream.println("");
                this.myPPrintStream.println("NOTA: Este reporte ha sido guardado en archivo DCLFFlujoRamas.dat");
                this.myPPrintStream.println("      en directorio de resultados");
                this.closefile();
            }
            catch (Exception e) {
                this.closefile();
            }
            Runtime r = Runtime.getRuntime();
            try {
                r.exec("notepad " + file);
            }
            catch (Exception e) {
                System.out.println(e + ": error al abrir notepad");
            }
        }
        this.finalize();
    }

    private void getNetwork() throws Exception {
        Line TempLine;
        ndb_comp TempNdb_comp;
        comp TempComponent;
        Complex Zrama23;
        Complex complejoX;
        Complex segundiag;
        Complex auxc3;
        int ix = 0;
        int i = 0;
        int j = 0;
        int c = 0;
        int count = 0;
        int countaux = 0;
        int con1 = 10000;
        int con2 = 10000;
        int con3 = 10000;
        int parestrafo = 0;
        int fintrafo = 0;
        this.BusbarVector = new Vector();
        double ueb = 0.0;
        double res = 0.0;
        double z = 0.0;
        double reac = 0.0;
        double y1 = 0.0;
        double y2 = 0.0;
        double b = 0.0;
        double tapdiag1 = 0.0;
        double tapdiag2 = 0.0;
        double tapnodiag = 0.0;
        double Zk12 = 0.0;
        double Zk13 = 0.0;
        double Zk23 = 0.0;
        double tap1 = 1.0;
        double tap2 = 1.0;
        double tap3 = 1.0;
        double divisor = 0.0;
        double ramaX = 0.0;
        double modulo = 0.0;
        double partimag = 0.0;
        double potapa1 = 0.0;
        double potapa2 = 0.0;
        double potapa3 = 0.0;
        Complex factory = auxc3 = new Complex(0.0, 0.0);
        Complex factor = auxc3;
        Complex Afinal = auxc3;
        Complex invertA3 = auxc3;
        Complex A3 = auxc3;
        Complex A2 = auxc3;
        Complex A1 = auxc3;
        Complex ramaY3 = auxc3;
        Complex ramaY2 = auxc3;
        Complex ramaY1 = auxc3;
        Complex ramaY = auxc3;
        Complex primerdiag = segundiag = new Complex(0.0, 0.0);
        Complex invertapnodiag = segundiag;
        Complex invertapdiag2 = segundiag;
        Complex invertapdiag1 = segundiag;
        Complex neutro = complejoX = new Complex(1.0, 0.0);
        Complex Zrama13 = Zrama23 = new Complex(0.0, 0.0);
        Complex Zrama12 = Zrama23;
        this.numbran = 0;
        this.numnod = 0;
        for (ix = 0; ix < this.ActSchematic.Components.size(); ++ix) {
            TempComponent = (comp)this.ActSchematic.Components.elementAt(ix);
            if (!(TempComponent instanceof ndb_comp)) continue;
            TempNdb_comp = (ndb_comp)TempComponent;
            if (!TempComponent.getactive() || !TempComponent.getvalid() || !TempComponent.getinservice() || !TempNdb_comp.getctrla().equals(this.ctrla) && !this.ctrla.equals("ALL CONTROL AREAS")) continue;
            if (TempComponent instanceof Busbar) {
                TempComponent.InformAllComponents();
                Busbar TempBusbar = (Busbar)TempComponent;
                if (this.numbus(TempComponent.getName()) != -1) {
                    this.dcLF_Error("There\u00b4s more than one busbar with name \"" + TempComponent.getName() + "\"");
                }
                this.BusbarVector.addElement(TempComponent);
                ++this.numnod;
                continue;
            }
            if (!(TempComponent instanceof ndb_branch)) continue;
            if (TempComponent instanceof Line) {
                TempLine = (Line)TempComponent;
                TempLine.InformPartner(TempLine.ConnComps1, TempLine.getx1(), TempLine.gety1(), 1);
                TempLine.InformPartner(TempLine.ConnComps2, TempLine.getx2(), TempLine.gety2(), 2);
                ++this.numlin;
            } else if (TempComponent instanceof Trafo) {
                TempComponent.InformAllComponents();
                ++this.numtran;
            } else if (TempComponent instanceof ThreeWindingTrafo) {
                TempComponent.InformAllComponents();
                ++this.numtranthree;
                this.numbran += 2;
            }
            ++this.numbran;
        }
        this.BranchR = new double[this.numbran];
        this.BranchX = new double[this.numbran];
        this.BranchI = new int[this.numbran];
        this.BranchJ = new int[this.numbran];
        this.BranchPLoss = new double[this.numbran];
        this.NomBra = new String[this.numbran];
        this.react = new double[3];
        this.resistencias = new double[3];
        this.ZthreeWinding = new Complex[3];
        this.Zreales = new Complex[3];
        this.nbr = this.numbran;
        this.slack = -1;
        this.ini_var_sist();
        int tipocomp = 0;
        String strcomp = "";
        for (i = 0; i < 3; ++i) {
            this.react[i] = 0.0;
            this.resistencias[i] = 0.0;
            this.ZthreeWinding[i] = new Complex(1.0, 0.0);
            this.Zreales[i] = new Complex(0.0, 0.0);
        }
        if (this.numnod < 2) {
            this.dcLF_Error("Not valid System");
        }
        for (ix = 0; ix < this.ActSchematic.Components.size(); ++ix) {
            double aux;
            Complex auxc2;
            Complex auxc1;
            TempComponent = (comp)this.ActSchematic.Components.elementAt(ix);
            if (!(TempComponent instanceof ndb_comp)) continue;
            TempNdb_comp = (ndb_comp)TempComponent;
            if (!TempComponent.getactive() || !TempComponent.getvalid() || !TempComponent.getinservice() || TempComponent instanceof Busbar || !TempNdb_comp.getctrla().equals(this.ctrla) && !this.ctrla.equals("ALL CONTROL AREAS")) continue;
            if (TempComponent instanceof Line) {
                TempLine = (Line)TempComponent;
                con1 = this.numbus(TempLine.getcon1());
                if (con1 > -1 && (con2 = this.numbus(TempLine.getcon2())) > -1) {
                    this.BranchR[count] = TempLine.getr1() * TempLine.getlen() * this.getSref() / (TempLine.getun1() * TempLine.getun1());
                    this.BranchX[count] = TempLine.getxx1() * TempLine.getlen() * this.getSref() / (TempLine.getun1() * TempLine.getun1());
                    this.BranchI[count] = con1;
                    this.BranchJ[count] = con2;
                    this.NomBra[count] = TempLine.getName();
                    if (Math.abs(this.BranchX[count]) < 1.0E-9) {
                        this.dcLF_Error("Line \"" + TempLine.getName() + "\"" + ", too low Reactance.");
                    }
                    if (this.halfFDLF) {
                        this.BranchB[count] = TempLine.getb1() * TempLine.getlen() / 2.0 / this.getSref() * (TempLine.getun1() * TempLine.getun1());
                        auxc1 = new Complex(this.BranchR[count], this.BranchX[count]);
                        auxc2 = new Complex(1.0);
                        auxc1 = auxc2.divide(auxc1);
                        auxc2 = new Complex(0.0, this.BranchB[count]);
                        this.Ybus[this.BranchJ[count]][this.BranchI[count]].add(Complex.negate((Complex)auxc1));
                        this.Ybus[this.BranchI[count]][this.BranchJ[count]].add(Complex.negate((Complex)auxc1));
                        this.Ybus[this.BranchI[count]][this.BranchI[count]].add(Complex.add((Complex)auxc1, (Complex)auxc2));
                        this.Ybus[this.BranchJ[count]][this.BranchJ[count]].add(Complex.add((Complex)auxc1, (Complex)auxc2));
                        aux = this.B1.elementAt(this.BranchJ[count], this.BranchI[count]);
                        this.B1.setElementAt(this.BranchJ[count], this.BranchI[count], auxc1.im + aux);
                        aux = this.B1.elementAt(this.BranchI[count], this.BranchJ[count]);
                        this.B1.setElementAt(this.BranchI[count], this.BranchJ[count], auxc1.im + aux);
                        aux = this.B1.elementAt(this.BranchI[count], this.BranchI[count]);
                        this.B1.setElementAt(this.BranchI[count], this.BranchI[count], -auxc1.im + aux);
                        aux = this.B1.elementAt(this.BranchJ[count], this.BranchJ[count]);
                        this.B1.setElementAt(this.BranchJ[count], this.BranchJ[count], -auxc1.im + aux);
                    } else {
                        double[] dArray = this.MxInvX[this.BranchJ[count]];
                        int n = this.BranchI[count];
                        dArray[n] = dArray[n] - 1.0 / this.BranchX[count];
                        double[] dArray2 = this.MxInvX[this.BranchI[count]];
                        int n2 = this.BranchJ[count];
                        dArray2[n2] = dArray2[n2] - 1.0 / this.BranchX[count];
                        double[] dArray3 = this.MxInvX[this.BranchI[count]];
                        int n3 = this.BranchI[count];
                        dArray3[n3] = dArray3[n3] + 1.0 / this.BranchX[count];
                        double[] dArray4 = this.MxInvX[this.BranchJ[count]];
                        int n4 = this.BranchJ[count];
                        dArray4[n4] = dArray4[n4] + 1.0 / this.BranchX[count];
                    }
                    this.matCx[this.BranchJ[count]][this.BranchI[count]] = true;
                    this.matCx[this.BranchI[count]][this.BranchJ[count]] = true;
                    ++count;
                    continue;
                }
                this.dcLF_Error("Line \"" + TempLine.getName() + "\"" + ", is not connected");
                continue;
            }
            if (TempComponent instanceof Trafo) {
                Trafo TempTrafo = (Trafo)TempComponent;
                TempTrafo.actualizet();
                con1 = this.numbus(TempTrafo.getcon1());
                if (con1 > -1 && (con2 = this.numbus(TempTrafo.getcon2())) > -1) {
                    ueb = TempTrafo.getun1() / TempTrafo.getun2() / (TempTrafo.getur1() / TempTrafo.getur2());
                    res = TempTrafo.getpcu() * 0.001 * ueb * ueb / TempTrafo.getsn() * this.getSref() / TempTrafo.getsn();
                    z = TempTrafo.getuk() * 0.01 * ueb * ueb * this.getSref() / TempTrafo.getsn();
                    reac = TempTrafo.getuk() >= 0.0 ? Math.sqrt(z * z - res * res) : -Math.sqrt(z * z - res * res);
                    this.BranchI[count] = con1;
                    this.BranchJ[count] = con2;
                    this.BranchX[count] = reac;
                    this.BranchR[count] = res;
                    this.NomBra[count] = TempTrafo.getName();
                    if (Math.abs(this.BranchX[count]) < 1.0E-9) {
                        this.dcLF_Error("Trafo \"" + TempTrafo.getName() + "\"" + ", too low Reactance.");
                    }
                    if (this.halfFDLF) {
                        this.BranchB[count] = TempTrafo.geti0() * 0.01 * 0.5 / this.getSref() * TempTrafo.getsn();
                        auxc1 = new Complex(this.BranchR[count], this.BranchX[count]);
                        auxc2 = new Complex(1.0);
                        auxc1 = Complex.divide((Complex)auxc2, (Complex)auxc1);
                        auxc2 = new Complex(0.0, this.BranchB[count]);
                        if (TempTrafo.gett_im() == 0.0) {
                            factor = new Complex(TempTrafo.gett_re(), 0.0);
                            modulo = TempTrafo.gett_re();
                        } else {
                            partimag = TempTrafo.gett_im() * Math.PI / 180.0;
                            factor = new Complex(Math.cos(partimag), Math.sin(partimag));
                            modulo = 1.0;
                        }
                        this.Ybus[this.BranchJ[count]][this.BranchI[count]].add(Complex.negate((Complex)Complex.divide((Complex)auxc1, (Complex)factor)));
                        this.Ybus[this.BranchI[count]][this.BranchJ[count]].add(Complex.negate((Complex)Complex.divide((Complex)auxc1, (Complex)Complex.conjugate((Complex)factor))));
                        this.Ybus[this.BranchI[count]][this.BranchI[count]].add(Complex.add((Complex)auxc1, (Complex)auxc2).divide(modulo * modulo));
                        this.Ybus[this.BranchJ[count]][this.BranchJ[count]].add(Complex.add((Complex)auxc1, (Complex)auxc2));
                        aux = this.B1.elementAt(this.BranchJ[count], this.BranchI[count]);
                        this.B1.setElementAt(this.BranchJ[count], this.BranchI[count], auxc1.im + aux);
                        aux = this.B1.elementAt(this.BranchI[count], this.BranchJ[count]);
                        this.B1.setElementAt(this.BranchI[count], this.BranchJ[count], auxc1.im + aux);
                        aux = this.B1.elementAt(this.BranchI[count], this.BranchI[count]);
                        this.B1.setElementAt(this.BranchI[count], this.BranchI[count], -auxc1.im + aux);
                        aux = this.B1.elementAt(this.BranchJ[count], this.BranchJ[count]);
                        this.B1.setElementAt(this.BranchJ[count], this.BranchJ[count], -auxc1.im + aux);
                    } else if (TempTrafo.gett_im() == 0.0) {
                        int n = count;
                        this.BranchR[n] = this.BranchR[n] * TempTrafo.gett_re();
                        int n5 = count;
                        this.BranchX[n5] = this.BranchX[n5] * TempTrafo.gett_re();
                        double[] dArray = this.MxInvX[this.BranchJ[count]];
                        int n6 = this.BranchI[count];
                        dArray[n6] = dArray[n6] - 1.0 / this.BranchX[count];
                        double[] dArray5 = this.MxInvX[this.BranchI[count]];
                        int n7 = this.BranchJ[count];
                        dArray5[n7] = dArray5[n7] - 1.0 / this.BranchX[count];
                        double[] dArray6 = this.MxInvX[this.BranchI[count]];
                        int n8 = this.BranchI[count];
                        dArray6[n8] = dArray6[n8] + 1.0 / this.BranchX[count];
                        double[] dArray7 = this.MxInvX[this.BranchJ[count]];
                        int n9 = this.BranchJ[count];
                        dArray7[n9] = dArray7[n9] + 1.0 / this.BranchX[count];
                    } else {
                        double[] dArray = this.MxInvX[this.BranchJ[count]];
                        int n = this.BranchI[count];
                        dArray[n] = dArray[n] - 1.0 / this.BranchX[count];
                        double[] dArray8 = this.MxInvX[this.BranchI[count]];
                        int n10 = this.BranchJ[count];
                        dArray8[n10] = dArray8[n10] - 1.0 / this.BranchX[count];
                        double[] dArray9 = this.MxInvX[this.BranchI[count]];
                        int n11 = this.BranchI[count];
                        dArray9[n11] = dArray9[n11] + 1.0 / this.BranchX[count];
                        double[] dArray10 = this.MxInvX[this.BranchJ[count]];
                        int n12 = this.BranchJ[count];
                        dArray10[n12] = dArray10[n12] + 1.0 / this.BranchX[count];
                    }
                    this.matCx[this.BranchJ[count]][this.BranchI[count]] = true;
                    this.matCx[this.BranchI[count]][this.BranchJ[count]] = true;
                    ++count;
                    continue;
                }
                this.dcLF_Error("Trafo \"" + TempTrafo.getName() + "\"" + ", is not properly connected.");
                continue;
            }
            if (TempComponent instanceof ThreeWindingTrafo) {
                ThreeWindingTrafo TempThreeWindingTrafo = (ThreeWindingTrafo)TempComponent;
                TempThreeWindingTrafo.actualizet();
                con1 = this.numbus(TempThreeWindingTrafo.getcon1());
                if (con1 > -1 && (con2 = this.numbus(TempThreeWindingTrafo.getcon2())) > -1 && (con3 = this.numbus(TempThreeWindingTrafo.getcon3())) > -1) {
                    potapa1 = TempThreeWindingTrafo.getsn() > TempThreeWindingTrafo.getsn1() ? TempThreeWindingTrafo.getsn1() : TempThreeWindingTrafo.getsn();
                    potapa2 = TempThreeWindingTrafo.getsn() > TempThreeWindingTrafo.getsn2() ? TempThreeWindingTrafo.getsn2() : TempThreeWindingTrafo.getsn();
                    potapa3 = TempThreeWindingTrafo.getsn1() > TempThreeWindingTrafo.getsn2() ? TempThreeWindingTrafo.getsn2() : TempThreeWindingTrafo.getsn1();
                    this.resistencias[0] = TempThreeWindingTrafo.getpcu() * (0.001 / potapa1) * (TempThreeWindingTrafo.getun1() * TempThreeWindingTrafo.getun1() / potapa1) * this.getSref() / TempThreeWindingTrafo.getsn();
                    this.resistencias[1] = TempThreeWindingTrafo.getpcu13() * (0.001 / potapa2) * (TempThreeWindingTrafo.getun1() * TempThreeWindingTrafo.getun1() / potapa2) * this.getSref() / TempThreeWindingTrafo.getsn1();
                    this.resistencias[2] = TempThreeWindingTrafo.getpcu23() * (0.001 / potapa3) * (TempThreeWindingTrafo.getun1() * TempThreeWindingTrafo.getun1() / potapa3) * this.getSref() / TempThreeWindingTrafo.getsn2();
                    this.resistencias[0] = this.resistencias[0] * TempThreeWindingTrafo.getsn() / (TempThreeWindingTrafo.getun1() * TempThreeWindingTrafo.getun1());
                    this.resistencias[1] = this.resistencias[1] * TempThreeWindingTrafo.getsn() / (TempThreeWindingTrafo.getun1() * TempThreeWindingTrafo.getun1());
                    this.resistencias[2] = this.resistencias[2] * TempThreeWindingTrafo.getsn() / (TempThreeWindingTrafo.getun1() * TempThreeWindingTrafo.getun1());
                    Zk12 = TempThreeWindingTrafo.getuk12() * 0.01 * (TempThreeWindingTrafo.getun1() * TempThreeWindingTrafo.getun1()) / potapa1 * this.getSref() / TempThreeWindingTrafo.getsn();
                    Zk13 = TempThreeWindingTrafo.getuk13() * 0.01 * (TempThreeWindingTrafo.getun1() * TempThreeWindingTrafo.getun1()) / potapa2 * this.getSref() / TempThreeWindingTrafo.getsn1();
                    Zk23 = TempThreeWindingTrafo.getuk23() * 0.01 * (TempThreeWindingTrafo.getun1() * TempThreeWindingTrafo.getun1()) / potapa3 * this.getSref() / TempThreeWindingTrafo.getsn2();
                    Zk12 = Zk12 * TempThreeWindingTrafo.getsn() / (TempThreeWindingTrafo.getun1() * TempThreeWindingTrafo.getun1());
                    Zk13 = Zk13 * TempThreeWindingTrafo.getsn() / (TempThreeWindingTrafo.getun1() * TempThreeWindingTrafo.getun1());
                    Zk23 = Zk23 * TempThreeWindingTrafo.getsn() / (TempThreeWindingTrafo.getun1() * TempThreeWindingTrafo.getun1());
                    b = TempThreeWindingTrafo.geti0() * 0.01 / this.getSref() * TempThreeWindingTrafo.getsn();
                    tap1 = TempThreeWindingTrafo.gett_re();
                    tap2 = TempThreeWindingTrafo.gett_re1();
                    tap3 = TempThreeWindingTrafo.gett_re2();
                    c = 0;
                    parestrafo = 0;
                    this.react[0] = TempThreeWindingTrafo.getuk12() >= 0.0 ? Math.sqrt(Zk12 * Zk12 - this.resistencias[0] * this.resistencias[0]) : -Math.sqrt(Zk12 * Zk12 - this.resistencias[0] * this.resistencias[0]);
                    this.react[1] = TempThreeWindingTrafo.getuk13() >= 0.0 ? Math.sqrt(Zk13 * Zk13 - this.resistencias[1] * this.resistencias[1]) : -Math.sqrt(Zk13 * Zk13 - this.resistencias[1] * this.resistencias[1]);
                    this.react[2] = TempThreeWindingTrafo.getuk23() >= 0.0 ? Math.sqrt(Zk23 * Zk23 - this.resistencias[2] * this.resistencias[2]) : -Math.sqrt(Zk23 * Zk23 - this.resistencias[2] * this.resistencias[2]);
                    this.ZthreeWinding[0] = new Complex(0.5 * (this.resistencias[0] + this.resistencias[1] - this.resistencias[2]), 0.5 * (this.react[0] + this.react[1] - this.react[2]));
                    this.ZthreeWinding[1] = new Complex(0.5 * (this.resistencias[0] + this.resistencias[2] - this.resistencias[1]), 0.5 * (this.react[0] + this.react[2] - this.react[1]));
                    this.ZthreeWinding[2] = new Complex(0.5 * (this.resistencias[1] + this.resistencias[2] - this.resistencias[0]), 0.5 * (this.react[1] + this.react[2] - this.react[0]));
                    Zrama12 = new Complex(this.resistencias[0], this.react[0]);
                    Zrama13 = new Complex(this.resistencias[1], this.react[1]);
                    Zrama23 = new Complex(this.resistencias[2], this.react[2]);
                    this.Zreales[0] = Complex.add((Complex)Zrama12, (Complex)Complex.divide((Complex)Complex.multiply((Complex)this.ZthreeWinding[0], (Complex)this.ZthreeWinding[1]), (Complex)this.ZthreeWinding[2]));
                    this.Zreales[1] = Complex.add((Complex)Zrama13, (Complex)Complex.divide((Complex)Complex.multiply((Complex)this.ZthreeWinding[0], (Complex)this.ZthreeWinding[2]), (Complex)this.ZthreeWinding[1]));
                    this.Zreales[2] = Complex.add((Complex)Zrama23, (Complex)Complex.divide((Complex)Complex.multiply((Complex)this.ZthreeWinding[1], (Complex)this.ZthreeWinding[2]), (Complex)this.ZthreeWinding[0]));
                    auxc3 = new Complex(0.0, b);
                    fintrafo = count + 3;
                    for (count = countaux = count; count < fintrafo; ++count) {
                        this.BranchX[count] = this.Zreales[c].im;
                        this.BranchR[count] = this.Zreales[c].re;
                        this.NomBra[count] = TempThreeWindingTrafo.getName();
                        auxc1 = new Complex(this.ZthreeWinding[c]);
                        if (Complex.abs((Complex)auxc1) < 1.0E-9) {
                            this.dcLF_Error("Three Winding Trafo \"" + TempThreeWindingTrafo.getName() + "\"" + ", too low Impedance.");
                        }
                        auxc2 = new Complex(1.0);
                        auxc1 = Complex.divide((Complex)auxc2, (Complex)auxc1);
                        if (c == 0) {
                            ramaY1 = auxc1;
                        } else if (c == 1) {
                            ramaY2 = auxc1;
                        } else if (c == 2) {
                            ramaY3 = auxc1;
                        }
                        ++c;
                    }
                    if (this.halfFDLF) {
                        A1 = Complex.divide((Complex)ramaY1, (Complex)Complex.add((Complex)ramaY1, (Complex)Complex.add((Complex)ramaY2, (Complex)ramaY3)));
                        A2 = Complex.divide((Complex)ramaY2, (Complex)Complex.add((Complex)ramaY1, (Complex)Complex.add((Complex)ramaY2, (Complex)ramaY3)));
                        A3 = Complex.add((Complex)ramaY1, (Complex)Complex.add((Complex)ramaY2, (Complex)ramaY3));
                        invertA3 = Complex.divide((Complex)neutro, (Complex)A3);
                        factory = Complex.multiply((Complex)A3, (Complex)auxc3);
                        auxc1 = new Complex(1.0);
                        for (count = countaux; count < fintrafo; ++count) {
                            this.BranchB[count] = b;
                            if (parestrafo == 0) {
                                this.BranchI[count] = con1;
                                this.BranchJ[count] = con2;
                                Afinal = A1;
                                auxc1 = Complex.divide((Complex)neutro, (Complex)this.Zreales[0]);
                                ramaY = ramaY2;
                                tapdiag1 = tap1 * tap1;
                                tapnodiag = tap1 * tap2;
                                tapdiag2 = tap2 * tap2;
                                if (TempThreeWindingTrafo.getlado() == "HV") {
                                    System.out.println("HV");
                                    primerdiag = factory;
                                    segundiag = new Complex(0.0, 0.0);
                                }
                            } else if (parestrafo == 1) {
                                this.BranchI[count] = con3;
                                this.BranchJ[count] = con1;
                                Afinal = A1;
                                auxc1 = Complex.divide((Complex)neutro, (Complex)this.Zreales[1]);
                                ramaY = ramaY3;
                                tapdiag1 = tap3 * tap3;
                                tapnodiag = tap1 * tap3;
                                tapdiag2 = tap1 * tap1;
                                if (TempThreeWindingTrafo.getlado() == "LV") {
                                    System.out.println("LV");
                                    primerdiag = new Complex(0.0, 0.0);
                                    segundiag = factory;
                                }
                            } else if (parestrafo == 2) {
                                this.BranchI[count] = con2;
                                this.BranchJ[count] = con3;
                                Afinal = A2;
                                auxc1 = Complex.divide((Complex)neutro, (Complex)this.Zreales[2]);
                                ramaY = ramaY3;
                                tapdiag1 = tap2 * tap2;
                                tapnodiag = tap2 * tap3;
                                tapdiag2 = tap3 * tap3;
                                if (TempThreeWindingTrafo.getlado() == "MV") {
                                    System.out.println("MV");
                                    primerdiag = factory;
                                    segundiag = new Complex(0.0, 0.0);
                                }
                            }
                            invertapdiag1 = new Complex(tapdiag1, 0.0);
                            invertapnodiag = new Complex(tapnodiag, 0.0);
                            invertapdiag2 = new Complex(tapdiag2, 0.0);
                            invertapdiag1 = Complex.divide((Complex)neutro, (double)tapdiag1);
                            invertapnodiag = Complex.divide((Complex)neutro, (double)tapnodiag);
                            invertapdiag2 = Complex.divide((Complex)neutro, (double)tapdiag2);
                            this.Ybus[this.BranchJ[count]][this.BranchI[count]].add(Complex.negate((Complex)Complex.multiply((Complex)ramaY, (Complex)Complex.multiply((Complex)Afinal, (Complex)invertapnodiag))));
                            this.Ybus[this.BranchI[count]][this.BranchJ[count]].add(Complex.negate((Complex)Complex.multiply((Complex)ramaY, (Complex)Complex.multiply((Complex)Afinal, (Complex)invertapnodiag))));
                            this.Ybus[this.BranchI[count]][this.BranchI[count]].add(Complex.add((Complex)Complex.multiply((Complex)ramaY, (Complex)Complex.multiply((Complex)Afinal, (Complex)invertapdiag1)), (Complex)Complex.multiply((Complex)primerdiag, (Complex)Complex.multiply((Complex)invertA3, (Complex)invertapdiag1))));
                            this.Ybus[this.BranchJ[count]][this.BranchJ[count]].add(Complex.add((Complex)Complex.multiply((Complex)ramaY, (Complex)Complex.multiply((Complex)Afinal, (Complex)invertapdiag2)), (Complex)Complex.multiply((Complex)segundiag, (Complex)Complex.multiply((Complex)invertA3, (Complex)invertapdiag2))));
                            aux = this.B1.elementAt(this.BranchJ[count], this.BranchI[count]);
                            this.B1.setElementAt(this.BranchJ[count], this.BranchI[count], auxc1.im + aux);
                            aux = this.B1.elementAt(this.BranchI[count], this.BranchJ[count]);
                            this.B1.setElementAt(this.BranchI[count], this.BranchJ[count], auxc1.im + aux);
                            aux = this.B1.elementAt(this.BranchI[count], this.BranchI[count]);
                            this.B1.setElementAt(this.BranchI[count], this.BranchI[count], -auxc1.im + aux);
                            aux = this.B1.elementAt(this.BranchJ[count], this.BranchJ[count]);
                            this.B1.setElementAt(this.BranchJ[count], this.BranchJ[count], -auxc1.im + aux);
                            this.matCx[this.BranchJ[count]][this.BranchI[count]] = true;
                            this.matCx[this.BranchI[count]][this.BranchJ[count]] = true;
                            ++parestrafo;
                            primerdiag = new Complex(0.0, 0.0);
                            segundiag = new Complex(0.0, 0.0);
                        }
                        continue;
                    }
                    parestrafo = 0;
                    divisor = this.ZthreeWinding[0].im * this.ZthreeWinding[1].im + this.ZthreeWinding[0].im * this.ZthreeWinding[2].im + this.ZthreeWinding[1].im * this.ZthreeWinding[2].im;
                    for (count = countaux; count < fintrafo; ++count) {
                        if (parestrafo == 0) {
                            this.BranchI[count] = con1;
                            this.BranchJ[count] = con2;
                            ramaX = this.ZthreeWinding[2].im;
                            tapdiag1 = tap1 * tap1;
                            tapnodiag = tap1 * tap2;
                            tapdiag2 = tap2 * tap2;
                            int n = count;
                            this.BranchX[n] = this.BranchX[n] * (tap1 * tap2);
                            int n13 = count;
                            this.BranchR[n13] = this.BranchR[n13] * (tap1 * tap2);
                        } else if (parestrafo == 1) {
                            this.BranchI[count] = con3;
                            this.BranchJ[count] = con1;
                            ramaX = this.ZthreeWinding[1].im;
                            tapdiag1 = tap3 * tap3;
                            tapnodiag = tap1 * tap3;
                            tapdiag2 = tap1 * tap1;
                            int n = count;
                            this.BranchX[n] = this.BranchX[n] * (tap3 * tap1);
                            int n14 = count;
                            this.BranchR[n14] = this.BranchR[n14] * (tap3 * tap1);
                        } else if (parestrafo == 2) {
                            this.BranchI[count] = con2;
                            this.BranchJ[count] = con3;
                            ramaX = this.ZthreeWinding[0].im;
                            tapdiag1 = tap2 * tap2;
                            tapnodiag = tap2 * tap3;
                            tapdiag2 = tap3 * tap3;
                            int n = count;
                            this.BranchX[n] = this.BranchX[n] * (tap2 * tap3);
                            int n15 = count;
                            this.BranchR[n15] = this.BranchR[n15] * (tap2 * tap3);
                        }
                        double[] dArray = this.MxInvX[this.BranchJ[count]];
                        int n = this.BranchI[count];
                        dArray[n] = dArray[n] - ramaX / (tapnodiag * divisor);
                        double[] dArray11 = this.MxInvX[this.BranchI[count]];
                        int n16 = this.BranchJ[count];
                        dArray11[n16] = dArray11[n16] - ramaX / (tapnodiag * divisor);
                        double[] dArray12 = this.MxInvX[this.BranchI[count]];
                        int n17 = this.BranchI[count];
                        dArray12[n17] = dArray12[n17] + ramaX / (tapdiag1 * divisor);
                        double[] dArray13 = this.MxInvX[this.BranchJ[count]];
                        int n18 = this.BranchJ[count];
                        dArray13[n18] = dArray13[n18] + ramaX / (tapdiag2 * divisor);
                        this.matCx[this.BranchJ[count]][this.BranchI[count]] = true;
                        this.matCx[this.BranchI[count]][this.BranchJ[count]] = true;
                        ++parestrafo;
                    }
                    continue;
                }
                this.dcLF_Error("Three Winding Trafo \"" + TempThreeWindingTrafo.getName() + "\"" + ", is not connected.");
                continue;
            }
            if (!(TempComponent instanceof ndb_1pol)) continue;
            TempComponent.InformAllComponents();
            ndb_1pol Temp1pol = (ndb_1pol)TempComponent;
            double p0 = -Temp1pol.getp0() / this.getSref();
            int indice = this.numbus(Temp1pol.getcon2());
            if (indice == -1) {
                this.dcLF_Error(Temp1pol.getClassName() + " \"" + Temp1pol.getName() + "\"" + ", is not connected.");
            }
            if (Temp1pol instanceof Load) {
                tipocomp = 1;
                strcomp = "Load";
            } else {
                if (Temp1pol instanceof Generator) {
                    p0 = -p0;
                    tipocomp = 4;
                    strcomp = "Generator";
                } else {
                    if (!(Temp1pol instanceof ndb_inj)) continue;
                    p0 = -p0;
                    tipocomp = 5;
                    strcomp = "Injection";
                }
                if (tipocomp == 4 && Temp1pol.getlf_type() == 3) {
                    if (this.slack > -1) {
                        if (this.indic_bSL != indice) {
                            Generator TempGenerator = (Generator)this.ActSchematic.Components.elementAt(this.slack);
                            strcomp = TempGenerator.getName();
                            this.dcLF_Error("There\u00b4s more than one slack busbar \"" + Temp1pol.getName() + "\" " + "\"" + strcomp + "\"");
                        }
                    } else {
                        this.slack = ix;
                        this.indic_bSL = indice;
                        p0 = 0.0;
                    }
                }
            }
            int n = indice;
            this.Pinj[n] = this.Pinj[n] + p0;
        }
        if (this.halfFDLF) {
            for (i = 0; i < this.numnod; ++i) {
                for (j = 0; j < this.numnod; ++j) {
                    this.Bbus.setElementAt(i, j, this.Ybus[i][j].im);
                    this.Gbus.setElementAt(i, j, this.Ybus[i][j].re);
                }
            }
            this.Ybus = null;
        } else {
            this.B1 = new SparseMatrix(this.MxInvX);
        }
        this.verificarGrafo();
        if (this.slack < 0) {
            this.dcLF_Error("there\u00b4s not slack busbar in system");
        }
        for (i = 0; i < this.numnod; ++i) {
            this.dk[i] = this.angref;
            this.Pk[i] = this.Pinj[i];
        }
        this.Pk[this.indic_bSL] = 0.0;
        this.B1.setElementAt(this.indic_bSL, this.indic_bSL, 1.0E200);
    }

    private int numbus(String Busbarname) {
        for (int ix = 0; ix < this.BusbarVector.size(); ++ix) {
            comp TempComponent = (comp)this.BusbarVector.elementAt(ix);
            if (TempComponent.getName().hashCode() != Busbarname.hashCode() || !TempComponent.getName().equals(Busbarname)) continue;
            return ix;
        }
        return -1;
    }

    private void ini_var_sist() {
        this.matCx = new boolean[this.numnod][this.numnod];
        this.Pinj = new double[this.numnod];
        this.Pk = new double[this.numnod];
        this.dk = new double[this.numnod];
        this.e = new DenseVector(this.numnod);
        this.f = new DenseVector(this.numnod);
        this.oper = new Algebra();
        if (this.halfFDLF) {
            this.Gbus = new SparseMatrix(this.numnod, this.numnod);
            this.Bbus = new SparseMatrix(this.numnod, this.numnod);
            this.B1 = new SparseMatrix(this.numnod, this.numnod);
            this.B1.setCapacity(this.numnod + 1, 20);
            this.Gbus.setCapacity(this.numnod + 1, 20);
            this.Bbus.setCapacity(this.numnod + 1, 20);
            this.Ybus = new Complex[this.numnod][this.numnod];
            this.BranchB = new double[this.numbran];
            for (int i = 0; i < this.numnod; ++i) {
                for (int j = 0; j < this.numnod; ++j) {
                    this.Ybus[i][j] = new Complex(0.0, 0.0);
                }
            }
        } else {
            this.MxInvX = new double[this.numnod][this.numnod];
        }
    }

    private void dcLF_Error(String mensaje) throws JavaLFException {
        StringTokenizer st = new StringTokenizer(mensaje, ":");
        mensaje = st.nextToken();
        throw new JavaLFException(mensaje);
    }

    private void calcular_DCLF() throws Exception {
        try {
            this.LU_B1 = new CroutPivot((MatrixI)this.B1);
        }
        catch (Exception ex) {
            String msg = new String(ex + "Singular Linear System occur during calculation");
            this.dcLF_Error(msg);
        }
        this.sol_lin(this.LU_B1, this.B1, this.dk, this.Pk);
        System.out.println("Calculating Process Finished.");
        this.dk[this.indic_bSL] = 0.0;
        for (int i = 0; i < this.numnod; ++i) {
            int n = this.indic_bSL;
            this.Pk[n] = this.Pk[n] - this.B1.elementAt(this.indic_bSL, i) * (this.dk[this.indic_bSL] - this.dk[i]);
        }
    }

    public boolean calcular_DCLF(double[] NewPinj, double[] NewPbranch) {
        int ix = 0;
        int count = 0;
        int con1 = 0;
        int con2 = 0;
        try {
            this.dk[this.indic_bSL] = 0.0;
            this.sol_lin(this.LU_B1, this.B1, this.dk, NewPinj);
            NewPinj[this.indic_bSL] = 0.0;
            for (int i = 0; i < this.numnod; ++i) {
                int n = this.indic_bSL;
                NewPinj[n] = NewPinj[n] - this.B1.elementAt(this.indic_bSL, i) * (this.dk[this.indic_bSL] - this.dk[i]);
            }
            for (ix = 0; ix < this.ActSchematic.Components.size(); ++ix) {
                ndb_branch TempBran;
                comp TempComponent = (comp)this.ActSchematic.Components.elementAt(ix);
                if (!(TempComponent instanceof ndb_branch) || !(TempBran = (ndb_branch)TempComponent).getctrla().equals(this.ctrla) && !this.ctrla.equals("ALL CONTROL AREAS") || !TempBran.getactive() || !TempBran.getvalid() || !TempBran.getinservice() || (con1 = this.numbus(TempBran.getcon1())) <= -1 || (con2 = this.numbus(TempBran.getcon2())) <= -1) continue;
                NewPbranch[count] = 1.0 / this.BranchX[count] * (this.dk[con1] - this.dk[con2]);
                ++count;
            }
        }
        catch (Exception ex) {
            System.out.println("DC LF error on calculus: " + ex);
            return false;
        }
        return true;
    }

    public boolean calcular_DCLF(double[] NewPinj, double[] NewPbranch, YearlyDCLFStatistics MMyYearlylf) {
        YearlyDCLFStatistics MyYearlylf = MMyYearlylf;
        double[] Pbranch = new double[NewPbranch.length];
        int ix = 0;
        int count = 0;
        int con1 = 0;
        int con2 = 0;
        try {
            this.dk[this.indic_bSL] = 0.0;
            this.sol_lin(this.LU_B1, this.B1, this.dk, NewPinj);
            NewPinj[this.indic_bSL] = 0.0;
            for (int i = 0; i < this.numnod; ++i) {
                int n = this.indic_bSL;
                NewPinj[n] = NewPinj[n] - this.B1.elementAt(this.indic_bSL, i) * (this.dk[this.indic_bSL] - this.dk[i]);
            }
            for (ix = 0; ix < this.ActSchematic.Components.size(); ++ix) {
                ndb_branch TempBran;
                comp TempComponent = (comp)this.ActSchematic.Components.elementAt(ix);
                if (!(TempComponent instanceof ndb_branch) || !(TempBran = (ndb_branch)TempComponent).getctrla().equals(this.ctrla) && !this.ctrla.equals("ALL CONTROL AREAS") || !TempBran.getactive() || !TempBran.getvalid() || !TempBran.getinservice() || (con1 = this.numbus(TempBran.getcon1())) <= -1 || (con2 = this.numbus(TempBran.getcon2())) <= -1) continue;
                NewPbranch[count] = 1.0 / this.BranchX[count] * (this.dk[con1] - this.dk[con2]);
                ++count;
            }
            for (int u = 0; u < NewPbranch.length; ++u) {
                Pbranch[u] = NewPbranch[u];
            }
            this.resultyearly(MyYearlylf, Pbranch);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.out.println("DC LF error on calculation: " + ex);
            return false;
        }
        return true;
    }

    public boolean calcular_DCLF(double[] NewPinj, double[] NewPbranch, MMS MMyYearlylf) {
        MMS MyYearlylf = MMyYearlylf;
        double[] Pbranch = new double[NewPbranch.length];
        int ix = 0;
        int count = 0;
        int con1 = 0;
        int con2 = 0;
        try {
            this.dk[this.indic_bSL] = 0.0;
            this.sol_lin(this.LU_B1, this.B1, this.dk, NewPinj);
            NewPinj[this.indic_bSL] = 0.0;
            for (int i = 0; i < this.numnod; ++i) {
                int n = this.indic_bSL;
                NewPinj[n] = NewPinj[n] - this.B1.elementAt(this.indic_bSL, i) * (this.dk[this.indic_bSL] - this.dk[i]);
            }
            for (ix = 0; ix < this.ActSchematic.Components.size(); ++ix) {
                ndb_branch TempBran;
                comp TempComponent = (comp)this.ActSchematic.Components.elementAt(ix);
                if (!(TempComponent instanceof ndb_branch) || !(TempBran = (ndb_branch)TempComponent).getctrla().equals(this.ctrla) && !this.ctrla.equals("ALL CONTROL AREAS") || !TempBran.getactive() || !TempBran.getvalid() || !TempBran.getinservice() || (con1 = this.numbus(TempBran.getcon1())) <= -1 || (con2 = this.numbus(TempBran.getcon2())) <= -1) continue;
                NewPbranch[count] = 1.0 / this.BranchX[count] * (this.dk[con1] - this.dk[con2]);
                ++count;
            }
            for (int u = 0; u < NewPbranch.length; ++u) {
                Pbranch[u] = NewPbranch[u];
            }
            this.resultyearly(MyYearlylf, Pbranch);
        }
        catch (Exception ex) {
            System.out.println("DC LF error on calculus: " + ex);
            return false;
        }
        return true;
    }

    private boolean calcular_PFDLF() throws Exception {
        int i;
        double maxDP = 0.0;
        int itercount = 0;
        double[] DP2 = new double[this.numnod];
        double[] Dd = new double[this.numnod];
        this.actualizar_Pk(this.Pk, this.dk, this.Gbus, this.Bbus);
        for (i = 0; i < this.numnod; ++i) {
            DP2[i] = this.Pinj[i] - this.Pk[i];
        }
        DP2[this.indic_bSL] = 0.0;
        for (i = 0; i < this.numnod; ++i) {
            if (!(Math.abs(DP2[i]) > maxDP)) continue;
            maxDP = Math.abs(DP2[i]);
        }
        System.out.println("\nNiter   P deviation");
        System.out.println("-----   -----------");
        System.out.println("* [" + itercount + "]   " + StringUtil.numformat(maxDP *= this.getSref(), 9, 4) + " [MW]");
        try {
            this.LU_B1 = new CroutPivot((MatrixI)this.B1);
        }
        catch (Exception ex) {
            String msg = new String(ex + "Singular Linear System occur during calculation");
            this.dcLF_Error(msg);
        }
        do {
            maxDP = 0.0;
            ++itercount;
            this.sol_lin(this.LU_B1, this.B1, Dd, DP2);
            Dd[this.indic_bSL] = 0.0;
            for (i = 0; i < this.numnod; ++i) {
                this.dk[i] = this.dk[i] + Dd[i];
            }
            this.actualizar_Pk(this.Pk, this.dk, this.Gbus, this.Bbus);
            for (i = 0; i < this.numnod; ++i) {
                DP2[i] = this.Pinj[i] - this.Pk[i];
            }
            DP2[this.indic_bSL] = 0.0;
            for (i = 0; i < this.numnod; ++i) {
                if (!(Math.abs(DP2[i]) > maxDP)) continue;
                maxDP = Math.abs(DP2[i]);
            }
            System.out.println("* [" + itercount + "]   " + StringUtil.numformat(maxDP *= this.getSref(), 9, 4) + " [MW]");
        } while (maxDP > 0.1 && itercount < 20);
        if (maxDP <= 0.1) {
            System.out.println("\nConvergence Reached.");
            return true;
        }
        System.out.println("\nThere's not convergence.");
        return false;
    }

    private boolean calcular_DCLFwCuadLoss() throws Exception {
        double maxDLoss;
        double dij;
        double z2;
        int itercount = 1;
        this.Pslwol = 0.0;
        try {
            this.LU_B1 = new CroutPivot((MatrixI)this.B1);
        }
        catch (Exception ex) {
            String msg = new String(ex + "Singular Linear System occur during calculation");
            this.dcLF_Error(msg);
        }
        double[] Plossk0 = new double[this.numnod];
        double[] Plossk1 = new double[this.numnod];
        this.sol_lin(this.LU_B1, this.B1, this.dk, this.Pk);
        int i = 0;
        while (i < this.numnod) {
            int n = i++;
            this.dk[n] = this.dk[n] - this.angref;
        }
        this.dk[this.indic_bSL] = this.angref;
        for (i = 0; i < this.numbran; ++i) {
            z2 = this.BranchX[i] * this.BranchX[i] + this.BranchR[i] * this.BranchR[i];
            dij = this.dk[this.BranchI[i]] - this.dk[this.BranchJ[i]];
            this.BranchPLoss[i] = this.BranchR[i] * dij * dij / z2;
            int n = this.BranchI[i];
            this.Pk[n] = this.Pk[n] - this.BranchPLoss[i] / 2.0;
            int n2 = this.BranchJ[i];
            this.Pk[n2] = this.Pk[n2] - this.BranchPLoss[i] / 2.0;
            int n3 = this.BranchI[i];
            Plossk1[n3] = Plossk1[n3] + this.BranchPLoss[i] / 2.0;
            int n4 = this.BranchJ[i];
            Plossk1[n4] = Plossk1[n4] + this.BranchPLoss[i] / 2.0;
        }
        this.Pk[this.indic_bSL] = 0.0;
        for (i = 0; i < this.numnod; ++i) {
            int n = this.indic_bSL;
            this.Pk[n] = this.Pk[n] - this.MxInvX[this.indic_bSL][i] * (this.dk[this.indic_bSL] - this.dk[i]);
        }
        this.Pslwol = this.Pk[this.indic_bSL];
        System.out.println("\nIterations  max PLoss mistmatch");
        System.out.println("----------  -------------------");
        do {
            double[] Plossktemp = Plossk0;
            Plossk0 = Plossk1;
            Plossk1 = Plossktemp;
            ++itercount;
            this.sol_lin(this.LU_B1, this.B1, this.dk, this.Pk);
            for (i = 0; i < this.numnod; ++i) {
                int n = i;
                this.dk[n] = this.dk[n] - this.angref;
                this.Pk[i] = this.Pinj[i];
                Plossk1[i] = 0.0;
            }
            this.dk[this.indic_bSL] = this.angref;
            for (i = 0; i < this.numbran; ++i) {
                z2 = this.BranchX[i] * this.BranchX[i] + this.BranchR[i] * this.BranchR[i];
                dij = this.dk[this.BranchI[i]] - this.dk[this.BranchJ[i]];
                this.BranchPLoss[i] = this.BranchR[i] * dij * dij / z2;
                int n = this.BranchI[i];
                this.Pk[n] = this.Pk[n] - this.BranchPLoss[i] / 2.0;
                int n5 = this.BranchJ[i];
                this.Pk[n5] = this.Pk[n5] - this.BranchPLoss[i] / 2.0;
                int n6 = this.BranchI[i];
                Plossk1[n6] = Plossk1[n6] + this.BranchPLoss[i] / 2.0;
                int n7 = this.BranchJ[i];
                Plossk1[n7] = Plossk1[n7] + this.BranchPLoss[i] / 2.0;
            }
            this.Pk[this.indic_bSL] = 0.0;
            maxDLoss = 0.0;
            for (i = 0; i < this.numnod; ++i) {
                int n = this.indic_bSL;
                this.Pk[n] = this.Pk[n] - this.MxInvX[this.indic_bSL][i] * (this.dk[this.indic_bSL] - this.dk[i]);
                if (!(maxDLoss < Math.abs(Plossk1[i] - Plossk0[i]))) continue;
                maxDLoss = Math.abs(Plossk1[i] - Plossk0[i]);
            }
            int n = this.indic_bSL;
            this.Pk[n] = this.Pk[n] + Plossk1[this.indic_bSL];
            System.out.println(" * [" + itercount + "-" + (itercount - 1) + "]     " + StringUtil.numformat(maxDLoss *= this.getSref(), 9, 4) + " [MW]");
        } while (maxDLoss > 0.01 && itercount < 20);
        if (maxDLoss <= 0.01) {
            System.out.println("\nConvergence Reached.");
            return true;
        }
        System.out.println("\nThere's not convergence.");
        return false;
    }

    public boolean calcular_DCLFwLoss(double[] NewPinj, double[] NewPbranch, YearlyDCLFStatistics MMyYearlylf) {
        YearlyDCLFStatistics MyYearlylf = MMyYearlylf;
        double[] Pbranch = new double[NewPbranch.length];
        try {
            double maxDLoss;
            double dij;
            double z2;
            int i;
            int ix = 0;
            int count = 0;
            int con1 = 0;
            int con2 = 0;
            int itercount = 1;
            this.Pslwol = 0.0;
            try {
                this.LU_B1 = new CroutPivot((MatrixI)this.B1);
            }
            catch (Exception ex) {
                String msg = new String(ex + "Singular Linear System occur during calculation");
                this.dcLF_Error(msg);
            }
            for (i = 0; i < this.numnod; ++i) {
                this.Pk[i] = NewPinj[i];
            }
            double[] Plossk0 = new double[this.numnod];
            double[] Plossk1 = new double[this.numnod];
            this.sol_lin(this.LU_B1, this.B1, this.dk, this.Pk);
            i = 0;
            while (i < this.numnod) {
                int n = i++;
                this.dk[n] = this.dk[n] - this.angref;
            }
            this.dk[this.indic_bSL] = this.angref;
            for (i = 0; i < this.numbran; ++i) {
                z2 = this.BranchX[i] * this.BranchX[i] + this.BranchR[i] * this.BranchR[i];
                dij = this.dk[this.BranchI[i]] - this.dk[this.BranchJ[i]];
                this.BranchPLoss[i] = this.BranchR[i] * dij * dij / z2;
                int n = this.BranchI[i];
                this.Pk[n] = this.Pk[n] - this.BranchPLoss[i] / 2.0;
                int n2 = this.BranchJ[i];
                this.Pk[n2] = this.Pk[n2] - this.BranchPLoss[i] / 2.0;
                int n3 = this.BranchI[i];
                Plossk1[n3] = Plossk1[n3] + this.BranchPLoss[i] / 2.0;
                int n4 = this.BranchJ[i];
                Plossk1[n4] = Plossk1[n4] + this.BranchPLoss[i] / 2.0;
            }
            this.Pk[this.indic_bSL] = 0.0;
            for (i = 0; i < this.numnod; ++i) {
                int n = this.indic_bSL;
                this.Pk[n] = this.Pk[n] - this.MxInvX[this.indic_bSL][i] * (this.dk[this.indic_bSL] - this.dk[i]);
            }
            this.Pslwol = this.Pk[this.indic_bSL];
            System.out.println("\nIterations  max PLoss mistmatch");
            System.out.println("----------  -------------------");
            do {
                double[] Plossktemp = Plossk0;
                Plossk0 = Plossk1;
                Plossk1 = Plossktemp;
                ++itercount;
                this.sol_lin(this.LU_B1, this.B1, this.dk, this.Pk);
                for (i = 0; i < this.numnod; ++i) {
                    int n = i;
                    this.dk[n] = this.dk[n] - this.angref;
                    this.Pk[i] = NewPinj[i];
                    Plossk1[i] = 0.0;
                }
                this.dk[this.indic_bSL] = this.angref;
                for (i = 0; i < this.numbran; ++i) {
                    z2 = this.BranchX[i] * this.BranchX[i] + this.BranchR[i] * this.BranchR[i];
                    dij = this.dk[this.BranchI[i]] - this.dk[this.BranchJ[i]];
                    this.BranchPLoss[i] = this.BranchR[i] * dij * dij / z2;
                    int n = this.BranchI[i];
                    this.Pk[n] = this.Pk[n] - this.BranchPLoss[i] / 2.0;
                    int n5 = this.BranchJ[i];
                    this.Pk[n5] = this.Pk[n5] - this.BranchPLoss[i] / 2.0;
                    int n6 = this.BranchI[i];
                    Plossk1[n6] = Plossk1[n6] + this.BranchPLoss[i] / 2.0;
                    int n7 = this.BranchJ[i];
                    Plossk1[n7] = Plossk1[n7] + this.BranchPLoss[i] / 2.0;
                }
                this.Pk[this.indic_bSL] = 0.0;
                maxDLoss = 0.0;
                for (i = 0; i < this.numnod; ++i) {
                    int n = this.indic_bSL;
                    this.Pk[n] = this.Pk[n] - this.MxInvX[this.indic_bSL][i] * (this.dk[this.indic_bSL] - this.dk[i]);
                    if (!(maxDLoss < Math.abs(Plossk1[i] - Plossk0[i]))) continue;
                    maxDLoss = Math.abs(Plossk1[i] - Plossk0[i]);
                }
                int n = this.indic_bSL;
                this.Pk[n] = this.Pk[n] + Plossk1[this.indic_bSL];
                System.out.println(" * [" + itercount + "-" + (itercount - 1) + "]     " + StringUtil.numformat(maxDLoss *= this.getSref(), 9, 4) + " [MW]");
            } while (maxDLoss > 0.01 && itercount < 20);
            if (maxDLoss <= 0.01) {
                System.out.println("\nConvergence Reached.");
                for (ix = 0; ix < this.ActSchematic.Components.size(); ++ix) {
                    ndb_branch TempBran;
                    comp TempComponent = (comp)this.ActSchematic.Components.elementAt(ix);
                    if (!(TempComponent instanceof ndb_branch) || !(TempBran = (ndb_branch)TempComponent).getctrla().equals(this.ctrla) && !this.ctrla.equals("ALL CONTROL AREAS") || !TempBran.getactive() || !TempBran.getvalid() || !TempBran.getinservice() || (con1 = this.numbus(TempBran.getcon1())) <= -1 || (con2 = this.numbus(TempBran.getcon2())) <= -1) continue;
                    NewPbranch[count] = 1.0 / this.BranchX[count] * (this.dk[con1] - this.dk[con2]);
                    ++count;
                }
                for (int u = 0; u < NewPbranch.length; ++u) {
                    Pbranch[u] = NewPbranch[u];
                }
                this.resultyearly(MyYearlylf, Pbranch);
                return true;
            }
            System.out.println("\nThere's not convergence.");
            return false;
        }
        catch (Exception ex) {
            System.out.println("DC LF error on calculus: " + ex);
            return false;
        }
    }

    public boolean calcular_DCLFwLoss(double[] NewPinj, double[] NewPbranch) {
        double[] Pbranch = new double[NewPbranch.length];
        try {
            double maxDLoss;
            double dij;
            double z2;
            int i;
            int ix = 0;
            int count = 0;
            int con1 = 0;
            int con2 = 0;
            int itercount = 1;
            this.Pslwol = 0.0;
            try {
                this.LU_B1 = new CroutPivot((MatrixI)this.B1);
            }
            catch (Exception ex) {
                String msg = new String(ex + "Singular Linear System occur during calculation");
                this.dcLF_Error(msg);
            }
            for (i = 0; i < this.numnod; ++i) {
                this.Pk[i] = NewPinj[i];
            }
            double[] Plossk0 = new double[this.numnod];
            double[] Plossk1 = new double[this.numnod];
            this.sol_lin(this.LU_B1, this.B1, this.dk, this.Pk);
            i = 0;
            while (i < this.numnod) {
                int n = i++;
                this.dk[n] = this.dk[n] - this.angref;
            }
            this.dk[this.indic_bSL] = this.angref;
            for (i = 0; i < this.numbran; ++i) {
                z2 = this.BranchX[i] * this.BranchX[i] + this.BranchR[i] * this.BranchR[i];
                dij = this.dk[this.BranchI[i]] - this.dk[this.BranchJ[i]];
                this.BranchPLoss[i] = this.BranchR[i] * dij * dij / z2;
                int n = this.BranchI[i];
                this.Pk[n] = this.Pk[n] - this.BranchPLoss[i] / 2.0;
                int n2 = this.BranchJ[i];
                this.Pk[n2] = this.Pk[n2] - this.BranchPLoss[i] / 2.0;
                int n3 = this.BranchI[i];
                Plossk1[n3] = Plossk1[n3] + this.BranchPLoss[i] / 2.0;
                int n4 = this.BranchJ[i];
                Plossk1[n4] = Plossk1[n4] + this.BranchPLoss[i] / 2.0;
            }
            this.Pk[this.indic_bSL] = 0.0;
            for (i = 0; i < this.numnod; ++i) {
                int n = this.indic_bSL;
                this.Pk[n] = this.Pk[n] - this.MxInvX[this.indic_bSL][i] * (this.dk[this.indic_bSL] - this.dk[i]);
            }
            this.Pslwol = this.Pk[this.indic_bSL];
            System.out.println("\nIterations  max PLoss mistmatch");
            System.out.println("----------  -------------------");
            do {
                double[] Plossktemp = Plossk0;
                Plossk0 = Plossk1;
                Plossk1 = Plossktemp;
                ++itercount;
                this.sol_lin(this.LU_B1, this.B1, this.dk, this.Pk);
                for (i = 0; i < this.numnod; ++i) {
                    int n = i;
                    this.dk[n] = this.dk[n] - this.angref;
                    this.Pk[i] = NewPinj[i];
                    Plossk1[i] = 0.0;
                }
                this.dk[this.indic_bSL] = this.angref;
                for (i = 0; i < this.numbran; ++i) {
                    z2 = this.BranchX[i] * this.BranchX[i] + this.BranchR[i] * this.BranchR[i];
                    dij = this.dk[this.BranchI[i]] - this.dk[this.BranchJ[i]];
                    this.BranchPLoss[i] = this.BranchR[i] * dij * dij / z2;
                    int n = this.BranchI[i];
                    this.Pk[n] = this.Pk[n] - this.BranchPLoss[i] / 2.0;
                    int n5 = this.BranchJ[i];
                    this.Pk[n5] = this.Pk[n5] - this.BranchPLoss[i] / 2.0;
                    int n6 = this.BranchI[i];
                    Plossk1[n6] = Plossk1[n6] + this.BranchPLoss[i] / 2.0;
                    int n7 = this.BranchJ[i];
                    Plossk1[n7] = Plossk1[n7] + this.BranchPLoss[i] / 2.0;
                }
                this.Pk[this.indic_bSL] = 0.0;
                maxDLoss = 0.0;
                for (i = 0; i < this.numnod; ++i) {
                    int n = this.indic_bSL;
                    this.Pk[n] = this.Pk[n] - this.MxInvX[this.indic_bSL][i] * (this.dk[this.indic_bSL] - this.dk[i]);
                    if (!(maxDLoss < Math.abs(Plossk1[i] - Plossk0[i]))) continue;
                    maxDLoss = Math.abs(Plossk1[i] - Plossk0[i]);
                }
                int n = this.indic_bSL;
                this.Pk[n] = this.Pk[n] + Plossk1[this.indic_bSL];
                System.out.println(" * [" + itercount + "-" + (itercount - 1) + "]     " + StringUtil.numformat(maxDLoss *= this.getSref(), 9, 4) + " [MW]");
            } while (maxDLoss > 0.01 && itercount < 20);
            if (maxDLoss <= 0.01) {
                System.out.println("\nConvergence Reached.");
                for (ix = 0; ix < this.ActSchematic.Components.size(); ++ix) {
                    ndb_branch TempBran;
                    comp TempComponent = (comp)this.ActSchematic.Components.elementAt(ix);
                    if (!(TempComponent instanceof ndb_branch) || !(TempBran = (ndb_branch)TempComponent).getctrla().equals(this.ctrla) && !this.ctrla.equals("ALL CONTROL AREAS") || !TempBran.getactive() || !TempBran.getvalid() || !TempBran.getinservice() || (con1 = this.numbus(TempBran.getcon1())) <= -1 || (con2 = this.numbus(TempBran.getcon2())) <= -1) continue;
                    NewPbranch[count] = 1.0 / this.BranchX[count] * (this.dk[con1] - this.dk[con2]);
                    ++count;
                }
                for (int u = 0; u < NewPbranch.length; ++u) {
                    Pbranch[u] = NewPbranch[u];
                }
                return true;
            }
            System.out.println("\nThere's not convergence.");
            return false;
        }
        catch (Exception ex) {
            System.out.println("DC LF error on calculus: " + ex);
            return false;
        }
    }

    public boolean calcular_DCLFwLoss(double[] NewPinj, double[] NewPbranch, MMS MMyYearlylf) {
        MMS MyYearlylf = MMyYearlylf;
        double[] Pbranch = new double[NewPbranch.length];
        try {
            double maxDLoss;
            double dij;
            double z2;
            int i;
            int ix = 0;
            int count = 0;
            int con1 = 0;
            int con2 = 0;
            int itercount = 1;
            this.Pslwol = 0.0;
            try {
                this.LU_B1 = new CroutPivot((MatrixI)this.B1);
            }
            catch (Exception ex) {
                String msg = new String(ex + "Singular Linear System occur during calculation");
                this.dcLF_Error(msg);
            }
            for (i = 0; i < this.numnod; ++i) {
                this.Pk[i] = NewPinj[i];
            }
            double[] Plossk0 = new double[this.numnod];
            double[] Plossk1 = new double[this.numnod];
            this.sol_lin(this.LU_B1, this.B1, this.dk, this.Pk);
            i = 0;
            while (i < this.numnod) {
                int n = i++;
                this.dk[n] = this.dk[n] - this.angref;
            }
            this.dk[this.indic_bSL] = this.angref;
            for (i = 0; i < this.numbran; ++i) {
                z2 = this.BranchX[i] * this.BranchX[i] + this.BranchR[i] * this.BranchR[i];
                dij = this.dk[this.BranchI[i]] - this.dk[this.BranchJ[i]];
                this.BranchPLoss[i] = this.BranchR[i] * dij * dij / z2;
                int n = this.BranchI[i];
                this.Pk[n] = this.Pk[n] - this.BranchPLoss[i] / 2.0;
                int n2 = this.BranchJ[i];
                this.Pk[n2] = this.Pk[n2] - this.BranchPLoss[i] / 2.0;
                int n3 = this.BranchI[i];
                Plossk1[n3] = Plossk1[n3] + this.BranchPLoss[i] / 2.0;
                int n4 = this.BranchJ[i];
                Plossk1[n4] = Plossk1[n4] + this.BranchPLoss[i] / 2.0;
            }
            this.Pk[this.indic_bSL] = 0.0;
            for (i = 0; i < this.numnod; ++i) {
                int n = this.indic_bSL;
                this.Pk[n] = this.Pk[n] - this.MxInvX[this.indic_bSL][i] * (this.dk[this.indic_bSL] - this.dk[i]);
            }
            this.Pslwol = this.Pk[this.indic_bSL];
            System.out.println("\nIterations  max PLoss mistmatch");
            System.out.println("----------  -------------------");
            do {
                double[] Plossktemp = Plossk0;
                Plossk0 = Plossk1;
                Plossk1 = Plossktemp;
                ++itercount;
                this.sol_lin(this.LU_B1, this.B1, this.dk, this.Pk);
                for (i = 0; i < this.numnod; ++i) {
                    int n = i;
                    this.dk[n] = this.dk[n] - this.angref;
                    this.Pk[i] = NewPinj[i];
                    Plossk1[i] = 0.0;
                }
                this.dk[this.indic_bSL] = this.angref;
                for (i = 0; i < this.numbran; ++i) {
                    z2 = this.BranchX[i] * this.BranchX[i] + this.BranchR[i] * this.BranchR[i];
                    dij = this.dk[this.BranchI[i]] - this.dk[this.BranchJ[i]];
                    this.BranchPLoss[i] = this.BranchR[i] * dij * dij / z2;
                    int n = this.BranchI[i];
                    this.Pk[n] = this.Pk[n] - this.BranchPLoss[i] / 2.0;
                    int n5 = this.BranchJ[i];
                    this.Pk[n5] = this.Pk[n5] - this.BranchPLoss[i] / 2.0;
                    int n6 = this.BranchI[i];
                    Plossk1[n6] = Plossk1[n6] + this.BranchPLoss[i] / 2.0;
                    int n7 = this.BranchJ[i];
                    Plossk1[n7] = Plossk1[n7] + this.BranchPLoss[i] / 2.0;
                }
                this.Pk[this.indic_bSL] = 0.0;
                maxDLoss = 0.0;
                for (i = 0; i < this.numnod; ++i) {
                    int n = this.indic_bSL;
                    this.Pk[n] = this.Pk[n] - this.MxInvX[this.indic_bSL][i] * (this.dk[this.indic_bSL] - this.dk[i]);
                    if (!(maxDLoss < Math.abs(Plossk1[i] - Plossk0[i]))) continue;
                    maxDLoss = Math.abs(Plossk1[i] - Plossk0[i]);
                }
                int n = this.indic_bSL;
                this.Pk[n] = this.Pk[n] + Plossk1[this.indic_bSL];
                System.out.println(" * [" + itercount + "-" + (itercount - 1) + "]     " + StringUtil.numformat(maxDLoss *= this.getSref(), 9, 4) + " [MW]");
            } while (maxDLoss > 0.01 && itercount < 20);
            if (maxDLoss <= 0.01) {
                System.out.println("\nConvergence Reached.");
                for (ix = 0; ix < this.ActSchematic.Components.size(); ++ix) {
                    ndb_branch TempBran;
                    comp TempComponent = (comp)this.ActSchematic.Components.elementAt(ix);
                    if (!(TempComponent instanceof ndb_branch) || !(TempBran = (ndb_branch)TempComponent).getctrla().equals(this.ctrla) && !this.ctrla.equals("ALL CONTROL AREAS") || !TempBran.getactive() || !TempBran.getvalid() || !TempBran.getinservice() || (con1 = this.numbus(TempBran.getcon1())) <= -1 || (con2 = this.numbus(TempBran.getcon2())) <= -1) continue;
                    NewPbranch[count] = 1.0 / this.BranchX[count] * (this.dk[con1] - this.dk[con2]);
                    ++count;
                }
                for (int u = 0; u < NewPbranch.length; ++u) {
                    Pbranch[u] = NewPbranch[u];
                }
                this.resultyearly(MyYearlylf, Pbranch);
                return true;
            }
            System.out.println("\nThere's not convergence.");
            return false;
        }
        catch (Exception ex) {
            System.out.println("DC LF error on calculus: " + ex);
            return false;
        }
    }

    private void sol_lin(CroutPivot LU, SparseMatrix A, double[] dk, double[] pk) throws Exception {
        DenseVector b = new DenseVector(pk);
        try {
            DenseVector x = LU.solveEquations((VectorI)b);
            DenseVector bk = this.oper.multiply((MatrixI)A, (VectorI)x);
            DenseVector Db = this.oper.subtract((VectorI)b, (VectorI)bk);
            DenseVector Dx = LU.solveEquations((VectorI)Db);
            x = this.oper.add((VectorI)x, (VectorI)Dx);
            for (int i = 0; i < this.numnod; ++i) {
                dk[i] = x.elementAt(i);
            }
        }
        catch (Exception ex) {
            String msg = new String(ex + "On linear system calculation on iter:");
            this.dcLF_Error(msg);
        }
    }

    public void resultyearly(YearlyDCLFStatistics MMyYearlylf, double[] BranchP) throws Exception {
        int count = 0;
        YearlyDCLFStatistics MyYearlylfDC = MMyYearlylf;
        if (MMyYearlylf.isTPresDB) {
            MMyYearlylf.conTPresDB = DeepEdit.OpenODBC_JDBCConnection("TPResDB", true);
            Statement s = MMyYearlylf.conTPresDB.createStatement();
            for (int y = 0; y < this.ActSchematic.Components.size(); ++y) {
                ndb_branch TempBran;
                comp TempComponent = (comp)this.ActSchematic.Components.elementAt(y);
                if (!(TempComponent instanceof ndb_branch) || !(TempBran = (ndb_branch)TempComponent).getctrla().equals(this.ctrla) && !this.ctrla.equals("ALL CONTROL AREAS") || !TempBran.getactive() || !TempBran.getvalid() || !TempBran.getinservice()) continue;
                String nombre = "INSERT INTO flow_disp VALUES ('" + TempBran.getName() + "'," + BranchP[count] + "," + MMyYearlylf.countdcflow + ")";
                s.executeUpdate(nombre);
                ++count;
            }
            MMyYearlylf.conTPresDB.commit();
            MMyYearlylf.conTPresDB.close();
        } else {
            this.os = MyYearlylfDC.os_yearlyDC;
            String sp = ",";
            PrintStream myPrintStream = null;
            myPrintStream = new PrintStream(this.os, true);
            if (MyYearlylfDC.countdcflow == 1) {
                myPrintStream.println("Branch" + sp + "Flux");
            }
            for (int y = 0; y < this.ActSchematic.Components.size(); ++y) {
                ndb_branch TempBran;
                comp TempComponent = (comp)this.ActSchematic.Components.elementAt(y);
                if (!(TempComponent instanceof ndb_branch) || !(TempBran = (ndb_branch)TempComponent).getctrla().equals(this.ctrla) && !this.ctrla.equals("ALL CONTROL AREAS") || !TempBran.getactive() || !TempBran.getvalid() || !TempBran.getinservice()) continue;
                String sv = StringUtil.numformat(BranchP[count] * this.getSref(), 9, 3);
                String nombre = StringUtil.strformat(TempBran.getName(), 20);
                sv.trim();
                nombre.trim();
                myPrintStream.println(nombre + sp + sv);
                ++count;
            }
        }
    }

    public void resultyearly(MMS MMyYearlylf, double[] BranchP) {
        MMS MyYearlylfDC = MMyYearlylf;
        FileOutputStream os = MyYearlylfDC.os_yearlyDC;
        int count = 0;
        String sp = null;
        String acomsp = null;
        PrintStream myPrintStream = null;
        sp = ",";
        acomsp = ",";
        myPrintStream = new PrintStream(os, true);
        if (MyYearlylfDC.countdcflow == 1) {
            myPrintStream.println("Branch" + acomsp + "  Flux");
        }
        for (int y = 0; y < this.ActSchematic.Components.size(); ++y) {
            ndb_branch TempBran;
            comp TempComponent = (comp)this.ActSchematic.Components.elementAt(y);
            if (!(TempComponent instanceof ndb_branch) || !(TempBran = (ndb_branch)TempComponent).getctrla().equals(this.ctrla) && !this.ctrla.equals("ALL CONTROL AREAS") || !TempBran.getactive() || !TempBran.getvalid() || !TempBran.getinservice()) continue;
            String sv = StringUtil.numformat(BranchP[count] * 1.0, 9, 3);
            String nombre = StringUtil.strformat(TempBran.getName(), 20);
            sv.trim();
            nombre.trim();
            myPrintStream.println(nombre + acomsp + sv);
            ++count;
        }
    }

    public void writeresults() {
        ndb_branch TempBran;
        ndb_1pol Temp1pol;
        Generator TempGenerator;
        ndb_comp TempNdb_comp;
        comp TempComponent;
        int ix = 0;
        int count = 0;
        int con1 = 0;
        int con2 = 0;
        int con3 = 0;
        boolean c = false;
        int countbus = 0;
        int fintrafo = 0;
        int rama = 0;
        Vector<Generator> genAonbSL = new Vector<Generator>();
        double avisador = 0.0;
        double timag = 0.0;
        double PgbSL = this.Pk[this.indic_bSL] * this.getSref();
        double difere = 0.0;
        double angulo = 0.0;
        double p12 = 0.0;
        double p21 = 0.0;
        Complex v1 = new Complex(0.0, 0.0);
        Complex v2 = new Complex(0.0, 0.0);
        Complex v3 = new Complex(0.0, 0.0);
        Complex ybr = new Complex(0.0, 0.0);
        Complex ybr12 = new Complex();
        Complex ybr21 = new Complex();
        Complex ysh1 = new Complex(0.0, 0.0);
        Complex ysh2 = new Complex(0.0, 0.0);
        Complex ramashunt = new Complex(0.0, 0.0);
        Complex unidad = new Complex(1.0, 0.0);
        Complex tapchange1 = new Complex();
        Complex tapchange2 = new Complex();
        Complex tapchange3 = new Complex();
        Complex ctimag = new Complex();
        Complex cY12 = new Complex();
        Complex cY13 = new Complex();
        Complex cY23 = new Complex();
        Complex sumY1 = new Complex();
        Complex sumY2 = new Complex();
        Complex sumY3 = new Complex();
        Complex factor1 = new Complex();
        Complex factor2 = new Complex();
        Complex factor3 = new Complex();
        Complex auxramay12 = new Complex();
        Complex auxramay13 = new Complex();
        Complex auxramay23 = new Complex();
        for (ix = 0; ix < this.ActSchematic.Components.size(); ++ix) {
            TempComponent = (comp)this.ActSchematic.Components.elementAt(ix);
            if (!(TempComponent instanceof ndb_comp) || !(TempNdb_comp = (ndb_comp)TempComponent).getctrla().equals(this.ctrla) && !this.ctrla.equals("ALL CONTROL AREAS") || !TempComponent.getactive() || !TempComponent.getvalid() || !(TempComponent instanceof ndb_1pol) || !TempComponent.getinservice()) continue;
            if (TempComponent instanceof ndb_inj) {
                ndb_inj TempInj = (ndb_inj)TempComponent;
                TempInj.setp(TempInj.getp0());
                con1 = this.numbus(TempInj.getcon2());
                if (!(TempInj instanceof Generator)) continue;
                TempGenerator = (Generator)TempInj;
                if (TempGenerator.getlf_type() != 3 && con1 == this.indic_bSL) {
                    PgbSL -= TempGenerator.getp0();
                }
                if (TempGenerator.getlf_type() != 3) continue;
                genAonbSL.addElement(TempGenerator);
                continue;
            }
            if (TempComponent instanceof Busbar || (con1 = this.numbus((Temp1pol = (ndb_1pol)TempComponent).getcon2())) != this.indic_bSL) continue;
            PgbSL += Temp1pol.getp0();
        }
        for (ix = 0; ix < genAonbSL.size(); ++ix) {
            TempGenerator = (Generator)genAonbSL.elementAt(ix);
            TempGenerator.setp((double)Math.round(PgbSL * 1000.0) / 1000.0);
            if (ix + 1 < genAonbSL.size()) {
                if (TempGenerator.getp() > TempGenerator.getpmax()) {
                    TempGenerator.setp(TempGenerator.getpmax());
                } else if (TempGenerator.getp() < TempGenerator.getpmin()) {
                    TempGenerator.setp(TempGenerator.getpmin());
                }
            }
            PgbSL -= TempGenerator.getp();
            TempGenerator.setp((double)Math.round(TempGenerator.getp() * 1000.0) / 1000.0);
        }
        this.Flujos = new double[this.numbran];
        for (ix = 0; ix < this.ActSchematic.Components.size(); ++ix) {
            TempComponent = (comp)this.ActSchematic.Components.elementAt(ix);
            if (!(TempComponent instanceof ndb_comp) || !(TempNdb_comp = (ndb_comp)TempComponent).getctrla().equals(this.ctrla) && !this.ctrla.equals("ALL CONTROL AREAS") || !TempComponent.getactive() || !TempComponent.getvalid() || !TempComponent.getinservice()) continue;
            if (TempComponent instanceof ndb_branch) {
                double p32;
                double p23;
                double p13;
                double p31;
                TempBran = (ndb_branch)TempComponent;
                con1 = this.numbus(TempBran.getcon1());
                if (con1 <= -1 || (con2 = this.numbus(TempBran.getcon2())) <= -1) continue;
                if (!this.halfFDLF) {
                    double auxd;
                    if (!(TempBran instanceof ThreeWindingTrafo)) {
                        auxd = 1.0 / this.BranchX[count] * (this.dk[con1] - this.dk[con2]);
                        p12 = (double)Math.round((auxd + this.BranchPLoss[count] / 2.0) * 10000.0) / 10000.0;
                        p21 = (double)Math.round((-auxd + this.BranchPLoss[count] / 2.0) * 10000.0) / 10000.0;
                        angulo = this.dk[con1] - this.dk[con2];
                        difere = 1.0 / this.BranchX[count];
                    }
                    if (TempBran instanceof ThreeWindingTrafo) {
                        con3 = this.numbus(TempBran.getcon3());
                        auxd = 1.0 / this.BranchX[count] * (this.dk[con1] - this.dk[con2]);
                        p12 = (double)Math.round((auxd + this.BranchPLoss[count] / 2.0) * 10000.0) / 10000.0;
                        p21 = (double)Math.round((-auxd + this.BranchPLoss[count] / 2.0) * 10000.0) / 10000.0;
                        angulo = this.dk[con1] - this.dk[con2];
                        difere = 1.0 / this.BranchX[count];
                        this.Flujos[count] = p12;
                        auxd = 1.0 / this.BranchX[++count] * (this.dk[con3] - this.dk[con1]);
                        p31 = (double)Math.round((auxd + this.BranchPLoss[count] / 2.0) * 10000.0) / 10000.0;
                        p13 = (double)Math.round((-auxd + this.BranchPLoss[count] / 2.0) * 10000.0) / 10000.0;
                        angulo = this.dk[con3] - this.dk[con1];
                        difere = 1.0 / this.BranchX[count];
                        this.Flujos[count] = p31;
                        auxd = 1.0 / this.BranchX[++count] * (this.dk[con2] - this.dk[con3]);
                        p23 = (double)Math.round((auxd + this.BranchPLoss[count] / 2.0) * 10000.0) / 10000.0;
                        p32 = (double)Math.round((-auxd + this.BranchPLoss[count] / 2.0) * 10000.0) / 10000.0;
                        angulo = this.dk[con2] - this.dk[con3];
                        difere = 1.0 / this.BranchX[count];
                        this.Flujos[count] = p23;
                        TempBran.setp12(p12);
                        TempBran.setq12(0.0);
                        TempBran.setp21(p21);
                        TempBran.setq21(0.0);
                        TempBran.setp13(p13);
                        TempBran.setq13(0.0);
                        TempBran.setp31(p31);
                        TempBran.setq31(0.0);
                        TempBran.setp23(p23);
                        TempBran.setq23(0.0);
                        TempBran.setp32(p32);
                        TempBran.setq32(0.0);
                    }
                } else {
                    ybr.re = this.BranchR[count];
                    ybr.im = this.BranchX[count];
                    ybr = Complex.divide((Complex)new Complex(1.0, 0.0), (Complex)ybr);
                    ysh2.re = 0.0;
                    ysh1.re = 0.0;
                    ysh1.im = ysh2.im = this.BranchB[count];
                    if (TempBran instanceof Trafo) {
                        Trafo TempTrafo = (Trafo)TempBran;
                        if (TempTrafo.gett_im() == 0.0) {
                            ysh2.add(Complex.multiply((Complex)ybr, (double)(1.0 - 1.0 / TempTrafo.gett_re())));
                            ysh1.add(Complex.multiply((Complex)ybr, (double)(1.0 - TempTrafo.gett_re())));
                            ysh1.divide(TempTrafo.gett_re() * TempTrafo.gett_re());
                            ybr = Complex.divide((Complex)ybr, (double)TempTrafo.gett_re());
                        } else {
                            timag = TempTrafo.gett_im() * Math.PI / 180.0;
                            ctimag = new Complex(Math.cos(timag), Math.sin(timag));
                            ysh2.add(Complex.multiply((Complex)ybr, (Complex)Complex.subtract((Complex)unidad, (Complex)Complex.divide((Complex)unidad, (Complex)ctimag))));
                            ysh1.add(Complex.multiply((Complex)ybr, (Complex)Complex.subtract((Complex)unidad, (Complex)ctimag)));
                            ybr12 = Complex.divide((Complex)ybr, (Complex)Complex.conjugate((Complex)ctimag));
                            ybr21 = Complex.divide((Complex)ybr, (Complex)ctimag);
                            avisador = 1.0;
                        }
                    }
                    v1.re = Math.cos(this.dk[con1]);
                    v1.im = Math.sin(this.dk[con1]);
                    v2.re = Math.cos(this.dk[con2]);
                    v2.im = Math.sin(this.dk[con2]);
                    Complex s1 = Complex.multiply((Complex)v1, (Complex)Complex.conjugate((Complex)Complex.multiply((Complex)v1, (Complex)ysh1)));
                    Complex s2 = Complex.multiply((Complex)v2, (Complex)Complex.conjugate((Complex)Complex.multiply((Complex)v2, (Complex)ysh2)));
                    Complex s12 = Complex.multiply((Complex)v1, (Complex)Complex.conjugate((Complex)Complex.multiply((Complex)Complex.subtract((Complex)v1, (Complex)v2), (Complex)ybr)));
                    Complex s21 = Complex.multiply((Complex)v2, (Complex)Complex.conjugate((Complex)Complex.multiply((Complex)Complex.subtract((Complex)v2, (Complex)v1), (Complex)ybr)));
                    if (TempBran instanceof Trafo && avisador == 1.0) {
                        s12 = Complex.multiply((Complex)v1, (Complex)Complex.conjugate((Complex)Complex.multiply((Complex)Complex.subtract((Complex)v1, (Complex)v2), (Complex)ybr12)));
                        s21 = Complex.multiply((Complex)v2, (Complex)Complex.conjugate((Complex)Complex.multiply((Complex)Complex.subtract((Complex)v2, (Complex)v1), (Complex)ybr21)));
                        avisador = 0.0;
                    }
                    p12 = (double)Math.round((s1.re + s12.re) * 10000.0) / 10000.0;
                    p21 = (double)Math.round((s2.re + s21.re) * 10000.0) / 10000.0;
                    if (TempBran instanceof ThreeWindingTrafo) {
                        con3 = this.numbus(TempBran.getcon3());
                        ThreeWindingTrafo TempThreeWindingTrafo = (ThreeWindingTrafo)TempBran;
                        ++rama;
                        fintrafo = count + 3;
                        v1.re = Math.cos(this.dk[con1]);
                        v1.im = Math.sin(this.dk[con1]);
                        v2.re = Math.cos(this.dk[con2]);
                        v2.im = Math.sin(this.dk[con2]);
                        v3.re = Math.cos(this.dk[con3]);
                        v3.im = Math.sin(this.dk[con3]);
                        tapchange1 = Complex.divide((Complex)new Complex(1.0, 0.0), (Complex)new Complex(TempThreeWindingTrafo.gett_re(), 0.0));
                        tapchange2 = Complex.divide((Complex)new Complex(1.0, 0.0), (Complex)new Complex(TempThreeWindingTrafo.gett_re1(), 0.0));
                        tapchange3 = Complex.divide((Complex)new Complex(1.0, 0.0), (Complex)new Complex(TempThreeWindingTrafo.gett_re2(), 0.0));
                        ramashunt = new Complex(0.0, this.BranchB[count]);
                        auxramay12 = new Complex(this.BranchR[count], this.BranchX[count]);
                        auxramay13 = new Complex(this.BranchR[count + 1], this.BranchX[count + 1]);
                        auxramay23 = new Complex(this.BranchR[count + 2], this.BranchX[count + 2]);
                        cY12 = new Complex(Complex.divide((Complex)unidad, (Complex)auxramay12));
                        cY13 = new Complex(Complex.divide((Complex)unidad, (Complex)auxramay13));
                        cY23 = new Complex(Complex.divide((Complex)unidad, (Complex)auxramay23));
                        sumY1 = Complex.add((Complex)cY12, (Complex)cY13);
                        sumY2 = Complex.add((Complex)cY12, (Complex)cY23);
                        sumY3 = Complex.add((Complex)cY13, (Complex)cY23);
                        if (TempThreeWindingTrafo.getlado() == "HV") {
                            sumY1 = Complex.add((Complex)sumY1, (Complex)ramashunt);
                        } else if (TempThreeWindingTrafo.getlado() == "MV") {
                            sumY2 = Complex.add((Complex)sumY2, (Complex)ramashunt);
                        } else if (TempThreeWindingTrafo.getlado() == "LV") {
                            sumY3 = Complex.add((Complex)sumY3, (Complex)ramashunt);
                        }
                        cY12 = Complex.negate((Complex)Complex.multiply((Complex)cY12, (Complex)Complex.multiply((Complex)tapchange1, (Complex)tapchange2)));
                        cY13 = Complex.negate((Complex)Complex.multiply((Complex)cY13, (Complex)Complex.multiply((Complex)tapchange1, (Complex)tapchange3)));
                        cY23 = Complex.negate((Complex)Complex.multiply((Complex)cY23, (Complex)Complex.multiply((Complex)tapchange2, (Complex)tapchange3)));
                        sumY1 = Complex.multiply((Complex)sumY1, (Complex)Complex.multiply((Complex)tapchange1, (Complex)tapchange1));
                        sumY2 = Complex.multiply((Complex)sumY2, (Complex)Complex.multiply((Complex)tapchange2, (Complex)tapchange2));
                        sumY3 = Complex.multiply((Complex)sumY3, (Complex)Complex.multiply((Complex)tapchange3, (Complex)tapchange3));
                        factor1 = Complex.add((Complex)sumY1, (Complex)Complex.add((Complex)cY12, (Complex)cY13));
                        factor2 = Complex.add((Complex)sumY2, (Complex)Complex.add((Complex)cY12, (Complex)cY23));
                        factor3 = Complex.add((Complex)sumY3, (Complex)Complex.add((Complex)cY13, (Complex)cY23));
                        s1 = Complex.multiply((Complex)v1, (Complex)Complex.conjugate((Complex)Complex.multiply((Complex)v1, (Complex)factor1)));
                        s2 = Complex.multiply((Complex)v2, (Complex)Complex.conjugate((Complex)Complex.multiply((Complex)v2, (Complex)factor2)));
                        Complex s3 = Complex.multiply((Complex)v3, (Complex)Complex.conjugate((Complex)Complex.multiply((Complex)v3, (Complex)factor3)));
                        s12 = Complex.multiply((Complex)v1, (Complex)Complex.conjugate((Complex)Complex.multiply((Complex)Complex.subtract((Complex)v1, (Complex)v2), (Complex)Complex.negate((Complex)cY12))));
                        s21 = Complex.multiply((Complex)v2, (Complex)Complex.conjugate((Complex)Complex.multiply((Complex)Complex.subtract((Complex)v2, (Complex)v1), (Complex)Complex.negate((Complex)cY12))));
                        Complex s13 = Complex.multiply((Complex)v1, (Complex)Complex.conjugate((Complex)Complex.multiply((Complex)Complex.subtract((Complex)v1, (Complex)v3), (Complex)Complex.negate((Complex)cY13))));
                        Complex s31 = Complex.multiply((Complex)v3, (Complex)Complex.conjugate((Complex)Complex.multiply((Complex)Complex.subtract((Complex)v3, (Complex)v1), (Complex)Complex.negate((Complex)cY13))));
                        Complex s23 = Complex.multiply((Complex)v2, (Complex)Complex.conjugate((Complex)Complex.multiply((Complex)Complex.subtract((Complex)v2, (Complex)v3), (Complex)Complex.negate((Complex)cY23))));
                        Complex s32 = Complex.multiply((Complex)v3, (Complex)Complex.conjugate((Complex)Complex.multiply((Complex)Complex.subtract((Complex)v3, (Complex)v2), (Complex)Complex.negate((Complex)cY23))));
                        p12 = (double)Math.round((s1.re / 2.0 + s12.re) * 10000.0) / 10000.0;
                        p21 = (double)Math.round((s2.re / 2.0 + s21.re) * 10000.0) / 10000.0;
                        p13 = (double)Math.round((s1.re / 2.0 + s13.re) * 10000.0) / 10000.0;
                        p31 = (double)Math.round((s3.re / 2.0 + s31.re) * 10000.0) / 10000.0;
                        p23 = (double)Math.round((s2.re / 2.0 + s23.re) * 10000.0) / 10000.0;
                        p32 = (double)Math.round((s3.re / 2.0 + s32.re) * 10000.0) / 10000.0;
                        TempBran.setp12(p12);
                        TempBran.setq12(0.0);
                        TempBran.setp21(p21);
                        TempBran.setq21(0.0);
                        TempBran.setp13(p13);
                        TempBran.setq13(0.0);
                        TempBran.setp31(p31);
                        TempBran.setq31(0.0);
                        TempBran.setp23(p23);
                        TempBran.setq23(0.0);
                        TempBran.setp32(p32);
                        TempBran.setq32(0.0);
                        this.Flujos[count] = p12;
                        this.Flujos[++count] = p13;
                        this.Flujos[++count] = p23;
                    }
                }
                if (!(TempBran instanceof ThreeWindingTrafo)) {
                    TempBran.setp12(p12);
                    TempBran.setp21(p21);
                    TempBran.setq12(0.0);
                    TempBran.setq21(0.0);
                    this.Flujos[count] = p12;
                    TempBran.setu1(TempBran.getun1());
                    TempBran.setu2(TempBran.getun2());
                    TempBran.setdelta2(this.dk[con1] * 180.0 / Math.PI);
                    TempBran.setdelta3(this.dk[con2] * 180.0 / Math.PI);
                }
                ++count;
                continue;
            }
            if (!(TempComponent instanceof Busbar)) continue;
            Busbar TempBusbar = (Busbar)TempComponent;
            TempBusbar.setdelta2((double)Math.round(this.dk[countbus] * 180.0 / Math.PI * 10000.0) / 10000.0);
            ++countbus;
        }
        for (ix = 0; ix < this.ActSchematic.Components.size(); ++ix) {
            TempComponent = (comp)this.ActSchematic.Components.elementAt(ix);
            if (!(TempComponent instanceof ndb_comp) || ((TempNdb_comp = (ndb_comp)TempComponent).getctrla().equals(this.ctrla) || this.ctrla.equals("ALL CONTROL AREAS")) && TempComponent.getactive() && TempComponent.getvalid() && TempComponent.getinservice()) continue;
            if (TempComponent instanceof ndb_branch) {
                TempBran = (ndb_branch)TempComponent;
                TempBran.setp12(0.0);
                TempBran.setq12(0.0);
                TempBran.setp21(0.0);
                TempBran.setq21(0.0);
                continue;
            }
            if (!(TempComponent instanceof ndb_1pol)) continue;
            Temp1pol = (ndb_1pol)TempComponent;
            Temp1pol.setp(0.0);
            Temp1pol.setq(0.0);
        }
    }

    private void verificarGrafo() throws Exception {
        int i;
        int[] grupnod1 = new int[this.numnod + 1];
        boolean[] ingrup1 = new boolean[this.numnod];
        grupnod1[0] = 1;
        grupnod1[1] = 0;
        ingrup1[0] = true;
        for (i = 1; i <= grupnod1[0]; ++i) {
            for (int j = 0; j < this.numnod; ++j) {
                if (!this.matCx[grupnod1[i]][j] || ingrup1[j]) continue;
                grupnod1[0] = grupnod1[0] + 1;
                grupnod1[grupnod1[0]] = j;
                ingrup1[j] = true;
            }
            if (grupnod1[0] == this.numnod) break;
        }
        if (grupnod1[0] < this.numnod) {
            for (i = 0; i < this.numnod && ingrup1[i]; ++i) {
            }
            Busbar TempBusbar = (Busbar)this.BusbarVector.elementAt(i);
            this.dcLF_Error("There\u00b4s an isolated Subystem; " + TempBusbar.getName() + "...");
        }
    }

    public void finalize() {
        this.matCx = null;
        this.Pinj = null;
        this.dk = null;
        this.Pk = null;
        this.BusbarVector = null;
        this.BranchI = null;
        this.BranchJ = null;
        this.BranchX = null;
        this.BranchR = null;
        this.BranchPLoss = null;
        this.B1 = null;
        this.LU_B1 = null;
        this.MxInvX = null;
        this.Pinj = null;
        this.Ybus = null;
        this.BranchB = null;
        this.Bbus = null;
        this.Gbus = null;
    }

    private void actualizar_Pk(double[] P, double[] ang, SparseMatrix G, SparseMatrix B) throws Exception {
        try {
            int i;
            for (i = 0; i < this.numnod; ++i) {
                this.e.setElementAt(i, Math.cos(ang[i]));
                this.f.setElementAt(i, Math.sin(ang[i]));
            }
            DenseVector eG = this.oper.multiply((MatrixI)G, (VectorI)this.e);
            DenseVector eB = this.oper.multiply((MatrixI)B, (VectorI)this.e);
            DenseVector fG = this.oper.multiply((MatrixI)G, (VectorI)this.f);
            DenseVector fB = this.oper.multiply((MatrixI)B, (VectorI)this.f);
            eG = this.oper.subtract((VectorI)eG, (VectorI)fB);
            eB = this.oper.add((VectorI)eB, (VectorI)fG);
            for (i = 0; i < this.numnod; ++i) {
                P[i] = this.e.elementAt(i) * eG.elementAt(i) + this.f.elementAt(i) * eB.elementAt(i);
            }
        }
        catch (Exception ex) {
            String msg = new String(ex + "on updating powers, incompatible dimensions");
            this.dcLF_Error(msg);
        }
    }

    public void closefile() {
        try {
            this.myPPrintStream.close();
            if (this.os != null) {
                this.os.close();
            }
        }
        catch (Exception e) {
            System.out.println("Error en close: " + e);
        }
    }
}

