/*
 * Decompiled with CFR 0.152.
 */
package de.core;

import JSci.maths.matrices.DoubleSquareMatrix;
import de.core.AnalysisTool;
import de.core.Busbar;
import de.core.CFuzzytra;
import de.core.DCLFFrame;
import de.core.DeepEdit;
import de.core.DeepEditFrame;
import de.core.Generator;
import de.core.Injection;
import de.core.JavaLFException;
import de.core.Line;
import de.core.Load;
import de.core.Schematic;
import de.core.SimpleDialog;
import de.core.Trafo;
import de.core.comp;
import de.core.ndb_1pol;
import de.core.ndb_branch;
import de.core.ndb_comp;
import de.core.ndb_inj;
import drasys.or.linear.algebra.Algebra;
import drasys.or.linear.algebra.CroutPivot;
import drasys.or.matrix.DenseVector;
import drasys.or.matrix.MatrixI;
import drasys.or.matrix.SparseMatrix;
import drasys.or.matrix.VectorI;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.StringTokenizer;
import java.util.Vector;

public final class DCFuzzyLFPorto
extends AnalysisTool {
    DCLFFrame MyDCLFFrame = null;
    String errorMsg = null;
    String ctrla = null;
    protected Vector BusbarVector;
    protected Vector GeneratorVector;
    protected Vector LoadVector;
    protected Vector LineVector;
    protected Vector TrafoVector;
    protected Vector DFuzzyVector;
    protected Vector PFuzzyVector;
    private DoubleSquareMatrix dsmA;
    private DoubleSquareMatrix dsmInvA;
    double[] BranchX;
    int[] BranchI;
    int[] BranchJ;
    String[] NameBranch;
    double[][] voltBranch;
    int numbran = 0;
    private double[][] MxInvX;
    private double[] Pinj;
    private int indic_bSL = -1;
    private double angref = 0.0;
    private int BarraRef = 0;
    private SparseMatrix B1;
    private boolean[][] matCx;
    final double eliminador = 1.0E200;
    private double[] dk;
    private double[] Pk;
    private double[][] PFuzzy;
    private double[][] DFuzzy;
    private double[][] A;
    private double[][] dA;
    private CroutPivot LU_B1;
    protected DeepEdit deepEdApp;
    PrintWriter myPrintStream;
    boolean borrar = true;
    int gen = 0;
    int genVecSlack = 0;

    public DCFuzzyLFPorto(DeepEdit deepApplet, Schematic sch) {
        super(sch);
        this.deepEdApp = deepApplet;
        System.out.println("---------- DC Load Flow Started ------------");
    }

    public void Calculate(String cctrla) {
        FileOutputStream os = null;
        String DCFuzzyPorto = WORK_FOLDER + File.separator + "DCFuzzyPorto.dat";
        this.ctrla = cctrla;
        String message = "Some problems, sorry!";
        try {
            AnalysisTool.CreateDirectory(WORK_FOLDER);
            os = new FileOutputStream(DCFuzzyPorto);
            this.getNetwork(os);
            this.ValoresFuzzy(os);
            this.calcular_DCLF();
            this.calcularDCFuzzyLF();
            this.calculaA(os);
            this.solveFlujos(os);
            this.writeresults();
            this.writeres(os);
            this.ActSchematic.Modified = false;
            this.ActSchematic.Modifiedstate = false;
            this.ActSchematic.changeGIS = true;
            DeepEdit.MySchematicPanel.repaint();
            os.close();
        }
        catch (Exception e) {
            message = this.errorMsg != null ? this.errorMsg : e.toString();
            String[] DlgButtons = new String[]{"OK"};
            SimpleDialog ExceptionDialog = new SimpleDialog(DeepEdit.frame, "DC Load Flow", message, DlgButtons, 1, 0, 0, 1);
        }
        try {
            os.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        this.DoListResults(DCFuzzyPorto);
        this.finalize();
        System.out.println("Termino DC Fuzzy LF Incremental");
    }

    public void getNetwork(FileOutputStream os) throws Exception {
        Line TempLine;
        ndb_comp TempNdb_comp;
        comp TempComponent;
        PrintWriter myPrintStream = new PrintWriter(os, true);
        int indicbus = 0;
        int ix = 0;
        int i = 0;
        boolean j = false;
        int count = 0;
        int con1 = 10000;
        int con2 = 10000;
        this.BusbarVector = new Vector();
        this.GeneratorVector = new Vector();
        this.LoadVector = new Vector();
        this.LineVector = new Vector();
        this.TrafoVector = new Vector();
        double ueb = 0.0;
        double res = 0.0;
        double z = 0.0;
        double reac = 0.0;
        double y1 = 0.0;
        double y2 = 0.0;
        this.numbran = 0;
        this.numnod = 0;
        for (ix = 0; ix < this.ActSchematic.Components.size(); ++ix) {
            TempComponent = (comp)this.ActSchematic.Components.elementAt(ix);
            if (!(TempComponent instanceof ndb_comp) || !(TempNdb_comp = (ndb_comp)TempComponent).getctrla().equals(this.ctrla) && !this.ctrla.equals("ALL CONTROL AREAS") || !TempComponent.getactive() || !TempComponent.getvalid() || !TempComponent.getinservice()) continue;
            if (TempComponent instanceof Busbar) {
                TempComponent.InformAllComponents();
                Busbar TempBusbar = (Busbar)TempComponent;
                if (this.numbus(TempComponent.getName()) != -1) {
                    this.dcLF_Error("There\u00b4s more than one busbar with name \"" + TempComponent.getName() + "\"");
                }
                this.BusbarVector.addElement(TempComponent);
                ++this.numnod;
                continue;
            }
            if (!(TempComponent instanceof ndb_branch)) continue;
            if (TempComponent instanceof Line) {
                TempLine = (Line)TempComponent;
                TempLine.InformPartner(TempLine.ConnComps1, TempLine.getx1(), TempLine.gety1(), 1);
                TempLine.InformPartner(TempLine.ConnComps2, TempLine.getx2(), TempLine.gety2(), 2);
                this.LineVector.addElement(TempLine);
                ++this.numlin;
            }
            if (TempComponent instanceof Trafo) {
                TempComponent.InformAllComponents();
                this.TrafoVector.addElement((Trafo)TempComponent);
                ++this.numtran;
            }
            ++this.numbran;
        }
        this.BranchX = new double[this.numbran];
        this.BranchI = new int[this.numbran];
        this.BranchJ = new int[this.numbran];
        this.NameBranch = new String[this.numbran];
        this.voltBranch = new double[this.numbran][2];
        this.slack = -1;
        this.ini_var_sist();
        indicbus = 0;
        int tipocomp = 0;
        String strcomp = "";
        if (this.numnod < 2) {
            this.dcLF_Error("Not valid System");
        }
        for (ix = 0; ix < this.ActSchematic.Components.size(); ++ix) {
            int indice;
            TempComponent = (comp)this.ActSchematic.Components.elementAt(ix);
            if (!(TempComponent instanceof ndb_comp) || !(TempNdb_comp = (ndb_comp)TempComponent).getctrla().equals(this.ctrla) && !this.ctrla.equals("ALL CONTROL AREAS") || !TempComponent.getactive() || !TempComponent.getvalid() || !TempComponent.getinservice()) continue;
            if (TempComponent instanceof Line) {
                TempLine = (Line)TempComponent;
                con1 = this.numbus(TempLine.getcon1());
                if (con1 > -1 && (con2 = this.numbus(TempLine.getcon2())) > -1) {
                    this.BranchX[count] = TempLine.getxx1() * TempLine.getlen() * this.getSref() / (TempLine.getun1() * TempLine.getun1());
                    this.BranchI[count] = con1;
                    this.BranchJ[count] = con2;
                    this.NameBranch[count] = TempLine.getName();
                    this.voltBranch[count][0] = TempLine.getu1();
                    myPrintStream.println("Voltaje " + TempLine.getName() + " : " + TempLine.getu1());
                    this.voltBranch[count][1] = TempLine.getu2();
                    if (Math.abs(this.BranchX[count]) < 1.0E-9) {
                        this.dcLF_Error("Line \"" + TempLine.getName() + "\"" + ", too low Reactance.");
                    }
                    double[] dArray = this.MxInvX[this.BranchJ[count]];
                    int n = this.BranchI[count];
                    dArray[n] = dArray[n] - 1.0 / this.BranchX[count];
                    double[] dArray2 = this.MxInvX[this.BranchI[count]];
                    int n2 = this.BranchJ[count];
                    dArray2[n2] = dArray2[n2] - 1.0 / this.BranchX[count];
                    double[] dArray3 = this.MxInvX[this.BranchI[count]];
                    int n3 = this.BranchI[count];
                    dArray3[n3] = dArray3[n3] + 1.0 / this.BranchX[count];
                    double[] dArray4 = this.MxInvX[this.BranchJ[count]];
                    int n4 = this.BranchJ[count];
                    dArray4[n4] = dArray4[n4] + 1.0 / this.BranchX[count];
                    this.matCx[this.BranchJ[count]][this.BranchI[count]] = true;
                    this.matCx[this.BranchI[count]][this.BranchJ[count]] = true;
                    ++count;
                    continue;
                }
                this.dcLF_Error("Line \"" + TempLine.getName() + "\"" + ", is not connected");
                continue;
            }
            if (TempComponent instanceof Trafo) {
                Trafo TempTrafo = (Trafo)TempComponent;
                TempTrafo.actualizet();
                con1 = this.numbus(TempTrafo.getcon1());
                if (con1 > -1 && (con2 = this.numbus(TempTrafo.getcon2())) > -1) {
                    ueb = TempTrafo.getun1() / TempTrafo.getun2() / (TempTrafo.getur1() / TempTrafo.getur2());
                    res = TempTrafo.getpcu() * 0.001 * ueb * ueb / TempTrafo.getsn() * this.getSref() / TempTrafo.getsn();
                    z = TempTrafo.getuk() * 0.01 * ueb * ueb * this.getSref() / TempTrafo.getsn();
                    reac = TempTrafo.getuk() >= 0.0 ? Math.sqrt(z * z - res * res) : -Math.sqrt(z * z - res * res);
                    this.BranchX[count] = reac / TempTrafo.gett_re();
                    this.BranchI[count] = con1;
                    this.BranchJ[count] = con2;
                    this.NameBranch[count] = TempTrafo.getName();
                    this.voltBranch[count][0] = TempTrafo.getu1();
                    this.voltBranch[count][1] = TempTrafo.getu2();
                    if (Math.abs(this.BranchX[count]) < 1.0E-9) {
                        this.dcLF_Error("Trafo \"" + TempTrafo.getName() + "\"" + ", too low Reactance.");
                    }
                    double[] dArray = this.MxInvX[this.BranchJ[count]];
                    int n = this.BranchI[count];
                    dArray[n] = dArray[n] - 1.0 / this.BranchX[count];
                    double[] dArray5 = this.MxInvX[this.BranchI[count]];
                    int n5 = this.BranchJ[count];
                    dArray5[n5] = dArray5[n5] - 1.0 / this.BranchX[count];
                    double[] dArray6 = this.MxInvX[this.BranchI[count]];
                    int n6 = this.BranchI[count];
                    dArray6[n6] = dArray6[n6] + 1.0 / this.BranchX[count];
                    double[] dArray7 = this.MxInvX[this.BranchJ[count]];
                    int n7 = this.BranchJ[count];
                    dArray7[n7] = dArray7[n7] + 1.0 / this.BranchX[count];
                    this.matCx[this.BranchJ[count]][this.BranchI[count]] = true;
                    this.matCx[this.BranchI[count]][this.BranchJ[count]] = true;
                    ++count;
                    continue;
                }
                this.dcLF_Error("Trafo \"" + TempTrafo.getName() + "\"" + ", is not properly connected.");
                continue;
            }
            if (!(TempComponent instanceof ndb_1pol)) continue;
            TempComponent.InformAllComponents();
            ndb_1pol Temp1pol = (ndb_1pol)TempComponent;
            double p0 = -Temp1pol.getp0() / this.getSref();
            if (Temp1pol instanceof Busbar) {
                tipocomp = 0;
                strcomp = "Busbar";
                indice = indicbus++;
                continue;
            }
            indice = this.numbus(Temp1pol.getcon2());
            if (Temp1pol instanceof Load) {
                this.LoadVector.addElement(TempComponent);
                tipocomp = 1;
                strcomp = "Load";
            } else if (Temp1pol instanceof Generator) {
                p0 = -p0;
                this.GeneratorVector.addElement(TempComponent);
                tipocomp = 4;
                strcomp = "Generator";
                ++this.gen;
                if (((Generator)TempComponent).getlf_type() == 3) {
                    this.genVecSlack = this.gen;
                }
            } else if (Temp1pol instanceof Injection) {
                p0 = -p0;
                tipocomp = 5;
                strcomp = "Injection";
            } else {
                this.dcLF_Error("There\u00b4s an unknown componenet in system");
            }
            if (indice == -1) {
                this.dcLF_Error(strcomp + " \"" + Temp1pol.getName() + "\"" + ", is not connected.");
            }
            if (tipocomp == 4 && Temp1pol.getlf_type() == 3) {
                if (this.slack > -1) {
                    if (this.indic_bSL != indice) {
                        Generator TempGenerator = (Generator)this.ActSchematic.Components.elementAt(this.slack);
                        strcomp = TempGenerator.getName();
                        this.dcLF_Error("There\u00b4s more than one slack busbar \"" + Temp1pol.getName() + "\" " + "\"" + strcomp + "\"");
                    }
                } else {
                    this.slack = ix;
                    this.indic_bSL = indice;
                    p0 = 0.0;
                }
            }
            int n = indice;
            this.Pinj[n] = this.Pinj[n] + p0;
        }
        System.out.println("Initial load finished.\n");
        System.out.print("Verifying Cx...");
        this.verificarGrafo();
        System.out.println(" OK.");
        if (this.slack < 0) {
            this.dcLF_Error("there\u00b4s not slack busbar in system");
        }
        for (i = 0; i < this.numnod; ++i) {
            this.dk[i] = this.angref;
            this.Pk[i] = this.Pinj[i];
        }
        this.Pk[this.indic_bSL] = 0.0;
        this.B1 = new SparseMatrix(this.MxInvX);
        this.B1.setElementAt(this.indic_bSL, this.indic_bSL, 1.0E200);
    }

    public int numbus(String Busbarname) {
        for (int ix = 0; ix < this.BusbarVector.size(); ++ix) {
            comp TempComponent = (comp)this.BusbarVector.elementAt(ix);
            if (TempComponent.getName().hashCode() != Busbarname.hashCode() || !TempComponent.getName().equals(Busbarname)) continue;
            return ix;
        }
        return -1;
    }

    private void ini_var_sist() {
        this.MxInvX = new double[this.numnod][this.numnod];
        this.matCx = new boolean[this.numnod][this.numnod];
        this.Pinj = new double[this.numnod];
        this.Pk = new double[this.numnod];
        this.dk = new double[this.numnod];
    }

    void dcLF_Error(String mensaje) throws JavaLFException {
        StringTokenizer st = new StringTokenizer(mensaje, ":");
        mensaje = st.nextToken();
        throw new JavaLFException(mensaje);
    }

    private void calcular_DCLF() throws Exception {
        try {
            this.LU_B1 = new CroutPivot((MatrixI)this.B1);
        }
        catch (Exception ex) {
            String msg = new String(ex + "Singular Linear System occur during calculation");
            this.dcLF_Error(msg);
        }
        this.sol_lin(this.LU_B1, this.B1, this.dk, this.Pk);
        System.out.println("Calculating Process Finished.");
        this.dk[this.indic_bSL] = 0.0;
        for (int i = 0; i < this.numnod; ++i) {
            int n = this.indic_bSL;
            this.Pk[n] = this.Pk[n] - this.MxInvX[this.indic_bSL][i] * (this.dk[this.indic_bSL] - this.dk[i]);
        }
    }

    private void sol_lin(CroutPivot LU, SparseMatrix A, double[] dk, double[] pk) throws Exception {
        Algebra oper = new Algebra();
        DenseVector b = new DenseVector(pk);
        DenseVector x = new DenseVector();
        DenseVector Db = new DenseVector();
        DenseVector Dx = new DenseVector();
        try {
            x = LU.solveEquations((VectorI)b);
            DenseVector bk = oper.multiply((MatrixI)A, (VectorI)x);
            Db = oper.subtract((VectorI)b, (VectorI)bk);
            Dx = LU.solveEquations((VectorI)Db);
            x = oper.add((VectorI)x, (VectorI)Dx);
            for (int i = 0; i < dk.length; ++i) {
                dk[i] = x.elementAt(i);
            }
        }
        catch (Exception ex) {
            String msg = new String(ex + "On linear system calculation on iter:");
            this.dcLF_Error(msg);
        }
    }

    private void writeresults() {
        ndb_branch TempBran;
        ndb_1pol Temp1pol;
        Generator TempGenerator;
        ndb_comp TempNdb_comp;
        comp TempComponent;
        int ix = 0;
        int count = 0;
        int con1 = 0;
        int con2 = 0;
        Vector<Generator> genAonbSL = new Vector<Generator>();
        double PgbSL = this.Pk[this.indic_bSL] * this.getSref();
        for (ix = 0; ix < this.ActSchematic.Components.size(); ++ix) {
            TempComponent = (comp)this.ActSchematic.Components.elementAt(ix);
            if (!(TempComponent instanceof ndb_comp) || !(TempNdb_comp = (ndb_comp)TempComponent).getctrla().equals(this.ctrla) && !this.ctrla.equals("ALL CONTROL AREAS") || !TempComponent.getactive() || !TempComponent.getvalid() || !(TempComponent instanceof ndb_1pol) || !TempComponent.getinservice()) continue;
            if (TempComponent instanceof ndb_inj) {
                ndb_inj TempInj = (ndb_inj)TempComponent;
                TempInj.setp(TempInj.getp0());
                con1 = this.numbus(TempInj.getcon2());
                if (!(TempInj instanceof Generator)) continue;
                TempGenerator = (Generator)TempInj;
                if (TempGenerator.getlf_type() != 3 && con1 == this.indic_bSL) {
                    PgbSL -= TempGenerator.getp0();
                }
                if (TempGenerator.getlf_type() != 3) continue;
                genAonbSL.addElement(TempGenerator);
                continue;
            }
            if (TempComponent instanceof Busbar || (con1 = this.numbus((Temp1pol = (ndb_1pol)TempComponent).getcon2())) != this.indic_bSL) continue;
            PgbSL += Temp1pol.getp0();
        }
        for (ix = 0; ix < genAonbSL.size(); ++ix) {
            TempGenerator = (Generator)genAonbSL.elementAt(ix);
            TempGenerator.setp(PgbSL);
            if (ix + 1 < genAonbSL.size()) {
                if (TempGenerator.getp() > TempGenerator.getpmax()) {
                    TempGenerator.setp(TempGenerator.getpmax());
                } else if (TempGenerator.getp() < TempGenerator.getpmin()) {
                    TempGenerator.setp(TempGenerator.getpmin());
                }
            }
            PgbSL -= TempGenerator.getp();
            TempGenerator.setp((double)Math.round(TempGenerator.getp() * 1000000.0) / 1000000.0);
        }
        for (ix = 0; ix < this.ActSchematic.Components.size(); ++ix) {
            TempComponent = (comp)this.ActSchematic.Components.elementAt(ix);
            if (!(TempComponent instanceof ndb_comp) || !(TempNdb_comp = (ndb_comp)TempComponent).getctrla().equals(this.ctrla) && !this.ctrla.equals("ALL CONTROL AREAS") || !TempComponent.getactive() || !TempComponent.getvalid() || !TempComponent.getinservice() || !(TempComponent instanceof ndb_branch) || (con1 = this.numbus((TempBran = (ndb_branch)TempComponent).getcon1())) <= -1 || (con2 = this.numbus(TempBran.getcon2())) <= -1) continue;
            double auxd = 1.0 / this.BranchX[count] * (this.dk[con1] - this.dk[con2]);
            double p12 = (double)Math.round(auxd * 10000.0) / 10000.0;
            double p21 = (double)Math.round(-auxd * 10000.0) / 10000.0;
            TempBran.setp12(p12);
            TempBran.setp21(p21);
            TempBran.setq12(0.0);
            TempBran.setq21(0.0);
            ++count;
        }
        for (ix = 0; ix < this.ActSchematic.Components.size(); ++ix) {
            TempComponent = (comp)this.ActSchematic.Components.elementAt(ix);
            if (!(TempComponent instanceof ndb_comp) || ((TempNdb_comp = (ndb_comp)TempComponent).getctrla().equals(this.ctrla) || this.ctrla.equals("ALL CONTROL AREAS")) && TempComponent.getactive() && TempComponent.getvalid() && TempComponent.getinservice()) continue;
            if (TempComponent instanceof ndb_branch) {
                TempBran = (ndb_branch)TempComponent;
                TempBran.setp12(0.0);
                TempBran.setq12(0.0);
                TempBran.setp21(0.0);
                TempBran.setq21(0.0);
                continue;
            }
            if (!(TempComponent instanceof ndb_1pol)) continue;
            Temp1pol = (ndb_1pol)TempComponent;
            Temp1pol.setp(0.0);
            Temp1pol.setq(0.0);
        }
    }

    public static String numformat(double num, int ltot, int lmant) {
        int i;
        double precs = Math.pow(10.0, lmant);
        num = (double)Math.round(num * precs) / precs;
        String numero = "" + num;
        StringTokenizer st = new StringTokenizer(numero, ".");
        String pent = st.nextToken();
        String pfrac = st.nextToken();
        for (i = pfrac.length(); i < lmant; ++i) {
            pfrac = pfrac + "0";
        }
        for (i = pent.length() + lmant + 1; i < ltot; ++i) {
            pent = " " + pent;
        }
        return pent + "." + pfrac;
    }

    private void verificarGrafo() throws Exception {
        int i;
        int[] grupnod1 = new int[this.numnod + 1];
        boolean[] ingrup1 = new boolean[this.numnod];
        grupnod1[0] = 1;
        grupnod1[1] = 0;
        ingrup1[0] = true;
        for (i = 1; i <= grupnod1[0]; ++i) {
            for (int j = 0; j < this.numnod; ++j) {
                if (!this.matCx[grupnod1[i]][j] || ingrup1[j]) continue;
                grupnod1[0] = grupnod1[0] + 1;
                grupnod1[grupnod1[0]] = j;
                ingrup1[j] = true;
            }
            if (grupnod1[0] == this.numnod) break;
        }
        if (grupnod1[0] < this.numnod) {
            for (i = 0; i < this.numnod && ingrup1[i]; ++i) {
            }
            Busbar TempBusbar = (Busbar)this.BusbarVector.elementAt(i);
            this.dcLF_Error("There\u00b4s an isolated Subystem; " + TempBusbar.getName() + "...");
        }
    }

    public void finalize() {
        this.matCx = null;
        this.Pinj = null;
        this.dk = null;
        this.Pk = null;
        this.BusbarVector = null;
        this.BranchI = null;
        this.BranchJ = null;
        this.BranchX = null;
        this.B1 = null;
        this.LU_B1 = null;
        this.MxInvX = null;
        this.Pinj = null;
    }

    public void calcularDCFuzzyLF() {
        double[] Dvar = new double[this.numnod];
        double[] PotVar = new double[this.numnod];
        this.DFuzzy = new double[this.numnod][5];
        this.dk[this.indic_bSL] = 0.0;
        this.agregaColumna(this.DFuzzy, this.dk, 4);
        try {
            for (int i = 0; i < 4; ++i) {
                this.calcVarPot(PotVar, this.columnaArreglo(this.PFuzzy, i), this.columnaArreglo(this.PFuzzy, 4));
                this.sol_lin(this.LU_B1, this.B1, Dvar, PotVar);
                System.out.println("Calculating Process Finished.");
                Dvar[this.indic_bSL] = 0.0;
                this.agregaColumna(this.DFuzzy, Dvar, i);
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
    }

    public void ValoresFuzzy(FileOutputStream os) {
        PrintWriter myPrintStream = new PrintWriter(os, true);
        this.PFuzzy = new double[this.numnod][5];
        try {
            SimpleDialog ExceptionDialog;
            String[] DlgButtons;
            double medioP;
            int indice;
            String nombre;
            double Pdd;
            double Pcc;
            double Pbb;
            double Paa;
            Statement stmt = DeepEditFrame.conFuzzy.createStatement();
            String query = "SELECT * FROM Generator";
            ResultSet rs = stmt.executeQuery(query);
            boolean more = rs.next();
            while (more) {
                Paa = Double.valueOf(rs.getString("Pa")) / this.getSref();
                Pbb = Double.valueOf(rs.getString("Pb")) / this.getSref();
                Pcc = Double.valueOf(rs.getString("Pc")) / this.getSref();
                Pdd = Double.valueOf(rs.getString("Pd")) / this.getSref();
                nombre = rs.getString("Name");
                indice = this.numbusgen(nombre);
                medioP = (Paa + Pbb + Pcc + Pdd) / 4.0;
                if (indice == -1) {
                    DlgButtons = new String[]{"OK"};
                    ExceptionDialog = new SimpleDialog(DeepEdit.frame, "1- JavaFuzzyLF Read", "Barra asociada a " + nombre + " no existe!!!", DlgButtons, 1, 0, 0, 1);
                } else {
                    double[] dArray = this.PFuzzy[indice];
                    dArray[0] = dArray[0] + Paa;
                    double[] dArray2 = this.PFuzzy[indice];
                    dArray2[1] = dArray2[1] + Pbb;
                    double[] dArray3 = this.PFuzzy[indice];
                    dArray3[2] = dArray3[2] + Pcc;
                    double[] dArray4 = this.PFuzzy[indice];
                    dArray4[3] = dArray4[3] + Pdd;
                    double[] dArray5 = this.PFuzzy[indice];
                    dArray5[4] = dArray5[4] + medioP;
                }
                more = rs.next();
            }
            this.PFuzzy[this.BarraRef][0] = 0.0;
            this.PFuzzy[this.BarraRef][1] = 0.0;
            this.PFuzzy[this.BarraRef][2] = 0.0;
            this.PFuzzy[this.BarraRef][3] = 0.0;
            this.PFuzzy[this.BarraRef][4] = 0.0;
            rs.close();
            query = "SELECT * FROM Load";
            rs = stmt.executeQuery(query);
            more = rs.next();
            while (more) {
                Paa = Double.valueOf(rs.getString("Pa")) / this.getSref();
                Pbb = Double.valueOf(rs.getString("Pb")) / this.getSref();
                Pcc = Double.valueOf(rs.getString("Pc")) / this.getSref();
                Pdd = Double.valueOf(rs.getString("Pd")) / this.getSref();
                nombre = rs.getString("Name");
                indice = this.numbusload(nombre);
                medioP = (Paa + Pbb + Pcc + Pdd) / 4.0;
                if (indice == -1) {
                    DlgButtons = new String[]{"OK"};
                    ExceptionDialog = new SimpleDialog(DeepEdit.frame, "2- JavaFuzzyLF Read", "Barra " + nombre + " no existe!!!", DlgButtons, 1, 0, 0, 1);
                } else {
                    double[] dArray = this.PFuzzy[indice];
                    dArray[0] = dArray[0] - Pdd;
                    double[] dArray6 = this.PFuzzy[indice];
                    dArray6[1] = dArray6[1] - Pcc;
                    double[] dArray7 = this.PFuzzy[indice];
                    dArray7[2] = dArray7[2] - Pbb;
                    double[] dArray8 = this.PFuzzy[indice];
                    dArray8[3] = dArray8[3] - Paa;
                    double[] dArray9 = this.PFuzzy[indice];
                    dArray9[4] = dArray9[4] - medioP;
                }
                more = rs.next();
            }
            rs.close();
            stmt.close();
        }
        catch (Exception e) {
            String message = e.toString();
            String[] DlgButtons = new String[]{"OK"};
            SimpleDialog ExceptionDialog = new SimpleDialog(DeepEdit.frame, "DCFuzzyLFPorto", message, DlgButtons, 1, 0, 0, 1);
            return;
        }
    }

    public int numbusgen(String Genname) {
        for (int ix = 0; ix < this.GeneratorVector.size(); ++ix) {
            comp TempComponent = (comp)this.GeneratorVector.elementAt(ix);
            if (!(TempComponent instanceof ndb_inj) || !Genname.equals(TempComponent.getName())) continue;
            ndb_inj TempInj = (ndb_inj)TempComponent;
            TempInj.InformAllComponents();
            if (TempInj.getlf_type() == 3) {
                this.BarraRef = this.numbus(TempInj.getcon2());
                return this.BarraRef;
            }
            return this.numbus(TempInj.getcon2());
        }
        System.out.println("Error en NUMBUSGEN");
        return -1;
    }

    public int numbusload(String Loadname) {
        for (int ix = 0; ix < this.LoadVector.size(); ++ix) {
            comp TempComponent = (comp)this.LoadVector.elementAt(ix);
            if (!(TempComponent instanceof Load) || !Loadname.equals(TempComponent.getName())) continue;
            Load TempLoad = (Load)TempComponent;
            TempLoad.InformAllComponents();
            return this.numbus(TempLoad.getcon2());
        }
        System.out.println("Error en NUMBUSLOAD");
        return -1;
    }

    public void printMatrixDouble(FileOutputStream os, double[][] m, int ii, int jj) {
        PrintWriter myPrintStream = new PrintWriter(os, true);
        for (int i = 0; i < ii; ++i) {
            for (int j = 0; j < jj; ++j) {
                myPrintStream.print(m[i][j] + "\t \t \t");
            }
            myPrintStream.println();
        }
        myPrintStream.println();
    }

    public double[] columnaArreglo(double[][] m, int j) {
        double[] res = new double[this.numnod];
        for (int i = 0; i < this.numnod; ++i) {
            res[i] = m[i][j];
        }
        return res;
    }

    public void agregaColumna(double[][] m, double[] a, int n) {
        for (int i = 0; i < this.numnod; ++i) {
            m[i][n] = a[i];
        }
    }

    public void sumaArreglos(double[] a, double[] b) {
        for (int i = 0; i < a.length; ++i) {
            int n = i;
            a[n] = a[n] + b[i];
        }
    }

    public double[] restaArreglos(double[] a, double[] b) {
        double[] res = new double[this.numnod];
        for (int i = 0; i < a.length; ++i) {
            res[i] = a[i] - b[i];
        }
        return res;
    }

    private void calcVarPot(double[] DXv, double[] Xdat, double[] X) {
        for (int i = 0; i < X.length; ++i) {
            DXv[i] = Xdat[i] - X[i];
        }
    }

    public void writeres(FileOutputStream os) {
        PrintWriter myPrintStream = new PrintWriter(os, true);
        int contA = 0;
        CFuzzytra tempGen = new CFuzzytra();
        this.borrar = true;
        myPrintStream.println();
        myPrintStream.println("Flujos de Potencia [MW]");
        for (int i = 0; i < this.numbran; ++i) {
            int ii = this.BranchI[i];
            int jj = this.BranchJ[i];
            String nombre = this.NameBranch[i];
            double v1 = this.voltBranch[i][0];
            double v2 = this.voltBranch[i][1];
            Busbar TempBusbar1 = (Busbar)this.BusbarVector.elementAt(ii);
            Busbar TempBusbar2 = (Busbar)this.BusbarVector.elementAt(jj);
            double flu = this.getSref() * (1.0 / this.BranchX[i]) * (this.DFuzzy[ii][4] - this.DFuzzy[jj][4]);
            myPrintStream.println(TempBusbar1.getName() + "-" + TempBusbar2.getName() + " -> " + DCFuzzyLFPorto.numformat(flu, 9, 4) + " [MW] - " + DCFuzzyLFPorto.numformat(flu / this.getSref(), 9, 4) + " pu");
            double[] dArray = this.dA[contA];
            dArray[0] = dArray[0] + flu / this.getSref();
            double[] dArray2 = this.dA[contA];
            dArray2[1] = dArray2[1] + flu / this.getSref();
            double[] dArray3 = this.dA[contA];
            dArray3[2] = dArray3[2] + flu / this.getSref();
            double[] dArray4 = this.dA[contA];
            dArray4[3] = dArray4[3] + flu / this.getSref();
            CFuzzytra tempF1 = new CFuzzytra(this.dA[contA][0], this.dA[contA][1], this.dA[contA][2], this.dA[contA][3]);
            tempF1.pond(this.getSref());
            if (!tempF1.isRigth()) {
                tempF1.inv();
            }
            if (ii == this.BarraRef) {
                tempGen.add(tempF1);
            }
            if (jj == this.BarraRef) {
                tempGen.sub(tempF1);
            }
            if (i == this.numbran - 1) {
                Generator TempGenerator = (Generator)this.GeneratorVector.elementAt(this.genVecSlack);
                myPrintStream.println("Gen Slack " + TempGenerator.getName() + " : " + tempGen);
            }
            try {
                this.SaveDBFuzzyLine(nombre, TempBusbar1.getName(), TempBusbar2.getName(), tempF1.a, tempF1.b, tempF1.c, tempF1.d, v1, v2);
            }
            catch (Exception e) {
                // empty catch block
            }
            ++contA;
        }
    }

    public void SaveDBFuzzyLine(String name, String bus1, String bus2, double a, double b, double c, double d, double v1, double v2) throws SQLException {
        String query;
        int x = 0;
        Statement stmt = DeepEditFrame.conFuzzy.createStatement();
        if (this.borrar) {
            query = "DELETE * FROM LineFuzzyPorto";
            x = stmt.executeUpdate(query);
        }
        this.borrar = false;
        query = "INSERT INTO LineFuzzyPorto (Name,c1,c2,Pa,Pb,Pc,Pd,V1,V2) VALUES ('" + name + "','" + bus1 + "','" + bus2 + "'," + DCFuzzyLFPorto.numformat(a, 9, 2) + "," + DCFuzzyLFPorto.numformat(b, 9, 2) + "," + DCFuzzyLFPorto.numformat(c, 9, 2) + "," + DCFuzzyLFPorto.numformat(d, 9, 2) + "," + DCFuzzyLFPorto.numformat(v1, 9, 2) + "," + DCFuzzyLFPorto.numformat(v2, 9, 2) + ")";
        x = stmt.executeUpdate(query);
        stmt.close();
    }

    public void SaveDBFuzzyGen(String name, CFuzzytra F) throws SQLException {
        int x = 0;
        int c = 0;
        Statement stmt = DeepEditFrame.conFuzzy.createStatement();
        String query = "INSERT INTO Generator (Name,Pa,Pb,Pc,Pd,Qa,Qb,Qc,Qd) VALUES ('" + name + "'," + DCFuzzyLFPorto.numformat(F.a, 9, 2) + "," + DCFuzzyLFPorto.numformat(F.b, 9, 2) + "," + DCFuzzyLFPorto.numformat(F.c, 9, 2) + "," + DCFuzzyLFPorto.numformat(F.d, 9, 2) + "," + c + "," + c + "," + c + "," + c + ")";
        x = stmt.executeUpdate(query);
        stmt.close();
    }

    public void calculaA(FileOutputStream os) {
        PrintWriter myPrintStream = new PrintWriter(os, true);
        int ij = 0;
        double aig = 0.0;
        double ajg = 0.0;
        double[][] aux = this.MxInvX;
        this.eliminaSlack(aux);
        this.dsmA = new DoubleSquareMatrix(aux);
        DoubleSquareMatrix BB = (DoubleSquareMatrix)this.dsmA.inverse();
        this.A = new double[this.numlin + this.numtran][this.numnod];
        for (int i = 0; i < this.numbran; ++i) {
            Busbar tempB1 = (Busbar)this.BusbarVector.elementAt(this.BranchI[i]);
            Busbar tempB2 = (Busbar)this.BusbarVector.elementAt(this.BranchJ[i]);
            for (int g = 0; g < this.numnod; ++g) {
                aig = BB.getElement(this.BranchI[i], g);
                ajg = BB.getElement(this.BranchJ[i], g);
                this.A[ij][g] = (aig - ajg) / this.BranchX[i];
            }
            ++ij;
        }
    }

    public void solveFlujos(FileOutputStream os) {
        PrintWriter myPrintStream = new PrintWriter(os, true);
        SparseMatrix AA = new SparseMatrix(this.A);
        Algebra Alg = new Algebra();
        this.dA = new double[this.numlin + this.numtran][4];
        try {
            for (int i = 0; i < 4; ++i) {
                DenseVector p = new DenseVector(this.restaArreglos(this.columnaArreglo(this.PFuzzy, i), this.columnaArreglo(this.PFuzzy, 4)));
                DenseVector x = new DenseVector();
                x = Alg.multiply((MatrixI)AA, (VectorI)p);
                for (int j = 0; j < this.numbran; ++j) {
                    this.dA[j][i] = x.elementAt(j);
                }
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
    }

    public void eliminaSlack(double[][] B) {
        B[this.indic_bSL][this.indic_bSL] = 1.0E200;
    }
}

