/*
 * Decompiled with CFR 0.152.
 */
package de.core;

import JSci.maths.Complex;
import JSci.maths.matrices.DoubleMatrix;
import JSci.maths.matrices.DoubleSquareMatrix;
import de.core.AnalysisTool;
import de.core.Busbar;
import de.core.CFuzzytri;
import de.core.DeepEdit;
import de.core.DeepEditFrame;
import de.core.FuzzyLinearSystem2;
import de.core.Generator;
import de.core.Line;
import de.core.Load;
import de.core.Schematic;
import de.core.SimpleDialog;
import de.core.Trafo;
import de.core.comp;
import de.core.ndb_branch;
import de.core.ndb_inj;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.StringTokenizer;
import java.util.Vector;

public class DCFuzzyLF
extends AnalysisTool {
    FuzzyLinearSystem2 FLS;
    String ctrla = null;
    double[][] MatB;
    double[][] MatBRed;
    double[][] PFuzzy;
    double[][] PFuzzyRed;
    double[][] ResFuzzy;
    int numi = 0;
    protected Vector BusbarVectorI;
    protected Vector GeneratorVectorI;
    protected Vector LoadVectorI;
    protected Vector LineVectorI;
    protected Vector TrafoVectorI;
    protected Vector TFuzzyVector;
    String[] NameBranch;
    double[][] voltBranch;
    int numbran = 0;
    int numnod = 0;
    int numload = 0;
    int numgen = 0;
    int BarraRef = 0;
    double[] BranchX;
    int[] BranchI;
    int[] BranchJ;
    int[] VarNode;
    int cont = 0;
    String query;
    Statement stmt;
    Statement stmt1;
    ResultSet rs;
    boolean more;
    boolean borrar = true;
    PrintStream myPrintStream;

    public DCFuzzyLF(Schematic sch, DeepEditFrame DF) {
        super(sch, DF);
        System.out.println("---------- In Equivalent Calculation Tool ------------");
    }

    public void Calculate(String cctrla) {
        FileOutputStream os;
        double aa = 0.0;
        double bb = 0.0;
        double cc = 0.0;
        double dd = 0.0;
        double medio = 0.0;
        double aux1 = 0.0;
        double aux2 = 0.0;
        String nombre = "";
        int indice = 0;
        this.ctrla = cctrla;
        String DCFuzzy = WORK_FOLDER + File.separator + "DCFuzzy.dat";
        this.FLS = new FuzzyLinearSystem2();
        try {
            os = new FileOutputStream(DCFuzzy);
            this.myPrintStream = new PrintStream(os);
            this.InitNetwork(os);
            this.PFuzzy = new double[this.numnod][3];
            for (int i = 0; i < this.numnod; ++i) {
                for (int j = 0; j < 3; ++j) {
                    this.PFuzzy[i][j] = 0.0;
                }
            }
            this.stmt = DeepEditFrame.conFuzzy.createStatement();
            this.query = "SELECT * FROM Generator";
            this.rs = this.stmt.executeQuery(this.query);
            this.more = this.rs.next();
            while (this.more) {
                aa = Double.valueOf(this.rs.getString("Pa")) / this.getSref();
                bb = Double.valueOf(this.rs.getString("Pb")) / this.getSref();
                cc = Double.valueOf(this.rs.getString("Pc")) / this.getSref();
                dd = Double.valueOf(this.rs.getString("Pd")) / this.getSref();
                nombre = this.rs.getString("Name");
                indice = this.numbusgen(nombre);
                medio = (aa + bb + cc + dd) / 4.0;
                if (indice == 1000) {
                    String[] DlgButtons = new String[]{"OK"};
                    SimpleDialog ExceptionDialog = new SimpleDialog(DeepEdit.frame, "1- DCFuzzyLF Read", "Barra asociada a " + nombre + " no existe!!!", DlgButtons, 1, 0, 0, 1);
                } else {
                    double[] dArray = this.PFuzzy[indice];
                    dArray[0] = dArray[0] + aa;
                    double[] dArray2 = this.PFuzzy[indice];
                    dArray2[1] = dArray2[1] + medio;
                    double[] dArray3 = this.PFuzzy[indice];
                    dArray3[2] = dArray3[2] + dd;
                }
                this.more = this.rs.next();
            }
            this.PFuzzy[this.BarraRef][0] = 0.0;
            this.PFuzzy[this.BarraRef][1] = 0.0;
            this.PFuzzy[this.BarraRef][2] = 0.0;
            this.rs.close();
            this.query = "SELECT * FROM Load";
            this.rs = this.stmt.executeQuery(this.query);
            this.more = this.rs.next();
            while (this.more) {
                aa = Double.valueOf(this.rs.getString("Pa")) / this.getSref();
                bb = Double.valueOf(this.rs.getString("Pb")) / this.getSref();
                cc = Double.valueOf(this.rs.getString("Pc")) / this.getSref();
                dd = Double.valueOf(this.rs.getString("Pd")) / this.getSref();
                nombre = this.rs.getString("Name");
                indice = this.numbusload(nombre);
                medio = (aa + bb + cc + dd) / 4.0;
                if (indice == 1000) {
                    String[] DlgButtons = new String[]{"OK"};
                    SimpleDialog ExceptionDialog = new SimpleDialog(DeepEdit.frame, "2- DCFuzzyLF Read", "Barra " + nombre + " no existe!!!", DlgButtons, 1, 0, 0, 1);
                } else {
                    double[] dArray = this.PFuzzy[indice];
                    dArray[0] = dArray[0] - dd;
                    double[] dArray4 = this.PFuzzy[indice];
                    dArray4[1] = dArray4[1] - medio;
                    double[] dArray5 = this.PFuzzy[indice];
                    dArray5[2] = dArray5[2] - aa;
                }
                this.more = this.rs.next();
            }
            this.rs.close();
            this.stmt.close();
        }
        catch (Exception e) {
            String message = e.toString();
            String[] DlgButtons = new String[]{"OK"};
            SimpleDialog ExceptionDialog = new SimpleDialog(DeepEdit.frame, "DCFuzzyLF", message, DlgButtons, 1, 0, 0, 1);
            return;
        }
        this.myPrintStream.println("la barra de Referencia es : " + this.BarraRef);
        this.BRED(this.MatB);
        this.PotRed();
        this.ResFuzzy = new double[this.numnod - 1][3];
        this.ResFuzzy = this.FLS.solveSystem(this.MatBRed, this.PFuzzyRed);
        this.creaVectorTheta();
        for (int ind = 0; ind < this.numbran; ++ind) {
            this.ValorFinalPotencia((CFuzzytri)this.TFuzzyVector.elementAt(this.BranchI[ind]), (CFuzzytri)this.TFuzzyVector.elementAt(this.BranchJ[ind]), this.MatB, ind);
        }
        this.borrar = true;
        try {
            if (os != null) {
                os.close();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        this.DoListResults(DCFuzzy);
        System.out.println("Termino DC Fuzzy LF");
    }

    public void InitNetwork(FileOutputStream os) {
        Line TempLine;
        comp TempComponent;
        this.myPrintStream.println("Datos, System Name:  " + this.ActSchematic.getsysname());
        int ix = 0;
        boolean i = false;
        boolean j = false;
        int count = 0;
        int con1 = 10000;
        int con2 = 10000;
        this.BusbarVectorI = new Vector();
        this.GeneratorVectorI = new Vector();
        this.LoadVectorI = new Vector();
        this.LineVectorI = new Vector();
        this.TrafoVectorI = new Vector();
        double ueb = 0.0;
        double res = 0.0;
        double z = 0.0;
        double reac = 0.0;
        double yy = 0.0;
        double y1 = 0.0;
        double y2 = 0.0;
        double b = 0.0;
        for (ix = 0; ix < this.ActSchematic.Components.size(); ++ix) {
            TempComponent = (comp)this.ActSchematic.Components.elementAt(ix);
            if (!TempComponent.getactive() || !TempComponent.getvalid() || !TempComponent.getinservice()) continue;
            if (TempComponent instanceof Busbar) {
                TempComponent.InformAllComponents();
                Busbar TempBusbar = (Busbar)TempComponent;
                if (TempBusbar.getctrla().equals(this.ctrla) || this.ctrla.equals("ALL CONTROL AREAS")) {
                    this.myPrintStream.println(this.numnod + "\t" + TempComponent.getName() + "\t" + TempBusbar.getctrla() + "\t" + "Barra Considerada");
                    ++this.numnod;
                    this.BusbarVectorI.addElement(TempComponent);
                }
            }
            if (TempComponent instanceof Generator) {
                this.GeneratorVectorI.addElement(TempComponent);
                ++this.numgen;
            }
            if (TempComponent instanceof Load) {
                this.LoadVectorI.addElement(TempComponent);
                ++this.numload;
            }
            if (!(TempComponent instanceof ndb_branch)) continue;
            if (TempComponent instanceof Line) {
                TempLine = (Line)TempComponent;
                TempLine.InformPartner(TempLine.ConnComps1, TempLine.getx1(), TempLine.gety1(), 1);
                TempLine.InformPartner(TempLine.ConnComps2, TempLine.getx2(), TempLine.gety2(), 2);
                this.LineVectorI.addElement(TempLine);
                ++this.numlin;
            }
            if (TempComponent instanceof Trafo) {
                TempComponent.InformAllComponents();
                this.TrafoVectorI.addElement((Trafo)TempComponent);
                ++this.numtran;
            }
            ++this.numbran;
        }
        this.BranchX = new double[this.numbran];
        this.BranchI = new int[this.numbran];
        this.BranchJ = new int[this.numbran];
        this.NameBranch = new String[this.numbran];
        this.voltBranch = new double[this.numbran][2];
        this.MatB = new double[this.numnod][this.numnod];
        for (ix = 0; ix < this.ActSchematic.Components.size(); ++ix) {
            TempComponent = (comp)this.ActSchematic.Components.elementAt(ix);
            if (!TempComponent.getactive() || !TempComponent.getvalid() || !TempComponent.getinservice()) continue;
            if (TempComponent instanceof Line && (con1 = this.numbus((TempLine = (Line)TempComponent).getcon1())) != 1000 && (con2 = this.numbus(TempLine.getcon2())) != 1000) {
                this.BranchX[count] = TempLine.getxx1() * TempLine.getlen() * this.getSref() / (TempLine.getun1() * TempLine.getun1());
                this.BranchI[count] = con1;
                this.BranchJ[count] = con2;
                this.NameBranch[count] = TempLine.getName();
                this.voltBranch[count][0] = TempLine.getun1();
                this.voltBranch[count][1] = TempLine.getun2();
                double auxr2 = 1.0 / this.BranchX[count];
                double[] dArray = this.MatB[this.BranchJ[count]];
                int n = this.BranchI[count];
                dArray[n] = dArray[n] + auxr2 * -1.0;
                double[] dArray2 = this.MatB[this.BranchI[count]];
                int n2 = this.BranchJ[count];
                dArray2[n2] = dArray2[n2] + auxr2 * -1.0;
                double[] dArray3 = this.MatB[this.BranchI[count]];
                int n3 = this.BranchI[count];
                dArray3[n3] = dArray3[n3] + auxr2;
                double[] dArray4 = this.MatB[this.BranchJ[count]];
                int n4 = this.BranchJ[count];
                dArray4[n4] = dArray4[n4] + auxr2;
                ++count;
            }
            if (!(TempComponent instanceof Trafo)) continue;
            Trafo TempTrafo = (Trafo)TempComponent;
            TempTrafo.actualizet();
            con1 = this.numbus(TempTrafo.getcon1());
            if (con1 == 1000 || (con2 = this.numbus(TempTrafo.getcon2())) == 1000) continue;
            ueb = TempTrafo.getun1() / TempTrafo.getun2() / (TempTrafo.getur1() / TempTrafo.getur2());
            res = TempTrafo.getpcu() * 0.001 * ueb * ueb / TempTrafo.getsn() * this.getSref() / TempTrafo.getsn();
            z = TempTrafo.getuk() * 0.01 * ueb * ueb * this.getSref() / TempTrafo.getsn();
            reac = TempTrafo.getuk() >= 0.0 ? Math.sqrt(z * z - res * res) : -Math.sqrt(z * z - res * res);
            this.BranchX[count] = reac / TempTrafo.gett_re();
            this.BranchI[count] = con1;
            this.BranchJ[count] = con2;
            this.NameBranch[count] = TempTrafo.getName();
            this.voltBranch[count][0] = TempTrafo.getun1();
            this.voltBranch[count][1] = TempTrafo.getun2();
            double auxr1 = 1.0 / this.BranchX[count];
            double[] dArray = this.MatB[this.BranchJ[count]];
            int n = this.BranchI[count];
            dArray[n] = dArray[n] + -1.0 * auxr1;
            double[] dArray5 = this.MatB[this.BranchI[count]];
            int n5 = this.BranchJ[count];
            dArray5[n5] = dArray5[n5] + -1.0 * auxr1;
            double[] dArray6 = this.MatB[this.BranchI[count]];
            int n6 = this.BranchI[count];
            dArray6[n6] = dArray6[n6] + auxr1;
            double[] dArray7 = this.MatB[this.BranchJ[count]];
            int n7 = this.BranchJ[count];
            dArray7[n7] = dArray7[n7] + auxr1;
            ++count;
        }
    }

    public static void printMatrix(PrintStream myPrintStream, Complex[][] m, int ii, int jj) {
        for (int i = 0; i < ii; ++i) {
            for (int j = 0; j < jj; ++j) {
                myPrintStream.print(m[i][j] + "\t \t \t");
            }
            myPrintStream.println();
        }
        myPrintStream.println();
    }

    public static void printMatrix2(PrintStream myPrintStream, double[][] m, int ii, int jj) {
        for (int i = 0; i < ii; ++i) {
            for (int j = 0; j < jj; ++j) {
                myPrintStream.print(m[i][j] + "\t \t \t");
            }
            myPrintStream.println();
        }
        myPrintStream.println();
    }

    public static void printDSM(PrintStream myPrintStream, DoubleSquareMatrix m, int ii) {
        for (int i = 0; i < ii; ++i) {
            for (int j = 0; j < ii; ++j) {
                myPrintStream.print(m.getElement(i, j) + "\t \t \t");
            }
            myPrintStream.println();
        }
        myPrintStream.println();
    }

    public static void printDM(PrintStream myPrintStream, DoubleMatrix m, int ii, int jj) {
        for (int i = 0; i < ii; ++i) {
            for (int j = 0; j < jj; ++j) {
                myPrintStream.print(m.getElement(i, j) + "\t \t \t");
            }
            myPrintStream.println();
        }
        myPrintStream.println();
    }

    public static void printVectorCFuzzytri(PrintStream myPrintStream, Vector V) {
        CFuzzytri Temp = new CFuzzytri();
        for (int i = 0; i == V.size(); ++i) {
            Temp = (CFuzzytri)V.elementAt(i);
        }
    }

    public static void printVector(PrintStream myPrintStream, Complex[] v, int ii) {
        for (int i = 0; i < ii; ++i) {
            myPrintStream.print(i + "\t" + v[i] + "\t");
            myPrintStream.println();
        }
        myPrintStream.println();
    }

    public int numbus(String Busbarname) {
        int ixx = 0;
        for (int ix = 0; ix < this.BusbarVectorI.size(); ++ix) {
            ++ixx;
            comp TempComponent = (comp)this.BusbarVectorI.elementAt(ix);
            if (TempComponent.getName().hashCode() != Busbarname.hashCode() || !TempComponent.getName().equals(Busbarname)) continue;
            return ixx - 1;
        }
        System.out.println("Error en NUMBUS");
        return 1000;
    }

    public int numbusgen(String Genname) {
        for (int ix = 0; ix < this.GeneratorVectorI.size(); ++ix) {
            comp TempComponent = (comp)this.GeneratorVectorI.elementAt(ix);
            if (!(TempComponent instanceof ndb_inj) || !Genname.equals(TempComponent.getName())) continue;
            ndb_inj TempInj = (ndb_inj)TempComponent;
            TempInj.InformAllComponents();
            if (TempInj.getlf_type() == 3) {
                this.BarraRef = this.numbus(TempInj.getcon2());
                return this.BarraRef;
            }
            return this.numbus(TempInj.getcon2());
        }
        System.out.println("Error en NUMBUSGEN");
        return 1000;
    }

    public int numbusload(String Loadname) {
        for (int ix = 0; ix < this.LoadVectorI.size(); ++ix) {
            comp TempComponent = (comp)this.LoadVectorI.elementAt(ix);
            if (!(TempComponent instanceof Load) || !Loadname.equals(TempComponent.getName())) continue;
            Load TempLoad = (Load)TempComponent;
            TempLoad.InformAllComponents();
            return this.numbus(TempLoad.getcon2());
        }
        System.out.println("Error en NUMBUSLOAD");
        return 1000;
    }

    public void PotRed() {
        int cont = 0;
        this.PFuzzyRed = new double[this.numnod - 1][3];
        for (int i = 0; i < this.numnod; ++i) {
            if (i == this.BarraRef) continue;
            this.PFuzzyRed[cont][0] = this.PFuzzy[i][0];
            this.PFuzzyRed[cont][1] = this.PFuzzy[i][1];
            this.PFuzzyRed[cont][2] = this.PFuzzy[i][2];
            ++cont;
        }
    }

    public void BRED(double[][] m) {
        int j;
        int i;
        this.MatBRed = new double[this.numnod - 1][this.numnod - 1];
        for (i = 0; i < this.BarraRef; ++i) {
            for (j = 0; j < this.BarraRef; ++j) {
                this.MatBRed[i][j] = m[i][j];
            }
        }
        for (i = this.BarraRef + 1; i < this.numnod; ++i) {
            for (j = 0; j < this.BarraRef; ++j) {
                this.MatBRed[i - 1][j] = m[i][j];
            }
        }
        for (i = 0; i < this.BarraRef; ++i) {
            for (j = this.BarraRef + 1; j < this.numnod; ++j) {
                this.MatBRed[i][j - 1] = m[i][j];
            }
        }
        for (i = this.BarraRef + 1; i < this.numnod; ++i) {
            for (j = this.BarraRef + 1; j < this.numnod; ++j) {
                this.MatBRed[i - 1][j - 1] = m[i][j];
            }
        }
    }

    public void creaVectorTheta() {
        this.TFuzzyVector = new Vector();
        for (int i = 0; i < this.numnod - 1; ++i) {
            CFuzzytri temp = new CFuzzytri(this.ResFuzzy[i][0], this.ResFuzzy[i][1], this.ResFuzzy[i][2]);
            this.TFuzzyVector.addElement(temp);
        }
        this.ThetaFinal();
    }

    public void ThetaFinal() {
        CFuzzytri Temp = new CFuzzytri();
        this.TFuzzyVector.insertElementAt(Temp, this.BarraRef);
    }

    public void ValorFinalPotencia(CFuzzytri Thetai, CFuzzytri Thetak, double[][] B, int in) {
        double aux = 0.0;
        int i = this.BranchI[in];
        int k = this.BranchJ[in];
        String nombre = this.NameBranch[in];
        double v1 = this.voltBranch[in][0];
        double v2 = this.voltBranch[in][1];
        Busbar TempBusbar1 = (Busbar)this.BusbarVectorI.elementAt(i);
        Busbar TempBusbar2 = (Busbar)this.BusbarVectorI.elementAt(k);
        double a = Thetai.a;
        double b = Thetai.b;
        double c = Thetai.c;
        CFuzzytri TempF = new CFuzzytri(a, b, c);
        TempF.sub(Thetak);
        if (!TempF.isRigth()) {
            TempF.Inv();
        }
        aux = 1.0 / this.BranchX[in];
        TempF.pond(aux);
        TempF.pond(this.getSref());
        this.myPrintStream.println("La potencia en " + nombre + " es " + TempF);
        this.myPrintStream.println("------------------------------------------------------------------------");
        try {
            this.SaveDBFuzzyLine(nombre, TempBusbar1.getName(), TempBusbar2.getName(), TempF.a, TempF.b, TempF.c, v1, v2);
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public void SaveDBFuzzyLine(String name, String bus1, String bus2, double a, double b, double c, double v1, double v2) throws SQLException {
        String query;
        int x = 0;
        Statement stmt = DeepEditFrame.conFuzzy.createStatement();
        if (this.borrar) {
            query = "DELETE * FROM LineFuzzyLinear";
            x = stmt.executeUpdate(query);
        }
        this.borrar = false;
        query = "INSERT INTO LineFuzzyLinear (Name,c1,c2,Pa,Pb,Pc,V1,V2) VALUES ('" + name + "','" + bus1 + "','" + bus2 + "'," + DCFuzzyLF.numformat(a, 9, 2) + "," + DCFuzzyLF.numformat(b, 9, 2) + "," + DCFuzzyLF.numformat(c, 9, 2) + "," + DCFuzzyLF.numformat(v1, 9, 2) + "," + DCFuzzyLF.numformat(v2, 9, 2) + ")";
        x = stmt.executeUpdate(query);
        stmt.close();
    }

    public static String numformat(double num, int ltot, int lmant) {
        int i;
        double precs = Math.pow(10.0, lmant);
        num = (double)Math.round(num * precs) / precs;
        String numero = "" + num;
        StringTokenizer st = new StringTokenizer(numero, ".");
        String pent = st.nextToken();
        String pfrac = st.nextToken();
        for (i = pfrac.length(); i < lmant; ++i) {
            pfrac = pfrac + "0";
        }
        for (i = pent.length() + lmant + 1; i < ltot; ++i) {
            pent = " " + pent;
        }
        return pent + "." + pfrac;
    }
}

