/*
 * Decompiled with CFR 0.152.
 */
package de.core;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Label;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Random;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import quick.dbtable.Column;
import quick.dbtable.DBTable;
import quick.dbtable.DBTableCellListener;
import quick.dbtable.DBTableErrorListener;
import quick.dbtable.DatabaseChangeListener;
import quick.dbtable.Skin;

public class DBTableFrame
extends JFrame
implements ActionListener {
    public DBTable NewTable;
    public DBTableFrame myhelp;
    JButton printButton;
    JButton previewButton;
    JButton findButton;
    JButton replaceButton;
    JButton refreshButton;
    JButton closeButton;
    JButton helpButton;
    JComboBox selectionCombo;
    DatabaseChangeListener myChangeListener;
    DBTableCellListener myCellListener;
    DBTableErrorListener myErrorListener;
    Random randomOrderNumber = new Random();
    Label title;
    String mitabla;
    String[] titulos;
    boolean help;
    boolean muestratodo;
    String StringID;
    String minombre;
    Vector defecto;
    String order;
    Connection miCon = null;
    private String miDB = "";

    public DBTableFrame(Connection con, String tit, String mmitabla, int ancho, int alto, String[] ttitulos, boolean hhelp, String SStringID, boolean mmuestratodo, String mminombre, Vector ddefecto, String porder) {
        super(tit);
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            // empty catch block
        }
        this.setSize(ancho, alto);
        this.setName(tit);
        this.miCon = con;
        this.defecto = ddefecto;
        this.titulos = ttitulos;
        this.mitabla = mmitabla;
        this.muestratodo = mmuestratodo;
        this.minombre = mminombre;
        this.order = porder;
        this.StringID = SStringID;
        this.help = hhelp;
        this.NewTable = new DBTable();
        this.NewTable.setSkin(DBTableFrame.getDBTableSkin());
        this.getContentPane().add((Component)this.NewTable, "Center");
        this.title = new Label(tit);
        this.title.setForeground(Color.blue);
        this.title.setAlignment(1);
        this.NewTable.add((Component)this.title, (Object)"North");
        this.NewTable.createControlPanel();
        this.NewTable.enableExcelCopyPaste();
        this.NewTable.setConnection(con);
        try {
            JToolBar jb = new JToolBar();
            Insets i1 = new Insets(0, 0, 0, 0);
            this.printButton = new JButton(new ImageIcon(this.getClass().getResource("/images/print.gif")));
            this.printButton.setToolTipText("Imprimir");
            this.printButton.setMargin(i1);
            this.printButton.setAlignmentY(0.5f);
            this.printButton.addActionListener(this);
            jb.add(this.printButton);
            this.previewButton = new JButton(new ImageIcon(this.getClass().getResource("/images/print.gif")));
            this.previewButton.setToolTipText("Vista Previa");
            this.previewButton.setMargin(i1);
            this.previewButton.setAlignmentY(0.5f);
            this.previewButton.addActionListener(this);
            jb.add(this.previewButton);
            this.findButton = new JButton(new ImageIcon(this.getClass().getResource("/images/find.gif")));
            this.findButton.setToolTipText("Buscar");
            this.findButton.setMargin(i1);
            this.findButton.setAlignmentY(0.5f);
            this.findButton.addActionListener(this);
            jb.add(this.findButton);
            if (!this.help) {
                this.replaceButton = new JButton(new ImageIcon(this.getClass().getResource("/images/replace.gif")));
                this.replaceButton.setToolTipText("Buscar-Reemplazar");
                this.replaceButton.setMargin(i1);
                this.replaceButton.setAlignmentY(0.5f);
                this.replaceButton.addActionListener(this);
                jb.add(this.replaceButton);
            }
            jb.addSeparator();
            this.refreshButton = new JButton(new ImageIcon(this.getClass().getResource("/images/refresh.gif")));
            this.refreshButton.setToolTipText("Actualizar");
            this.refreshButton.setMargin(i1);
            this.refreshButton.setAlignmentY(0.5f);
            this.refreshButton.addActionListener(this);
            jb.add(this.refreshButton);
            jb.addSeparator();
            if (!this.help) {
                this.helpButton = new JButton("Ayuda");
                this.helpButton.setToolTipText("Ayuda");
                this.helpButton.setMargin(i1);
                this.helpButton.setAlignmentY(0.5f);
                this.helpButton.addActionListener(this);
                jb.add(this.helpButton);
            }
            this.closeButton = new JButton("Terminar");
            this.closeButton.setToolTipText("Terminar");
            this.closeButton.setMargin(i1);
            this.closeButton.setAlignmentY(0.5f);
            this.closeButton.addActionListener(this);
            jb.add(this.closeButton);
            this.getContentPane().add((Component)jb, "South");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent event) {
                DBTableFrame.this.NewTable.save();
                if (DBTableFrame.this.myhelp != null) {
                    DBTableFrame.this.myhelp.dispose();
                    DBTableFrame.this.myhelp = null;
                }
                DBTableFrame.this.setVisible(false);
                DBTableFrame.this.dispose();
            }
        });
        this.showDB();
        this.setVisible(true);
    }

    public DBTableFrame(String DB, String tit, String mmitabla, int ancho, int alto, String[] ttitulos, boolean hhelp, String SStringID, boolean mmuestratodo, String mminombre, Vector ddefecto, String porder) {
        super(tit);
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            // empty catch block
        }
        this.setSize(ancho, alto);
        this.setName(tit);
        this.miDB = DB;
        this.defecto = ddefecto;
        this.titulos = ttitulos;
        this.mitabla = mmitabla;
        this.muestratodo = mmuestratodo;
        this.minombre = mminombre;
        this.order = porder;
        this.StringID = SStringID;
        this.help = hhelp;
        this.NewTable = new DBTable();
        this.NewTable.setSkin(DBTableFrame.getDBTableSkin());
        this.getContentPane().add((Component)this.NewTable, "Center");
        this.title = new Label(tit);
        this.title.setForeground(Color.blue);
        this.title.setAlignment(1);
        this.NewTable.add((Component)this.title, (Object)"North");
        this.NewTable.createControlPanel();
        this.NewTable.enableExcelCopyPaste();
        this.NewTable.setDatabaseDriver("sun.jdbc.odbc.JdbcOdbcDriver");
        this.NewTable.setJdbcUrl("jdbc:odbc:" + DB);
        try {
            JToolBar jb = new JToolBar();
            Insets i1 = new Insets(0, 0, 0, 0);
            this.printButton = new JButton(new ImageIcon(this.getClass().getResource("/images/print.gif")));
            this.printButton.setToolTipText("Imprimir");
            this.printButton.setMargin(i1);
            this.printButton.setAlignmentY(0.5f);
            this.printButton.addActionListener(this);
            jb.add(this.printButton);
            this.previewButton = new JButton(new ImageIcon(this.getClass().getResource("/images/print.gif")));
            this.previewButton.setToolTipText("Vista Previa");
            this.previewButton.setMargin(i1);
            this.previewButton.setAlignmentY(0.5f);
            this.previewButton.addActionListener(this);
            jb.add(this.previewButton);
            this.findButton = new JButton(new ImageIcon(this.getClass().getResource("/images/find.gif")));
            this.findButton.setToolTipText("Buscar");
            this.findButton.setMargin(i1);
            this.findButton.setAlignmentY(0.5f);
            this.findButton.addActionListener(this);
            jb.add(this.findButton);
            if (!this.help) {
                this.replaceButton = new JButton(new ImageIcon(this.getClass().getResource("/images/replace.gif")));
                this.replaceButton.setToolTipText("Buscar-Reemplazar");
                this.replaceButton.setMargin(i1);
                this.replaceButton.setAlignmentY(0.5f);
                this.replaceButton.addActionListener(this);
                jb.add(this.replaceButton);
            }
            jb.addSeparator();
            this.refreshButton = new JButton(new ImageIcon(this.getClass().getResource("/images/refresh.gif")));
            this.refreshButton.setToolTipText("Actualizar");
            this.refreshButton.setMargin(i1);
            this.refreshButton.setAlignmentY(0.5f);
            this.refreshButton.addActionListener(this);
            jb.add(this.refreshButton);
            jb.addSeparator();
            if (!this.help) {
                this.helpButton = new JButton("Ayuda");
                this.helpButton.setToolTipText("Ayuda");
                this.helpButton.setMargin(i1);
                this.helpButton.setAlignmentY(0.5f);
                this.helpButton.addActionListener(this);
                jb.add(this.helpButton);
            }
            this.closeButton = new JButton("Terminar");
            this.closeButton.setToolTipText("Terminar");
            this.closeButton.setMargin(i1);
            this.closeButton.setAlignmentY(0.5f);
            this.closeButton.addActionListener(this);
            jb.add(this.closeButton);
            this.getContentPane().add((Component)jb, "South");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent event) {
                DBTableFrame.this.NewTable.save();
                if (DBTableFrame.this.myhelp != null) {
                    DBTableFrame.this.myhelp.dispose();
                    DBTableFrame.this.myhelp = null;
                }
                DBTableFrame.this.setVisible(false);
                DBTableFrame.this.dispose();
            }
        });
        this.showDB();
        this.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.printButton) {
            this.NewTable.print();
        } else if (e.getSource() == this.previewButton) {
            this.NewTable.printPreview(792, 612);
        } else if (e.getSource() == this.findButton) {
            this.NewTable.doFind();
        } else if (e.getSource() == this.closeButton) {
            this.NewTable.save();
            if (this.myhelp != null) {
                this.myhelp.dispose();
                this.myhelp = null;
            }
            try {
                this.NewTable.close();
            }
            catch (SQLException es) {
                es.printStackTrace();
            }
            this.dispose();
        } else if (e.getSource() == this.helpButton) {
            String[] titulos = new String[]{"Nombre de Campo", "Descripci\u00f3n"};
            Vector<String> insertVector = new Vector<String>();
            insertVector.addElement("Campo");
            insertVector.addElement("valor");
            this.myhelp = new DBTableFrame(this.miCon, "SISTEMA DE AYUDA", this.mitabla + "_help", 650, 500, titulos, true, "No Importa", true, "No Importa", insertVector, "");
            this.myhelp.NewTable.getColumn(0).setPreferredWidth(150);
            this.myhelp.NewTable.getColumn(1).setPreferredWidth(450);
            this.myhelp.NewTable.createControlPanel(3);
        } else if (e.getSource() == this.replaceButton) {
            this.NewTable.doFindAndReplace();
        } else if (e.getSource() == this.refreshButton) {
            try {
                this.NewTable.refresh();
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
        }
    }

    public void showDB() {
        this.NewTable.clearAllUpdateSql();
        this.NewTable.clearAllInsertSql();
        this.NewTable.clearAllDeleteSql();
        try {
            if (this.muestratodo) {
                this.NewTable.setSelectSql("SELECT * from " + this.mitabla);
            } else if (this.order.length() > 0) {
                this.NewTable.setSelectSql("SELECT * from " + this.mitabla + " where " + this.StringID + " = '" + this.minombre + "' " + this.order);
            } else {
                this.NewTable.setSelectSql("SELECT * from " + this.mitabla + " where " + this.StringID + " = '" + this.minombre + "'");
            }
            this.NewTable.createColumnModelFromQuery();
            for (int i = 0; i < this.titulos.length; ++i) {
                Column c = this.NewTable.getColumn(i);
                if (!this.help) {
                    c.setReadOnly(false);
                }
                c.setHeaderValue((Object)this.titulos[i]);
                c.setPreferredWidth(100);
            }
            if (this.myErrorListener == null) {
                this.myErrorListener = new DBTableErrorListener(){

                    public boolean errorOccured(int errorId, String errorMessage, Exception unexpectedException) {
                        if (errorId == 2) {
                            JOptionPane.showMessageDialog(DBTableFrame.this, "Error de Instalaci\u00f3n: Agregar controlador jdbc al classpath!", "", 0);
                            return true;
                        }
                        if (errorId == 3) {
                            if (((SQLException)unexpectedException).getErrorCode() == 0) {
                                JOptionPane.showMessageDialog(DBTableFrame.this, "Error: No se han realizado los cambios debido a un error de base de datos!", "", 0);
                                return true;
                            }
                            return false;
                        }
                        return false;
                    }
                };
            }
            this.NewTable.addDBTableErrorListener(this.myErrorListener);
            if (this.myCellListener == null) {
                this.myCellListener = new DBTableCellListener(){

                    public Object cellValueChanged(int row, int c, Object oldValue, Object newValue) {
                        return newValue;
                    }
                };
            }
            this.NewTable.addTableCellListener(this.myCellListener);
            if (this.myChangeListener == null) {
                this.myChangeListener = new DatabaseChangeListener(){

                    public boolean beforeDelete(int row) {
                        Object orderNo = DBTableFrame.this.NewTable.getTable().getValueAt(row, 0);
                        int option = JOptionPane.showConfirmDialog(DBTableFrame.this, "Est\u00e1 seguro de borrar: " + orderNo, " ", 2);
                        return option == 0;
                    }

                    public void afterDelete(int row) {
                        JOptionPane.showMessageDialog(DBTableFrame.this, "Ha sido Borrado Exitosamente", "", 0);
                    }

                    public boolean onNewButtonClick() {
                        DBTableFrame.this.NewTable.insert(DBTableFrame.this.defecto);
                        try {
                            DBTableFrame.this.NewTable.refresh();
                        }
                        catch (Exception e) {
                            System.out.println("Ups !!! : " + e);
                        }
                        DBTableFrame.this.NewTable.save();
                        return false;
                    }
                };
            }
            this.NewTable.addDatabaseChangeListener(this.myChangeListener);
            JTable jt = this.NewTable.getTable();
            this.NewTable.refresh();
        }
        catch (SQLException e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(this, e.getMessage());
        }
    }

    public static Skin getDBTableSkin() {
        Font TextDialogFont = new Font("TimesRoman", 0, 11);
        Skin mySkin = new Skin();
        mySkin.put((Object)"Quicktable.tableFont", (Object)TextDialogFont);
        mySkin.put((Object)"Quicktable.headerFont", (Object)TextDialogFont);
        mySkin.put((Object)"Quicktable.navigationFont", (Object)TextDialogFont);
        return mySkin;
    }
}

