/*
 * Decompiled with CFR 0.152.
 */
package de.core;

import de.core.DBTableFrame;
import java.awt.Color;
import java.awt.Component;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.net.URL;
import java.sql.SQLException;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import quick.dbtable.DBTable;
import quick.dbtable.DBTableCellListener;
import quick.dbtable.DBTableErrorListener;
import quick.dbtable.DatabaseChangeListener;

public class DBReadTableFrame
extends JFrame
implements ActionListener {
    public DBTable NewTable;
    private JButton printButton;
    private JButton previewButton;
    private JButton findButton;
    private JButton refreshButton;
    private JButton closeButton;
    private DatabaseChangeListener myChangeListener;
    private DBTableCellListener myCellListener;
    private DBTableErrorListener myErrorListener;
    private Label title;
    private String mitabla;
    private String minombre;

    public DBReadTableFrame(String DB, String tit, String mmitabla, int ancho, int alto, String mminombre) {
        super(tit);
        String sConnString;
        String sConnDriver;
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            // empty catch block
        }
        this.setSize(ancho, alto);
        this.setName(tit);
        this.mitabla = mmitabla;
        this.minombre = mminombre;
        this.NewTable = new DBTable();
        this.NewTable.setSkin(DBTableFrame.getDBTableSkin());
        this.getContentPane().add((Component)this.NewTable, "Center");
        this.title = new Label(tit);
        this.title.setForeground(Color.blue);
        this.title.setAlignment(1);
        this.NewTable.setEditable(false);
        this.NewTable.createControlPanel();
        this.NewTable.enableExcelCopyPaste();
        if (DB.equals("database")) {
            sConnDriver = "sun.jdbc.odbc.JdbcOdbcDriver";
            sConnString = "jdbc:odbc:Driver={Microsoft Text Driver (*.txt; *.csv)};DBQ=." + File.separator + DB + File.separator + ";Extensions=asc,csv,dat,txt";
        } else if (DB.endsWith(".db")) {
            sConnDriver = "org.sqlite.JDBC";
            sConnString = "jdbc:sqlite:" + DB;
        } else if (DB.endsWith(".mdb")) {
            sConnDriver = "sun.jdbc.odbc.JdbcOdbcDriver";
            sConnString = "jdbc:odbc:Driver={Microsoft Access Driver (*.mdb)};DBQ=" + DB;
        } else if (new File("." + File.separator + DB + ".db").exists()) {
            sConnDriver = "org.sqlite.JDBC";
            sConnString = "jdbc:sqlite:." + File.separator + DB + ".db";
        } else {
            sConnDriver = "sun.jdbc.odbc.JdbcOdbcDriver";
            sConnString = "jdbc:odbc:Driver={Microsoft Access Driver (*.mdb)};DBQ=." + File.separator + DB + ".mdb";
        }
        this.NewTable.setDatabaseDriver(sConnDriver);
        this.NewTable.setJdbcUrl(sConnString);
        try {
            JToolBar jb = new JToolBar();
            Insets i1 = new Insets(0, 0, 0, 0);
            this.printButton = new JButton(new ImageIcon(this.getClass().getResource("/images/print.gif")));
            this.printButton.setToolTipText("Imprimir");
            this.printButton.setMargin(i1);
            this.printButton.setAlignmentY(0.5f);
            this.printButton.addActionListener(this);
            jb.add(this.printButton);
            this.previewButton = new JButton(new ImageIcon(this.getClass().getResource("/images/preview.gif")));
            this.previewButton.setToolTipText("Vista Previa");
            this.previewButton.setMargin(i1);
            this.previewButton.setAlignmentY(0.5f);
            this.previewButton.addActionListener(this);
            jb.add(this.previewButton);
            this.findButton = new JButton(new ImageIcon(this.getClass().getResource("/images/search.gif")));
            this.findButton.setToolTipText("Buscar");
            this.findButton.setMargin(i1);
            this.findButton.setAlignmentY(0.5f);
            this.findButton.addActionListener(this);
            jb.add(this.findButton);
            jb.addSeparator();
            this.refreshButton = new JButton(new ImageIcon(this.getClass().getResource("/images/refresh.gif")));
            this.refreshButton.setToolTipText("Actualizar");
            this.refreshButton.setMargin(i1);
            this.refreshButton.setAlignmentY(0.5f);
            this.refreshButton.addActionListener(this);
            jb.add(this.refreshButton);
            jb.addSeparator();
            this.closeButton = new JButton(new ImageIcon(this.getClass().getResource("/images/eject.gif")));
            this.closeButton.setToolTipText("Terminar");
            this.closeButton.setMargin(i1);
            this.closeButton.setAlignmentY(0.5f);
            this.closeButton.addActionListener(this);
            jb.add(this.closeButton);
            this.getContentPane().add((Component)jb, "South");
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent event) {
                try {
                    DBReadTableFrame.this.NewTable.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                DBReadTableFrame.this.setVisible(false);
                DBReadTableFrame.this.dispose();
            }
        });
        this.showDB();
        Image favIcon = this.getDeepEditIconImage();
        if (favIcon != null) {
            this.setIconImage(this.getDeepEditIconImage());
        }
        this.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.printButton) {
            this.NewTable.print();
        } else if (e.getSource() == this.previewButton) {
            this.NewTable.printPreview(792, 612);
        } else if (e.getSource() == this.findButton) {
            this.NewTable.doFind();
        } else if (e.getSource() == this.closeButton) {
            try {
                this.NewTable.close();
            }
            catch (Exception ee) {
                // empty catch block
            }
            this.setVisible(false);
            this.dispose();
        } else if (e.getSource() == this.refreshButton) {
            try {
                this.NewTable.refresh();
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
        }
    }

    public void showDB() {
        this.NewTable.clearAllUpdateSql();
        this.NewTable.clearAllInsertSql();
        this.NewTable.clearAllDeleteSql();
        try {
            this.NewTable.setSelectSql("SELECT * from " + this.mitabla);
            if (this.myErrorListener == null) {
                this.myErrorListener = new DBTableErrorListener(){

                    public boolean errorOccured(int errorId, String errorMessage, Exception unexpectedException) {
                        if (errorId == 2) {
                            JOptionPane.showMessageDialog(DBReadTableFrame.this, "Error de Instalaci\u00f3n: Agregar controlador jdbc al classpath!", "", 0);
                            return true;
                        }
                        if (errorId == 3) {
                            if (((SQLException)unexpectedException).getErrorCode() == 0) {
                                JOptionPane.showMessageDialog(DBReadTableFrame.this, "Error: No se han realizado los cambios debido a un error de base de datos!", "", 0);
                                return true;
                            }
                            return false;
                        }
                        return false;
                    }
                };
            }
            this.NewTable.addDBTableErrorListener(this.myErrorListener);
            if (this.myCellListener == null) {
                this.myCellListener = new DBTableCellListener(){

                    public Object cellValueChanged(int row, int c, Object oldValue, Object newValue) {
                        return newValue;
                    }
                };
            }
            this.NewTable.addTableCellListener(this.myCellListener);
            if (this.myChangeListener == null) {
                this.myChangeListener = new DatabaseChangeListener(){

                    public boolean beforeDelete(int row) {
                        Object orderNo = DBReadTableFrame.this.NewTable.getTable().getValueAt(row, 0);
                        int option = JOptionPane.showConfirmDialog(DBReadTableFrame.this, "Est\u00e1 seguro de borrar: " + orderNo, " ", 2);
                        return option == 0;
                    }

                    public void afterDelete(int row) {
                        JOptionPane.showMessageDialog(DBReadTableFrame.this, "Ha sido Borrado Exitosamente", "", 0);
                    }

                    public boolean onNewButtonClick() {
                        try {
                            DBReadTableFrame.this.NewTable.refresh();
                        }
                        catch (Exception e) {
                            System.out.println("Ups !!! : " + e);
                        }
                        return false;
                    }
                };
            }
            this.NewTable.addDatabaseChangeListener(this.myChangeListener);
            JTable jt = this.NewTable.getTable();
            jt.setRowHeight(30);
            this.NewTable.refresh();
        }
        catch (SQLException e) {
            System.out.println("Error exectuting query: " + this.NewTable.getSelectSql());
            System.out.println("More details: " + e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            JOptionPane.showMessageDialog(this, e.getMessage());
        }
    }

    private Image getDeepEditIconImage() {
        Image tmpImg;
        try {
            URL imageURL = this.getClass().getResource("/images/DEfavicon.png");
            tmpImg = Toolkit.getDefaultToolkit().getImage(imageURL);
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            return null;
        }
        return tmpImg;
    }
}

