/*
 * Decompiled with CFR 0.152.
 */
package de.core;

import java.util.Vector;

public final class CvaLinPartes {
    private double[] fi;
    private double[] mi;
    private double[] xi;
    private int numpoints = 0;
    private boolean allOK = false;

    public CvaLinPartes(double[] px0, double[] pfx0) {
        if (px0.length == 0) {
            return;
        }
        this.numpoints = px0.length;
        this.xi = new double[this.numpoints];
        this.xi[0] = px0[0];
        for (int i = 1; i < this.numpoints; ++i) {
            this.xi[i] = px0[i];
            if (!(this.xi[i] <= this.xi[i - 1])) continue;
            return;
        }
        this.mi = new double[this.numpoints];
        this.fi = new double[this.numpoints];
        this.changeFvalues(pfx0);
    }

    public CvaLinPartes(Vector px0, Vector pfx0) {
        int i;
        if (px0.size() == 0) {
            return;
        }
        this.numpoints = px0.size();
        this.xi = new double[this.numpoints];
        this.xi[0] = (Double)px0.elementAt(0);
        for (i = 1; i < this.numpoints; ++i) {
            this.xi[i] = (Double)px0.elementAt(i);
            if (!(this.xi[i] <= this.xi[i - 1])) continue;
            return;
        }
        this.mi = new double[this.numpoints];
        this.fi = new double[this.numpoints];
        this.allOK = false;
        if (pfx0.size() != this.numpoints) {
            return;
        }
        this.fi[0] = (Double)pfx0.elementAt(0);
        for (i = 1; i < this.numpoints; ++i) {
            this.fi[i] = (Double)pfx0.elementAt(i);
            this.mi[i] = (this.fi[i] - this.fi[i - 1]) / (this.xi[i] - this.xi[i - 1]);
        }
        this.mi[0] = this.mi[1];
        this.allOK = true;
    }

    public double getSlope(int frompoint) {
        if (this.allOK && frompoint < this.numpoints && frompoint > 0) {
            return this.mi[frompoint];
        }
        return 0.0;
    }

    public double evalIn(double x) {
        if (!this.allOK) {
            return 0.0;
        }
        for (int i = this.numpoints - 2; i > -1; --i) {
            if (!(x >= this.xi[i])) continue;
            return this.mi[i + 1] * (x - this.xi[i]) + this.fi[i];
        }
        if (x < this.xi[0]) {
            return this.fi[0] + this.mi[1] * (x - this.xi[0]);
        }
        if (x >= this.xi[this.numpoints - 1]) {
            return this.fi[this.numpoints - 1] + this.mi[this.numpoints - 1] * (x - this.xi[this.numpoints - 1]);
        }
        return 0.0;
    }

    public double evalInverseIn(double f) {
        if (!this.allOK) {
            return 0.0;
        }
        for (int i = this.numpoints - 2; i > -1; --i) {
            if (!(f >= this.fi[i])) continue;
            return (f - this.fi[i]) / this.mi[i + 1] + this.xi[i];
        }
        if (f < this.fi[0]) {
            return this.xi[0] + (f - this.fi[0]) / this.mi[1];
        }
        if (f >= this.fi[this.numpoints - 1]) {
            return this.xi[this.numpoints - 1] + (f - this.fi[this.numpoints - 1]) / this.mi[this.numpoints - 1];
        }
        return 0.0;
    }

    public int getNumPoints() {
        return this.numpoints;
    }

    public void changeFvalues(double[] NewFval) {
        this.allOK = false;
        if (NewFval.length != this.numpoints) {
            return;
        }
        this.fi[0] = NewFval[0];
        for (int i = 1; i < this.numpoints; ++i) {
            this.fi[i] = NewFval[i];
            this.mi[i] = (this.fi[i] - this.fi[i - 1]) / (this.xi[i] - this.xi[i - 1]);
        }
        this.mi[0] = this.mi[1];
        this.allOK = true;
    }

    public double getXpoint(int numpoint) {
        if (this.allOK && numpoint < this.numpoints && numpoint >= 0) {
            return this.xi[numpoint];
        }
        return 0.0;
    }

    public double getFpoint(int numpoint) {
        if (this.allOK && numpoint < this.numpoints && numpoint >= 0) {
            return this.fi[numpoint];
        }
        return 0.0;
    }

    public boolean checkConc() {
        for (int i = 1; i < this.numpoints; ++i) {
            if (!(this.mi[i - 1] < this.mi[i])) continue;
            return false;
        }
        return true;
    }
}

