/*
 * Decompiled with CFR 0.152.
 */
package de.core;

import de.core.DeepEdit;
import de.core.ImageButton;
import de.core.SimpleDialog;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.util.Vector;

class ControlPanel
extends Canvas {
    Vector buttons;
    DeepEdit applet;
    Image ImageBuffer = null;
    Image CopyImage = null;
    Graphics cig;
    int ButtonOffset = 0;
    ImageButton PressedButton = null;
    boolean ImageButtonsDisabled = false;

    public ControlPanel(DeepEdit app) {
        this.applet = app;
        this.buttons = new Vector();
        this.LoadButtonsImage();
        this.buttons.addElement(new ImageButton("New", 0));
        this.buttons.addElement(new ImageButton("Open", 24));
        this.buttons.addElement(new ImageButton("Save", 48));
        this.buttons.addElement(new ImageButton("Cut", 80));
        this.buttons.addElement(new ImageButton("Copy", 104));
        this.buttons.addElement(new ImageButton("Paste", 128));
        this.buttons.addElement(new ImageButton("Pointer", 160));
        this.buttons.addElement(new ImageButton("Line", 184));
        this.buttons.addElement(new ImageButton("Junction", 208));
        this.buttons.addElement(new ImageButton("Text", 232));
        this.buttons.addElement(new ImageButton("Generator", 265));
        this.buttons.addElement(new ImageButton("Trafo", 289));
        this.buttons.addElement(new ImageButton("ThreeWindingTrafo", 313));
        this.buttons.addElement(new ImageButton("Upfc", 289));
        this.buttons.addElement(new ImageButton("Load", 337));
        this.buttons.addElement(new ImageButton("BusbarFour", 361));
        this.buttons.addElement(new ImageButton("JavaLF", 394));
        this.buttons.addElement(new ImageButton("JavaOPF", 418));
        this.buttons.addElement(new ImageButton("Simulate", 442));
        this.buttons.addElement(new ImageButton("Contract", 474));
        this.buttons.addElement(new ImageButton("Supplier", 499));
        this.buttons.addElement(new ImageButton("Customer", 523));
        this.buttons.addElement(new ImageButton("ISO", 548));
        this.buttons.addElement(new ImageButton("Broker", 571));
        this.buttons.addElement(new ImageButton("Help", 602));
        if (this.ImageButtonsDisabled) {
            this.setSize(this.getSize().width, 36);
        } else {
            this.setSize(this.getSize().width, 4);
        }
    }

    @Override
    public Dimension preferredSize() {
        int w = DeepEdit.frame.getSize().width;
        if (this.ImageButtonsDisabled) {
            return new Dimension(w, 4);
        }
        return new Dimension(w, 36);
    }

    public ImageButton getButton(String Name) {
        for (int ix = 0; ix < this.buttons.size(); ++ix) {
            ImageButton TempButton = (ImageButton)this.buttons.elementAt(ix);
            if (!TempButton.getName().equals(Name)) continue;
            return TempButton;
        }
        return null;
    }

    public void EnableButton(String Name) {
        ImageButton TempButton = this.getButton(Name);
        if (TempButton != null) {
            TempButton.Enable();
        }
        this.repaint();
    }

    public void DisableButton(String Name) {
        ImageButton TempButton = this.getButton(Name);
        if (TempButton != null) {
            TempButton.Disable();
        }
        this.repaint();
    }

    public void SelectButton(String Name) {
        ImageButton TempButton = this.getButton(Name);
        if (TempButton != null) {
            TempButton.Select();
        }
        this.repaint();
    }

    public void UnselectButton(String Name) {
        ImageButton TempButton = this.getButton(Name);
        if (TempButton != null) {
            TempButton.Unselect();
        }
        this.repaint();
    }

    public void EnableAllButtons() {
        this.EnableButton("Pointer");
        this.EnableButton("Line");
        this.EnableButton("Junction");
        this.EnableButton("Text");
        this.EnableButton("Help");
        this.EnableButton("JavaLF");
        this.EnableButton("JavaOPF");
        this.EnableButton("Simulate");
        this.EnableButton("New");
        this.EnableButton("Generator");
        this.EnableButton("Trafo");
        this.EnableButton("ThreeWindingTrafo");
        this.EnableButton("Upfc");
        this.EnableButton("BusbarFour");
        this.EnableButton("Load");
        if (this.applet.EnableFileOperations) {
            this.EnableButton("Open");
            this.EnableButton("Save");
        }
        this.SelectButton("Pointer");
    }

    public void DrawButtons(Graphics g) {
        this.ButtonOffset = (this.getSize().width - this.CopyImage.getWidth(this)) / 2;
        for (int ix = 0; ix < this.buttons.size(); ++ix) {
            ImageButton TempButton = (ImageButton)this.buttons.elementAt(ix);
            TempButton.Draw(this.cig);
        }
        Graphics ibg = this.ImageBuffer.getGraphics();
        ibg.drawImage(this.CopyImage, 0, 0, this);
        g.drawImage(this.ImageBuffer, this.ButtonOffset, 4, this);
    }

    @Override
    public boolean mouseDown(Event event, int x, int y) {
        x -= this.ButtonOffset;
        y -= 4;
        for (int ix = 0; ix < this.buttons.size(); ++ix) {
            ImageButton TempButton = (ImageButton)this.buttons.elementAt(ix);
            if (!TempButton.CheckIfPressed(x, y)) continue;
            this.PressedButton = TempButton;
            this.repaint();
            return true;
        }
        return true;
    }

    @Override
    public boolean mouseUp(Event event, int x, int y) {
        if (this.PressedButton != null) {
            this.PressedButton.Select();
            this.repaint();
            this.ButtonPressed(this.PressedButton.getName());
            this.PressedButton = null;
        }
        return true;
    }

    @Override
    public synchronized void update(Graphics g) {
        g.setColor(Color.gray);
        g.drawLine(0, 0, this.getSize().width, 0);
        if (!this.ImageButtonsDisabled) {
            g.drawLine(0, 30, this.getSize().width, 30);
        }
        g.setColor(Color.lightGray);
        g.drawLine(0, 1, this.getSize().width, 1);
        if (!this.ImageButtonsDisabled) {
            g.drawLine(0, 31, this.getSize().width, 31);
        }
        if (this.CopyImage != null && !this.ImageButtonsDisabled) {
            this.DrawButtons(g);
        }
    }

    @Override
    public synchronized void paint(Graphics g) {
        this.update(g);
    }

    public void LoadButtonsImage() {
        MediaTracker tracker = new MediaTracker(this);
        Image ButtonsImage = this.applet.getImage(this.applet.getDocumentBase(), "images/allbuttons.gif");
        tracker.addImage(ButtonsImage, 0);
        try {
            Thread.currentThread().setPriority(1);
            tracker.waitForAll();
        }
        catch (Exception e) {
            String message = e.toString();
            String[] DlgButtons = new String[]{"OK"};
            SimpleDialog ExceptionDialog = new SimpleDialog(DeepEdit.frame, "Reading imagebuttons", message, DlgButtons, 1, 0, 0, 1);
            return;
        }
        if (tracker.isErrorAny()) {
            this.ImageButtonsDisabled = true;
            String message = "Can't read images/allbuttons.gif ImageButtons will be disabled";
            String[] DlgButtons = new String[]{"OK"};
            SimpleDialog ErrorDialog = new SimpleDialog(DeepEdit.frame, "Error while reading imagebuttons", message, DlgButtons, 1, 0, 0, 1);
            return;
        }
        this.ImageBuffer = DeepEdit.frame.createImage(ButtonsImage.getWidth(this), 24);
        this.CopyImage = DeepEdit.frame.createImage(ButtonsImage.getWidth(this), ButtonsImage.getHeight(this));
        this.cig = this.CopyImage.getGraphics();
        this.cig.drawImage(ButtonsImage, 0, 0, this);
    }

    public void ButtonPressed(String PressedButton) {
        if (this.ImageButtonsDisabled) {
            return;
        }
        if (PressedButton.equals("Pointer")) {
            this.applet.UserWantsPointer();
        } else if (PressedButton.equals("Line")) {
            this.applet.UserWantsWireDrawing();
        } else if (PressedButton.equals("Contract")) {
            this.applet.UserWantsContractDrawing();
        } else if (PressedButton.equals("Junction")) {
            this.applet.UserWantsJunctionDrawing();
        } else if (PressedButton.equals("Text")) {
            this.applet.UserWantsTextDrawing();
        } else if (PressedButton.equals("Generator")) {
            this.applet.UserWantsGeneratorDrawing();
        } else if (PressedButton.equals("Trafo")) {
            this.applet.UserWantsTrafoDrawing();
        } else if (PressedButton.equals("ThreeWindingTrafo")) {
            this.applet.UserWantsThreeWindingTrafoDrawing();
        } else if (PressedButton.equals("Upfc")) {
            this.applet.UserWantsUpfcDrawing();
        } else if (PressedButton.equals("Load")) {
            this.applet.UserWantsLoadDrawing();
        } else if (PressedButton.equals("Supplier")) {
            this.applet.UserWantsmdb_supDrawing();
        } else if (PressedButton.equals("Customer")) {
            this.applet.UserWantsmdb_custDrawing();
        } else if (PressedButton.equals("ISO")) {
            this.applet.UserWantsmdb_isoDrawing();
        } else if (PressedButton.equals("BusbarFour")) {
            this.applet.UserWantsBusbarFourDrawing();
        } else if (PressedButton.equals("Help")) {
            this.applet.UserWantsHelp();
        } else if (PressedButton.equals("JavaLF")) {
            this.applet.UserWantsJavaLF();
        } else if (PressedButton.equals("JavaOPF")) {
            this.applet.UserWantsJavaOPF();
        } else if (PressedButton.equals("Simulate")) {
            this.applet.UserWantsSimulate();
        } else if (PressedButton.equals("New")) {
            this.applet.UserWantsNewSchematic();
        } else if (PressedButton.equals("Open")) {
            this.applet.UserWantsOpenSchematic();
        } else if (PressedButton.equals("Save")) {
            this.applet.UserWantsSaveSchematic(false);
        } else if (PressedButton.equals("Copy")) {
            this.applet.UserWantsCopySchematic();
        } else if (PressedButton.equals("Paste")) {
            this.applet.UserWantsPasteSchematic();
        } else if (PressedButton.equals("Cut")) {
            this.applet.UserWantsCutSchematic();
        }
    }
}

