/*
 * Decompiled with CFR 0.152.
 */
package de.core;

import de.core.comp;
import de.data.DE_VariableEnums;
import java.io.PrintStream;

class ConstraintCoefficient {
    private final int id;
    private double coefficient;
    private final String objectname;
    private final String classname;
    private final DE_VariableEnums.DE_Variable variable;
    private final comp component;

    public ConstraintCoefficient(double coefficientValue, DE_VariableEnums.DE_Variable variable, comp component) {
        this.id = ConstraintCoefficient.createId(component.getName(), component.getClassName(), variable.toString());
        this.coefficient = coefficientValue;
        this.variable = variable;
        this.component = component;
        this.objectname = component.getName();
        this.classname = component.getClassName();
    }

    public ConstraintCoefficient(double coefficientValue, DE_VariableEnums.DE_Variable variable, String componentName, String className) {
        this.id = ConstraintCoefficient.createId(componentName, className, variable.toString());
        this.coefficient = coefficientValue;
        this.variable = variable;
        this.objectname = componentName;
        this.classname = className;
        this.component = null;
    }

    private static int createId(String objectName, String className, String sVariable) {
        return (objectName + "_" + className + "_" + sVariable).hashCode();
    }

    public int getId() {
        return this.id;
    }

    double getCoefficient() {
        return this.coefficient;
    }

    void setCoefficient(double coefficient) {
        this.coefficient = coefficient;
    }

    comp getComponent() {
        return this.component;
    }

    String getObjectname() {
        if (this.component == null) {
            return this.objectname;
        }
        return this.component.getName();
    }

    String getClassname() {
        if (this.component == null) {
            return this.classname;
        }
        return this.component.getClassName();
    }

    String getVariablename() {
        return this.variable.toString();
    }

    DE_VariableEnums.DE_Variable getVariable() {
        return this.variable;
    }

    void saveToFile(PrintStream ps) {
        ps.println(" coefficient " + this.getCoefficient());
        ps.println(" objectname " + this.getObjectname());
        ps.println(" classname " + this.getClassname());
        ps.println(" variablename " + this.getVariablename());
    }
}

