/*
 * Decompiled with CFR 0.152.
 */
package de.core;

import de.core.Constraint;
import de.core.DeepEdit;
import de.core.comp;
import de.data.DE_GeneralEnums;
import de.data.DE_ValidationException;
import de.data.DE_VariableEnums;
import de.utils.Utils;
import java.awt.Color;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.LayoutStyle;
import javax.swing.border.LineBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.text.BadLocationException;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class ConstraintBuilderFrame
extends JDialog {
    private Constraint tempConstraint;
    private Constraint loadedConstraint = null;
    private LinkedList<Integer> lCoefficient = new LinkedList();
    private JButton btnAdd;
    private JButton btnCancel;
    private JButton btnFinish;
    private JComboBox cboCategory;
    private JComboBox cboType;
    private Box.Filler filler1;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane3;
    private JLabel lblCoefficient;
    private JLabel lblDE_Banner;
    private JLabel lblGeneral;
    private JLabel lblLHS;
    private JLabel lblLHSsmall;
    private JLabel lblRHSsmall;
    private JLabel lblSense;
    private JLabel lblVariable;
    private JList lstVariable;
    private JTree objectTreeView;
    private JPanel pnlComp;
    private JPanel pnlConfigCategory;
    private JPanel pnlControl;
    private JPanel pnlMain;
    private JPanel pnlTittle;
    private JPanel pnlVariable;
    private JTextField txtCoefficient;
    private JTextArea txtDomain;
    private JTextArea txtLHS;
    private JTextField txtName;
    private JTextField txtRHS;
    private JTextArea txtTittle;

    public ConstraintBuilderFrame(Window parent) {
        super(parent, "Constraint Builder", Dialog.ModalityType.DOCUMENT_MODAL);
        this.initComponents();
        this.loadTreeComponents();
        this.loadConstraintType();
        this.loadConstraintCategory();
    }

    private void loadTreeComponents() {
        DeepEdit.updateTreeView(this.objectTreeView);
        this.objectTreeView.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)ConstraintBuilderFrame.this.objectTreeView.getLastSelectedPathComponent();
                if (node == null) {
                    return;
                }
                ConstraintBuilderFrame.this.updateVariableList(ConstraintBuilderFrame.this.getClassName(node));
                ConstraintBuilderFrame.this.btnAdd.setEnabled(ConstraintBuilderFrame.this.isValidLHSSelection());
            }
        });
    }

    private void loadConstraintType() {
        for (DE_GeneralEnums.ConstraintSenseType ct : DE_GeneralEnums.ConstraintSenseType.values()) {
            this.cboType.addItem(ct);
        }
    }

    private void loadConstraintCategory() {
        for (DE_GeneralEnums.ConstraintCategory ct : DE_GeneralEnums.ConstraintCategory.values()) {
            this.cboCategory.addItem(ct);
        }
    }

    private DE_GeneralEnums.ConstraintSenseType getSenseLabel() {
        String sSense = this.lblSense.getText();
        if (sSense.equals("=")) {
            return DE_GeneralEnums.ConstraintSenseType.Equality;
        }
        if (sSense.equals("<=")) {
            return DE_GeneralEnums.ConstraintSenseType.Lower_Than;
        }
        if (sSense.equals(">=")) {
            return DE_GeneralEnums.ConstraintSenseType.Greater_Than;
        }
        assert (false) : "Why this constraint sense label is not of any supported type??" + sSense;
        return DE_GeneralEnums.ConstraintSenseType.Lower_Than;
    }

    private void setSenseLabel(DE_GeneralEnums.ConstraintSenseType ctype) {
        switch (ctype) {
            case Equality: {
                this.lblSense.setText("=");
                break;
            }
            case Greater_Than: {
                this.lblSense.setText(">=");
                break;
            }
            case Lower_Than: {
                this.lblSense.setText("<=");
            }
        }
    }

    private DE_GeneralEnums.ConstraintCategory getCategoryLabel() {
        if (this.cboCategory.getSelectedItem().toString().equalsIgnoreCase("Category")) {
            return DE_GeneralEnums.ConstraintCategory.Generic;
        }
        return (DE_GeneralEnums.ConstraintCategory)((Object)this.cboCategory.getSelectedItem());
    }

    private void setCategoryLabel(DE_GeneralEnums.ConstraintCategory eCategory) {
        this.cboCategory.setSelectedItem((Object)eCategory);
        if (eCategory == DE_GeneralEnums.ConstraintCategory.Generic) {
            if (this.tempConstraint != null) {
                this.cboCategory.setEnabled(false);
            }
        } else {
            this.cboCategory.setEnabled(false);
            this.cboType.setEnabled(false);
        }
        this.updateVariableList(this.getClassNameSelected());
    }

    private void setRHSLabel(double dRHS) {
        this.txtRHS.setText(String.valueOf(dRHS));
    }

    private void updateVariableList(comp DE_Comp) {
        this.lstVariable.removeAll();
        if (this.isValidCompSelection(DE_Comp)) {
            this.updateVariableList(DE_Comp.getClassName());
        }
    }

    private void updateVariableList(String className) {
        this.lstVariable.removeAll();
        DE_GeneralEnums.ConstraintCategory cc = this.getCategoryLabel();
        if (cc != DE_GeneralEnums.ConstraintCategory.Generic && className == null) {
            return;
        }
        if (this.isValidCompSelection(className)) {
            List<DE_VariableEnums.DE_Variable> lVar = Constraint.getVariableList(className, cc);
            Object[] lData = new Object[lVar.size()];
            int cont = 0;
            for (DE_VariableEnums.DE_Variable var : lVar) {
                lData[cont] = var;
                ++cont;
            }
            this.lstVariable.setListData(lData);
        }
    }

    private boolean isValidCompSelection(String className) {
        return className != null && !className.equalsIgnoreCase("Constraint");
    }

    private boolean isValidCompSelection(comp DE_Comp) {
        if (DE_Comp != null) {
            return this.isValidCompSelection(DE_Comp.getClassName());
        }
        return false;
    }

    private boolean isValidLHSSelection() {
        return this.isValidCompSelection(this.getClassNameSelected()) && this.lstVariable.getSelectedValue() != null;
    }

    private DefaultMutableTreeNode getNodeSelected() {
        if (this.objectTreeView == null || this.lstVariable == null) {
            return null;
        }
        TreePath tp = this.objectTreeView.getSelectionPath();
        if (tp == null) {
            return null;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.objectTreeView.getSelectionPath().getLastPathComponent();
        if (node == null) {
            return null;
        }
        if (node.isRoot()) {
            return null;
        }
        return node;
    }

    private String getClassNameSelected() {
        DefaultMutableTreeNode node = this.getNodeSelected();
        return this.getClassName(node);
    }

    private String getClassName(DefaultMutableTreeNode node) {
        if (node != null) {
            if (!node.isLeaf()) {
                return node.getUserObject().toString();
            }
            if (node.getUserObject() instanceof comp) {
                return ((comp)node.getUserObject()).getClassName();
            }
            return node.getUserObject().toString();
        }
        return null;
    }

    private comp getComponentSelected() {
        DefaultMutableTreeNode node = this.getNodeSelected();
        return this.getComponent(node);
    }

    private comp getComponent(DefaultMutableTreeNode node) {
        if (node == null) {
            return null;
        }
        if (node.isLeaf() && !node.getParent().equals(node.getRoot()) && node.getUserObject() instanceof comp) {
            if (node.getUserObject() instanceof Constraint) {
                return null;
            }
            return (comp)node.getUserObject();
        }
        return null;
    }

    private void appendLHSToGUI(double dCoefficient, String Variable, comp c) {
        this.lCoefficient.addLast(this.tempConstraint.getCoefficientID(Variable, c));
        String sExpression = Variable + "(" + c.getName() + "){t}";
        if (dCoefficient == -1.0) {
            sExpression = "-" + sExpression;
        } else if (dCoefficient == 1.0) {
            sExpression = "+" + sExpression;
        } else {
            if (dCoefficient == 0.0) {
                return;
            }
            sExpression = dCoefficient > 0.0 ? "+" + String.valueOf(dCoefficient) + sExpression : String.valueOf(dCoefficient) + sExpression;
        }
        this.txtLHS.append(sExpression + "\n");
    }

    private void addSelectionToConstraint() {
        double dCoefficient = 0.0;
        try {
            dCoefficient = Double.parseDouble(this.txtCoefficient.getText());
        }
        catch (NumberFormatException e) {
            System.out.println("Invalid coefficient value '" + this.txtCoefficient.getText() + "' . Only double values are allowed");
            return;
        }
        if (dCoefficient == 0.0) {
            return;
        }
        if (this.tempConstraint == null) {
            String tempName = this.txtName.getText();
            if (tempName == null) {
                tempName = "Constraint";
            }
            this.tempConstraint = new Constraint(tempName, DeepEdit.getActiveSchematic().getiniperiod(), DeepEdit.getActiveSchematic().getendperiod());
        }
        DE_VariableEnums.DE_Variable variable = (DE_VariableEnums.DE_Variable)this.lstVariable.getSelectedValue();
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.objectTreeView.getSelectionPath().getLastPathComponent();
        ArrayList lComp = new ArrayList();
        String compLabel = node.getUserObject().toString();
        if (node.getUserObject() instanceof comp) {
            lComp.add((comp)node.getUserObject());
        } else {
            lComp = (ArrayList)DeepEdit.getComponents(node.getUserObject().toString());
            compLabel = "[" + compLabel.toUpperCase() + "]";
        }
        for (comp c : lComp) {
            try {
                if (!Constraint.isValidCoefficient(dCoefficient, variable, c, this.getCategoryLabel())) continue;
                this.tempConstraint.setCoefficient(dCoefficient, variable, c);
                this.appendLHSToGUI(dCoefficient, variable.toString(), c);
            }
            catch (DE_ValidationException e) {
                JOptionPane.showMessageDialog(this, e.getLocalizedMessage(), "Invalid Coefficient Value", 0);
                return;
            }
        }
    }

    private boolean removeSelectionFromConstraint(int nLine) {
        if (nLine >= this.lCoefficient.size()) {
            return false;
        }
        Integer id = this.lCoefficient.remove(nLine);
        if (id == null) {
            assert (false) : "Why you are trying to delete an inexistant LHS?? Line '" + nLine + "' got messy?";
            return false;
        }
        return this.tempConstraint.removeCoefficient(id);
    }

    public void loadConstraint(Constraint c) {
        assert (c != null) : "Why you are loading a null constraint??? Always instantiate first!";
        this.loadedConstraint = c;
        this.tempConstraint = c;
        this.txtName.setText(c.getName());
        this.txtLHS.removeAll();
        for (int id : this.tempConstraint.getAllCoefficientIDs()) {
            double dCoefficient = this.tempConstraint.getCoefficientValue(id);
            String variableLabel = this.tempConstraint.getCoefficientVariable(id).toString();
            comp tempComp = this.tempConstraint.getCoefficientComp(id);
            this.appendLHSToGUI(dCoefficient, variableLabel, tempComp);
        }
        this.setSenseLabel(this.tempConstraint.getSense());
        this.setRHSLabel(this.tempConstraint.getRHS());
        this.setCategoryLabel(this.tempConstraint.getCategory());
    }

    public boolean saveConstraint() {
        if (this.tempConstraint == null) {
            return false;
        }
        this.tempConstraint.setName(this.txtName.getText());
        DE_GeneralEnums.ConstraintSenseType eSense = this.getSenseLabel();
        this.tempConstraint.setSense(eSense);
        this.tempConstraint.setCategory(this.getCategoryLabel());
        double dRHS = Double.parseDouble(this.txtRHS.getText());
        this.tempConstraint.setRHS(dRHS);
        if (this.loadedConstraint == null) {
            DeepEdit.addComponent(this.tempConstraint);
        } else {
            comp.copyParameters(this.tempConstraint, this.loadedConstraint);
        }
        return true;
    }

    private void initComponents() {
        this.pnlMain = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.txtLHS = new JTextArea();
        this.txtRHS = new JTextField();
        this.btnFinish = new JButton();
        this.btnCancel = new JButton();
        this.txtDomain = new JTextArea();
        this.lblSense = new JLabel();
        this.lblLHSsmall = new JLabel();
        this.lblRHSsmall = new JLabel();
        this.filler1 = new Box.Filler(new Dimension(5, 0), new Dimension(5, 0), new Dimension(5, Short.MAX_VALUE));
        this.pnlTittle = new JPanel();
        this.lblDE_Banner = new JLabel();
        this.txtTittle = new JTextArea();
        this.pnlControl = new JPanel();
        this.pnlConfigCategory = new JPanel();
        this.cboCategory = new JComboBox();
        this.lblGeneral = new JLabel();
        this.cboType = new JComboBox();
        this.txtName = new JTextField();
        this.pnlComp = new JPanel();
        this.lblLHS = new JLabel();
        this.jScrollPane2 = new JScrollPane();
        this.objectTreeView = new JTree();
        this.pnlVariable = new JPanel();
        this.lblVariable = new JLabel();
        this.btnAdd = new JButton();
        this.txtCoefficient = new JTextField();
        this.lblCoefficient = new JLabel();
        this.jScrollPane3 = new JScrollPane();
        this.lstVariable = new JList();
        this.setDefaultCloseOperation(2);
        this.setTitle("Constraint Builder");
        this.pnlMain.setBackground(new Color(255, 255, 255));
        this.pnlMain.setBorder(BorderFactory.createLineBorder(new Color(153, 153, 153)));
        this.txtLHS.setColumns(20);
        this.txtLHS.setFont(new Font("Monospaced", 0, 10));
        this.txtLHS.setRows(5);
        this.txtLHS.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                ConstraintBuilderFrame.this.txtLHSKeyPressed(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.txtLHS);
        this.txtRHS.setText("0.0");
        this.btnFinish.setText("Finish");
        this.btnFinish.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConstraintBuilderFrame.this.btnFinishActionPerformed(evt);
            }
        });
        this.btnCancel.setText("Cancel");
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConstraintBuilderFrame.this.btnCancelActionPerformed(evt);
            }
        });
        this.txtDomain.setBackground(new Color(240, 240, 240));
        this.txtDomain.setColumns(20);
        this.txtDomain.setFont(new Font("Monospaced", 0, 12));
        this.txtDomain.setRows(5);
        this.txtDomain.setText("Forall{t}");
        this.lblSense.setText("<=");
        this.lblLHSsmall.setFont(new Font("Tahoma", 0, 8));
        this.lblLHSsmall.setText("LHS");
        this.lblRHSsmall.setFont(new Font("Tahoma", 0, 8));
        this.lblRHSsmall.setText("RHS");
        GroupLayout pnlMainLayout = new GroupLayout(this.pnlMain);
        this.pnlMain.setLayout(pnlMainLayout);
        pnlMainLayout.setHorizontalGroup(pnlMainLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlMainLayout.createSequentialGroup().addContainerGap().addGroup(pnlMainLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 243, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, pnlMainLayout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.btnFinish).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnCancel, -2, 65, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pnlMainLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlMainLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.txtDomain, -2, 85, -2).addGroup(pnlMainLayout.createSequentialGroup().addComponent(this.lblSense).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pnlMainLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, pnlMainLayout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.filler1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblRHSsmall).addGap(2, 2, 2)).addComponent(this.txtRHS)))).addComponent(this.lblLHSsmall)).addGap(19, 19, 19)));
        pnlMainLayout.setVerticalGroup(pnlMainLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlMainLayout.createSequentialGroup().addContainerGap().addGroup(pnlMainLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlMainLayout.createSequentialGroup().addGroup(pnlMainLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.txtRHS, -2, -1, -2).addComponent(this.lblSense)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pnlMainLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblRHSsmall).addComponent(this.filler1, -2, -1, -2)).addGap(23, 23, 23).addComponent(this.txtDomain, -2, 109, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.lblLHSsmall)).addComponent(this.jScrollPane1)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pnlMainLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.btnFinish).addComponent(this.btnCancel)).addGap(15, 15, 15)));
        this.pnlTittle.setBackground(new Color(255, 255, 255));
        this.pnlTittle.setBorder(BorderFactory.createLineBorder(new Color(153, 153, 153)));
        this.lblDE_Banner.setIcon(new ImageIcon(this.getClass().getResource("/images/DEbanner372x76.jpg")));
        this.lblDE_Banner.setToolTipText("");
        this.txtTittle.setEditable(false);
        this.txtTittle.setColumns(20);
        this.txtTittle.setFont(new Font("Tahoma", 0, 10));
        this.txtTittle.setRows(5);
        this.txtTittle.setText("Constraint Builder:\n\nSelect constraint category, type, choose \nobjects, select variables, define RHS\n");
        this.txtTittle.setAutoscrolls(false);
        this.txtTittle.setOpaque(false);
        GroupLayout pnlTittleLayout = new GroupLayout(this.pnlTittle);
        this.pnlTittle.setLayout(pnlTittleLayout);
        pnlTittleLayout.setHorizontalGroup(pnlTittleLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlTittleLayout.createSequentialGroup().addComponent(this.txtTittle, -2, 181, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblDE_Banner).addContainerGap(-1, Short.MAX_VALUE)));
        pnlTittleLayout.setVerticalGroup(pnlTittleLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, pnlTittleLayout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addGroup(pnlTittleLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.lblDE_Banner, -1, -1, Short.MAX_VALUE).addComponent(this.txtTittle)).addGap(29, 29, 29)));
        this.pnlControl.setBackground(new Color(220, 220, 226));
        this.pnlConfigCategory.setBorder(new LineBorder(new Color(153, 153, 153), 1, true));
        this.cboCategory.setModel(new DefaultComboBoxModel<String>(new String[]{"Category"}));
        this.cboCategory.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                ConstraintBuilderFrame.this.cboCategoryItemStateChanged(evt);
            }
        });
        this.lblGeneral.setBackground(new Color(220, 220, 226));
        this.lblGeneral.setHorizontalAlignment(0);
        this.lblGeneral.setText("General");
        this.lblGeneral.setOpaque(true);
        this.cboType.setModel(new DefaultComboBoxModel<String>(new String[]{"Type"}));
        this.cboType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConstraintBuilderFrame.this.cboTypeActionPerformed(evt);
            }
        });
        this.txtName.setText("Constraint");
        GroupLayout pnlConfigCategoryLayout = new GroupLayout(this.pnlConfigCategory);
        this.pnlConfigCategory.setLayout(pnlConfigCategoryLayout);
        pnlConfigCategoryLayout.setHorizontalGroup(pnlConfigCategoryLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblGeneral, -1, -1, Short.MAX_VALUE).addGroup(pnlConfigCategoryLayout.createSequentialGroup().addContainerGap().addGroup(pnlConfigCategoryLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.cboType, 0, 142, Short.MAX_VALUE).addComponent(this.cboCategory, 0, -1, Short.MAX_VALUE).addComponent(this.txtName)).addContainerGap(-1, Short.MAX_VALUE)));
        pnlConfigCategoryLayout.setVerticalGroup(pnlConfigCategoryLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlConfigCategoryLayout.createSequentialGroup().addComponent(this.lblGeneral, -2, 20, -2).addGap(3, 3, 3).addComponent(this.txtName, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cboCategory, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cboType, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.pnlComp.setBorder(new LineBorder(new Color(153, 153, 153), 1, true));
        this.lblLHS.setBackground(new Color(220, 220, 226));
        this.lblLHS.setHorizontalAlignment(0);
        this.lblLHS.setText("Component");
        this.lblLHS.setOpaque(true);
        this.objectTreeView.setFont(new Font("Tahoma", 0, 10));
        DefaultMutableTreeNode treeNode1 = new DefaultMutableTreeNode("Database");
        this.objectTreeView.setModel(new DefaultTreeModel(treeNode1));
        this.objectTreeView.addTreeWillExpandListener(new TreeWillExpandListener(){

            @Override
            public void treeWillCollapse(TreeExpansionEvent evt) throws ExpandVetoException {
            }

            @Override
            public void treeWillExpand(TreeExpansionEvent evt) throws ExpandVetoException {
                ConstraintBuilderFrame.this.objectTreeViewTreeWillExpand(evt);
            }
        });
        this.objectTreeView.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                ConstraintBuilderFrame.this.objectTreeViewMouseClicked(evt);
            }
        });
        this.jScrollPane2.setViewportView(this.objectTreeView);
        GroupLayout pnlCompLayout = new GroupLayout(this.pnlComp);
        this.pnlComp.setLayout(pnlCompLayout);
        pnlCompLayout.setHorizontalGroup(pnlCompLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblLHS, -1, -1, Short.MAX_VALUE).addComponent(this.jScrollPane2, GroupLayout.Alignment.TRAILING, -2, 162, -2));
        pnlCompLayout.setVerticalGroup(pnlCompLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlCompLayout.createSequentialGroup().addComponent(this.lblLHS, -2, 20, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane2, -1, 75, Short.MAX_VALUE)));
        this.pnlVariable.setBorder(new LineBorder(new Color(153, 153, 153), 1, true));
        this.lblVariable.setBackground(new Color(220, 220, 226));
        this.lblVariable.setHorizontalAlignment(0);
        this.lblVariable.setText("Variable");
        this.lblVariable.setOpaque(true);
        this.btnAdd.setFont(new Font("Tahoma", 0, 10));
        this.btnAdd.setText(">>");
        this.btnAdd.setEnabled(false);
        this.btnAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConstraintBuilderFrame.this.btnAddActionPerformed(evt);
            }
        });
        this.txtCoefficient.setText("1.0");
        this.lblCoefficient.setFont(new Font("Tahoma", 0, 10));
        this.lblCoefficient.setText("Coeffient");
        this.lstVariable.setFont(new Font("Tahoma", 0, 10));
        this.lstVariable.setModel(new AbstractListModel(){
            String[] strings = new String[]{""};

            @Override
            public int getSize() {
                return this.strings.length;
            }

            @Override
            public Object getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.lstVariable.setSelectionMode(0);
        this.lstVariable.setToolTipText("");
        this.lstVariable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                ConstraintBuilderFrame.this.lstVariableMouseClicked(evt);
            }
        });
        this.lstVariable.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                ConstraintBuilderFrame.this.lstVariableValueChanged(evt);
            }
        });
        this.jScrollPane3.setViewportView(this.lstVariable);
        GroupLayout pnlVariableLayout = new GroupLayout(this.pnlVariable);
        this.pnlVariable.setLayout(pnlVariableLayout);
        pnlVariableLayout.setHorizontalGroup(pnlVariableLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblVariable, -1, -1, Short.MAX_VALUE).addGroup(pnlVariableLayout.createSequentialGroup().addGap(4, 4, 4).addComponent(this.lblCoefficient, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.txtCoefficient, -2, 55, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnAdd)).addComponent(this.jScrollPane3, GroupLayout.Alignment.TRAILING));
        pnlVariableLayout.setVerticalGroup(pnlVariableLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlVariableLayout.createSequentialGroup().addComponent(this.lblVariable, -2, 20, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane3, -1, 86, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pnlVariableLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.lblCoefficient).addComponent(this.txtCoefficient, -2, -1, -2).addComponent(this.btnAdd))));
        GroupLayout pnlControlLayout = new GroupLayout(this.pnlControl);
        this.pnlControl.setLayout(pnlControlLayout);
        pnlControlLayout.setHorizontalGroup(pnlControlLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlControlLayout.createSequentialGroup().addContainerGap().addGroup(pnlControlLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.pnlConfigCategory, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.pnlComp, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.pnlVariable, -2, -1, -2)).addContainerGap()));
        pnlControlLayout.setVerticalGroup(pnlControlLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlControlLayout.createSequentialGroup().addContainerGap().addComponent(this.pnlConfigCategory, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.pnlComp, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.pnlVariable, -2, -1, -2).addGap(15, 15, 15)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.pnlControl, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.pnlMain, -1, -1, Short.MAX_VALUE)).addComponent(this.pnlTittle, -2, 555, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.pnlTittle, -2, 77, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.pnlControl, -1, -1, Short.MAX_VALUE).addComponent(this.pnlMain, -1, -1, Short.MAX_VALUE))));
        this.pack();
    }

    private void btnCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void cboTypeActionPerformed(ActionEvent evt) {
        JComboBox jBox = (JComboBox)evt.getSource();
        Object oSense = jBox.getSelectedItem();
        if (oSense instanceof DE_GeneralEnums.ConstraintSenseType) {
            this.setSenseLabel((DE_GeneralEnums.ConstraintSenseType)((Object)oSense));
        }
    }

    private void objectTreeViewMouseClicked(MouseEvent evt) {
    }

    private void lstVariableMouseClicked(MouseEvent evt) {
    }

    private void btnAddActionPerformed(ActionEvent evt) {
        this.addSelectionToConstraint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void btnFinishActionPerformed(ActionEvent evt) {
        try {
            this.saveConstraint();
        }
        catch (Exception e) {
            System.out.println("Unexpected error storing constraint. " + e);
            e.printStackTrace(System.err);
        }
        finally {
            this.dispose();
        }
    }

    private void cboCategoryItemStateChanged(ItemEvent evt) {
        this.updateVariableList(this.getClassNameSelected());
    }

    private void txtLHSKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 8) {
            int caretPos = this.txtLHS.getCaretPosition();
            try {
                int nLine = this.txtLHS.getLineOfOffset(caretPos);
                int iniTxt = this.txtLHS.getLineStartOffset(nLine);
                int endTxt = this.txtLHS.getLineEndOffset(nLine);
                this.txtLHS.setSelectionStart(iniTxt);
                this.txtLHS.setSelectionEnd(endTxt);
                String text = this.txtLHS.getSelectedText();
                if (text != null) {
                    this.removeSelectionFromConstraint(nLine);
                }
            }
            catch (BadLocationException ex) {
                Logger.getLogger(ConstraintBuilderFrame.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private void lstVariableValueChanged(ListSelectionEvent evt) {
        this.btnAdd.setEnabled(this.isValidLHSSelection());
    }

    private void objectTreeViewTreeWillExpand(TreeExpansionEvent evt) throws ExpandVetoException {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)evt.getPath().getLastPathComponent();
        if (node == null) {
            return;
        }
        if (!node.isLeaf()) {
            Enumeration<TreeNode> e = node.children();
            ArrayList<TreeNode> l = Collections.list(e);
            Utils.sortCompListByName(l);
            node.removeAllChildren();
            for (DefaultMutableTreeNode defaultMutableTreeNode : l) {
                node.add(defaultMutableTreeNode);
            }
        }
    }
}

