/*
 * Decompiled with CFR 0.152.
 */
package de.core;

import de.core.ConstraintCoefficient;
import de.core.DeepEdit;
import de.core.comp;
import de.data.DE_GeneralEnums;
import de.data.DE_ValidationException;
import de.data.DE_VariableEnums;
import de.data.ParameterData;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class Constraint
extends comp {
    private Map<Integer, ConstraintCoefficient> lLHS = new LinkedHashMap<Integer, ConstraintCoefficient>();
    private double dRHS;
    private double dPrice;
    private DE_GeneralEnums.ConstraintType eType = DE_GeneralEnums.ConstraintType.Hard;
    private DE_GeneralEnums.ConstraintSenseType eSense = DE_GeneralEnums.ConstraintSenseType.Lower_Than;
    private DE_GeneralEnums.ConstraintCategory eCategory = DE_GeneralEnums.ConstraintCategory.Generic;
    private static final double VALUE_TOLERANCE = 1.0E-5;

    public Constraint(String Name, int entryperiod, int exitperiod) {
        super(Name, entryperiod, exitperiod);
        this.ClassName = "Constraint";
    }

    @Override
    public comp Copy(int xo, int yo) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public double getRHS() {
        return this.dRHS;
    }

    public boolean setRHS(double dRHS) {
        this.dRHS = dRHS;
        return true;
    }

    public double getPenaltyPrice() {
        if (this.eType != null && this.eType == DE_GeneralEnums.ConstraintType.Hard) {
            return 0.0;
        }
        return this.dPrice;
    }

    public void setPenaltyPrice(double dPrice) {
        if (dPrice != 0.0) {
            this.eType = DE_GeneralEnums.ConstraintType.Soft_repair;
        }
        this.dPrice = dPrice;
    }

    public DE_GeneralEnums.ConstraintType getType() {
        return this.eType;
    }

    public void setType(DE_GeneralEnums.ConstraintType eType) {
        this.eType = eType;
    }

    public DE_GeneralEnums.ConstraintSenseType getSense() {
        if (this.eSense == null) {
            return DE_GeneralEnums.ConstraintSenseType.Lower_Than;
        }
        return this.eSense;
    }

    public void setSense(DE_GeneralEnums.ConstraintSenseType eSense) {
        if (eSense == null) {
            return;
        }
        if (this.eCategory == DE_GeneralEnums.ConstraintCategory.Generic) {
            this.eSense = eSense;
        }
    }

    public DE_GeneralEnums.ConstraintCategory getCategory() {
        if (this.eCategory == null) {
            this.eCategory = DE_GeneralEnums.ConstraintCategory.Generic;
        }
        return this.eCategory;
    }

    public void setCategory(DE_GeneralEnums.ConstraintCategory eCategory) {
        if (eCategory != null) {
            this.eCategory = eCategory;
            this.setSense(eCategory);
        }
    }

    public void setSense(DE_GeneralEnums.ConstraintCategory eCategory) {
        switch (eCategory) {
            case Generic: {
                break;
            }
            case FCF: {
                this.eSense = DE_GeneralEnums.ConstraintSenseType.Greater_Than;
                break;
            }
            case PET_rpot: {
                this.eSense = DE_GeneralEnums.ConstraintSenseType.Lower_Than;
                break;
            }
            case PET_rea: {
                this.eSense = DE_GeneralEnums.ConstraintSenseType.Greater_Than;
                break;
            }
            case PET_rpa: {
                this.eSense = DE_GeneralEnums.ConstraintSenseType.Lower_Than;
                break;
            }
            case PET_pce: {
                this.eSense = DE_GeneralEnums.ConstraintSenseType.Equality;
                break;
            }
            case PET_pcn: {
                this.eSense = DE_GeneralEnums.ConstraintSenseType.Equality;
                break;
            }
            case PET_pco: {
                this.eSense = DE_GeneralEnums.ConstraintSenseType.Equality;
                break;
            }
            case PET_pex: {
                this.eSense = DE_GeneralEnums.ConstraintSenseType.Lower_Than;
                break;
            }
            case PET_pre: {
                this.eSense = DE_GeneralEnums.ConstraintSenseType.Equality;
            }
        }
    }

    @Override
    public void saveToFile(PrintStream ps) {
        super.saveToFile(ps);
        for (ConstraintCoefficient coeff : this.lLHS.values()) {
            ps.println("describe component ConstraintRecord");
            coeff.saveToFile(ps);
            ps.println(" constraintname " + this.getName());
            ps.println("end describe component");
        }
    }

    public static boolean isValidCoefficient(double dValue, DE_VariableEnums.DE_Variable variable, comp component, DE_GeneralEnums.ConstraintCategory category) throws DE_ValidationException {
        switch (category) {
            case Generic: {
                return true;
            }
            case FCF: {
                return true;
            }
            case PET_pce: {
                if (Constraint.isEqualToRef(dValue, 1.0) || Constraint.isEqualToRef(dValue, -1.0)) {
                    return true;
                }
                throw new DE_ValidationException(String.valueOf(dValue), "x{-1,0,1}");
            }
            case PET_pcn: {
                if (Constraint.isEqualToRef(dValue, 1.0) || Constraint.isEqualToRef(dValue, -1.0)) {
                    return true;
                }
                throw new DE_ValidationException(String.valueOf(dValue), "x{-1,0,1}");
            }
            case PET_pco: {
                if (Constraint.isEqualToRef(dValue, 1.0) || Constraint.isEqualToRef(dValue, -1.0)) {
                    return true;
                }
                throw new DE_ValidationException(String.valueOf(dValue), "x{-1,0,1}");
            }
            case PET_pex: {
                if (!Constraint.isEqualToRef(dValue, 1.0)) {
                    throw new DE_ValidationException(String.valueOf(dValue), "x{0,1}");
                }
                return true;
            }
            case PET_pre: {
                if (Constraint.isEqualToRef(dValue, 1.0) || Constraint.isEqualToRef(dValue, -1.0)) {
                    return true;
                }
                throw new DE_ValidationException(String.valueOf(dValue), "x{-1,0,1}");
            }
            case PET_rco: {
                if (!Constraint.isEqualToRef(dValue, 1.0)) {
                    throw new DE_ValidationException(String.valueOf(dValue), "x{0,1}");
                }
                return true;
            }
            case PET_rea: {
                if (!Constraint.isEqualToRef(dValue, 1.0)) {
                    throw new DE_ValidationException(String.valueOf(dValue), "x{0,1}");
                }
                return true;
            }
            case PET_rpa: {
                if (!Constraint.isEqualToRef(dValue, 1.0)) {
                    throw new DE_ValidationException(String.valueOf(dValue), "x{0,1}");
                }
                return true;
            }
            case PET_rpot: {
                if (!Constraint.isEqualToRef(dValue, 1.0)) {
                    throw new DE_ValidationException(String.valueOf(dValue), "x{0,1}");
                }
                return true;
            }
            case PET_irie: {
                if (!Constraint.isEqualToRef(dValue, 1.0)) {
                    throw new DE_ValidationException(String.valueOf(dValue), "x{0,1}");
                }
                return true;
            }
        }
        return true;
    }

    private static boolean isEqualToRef(double dValue, double dRef) {
        return dRef - 1.0E-5 < dValue && dValue < dRef + 1.0E-5;
    }

    public boolean setCoefficient(double dValue, DE_VariableEnums.DE_Variable variable, comp component) {
        if (variable == null || component == null) {
            return false;
        }
        ConstraintCoefficient coef = new ConstraintCoefficient(dValue, variable, component);
        this.lLHS.put(coef.getId(), coef);
        return true;
    }

    private boolean setCoefficient(double dValue, String variableName, String compName, String compClassName) {
        DE_VariableEnums.DE_Variable var = DE_VariableEnums.getVariable(variableName, compClassName);
        assert (var != null) : "Why there is no match for variable '" + variableName + "'. Did you change Builder??";
        ConstraintCoefficient coef = new ConstraintCoefficient(dValue, var, compName, compClassName);
        this.lLHS.put(coef.getId(), coef);
        return true;
    }

    public boolean setCoefficient(Properties p) {
        double dValue;
        try {
            dValue = Double.parseDouble(p.getProperty("coefficient"));
        }
        catch (NumberFormatException e) {
            assert (false) : "Why did you store an invalid coefficient value??" + p.getProperty("coefficient");
            return false;
        }
        String objectName = p.getProperty("objectname");
        String className = p.getProperty("classname");
        String variableName = p.getProperty("variablename");
        assert (objectName != null && className != null && variableName != null) : "Why are you trying to store an incomplete coefficient? Did you make changes to the ConstraintRecord? did you store an invalid coefficient value??" + p.getProperty("objectname") + " " + p.getProperty("variablename") + " " + p.getProperty("coefficient");
        return this.setCoefficient(dValue, variableName, objectName, className);
    }

    public boolean removeCoefficient(DE_VariableEnums.DE_Variable variable, comp component) {
        int id = this.getCoefficientID(variable.toString(), component);
        return this.removeCoefficient(id);
    }

    public boolean removeCoefficient(int id) {
        return this.lLHS.remove(id) != null;
    }

    public int removeAllCoefficient(comp component) {
        int cont = 0;
        for (Map.Entry<Integer, ConstraintCoefficient> coeff : this.lLHS.entrySet()) {
            if (!component.getName().equalsIgnoreCase(coeff.getValue().getObjectname()) || !component.getClassName().equalsIgnoreCase(coeff.getValue().getClassname())) continue;
            ConstraintCoefficient oldCoeff = this.lLHS.remove(coeff.getKey());
            ++cont;
        }
        return cont;
    }

    private void refresh() {
        for (int id : this.getAllCoefficientIDs()) {
            comp DE_Comp = this.getCoefficientComp(id);
            if (DE_Comp != null) continue;
            this.removeCoefficient(id);
        }
    }

    public void removeAllCoefficient() {
        this.lLHS.clear();
    }

    public double getCoefficientValue(String variableName, comp component) {
        int id = this.getCoefficientID(variableName, component);
        return this.lLHS.get(id).getCoefficient();
    }

    public int getCoefficientID(String variableName, comp component) {
        return this.getCoefficientID(variableName, component.getName(), component.getClassName());
    }

    private int getCoefficientID(String variableName, String component, String className) {
        for (Map.Entry<Integer, ConstraintCoefficient> rec : this.lLHS.entrySet()) {
            ConstraintCoefficient coeff = rec.getValue();
            if (!coeff.getObjectname().equals(component) || !coeff.getClassname().equalsIgnoreCase(className) || !coeff.getVariablename().equalsIgnoreCase(variableName)) continue;
            return rec.getKey();
        }
        return -1;
    }

    public int[] getAllCoefficientIDs() {
        int nCoeff = this.lLHS.keySet().size();
        int[] Ids = new int[nCoeff];
        int cont = 0;
        Iterator<Integer> i$ = this.lLHS.keySet().iterator();
        while (i$.hasNext()) {
            int i;
            Ids[cont] = i = i$.next().intValue();
            ++cont;
        }
        return Ids;
    }

    public double[] getAllCoefficientValues() {
        int nCoeff = this.lLHS.keySet().size();
        double[] dValues = new double[nCoeff];
        int cont = 0;
        for (ConstraintCoefficient coeff : this.lLHS.values()) {
            dValues[cont] = coeff.getCoefficient();
            ++cont;
        }
        return dValues;
    }

    public double getCoefficientValue(int coefficientID) {
        ConstraintCoefficient coeff = this.lLHS.get(coefficientID);
        if (coeff != null) {
            return coeff.getCoefficient();
        }
        return 0.0;
    }

    public DE_VariableEnums.DE_Variable getCoefficientVariable(int coefficientID) {
        ConstraintCoefficient coeff = this.lLHS.get(coefficientID);
        if (coeff != null) {
            return coeff.getVariable();
        }
        return null;
    }

    public comp getCoefficientComp(int coefficientID) {
        comp component = null;
        ConstraintCoefficient coeff = this.lLHS.get(coefficientID);
        assert (coeff != null) : "Why this id " + coefficientID + " is invalid? Did you mess up with the comp's id";
        if (coeff != null && (component = coeff.getComponent()) == null) {
            component = DeepEdit.getComponent(coeff.getObjectname(), coeff.getClassname());
        }
        assert (component != null) : "Why " + coeff.getObjectname() + " of class " + coeff.getClassname() + " doesn't exist anymore in main Schematic?? Did you add/rename/delete this object without registering deletion?";
        return component;
    }

    public String getCoefficientCompName(int coefficientID) {
        ConstraintCoefficient coeff = this.lLHS.get(coefficientID);
        assert (coeff != null) : "Why this id " + coefficientID + " is invalid?";
        if (coeff != null) {
            return coeff.getObjectname();
        }
        return null;
    }

    public String getCoefficientCompClassName(int coefficientID) {
        ConstraintCoefficient coeff = this.lLHS.get(coefficientID);
        assert (coeff != null) : "Why this id " + coefficientID + " is invalid?";
        return coeff.getClassname();
    }

    @Override
    public boolean getParameterInfo(String sParameterName, ParameterData oData) {
        String sValue = null;
        DE_GeneralEnums.databaseDataType eDataType = null;
        DE_GeneralEnums.parameterGroup eGroup = null;
        oData.seteGroup(DE_GeneralEnums.parameterGroup.Operation);
        if (sParameterName.equalsIgnoreCase("Name")) {
            sValue = this.getName();
            eDataType = DE_GeneralEnums.databaseDataType.StringValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("RHS")) {
            sValue = String.valueOf(this.getRHS());
            eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("type")) {
            sValue = this.getType().name();
            eDataType = DE_GeneralEnums.databaseDataType.StringValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("category")) {
            sValue = this.eCategory.name();
            eDataType = DE_GeneralEnums.databaseDataType.StringValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("sense")) {
            sValue = this.getSense().name();
            eDataType = DE_GeneralEnums.databaseDataType.StringValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("inservice")) {
            sValue = String.valueOf(this.getinservice());
            eDataType = DE_GeneralEnums.databaseDataType.BooleanValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("penaltyprice")) {
            sValue = String.valueOf(this.getPenaltyPrice());
            eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        }
        if (sValue != null) {
            oData.setValue(sValue, eDataType, eGroup);
        } else {
            ParameterData oDataOld = (ParameterData)this.mData.get(sParameterName);
            if (oDataOld == null && (oDataOld = DeepEdit.getDefaultParameterInfo(this.ClassName, sParameterName)) == null) {
                assert (false) : "Why are you looking for parameter '" + sParameterName + "' if it is not supported by object '" + this.ClassName + "?";
                return false;
            }
            oDataOld.copyParameterInto(oData);
        }
        return true;
    }

    @Override
    public boolean setParameterInfo(String sParameterName, ParameterData pData) {
        String sValue = pData.getValue();
        if (sParameterName.equalsIgnoreCase("Name")) {
            this.setName(sValue);
            return true;
        }
        if (sParameterName.equalsIgnoreCase("RHS")) {
            this.setRHS(Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("type")) {
            this.setType(DE_GeneralEnums.ConstraintType.valueOf(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("category")) {
            this.setCategory(DE_GeneralEnums.ConstraintCategory.valueOf(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("sense")) {
            this.setSense(DE_GeneralEnums.ConstraintSenseType.valueOf(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("inservice")) {
            this.setinservice(Boolean.parseBoolean(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("entryperiod")) {
            this.setentry_period((int)Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("exitperiod")) {
            this.setexit_period((int)Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("entrymonth")) {
            this.setentry_month((int)Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("exitmonth")) {
            this.setexit_month((int)Double.parseDouble(sValue));
            return true;
        }
        ParameterData pDataOld = (ParameterData)this.mData.get(sParameterName);
        if (pDataOld != null) {
            pDataOld.setValue(sValue);
        } else {
            this.mData.put(sParameterName, pData);
        }
        return true;
    }

    public List<DE_VariableEnums.DE_Variable> getVariableList(String className) {
        return Constraint.getVariableList(className, this.getCategory());
    }

    public static List<DE_VariableEnums.DE_Variable> getVariableList(String className, DE_GeneralEnums.ConstraintCategory eCategory) {
        ArrayList<DE_VariableEnums.DE_Variable> lRet = new ArrayList<DE_VariableEnums.DE_Variable>();
        List<DE_VariableEnums.DE_Variable> lVar = Constraint.getCategoryVariableList(eCategory);
        for (DE_VariableEnums.DE_Variable var : lVar) {
            if (!var.getClassName().equalsIgnoreCase(className)) continue;
            lRet.add(var);
        }
        return lRet;
    }

    public static List<DE_VariableEnums.DE_Variable> getCategoryVariableList(DE_GeneralEnums.ConstraintCategory eCategory) {
        ArrayList<DE_VariableEnums.DE_Variable> lRet = new ArrayList<DE_VariableEnums.DE_Variable>();
        switch (eCategory) {
            case Generic: {
                lRet.addAll(Arrays.asList(DE_VariableEnums.Generator.values()));
                lRet.addAll(Arrays.asList(DE_VariableEnums.GeneratorCHP.values()));
                lRet.addAll(Arrays.asList(DE_VariableEnums.GeneratorDG.values()));
                lRet.addAll(Arrays.asList(DE_VariableEnums.GeneratorEO.values()));
                lRet.addAll(Arrays.asList(DE_VariableEnums.GeneratorPV.values()));
                lRet.addAll(Arrays.asList(DE_VariableEnums.Line.values()));
                lRet.addAll(Arrays.asList(DE_VariableEnums.Trafo.values()));
                break;
            }
            case FCF: {
                lRet.add(DE_VariableEnums.hdb_res.Volume);
                break;
            }
            case PET_rpot: {
                lRet.add(DE_VariableEnums.Generator.Build_Capacity);
                lRet.add(DE_VariableEnums.GeneratorCHP.Build_Capacity);
                lRet.add(DE_VariableEnums.GeneratorDG.Build_Capacity);
                lRet.add(DE_VariableEnums.GeneratorEO.Build_Capacity);
                lRet.add(DE_VariableEnums.GeneratorPV.Build_Capacity);
                break;
            }
            case PET_rea: {
                lRet.add(DE_VariableEnums.Generator.Generation_P);
                lRet.add(DE_VariableEnums.GeneratorCHP.Generation_P);
                lRet.add(DE_VariableEnums.GeneratorDG.Generation_P);
                lRet.add(DE_VariableEnums.GeneratorEO.Generation_P);
                lRet.add(DE_VariableEnums.GeneratorPV.Generation_P);
                break;
            }
            case PET_rpa: {
                lRet.add(DE_VariableEnums.Generator.Build_Capacity);
                lRet.add(DE_VariableEnums.GeneratorCHP.Build_Capacity);
                lRet.add(DE_VariableEnums.GeneratorDG.Build_Capacity);
                lRet.add(DE_VariableEnums.GeneratorEO.Build_Capacity);
                lRet.add(DE_VariableEnums.GeneratorPV.Build_Capacity);
                break;
            }
            case PET_pce: {
                lRet.add(DE_VariableEnums.Line.Build_Decision);
                lRet.add(DE_VariableEnums.Trafo.Build_Decision);
                break;
            }
            case PET_pcn: {
                lRet.add(DE_VariableEnums.Line.Build_Decision);
                lRet.add(DE_VariableEnums.Trafo.Build_Decision);
                break;
            }
            case PET_pco: {
                lRet.add(DE_VariableEnums.Generator.Build_Decision);
                lRet.add(DE_VariableEnums.GeneratorCHP.Build_Capacity);
                lRet.add(DE_VariableEnums.GeneratorDG.Build_Capacity);
                lRet.add(DE_VariableEnums.GeneratorEO.Build_Capacity);
                lRet.add(DE_VariableEnums.GeneratorPV.Build_Capacity);
                lRet.add(DE_VariableEnums.Line.Build_Decision);
                lRet.add(DE_VariableEnums.Trafo.Build_Decision);
                break;
            }
            case PET_pex: {
                lRet.add(DE_VariableEnums.Generator.Build_Decision);
                lRet.add(DE_VariableEnums.GeneratorCHP.Build_Capacity);
                lRet.add(DE_VariableEnums.GeneratorDG.Build_Capacity);
                lRet.add(DE_VariableEnums.GeneratorEO.Build_Capacity);
                lRet.add(DE_VariableEnums.GeneratorPV.Build_Capacity);
                lRet.add(DE_VariableEnums.Line.Build_Decision);
                lRet.add(DE_VariableEnums.Trafo.Build_Decision);
                break;
            }
            case PET_pre: {
                lRet.add(DE_VariableEnums.Generator.Build_Decision);
                lRet.add(DE_VariableEnums.GeneratorCHP.Build_Capacity);
                lRet.add(DE_VariableEnums.GeneratorDG.Build_Capacity);
                lRet.add(DE_VariableEnums.GeneratorEO.Build_Capacity);
                lRet.add(DE_VariableEnums.GeneratorPV.Build_Capacity);
                lRet.add(DE_VariableEnums.Line.Build_Decision);
                lRet.add(DE_VariableEnums.Trafo.Build_Decision);
                break;
            }
            case PET_rco: {
                lRet.add(DE_VariableEnums.Generator.Build_Decision);
                lRet.add(DE_VariableEnums.GeneratorCHP.Build_Capacity);
                lRet.add(DE_VariableEnums.GeneratorDG.Build_Capacity);
                lRet.add(DE_VariableEnums.GeneratorEO.Build_Capacity);
                lRet.add(DE_VariableEnums.GeneratorPV.Build_Capacity);
                break;
            }
            case PET_rtx: {
                lRet.add(DE_VariableEnums.Line.Flow_P);
                break;
            }
            case PET_irie: {
                lRet.add(DE_VariableEnums.hdb_res.Flow_Filtered);
                lRet.add(DE_VariableEnums.hdb_res.Flow_Spilled);
                lRet.add(DE_VariableEnums.hdb_res.Flow_Turbined);
                lRet.add(DE_VariableEnums.hdb_res.Flow_Inflow);
                break;
            }
        }
        return lRet;
    }

    public static List<String> getCategoryClassNameList(DE_GeneralEnums.ConstraintCategory eCategory) {
        ArrayList<String> lRet = new ArrayList<String>();
        List<DE_VariableEnums.DE_Variable> lVar = Constraint.getCategoryVariableList(eCategory);
        for (DE_VariableEnums.DE_Variable var : lVar) {
            if (lRet.contains(var.getClassName())) continue;
            lRet.add(var.getClassName());
        }
        return lRet;
    }
}

