/*
 * Decompiled with CFR 0.152.
 */
package de.core;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import javax.swing.JFrame;
import javax.swing.JTextArea;
import javax.swing.text.Document;

public class ConsoleOutputStream
extends OutputStream {
    private Document document = null;
    private JTextArea textArea = null;
    private ByteArrayOutputStream outputStream = new ByteArrayOutputStream(250);
    private PrintStream ps = null;
    int idealSize = 10000;
    int maxExcess = 5000;
    int excess;
    JFrame win = null;

    public ConsoleOutputStream(JTextArea textA, PrintStream ps) {
        this.textArea = textA;
        this.document = textA.getDocument();
        this.ps = ps;
    }

    @Override
    public void write(int b) {
        this.outputStream.write(b);
    }

    @Override
    public void flush() throws IOException {
        super.flush();
        try {
            if (this.textArea != null) {
                this.document.insertString(this.document.getLength(), new String(this.outputStream.toByteArray()), null);
            }
            if (this.ps != null) {
                this.ps.write(this.outputStream.toByteArray());
            }
            this.textArea.setCaretPosition(this.document.getLength());
            this.excess = this.document.getLength() - this.idealSize;
            if (this.excess >= this.maxExcess) {
                this.textArea.replaceRange("", 0, this.excess);
            }
            this.outputStream.reset();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static PrintStream createPStream(JTextArea textA, PrintStream ps) {
        return new PrintStream(new ConsoleOutputStream(textA, ps), true);
    }
}

