/*
 * Decompiled with CFR 0.152.
 */
package de.core;

import de.core.DeepEdit;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Point;
import java.util.Vector;

public abstract class ComponentPin {
    protected Vector ConnComps;
    private int Level = 0;
    private int OldLevel = 0;
    protected Point PinPos;
    private Dimension PinDim;
    private String Name;
    private int Flags;
    private int TextXoffs;
    private int TextYoffs;
    public static final int PIN_NORMAL = 0;
    public static final int PIN_NEGATIVE = 1;
    public static final int PIN_TEXT_INVISIBLE = 2;
    public static final int PIN_EDGETRIGGERED = 4;
    public static final int PIN_NOACTION = 8;
    private final Font PinFont;

    public ComponentPin(ComponentPin PinToCopy) {
        assert (PinToCopy != null) : "Why you are creating a copy of a null Pin? Are you sure you created all component pins for this object?";
        this.Name = PinToCopy.Name;
        this.PinPos = new Point(PinToCopy.PinPos.x, PinToCopy.PinPos.y);
        this.PinDim = new Dimension(PinToCopy.PinDim.width, PinToCopy.PinDim.height);
        this.Flags = PinToCopy.Flags;
        this.TextXoffs = PinToCopy.TextXoffs;
        this.TextYoffs = PinToCopy.TextYoffs;
        this.PinFont = DeepEdit.TextFont;
    }

    public ComponentPin(String name, int x, int y, int w, int h, int txo, int tyo, int fl) {
        this.Name = name;
        this.TextXoffs = txo;
        this.TextYoffs = tyo;
        this.PinPos = new Point(x, y);
        this.PinDim = new Dimension(w, h);
        this.Flags = fl;
        this.PinFont = DeepEdit.TextFont;
    }

    public void draw(Graphics2D g, int x, int y, int gs) {
        g.drawLine((x + this.PinPos.x) * gs, (y + this.PinPos.y) * gs, (x + this.PinPos.x + this.PinDim.width) * gs, (y + this.PinPos.y + this.PinDim.height) * gs);
        if (DeepEdit.ShowPins) {
            g.fillRect((int)(((double)(x + this.PinPos.x) - 0.1) * (double)gs), (int)(((double)(y + this.PinPos.y) - 0.1) * (double)gs), (int)((double)gs * 0.4), (int)((double)gs * 0.4));
        }
    }

    public void HighlightPin(Graphics2D g, int x, int y, int gs) {
        g.setColor(Color.RED);
        g.setStroke(new BasicStroke(2.0f));
        g.drawRect((int)(((double)x - 0.4) * (double)gs), (int)(((double)y - 0.4) * (double)gs), gs, gs);
    }

    public int getLevel() {
        if ((this.Flags & 1) == 0) {
            return this.Level;
        }
        if (this.Level == 0) {
            return 5;
        }
        return 0;
    }

    public int getOldLevel() {
        if ((this.Flags & 1) == 0) {
            return this.OldLevel;
        }
        if (this.OldLevel == 0) {
            return 5;
        }
        return 0;
    }

    public void setLevel(int l) {
        this.OldLevel = this.Level;
        this.Level = l;
    }

    public String getName() {
        return this.Name;
    }

    public void setName(String n) {
        if (n != null) {
            this.Name = n;
        }
    }
}

