/*
 * Decompiled with CFR 0.152.
 */
package de.core;

import de.core.ColorSelectorFrame;
import java.awt.BorderLayout;
import java.awt.Checkbox;
import java.awt.Event;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Scrollbar;

class ColorSliderPanel
extends Panel {
    ColorSelectorFrame controller;
    Label instructionsLabel;
    Checkbox defaultCheckBox;
    Scrollbar slider;

    ColorSliderPanel(ColorSelectorFrame myController, String instructions, int myMaxSize) {
        this.controller = myController;
        int min = 0;
        int max = myMaxSize - 1;
        int start = 0;
        int incr = max / 32;
        this.instructionsLabel = new Label(instructions, 1);
        this.defaultCheckBox = new Checkbox("Use Default");
        this.slider = new Scrollbar(0, start, incr, min, max);
        this.defaultCheckBox.setState(true);
        this.setLayout(new BorderLayout());
        this.add("West", this.instructionsLabel);
        this.add("East", this.defaultCheckBox);
        this.add("South", this.slider);
    }

    int getValue() {
        if (this.defaultCheckBox.getState()) {
            return -1;
        }
        return this.slider.getValue();
    }

    @Override
    public boolean handleEvent(Event e) {
        if (e.target instanceof Scrollbar) {
            this.controller.updateDisplay();
            return true;
        }
        if (e.target instanceof Checkbox) {
            this.controller.updateDisplay();
            return true;
        }
        return false;
    }
}

