/*
 * Decompiled with CFR 0.152.
 */
package de.core;

import de.core.DeepEdit;
import de.core.DisplayPanel;
import de.core.InputPanel;
import de.core.TitlePanel;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Event;
import java.awt.Frame;
import java.awt.Insets;

class ColorSelectorFrame
extends Frame {
    DeepEdit applet;
    TitlePanel titlePanel;
    InputPanel inputPanel;
    DisplayPanel displayPanel;
    int numColorValues = 256;
    int increment = 8;
    int numColors = this.numColorValues / this.increment * 7 + 1;
    Color[] colors = new Color[this.numColors];
    Color defaultBgColor = new Color(0, 0, 60);
    Color defaultGridColor = Color.lightGray;
    Color defaultTextColor1 = Color.lightGray;
    Color defaultTextColor2 = Color.yellow;
    Color defaultCaptionColor = Color.yellow;
    Color defaultContractColor = Color.orange;
    Color defaultColor0 = Color.black;
    Color defaultColor1 = Color.lightGray;
    Color defaultColor105 = Color.green.darker();
    Color defaultColor20 = Color.blue;
    Color defaultColor25 = Color.blue;
    Color defaultColor110 = Color.yellow;
    Color defaultColor220 = Color.green.darker();
    Color defaultColor400 = Color.orange;
    Color defaultColor500 = Color.red;

    public ColorSelectorFrame(DeepEdit app) {
        super("Color Selector");
        this.applet = app;
        this.setBackground(Color.lightGray);
        this.initColorArray();
        this.titlePanel = new TitlePanel(this, "Color Selector Menu", this.colors);
        this.inputPanel = new InputPanel(this, this.colors);
        this.displayPanel = new DisplayPanel(this.defaultBgColor, this.defaultGridColor, this.defaultTextColor1, this.defaultTextColor2, this.defaultCaptionColor, this.defaultContractColor, this.defaultColor0, this.defaultColor20, this.defaultColor110, this.defaultColor220, this.defaultColor400, this.defaultColor500);
        this.setLayout(new BorderLayout());
        this.add("North", this.titlePanel);
        this.add("East", this.displayPanel);
        this.add("Center", this.inputPanel);
        this.setIconImage(this.applet.getFrameIconImage());
        this.pack();
        this.setSize(650, 550);
        this.setVisible(true);
    }

    @Override
    public Insets insets() {
        return new Insets(3, 3, 3, 3);
    }

    private void initColorArray() {
        int blue;
        int green;
        int red;
        int loop;
        int index = 0;
        for (loop = this.numColorValues; loop >= 0; loop -= this.increment) {
            red = loop;
            green = loop;
            blue = loop;
            if (red == this.numColorValues) {
                --red;
            }
            if (green == this.numColorValues) {
                --green;
            }
            if (blue == this.numColorValues) {
                --blue;
            }
            this.colors[index++] = new Color(red, green, blue);
        }
        for (loop = 0; loop <= this.numColorValues - this.increment; loop += this.increment) {
            red = this.numColorValues - 1;
            green = loop;
            blue = 0;
            if (green == this.numColorValues) {
                --green;
            }
            this.colors[index++] = new Color(red, green, blue);
        }
        for (loop = this.numColorValues; loop >= this.increment; loop -= this.increment) {
            red = loop;
            green = this.numColorValues - 1;
            blue = 0;
            if (red == this.numColorValues) {
                --red;
            }
            this.colors[index++] = new Color(red, green, blue);
        }
        for (loop = 0; loop <= this.numColorValues - this.increment; loop += this.increment) {
            red = 0;
            green = this.numColorValues - 1;
            blue = loop;
            if (blue == this.numColorValues) {
                --blue;
            }
            this.colors[index++] = new Color(red, green, blue);
        }
        for (loop = this.numColorValues; loop >= this.increment; loop -= this.increment) {
            red = 0;
            green = loop;
            blue = this.numColorValues - 40;
            if (green == this.numColorValues) {
                --green;
            }
            this.colors[index++] = new Color(red, green, blue);
        }
        for (loop = 0; loop <= this.numColorValues - this.increment; loop += this.increment) {
            red = loop;
            green = 0;
            blue = this.numColorValues - 1;
            if (red == this.numColorValues) {
                --red;
            }
            this.colors[index++] = new Color(red, green, blue);
        }
        for (loop = this.numColorValues; loop >= this.increment; loop -= this.increment) {
            red = this.numColorValues - 1;
            green = 0;
            blue = loop;
            if (blue == this.numColorValues) {
                --blue;
            }
            this.colors[index++] = new Color(red, green, blue);
        }
    }

    void updateDisplay() {
        int BgC = this.inputPanel.BgCSliderPanel.getValue();
        int GridC = this.inputPanel.GridCSliderPanel.getValue();
        int TextC1 = this.inputPanel.TextC1SliderPanel.getValue();
        int TextC2 = this.inputPanel.TextC2SliderPanel.getValue();
        int CaptionC = this.inputPanel.CaptionCSliderPanel.getValue();
        int ContractC = this.inputPanel.ContractCSliderPanel.getValue();
        int C0 = this.inputPanel.C0SliderPanel.getValue();
        int C20 = this.inputPanel.C20SliderPanel.getValue();
        int C110 = this.inputPanel.C110SliderPanel.getValue();
        int C220 = this.inputPanel.C220SliderPanel.getValue();
        int C400 = this.inputPanel.C400SliderPanel.getValue();
        int C500 = this.inputPanel.C500SliderPanel.getValue();
        Color BgColor = BgC >= 0 ? this.colors[BgC] : this.defaultBgColor;
        Color GridColor = GridC >= 0 ? this.colors[GridC] : this.defaultGridColor;
        Color TextColor1 = TextC1 >= 0 ? this.colors[TextC1] : this.defaultTextColor1;
        Color TextColor2 = TextC2 >= 0 ? this.colors[TextC2] : this.defaultTextColor2;
        Color CaptionColor = CaptionC >= 0 ? this.colors[CaptionC] : this.defaultCaptionColor;
        Color ContractColor = ContractC >= 0 ? this.colors[ContractC] : this.defaultContractColor;
        Color Color0 = C0 >= 0 ? this.colors[C0] : this.defaultColor0;
        Color Color20 = C20 >= 0 ? this.colors[C20] : this.defaultColor20;
        Color Color110 = C110 >= 0 ? this.colors[C110] : this.defaultColor110;
        Color Color220 = C220 >= 0 ? this.colors[C220] : this.defaultColor220;
        Color Color400 = C400 >= 0 ? this.colors[C400] : this.defaultColor400;
        Color Color500 = C500 >= 0 ? this.colors[C500] : this.defaultColor500;
        this.displayPanel.updateColors(BgColor, GridColor, TextColor1, TextColor2, CaptionColor, ContractColor, Color0, Color20, Color110, Color220, Color400, Color500);
    }

    @Override
    public boolean handleEvent(Event ev) {
        if (ev.id == 201) {
            this.setVisible(false);
            return true;
        }
        return super.handleEvent(ev);
    }

    @Override
    public boolean action(Event ev, Object arg) {
        if (ev.target instanceof Button) {
            String label = (String)arg;
            if (arg.equals("CANCEL")) {
                this.setVisible(false);
                return true;
            }
            if (arg.equals("OK")) {
                this.applet.BackGroundColor = this.displayPanel.currentBgColor;
                DeepEdit.setGridColor(this.displayPanel.currentGridColor);
                DeepEdit.MySchematicPanel.repaint();
                this.setVisible(false);
                return true;
            }
        }
        return false;
    }
}

