/*
 * Decompiled with CFR 0.152.
 */
package de.core;

import de.core.DeepEdit;
import de.core.DeepEditFrame;
import de.core.InputPin;
import de.core.Load;
import de.core.OutputPin;
import de.core.Pin;
import de.core.comp;
import de.core.ndb_1pol;
import de.core.ndb_2pol;
import de.core.ndb_inj;
import de.data.DE_GeneralEnums;
import de.data.ParameterData;
import de.utils.StringUtil;
import de.utils.Utils;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.io.PrintStream;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;

public class Busbar
extends ndb_1pol {
    protected int num;
    protected double umin;
    protected double umax;
    private InputPin[] tempIPin = null;
    private OutputPin[] tempOPin = null;

    public Busbar(Pin[][] PinGrid, int nnum, int x, int y, int entryperiod, int exitperiod, int entrymonth, int exitmonth) {
        super(x, y, nnum / 2 * 5 + 1, 11, 0, 5, 6 + (nnum - 2) / 2 * 5, 1, nnum / 2, nnum / 2, entryperiod, exitperiod, entrymonth, exitmonth);
        this.num = nnum;
        this.setName("Busbar");
        this.ClassName = "Busbar";
        this.alias = "Busbar";
        this.inv_type = "A";
        this.umin = 0.9;
        this.umax = 1.1;
        this.adjustPins();
        this.RegisterPins(PinGrid, x, y);
    }

    public Busbar(Pin[][] PinGrid, int nnum, int x, int y, String Name, String type, String alias, String owner, String ctrla, double cost, double un1, double un2, double ssmax, int lifetime, int entryperiod, int exitperiod, int entrymonth, int exitmonth, double uumin, double uumax, double latitude, double longitude, boolean iinservice) {
        super(x, y, nnum / 2 * 5 + 1, 11, 0, 5, 6 + (nnum - 2) / 2 * 5, 1, nnum / 2, nnum / 2, Name, type, alias, owner, ctrla, cost, un1, un2, ssmax, lifetime, entryperiod, exitperiod, entrymonth, exitmonth, latitude, longitude);
        this.num = nnum;
        this.umin = uumin;
        this.umax = uumax;
        this.inservice = iinservice;
        this.ClassName = "Busbar";
        this.adjustPins();
        this.RegisterPins(PinGrid, x, y);
    }

    public Busbar(comp CompToCopy, int xo, int yo) {
        super(CompToCopy, xo, yo);
        List<ParameterData> lData = CompToCopy.getAllParametersInfo();
        int n = this.setAllParameterInfo(lData);
        if (n > 0) {
            System.out.println("Warning: '" + n + "' parameters couldn't be copied to " + this.getClassName() + "/" + this.getName());
        }
        this.setxpos(CompToCopy.getxpos() - xo);
        this.setypos(CompToCopy.getypos() - yo);
        this.adjustPins();
    }

    private void adjustPins() {
        this.Inputs = this.num / 2;
        this.Outputs = this.num / 2;
        this.IPin = new InputPin[this.Inputs];
        this.OPin = new OutputPin[this.Outputs];
        for (int i = 0; i < this.num / 2; ++i) {
            String numero = String.valueOf(i + 1);
            this.IPin[i] = new InputPin(numero, 5 * i + 3, 0, 0, 5, 1, 2, 0);
            numero = String.valueOf(this.num / 2 + i + 1);
            this.OPin[i] = new OutputPin(numero, 5 * i + 3, 11, 0, -5, 1, 0, 0);
        }
    }

    public int getnum() {
        return this.num;
    }

    public double getumin() {
        return this.umin;
    }

    public double getumax() {
        return this.umax;
    }

    @Override
    public double getpini() {
        double dTotal_pini = 0.0;
        for (comp c : this.getConnectedComponentList()) {
            if (!(c instanceof Load)) continue;
            dTotal_pini += ((Load)c).getpini();
        }
        return dTotal_pini;
    }

    public double getbeta() {
        double dAvg_beta = 0.0;
        double cont = 0.0;
        for (comp c : this.getConnectedComponentList()) {
            if (!(c instanceof Load)) continue;
            dAvg_beta += ((Load)c).getbeta();
            cont += 1.0;
        }
        return Utils.safeDivision(dAvg_beta, cont);
    }

    public void setnum(int n) {
        if (this.num == n) {
            return;
        }
        if (n % 2 != 0) {
            return;
        }
        this.num = n;
        this.adjustPins();
        this.Dim = new Dimension(this.num / 2 * 5 + 1, 11);
        this.HitBoxSize = new Dimension(6 + (this.num - 2) / 2 * 5, 1);
    }

    public void setumin(double n) {
        this.umin = n;
    }

    public void setumax(double n) {
        this.umax = n;
    }

    @Override
    public void setpini(double n) {
        HashMap<Load, Double> lLoadFactor = new HashMap<Load, Double>();
        for (comp c : this.getConnectedComponentList()) {
            if (!(c instanceof Load)) continue;
            lLoadFactor.put((Load)c, ((Load)c).getLoadFactor());
        }
        for (Load l : lLoadFactor.keySet()) {
            l.setpini(n * (Double)lLoadFactor.get(l));
        }
    }

    @Override
    public comp Copy(int xo, int yo) {
        Busbar NewComponent = new Busbar(this, xo, yo);
        return NewComponent;
    }

    @Override
    public void SimulateLogic() {
    }

    @Override
    public boolean CheckIfComponentInDrawArea(int x1, int y1, int x2, int y2) {
        int y2min;
        boolean aux = true;
        int cx1 = this.Pos.x + this.HitBox.x;
        int cy1 = this.Pos.y + this.HitBox.y - 6;
        int cx2 = this.Pos.x + this.HitBox.x + this.HitBoxSize.width;
        int cy2 = this.Pos.y + this.HitBox.y + this.HitBoxSize.height + 6;
        int x1max = cx1 > x1 ? cx1 : x1;
        int x2min = cx2 < x2 ? cx2 : x2;
        int y1max = cy1 > y1 ? cy1 : y1;
        int n = y2min = cy2 < y2 ? cy2 : y2;
        return x1max <= x2min && y1max <= y2min;
    }

    @Override
    public void Save(PrintStream myPrintStream) {
        myPrintStream.println("describe component " + this.ClassName);
        myPrintStream.println(" pos " + this.Pos.x + " " + this.Pos.y);
        myPrintStream.println(" num " + this.num);
        myPrintStream.println(" umin " + this.umin);
        myPrintStream.println(" umax " + this.umax);
        myPrintStream.println(" Name " + this.ComponentName);
        myPrintStream.println(" type " + this.inv_type);
        myPrintStream.println(" alias " + this.alias);
        myPrintStream.println(" owner " + this.inv_owner);
        myPrintStream.println(" ctrla " + this.ctrla);
        myPrintStream.println(" cost " + this.inv_cost);
        myPrintStream.println(" un1 " + this.un[0]);
        myPrintStream.println(" lifetime " + this.life_time);
        myPrintStream.println(" entryperiod " + this.entry_period);
        myPrintStream.println(" exitperiod " + this.exit_period);
        myPrintStream.println(" entrymonth " + this.entry_month);
        myPrintStream.println(" exitmonth " + this.exit_month);
        myPrintStream.println(" latitude " + this.latitude);
        myPrintStream.println(" longitude " + this.longitude);
        myPrintStream.println(" inservice  " + this.inservice);
        myPrintStream.println("end describe");
    }

    @Override
    public void SaveDatabase() throws SQLException {
        int x = 0;
        Statement stmt = DeepEditFrame.con.createStatement();
        if (this.alias.isEmpty()) {
            this.alias = this.ClassName;
        }
        String query = "INSERT INTO Busbar (num,XPos,YPos,Name,type,alias,owner,ctrla,cost,un1,smax,lifetime,entryperiod,exitperiod,entrymonth,exitmonth,umin,umax,latitude,longitude,U,delta,p,q,p0,q0,spotp,spotq,inservice) VALUES (" + String.valueOf(this.num) + "," + String.valueOf(this.Pos.x) + "," + String.valueOf(this.Pos.y) + ",'" + this.ComponentName + "','" + this.inv_type + "','" + this.alias + "','" + this.inv_owner + "','" + this.ctrla + "'," + String.valueOf(this.inv_cost) + "," + String.valueOf(this.un[0]) + "," + String.valueOf(this.smax) + "," + String.valueOf(this.life_time) + "," + String.valueOf(this.entry_period) + "," + String.valueOf(this.exit_period) + "," + String.valueOf(this.entry_month) + "," + String.valueOf(this.exit_month) + "," + String.valueOf(this.umin) + "," + String.valueOf(this.umax) + "," + String.valueOf(this.latitude) + "," + String.valueOf(this.longitude) + "," + String.valueOf(this.getun2()) + "," + String.valueOf(this.getdelta2()) + "," + String.valueOf(this.p) + "," + String.valueOf(this.q) + "," + String.valueOf(this.p0) + "," + String.valueOf(this.q0) + "," + String.valueOf(this.spot_p) + "," + String.valueOf(this.spot_q) + "," + (this.inservice ? 1 : 0) + ")";
        x = stmt.executeUpdate(query);
        stmt.close();
    }

    public void draw(Graphics2D g, int xp, int yp, int gs, boolean Modifiedstate, double sref, int actperiod, int actmonth, int typsim) {
        super.draw(g, xp, yp, gs);
        int x = this.Pos.x - xp;
        int y = this.Pos.y - yp;
        if (!this.inservice) {
            g.setColor(Color.black);
        } else {
            g.setColor(this.getkv_color1());
        }
        this.DrawInputPins(g, x, y, gs);
        if (!this.inservice) {
            g.setColor(Color.black);
        } else {
            g.setColor(this.getkv_color1());
        }
        this.DrawOutputPins(g, x, y, gs);
        if (!Modifiedstate) {
            if (this.getun2() / this.getun1() > this.getumax()) {
                g.drawImage(DeepEditFrame.file_red, x * gs, y * gs, DeepEdit.MySchematicPanel);
            }
            if (this.getun2() / this.getun1() < this.getumin()) {
                g.drawImage(DeepEditFrame.file_blue, x * gs, y * gs, DeepEdit.MySchematicPanel);
            }
        }
        if (!this.inservice) {
            g.setColor(Color.white);
        } else {
            g.setColor(this.getkv_color1());
        }
        if (gs > 1) {
            g.fillRect((x + this.HitBox.x) * gs, (int)((double)((y + this.HitBox.y) * gs) + 0.25 * (double)gs), this.HitBoxSize.width * gs, (int)((double)(this.HitBoxSize.height * gs) * 0.5));
        } else {
            g.fillRect((x + this.HitBox.x) * gs, (y + this.HitBox.y) * gs, this.HitBoxSize.width * gs, 1);
        }
        if (gs >= 4) {
            if (!this.inservice) {
                g.setColor(Color.gray);
            } else {
                g.setColor(Color.black);
            }
            g.drawRect((x + this.HitBox.x) * gs, (int)((double)((y + this.HitBox.y) * gs) + 0.25 * (double)gs), this.HitBoxSize.width * gs, (int)((double)(this.HitBoxSize.height * gs) * 0.5));
        }
        for (int i = 0; i < this.num / 2; ++i) {
            if (!this.inservice) {
                g.setColor(Color.gray);
            } else {
                g.setColor(this.getkv_color1());
            }
            g.fillOval((int)(((double)(x + this.HitBox.x + 5 * i) + 2.5) * (double)gs), (y + this.HitBox.y) * gs, gs, gs);
            if (gs < 4) continue;
            g.setColor(Color.black);
            g.drawOval((int)(((double)(x + this.HitBox.x + 5 * i) + 2.5) * (double)gs), (y + this.HitBox.y) * gs, gs, gs);
        }
        if (!this.inservice) {
            g.setColor(Color.gray);
        } else {
            g.setColor(this.getkv_color1());
        }
        g.setColor(TextColor2);
        this.auxs = DeepEdit.ShowAlias ? this.alias : this.ComponentName;
        if (gs == 1) {
            return;
        }
        if (gs > 1 && gs < 4) {
            g.setFont(Font8);
            g.drawString(this.auxs, (int)(((double)(x + this.HitBox.x + this.HitBoxSize.width) - 2.5) * (double)gs), (int)(((double)(y + this.HitBox.y) - 0.25) * (double)gs));
        } else if (gs >= 4 && gs < 8) {
            g.setFont(Font10);
            g.drawString(this.auxs, (int)(((double)(x + this.HitBox.x + this.HitBoxSize.width) - 2.5) * (double)gs), (int)(((double)(y + this.HitBox.y) - 0.25) * (double)gs));
        } else if (gs >= 8 && gs < 10) {
            g.setFont(Font11);
            g.drawString(this.auxs, (int)(((double)(x + this.HitBox.x + this.HitBoxSize.width) - 2.5) * (double)gs), (int)(((double)(y + this.HitBox.y) - 0.25) * (double)gs));
        } else if (gs >= 10 && gs < 12) {
            g.setFont(Font12);
            g.drawString(this.auxs, (int)(((double)(x + this.HitBox.x + this.HitBoxSize.width) - 2.5) * (double)gs), (int)(((double)(y + this.HitBox.y) - 0.25) * (double)gs));
            if (!Modifiedstate) {
                g.setColor(TextColor1);
                g.setFont(Font12);
                g.drawString(StringUtil.numformat(this.getun2(), 7, 2) + "," + StringUtil.numformat(this.getdelta2(), 7, 2) + "\u00b0", (int)(((double)(x + this.HitBox.x + this.HitBoxSize.width) - 2.5) * (double)gs), (int)(((double)(y + this.HitBox.y) + 2.0) * (double)gs));
                g.drawString(StringUtil.numformat(this.getun2() / this.getun1() * 100.0, 7, 2) + "," + StringUtil.numformat(this.getdelta2(), 7, 2) + "\u00b0", (int)(((double)(x + this.HitBox.x + this.HitBoxSize.width) - 2.5) * (double)gs), (int)(((double)(y + this.HitBox.y) + 3.0) * (double)gs));
                if (typsim == 1 || typsim == 2 || typsim == 4) {
                    g.setColor(TextColor3);
                    g.drawString(StringUtil.numformat(this.getspot_p(), 7, 2) + " [$/MWh]", (int)(((double)(x + this.HitBox.x + this.HitBoxSize.width) - 2.5) * (double)gs), (int)(((double)(y + this.HitBox.y) + 4.0) * (double)gs));
                    if (typsim == 4) {
                        g.setColor(Color2);
                        g.drawString(StringUtil.numformat(this.getspot_q(), 7, 2) + " [$/MVArh]", (int)(((double)(x + this.HitBox.x + this.HitBoxSize.width) - 2.5) * (double)gs), (int)(((double)(y + this.HitBox.y) + 5.0) * (double)gs));
                    }
                } else if (typsim == 16) {
                    g.setColor(Color.magenta);
                    g.drawString(StringUtil.numformat(this.getun3() / this.getun1() * 100.0, 7, 2) + "," + StringUtil.numformat(this.getdelta3(), 7, 2) + "\u00b0", (int)(((double)(x + this.HitBox.x + this.HitBoxSize.width) - 2.5) * (double)gs), (int)(((double)(y + this.HitBox.y) - 1.5) * (double)gs));
                }
            }
        } else if (gs >= 12) {
            g.setFont(Font14);
            g.setColor(TextColor2);
            g.drawString(this.auxs, (int)(((double)(x + this.HitBox.x + this.HitBoxSize.width) - 2.5) * (double)gs), (int)(((double)(y + this.HitBox.y) - 0.25) * (double)gs));
            if (!Modifiedstate) {
                g.setColor(TextColor1);
                g.setFont(Font14);
                g.drawString(StringUtil.numformat(this.getun2(), 7, 2) + "," + StringUtil.numformat(this.getdelta2(), 6, 2) + "\u00b0", (int)(((double)(x + this.HitBox.x + this.HitBoxSize.width) - 2.5) * (double)gs), (int)(((double)(y + this.HitBox.y) + 2.0) * (double)gs));
                g.drawString(StringUtil.numformat(this.getun2() / this.getun1() * 100.0, 7, 2) + "," + StringUtil.numformat(this.getdelta2(), 6, 2) + "\u00b0", (int)(((double)(x + this.HitBox.x + this.HitBoxSize.width) - 2.5) * (double)gs), (int)(((double)(y + this.HitBox.y) + 3.0) * (double)gs));
                if (typsim == 1 || typsim == 2 || typsim == 4) {
                    g.setColor(TextColor3);
                    g.drawString(StringUtil.numformat(this.getspot_p(), 7, 2) + " [$/MWh]", (int)(((double)(x + this.HitBox.x + this.HitBoxSize.width) - 2.5) * (double)gs), (int)(((double)(y + this.HitBox.y) + 4.0) * (double)gs));
                    if (typsim == 4) {
                        g.setColor(Color2);
                        g.drawString(StringUtil.numformat(this.getspot_q(), 7, 2) + " [$/MVArh]", (int)(((double)(x + this.HitBox.x + this.HitBoxSize.width) - 2.5) * (double)gs), (int)(((double)(y + this.HitBox.y) + 5.0) * (double)gs));
                    }
                } else if (typsim == 16) {
                    g.setColor(Color.magenta);
                    g.drawString(StringUtil.numformat(this.getun3() / this.getun1() * 100.0, 7, 2) + "," + StringUtil.numformat(this.getdelta3(), 7, 2) + "\u00b0", (int)(((double)(x + this.HitBox.x + this.HitBoxSize.width) - 2.5) * (double)gs), (int)(((double)(y + this.HitBox.y) - 1.5) * (double)gs));
                }
            }
        }
    }

    public void hideUnusedPins() {
        comp tempComp;
        int j;
        Vector conCompVec;
        int i;
        int nIpins = 0;
        int nOpins = 0;
        boolean pinWithCon = false;
        InputPin[] auxIPin = null;
        OutputPin[] auxOPin = null;
        this.tempIPin = new InputPin[this.Inputs];
        for (i = 0; i < this.Inputs; ++i) {
            pinWithCon = false;
            conCompVec = this.IPin[i].ConnComps;
            if (conCompVec != null && conCompVec.size() > 0) {
                for (j = 0; j < conCompVec.size(); ++j) {
                    tempComp = (comp)conCompVec.elementAt(j);
                    if (!(tempComp instanceof ndb_inj) && !(tempComp instanceof ndb_2pol)) continue;
                    pinWithCon = true;
                    break;
                }
            }
            if (!pinWithCon) continue;
            this.tempIPin[nIpins] = this.IPin[i];
            ++nIpins;
        }
        this.tempOPin = new OutputPin[this.Outputs];
        for (i = 0; i < this.Outputs; ++i) {
            pinWithCon = false;
            conCompVec = this.OPin[i].ConnComps;
            if (conCompVec != null && conCompVec.size() > 0) {
                for (j = 0; j < conCompVec.size(); ++j) {
                    tempComp = (comp)conCompVec.elementAt(j);
                    if (!(tempComp instanceof Load) && !(tempComp instanceof ndb_2pol)) continue;
                    pinWithCon = true;
                    break;
                }
            }
            if (!pinWithCon) continue;
            this.tempOPin[nOpins] = this.OPin[i];
            ++nOpins;
        }
        auxIPin = this.IPin;
        auxOPin = this.OPin;
        this.IPin = this.tempIPin;
        this.OPin = this.tempOPin;
        this.tempIPin = auxIPin;
        this.tempOPin = auxOPin;
        this.Inputs = nIpins;
        this.Outputs = nOpins;
    }

    public void showUnusedPins() {
        if (this.tempIPin == null) {
            return;
        }
        this.IPin = this.tempIPin;
        this.OPin = this.tempOPin;
        this.tempIPin = null;
        this.tempOPin = null;
        this.Inputs = this.num / 2;
        this.Outputs = this.num / 2;
    }

    public String Statistic(int ix, double sref) {
        String line = StringUtil.printf(this.getName(), 20) + " " + StringUtil.printf(this.getun1(), 10, 2);
        return line;
    }

    @Override
    public boolean getParameterInfo(String sParameterName, ParameterData oData) {
        String sValue = null;
        DE_GeneralEnums.databaseDataType eDataType = null;
        DE_GeneralEnums.parameterGroup eGroup = null;
        oData.seteGroup(DE_GeneralEnums.parameterGroup.Operation);
        if (sParameterName.equalsIgnoreCase("Name")) {
            sValue = this.getName();
            eDataType = DE_GeneralEnums.databaseDataType.StringValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("con2")) {
            sValue = this.getcon2();
            eDataType = DE_GeneralEnums.databaseDataType.StringValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("alias")) {
            sValue = this.getalias();
            eDataType = DE_GeneralEnums.databaseDataType.StringValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("p")) {
            sValue = String.valueOf(this.getp());
            eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("q")) {
            sValue = String.valueOf(this.getq());
            eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("p0")) {
            sValue = String.valueOf(this.getp0());
            eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("q0")) {
            sValue = String.valueOf(this.getq0());
            eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("un1")) {
            sValue = String.valueOf(this.getun1());
            eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("smax")) {
            sValue = String.valueOf(this.getsmax());
            eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("sn")) {
            sValue = String.valueOf(this.getsn());
            eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("lftype")) {
            sValue = String.valueOf(this.getlf_type());
            eDataType = DE_GeneralEnums.databaseDataType.IntegerValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("lftypes")) {
            sValue = String.valueOf(this.getlf_type_s());
            eDataType = DE_GeneralEnums.databaseDataType.IntegerValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("U")) {
            sValue = String.valueOf(this.getub());
            eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("delta")) {
            sValue = String.valueOf(this.getdelta2());
            eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("U")) {
            sValue = String.valueOf(this.getub());
            eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("umin")) {
            sValue = String.valueOf(this.getumin());
            eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("umax")) {
            sValue = String.valueOf(this.getumax());
            eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("spotp")) {
            sValue = String.valueOf(this.getspot_p());
            eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("spotq")) {
            sValue = String.valueOf(this.getspot_q());
            eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("inservicei")) {
            sValue = String.valueOf(this.getinservicei());
            eDataType = DE_GeneralEnums.databaseDataType.IntegerValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("inservice")) {
            sValue = String.valueOf(this.getinservice());
            eDataType = DE_GeneralEnums.databaseDataType.BooleanValue;
            eGroup = DE_GeneralEnums.parameterGroup.Operation;
        } else if (sParameterName.equalsIgnoreCase("type")) {
            sValue = this.getinv_type();
            eDataType = DE_GeneralEnums.databaseDataType.StringValue;
            eGroup = DE_GeneralEnums.parameterGroup.Economic;
        } else if (sParameterName.equalsIgnoreCase("owner")) {
            sValue = this.getinv_owner();
            eDataType = DE_GeneralEnums.databaseDataType.StringValue;
            eGroup = DE_GeneralEnums.parameterGroup.Economic;
        } else if (sParameterName.equalsIgnoreCase("lifetime")) {
            sValue = String.valueOf(this.getlife_time());
            eDataType = DE_GeneralEnums.databaseDataType.IntegerValue;
            eGroup = DE_GeneralEnums.parameterGroup.Economic;
        } else if (sParameterName.equalsIgnoreCase("entryperiod")) {
            sValue = String.valueOf(this.getentry_period());
            eDataType = DE_GeneralEnums.databaseDataType.IntegerValue;
            eGroup = DE_GeneralEnums.parameterGroup.Economic;
        } else if (sParameterName.equalsIgnoreCase("exitperiod")) {
            sValue = String.valueOf(this.getexit_period());
            eDataType = DE_GeneralEnums.databaseDataType.IntegerValue;
            eGroup = DE_GeneralEnums.parameterGroup.Economic;
        } else if (sParameterName.equalsIgnoreCase("cost")) {
            sValue = String.valueOf(this.getinv_cost());
            eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
            eGroup = DE_GeneralEnums.parameterGroup.Economic;
        } else if (sParameterName.equalsIgnoreCase("entrymonth")) {
            sValue = String.valueOf(this.getentry_month());
            eDataType = DE_GeneralEnums.databaseDataType.IntegerValue;
            eGroup = DE_GeneralEnums.parameterGroup.Economic;
        } else if (sParameterName.equalsIgnoreCase("exitmonth")) {
            sValue = String.valueOf(this.getexit_month());
            eDataType = DE_GeneralEnums.databaseDataType.IntegerValue;
            eGroup = DE_GeneralEnums.parameterGroup.Economic;
        } else if (sParameterName.equalsIgnoreCase("ctrla")) {
            sValue = this.getctrla();
            eDataType = DE_GeneralEnums.databaseDataType.StringValue;
            eGroup = DE_GeneralEnums.parameterGroup.Location;
        } else if (sParameterName.equalsIgnoreCase("latitude")) {
            sValue = String.valueOf(this.getlatitude());
            eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
            eGroup = DE_GeneralEnums.parameterGroup.Location;
        } else if (sParameterName.equalsIgnoreCase("longitude")) {
            sValue = String.valueOf(this.getlongitude());
            eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
            eGroup = DE_GeneralEnums.parameterGroup.Location;
        } else if (sParameterName.equalsIgnoreCase("XPos")) {
            sValue = String.valueOf(this.getxpos());
            eDataType = DE_GeneralEnums.databaseDataType.IntegerValue;
            eGroup = DE_GeneralEnums.parameterGroup.Location;
        } else if (sParameterName.equalsIgnoreCase("YPos")) {
            sValue = String.valueOf(this.getypos());
            eDataType = DE_GeneralEnums.databaseDataType.IntegerValue;
            eGroup = DE_GeneralEnums.parameterGroup.Location;
        } else if (sParameterName.equalsIgnoreCase("num")) {
            sValue = String.valueOf(this.getnum());
            eDataType = DE_GeneralEnums.databaseDataType.IntegerValue;
            eGroup = DE_GeneralEnums.parameterGroup.Location;
        } else if (sParameterName.equalsIgnoreCase("pini")) {
            sValue = String.valueOf(this.getpini());
            eDataType = DE_GeneralEnums.databaseDataType.DoubleValue;
            eGroup = DE_GeneralEnums.parameterGroup.Location;
        }
        if (sValue != null) {
            oData.setValue(sValue, eDataType, eGroup);
        } else {
            ParameterData oDataOld = (ParameterData)this.mData.get(sParameterName);
            if (oDataOld == null && (oDataOld = DeepEdit.getDefaultParameterInfo(this.ClassName, sParameterName)) == null) {
                assert (false) : "Why are you looking for parameter '" + sParameterName + "' if it is not supported by object '" + this.ClassName + "?";
                return false;
            }
            oDataOld.copyParameterInto(oData);
        }
        return true;
    }

    @Override
    public boolean setParameterInfo(String sParameterName, ParameterData pData) {
        String sValue = pData.getValue();
        if (sParameterName.equalsIgnoreCase("Name")) {
            this.setName(sValue);
            return true;
        }
        if (sParameterName.equalsIgnoreCase("con2")) {
            this.setcon2(sValue);
            return true;
        }
        if (sParameterName.equalsIgnoreCase("alias")) {
            this.setalias(sValue);
            return true;
        }
        if (sParameterName.equalsIgnoreCase("p")) {
            this.setp(Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("q")) {
            this.setq(Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("p0")) {
            this.setp0(Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("q0")) {
            this.setq0(Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("un1")) {
            this.setun1(Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("smax")) {
            this.setsmax(Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("sn")) {
            this.setsn(Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("lftype")) {
            this.setlf_type((int)Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("lftypes")) {
            this.setlf_type_s((int)Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("U")) {
            this.setub(Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("umin")) {
            this.setumin(Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("umax")) {
            this.setumax(Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("delta")) {
            this.setdelta2(Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("spotp")) {
            this.setspot_p(Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("spotq")) {
            this.setspot_q(Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("inservicei")) {
            this.setinservicei(Integer.parseInt(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("inservice")) {
            this.setinservice(Boolean.parseBoolean(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("type")) {
            this.setinv_type(sValue);
            return true;
        }
        if (sParameterName.equalsIgnoreCase("owner")) {
            this.setinv_owner(sValue);
            return true;
        }
        if (sParameterName.equalsIgnoreCase("lifetime")) {
            this.setlife_time((int)Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("entryperiod")) {
            this.setentry_period((int)Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("exitperiod")) {
            this.setexit_period((int)Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("cost")) {
            this.setinv_cost((int)Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("entrymonth")) {
            this.setentry_month((int)Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("exitmonth")) {
            this.setexit_month((int)Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("ctrla")) {
            this.setctrla(sValue);
            return true;
        }
        if (sParameterName.equalsIgnoreCase("latitude")) {
            this.setlatitude(Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("longitude")) {
            this.setlongitude(Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("XPos")) {
            this.setxpos((int)Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("YPos")) {
            this.setypos((int)Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("num")) {
            this.setnum((int)Double.parseDouble(sValue));
            return true;
        }
        if (sParameterName.equalsIgnoreCase("pini")) {
            this.setpini(Double.parseDouble(sValue));
            return true;
        }
        ParameterData pDataOld = (ParameterData)this.mData.get(sParameterName);
        if (pDataOld != null) {
            pDataOld.setValue(sValue);
        } else {
            this.mData.put(sParameterName, pData);
        }
        return true;
    }
}

