/*
 * Decompiled with CFR 0.152.
 */
package de.core;

import de.core.ArcPQ;
import de.core.DatatoDiag;
import de.core.DeepEdit;
import de.core.DibujaPQ;
import de.core.GraphicsUtil;
import de.core.SimpleDialog;
import java.awt.BasicStroke;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Arc2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

class ArcCanvas
extends Canvas {
    int startAngle = 0;
    int endAngle = 180;
    Font font = new Font("Courier", 1, 11);
    double escala;
    double[] esc = new double[1];
    public DatatoDiag dato;
    ArcPQ MyArcPQ;
    DibujaPQ dibpq;
    Point2D.Double QmaxaPsol;
    Point2D.Double QminaPsol;
    double qmin_do;
    double qmax_do;
    double df = this.esc[0];

    public ArcCanvas(DatatoDiag ffm, DibujaPQ ddibpq) {
        ffm.muestra();
        this.dato = ffm;
        this.dibpq = ddibpq;
        this.MyArcPQ = new ArcPQ();
    }

    public ArcCanvas() {
    }

    public ArcCanvas(DatatoDiag ffm, ArcPQ MMyArcPQ) {
        this.dato = ffm;
        this.MyArcPQ = MMyArcPQ;
        this.Calculate();
    }

    @Override
    public void paint(Graphics g) {
        try {
            int i;
            Point2D.Double p2max;
            double n;
            double m;
            Point2D.Double p1min;
            double rpmin;
            Rectangle r = this.getBounds();
            Graphics2D g2D = (Graphics2D)g;
            this.esc[0] = this.escala = 0.9 * (double)(r.width / 2) / this.dato.raSmax();
            if (this.dato.raPmax() / this.dato.raSmax() < 0.78) {
                System.out.println("--------------------------------------------------------------------");
                System.out.println("Warning:Coseno phi menor al l\u00edmite inferior 0,78.");
                System.out.println("--------------------------------------------------------------------");
            }
            g2D.setPaint(Color.red);
            double rsmax = this.dato.raSmax() * this.escala;
            Arc2D.Double arc1 = new Arc2D.Double((double)(r.width / 2) - rsmax, (double)(r.height - 150) - rsmax, 2.0 * rsmax, 2.0 * rsmax, this.startAngle, this.endAngle, 0);
            g2D.draw(arc1);
            g2D.setPaint(Color.black);
            double rsmin = this.dato.raSmin() * this.escala;
            Arc2D.Double arc2 = new Arc2D.Double((double)(r.width / 2) - rsmin, (double)(r.height - 150) - rsmin, 2.0 * rsmin, 2.0 * rsmin, this.startAngle, this.endAngle, 0);
            g2D.draw(arc2);
            g2D.setPaint(Color.black);
            double remax = this.dato.raEmax() * this.escala;
            double ptorigen = (double)(r.width / 2) - this.dato.ptorg() * this.escala;
            Arc2D.Double arc3 = new Arc2D.Double(ptorigen - remax, (double)(r.height - 150) - remax, 2.0 * remax, 2.0 * remax, this.dato.anginicEmax(), this.dato.angfinEmax() - this.dato.anginicEmax(), 0);
            g2D.draw(arc3);
            if (this.dato.angfinEmax() - this.dato.anginicEmax() >= 90.0) {
                System.out.println("--------------------------------------------------------------------");
                System.out.println("Warning:El arco de Emax corta a Smax no en el primer cuadrante (P>0 y Q>0),");
                System.out.println("--------------------------------------------------------------------");
            }
            Color paul2 = new Color(130, 0, 130);
            g2D.setPaint(paul2);
            double remin = this.dato.raEmin() * this.escala;
            Arc2D.Double arc4 = new Arc2D.Double(ptorigen - remin, (double)(r.height - 150) - remin, 2.0 * remin, 2.0 * remin, this.startAngle, this.endAngle, 0);
            g2D.draw(arc4);
            double ppsol = (double)(r.height - 150) - this.dato.psol() * this.escala;
            double rarc4 = remin;
            double rparc4 = rarc4 * 0.9;
            double raizarc4 = Math.sqrt(rarc4 * rarc4 - (rparc4 - 0.0) * (rparc4 - 0.0));
            double sol1arc4 = ptorigen - raizarc4;
            double sol2arc4 = ptorigen + raizarc4;
            double solarc4 = sol1arc4 - ptorigen > 0.0 ? sol1arc4 : sol2arc4;
            double yarc4 = (double)(r.height - 150) - rparc4;
            Point2D.Double p14 = new Point2D.Double(solarc4, yarc4);
            g2D.setPaint(Color.blue);
            double rV1 = this.dato.ptorg() * this.escala;
            Arc2D.Double arc5 = new Arc2D.Double(ptorigen - rV1, (double)(r.height - 150) - rV1, 2.0 * rV1, 2.0 * rV1, this.startAngle, this.endAngle, 0);
            double rarc5 = rV1;
            double rparc5 = rarc5 * 0.9;
            double raizarc5 = Math.sqrt(rarc5 * rarc5 - (rparc5 - 0.0) * (rparc5 - 0.0));
            double sol1arc5 = ptorigen - raizarc5;
            double sol2arc5 = ptorigen + raizarc5;
            double solarc5 = sol1arc5 - ptorigen > 0.0 ? sol1arc5 : sol2arc5;
            double yarc5 = (double)(r.height - 150) - rparc5;
            Point2D.Double p15 = new Point2D.Double(solarc5, yarc5);
            Line2D.Double line15 = new Line2D.Double(p14, p15);
            g2D.setPaint(Color.blue);
            g2D.draw(line15);
            double qapmax = (double)(r.height / 2) - this.dato.qaPmax() * this.escala;
            double qapmin = (double)(r.height / 2) - this.dato.qaPminEmax() * this.escala;
            double qapminemin = (double)(r.height / 2) - this.dato.qaPminEmin() * this.escala;
            if (ppsol <= (double)(r.height - 150) && ppsol > yarc4) {
                this.MyArcPQ.qmin_a_psol = (double)(r.height - 150) - this.dato.qaPsolEmin() * this.escala;
                this.QminaPsol = new Point2D.Double((double)r.height - this.MyArcPQ.qmin_a_psol, ppsol);
                this.qmin_do = this.MyArcPQ.qminpsol = ((double)(-r.height - 150) + ((double)r.height - this.MyArcPQ.qmin_a_psol)) / this.escala;
            }
            if ((rpmin = (double)(r.height - 150) - this.dato.raPmin() * this.escala) >= yarc4) {
                p1min = new Point2D.Double((double)r.height - qapminemin, rpmin);
            } else {
                m = (yarc5 - yarc4) / (solarc5 - solarc4);
                n = -m * solarc5 + yarc5;
                double qapminestab = (rpmin - yarc5 + m * solarc5) / m;
                p1min = new Point2D.Double(qapminestab, rpmin);
            }
            Point2D.Double p2min = new Point2D.Double((double)r.height - qapmin, rpmin);
            Line2D.Double linemin = new Line2D.Double(p1min, p2min);
            g2D.setPaint(Color.gray);
            g2D.draw(linemin);
            g2D.setPaint(Color.blue);
            double minpmax = (double)(r.height - 150) - this.dato.minPmax() * this.escala;
            double rpmax = (double)(r.height - 150) - this.dato.raPmax() * this.escala;
            if (yarc5 < rpmax) {
                rpmax = yarc5;
                System.out.println("--------------------------------------------------------------------");
                System.out.println("Warning:Pmax definida es menor que la potencia P_estab del punto superior de la l\u00ednea de estabilidad.");
                System.out.println("--------------------------------------------------------------------");
            }
            if (minpmax < rpmax) {
                rpmax = minpmax;
                System.out.println("--------------------------------------------------------------------");
                System.out.println("Warning:Pmax definida es menor que la potencia P_a_Emax del punto superior del trazo definido por Emax.");
                System.out.println("--------------------------------------------------------------------");
            }
            m = (yarc5 - yarc4) / (solarc5 - solarc4);
            n = -m * solarc5 + yarc5;
            double p1 = (double)(r.height - 150) - this.dato.raPmax() * this.escala;
            double xmax = (p1 - yarc5 + m * solarc5) / m;
            if (qapmax < xmax) {
                if (rpmax < minpmax) {
                    Point2D.Double p1max = new Point2D.Double(xmax, rpmax);
                    p2max = new Point2D.Double((double)r.height - qapmax, rpmax);
                    Line2D.Double linemax = new Line2D.Double(p1max, p2max);
                    g2D.draw(linemax);
                }
                Point2D.Double pest = new Point2D.Double(xmax, p1);
                Line2D.Double linepest = new Line2D.Double(p15, pest);
                g2D.draw(linepest);
                if (ppsol <= yarc4 && ppsol >= rpmax) {
                    this.MyArcPQ.qmin_a_psol = (ppsol - yarc5 + m * solarc5) / m;
                    this.QminaPsol = new Point2D.Double(this.MyArcPQ.qmin_a_psol, ppsol);
                    this.qmin_do = this.MyArcPQ.qminpsol = ((double)(-r.height / 2) + this.MyArcPQ.qmin_a_psol) / this.escala;
                }
            } else {
                if (rpmax < minpmax) {
                    Point2D.Double p1max = new Point2D.Double(qapmax, rpmax);
                    p2max = new Point2D.Double((double)(r.height - 300) - qapmax, rpmax);
                    Line2D.Double linemax = new Line2D.Double(p1max, p2max);
                    g2D.draw(linemax);
                }
                double al1 = r.width / 2;
                double beta1 = (2.0 * m * n - 2.0 * m * al1 - 2.0 * al1) / (1.0 + m * m);
                double beta2 = (n * n + 2.0 * al1 * al1 - 2.0 * n * al1 - rsmax * rsmax) / (1.0 + m * m);
                double pre1qlim = -(beta1 / 2.0) + Math.sqrt(beta1 / 2.0 * (beta1 / 2.0) - beta2);
                double pre2qlim = -(beta1 / 2.0) - Math.sqrt(beta1 / 2.0 * (beta1 / 2.0) - beta2);
                double qlim = Math.abs(pre1qlim) > Math.abs(pre2qlim) ? pre1qlim : pre2qlim;
                double plim = m * qlim + n;
                Point2D.Double pest = new Point2D.Double(qlim, plim);
                Line2D.Double linepest = new Line2D.Double(p15, pest);
                g2D.draw(linepest);
                if (ppsol <= yarc4 && ppsol >= plim) {
                    this.MyArcPQ.qmin_a_psol = (ppsol - yarc5 + m * solarc5) / m;
                    this.QminaPsol = new Point2D.Double(this.MyArcPQ.qmin_a_psol, ppsol);
                    this.qmin_do = this.MyArcPQ.qminpsol = ((double)(-r.height / 2) + this.MyArcPQ.qmin_a_psol) / this.escala;
                }
                if (ppsol < plim && ppsol >= rpmax) {
                    this.MyArcPQ.qmin_a_psol = (double)(r.height / 2) - this.dato.qaPsol() * this.escala;
                    this.QminaPsol = new Point2D.Double(this.MyArcPQ.qmin_a_psol, ppsol);
                    this.qmin_do = this.MyArcPQ.qminpsol = ((double)(-r.height / 2) + this.MyArcPQ.qmin_a_psol) / this.escala;
                }
            }
            if (ppsol <= (double)(r.height - 150) && ppsol > minpmax) {
                this.MyArcPQ.qmax_a_psol = (double)(r.height / 2) + this.dato.qaPsolEmax() * this.escala;
                this.QmaxaPsol = new Point2D.Double(this.MyArcPQ.qmax_a_psol, ppsol);
                this.qmax_do = this.MyArcPQ.qmaxpsol = (this.MyArcPQ.qmax_a_psol - (double)(r.height / 2)) / this.escala;
            }
            if (ppsol <= minpmax && ppsol >= rpmax) {
                this.MyArcPQ.qmax_a_psol = (double)(r.height / 2) + this.dato.qaPsol() * this.escala;
                this.QmaxaPsol = new Point2D.Double(this.MyArcPQ.qmax_a_psol, ppsol);
                this.qmax_do = this.MyArcPQ.qmaxpsol = (this.MyArcPQ.qmax_a_psol - (double)(r.height / 2)) / this.escala;
            }
            Color paul = new Color(0, 150, 0);
            g.setColor(paul);
            Line2D.Double linePsol = new Line2D.Double(this.QmaxaPsol, this.QminaPsol);
            g2D.draw(linePsol);
            this.MyArcPQ.setqmin(this.qmin_do);
            this.MyArcPQ.setqmax(this.qmax_do);
            if (this.MyArcPQ.limq_imp) {
                this.MyArcPQ.qmax_imp = (double)(r.height / 2) + this.dato.raQmax() * this.escala;
                this.MyArcPQ.qmin_imp = (double)(r.height / 2) + this.dato.raQmin() * this.escala;
                Point2D.Double qmax_imp_a_pmin = new Point2D.Double(this.MyArcPQ.qmax_imp, rpmin);
                Point2D.Double qmax_imp_a_pmax = new Point2D.Double(this.MyArcPQ.qmax_imp, rpmax);
                g.setColor(Color.green);
                Line2D.Double lineQmax_imp = new Line2D.Double(qmax_imp_a_pmin, qmax_imp_a_pmax);
                Point2D.Double qmin_imp_a_pmin = new Point2D.Double(this.MyArcPQ.qmin_imp, rpmin);
                Point2D.Double qmin_imp_a_pmax = new Point2D.Double(this.MyArcPQ.qmin_imp, rpmax);
                Line2D.Double lineQmin_imp = new Line2D.Double(qmin_imp_a_pmin, qmin_imp_a_pmax);
                g2D.draw(lineQmax_imp);
                g2D.draw(lineQmin_imp);
                Line2D.Double linePmax_qmax_y_qmin_imp = new Line2D.Double(qmax_imp_a_pmax, qmin_imp_a_pmax);
                Line2D.Double linePmin_qmax_y_qmin_imp = new Line2D.Double(qmax_imp_a_pmin, qmin_imp_a_pmin);
                g2D.draw(linePmax_qmax_y_qmin_imp);
                g2D.draw(linePmin_qmax_y_qmin_imp);
            }
            Point2D.Double origen = new Point2D.Double(r.width / 2, r.height - 150);
            Point2D.Double ptoper = new Point2D.Double((double)(r.width / 2) + this.dato.datos[11] * this.escala, (double)(r.height - 150) - this.dato.datos[10] * this.escala);
            g.setColor(Color.magenta);
            Line2D.Double lineoper = new Line2D.Double(origen, ptoper);
            g2D.setStroke(new BasicStroke(2.0f));
            g2D.draw(lineoper);
            Rectangle2D.Double poper = new Rectangle2D.Double((double)(r.width / 2) + this.dato.datos[11] * this.escala - 2.0, (double)(r.height - 150) - this.dato.datos[10] * this.escala - 2.0, 4.0, 4.0);
            g2D.draw(poper);
            g2D.setStroke(new BasicStroke(1.0f));
            g.drawString("(" + Math.round(this.dato.datos[10]) + "," + Math.round(this.dato.datos[11]) + ")", (int)((double)(r.width / 2) + this.dato.datos[11] * this.escala + 5.0), (int)((double)(r.height - 150) - this.dato.datos[10] * this.escala - 8.0));
            int gs = 7;
            g.setColor(Color.black);
            g.setFont(this.font);
            g.drawLine(0, r.height - 150, r.width - 6, r.height - 150);
            GraphicsUtil.drawArrow(g2D, r.width - 6, r.height - 150, r.width - 4, r.height - 150, 1, (int)((double)gs * 1.5));
            g.drawLine(r.width / 2, 30, r.width / 2, r.height - 100);
            GraphicsUtil.drawArrow(g2D, r.width / 2, 30, r.width / 2, 28, 1, (int)((double)gs * 1.5));
            int sx1 = r.height / 2 - 55;
            int sy1 = 50;
            g.drawString("P [MW]", sx1, sy1);
            int sx2 = r.height - 60;
            int sy2 = r.height - 150 + 30;
            g.drawString("Q [MVAr]", sx2, sy2);
            g.drawString("-" + Math.round(this.dato.raSmax() / 1.0), 1 * r.width / 5 - 70, r.height - 150 + 10);
            g.drawString("" + Math.round(this.dato.raSmax() / 1.0), 3 * r.width / 5 + 130, r.height - 150 + 10);
            g.drawString("" + Math.round(this.dato.raSmax() / 1.0), r.width / 2 - 18, r.height / 5 + 10);
            for (i = 2; i > 0; --i) {
                g.drawString("-" + Math.round((double)i * this.dato.raSmax() / 3.0), (int)((double)(r.width / 2) - this.dato.raSmax() * this.escala * (double)i / 3.0) - 13, r.height - 150 + 10);
            }
            for (i = 1; i < 3; ++i) {
                g.drawString("" + Math.round((double)i * this.dato.raSmax() / 3.0), (int)((double)(r.width / 2) + this.dato.raSmax() * this.escala * (double)i / 3.0), r.height - 150 + 10);
            }
            for (i = 1; i < 3; ++i) {
                g.drawString("" + Math.round((double)i * this.dato.raSmax() / 3.0), r.width / 2 - 18, (int)((double)(r.height - 150) - this.dato.raSmax() * this.escala * (double)i / 3.0));
            }
        }
        catch (Exception e) {
            this.dibpq.f.dispose();
            if (this.dato.datos[10] < 0.0) {
                String message = "Imposible dibujar el diagrama de operaci\u00f3n para una m\u00e1quina funcionando como motor";
                String[] DlgButtons = new String[]{"OK"};
                SimpleDialog ExceptionDialog = new SimpleDialog(DeepEdit.frame, "Diagrama de Operaci\u00f3n", message, DlgButtons, 1, 0, 0, 2);
            }
            String message = "Inconsistencia en los par\u00e1metros del generador para dibujar diagrama.";
            String[] DlgButtons = new String[]{"OK"};
            SimpleDialog ExceptionDialog = new SimpleDialog(DeepEdit.frame, "Diagrama de Operaci\u00f3n", message, DlgButtons, 1, 0, 0, 2);
        }
    }

    public void Calculate() {
        double rV1;
        int dim = 300;
        double hlines = dim / 10;
        double vlines = dim / 10;
        this.esc[0] = this.escala = 0.9 * (double)(dim / 2) / this.dato.raSmax();
        double rsmax = this.dato.raSmax() * this.escala;
        double rsmin = this.dato.raSmin() * this.escala;
        double remax = this.dato.raEmax() * this.escala;
        double ptorigen = (double)(dim / 2) - this.dato.ptorg() * this.escala;
        double remin = this.dato.raEmin() * this.escala;
        double ppsol = (double)(dim / 2) - this.dato.psol() * this.escala;
        double rarc4 = remin;
        double rparc4 = rarc4 * 0.9;
        double raizarc4 = Math.sqrt(rarc4 * rarc4 - (rparc4 - 0.0) * (rparc4 - 0.0));
        double sol1arc4 = ptorigen - raizarc4;
        double sol2arc4 = ptorigen + raizarc4;
        double solarc4 = sol1arc4 - ptorigen > 0.0 ? sol1arc4 : sol2arc4;
        double yarc4 = (double)(dim / 2) - rparc4;
        double rarc5 = rV1 = this.dato.ptorg() * this.escala;
        double rparc5 = rarc5 * 0.9;
        double raizarc5 = Math.sqrt(rarc5 * rarc5 - (rparc5 - 0.0) * (rparc5 - 0.0));
        double sol1arc5 = ptorigen - raizarc5;
        double sol2arc5 = ptorigen + raizarc5;
        double solarc5 = sol1arc5 - ptorigen > 0.0 ? sol1arc5 : sol2arc5;
        double yarc5 = (double)(dim / 2) - rparc5;
        double qapmax = (double)(dim / 2) - this.dato.qaPmax() * this.escala;
        double qapmin = (double)(dim / 2) - this.dato.qaPminEmax() * this.escala;
        double qapminemin = (double)(dim / 2) - this.dato.qaPminEmin() * this.escala;
        if (ppsol <= (double)(dim / 2) && ppsol > yarc4) {
            this.MyArcPQ.qmin_a_psol = (double)(dim / 2) - this.dato.qaPsolEmin() * this.escala;
            this.QminaPsol = new Point2D.Double((double)dim - this.MyArcPQ.qmin_a_psol, ppsol);
            this.qmin_do = this.MyArcPQ.qminpsol = ((double)(-dim / 2) + ((double)dim - this.MyArcPQ.qmin_a_psol)) / this.escala;
        }
        double rpmin = (double)(dim / 2) - this.dato.raPmin() * this.escala;
        double minpmax = (double)(dim / 2) - this.dato.minPmax() * this.escala;
        double rpmax = (double)(dim / 2) - this.dato.raPmax() * this.escala;
        double m = (yarc5 - yarc4) / (solarc5 - solarc4);
        double n = -m * solarc5 + yarc5;
        double p1 = (double)(dim / 2) - this.dato.raPmax() * this.escala;
        double xmax = (p1 - yarc5 + m * solarc5) / m;
        if (qapmax < xmax) {
            if (!(rpmax < minpmax)) {
                rpmax = minpmax;
            }
            if (ppsol <= yarc4 && ppsol >= rpmax) {
                this.MyArcPQ.qmin_a_psol = (ppsol - yarc5 + m * solarc5) / m;
                this.QminaPsol = new Point2D.Double(this.MyArcPQ.qmin_a_psol, ppsol);
                this.qmin_do = this.MyArcPQ.qminpsol = ((double)(-dim / 2) + this.MyArcPQ.qmin_a_psol) / this.escala;
            }
        } else {
            if (!(rpmax < minpmax)) {
                rpmax = minpmax;
            }
            double al1 = dim / 2;
            double beta1 = (2.0 * m * n - 2.0 * m * al1 - 2.0 * al1) / (1.0 + m * m);
            double beta2 = (n * n + 2.0 * al1 * al1 - 2.0 * n * al1 - rsmax * rsmax) / (1.0 + m * m);
            double pre1qlim = -(beta1 / 2.0) + Math.sqrt(beta1 / 2.0 * (beta1 / 2.0) - beta2);
            double pre2qlim = -(beta1 / 2.0) - Math.sqrt(beta1 / 2.0 * (beta1 / 2.0) - beta2);
            double qlim = Math.abs(pre1qlim) > Math.abs(pre2qlim) ? pre1qlim : pre2qlim;
            double plim = m * qlim + n;
            if (ppsol <= yarc4 && ppsol >= plim) {
                this.MyArcPQ.qmin_a_psol = (ppsol - yarc5 + m * solarc5) / m;
                this.QminaPsol = new Point2D.Double(this.MyArcPQ.qmin_a_psol, ppsol);
                this.qmin_do = this.MyArcPQ.qminpsol = ((double)(-dim / 2) + this.MyArcPQ.qmin_a_psol) / this.escala;
            }
            if (ppsol < plim && ppsol >= rpmax) {
                this.MyArcPQ.qmin_a_psol = (double)(dim / 2) - this.dato.qaPsol() * this.escala;
                this.QminaPsol = new Point2D.Double(this.MyArcPQ.qmin_a_psol, ppsol);
                this.qmin_do = this.MyArcPQ.qminpsol = ((double)(-dim / 2) + this.MyArcPQ.qmin_a_psol) / this.escala;
            }
        }
        if (ppsol <= (double)(dim / 2) && ppsol > minpmax) {
            this.MyArcPQ.qmax_a_psol = (double)(dim / 2) + this.dato.qaPsolEmax() * this.escala;
            this.QmaxaPsol = new Point2D.Double(this.MyArcPQ.qmax_a_psol, ppsol);
            this.qmax_do = this.MyArcPQ.qmaxpsol = (this.MyArcPQ.qmax_a_psol - (double)(dim / 2)) / this.escala;
        }
        if (ppsol <= minpmax && ppsol >= rpmax) {
            this.MyArcPQ.qmax_a_psol = (double)(dim / 2) + this.dato.qaPsol() * this.escala;
            this.QmaxaPsol = new Point2D.Double(this.MyArcPQ.qmax_a_psol, ppsol);
            this.qmax_do = this.MyArcPQ.qmaxpsol = (this.MyArcPQ.qmax_a_psol - (double)(dim / 2)) / this.escala;
        }
        this.MyArcPQ.setqmin(this.qmin_do);
        this.MyArcPQ.setqmax(this.qmax_do);
        if (this.dato.raPmax() / this.dato.raSmax() < 0.7) {
            this.MyArcPQ.setqmin(-100000.0);
            this.MyArcPQ.setqmax(100000.0);
        }
    }

    double getescala() {
        return this.df;
    }
}

