/*
 * Decompiled with CFR 0.152.
 */
package de.core;

import JSci.maths.Complex;
import de.core.AnalysisToolsPrgFrame;
import de.core.Busbar;
import de.core.DeepEdit;
import de.core.DeepEditFrame;
import de.core.Generator;
import de.core.Load;
import de.core.Schematic;
import de.core.TPDBProcessor;
import de.core.Trafo;
import de.core.ZFileViewer;
import de.core.comp;
import de.core.mdb_wheel;
import de.core.ndb_1pol;
import de.core.ndb_branch;
import de.core.ndb_comp;
import de.data.DE_GeneralEnums;
import de.data.ParameterData;
import de.utils.StringUtil;
import de.utils.Utils;
import java.io.File;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;

public abstract class AnalysisTool {
    protected Schematic ActSchematic;
    protected DeepEditFrame ActFrame;
    protected DeepEdit ActDeepEdit;
    public ZFileViewer MyZFileViewer;
    public int numnod = 0;
    public int numlin = 0;
    public int numload = 0;
    public int numupfc = 0;
    public int numlinedc = 0;
    public int numtran = 0;
    public int numtranthree = 0;
    public int numgen = 0;
    public int numinj = 0;
    public int slack = 0;
    public int numloadvd = 0;
    int maxiter = 0;
    protected double sref = 100.0;
    protected static String WORK_FOLDER = "./nod";
    protected static String RESULT_FOLDER = "./results";
    private static AnalysisToolsPrgFrame myMsgFrame;
    public String message = " ";
    protected ArrayList<ndb_branch> ndb_branches;
    protected ArrayList<Generator> Generators;
    protected ArrayList<Busbar> Busbars;
    protected ArrayList<Load> Loads;
    protected ArrayList<mdb_wheel> mdb_wheels;

    public AnalysisTool(Schematic sch) {
        this(sch, DeepEdit.frame);
    }

    public AnalysisTool(Schematic sch, DeepEditFrame aActFrame) {
        this.ActFrame = aActFrame;
        this.ActSchematic = sch;
        this.ActDeepEdit = aActFrame.applet;
        this.initSchematicLists();
    }

    public void setSref(double sref) {
        this.sref = sref;
    }

    public double getSref() {
        return this.sref;
    }

    public void DoListResults(String fname) {
        if (this.MyZFileViewer == null) {
            this.MyZFileViewer = new ZFileViewer(DeepEdit.frame, fname);
            this.MyZFileViewer.setVisible(true);
        } else {
            this.MyZFileViewer.setVisible(true);
        }
    }

    public static void Dorun(String progname_pc, String progname_unix, boolean print) throws Exception {
        Process p;
        String OSName = System.getProperty("os.name");
        boolean bIsQuadra = false;
        if (progname_pc != null && progname_pc.contains("cuadra")) {
            bIsQuadra = true;
        }
        if (progname_unix != null && progname_unix.contains("cuadra")) {
            bIsQuadra = true;
        }
        if (bIsQuadra && !DeepEdit.isMinosQuadraInstalled()) {
            throw new Exception("Unsupported Software!! Required MINOS software to run this analysis tool.\n Contact DeepEdit provider for a full version");
        }
        Runtime r = Runtime.getRuntime();
        r.gc();
        if (OSName.startsWith("Windows")) {
            if (print) {
                System.out.println("Call Command: " + progname_pc);
            }
            p = r.exec(progname_pc);
        } else if (OSName.equals("Linux") || OSName.startsWith("Mac OS X")) {
            if (print) {
                System.out.println("Call Command: /bin/sh -c " + progname_unix);
            }
            p = r.exec(new String[]{"/bin/sh", "-c", progname_unix});
        } else if (OSName.equals("IRIX")) {
            String[] commando = new String[]{"xterm", "-e", progname_unix};
            if (print) {
                System.out.println("Dorun:" + commando);
            }
            p = r.exec(commando);
        } else {
            if (print) {
                System.out.println("Call Command: " + progname_pc);
            }
            p = r.exec(progname_pc);
        }
        p.waitFor();
        r.runFinalization();
    }

    public static void Dorun(String progname_pc, String progname_unix) throws Exception {
        AnalysisTool.Dorun(progname_pc, progname_unix, true);
    }

    public static String numformat(double num, int ltot, int lmant) {
        return StringUtil.numformat(num, ltot, lmant);
    }

    public static String numformat(int num, int ltot) {
        return StringUtil.numformat(num, ltot);
    }

    public static String numformat(long num, int ltot) {
        return StringUtil.strformat2(num + "", ltot);
    }

    public static String strformat(String cad, int ltot) {
        return StringUtil.strformat(cad, ltot);
    }

    public static String strformat2(String cad, int ltot) {
        return StringUtil.strformat2(cad, ltot);
    }

    public static boolean DirectoryExist(String FullPath) {
        File folderExisting = new File(FullPath);
        return folderExisting.exists();
    }

    public static boolean FileExist(String FileName, String FullPath) {
        File folderExisting = new File(FullPath + File.separator + FileName);
        return folderExisting.exists();
    }

    public static void CreateDirectory(String RelativePath) {
        File folderExisting = new File(RelativePath);
        if (!folderExisting.exists()) {
            folderExisting.mkdir();
        }
    }

    public static double[] getExactLineParam(double r, double x, double g, double b, double len) {
        double[] param = new double[4];
        Complex ZetaC = new Complex(r, x).divide(new Complex(g, b));
        ZetaC = ZetaC.sqrt();
        Complex Gamma = new Complex(r, x).multiply(new Complex(g, b));
        Gamma = Gamma.sqrt();
        Complex Zeta = ZetaC.multiply(Complex.sinh((Complex)Gamma.multiply(len)));
        Complex midY = Complex.tanh((Complex)Gamma.multiply(len).divide(2.0)).divide(ZetaC);
        param[0] = Zeta.real();
        param[1] = Zeta.imag();
        param[2] = midY.real();
        param[3] = midY.imag();
        return param;
    }

    protected final void initSchematicLists() {
        this.ndb_branches = new ArrayList();
        this.Generators = new ArrayList();
        this.Busbars = new ArrayList();
        this.Loads = new ArrayList();
        this.mdb_wheels = new ArrayList();
        if (DeepEdit.MySchematic != null) {
            this.ActSchematic = DeepEdit.MySchematic;
        }
        for (comp c : this.ActSchematic.getComponents()) {
            if (c instanceof ndb_branch) {
                this.ndb_branches.add((ndb_branch)c);
            }
            if (c instanceof Generator) {
                this.Generators.add((Generator)c);
            }
            if (c instanceof Busbar) {
                this.Busbars.add((Busbar)c);
            }
            if (c instanceof Load) {
                this.Loads.add((Load)c);
            }
            if (!(c instanceof mdb_wheel)) continue;
            this.mdb_wheels.add((mdb_wheel)c);
        }
        this.sref = this.ActSchematic.getsref();
        DeepEdit.SimulateSetUp();
    }

    protected void setParameterInfo(ArrayList<ParameterData> lData) {
        if (lData == null) {
            return;
        }
        for (ParameterData pData : lData) {
            this.setParameterInfo(pData);
        }
    }

    protected void setParameterInfo(ParameterData pData) {
        AnalysisTool.setParameterInfo(pData, this.ActSchematic);
    }

    public static void setParameterInfo(ParameterData pData, Schematic sch) {
        comp OwnerComponent = null;
        if (pData.getoOwnerComponent() != null) {
            OwnerComponent = pData.getoOwnerComponent();
        } else {
            for (comp TempComponent : sch.getComponents()) {
                if (!pData.getStrOwnerName().equals(TempComponent.getName())) continue;
                if (pData.getClassName() != null) {
                    String myClassName = TempComponent.getClassName();
                    String mySuperClassName = TempComponent.getClass().getSuperclass().getSimpleName();
                    if (!pData.getClassName().equals(myClassName) && !pData.getClassName().equals(mySuperClassName)) continue;
                    OwnerComponent = TempComponent;
                    break;
                }
                OwnerComponent = TempComponent;
                break;
            }
        }
        if (OwnerComponent != null) {
            AnalysisTool.setParameterInfo(pData, OwnerComponent);
        } else if (DeepEdit.PrintConnecWarnings) {
            System.out.println("Object not found in schematic: " + pData.getStrOwnerName() + "[" + pData.getClassName() + "]");
        }
    }

    private static void setParameterInfo(ParameterData pData, comp TempComponent) {
        TempComponent.setParameterInfo(pData.Name, pData);
        if (pData.getdValue() != 0.0) {
            TempComponent.setinservice(true);
        }
        if (pData.Name.equals("smax") && pData.getdValue() == 0.0) {
            TempComponent.setinservice(false);
        }
        if (pData.Name.equals("p0") && TempComponent instanceof Generator) {
            TempComponent.setParameterInfo("p", pData);
            if (pData.getdValue() == 0.0) {
                TempComponent.setinservice(false);
            }
        }
        if (pData.Name.equals("pini") && TempComponent instanceof Load) {
            TempComponent.setParameterInfo("p0", pData);
        }
    }

    public Busbar getSlackBurbar() {
        return this.ActSchematic.getSlackBurbar();
    }

    public boolean isSchematicValid() {
        return AnalysisTool.isSchematicValid(this.ActSchematic);
    }

    public static boolean isSchematicValid(Schematic sch) {
        ArrayList<String> nonreach;
        ArrayList<String> printMessages = new ArrayList<String>();
        ArrayList<String> canonicalPaths = new ArrayList<String>();
        ArrayList<String> slackBusNames = new ArrayList<String>();
        ArrayList<String> unconnectedBus = new ArrayList<String>();
        ArrayList<String> notinserviceBar = new ArrayList<String>();
        boolean bIsValid = true;
        int nValidndb_comp = 0;
        if (sch == null) {
            printMessages.add("Invalid system. Please open a valid schematic file");
            return false;
        }
        boolean bOldPrint = DeepEdit.PrintConnecWarnings;
        DeepEdit.PrintConnecWarnings = false;
        for (comp myBus : sch.getComponents("Busbar")) {
            if (myBus.inservice) continue;
            notinserviceBar.add(myBus.getName());
        }
        double min_x = DeepEdit.getDoubleOptionValue("MinPFReactance");
        for (comp TempComponent : sch.getComponents()) {
            if (TempComponent.getName().contains(",") || TempComponent.getName().contains("/") || TempComponent.getName().contains("'")) {
                bIsValid = false;
                printMessages.add("Invalid character in components name: " + TempComponent.getName());
            }
            String sCompPath = TempComponent.getClass().getSuperclass().getSimpleName() + "/" + TempComponent.getClassName() + "/" + TempComponent.getName();
            if (TempComponent instanceof ndb_comp) {
                canonicalPaths.add(sCompPath);
                if (TempComponent.getactive() || TempComponent.getinservice()) {
                    ++nValidndb_comp;
                }
            }
            if (TempComponent instanceof ndb_1pol && TempComponent.getactive() && TempComponent.getinservice()) {
                if (((ndb_1pol)TempComponent).getlf_type() == 3) {
                    slackBusNames.add(sCompPath);
                }
                if (TempComponent instanceof Generator || TempComponent instanceof Load) {
                    TempComponent.InformAllComponents();
                    if ((TempComponent.getcon1().equals(" ") || notinserviceBar.contains(TempComponent.getcon1())) && (TempComponent.getcon2().equals(" ") || notinserviceBar.contains(TempComponent.getcon2())) && TempComponent.getcon3().equals(" ") || notinserviceBar.contains(TempComponent.getcon3())) {
                        unconnectedBus.add(sCompPath);
                    }
                }
            }
            if (!(TempComponent instanceof ndb_branch)) continue;
            TempComponent.InformAllComponents();
            double x_pu = ((ndb_branch)TempComponent).getSeriesReactance(sch.getsref());
            if (Double.isNaN(x_pu)) {
                bIsValid = false;
                if (TempComponent instanceof Trafo) {
                    printMessages.add("Invalid series reactance: Check '" + TempComponent.getName() + "'  non-nominal voltages ('ur1', 'ur2') and 'sn' are all >0");
                } else {
                    printMessages.add("Invalid series reactance: Check '" + TempComponent.getName() + "' parameter 'un1'>0");
                }
            }
            if (x_pu < min_x) {
                bIsValid = false;
                printMessages.add("Invalid series reactance: '" + TempComponent.getName() + "' X[pu]=" + x_pu + ". Value should be greater than " + min_x);
            }
            if (TempComponent.getcon1().equals(" ") || notinserviceBar.contains(TempComponent.getcon1())) {
                bIsValid = false;
                printMessages.add(TempComponent.getName() + " sender end is not connected. Run 'View->View Connection' to diagnostic schematic connections");
            }
            if (!TempComponent.getcon2().equals(" ") && !notinserviceBar.contains(TempComponent.getcon2())) continue;
            bIsValid = false;
            printMessages.add(TempComponent.getName() + " receiver's end is not connected. Run 'View->View Connection' to diagnostic schematic connections");
        }
        DeepEdit.PrintConnecWarnings = bOldPrint;
        if (nValidndb_comp < 2) {
            printMessages.add("Invalid system. At least 2 network components should be valid (visible and inservice). Open a valid schematic and re-run analysis tool");
            bIsValid = false;
        }
        if (Utils.hasDuplicates(canonicalPaths)) {
            for (Object o : Utils.getRepeatedElemmentsInArray(canonicalPaths)) {
                printMessages.add("Duplicated object name in Schematic: " + o.toString());
            }
            bIsValid = false;
        }
        if (slackBusNames.size() > 1) {
            String slack = "";
            for (String s : slackBusNames) {
                slack = slack + s + ",";
            }
            printMessages.add("More than 1 active slack busbar: " + slack);
            bIsValid = false;
        }
        if (slackBusNames.isEmpty()) {
            printMessages.add("Warning: No active slack busbar. Results can be inaccurate");
            bIsValid = false;
        }
        if (unconnectedBus.size() > 0) {
            String onepole = "";
            for (String s : unconnectedBus) {
                onepole = onepole + s + ",";
            }
            printMessages.add("Components not connected to any system: " + onepole);
            bIsValid = false;
        }
        if (!(nonreach = AnalysisTool.notConnected(sch)).isEmpty()) {
            bIsValid = false;
            printMessages.add("Isolated subystem detected: ");
            for (String s : nonreach) {
                printMessages.add(s);
            }
        }
        if (DeepEdit.PrintConnecWarnings) {
            for (String s : printMessages) {
                AnalysisTool.setMessageText(s, 0);
            }
        }
        return bIsValid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateSchematicFromTPDB(int nBlock, int nHydro) {
        ArrayList<ParameterData> lLoadP_t_h;
        ArrayList<ParameterData> lCmg_t_h;
        ArrayList<ParameterData> lFlowPMax_t_h;
        ArrayList<ParameterData> lFlowP12_t_h;
        ArrayList<ParameterData> lGenerationP_t_h;
        String strTPDBName = DeepEdit.getOptionValue("TA_DBPath");
        Connection connTADB = DeepEdit.OpenJDBCConnection(strTPDBName, false);
        if (connTADB == null) {
            System.out.println("Error opening TPDB database: " + DeepEdit.getYearlyDBName());
            System.out.println("Current Schematic hasn't been updated");
            return;
        }
        try {
            lGenerationP_t_h = TPDBProcessor.executeTPDBQuery(connTADB, "SELECT dispatchInfo.hydroID AS nHydroID, blockTime.BlockNumber AS nBlockID, resultName, objectName, dataValue FROM objectInfo INNER JOIN (hydroInfo INNER JOIN ((blockTime INNER JOIN dispatchInfo ON blockTime.BlockNumber = dispatchInfo.BlockNumber) INNER JOIN data ON dispatchInfo.idDesp = data.idDesp) ON hydroInfo.hydroID = dispatchInfo.hydroID) ON objectInfo.idObject = data.idObject ", "gen_p", nBlock, nHydro, "p0", "Generator");
            lFlowP12_t_h = TPDBProcessor.executeTPDBQuery(connTADB, "SELECT dispatchInfo.hydroID AS nHydroID, blockTime.BlockNumber AS nBlockID, resultName, objectName, dataValue FROM objectInfo INNER JOIN (hydroInfo INNER JOIN ((blockTime INNER JOIN dispatchInfo ON blockTime.BlockNumber = dispatchInfo.BlockNumber) INNER JOIN data ON dispatchInfo.idDesp = data.idDesp) ON hydroInfo.hydroID = dispatchInfo.hydroID) ON objectInfo.idObject = data.idObject ", "flow", nBlock, nHydro, "p12", "ndb_branch");
            ParameterData.scaleDoubleParameterData(lFlowP12_t_h, 1.0 / this.sref);
            lFlowPMax_t_h = TPDBProcessor.executeTPDBQuery(connTADB, "SELECT dispatchInfo.hydroID AS nHydroID, blockTime.BlockNumber AS nBlockID, resultName, objectName, dataValue FROM objectInfo INNER JOIN (hydroInfo INNER JOIN ((blockTime INNER JOIN dispatchInfo ON blockTime.BlockNumber = dispatchInfo.BlockNumber) INNER JOIN data ON dispatchInfo.idDesp = data.idDesp) ON hydroInfo.hydroID = dispatchInfo.hydroID) ON objectInfo.idObject = data.idObject ", "maxflow_p", nBlock, 0, "smax", "ndb_branch");
            lCmg_t_h = TPDBProcessor.executeTPDBQuery(connTADB, "SELECT dispatchInfo.hydroID AS nHydroID, blockTime.BlockNumber AS nBlockID, resultName, objectName, dataValue FROM objectInfo INNER JOIN (hydroInfo INNER JOIN ((blockTime INNER JOIN dispatchInfo ON blockTime.BlockNumber = dispatchInfo.BlockNumber) INNER JOIN data ON dispatchInfo.idDesp = data.idDesp) ON hydroInfo.hydroID = dispatchInfo.hydroID) ON objectInfo.idObject = data.idObject ", "cmg", nBlock, nHydro, "spotp", "Busbar");
            lLoadP_t_h = TPDBProcessor.executeTPDBQuery(connTADB, "SELECT dispatchInfo.hydroID AS nHydroID, blockTime.BlockNumber AS nBlockID, resultName, objectName, dataValue FROM objectInfo INNER JOIN (hydroInfo INNER JOIN ((blockTime INNER JOIN dispatchInfo ON blockTime.BlockNumber = dispatchInfo.BlockNumber) INNER JOIN data ON dispatchInfo.idDesp = data.idDesp) ON hydroInfo.hydroID = dispatchInfo.hydroID) ON objectInfo.idObject = data.idObject ", "load_p", nBlock, 0, "pini", "Busbar");
        }
        catch (SQLException ex) {
            System.out.println("Unable to update schematic with current dispatch from " + strTPDBName);
            System.out.println("Error retrieving parameters required to update schematic from database: " + ex.getMessage());
            return;
        }
        finally {
            DeepEdit.CloseJDBCConnection(connTADB);
        }
        this.setParameterInfo(lGenerationP_t_h);
        this.setParameterInfo(lFlowP12_t_h);
        ParameterData.setParameterName(lFlowP12_t_h, "p21");
        ParameterData.scaleDoubleParameterData(lFlowP12_t_h, -1.0);
        this.setParameterInfo(lFlowP12_t_h);
        this.setParameterInfo(lFlowPMax_t_h);
        this.setParameterInfo(lCmg_t_h);
        this.setParameterInfo(lLoadP_t_h);
        DeepEdit.MySchematic.Modified = false;
        DeepEdit.MySchematic.Modifiedstate = false;
        this.ActSchematic.settypsim(DE_GeneralEnums.SimulationType.ECD.getValue());
        System.out.println("Finish loading scenario in schematic. Loaded solution Block=" + (nBlock + 1) + "; Hydro=" + (nHydro + 1));
    }

    public static void showProgressFrame(final String sTitle, final JDialog owner) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                myMsgFrame = new AnalysisToolsPrgFrame(owner);
                myMsgFrame.setTitle(sTitle);
                myMsgFrame.setLocationRelativeTo(null);
                myMsgFrame.appendMessage("Initializing calculation. Please wait...");
                myMsgFrame.setVisible(true);
            }
        });
    }

    public static void setMessageText(String strLine, int progressPctg) {
        AnalysisTool.setMessageText(strLine);
        AnalysisTool.setProgress(progressPctg);
    }

    public static void setMessageText(String strLine) {
        if (myMsgFrame != null && myMsgFrame.isVisible()) {
            myMsgFrame.appendMessage(strLine);
        }
        System.out.println(strLine);
    }

    public static void setProgress(int progressPctg) {
        if (myMsgFrame != null && myMsgFrame.isVisible()) {
            myMsgFrame.setProgress(progressPctg);
        }
    }

    public static void finishProgressFrame() {
        if (myMsgFrame != null) {
            myMsgFrame.finishExecution();
        }
    }

    public static void disposeProgressFrame() {
        if (myMsgFrame != null) {
            myMsgFrame.finishExecution();
            myMsgFrame.dispose();
        }
    }

    public static ArrayList<String> notConnected(Schematic sch) {
        HashMap AdjList = new HashMap();
        ArrayList<String> nonreachables = new ArrayList<String>();
        ArrayList<String> toVisit = new ArrayList<String>();
        for (comp branch : sch.getComponents(ndb_branch.class)) {
            ArrayList<String> temp;
            if (!branch.inservice) continue;
            branch.InformAllComponents();
            String strNode1 = branch.getcon1();
            String strNode2 = branch.getcon2();
            if (!AdjList.containsKey(strNode1)) {
                temp = new ArrayList<String>();
                temp.add(strNode2);
                AdjList.put(strNode1, temp);
            } else {
                ((ArrayList)AdjList.get(strNode1)).add(strNode2);
            }
            if (!AdjList.containsKey(strNode2)) {
                temp = new ArrayList();
                temp.add(strNode1);
                AdjList.put(strNode2, temp);
                continue;
            }
            ((ArrayList)AdjList.get(strNode2)).add(strNode1);
        }
        for (comp mybus : sch.getComponents("Busbar")) {
            if (!mybus.inservice) continue;
            nonreachables.add(mybus.getName());
        }
        if (sch.getSlackBurbar() != null) {
            toVisit.add(sch.getSlackBurbar().getName());
        } else if (!nonreachables.isEmpty()) {
            toVisit.add(nonreachables.get(0));
        } else {
            return nonreachables;
        }
        while (!toVisit.isEmpty()) {
            String l = (String)toVisit.get(toVisit.size() - 1);
            nonreachables.remove(l);
            if (!AdjList.isEmpty()) {
                for (String adjbar : (ArrayList)AdjList.get(l)) {
                    if (!nonreachables.contains(adjbar)) continue;
                    toVisit.add(adjbar);
                }
            }
            toVisit.remove(l);
        }
        return nonreachables;
    }
}

