/*
 * Decompiled with CFR 0.152.
 */
package de.core;

import VisualNumerics.math.Complex;
import de.core.AdmittanceFrame;
import de.core.AnalysisTool;
import de.core.Busbar;
import de.core.DeepEdit;
import de.core.FrameDibujo;
import de.core.Line;
import de.core.Schematic;
import de.core.SimpleDialog;
import de.core.ThreeWindingTrafo;
import de.core.Trafo;
import de.core.Upfc;
import de.core.comp;
import de.core.ndb_branch;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.Vector;

public class Admittance
extends AnalysisTool {
    AdmittanceFrame MyAdmittanceFrame = null;
    String ctrla = null;
    Complex[][] MatY;
    Complex[] ZthreeWinding;
    Complex[] Zreales;
    int numi = 0;
    protected Vector BusbarVectorI;
    int numbran = 0;
    double[] BranchR;
    double[] BranchX;
    double[] BranchB;
    int[] BranchI;
    int[] BranchJ;
    int[] VarNode;
    static int BusSize;
    double partimag;
    double modulo;
    double[] react;
    double[] resistencias;

    public Admittance(Schematic sch) {
        super(sch);
        System.out.println("---------- In Equivalent Calculation Tool ------------");
        if (this.MyAdmittanceFrame == null) {
            this.MyAdmittanceFrame = new AdmittanceFrame(this);
        } else {
            this.MyAdmittanceFrame.setVisible(true);
        }
    }

    public void Calculate(String cctrla, boolean sino, int modelo) {
        FileOutputStream os;
        this.ctrla = cctrla;
        String Ymat = WORK_FOLDER + File.separator + "Y.dat";
        try {
            AnalysisTool.CreateDirectory(WORK_FOLDER);
            os = new FileOutputStream(Ymat);
            this.InitNetwork(os);
            os.close();
        }
        catch (Exception e) {
            String message = e.toString();
            String[] DlgButtons = new String[]{"OK"};
            SimpleDialog ExceptionDialog = new SimpleDialog(DeepEdit.frame, "Admittance", message, DlgButtons, 1, 0, 0, 1);
            return;
        }
        try {
            if (os != null) {
                os.close();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        this.DoListResults(Ymat);
    }

    public void InitNetwork(FileOutputStream os) {
        Line TempLine;
        comp TempComponent;
        Complex segundiag;
        Complex Zrama23;
        Complex invertapnodiag;
        Complex Afinal;
        PrintStream myPrintStream = new PrintStream(os);
        myPrintStream.println("Datos, System Name:  " + this.ActSchematic.getsysname());
        int ix = 0;
        int i = 0;
        int j = 0;
        int c = 0;
        int count = 0;
        int countaux = 0;
        int con1 = 10000;
        int con2 = 10000;
        int con3 = 10000;
        int parestrafo = 0;
        int fintrafo = 0;
        Complex factor = new Complex(0.0, 0.0);
        Complex cuadrado = new Complex(0.0, 0.0);
        Complex A2 = Afinal = new Complex(0.0, 0.0);
        Complex A1 = Afinal;
        Complex ramaY3 = Afinal;
        Complex ramaY2 = Afinal;
        Complex ramaY1 = Afinal;
        Complex ramaY = Afinal;
        Complex neutro = new Complex(1.0, 0.0);
        Complex invertapdiag2 = invertapnodiag = new Complex(0.0, 0.0);
        Complex invertapdiag1 = invertapnodiag;
        Complex Zrama13 = Zrama23 = new Complex(0.0, 0.0);
        Complex Zrama12 = Zrama23;
        Complex primerdiag = segundiag = new Complex(0.0, 0.0);
        Complex factory = segundiag;
        Complex auxc3 = segundiag;
        Complex invertA3 = segundiag;
        Complex A3 = segundiag;
        this.BusbarVectorI = new Vector();
        double ueb = 0.0;
        double res = 0.0;
        double z = 0.0;
        double reac = 0.0;
        double yy = 0.0;
        double y1 = 0.0;
        double y2 = 0.0;
        double b = 0.0;
        double ueb1 = 0.0;
        double ueb2 = 0.0;
        double ueb3 = 0.0;
        double tap1 = 1.0;
        double tap2 = 1.0;
        double tap3 = 1.0;
        double potapa1 = 0.0;
        double potapa2 = 0.0;
        double potapa3 = 0.0;
        double tapdiag1 = 0.0;
        double tapdiag2 = 0.0;
        double tapnodiag = 0.0;
        double Zk12 = 0.0;
        double Zk13 = 0.0;
        double Zk23 = 0.0;
        for (ix = 0; ix < this.ActSchematic.Components.size(); ++ix) {
            TempComponent = (comp)this.ActSchematic.Components.elementAt(ix);
            if (!TempComponent.getactive() || !TempComponent.getvalid() || !TempComponent.getinservice()) continue;
            if (TempComponent instanceof Busbar) {
                TempComponent.InformAllComponents();
                Busbar TempBusbar = (Busbar)TempComponent;
                if (TempBusbar.getctrla().equals(this.ctrla) || this.ctrla.equals("ALL CONTROL AREAS")) {
                    myPrintStream.println(this.numnod + "\t" + TempComponent.getName() + "\t" + TempBusbar.getctrla() + "\t" + "Barra Considerada");
                    ++this.numnod;
                    this.BusbarVectorI.addElement(TempComponent);
                }
            }
            if (!(TempComponent instanceof ndb_branch)) continue;
            if (TempComponent instanceof Line) {
                TempLine = (Line)TempComponent;
                TempLine.InformPartner(TempLine.ConnComps1, TempLine.getx1(), TempLine.gety1(), 1);
                TempLine.InformPartner(TempLine.ConnComps2, TempLine.getx2(), TempLine.gety2(), 2);
                ++this.numlin;
            }
            if (TempComponent instanceof Trafo) {
                TempComponent.InformAllComponents();
                ++this.numtran;
            }
            if (TempComponent instanceof ThreeWindingTrafo) {
                TempComponent.InformAllComponents();
                ++this.numtranthree;
                this.numbran += 2;
            }
            if (TempComponent instanceof Upfc) {
                TempComponent.InformAllComponents();
            }
            ++this.numbran;
        }
        BusSize = this.BusbarVectorI.size();
        this.BranchR = new double[this.numbran];
        this.BranchX = new double[this.numbran];
        this.BranchB = new double[this.numbran];
        this.BranchI = new int[this.numbran];
        this.BranchJ = new int[this.numbran];
        this.react = new double[3];
        this.resistencias = new double[3];
        this.ZthreeWinding = new Complex[3];
        this.Zreales = new Complex[3];
        this.MatY = new Complex[this.numnod][this.numnod];
        for (i = 0; i < this.numnod; ++i) {
            for (j = 0; j < this.numnod; ++j) {
                this.MatY[i][j] = new Complex();
            }
        }
        for (i = 0; i < 3; ++i) {
            this.react[i] = 0.0;
            this.resistencias[i] = 0.0;
            this.ZthreeWinding[i] = new Complex(1.0, 0.0);
            this.Zreales[i] = new Complex(0.0, 0.0);
        }
        for (ix = 0; ix < this.ActSchematic.Components.size(); ++ix) {
            Complex auxc2;
            Complex auxc1;
            TempComponent = (comp)this.ActSchematic.Components.elementAt(ix);
            if (!TempComponent.getactive() || !TempComponent.getvalid() || !TempComponent.getinservice()) continue;
            if (TempComponent instanceof Line && (con1 = this.numbus((TempLine = (Line)TempComponent).getcon1())) != 10000 && (con2 = this.numbus(TempLine.getcon2())) != 10000) {
                this.BranchX[count] = TempLine.getxx1() * TempLine.getlen() * this.getSref() / (TempLine.getun1() * TempLine.getun1());
                this.BranchR[count] = TempLine.getr1() * TempLine.getlen() * this.getSref() / (TempLine.getun1() * TempLine.getun1());
                this.BranchB[count] = TempLine.getb1() * TempLine.getlen() / 2.0 / this.getSref() * (TempLine.getun1() * TempLine.getun1());
                this.BranchI[count] = con1;
                this.BranchJ[count] = con2;
                auxc1 = new Complex(this.BranchR[count], this.BranchX[count]);
                auxc2 = new Complex(1.0);
                auxc1 = auxc2.divide(auxc1);
                auxc2 = new Complex(0.0, this.BranchB[count]);
                this.MatY[this.BranchJ[count]][this.BranchI[count]].add(Complex.negate((Complex)auxc1));
                this.MatY[this.BranchI[count]][this.BranchJ[count]].add(Complex.negate((Complex)auxc1));
                this.MatY[this.BranchI[count]][this.BranchI[count]].add(Complex.add((Complex)auxc1, (Complex)auxc2));
                this.MatY[this.BranchJ[count]][this.BranchJ[count]].add(Complex.add((Complex)auxc1, (Complex)auxc2));
                ++count;
            }
            if (TempComponent instanceof Trafo) {
                Trafo TempTrafo = (Trafo)TempComponent;
                TempTrafo.actualizet();
                con1 = this.numbus(TempTrafo.getcon1());
                if (con1 != 10000 && (con2 = this.numbus(TempTrafo.getcon2())) != 10000) {
                    ueb = TempTrafo.getun1() / TempTrafo.getun2() / (TempTrafo.getur1() / TempTrafo.getur2());
                    res = TempTrafo.getpcu() * 0.001 * ueb * ueb / TempTrafo.getsn() * this.getSref() / TempTrafo.getsn();
                    z = TempTrafo.getuk() * 0.01 * ueb * ueb * this.getSref() / TempTrafo.getsn();
                    b = TempTrafo.geti0() * 0.01 * 0.5 / this.getSref() * TempTrafo.getsn();
                    reac = TempTrafo.getuk() >= 0.0 ? Math.sqrt(z * z - res * res) : -Math.sqrt(z * z - res * res);
                    this.BranchX[count] = reac;
                    this.BranchR[count] = res;
                    this.BranchB[count] = b;
                    this.BranchI[count] = con1;
                    this.BranchJ[count] = con2;
                    auxc1 = new Complex(this.BranchR[count], this.BranchX[count]);
                    auxc2 = new Complex(1.0);
                    auxc1 = Complex.divide((Complex)auxc2, (Complex)auxc1);
                    auxc2 = new Complex(0.0, this.BranchB[count]);
                    if (TempTrafo.gett_im() == 0.0) {
                        factor = new Complex(TempTrafo.gett_re(), 0.0);
                        this.modulo = TempTrafo.gett_re();
                        System.out.println(factor);
                    } else {
                        this.partimag = TempTrafo.gett_im() * Math.PI / 180.0;
                        factor = new Complex(1.0, Math.sin(this.partimag));
                        System.out.println(factor);
                    }
                    this.MatY[this.BranchJ[count]][this.BranchI[count]].add(Complex.negate((Complex)Complex.divide((Complex)auxc1, (Complex)factor)));
                    this.MatY[this.BranchI[count]][this.BranchJ[count]].add(Complex.negate((Complex)Complex.divide((Complex)auxc1, (Complex)Complex.conjugate((Complex)factor))));
                    if (TempTrafo.gett_im() == 0.0) {
                        this.MatY[this.BranchI[count]][this.BranchI[count]].add(Complex.add((Complex)auxc1, (Complex)auxc2).divide(this.modulo * this.modulo));
                    } else {
                        this.MatY[this.BranchI[count]][this.BranchI[count]].add(Complex.add((Complex)auxc1, (Complex)auxc2));
                    }
                    this.MatY[this.BranchJ[count]][this.BranchJ[count]].add(Complex.add((Complex)auxc1, (Complex)auxc2));
                    ++count;
                }
            }
            if (TempComponent instanceof ThreeWindingTrafo) {
                ThreeWindingTrafo TempThreeWindingTrafo = (ThreeWindingTrafo)TempComponent;
                TempThreeWindingTrafo.actualizet();
                con1 = this.numbus(TempThreeWindingTrafo.getcon1());
                if (con1 != 10000 && (con2 = this.numbus(TempThreeWindingTrafo.getcon2())) != 10000 && (con3 = this.numbus(TempThreeWindingTrafo.getcon3())) != 10000) {
                    ueb1 = TempThreeWindingTrafo.getun1() / TempThreeWindingTrafo.getun2() / (TempThreeWindingTrafo.getur1() / TempThreeWindingTrafo.getur2());
                    ueb2 = TempThreeWindingTrafo.getun1() / TempThreeWindingTrafo.getun3() / (TempThreeWindingTrafo.getur1() / TempThreeWindingTrafo.getur3());
                    ueb3 = TempThreeWindingTrafo.getun2() / TempThreeWindingTrafo.getun3() / (TempThreeWindingTrafo.getur2() / TempThreeWindingTrafo.getur3());
                    potapa1 = TempThreeWindingTrafo.getsn() > TempThreeWindingTrafo.getsn1() ? TempThreeWindingTrafo.getsn1() : TempThreeWindingTrafo.getsn();
                    potapa2 = TempThreeWindingTrafo.getsn() > TempThreeWindingTrafo.getsn2() ? TempThreeWindingTrafo.getsn2() : TempThreeWindingTrafo.getsn();
                    potapa3 = TempThreeWindingTrafo.getsn1() > TempThreeWindingTrafo.getsn2() ? TempThreeWindingTrafo.getsn2() : TempThreeWindingTrafo.getsn1();
                    this.resistencias[0] = TempThreeWindingTrafo.getpcu() * (0.001 / potapa1) * (TempThreeWindingTrafo.getun1() * TempThreeWindingTrafo.getun1() / potapa1) * this.getSref() / TempThreeWindingTrafo.getsn();
                    this.resistencias[1] = TempThreeWindingTrafo.getpcu13() * (0.001 / potapa2) * (TempThreeWindingTrafo.getun1() * TempThreeWindingTrafo.getun1() / potapa2) * this.getSref() / TempThreeWindingTrafo.getsn1();
                    this.resistencias[2] = TempThreeWindingTrafo.getpcu23() * (0.001 / potapa3) * (TempThreeWindingTrafo.getun1() * TempThreeWindingTrafo.getun1() / potapa3) * this.getSref() / TempThreeWindingTrafo.getsn2();
                    this.resistencias[0] = this.resistencias[0] * potapa1 / (TempThreeWindingTrafo.getun1() * TempThreeWindingTrafo.getun1());
                    this.resistencias[1] = this.resistencias[1] * potapa2 / (TempThreeWindingTrafo.getun1() * TempThreeWindingTrafo.getun1());
                    this.resistencias[2] = this.resistencias[2] * potapa3 / (TempThreeWindingTrafo.getun1() * TempThreeWindingTrafo.getun1());
                    Zk12 = TempThreeWindingTrafo.getuk12() * 0.01 * (TempThreeWindingTrafo.getun1() * TempThreeWindingTrafo.getun1()) / potapa1 * this.getSref() / TempThreeWindingTrafo.getsn();
                    Zk13 = TempThreeWindingTrafo.getuk13() * 0.01 * (TempThreeWindingTrafo.getun1() * TempThreeWindingTrafo.getun1()) / potapa2 * this.getSref() / TempThreeWindingTrafo.getsn1();
                    Zk23 = TempThreeWindingTrafo.getuk23() * 0.01 * (TempThreeWindingTrafo.getun1() * TempThreeWindingTrafo.getun1()) / potapa3 * this.getSref() / TempThreeWindingTrafo.getsn2();
                    Zk12 = Zk12 * TempThreeWindingTrafo.getsn() / (TempThreeWindingTrafo.getun1() * TempThreeWindingTrafo.getun1());
                    Zk13 = Zk13 * TempThreeWindingTrafo.getsn() / (TempThreeWindingTrafo.getun1() * TempThreeWindingTrafo.getun1());
                    Zk23 = Zk23 * TempThreeWindingTrafo.getsn() / (TempThreeWindingTrafo.getun1() * TempThreeWindingTrafo.getun1());
                    b = TempThreeWindingTrafo.geti0() * 0.01 / this.getSref() * TempThreeWindingTrafo.getsn();
                    tap1 = TempThreeWindingTrafo.gett_re();
                    tap2 = TempThreeWindingTrafo.gett_re1();
                    tap3 = TempThreeWindingTrafo.gett_re2();
                    c = 0;
                    parestrafo = 0;
                    this.react[0] = TempThreeWindingTrafo.getuk12() >= 0.0 ? Math.sqrt(Zk12 * Zk12 - this.resistencias[0] * this.resistencias[0]) : -Math.sqrt(Zk12 * Zk12 - this.resistencias[0] * this.resistencias[0]);
                    this.react[1] = TempThreeWindingTrafo.getuk13() >= 0.0 ? Math.sqrt(Zk13 * Zk13 - this.resistencias[1] * this.resistencias[1]) : -Math.sqrt(Zk13 * Zk13 - this.resistencias[1] * this.resistencias[1]);
                    this.react[2] = TempThreeWindingTrafo.getuk23() >= 0.0 ? Math.sqrt(Zk23 * Zk23 - this.resistencias[2] * this.resistencias[2]) : -Math.sqrt(Zk23 * Zk23 - this.resistencias[2] * this.resistencias[2]);
                    this.ZthreeWinding[0] = new Complex(0.5 * (this.resistencias[0] + this.resistencias[1] - this.resistencias[2]), 0.5 * (this.react[0] + this.react[1] - this.react[2]));
                    this.ZthreeWinding[1] = new Complex(0.5 * (this.resistencias[0] + this.resistencias[2] - this.resistencias[1]), 0.5 * (this.react[0] + this.react[2] - this.react[1]));
                    this.ZthreeWinding[2] = new Complex(0.5 * (this.resistencias[1] + this.resistencias[2] - this.resistencias[0]), 0.5 * (this.react[1] + this.react[2] - this.react[0]));
                    Zrama12 = new Complex(this.resistencias[0], this.react[0]);
                    Zrama13 = new Complex(this.resistencias[1], this.react[1]);
                    Zrama23 = new Complex(this.resistencias[2], this.react[2]);
                    this.Zreales[0] = Complex.add((Complex)Zrama12, (Complex)Complex.divide((Complex)Complex.multiply((Complex)this.ZthreeWinding[0], (Complex)this.ZthreeWinding[1]), (Complex)this.ZthreeWinding[2]));
                    this.Zreales[1] = Complex.add((Complex)Zrama13, (Complex)Complex.divide((Complex)Complex.multiply((Complex)this.ZthreeWinding[0], (Complex)this.ZthreeWinding[2]), (Complex)this.ZthreeWinding[1]));
                    this.Zreales[2] = Complex.add((Complex)Zrama23, (Complex)Complex.divide((Complex)Complex.multiply((Complex)this.ZthreeWinding[1], (Complex)this.ZthreeWinding[2]), (Complex)this.ZthreeWinding[0]));
                    auxc3 = new Complex(0.0, b);
                    fintrafo = count + 3;
                    for (count = countaux = count; count < fintrafo; ++count) {
                        this.BranchX[count] = this.Zreales[c].im;
                        this.BranchR[count] = this.Zreales[c].re;
                        this.BranchB[count] = b;
                        auxc1 = new Complex(this.ZthreeWinding[c]);
                        auxc2 = new Complex(1.0);
                        auxc1 = Complex.divide((Complex)auxc2, (Complex)auxc1);
                        auxc2 = new Complex(0.0, this.BranchB[count]);
                        if (c == 0) {
                            ramaY1 = auxc1;
                        } else if (c == 1) {
                            ramaY2 = auxc1;
                        } else if (c == 2) {
                            ramaY3 = auxc1;
                        }
                        ++c;
                    }
                    A1 = Complex.divide((Complex)ramaY1, (Complex)Complex.add((Complex)ramaY1, (Complex)Complex.add((Complex)ramaY2, (Complex)ramaY3)));
                    A2 = Complex.divide((Complex)ramaY2, (Complex)Complex.add((Complex)ramaY1, (Complex)Complex.add((Complex)ramaY2, (Complex)ramaY3)));
                    A3 = Complex.add((Complex)ramaY1, (Complex)Complex.add((Complex)ramaY2, (Complex)ramaY3));
                    invertA3 = Complex.divide((Complex)neutro, (Complex)A3);
                    factory = Complex.multiply((Complex)A3, (Complex)auxc3);
                    for (count = countaux; count < fintrafo; ++count) {
                        if (parestrafo == 0) {
                            this.BranchI[count] = con1;
                            this.BranchJ[count] = con2;
                            Afinal = A1;
                            ramaY = ramaY2;
                            tapdiag1 = tap1 * tap1;
                            tapnodiag = tap1 * tap2;
                            tapdiag2 = tap2 * tap2;
                            if (TempThreeWindingTrafo.getlado() == "HV") {
                                System.out.println("HV");
                                primerdiag = factory;
                                segundiag = new Complex(0.0, 0.0);
                            }
                        } else if (parestrafo == 1) {
                            this.BranchI[count] = con1;
                            this.BranchJ[count] = con3;
                            Afinal = A1;
                            ramaY = ramaY3;
                            tapdiag1 = tap1 * tap1;
                            tapnodiag = tap1 * tap3;
                            tapdiag2 = tap3 * tap3;
                            if (TempThreeWindingTrafo.getlado() == "LV") {
                                System.out.println("LV");
                                primerdiag = new Complex(0.0, 0.0);
                                segundiag = factory;
                            }
                        } else if (parestrafo == 2) {
                            this.BranchI[count] = con2;
                            this.BranchJ[count] = con3;
                            Afinal = A2;
                            ramaY = ramaY3;
                            tapdiag1 = tap2 * tap2;
                            tapnodiag = tap2 * tap3;
                            tapdiag2 = tap3 * tap3;
                            if (TempThreeWindingTrafo.getlado() == "MV") {
                                System.out.println("MV");
                                primerdiag = factory;
                                segundiag = new Complex(0.0, 0.0);
                            }
                        }
                        invertapdiag1 = new Complex(tapdiag1, 0.0);
                        invertapnodiag = new Complex(tapnodiag, 0.0);
                        invertapdiag2 = new Complex(tapdiag2, 0.0);
                        invertapdiag1 = Complex.divide((Complex)neutro, (double)tapdiag1);
                        invertapnodiag = Complex.divide((Complex)neutro, (double)tapnodiag);
                        invertapdiag2 = Complex.divide((Complex)neutro, (double)tapdiag2);
                        this.MatY[this.BranchJ[count]][this.BranchI[count]].add(Complex.negate((Complex)Complex.multiply((Complex)ramaY, (Complex)Complex.multiply((Complex)Afinal, (Complex)invertapnodiag))));
                        this.MatY[this.BranchI[count]][this.BranchJ[count]].add(Complex.negate((Complex)Complex.multiply((Complex)ramaY, (Complex)Complex.multiply((Complex)Afinal, (Complex)invertapnodiag))));
                        this.MatY[this.BranchI[count]][this.BranchI[count]].add(Complex.add((Complex)Complex.multiply((Complex)ramaY, (Complex)Complex.multiply((Complex)Afinal, (Complex)invertapdiag1)), (Complex)Complex.multiply((Complex)primerdiag, (Complex)Complex.multiply((Complex)invertA3, (Complex)invertapdiag1))));
                        this.MatY[this.BranchJ[count]][this.BranchJ[count]].add(Complex.add((Complex)Complex.multiply((Complex)ramaY, (Complex)Complex.multiply((Complex)Afinal, (Complex)invertapdiag2)), (Complex)Complex.multiply((Complex)segundiag, (Complex)Complex.multiply((Complex)invertA3, (Complex)invertapdiag2))));
                        ++parestrafo;
                        primerdiag = new Complex(0.0, 0.0);
                        segundiag = new Complex(0.0, 0.0);
                    }
                }
            }
            if (!(TempComponent instanceof Upfc)) continue;
            Upfc TempUpfc = (Upfc)TempComponent;
            double auxr = 0.0;
            double rserie = 0.0;
            double xserie = 0.0;
            double gshunt = 0.0;
            double bshunt = 0.0;
            con1 = this.numbus(TempUpfc.getcon1());
            if (con1 == 10000 || (con2 = this.numbus(TempUpfc.getcon2())) == 10000) continue;
            auxr = TempUpfc.getun1() * TempUpfc.getun1() / this.getSref();
            rserie = 0.0;
            xserie = TempUpfc.getxboost() / auxr;
            gshunt = 0.0;
            bshunt = -1.0 / (TempUpfc.getxexc() / auxr);
            this.BranchX[count] = xserie;
            this.BranchR[count] = rserie;
            this.BranchB[count] = bshunt;
            this.BranchI[count] = con1;
            this.BranchJ[count] = con2;
            auxc1 = new Complex(this.BranchR[count], this.BranchX[count]);
            auxc2 = new Complex(1.0);
            auxc1 = Complex.divide((Complex)auxc2, (Complex)auxc1);
            auxc2 = new Complex(0.0, this.BranchB[count]);
            Complex auxzero = new Complex(0.0, 0.0);
            this.MatY[this.BranchJ[count]][this.BranchI[count]].add(Complex.negate((Complex)auxc1));
            this.MatY[this.BranchI[count]][this.BranchJ[count]].add(Complex.negate((Complex)auxc1));
            this.MatY[this.BranchI[count]][this.BranchI[count]].add(Complex.add((Complex)auxc1, (Complex)auxc2));
            this.MatY[this.BranchJ[count]][this.BranchJ[count]].add(Complex.add((Complex)auxc1, (Complex)auxzero));
        }
        myPrintStream.println("------------------------------------------------");
        myPrintStream.println("Matriz de admitancia Y (pu)");
        Admittance.printMatrix(myPrintStream, this.MatY, this.numnod, this.numnod);
    }

    public static void printMatrix(PrintStream myPrintStream, Complex[][] m, int ii, int jj) {
        for (int i = 0; i < ii; ++i) {
            for (int j = 0; j < jj; ++j) {
                myPrintStream.print(m[i][j] + "\t \t \t");
            }
            myPrintStream.println();
        }
        myPrintStream.println();
        int Arista = Math.min(650 / jj, 25);
        FrameDibujo f = new FrameDibujo("Visualizaci\u00f3n Gr\u00e1fica de Matriz de Admitancia", m, ii, jj, Arista);
        f.setSize(Math.max(Arista * ii + 20, 340), Arista * jj + 110);
        f.setVisible(true);
        f.repaint();
    }

    public static void printVector(PrintStream myPrintStream, Complex[] v, int ii) {
        for (int i = 0; i < ii; ++i) {
            myPrintStream.print(i + "\t" + v[i] + "\t");
            myPrintStream.println();
        }
        myPrintStream.println();
    }

    public int numbus(String Busbarname) {
        int ixx = 0;
        for (int ix = 0; ix < this.BusbarVectorI.size(); ++ix) {
            ++ixx;
            comp TempComponent = (comp)this.BusbarVectorI.elementAt(ix);
            if (TempComponent.getName().hashCode() != Busbarname.hashCode() || !TempComponent.getName().equals(Busbarname)) continue;
            return ixx - 1;
        }
        return 10000;
    }
}

