/*
 * Decompiled with CFR 0.152.
 */
package de.core;

import de.core.DeepEditWizardModel;
import de.core.WizardTask;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.LayoutStyle;

public abstract class AbstractDeepEditWizard
extends JDialog {
    public static Color TASK_DEFAULT_BCKGRND_COLOR = new Color(31, 166, 190);
    public static Color PANEL_DEFAULT_BCKGRND_COLOR = new Color(61, 181, 203);
    public static Color PANEL_DEFAULT_FOREGRND_COLOR = new Color(61, 181, 203);
    public static Font TASK_DEFAULT_FONT = new Font("Tahoma", 0, 11);
    public static Font TASK_ACTIVE_FONT = new Font("Tahoma", 1, 11);
    private final DeepEditWizardModel wModel = new DeepEditWizardModel();
    private String exitMessage = "Are you sure you want to cancel Wizard?";
    private boolean bFinishBtnAutoDisplay = true;
    private WizardTask oSelectedTask;
    private JLabel lblActiveTask;
    private JLabel lblBackBtn;
    private JLabel lblFinishBtn;
    private JLabel lblFwdBtn;
    private JLabel lblInactiveTask;
    private JPanel pnlControl;
    private JPanel pnlMain;
    private JPanel pnlTask;
    private JPanel pnlTitle;
    private JTextArea txtDescription;
    private JTextArea txtTitle;

    public AbstractDeepEditWizard(Window parent, String sTitle) {
        super((Frame)parent, true);
        this.initComponents();
        this.setTitle(sTitle);
        this.pnlTask.remove(this.lblActiveTask);
        this.pnlTask.remove(this.lblInactiveTask);
        TASK_DEFAULT_BCKGRND_COLOR = this.pnlTask.getBackground();
        PANEL_DEFAULT_BCKGRND_COLOR = this.pnlMain.getBackground();
        PANEL_DEFAULT_FOREGRND_COLOR = this.pnlMain.getForeground();
        this.lblFinishBtn.setVisible(false);
    }

    public void addTask(String name, JPanel pnl, String title, String description) {
        assert (!this.isVisible()) : "Never use this method onces the Wizard is visible";
        WizardTask task = new WizardTask(name, pnl, title, description);
        this.wModel.registerPanel(task);
        pnl.setName(name);
        pnl.setOpaque(false);
        this.adjustForeground(pnl);
        this.pnlTask.add(this.taskJLabel(name));
        this.pnlMain.add((Component)pnl, name);
        if (this.wModel.getTotalPanels() == 1) {
            this.setSelectedTask(name);
        } else if (this.wModel.getTotalPanels() > 1) {
            this.lblFwdBtn.setEnabled(true);
            this.setFinishBtnVisible(false);
        }
    }

    public void addTasks(String[] labels, JPanel[] panels, String[] titles, String[] descriptions) {
        assert (panels != null) : "An array with list of panels is a mandatory argument";
        assert (labels != null) : "An array with list of labels is a mandatory argument";
        assert (panels.length == labels.length) : "Why this method has different number of panels and labels???";
        assert (panels.length == titles.length) : "Why this method has different number of panels and titles???";
        assert (panels.length == descriptions.length) : "Why this method has different number of panels and descriptions???";
        if (panels.length > 0) {
            for (int i = 0; i < panels.length; ++i) {
                this.addTask(labels[i], panels[i], titles[i], descriptions[i]);
            }
            this.setSelectedTask(labels[0]);
        }
    }

    public void setFinishBtnVisible(boolean bActive) {
        this.lblFinishBtn.setVisible(bActive);
    }

    public void setFinishBtnAutoDisplay(boolean bActive) {
        this.bFinishBtnAutoDisplay = bActive;
    }

    public void setExitMessage(String newMessage) {
        this.exitMessage = newMessage;
    }

    public void setFowardEnabled(boolean bActive) {
        this.lblFwdBtn.setEnabled(bActive);
    }

    public void setBackEnabled(boolean bActive) {
        this.lblBackBtn.setEnabled(bActive);
    }

    public void showUnexpectedExceptionMessage(String msgHeader, Exception e) {
        String sHeader = "";
        String sLocalizedMessage = "";
        if (msgHeader != null) {
            sHeader = msgHeader;
        }
        if (e != null) {
            sLocalizedMessage = e.getLocalizedMessage();
            e.printStackTrace(System.err);
        }
        JOptionPane.showMessageDialog(this, sHeader + "\n" + sLocalizedMessage, "Error creating case ", 0);
        System.out.println(msgHeader);
        System.out.println(sLocalizedMessage);
        System.out.println("Check error log for exception details");
        this.wizardCancelled();
    }

    public abstract void beforeShowingPanel(JPanel var1);

    public abstract void finishWizard();

    private void adjustForeground(JPanel pnl) {
        for (Component c : pnl.getComponents()) {
            if (!(c instanceof JLabel)) continue;
            c.setForeground(PANEL_DEFAULT_FOREGRND_COLOR);
        }
    }

    private void setSelectedTask(String labelName) {
        if (labelName == null) {
            return;
        }
        this.oSelectedTask = this.wModel.getTask(labelName);
        if (this.oSelectedTask == null) {
            return;
        }
        for (Component c : this.pnlTask.getComponents()) {
            if (!(c instanceof JLabel)) continue;
            if (labelName.equalsIgnoreCase(c.getName())) {
                c.setBackground(Color.WHITE);
                c.setFont(TASK_ACTIVE_FONT);
                continue;
            }
            c.setBackground(this.pnlTask.getBackground());
            c.setFont(TASK_DEFAULT_FONT);
        }
        this.txtTitle.setText(this.oSelectedTask.getTaskTitle());
        this.txtDescription.setText(this.oSelectedTask.getTaskDescription());
        this.lblBackBtn.setEnabled(!this.isFirstPanel(this.oSelectedTask.getTaskName()));
        this.lblFwdBtn.setEnabled(!this.isLastPanel(this.oSelectedTask.getTaskName()));
        if (this.bFinishBtnAutoDisplay) {
            this.setFinishBtnVisible(this.isLastPanel(this.oSelectedTask.getTaskName()));
        }
        this.beforeShowingPanel(this.oSelectedTask.getTaskPnl());
    }

    private void moveNextTask() {
        String sCurrentTaskName = this.oSelectedTask.getTaskName();
        WizardTask nextTask = this.wModel.nextTask(sCurrentTaskName);
        JPanel nexPnl = this.wModel.nextPanel(sCurrentTaskName);
        if (nexPnl != null && nextTask != null) {
            CardLayout card = (CardLayout)this.pnlMain.getLayout();
            card.show(this.pnlMain, nextTask.getTaskName());
            this.setSelectedTask(nextTask.getTaskName());
        } else {
            this.lblFwdBtn.setEnabled(false);
        }
    }

    private void movePreviousTask() {
        String sCurrentTaskName = this.oSelectedTask.getTaskName();
        WizardTask prevTask = this.wModel.prevTask(sCurrentTaskName);
        JPanel prevPnl = this.wModel.prevPanel(sCurrentTaskName);
        if (prevPnl != null && prevTask != null) {
            CardLayout card = (CardLayout)this.pnlMain.getLayout();
            card.show(this.pnlMain, prevTask.getTaskName());
            this.setSelectedTask(prevTask.getTaskName());
            this.lblFwdBtn.setEnabled(true);
            this.lblBackBtn.setEnabled(!this.isFirstPanel(prevTask.getTaskName()));
        } else {
            this.lblBackBtn.setEnabled(false);
        }
    }

    private boolean isLastPanel(String name) {
        return this.wModel.nextTask(name) == null;
    }

    private boolean isFirstPanel(String name) {
        return this.wModel.prevTask(name) == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exitWizard() {
        int yesNo = JOptionPane.showConfirmDialog(this, this.exitMessage, "Wizard Cancel", 0, 3);
        if (yesNo == 0) {
            try {
                this.wizardCancelled();
            }
            finally {
                this.dispose();
            }
        }
    }

    public void wizardCancelled() {
    }

    private void initComponents() {
        this.pnlTitle = new JPanel();
        this.lblBackBtn = new JLabel();
        this.lblFwdBtn = new JLabel();
        this.txtTitle = new JTextArea();
        this.pnlTask = new JPanel();
        this.lblActiveTask = new JLabel();
        this.lblInactiveTask = new JLabel();
        this.pnlMain = new JPanel();
        this.pnlControl = new JPanel();
        this.txtDescription = new JTextArea();
        this.lblFinishBtn = new JLabel();
        this.setDefaultCloseOperation(0);
        this.setTitle("DeepEdit Wizard");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                AbstractDeepEditWizard.this.formWindowClosing(evt);
            }
        });
        this.pnlTitle.setBackground(new Color(255, 255, 255));
        this.lblBackBtn.setIcon(new ImageIcon(this.getClass().getResource("/images/w10_26x-left_round.png")));
        this.lblBackBtn.setEnabled(false);
        this.lblBackBtn.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                AbstractDeepEditWizard.this.lblBackBtnMouseClicked(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                AbstractDeepEditWizard.this.lblBackBtnMouseReleased(evt);
            }
        });
        this.lblFwdBtn.setIcon(new ImageIcon(this.getClass().getResource("/images/w10_26x-right_round.png")));
        this.lblFwdBtn.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                AbstractDeepEditWizard.this.lblFwdBtnMouseClicked(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                AbstractDeepEditWizard.this.lblFwdBtnMouseReleased(evt);
            }
        });
        this.txtTitle.setEditable(false);
        this.txtTitle.setColumns(20);
        this.txtTitle.setFont(new Font("Tahoma", 1, 18));
        this.txtTitle.setForeground(PANEL_DEFAULT_BCKGRND_COLOR);
        this.txtTitle.setRows(5);
        this.txtTitle.setText("Task Name");
        this.txtTitle.setBorder(null);
        GroupLayout pnlTitleLayout = new GroupLayout(this.pnlTitle);
        this.pnlTitle.setLayout(pnlTitleLayout);
        pnlTitleLayout.setHorizontalGroup(pnlTitleLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlTitleLayout.createSequentialGroup().addContainerGap().addComponent(this.lblBackBtn).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblFwdBtn).addGap(62, 62, 62).addComponent(this.txtTitle)));
        pnlTitleLayout.setVerticalGroup(pnlTitleLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlTitleLayout.createSequentialGroup().addContainerGap().addGroup(pnlTitleLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblFwdBtn).addComponent(this.lblBackBtn)).addContainerGap(-1, Short.MAX_VALUE)).addGroup(pnlTitleLayout.createSequentialGroup().addComponent(this.txtTitle, -2, 0, Short.MAX_VALUE).addContainerGap()));
        this.pnlTask.setBackground(new Color(79, 157, 215));
        this.pnlTask.setCursor(new Cursor(0));
        this.pnlTask.setMaximumSize(new Dimension(124, 9999));
        this.pnlTask.setMinimumSize(new Dimension(124, 265));
        this.pnlTask.setLayout(new BoxLayout(this.pnlTask, 3));
        this.lblActiveTask.setBackground(new Color(255, 255, 255));
        this.lblActiveTask.setFont(new Font("Tahoma", 1, 10));
        this.lblActiveTask.setHorizontalAlignment(0);
        this.lblActiveTask.setText("Step1");
        this.lblActiveTask.setMaximumSize(new Dimension(124, 25));
        this.lblActiveTask.setMinimumSize(new Dimension(124, 25));
        this.lblActiveTask.setName("Step1");
        this.lblActiveTask.setOpaque(true);
        this.lblActiveTask.setPreferredSize(new Dimension(124, 25));
        this.pnlTask.add(this.lblActiveTask);
        this.lblInactiveTask.setBackground(new Color(79, 157, 215));
        this.lblInactiveTask.setFont(new Font("Tahoma", 0, 10));
        this.lblInactiveTask.setHorizontalAlignment(0);
        this.lblInactiveTask.setText("Step2");
        this.lblInactiveTask.setMaximumSize(new Dimension(124, 25));
        this.lblInactiveTask.setMinimumSize(new Dimension(124, 25));
        this.lblInactiveTask.setName("Step1");
        this.lblInactiveTask.setOpaque(true);
        this.lblInactiveTask.setPreferredSize(new Dimension(124, 25));
        this.pnlTask.add(this.lblInactiveTask);
        this.pnlMain.setBackground(new Color(12, 173, 227));
        this.pnlMain.setForeground(new Color(255, 255, 255));
        this.pnlMain.setLayout(new CardLayout());
        this.pnlControl.setBackground(new Color(255, 255, 255));
        this.txtDescription.setEditable(false);
        this.txtDescription.setColumns(20);
        this.txtDescription.setFont(new Font("Tahoma", 0, 10));
        this.txtDescription.setRows(5);
        this.txtDescription.setText("Task Description");
        this.txtDescription.setBorder(BorderFactory.createEtchedBorder());
        this.lblFinishBtn.setIcon(new ImageIcon(this.getClass().getResource("/images/w10_26x-ok.png")));
        this.lblFinishBtn.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                AbstractDeepEditWizard.this.lblFinishBtnMouseClicked(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                AbstractDeepEditWizard.this.lblFinishBtnMouseReleased(evt);
            }
        });
        GroupLayout pnlControlLayout = new GroupLayout(this.pnlControl);
        this.pnlControl.setLayout(pnlControlLayout);
        pnlControlLayout.setHorizontalGroup(pnlControlLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlControlLayout.createSequentialGroup().addComponent(this.txtDescription, -2, 472, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 19, Short.MAX_VALUE).addComponent(this.lblFinishBtn).addContainerGap()));
        pnlControlLayout.setVerticalGroup(pnlControlLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlControlLayout.createSequentialGroup().addGroup(pnlControlLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.lblFinishBtn).addComponent(this.txtDescription, -2, 40, -2)).addGap(0, 0, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.pnlTitle, -1, -1, Short.MAX_VALUE).addComponent(this.pnlControl, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.pnlTask, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.pnlMain, -1, -1, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.pnlTitle, -2, 40, -2).addGap(0, 0, 0).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.pnlMain, -1, -1, Short.MAX_VALUE).addComponent(this.pnlTask, -1, 274, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.pnlControl, -2, -1, -2)));
        this.pack();
    }

    private void lblFwdBtnMouseClicked(MouseEvent evt) {
    }

    private void lblBackBtnMouseClicked(MouseEvent evt) {
    }

    private void lblFinishBtnMouseClicked(MouseEvent evt) {
    }

    private void formWindowClosing(WindowEvent evt) {
        this.exitWizard();
    }

    private void lblFwdBtnMouseReleased(MouseEvent evt) {
        if (this.lblFwdBtn.isEnabled()) {
            this.moveNextTask();
        }
    }

    private void lblBackBtnMouseReleased(MouseEvent evt) {
        if (this.lblBackBtn.isEnabled()) {
            this.movePreviousTask();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lblFinishBtnMouseReleased(MouseEvent evt) {
        try {
            this.finishWizard();
        }
        catch (Exception e) {
            System.out.println("Unexepected error closing Wizard. Details: " + e);
            e.printStackTrace(System.err);
        }
        finally {
            this.dispose();
        }
    }

    public JLabel taskJLabel(String name) {
        JLabel lblNewTask = new JLabel();
        lblNewTask.setBackground(this.pnlTask.getBackground());
        lblNewTask.setHorizontalAlignment(0);
        lblNewTask.setText(name);
        lblNewTask.setName(name);
        lblNewTask.setFont(TASK_DEFAULT_FONT);
        lblNewTask.setMaximumSize(new Dimension(124, 25));
        lblNewTask.setMinimumSize(new Dimension(124, 25));
        lblNewTask.setOpaque(true);
        lblNewTask.setPreferredSize(new Dimension(124, 25));
        return lblNewTask;
    }
}

