/*
 * Decompiled with CFR 0.152.
 */
package drasys.or.stat.model;

import drasys.or.matrix.FunctionMatrix;
import drasys.or.matrix.MatrixI;

public class QuadraticMatrix
extends FunctionMatrix {
    private int _n;
    MatrixI _matrix;

    public QuadraticMatrix(MatrixI matrixI) {
        this._n = matrixI.sizeOfColumns();
        this._matrix = matrixI;
        this._sizeOfRows = matrixI.sizeOfRows();
        this._sizeOfColumns = this._n + this._n * this._n;
    }

    public double functionElementAt(int n, int n2) {
        if (n2 < this._n) {
            return this._matrix.elementAt(n, n2);
        }
        int n3 = n2 - this._n;
        int n4 = n3 / this._n;
        int n5 = n3 % this._n;
        return this._matrix.elementAt(n, n4) * this._matrix.elementAt(n, n5);
    }

    public int getProductIndex(int n, int n2) {
        if (n >= this._n) {
            throw new Error("The column-1 index (" + n + ") exceeds the size of the underlying matrix (" + this._n + ").");
        }
        if (n2 >= this._n) {
            throw new Error("The column-2 index (" + n2 + ") exceeds the size of the underlying matrix (" + this._n + ").");
        }
        return this._n + n * this._n + n2;
    }
}

