/*
 * Decompiled with CFR 0.152.
 */
package drasys.or.stat.model;

import drasys.or.matrix.DenseVector;
import drasys.or.matrix.MatrixI;
import drasys.or.matrix.VectorI;
import drasys.or.prob.FDistribution;
import drasys.or.prob.StudentsTDistribution;
import drasys.or.stat.model.GeneralLinearModel;
import drasys.or.stat.model.GeneralLinearModelI;
import drasys.or.stat.model.LinearRegressionI;

public abstract class LinearRegression
implements LinearRegressionI {
    protected int _m;
    protected int _n;
    protected int[] _selectedVariables;
    protected int[] _requiredVariables;
    protected int[] _enteringVariables;
    protected VectorI _dependent;
    protected VectorI _coef;
    protected VectorI _upper;
    protected VectorI _lower;
    protected VectorI _stdv;
    protected VectorI _tstat;
    protected VectorI _tpvalue;
    protected MatrixI _independent;
    protected MatrixI _cov;
    protected GeneralLinearModelI _glm;
    protected double _exitPValue = 0.05;
    protected double _enterPValue = 0.05;
    protected double _lastConfidenceLevel;
    protected double _cfstat;
    protected boolean _zeroIntercept = false;

    public LinearRegression(VectorI vectorI, MatrixI matrixI) {
        this(new GeneralLinearModel(vectorI, matrixI));
    }

    public LinearRegression(GeneralLinearModelI generalLinearModelI) {
        this._glm = generalLinearModelI;
        this._dependent = this._glm.getDependent();
        this._independent = this._glm.getIndependent();
        this._m = this._independent.sizeOfRows();
        this._n = this._independent.sizeOfColumns();
        this._requiredVariables = new int[0];
        this._enteringVariables = this.allVariables();
        this.setSelectedVariables(this.allVariables());
    }

    public int[] allVariables() {
        int[] nArray = new int[this._n];
        int n = 0;
        while (n < this._n) {
            nArray[n] = n;
            ++n;
        }
        return nArray;
    }

    public VectorI getCoefficients() {
        return this._coef;
    }

    public double getEnteringThreshold() {
        return this._enterPValue;
    }

    public int[] getEnteringVariables() {
        return this._enteringVariables;
    }

    public double getExitingThreshold() {
        return this._exitPValue;
    }

    public double getF() {
        return this._cfstat;
    }

    public double getFPV() {
        FDistribution fDistribution = new FDistribution(this._glm.getDFR(), this._glm.getDFT());
        return 1.0 - fDistribution.cdf(this._cfstat);
    }

    public GeneralLinearModelI getGLM() {
        return this._glm;
    }

    public VectorI getLowerBounds(double d) {
        double d2;
        double d3;
        if (d < 0.0 || d > 1.0) {
            throw new Error("Bad confidence level");
        }
        if (this._lower != null && this._lastConfidenceLevel == d) {
            return this._lower;
        }
        this._lastConfidenceLevel = d;
        int n = this._selectedVariables.length;
        int n2 = this._zeroIntercept ? n : n + 1;
        int n3 = this._m - n - 1;
        StudentsTDistribution studentsTDistribution = new StudentsTDistribution((double)n3);
        this._lower = new DenseVector(n2);
        this._upper = new DenseVector(n2);
        double d4 = studentsTDistribution.inverseCdf(1.0 - 0.5 * (1.0 - d));
        int n4 = 0;
        while (n4 < n) {
            d3 = this._coef.elementAt(n4);
            d2 = this._stdv.elementAt(n4) * d4;
            this._lower.setElementAt(n4, d3 - d2);
            this._upper.setElementAt(n4, d3 + d2);
            ++n4;
        }
        if (!this._zeroIntercept) {
            d3 = this._coef.elementAt(n);
            d2 = this._stdv.elementAt(n) * d4;
            this._lower.setElementAt(n, d3 - d2);
            this._upper.setElementAt(n, d3 + d2);
        }
        return this._lower;
    }

    public int[] getRequiredVariables() {
        return this._requiredVariables;
    }

    public int[] getSelectedVariables() {
        return this._selectedVariables;
    }

    public VectorI getT() {
        return this._tstat;
    }

    public VectorI getTPV() {
        return this._tpvalue;
    }

    public double getTStatistic(double d) {
        int n = this._glm.getDFE();
        double d2 = new StudentsTDistribution((double)n).inverseCdf(d);
        return d2;
    }

    public VectorI getUpperBounds(double d) {
        this.getLowerBounds(d);
        return this._upper;
    }

    public void setEnteringThreshold(double d) {
        this._enterPValue = d;
    }

    public void setEnteringVariables(int[] nArray) {
        this._enteringVariables = nArray;
    }

    public void setExitingThreshold(double d) {
        this._exitPValue = d;
    }

    public void setRequiredVarables(int[] nArray) {
        this._requiredVariables = nArray;
    }

    public void setSelectedVariables(int[] nArray) {
        int n;
        if (nArray != null) {
            this._selectedVariables = nArray;
        } else {
            this._selectedVariables = new int[this._n];
            n = 0;
            while (n < this._n) {
                this._selectedVariables[n] = n;
                ++n;
            }
        }
        this._glm.solve(this._zeroIntercept, this._selectedVariables);
        this._coef = this._glm.getCoefficients();
        this._stdv = this._glm.getStandardErrors();
        this._upper = null;
        this._lower = null;
        n = this._selectedVariables.length;
        int n2 = this._zeroIntercept ? n : n + 1;
        int n3 = this._m - n - 1;
        StudentsTDistribution studentsTDistribution = new StudentsTDistribution((double)n3);
        this._tstat = new DenseVector(n2);
        int n4 = 0;
        while (n4 < n) {
            this._tstat.setElementAt(n4, this._coef.elementAt(n4) / this._stdv.elementAt(n4));
            ++n4;
        }
        if (!this._zeroIntercept) {
            this._tstat.setElementAt(n, this._coef.elementAt(n) / this._stdv.elementAt(n));
        }
        this._tpvalue = new DenseVector(n2);
        int n5 = 0;
        while (n5 < n) {
            this._tpvalue.setElementAt(n5, 2.0 * (1.0 - studentsTDistribution.cdf(Math.abs(this._tstat.elementAt(n5)))));
            ++n5;
        }
        if (!this._zeroIntercept) {
            this._tpvalue.setElementAt(n, 2.0 * (1.0 - studentsTDistribution.cdf(Math.abs(this._tstat.elementAt(n)))));
        }
        this._cfstat = this._glm.getMSR() / this._glm.getMSE();
    }

    public abstract int solve();

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(4096);
        stringBuffer.append("---------------------------\n");
        stringBuffer.append("---- Linear Regression ----\n");
        stringBuffer.append("---------------------------\n");
        stringBuffer.append("\n");
        stringBuffer.append("R-Squared        = " + this._glm.getRSquared() + "\n");
        stringBuffer.append("\n");
        stringBuffer.append("REGRESSION\n");
        stringBuffer.append("  Degrees of freedom (DFR) = ").append(this._glm.getDFR()).append("\n");
        stringBuffer.append("  Sum of squares     (SSR) = ").append(this._glm.getSSR()).append("\n");
        stringBuffer.append("  Mean squared       (MSR) = ").append(this._glm.getMSR()).append("\n");
        stringBuffer.append("\n");
        stringBuffer.append("ERROR\n");
        stringBuffer.append("  Degrees of freedom (DFE) = ").append(this._glm.getDFE()).append("\n");
        stringBuffer.append("  Sum of squares     (SSE) = ").append(this._glm.getSSE()).append("\n");
        stringBuffer.append("  Mean squared       (MSE) = ").append(this._glm.getMSE()).append("\n");
        stringBuffer.append("\n");
        stringBuffer.append("TOTAL\n");
        stringBuffer.append("  Degrees of freedom (DFT) = ").append(this._glm.getDFT()).append("\n");
        stringBuffer.append("  Sum of squares     (SST) = ").append(this._glm.getSST()).append("\n");
        stringBuffer.append("  Mean squared       (MST) = ").append(this._glm.getMST()).append("\n");
        stringBuffer.append("\n");
        stringBuffer.append("MODEL NULL HYPOTHESIS\n");
        stringBuffer.append("  'F' statistic      = " + this.getF() + "\n");
        stringBuffer.append("  'F' p-value        = " + this.getFPV() + "\n");
        stringBuffer.append("\n");
        stringBuffer.append("REGRESSION PARAMETERS\n");
        stringBuffer.append("  Exit p-value       = " + this._exitPValue + "\n");
        stringBuffer.append("  Enter p-value      = " + this._enterPValue + "\n");
        stringBuffer.append("\n");
        int n = this._selectedVariables.length;
        this.getLowerBounds(0.95);
        if (!this._zeroIntercept) {
            stringBuffer.append("INTERCEPT\n");
            stringBuffer.append("  Coefficient       = ").append(this._coef.elementAt(n)).append("\n");
            stringBuffer.append("  Lower bound @ 95% = ").append(this._lower.elementAt(n)).append("\n");
            stringBuffer.append("  Upper bound @ 95% = ").append(this._upper.elementAt(n)).append("\n");
            stringBuffer.append("  Standard Error    = ").append(this._stdv.elementAt(n)).append("\n");
            stringBuffer.append("  'T' statistic     = ").append(this._tstat.elementAt(n)).append("\n");
            stringBuffer.append("  'T' p-value       = ").append(this._tpvalue.elementAt(n)).append("\n");
            stringBuffer.append("\n");
        }
        int n2 = 0;
        while (n2 < n) {
            int n3 = this._selectedVariables[n2];
            stringBuffer.append("COLUMN-").append(n3).append("\n");
            stringBuffer.append("  Coefficient       = ").append(this._coef.elementAt(n2)).append("\n");
            stringBuffer.append("  Lower bound @ 95% = ").append(this._lower.elementAt(n2)).append("\n");
            stringBuffer.append("  Upper bound @ 95% = ").append(this._upper.elementAt(n2)).append("\n");
            stringBuffer.append("  Standard Error    = ").append(this._stdv.elementAt(n2)).append("\n");
            stringBuffer.append("  'T' statistic     = ").append(this._tstat.elementAt(n2)).append("\n");
            stringBuffer.append("  'T' p-value       = ").append(this._tpvalue.elementAt(n2)).append("\n");
            stringBuffer.append("\n");
            ++n2;
        }
        return stringBuffer.toString();
    }
}

