/*
 * Decompiled with CFR 0.152.
 */
package drasys.or.prob;

import drasys.or.InvalidArgumentError;
import drasys.or.nonlinear.Bisection;
import drasys.or.nonlinear.EquationSolutionI;
import drasys.or.nonlinear.FunctionI;
import drasys.or.nonlinear.NonlinearException;
import drasys.or.prob.ContinuousDistribution;
import drasys.or.prob.IncompleteBeta;
import drasys.or.prob.ProbError;

public class StudentsTDistribution
extends ContinuousDistribution
implements FunctionI {
    double _n;
    double _n2;
    double _n12;
    double _k;
    IncompleteBeta _ibeta;
    static final double MIN = -10000.0;
    static final double MAX = 10000.0;
    static EquationSolutionI _solver;

    public StudentsTDistribution(double d) {
        if (d < 1.0) {
            throw new InvalidArgumentError("The degreesOfFreedom can't be less than '1.0'.");
        }
        this._n = d;
        this._n12 = -0.5 * (this._n + 1.0);
        this._ibeta = new IncompleteBeta(0.5 * this._n, 0.5);
        this._k = this._ibeta.lnGamma(-this._n12) - 0.5 * Math.log(this._n * Math.PI) - this._ibeta.lnGamma(0.5 * this._n);
    }

    public double cdf(double d) {
        if (d <= -10000.0) {
            return 0.0;
        }
        if (d >= 10000.0) {
            return 1.0;
        }
        if (d == 0.0) {
            return 0.5;
        }
        double d2 = this._ibeta.function(this._n / (this._n + d * d));
        if (d >= 0.0) {
            return 1.0 - 0.5 * d2;
        }
        return 0.5 * d2;
    }

    public boolean equals(Object object) {
        if (!(object instanceof StudentsTDistribution)) {
            return false;
        }
        StudentsTDistribution studentsTDistribution = (StudentsTDistribution)object;
        return studentsTDistribution._n == this._n;
    }

    public double function(double d) {
        return this.cdf(d);
    }

    public double inverseCdf(double d) {
        double d2;
        if (d < 0.0) {
            throw new ProbError("The 'probability' can't be less than '0.0'.");
        }
        if (d > 1.0) {
            throw new ProbError("The 'probability' can't be greater than '1.0'.");
        }
        if (d <= this.cdf(-10000.0)) {
            return -10000.0;
        }
        if (d >= this.cdf(10000.0)) {
            return 10000.0;
        }
        if (_solver == null) {
            _solver = new Bisection();
        }
        try {
            d2 = _solver.solve(this, -10000.0, 10000.0, d);
        }
        catch (NonlinearException nonlinearException) {
            throw new ProbError("Nonlinear:" + nonlinearException.getMessage());
        }
        return d2;
    }

    public double mean() {
        return 0.0;
    }

    public double pdf(double d) {
        return Math.exp(this._k + Math.log(1.0 + d * (d / this._n)) * this._n12);
    }

    public double probability(double d, double d2) {
        if (d2 < d) {
            throw new InvalidArgumentError("X2 must be greater than or equal to x1.");
        }
        if (d == d2) {
            return 0.0;
        }
        return this.cdf(d2) - this.cdf(d);
    }

    public double std() {
        if (this._n <= 2.0) {
            throw new ProbError("Can't compute the std for degreesOfFreedom <= 2.0");
        }
        return Math.sqrt(this.variance());
    }

    public String toString() {
        return "StudentsDistribution(degreesOfFreedom = " + this._n + ")";
    }

    public double variance() {
        if (this._n <= 2.0) {
            throw new ProbError("Can't compute the variance for degreesOfFreedom <= 2.0");
        }
        return this._n / (this._n - 2.0);
    }
}

