/*
 * Decompiled with CFR 0.152.
 */
package drasys.or.prob;

import drasys.or.CompareI;
import drasys.or.InvalidArgumentError;
import drasys.or.alg.QuickSort;
import drasys.or.matrix.VectorElementI;
import drasys.or.matrix.VectorI;
import drasys.or.prob.DiscreteDistribution;
import drasys.or.prob.DiscreteDistributionI;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class EmpiricalDistribution
extends DiscreteDistribution
implements DiscreteDistributionI {
    Vector _elements;
    Hashtable _index;
    Element _tmp = new Element(0, 0.0);
    boolean _haveMean;
    boolean _haveVariance;
    double _mean;
    double _variance;

    public EmpiricalDistribution(int[] nArray, VectorI vectorI) {
        this.setParameters(nArray, vectorI);
    }

    public EmpiricalDistribution(int[] nArray, VectorI vectorI, long l) {
        super(l);
        this.setParameters(nArray, vectorI);
    }

    public double cdf(int n) {
        double d = 0.0;
        int n2 = 0;
        while (n2 < this._elements.size()) {
            Element element = (Element)this._elements.elementAt(n2);
            if (element._x > n) break;
            d += element._probability;
            ++n2;
        }
        return d;
    }

    public boolean equals(Object object) {
        if (!(object instanceof EmpiricalDistribution)) {
            return false;
        }
        EmpiricalDistribution empiricalDistribution = (EmpiricalDistribution)object;
        if (empiricalDistribution._elements.size() != this._elements.size()) {
            return false;
        }
        int n = 0;
        while (n < this._elements.size()) {
            Element element = (Element)this._elements.elementAt(n);
            Element element2 = (Element)empiricalDistribution._elements.elementAt(n);
            if (element._x != element2._x) {
                return false;
            }
            if (element._probability != element2._probability) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public int getRandomInteger() {
        double d = 0.0;
        double d2 = this._random.nextDouble();
        Element element = null;
        int n = 0;
        while (n < this._elements.size() - 1) {
            element = (Element)this._elements.elementAt(n);
            if (d2 <= (d += element._probability)) {
                return element._x;
            }
            ++n;
        }
        return element._x;
    }

    public double mean() {
        if (!this._haveMean) {
            this._haveMean = true;
            this._mean = 0.0;
            int n = 0;
            while (n < this._elements.size()) {
                Element element = (Element)this._elements.elementAt(n);
                this._mean += element._probability * (double)element._x;
                ++n;
            }
        }
        return this._mean;
    }

    public double pdf(int n) {
        this._tmp._x = n;
        Element element = (Element)this._index.get(this._tmp);
        if (element == null) {
            return 0.0;
        }
        return element._probability;
    }

    public double probability(int n, int n2) {
        double d = 0.0;
        int n3 = 0;
        while (n3 < this._elements.size()) {
            Element element = (Element)this._elements.elementAt(n3);
            if (element._x >= n) {
                if (element._x > n2) break;
                d += element._probability;
            }
            ++n3;
        }
        return d;
    }

    public void setParameters(int[] nArray, VectorI vectorI) {
        if (nArray.length != vectorI.size()) {
            throw new InvalidArgumentError("The argumants must be the same size.");
        }
        if (nArray.length == 0) {
            throw new InvalidArgumentError("The arguments are empty.");
        }
        this._elements = new Vector(nArray.length);
        this._index = new Hashtable(nArray.length);
        double d = 1.0 / vectorI.sum(0);
        Enumeration enumeration = vectorI.elements();
        while (enumeration.hasMoreElements()) {
            VectorElementI vectorElementI = (VectorElementI)enumeration.nextElement();
            Element element = new Element(nArray[vectorElementI.getIndex()], vectorElementI.getValue() * d);
            this._elements.addElement(element);
            this._index.put(element, element);
        }
        new QuickSort(this._tmp).sort(this._elements);
    }

    public double std() {
        return Math.sqrt(this.variance());
    }

    public String toString() {
        String string = "EmpiricalDistribution(";
        int n = 0;
        while (n < this._elements.size()) {
            Element element = (Element)this._elements.elementAt(n);
            if (n > 0) {
                string = String.valueOf(string) + ", ";
            }
            string = String.valueOf(string) + element._x + "=" + element._probability;
            ++n;
        }
        string = String.valueOf(string) + ")";
        return string;
    }

    public double variance() {
        if (!this._haveVariance) {
            this._haveVariance = true;
            double d = this.mean();
            this._variance = 0.0;
            int n = 0;
            while (n < this._elements.size()) {
                Element element = (Element)this._elements.elementAt(n);
                double d2 = (double)element._x - d;
                this._variance += element._probability * d2 * d2;
                ++n;
            }
        }
        return this._variance;
    }

    private static class Element
    implements CompareI {
        int _x;
        double _probability;

        Element(int n, double d) {
            this._x = n;
            this._probability = d;
        }

        public int compare(Object object, Object object2) {
            int n = ((Element)object)._x;
            int n2 = ((Element)object2)._x;
            if (n < n2) {
                return -1;
            }
            if (n2 < n) {
                return 1;
            }
            return 0;
        }

        public boolean equals(Object object) {
            return ((Element)object)._x == this._x;
        }

        public int hashCode() {
            return this._x;
        }
    }
}

