/*
 * Decompiled with CFR 0.152.
 */
package drasys.or.prob;

import drasys.or.InvalidArgumentError;
import drasys.or.prob.DiscreteDistribution;

public class DiscreteUniformDistribution
extends DiscreteDistribution {
    int _size;
    int _inc;
    int _min;
    int _max;

    public DiscreteUniformDistribution(int n, int n2, int n3) {
        this.setParameters(n, n2, n3);
    }

    public DiscreteUniformDistribution(int n, int n2, int n3, long l) {
        super(l);
        this.setParameters(n, n2, n3);
    }

    public double cdf(int n) {
        if (n < this._min) {
            return 0.0;
        }
        if (n >= this._max) {
            return 1.0;
        }
        return (double)(((n - this._min) / this._inc + 1) * this._inc) / (double)this._size;
    }

    public boolean equals(Object object) {
        if (!(object instanceof DiscreteUniformDistribution)) {
            return false;
        }
        DiscreteUniformDistribution discreteUniformDistribution = (DiscreteUniformDistribution)object;
        return discreteUniformDistribution._min == this._min && discreteUniformDistribution._inc == this._inc && discreteUniformDistribution._size == this._size;
    }

    public int getRandomInteger() {
        int n = (int)((double)this._size * this._random.nextDouble());
        if (n == this._size) {
            --n;
        }
        return this._min + n * this._inc;
    }

    public double mean() {
        return (double)this._min + (double)((this._size - 1) * this._inc) / 2.0;
    }

    public double pdf(int n) {
        if (n < this._min || n > this._max) {
            return 0.0;
        }
        if ((n - this._min + 1) % this._inc == 0) {
            return 1.0 / (double)this._size;
        }
        return 0.0;
    }

    public double probability(int n, int n2) {
        if (n2 < n) {
            throw new InvalidArgumentError("X2 must be greater than or equal to x1.");
        }
        if (n < this._min) {
            n = this._min;
        }
        if (n2 > this._max) {
            n2 = this._max;
        }
        if (n == n2) {
            return this.pdf(n);
        }
        if (n == this._min) {
            return this.cdf(n2);
        }
        return this.pdf(n) + (double)((n2 - n) / this._inc * this._inc) / (double)this._size;
    }

    public void setParameters(int n, int n2, int n3) {
        if (n2 == 0) {
            throw new InvalidArgumentError("The increment can not be zero.");
        }
        if (n3 < 2) {
            throw new InvalidArgumentError("The size must be greater than one.");
        }
        this._min = n;
        this._max = n + n2 * (n3 - 1);
        this._size = n3;
        this._inc = n2;
    }

    public double std() {
        double d = this._size * this._inc;
        return Math.sqrt((d * d - (double)this._inc) / 12.0);
    }

    public String toString() {
        return "DiscreteUniformDistribution(min = " + this._min + ", inc = " + this._inc + ", size = " + this._size + ")";
    }

    public double variance() {
        double d = this._size * this._inc;
        return (d * d - (double)this._inc) / 12.0;
    }
}

