/*
 * Decompiled with CFR 0.152.
 */
package drasys.or.prob;

import drasys.or.Functions;
import drasys.or.FunctionsI;
import drasys.or.InvalidArgumentError;
import drasys.or.prob.BinomialDistribution;
import drasys.or.prob.DiscreteDistribution;
import drasys.or.prob.DiscreteDistributionI;

public class BinomialDistributionBase
extends DiscreteDistribution
implements DiscreteDistributionI {
    int _n;
    double _p;
    double _q;
    double _lnp;
    double _lnq;
    double _lnfn;
    double _gp;
    double _gq;
    double _gexp;
    double _glog;
    double _gmean;
    double _gamma;
    double _glogp;
    double _glogq;
    FunctionsI _fnct;

    public BinomialDistributionBase(double d, int n) {
        this._fnct = new Functions();
        this.setParameters(d, n);
    }

    public BinomialDistributionBase(double d, int n, long l) {
        super(l);
        this._fnct = new Functions();
        this.setParameters(d, n);
    }

    public BinomialDistributionBase(double d, int n, FunctionsI functionsI) {
        this._fnct = functionsI;
        this.setParameters(d, n);
    }

    public double cdf(int n) {
        if (n < 0) {
            throw new InvalidArgumentError("The x argument must be greater than or equal to zero.");
        }
        double d = 0.0;
        int n2 = 0;
        while (n2 <= n) {
            d += this.pdf(n2);
            ++n2;
        }
        return d;
    }

    public boolean equals(Object object) {
        if (!(object instanceof BinomialDistribution)) {
            return false;
        }
        BinomialDistribution binomialDistribution = (BinomialDistribution)object;
        return binomialDistribution._p == this._p && binomialDistribution._n == this._n;
    }

    public int getRandomInteger() {
        int n = 0;
        if (this._n < 25) {
            int n2 = 0;
            while (n2 < this._n) {
                if (this._random.nextDouble() < this._gp) {
                    ++n;
                }
                ++n2;
            }
        } else if (this._gmean < 1.0) {
            double d = 1.0;
            int n3 = 0;
            while (n3 <= this._n) {
                if ((d *= this._random.nextDouble()) < this._gexp) break;
                ++n3;
            }
            n = n3 <= this._n ? n3 : this._n;
        } else {
            double d;
            double d2 = this._n;
            double d3 = d2 + 1.0;
            double d4 = Math.sqrt(2.0 * this._gmean * this._gq);
            while (true) {
                double d5;
                if ((d = d4 * (d5 = Math.tan(Math.PI * this._random.nextDouble())) + this._gmean) < 0.0 || d >= d3) {
                    continue;
                }
                d = Math.floor(d);
                double d6 = 1.2 * d4 * (1.0 + d5 * d5) * Math.exp(this._gamma - this._fnct.lnGamma(d + 1.0) - this._fnct.lnGamma(d2 - d + 1.0) + d * this._glogp + (d2 - d) * this._glogq);
                if (!(this._random.nextDouble() > d6)) break;
            }
            n = (int)d;
        }
        return this._gp != this._p ? this._n - n : n;
    }

    public double mean() {
        return (double)this._n * this._p;
    }

    public double pdf(int n) {
        if (n < 0) {
            throw new InvalidArgumentError("The x argument can't be less than zero.");
        }
        int n2 = this._n - n;
        return Math.exp(this._lnfn - this._fnct.lnFactorial(n) - this._fnct.lnFactorial(n2) + this._lnp * (double)n + this._lnq * (double)n2);
    }

    public double probability(int n, int n2) {
        if (n2 < n) {
            throw new InvalidArgumentError("The x2 must be greater than x1.");
        }
        if (n < 0) {
            throw new InvalidArgumentError("The x argument must be greater than or equal to zero.");
        }
        double d = 0.0;
        int n3 = n;
        while (n3 <= n2) {
            d += this.pdf(n3);
            ++n3;
        }
        return d;
    }

    public void setParameters(double d, int n) {
        if (n < 0) {
            throw new InvalidArgumentError("The parameter 'n' must be greater than zero.");
        }
        if (d < 0.0 || d > 1.0) {
            throw new InvalidArgumentError("The parameter 'p' must be between 0.0 and 1.0.");
        }
        this._n = n;
        this._p = d;
        this._q = 1.0 - d;
        this._lnp = Math.log(this._p);
        this._lnq = Math.log(this._q);
        this._lnfn = this._fnct.lnFactorial(this._n);
        this._gp = Math.min(this._p, this._q);
        this._gq = 1.0 - this._gp;
        this._gmean = this._gp * (double)this._n;
        this._gexp = Math.exp(-this._gmean);
        this._glogp = Math.log(this._gp);
        this._glogq = Math.log(1.0 - this._gp);
        this._gamma = this._fnct.lnGamma(this._n + 1);
    }

    public double std() {
        return Math.sqrt((double)this._n * this._p * this._q);
    }

    public String toString() {
        return "BinomialDistribution(p = " + this._p + ", n = " + this._n + ")";
    }

    public double variance() {
        return (double)this._n * this._p * this._q;
    }
}

