/*
 * Decompiled with CFR 0.152.
 */
package drasys.or.nonlinear;

import drasys.or.nonlinear.AccuracyException;
import drasys.or.nonlinear.FunctionI;
import drasys.or.nonlinear.IntegrationI;
import java.io.Serializable;

public class Trapezoidal
implements IntegrationI,
Serializable {
    int _maxIt = 25;
    double _epsilon = 1.0E-6;

    public double getEpsilon() {
        return this._epsilon;
    }

    public int getMaxIterations() {
        return this._maxIt;
    }

    public double integrate(FunctionI functionI, double d, double d2) throws AccuracyException {
        double d3;
        double d4;
        double d5;
        if (d2 < d) {
            d5 = d;
            d4 = d2;
        } else {
            d4 = d;
            d5 = d2;
        }
        double d6 = d5 - d4;
        double d7 = d3 = 0.5 * d6 * (functionI.function(d4) + functionI.function(d5));
        int n = 1;
        int n2 = 0;
        while (n2 < this._maxIt) {
            double d8 = d6 / (double)n;
            double d9 = d4 + 0.5 * d8;
            double d10 = 0.0;
            int n3 = 0;
            while (n3 < n) {
                d10 += functionI.function(d9);
                d9 += d8;
                ++n3;
            }
            if (Math.abs((d3 = 0.5 * (d3 + d6 * d10 / (double)n)) - d7) <= this._epsilon * Math.abs(d7)) {
                return d3;
            }
            d7 = d3;
            n <<= 1;
            ++n2;
        }
        throw new AccuracyException("Can't find the answer to the specified accuracy");
    }

    public void setEpsilon(double d) {
        this._epsilon = d;
    }

    public void setMaxIterations(int n) {
        this._maxIt = n;
    }
}

