/*
 * Decompiled with CFR 0.152.
 */
package drasys.or.nonlinear;

import drasys.or.nonlinear.AccuracyException;
import drasys.or.nonlinear.EquationSolutionI;
import drasys.or.nonlinear.FunctionI;
import drasys.or.nonlinear.NonlinearException;
import java.io.Serializable;

public class Bisection
implements EquationSolutionI,
Serializable {
    int _maxIt = 40;
    double _accuracy = 1.0E-6;

    public double getAccuracy() {
        return this._accuracy;
    }

    public int getMaxIterations() {
        return this._maxIt;
    }

    public void setAccuracy(double d) {
        this._accuracy = d;
    }

    public void setMaxIterations(int n) {
        this._maxIt = n;
    }

    public double solve(FunctionI functionI, double d, double d2, double d3) throws NonlinearException, AccuracyException {
        double d4;
        double d5;
        double d6 = functionI.function(d);
        double d7 = functionI.function(d2);
        if (d6 == d3) {
            return d;
        }
        if (d7 == d3) {
            return d2;
        }
        if ((d6 - d3) * (d7 - d3) > 0.0) {
            throw new NonlinearException("The 'y' value is not bracketed.");
        }
        if (d6 < d3) {
            d5 = d2 - d;
            d4 = d;
        } else {
            d5 = d - d2;
            d4 = d2;
        }
        int n = 0;
        while (n < this._maxIt) {
            double d8 = d4 + (d5 *= 0.5);
            double d9 = functionI.function(d8);
            if (d9 <= d3) {
                d4 = d8;
            }
            if (d9 == d3 || Math.abs(d5) < this._accuracy) {
                return d4;
            }
            ++n;
        }
        throw new AccuracyException("Can't find y to specified accuracy");
    }
}

