/*
 * Decompiled with CFR 0.152.
 */
package drasys.or.mp.lp;

import drasys.or.matrix.MatrixElementI;
import drasys.or.matrix.VectorI;
import drasys.or.mp.ConstraintI;
import drasys.or.mp.ConvergenceException;
import drasys.or.mp.InfeasibleException;
import drasys.or.mp.InvalidException;
import drasys.or.mp.NoSolutionException;
import drasys.or.mp.ProblemI;
import drasys.or.mp.ScaleException;
import drasys.or.mp.UnboundedException;
import drasys.or.mp.Variable;
import drasys.or.mp.VariableI;
import drasys.or.mp.lp.LinearProgrammingI;
import java.io.Serializable;
import java.util.Enumeration;

public abstract class DenseLPBase
implements LinearProgrammingI,
Serializable {
    protected int _sizeOfRows;
    protected int _sizeOfColumns;
    protected int _maxIterations;
    protected int _nonZeroCnt;
    protected double _fuzz;
    protected double _minCoefficient;
    protected double _maxCoefficient;
    protected double _minAbsVal = Double.MAX_VALUE;
    protected double _maxAbsVal = 0.0;
    protected byte[] _typ;
    protected double[] _obj;
    protected double[] _rhs;
    protected double[][] _cof;
    protected String _name;
    protected boolean _solved;
    protected boolean _problemSet;
    protected boolean _autoScale;
    protected boolean _isMaximize;

    private double doabs(double d) {
        if (d != 0.0) {
            double d2 = Math.abs(d);
            this._minAbsVal = Math.min(this._minAbsVal, d2);
            this._maxAbsVal = Math.max(this._maxAbsVal, d2);
        }
        return d;
    }

    public abstract double getObjectiveValue() throws NoSolutionException;

    public abstract VectorI getSolution() throws NoSolutionException;

    public void setProblem(ProblemI problemI) throws InvalidException {
        Object object;
        Object object2;
        this._solved = false;
        this._problemSet = false;
        this._sizeOfRows = problemI.sizeOfConstraints();
        this._sizeOfColumns = problemI.sizeOfVariables();
        this._fuzz = problemI.getMetadata().get("lp.epsilon", 1.0E-6, 0.0);
        this._autoScale = problemI.getMetadata().get("lp.autoScale", false);
        this._isMaximize = problemI.getMetadata().get("lp.isMaximize", false);
        this._name = problemI.getMetadata().get("lp.name", null);
        this._minCoefficient = problemI.getMetadata().get("lp.minCoefficient", 1.0E-4, 0.0);
        this._maxCoefficient = problemI.getMetadata().get("lp.maxCoefficient", 100000.0, 0.0);
        this._maxIterations = problemI.getMetadata().get("lp.maxIterations", this._sizeOfColumns * 20, this._sizeOfColumns);
        this._cof = new double[this._sizeOfRows][this._sizeOfColumns];
        Enumeration enumeration = problemI.coefficients();
        while (enumeration.hasMoreElements()) {
            object2 = (MatrixElementI)enumeration.nextElement();
            this._cof[object2.getRowIndex()][object2.getColumnIndex()] = object2.getValue();
        }
        this._typ = new byte[this._sizeOfRows];
        this._rhs = new double[this._sizeOfRows];
        object2 = problemI.constraints();
        while (object2.hasMoreElements()) {
            object = (ConstraintI)object2.nextElement();
            this._rhs[object.getRowIndex()] = object.getRightHandSide();
            this._typ[object.getRowIndex()] = object.getType();
        }
        this._obj = new double[this._sizeOfColumns];
        object = problemI.variables();
        while (object.hasMoreElements()) {
            VariableI variableI = (VariableI)object.nextElement();
            byte by = variableI.getType();
            if (by != 21) {
                throw new InvalidException("Invalid Variable type: " + Variable.typeToString(by));
            }
            this._obj[variableI.getColumnIndex()] = variableI.getObjectiveCoefficient();
        }
        this._problemSet = true;
    }

    public abstract double solve() throws NoSolutionException, UnboundedException, InfeasibleException, ConvergenceException, ScaleException, InvalidException;
}

