/*
 * Decompiled with CFR 0.152.
 */
package drasys.or.matrix;

import drasys.or.matrix.ColumnMajorMatrix;
import drasys.or.matrix.ContiguousMatrix;
import drasys.or.matrix.DenseVector;
import drasys.or.matrix.MatrixElementI;
import drasys.or.matrix.MatrixI;
import drasys.or.matrix.VectorElementI;
import drasys.or.matrix.VectorI;
import drasys.or.util.Array;
import java.util.Enumeration;

public class RowMajorMatrix
extends ContiguousMatrix {
    public RowMajorMatrix(int n, int n2) {
        super(n, n2, n, n2);
    }

    public RowMajorMatrix(int n, int n2, int n3, int n4) {
        super(n, n2, n3, n4);
    }

    public RowMajorMatrix(MatrixI matrixI) {
        super(matrixI);
        if (matrixI instanceof RowMajorMatrix) {
            RowMajorMatrix rowMajorMatrix = (RowMajorMatrix)matrixI;
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            while (n < this._sizeOfRows) {
                Array.copy(this._sizeOfColumns, this._values, n2, 1, rowMajorMatrix._values, n3, 1);
                ++n;
                n2 += this._capacityOfColumns;
                n3 += rowMajorMatrix._capacityOfColumns;
            }
        } else if (matrixI instanceof ColumnMajorMatrix) {
            ColumnMajorMatrix columnMajorMatrix = (ColumnMajorMatrix)matrixI;
            int n = 0;
            int n4 = 0;
            int n5 = 0;
            while (n < this._sizeOfRows) {
                Array.copy(this._sizeOfColumns, this._values, n4, 1, columnMajorMatrix._values, n5, columnMajorMatrix._capacityOfColumns);
                ++n;
                n4 += this._capacityOfColumns;
                ++n5;
            }
        } else {
            Enumeration enumeration = matrixI.elements();
            while (enumeration.hasMoreElements()) {
                MatrixElementI matrixElementI = (MatrixElementI)enumeration.nextElement();
                this.setElementAt(matrixElementI.getRowIndex(), matrixElementI.getColumnIndex(), matrixElementI.getValue());
            }
        }
    }

    public RowMajorMatrix(VectorI vectorI) {
        super(vectorI);
    }

    public RowMajorMatrix(double[][] dArray) {
        super(dArray);
        int n = 0;
        int n2 = 0;
        while (n < dArray.length) {
            double[] dArray2 = dArray[n];
            if (dArray2 != null) {
                Array.copy(dArray2.length, this._values, n2, 1, dArray2, 0, 1);
            }
            ++n;
            n2 += this._capacityOfColumns;
        }
    }

    public void addColumn(VectorI vectorI) {
        int n = this._sizeOfColumns;
        this.setSize(this._sizeOfRows, this._sizeOfColumns + 1);
        if (vectorI == null) {
            return;
        }
        if (vectorI instanceof DenseVector) {
            DenseVector denseVector = (DenseVector)vectorI;
            int n2 = Math.min(vectorI.size(), this._sizeOfRows);
            Array.copy(n2, this._values, this._sizeOfColumns - 1, this._capacityOfRows, denseVector._values, 0, 1);
        } else {
            Enumeration enumeration = vectorI.elements();
            while (enumeration.hasMoreElements()) {
                VectorElementI vectorElementI = (VectorElementI)enumeration.nextElement();
                int n3 = vectorElementI.getIndex();
                if (n3 >= this._sizeOfRows) continue;
                this.setElementAt(n3, n, vectorElementI.getValue());
            }
        }
    }

    public void addRow(VectorI vectorI) {
        int n = this._sizeOfRows;
        this.setSize(this._sizeOfRows + 1, this._sizeOfColumns);
        if (vectorI == null) {
            return;
        }
        if (vectorI instanceof DenseVector) {
            DenseVector denseVector = (DenseVector)vectorI;
            int n2 = Math.min(vectorI.size(), this._sizeOfColumns);
            Array.copy(n2, this._values, n * this._capacityOfColumns, 1, denseVector._values, 0, 1);
        } else {
            Enumeration enumeration = vectorI.elements();
            while (enumeration.hasMoreElements()) {
                VectorElementI vectorElementI = (VectorElementI)enumeration.nextElement();
                int n3 = vectorElementI.getIndex();
                if (n3 >= this._sizeOfColumns) continue;
                this.setElementAt(n, n3, vectorElementI.getValue());
            }
        }
    }

    public double elementAt(int n, int n2) {
        if (n < 0 || n >= this._sizeOfRows) {
            throw new IndexOutOfBoundsException("Row=" + n + ", sizeOfRows=" + this._sizeOfRows);
        }
        if (n2 < 0 || n2 >= this._sizeOfColumns) {
            throw new IndexOutOfBoundsException("Column=" + n2 + ", sizeOfColumns=" + this._sizeOfColumns);
        }
        return this._values[n2 + this._capacityOfColumns * n];
    }

    public double[][] getArray() {
        double[][] dArray = new double[this._sizeOfRows][this._sizeOfColumns];
        int n = 0;
        int n2 = 0;
        while (n < dArray.length) {
            double[] dArray2 = dArray[n];
            Array.copy(dArray2.length, dArray2, 0, 1, this._values, n2, 1);
            ++n;
            n2 += this._capacityOfColumns;
        }
        return dArray;
    }

    public int getColumnIncrement() {
        return 1;
    }

    public int getOffset(int n, int n2) {
        if (n < 0 || n >= this._sizeOfRows) {
            throw new IndexOutOfBoundsException("Row=" + n + ", sizeOfRows=" + this._sizeOfRows);
        }
        if (n2 < 0 || n2 >= this._sizeOfColumns) {
            throw new IndexOutOfBoundsException("Column=" + n2 + ", sizeOfColumns=" + this._sizeOfColumns);
        }
        return n * this._capacityOfColumns + n2;
    }

    public int getRowIncrement() {
        return this._capacityOfColumns;
    }

    public boolean isColumnMajor() {
        return false;
    }

    public boolean isRowMajor() {
        return true;
    }

    public void setCapacity(int n, int n2) {
        if (n <= this._capacityOfRows && n2 <= this._capacityOfColumns) {
            return;
        }
        double[] dArray = new double[n * n2];
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        while (n3 < this._sizeOfRows) {
            Array.copy(this._sizeOfColumns, dArray, n5, 1, this._values, n4, 1);
            ++n3;
            n4 += this._capacityOfColumns;
            n5 += n2;
        }
        this._values = dArray;
        this._capacityOfRows = n;
        this._capacityOfColumns = n2;
    }

    public void setElementAt(int n, int n2, double d) {
        if (n < 0 || n >= this._sizeOfRows) {
            throw new IndexOutOfBoundsException("Row=" + n + ", sizeOfRows=" + this._sizeOfRows);
        }
        if (n2 < 0 || n2 >= this._sizeOfColumns) {
            throw new IndexOutOfBoundsException("Column=" + n2 + ", sizeOfColumns=" + this._sizeOfColumns);
        }
        this._values[n2 + this._capacityOfColumns * n] = d;
    }

    public void setSize(int n, int n2) {
        if (n > this._capacityOfRows || n2 > this._capacityOfColumns) {
            this.setCapacity(n, n2);
        }
        int n3 = this._sizeOfRows;
        int n4 = this._sizeOfRows * this._capacityOfColumns;
        while (n3 < n) {
            Array.copy(n2, this._values, n4, 1, 0.0);
            ++n3;
            n4 += this._capacityOfColumns;
        }
        if (n2 > this._sizeOfColumns) {
            int n5 = n2 - this._sizeOfColumns;
            int n6 = 0;
            int n7 = this._sizeOfColumns;
            while (n6 < this._sizeOfRows) {
                Array.copy(n5, this._values, n7, 1, 0.0);
                ++n6;
                n7 += this._capacityOfColumns;
            }
        }
        this._sizeOfRows = n;
        this._sizeOfColumns = n2;
    }
}

