/*
 * Decompiled with CFR 0.152.
 */
package drasys.or.matrix;

import drasys.or.matrix.CompressedMatrix;
import drasys.or.matrix.MatrixElementI;
import drasys.or.matrix.MatrixI;
import drasys.or.matrix.VectorElementI;
import drasys.or.matrix.VectorI;
import drasys.or.util.Array;
import java.util.Enumeration;

public class CompressedRowMatrix
extends CompressedMatrix {
    int[] _rowSize = null;
    int[] _rowBegin = null;
    int[] _columnIndex = null;
    int[] _rowIndex = null;
    int[] _columnEnd = null;
    int[] _valueIndex = null;

    public CompressedRowMatrix(int n, int n2, int n3) {
        this(n, n2, n3, n * (1 + n3));
    }

    public CompressedRowMatrix(int n, int n2, int n3, int n4) {
        this._sizeOfRows = 0;
        this._fillInSpace = n3;
        this._sizeOfColumns = n2;
        this.resizeRows(n);
        this.resizeElements(n4);
    }

    public CompressedRowMatrix(MatrixI matrixI, int n) {
        this._sizeOfRows = matrixI.sizeOfRows();
        this._sizeOfColumns = matrixI.sizeOfColumns();
        this._sizeOfElements = matrixI.sizeOfElements();
        this._fillInSpace = n;
        this.resizeRows(this._sizeOfRows);
        this.resizeElements(this._sizeOfElements + this._sizeOfRows * n);
        int n2 = 0;
        int n3 = 0;
        while (n3 < this._sizeOfRows) {
            this._rowBegin[n3] = n2;
            Enumeration enumeration = matrixI.rowElements(n3);
            while (enumeration.hasMoreElements()) {
                MatrixElementI matrixElementI = (MatrixElementI)enumeration.nextElement();
                int n4 = matrixElementI.getColumnIndex();
                double d = matrixElementI.getValue();
                int n5 = n3;
                this._rowSize[n5] = this._rowSize[n5] + 1;
                this._values[n2] = d;
                this._columnIndex[n2++] = n4;
            }
            n2 += this._fillInSpace;
            ++n3;
        }
    }

    public CompressedRowMatrix(VectorI vectorI, int n) {
        this._sizeOfRows = vectorI.size();
        this._sizeOfColumns = vectorI.size();
        this._sizeOfElements = vectorI.size();
        this._fillInSpace = n;
        this.resizeRows(this._sizeOfRows);
        this.resizeElements(this._sizeOfElements + this._sizeOfRows * n);
        int n2 = 0;
        int n3 = 0;
        while (n3 < this._sizeOfRows) {
            double d = vectorI.elementAt(n3);
            int n4 = n3;
            this._rowSize[n4] = this._rowSize[n4] + 1;
            this._values[n2] = d;
            this._columnIndex[n2++] = n3++;
        }
        n2 += this._fillInSpace;
    }

    public CompressedRowMatrix(double[][] dArray, int n) {
        super(dArray);
        this._fillInSpace = n;
        this._sizeOfRows = dArray.length;
        this.resizeRows(this._sizeOfRows);
        this.resizeElements(this._sizeOfElements + this._sizeOfRows * n);
        int n2 = 0;
        int n3 = 0;
        while (n3 < this._sizeOfRows) {
            double[] dArray2 = dArray[n3];
            this._rowBegin[n3] = n2;
            int n4 = 0;
            while (n4 < dArray2.length) {
                int n5 = n3;
                this._rowSize[n5] = this._rowSize[n5] + 1;
                this._values[n2] = dArray2[n4];
                this._columnIndex[n2++] = n4++;
            }
            n2 += this._fillInSpace;
            ++n3;
        }
    }

    public CompressedRowMatrix(double[][] dArray, int n, double d) {
        super(dArray, d);
        this._fillInSpace = n;
        this._sizeOfRows = dArray.length;
        this.resizeRows(this._sizeOfRows);
        this.resizeElements(this._sizeOfElements + this._sizeOfRows * n);
        int n2 = 0;
        int n3 = 0;
        while (n3 < this._sizeOfRows) {
            double[] dArray2 = dArray[n3];
            this._rowBegin[n3] = n2;
            int n4 = 0;
            while (n4 < dArray2.length) {
                double d2 = dArray2[n4];
                if (!this.equals(d2, 0.0)) {
                    int n5 = n3;
                    this._rowSize[n5] = this._rowSize[n5] + 1;
                    this._values[n2] = d2;
                    this._columnIndex[n2++] = n4;
                }
                ++n4;
            }
            n2 += this._fillInSpace;
            ++n3;
        }
    }

    public void addColumn(VectorI vectorI) {
        int n = this._sizeOfColumns;
        this.setSize(this._sizeOfRows, this._sizeOfColumns + 1);
        if (vectorI == null) {
            return;
        }
        Enumeration enumeration = vectorI.elements();
        while (enumeration.hasMoreElements()) {
            VectorElementI vectorElementI = (VectorElementI)enumeration.nextElement();
            this.setElementAt(vectorElementI.getIndex(), n, vectorElementI.getValue());
        }
    }

    public void addRow(VectorI vectorI) {
        int n = this._sizeOfRows;
        this.setSize(this._sizeOfRows + 1, this._sizeOfColumns);
        if (vectorI == null) {
            return;
        }
        Enumeration enumeration = vectorI.elements();
        while (enumeration.hasMoreElements()) {
            VectorElementI vectorElementI = (VectorElementI)enumeration.nextElement();
            this.setElementAt(n, vectorElementI.getIndex(), vectorElementI.getValue());
        }
    }

    public void buildColumnIndex() {
        int n;
        int n2;
        this._rowIndex = new int[this._sizeOfElements];
        this._columnEnd = new int[this._sizeOfColumns];
        this._valueIndex = new int[this._sizeOfElements];
        int[] nArray = new int[this._sizeOfColumns];
        int n3 = 0;
        while (n3 < this._sizeOfRows) {
            n2 = this._rowBegin[n3];
            n = this._rowSize[n3];
            while (n > 0) {
                int n4 = this._columnIndex[n2];
                nArray[n4] = nArray[n4] + 1;
                --n;
                ++n2;
            }
            ++n3;
        }
        n2 = 0;
        n = 0;
        while (n < this._sizeOfColumns) {
            this._columnEnd[n] = n2 += nArray[n];
            ++n;
        }
        Array.copy(this._sizeOfColumns, nArray, 0, 1, 0);
        int n5 = 0;
        while (n5 < this._sizeOfRows) {
            int n6 = this._rowBegin[n5];
            int n7 = this._rowSize[n5];
            while (n7 > 0) {
                int n8 = this._columnIndex[n6];
                int n9 = (n8 == 0 ? 0 : this._columnEnd[n8 - 1]) + nArray[n8];
                this._rowIndex[n9] = n5;
                this._valueIndex[n9] = n6++;
                int n10 = n8;
                nArray[n10] = nArray[n10] + 1;
                --n7;
            }
            ++n5;
        }
    }

    public int capacityOfColumns() {
        return Integer.MAX_VALUE;
    }

    public int capacityOfRows() {
        return this._rowBegin.length;
    }

    public Enumeration columnElements(int n) {
        if (n < 0 || n >= this._sizeOfColumns) {
            throw new IndexOutOfBoundsException("Column=" + n + ", sizeOfColumns=" + this._sizeOfColumns);
        }
        if (this._columnEnd == null) {
            this.buildColumnIndex();
        }
        return new EnumCol(n);
    }

    public void deleteColumnIndex() {
        this._rowIndex = null;
        this._columnEnd = null;
        this._valueIndex = null;
    }

    public double elementAt(int n, int n2) {
        if (n < 0 || n >= this._sizeOfRows) {
            throw new IndexOutOfBoundsException("Row=" + n + ", sizeOfRows=" + this._sizeOfRows);
        }
        if (n2 < 0 || n2 >= this._sizeOfColumns) {
            throw new IndexOutOfBoundsException("Column=" + n2 + ", sizeOfColumns=" + this._sizeOfColumns);
        }
        int n3 = Array.find(this._rowSize[n], this._columnIndex, this._rowBegin[n], 1, n2, n2);
        return n3 == -1 ? 0.0 : this._values[n3];
    }

    public Enumeration elements() {
        return new Enum();
    }

    public double[][] getArray() {
        double[][] dArray = new double[this.sizeOfRows()][this.sizeOfColumns()];
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            MatrixElementI matrixElementI = (MatrixElementI)enumeration.nextElement();
            dArray[matrixElementI.getRowIndex()][matrixElementI.getColumnIndex()] = matrixElementI.getValue();
        }
        return dArray;
    }

    public int[] getColumnEndArray() {
        return this._columnEnd;
    }

    public int[] getColumnIndexArray() {
        return this._columnIndex;
    }

    public int[] getRowBeginArray() {
        return this._rowBegin;
    }

    public int[] getRowIndexArray() {
        return this._rowIndex;
    }

    public int[] getRowSizeArray() {
        return this._rowSize;
    }

    public int[] getValueIndexArray() {
        return this._valueIndex;
    }

    private void insert(int n, int n2, double d) {
        int n3 = this._rowBegin[n] + this._rowSize[n];
        if (n == this._sizeOfRows - 1) {
            if (this._sizeOfElements >= this._values.length) {
                Array.resize(2 * this._values.length, this._values);
            }
        } else if (n3 >= this._rowBegin[n + 1]) {
            int n4 = 10 + this._sizeOfElements + this._sizeOfRows * this._fillInSpace;
            n4 = Math.max(n4, this._values.length);
            int[] nArray = new int[n4];
            double[] dArray = new double[n4];
            int n5 = 0;
            int n6 = 0;
            while (n6 < this._sizeOfRows) {
                int n7 = this._rowBegin[n6];
                this._rowBegin[n6] = n5;
                int n8 = this._rowSize[n6];
                Array.copy(n8, dArray, n5, 1, this._values, n7, 1);
                Array.copy(n8, nArray, n5, 1, this._columnIndex, n7, 1);
                if (n6 == n) {
                    ++n5;
                }
                n5 += n8 + this._fillInSpace;
                ++n6;
            }
            this._values = dArray;
            this._columnIndex = nArray;
        }
        this._values[n3] = d;
        this._columnIndex[n3] = n2;
        int n9 = n;
        this._rowSize[n9] = this._rowSize[n9] + 1;
        ++this._sizeOfElements;
        if (this._columnEnd != null) {
            this.deleteColumnIndex();
        }
    }

    public boolean isColumnMajor() {
        return false;
    }

    public boolean isNull(int n, int n2) {
        if (n < 0 || n >= this._sizeOfRows) {
            throw new IndexOutOfBoundsException("Row=" + n + ", sizeOfRows=" + this._sizeOfRows);
        }
        if (n2 < 0 || n2 >= this._sizeOfColumns) {
            throw new IndexOutOfBoundsException("Column=" + n2 + ", sizeOfColumns=" + this._sizeOfColumns);
        }
        int n3 = Array.find(this._rowSize[n], this._columnIndex, this._rowBegin[n], 1, n2, n2);
        return n3 == -1;
    }

    public boolean isRowMajor() {
        return true;
    }

    private void resizeElements(int n) {
        this._values = Array.resize(n, this._values);
        this._columnIndex = Array.resize(n, this._columnIndex);
    }

    private void resizeRows(int n) {
        this._rowSize = Array.resize(n, this._rowSize);
        this._rowBegin = Array.resize(n, this._rowBegin);
    }

    public Enumeration rowElements(int n) {
        if (n < 0 || n >= this._sizeOfRows) {
            throw new IndexOutOfBoundsException("Row=" + n + ", sizeOfRows=" + this._sizeOfRows);
        }
        return new EnumRow(n);
    }

    public void setCapacity(int n, int n2) {
        if (n > this.capacityOfRows()) {
            this.resizeRows(n);
            this.resizeElements(this._sizeOfElements + n * this._fillInSpace);
        }
    }

    public void setElementAt(int n, int n2, double d) {
        if (n < 0 || n >= this._sizeOfRows) {
            throw new IndexOutOfBoundsException("Row=" + n + ", sizeOfRows=" + this._sizeOfRows);
        }
        if (n2 < 0 || n2 >= this._sizeOfColumns) {
            throw new IndexOutOfBoundsException("Column=" + n2 + ", sizeOfColumns=" + this._sizeOfColumns);
        }
        int n3 = Array.find(this._rowSize[n], this._columnIndex, this._rowBegin[n], 1, n2, n2);
        if (n3 != -1) {
            this._values[n3] = d;
        } else {
            this.insert(n, n2, d);
        }
    }

    public void setSize(int n, int n2) {
        if (n < this._sizeOfRows || n2 < this._sizeOfColumns) {
            this._sizeOfRows = 0;
            this._sizeOfColumns = 0;
        }
        if (n > this.capacityOfRows()) {
            this.setCapacity(n, n2);
        }
        if (n > this._sizeOfRows) {
            int n3 = n - this._sizeOfRows;
            Array.copy(n3, this._rowSize, this._sizeOfRows, 1, 0);
            int n4 = this._sizeOfRows == 0 ? 0 : this._rowBegin[this._sizeOfRows - 1] + this._rowSize[this._sizeOfRows - 1] + this._fillInSpace;
            int n5 = this._sizeOfRows;
            while (n5 < n) {
                this._rowBegin[n5] = n4;
                n4 += this._fillInSpace;
                ++n5;
            }
            this._sizeOfRows = n;
        }
        this._sizeOfColumns = Math.max(this._sizeOfColumns, n2);
    }

    public int sizeOfElements() {
        return this._sizeOfElements;
    }

    public double sum(int n, int n2, int n3, int n4) {
        double d = 0.0;
        while (n < n2) {
            int n5 = this._rowBegin[n];
            int n6 = this._rowSize[n];
            while (n6 > 0) {
                int n7 = this._columnIndex[n5];
                if (n7 >= n3 && n7 < n4) {
                    d += this._values[n5];
                }
                --n6;
                ++n5;
            }
            ++n;
        }
        return d;
    }

    public double sumOfSquaredDifferences(int n, int n2, int n3, int n4, double d) {
        int n5 = 0;
        double d2 = 0.0;
        int n6 = (n2 - n) * (n4 - n3);
        while (n < n2) {
            int n7 = this._rowBegin[n];
            int n8 = this._rowSize[n];
            while (n8 > 0) {
                int n9 = this._columnIndex[n7];
                if (n9 >= n3 && n9 < n4) {
                    double d3 = this._values[n7] - d;
                    d2 += d3 * d3;
                    ++n5;
                }
                --n8;
                ++n7;
            }
            ++n;
        }
        if (d != 0.0) {
            d2 += (double)(n6 - n5) * d * d;
        }
        return d2;
    }

    public double sumOfSquares(int n, int n2, int n3, int n4) {
        double d = 0.0;
        while (n < n2) {
            int n5 = this._rowBegin[n];
            int n6 = this._rowSize[n];
            while (n6 > 0) {
                int n7 = this._columnIndex[n5];
                if (n7 >= n3 && n7 < n4) {
                    double d2 = this._values[n5];
                    d += d2 * d2;
                }
                --n6;
                ++n5;
            }
            ++n;
        }
        return d;
    }

    private class Enum
    implements Enumeration,
    MatrixElementI {
        int _row = 0;
        int _beg = 0;
        int _cnt = 0;
        int _column = 0;
        int _mrow;
        int _mcol;
        int _mk;
        double _mvalue;

        public Enum() {
            while (this._row < CompressedRowMatrix.this._sizeOfRows && CompressedRowMatrix.this._rowSize[this._row] < 1) {
                ++this._row;
            }
            if (this._row < CompressedRowMatrix.this._sizeOfRows) {
                this._cnt = CompressedRowMatrix.this._rowSize[this._row];
                this._beg = CompressedRowMatrix.this._rowBegin[this._row];
            }
        }

        public int getColumnIndex() {
            return this._mcol;
        }

        public int getRowIndex() {
            return this._mrow;
        }

        public double getValue() {
            return this._mvalue;
        }

        public boolean hasMoreElements() {
            return this._row < CompressedRowMatrix.this._sizeOfRows;
        }

        public Object nextElement() {
            if (this._row >= CompressedRowMatrix.this._sizeOfRows) {
                return null;
            }
            this._mk = this._beg;
            this._mrow = this._row++;
            this._mcol = CompressedRowMatrix.this._columnIndex[this._beg];
            this._mvalue = CompressedRowMatrix.this._values[this._beg++];
            if (--this._cnt <= 0) {
                while (this._row < CompressedRowMatrix.this._sizeOfRows && CompressedRowMatrix.this._rowSize[this._row] < 1) {
                    ++this._row;
                }
                if (this._row < CompressedRowMatrix.this._sizeOfRows) {
                    this._cnt = CompressedRowMatrix.this._rowSize[this._row];
                    this._beg = CompressedRowMatrix.this._rowBegin[this._row];
                }
            }
            return this;
        }

        public void setValue(double d) {
            CompressedRowMatrix.this._values[this._mk] = this._mvalue = d;
        }
    }

    private class EnumRow
    implements Enumeration,
    MatrixElementI {
        int _beg = 0;
        int _end = 0;
        int _mrow;
        int _mcol;
        int _mk;
        double _mvalue;

        public EnumRow(int n) {
            this._mrow = n;
            this._beg = CompressedRowMatrix.this._rowBegin[n];
            this._end = this._beg + CompressedRowMatrix.this._rowSize[n];
        }

        public int getColumnIndex() {
            return this._mcol;
        }

        public int getRowIndex() {
            return this._mrow;
        }

        public double getValue() {
            return this._mvalue;
        }

        public boolean hasMoreElements() {
            return this._beg < this._end;
        }

        public Object nextElement() {
            if (this._beg >= this._end) {
                return null;
            }
            this._mk = this._beg;
            this._mcol = CompressedRowMatrix.this._columnIndex[this._beg];
            this._mvalue = CompressedRowMatrix.this._values[this._beg];
            ++this._beg;
            return this;
        }

        public void setValue(double d) {
            CompressedRowMatrix.this._values[this._mk] = this._mvalue = d;
        }
    }

    private class EnumCol
    implements Enumeration,
    MatrixElementI {
        int _beg = 0;
        int _end = 0;
        int _mrow;
        int _mcol;
        int _mk;
        double _mvalue;

        public EnumCol(int n) {
            this._mcol = n;
            this._beg = n == 0 ? 0 : CompressedRowMatrix.this._columnEnd[n - 1];
            this._end = CompressedRowMatrix.this._columnEnd[n];
        }

        public int getColumnIndex() {
            return this._mcol;
        }

        public int getRowIndex() {
            return this._mrow;
        }

        public double getValue() {
            return this._mvalue;
        }

        public boolean hasMoreElements() {
            return this._beg < this._end;
        }

        public Object nextElement() {
            if (this._beg >= this._end) {
                return null;
            }
            this._mk = CompressedRowMatrix.this._valueIndex[this._beg];
            this._mrow = CompressedRowMatrix.this._rowIndex[this._beg];
            this._mvalue = CompressedRowMatrix.this._values[this._mk];
            ++this._beg;
            return this;
        }

        public void setValue(double d) {
            CompressedRowMatrix.this._values[this._mk] = this._mvalue = d;
        }
    }
}

