/*
 * Decompiled with CFR 0.152.
 */
package drasys.or.matrix;

import drasys.or.matrix.Matrix;
import drasys.or.matrix.SizableMatrixI;
import drasys.or.matrix.VectorI;
import drasys.or.util.Array;

public abstract class CompressedMatrix
extends Matrix
implements SizableMatrixI {
    int _sizeOfRows = 0;
    int _fillInSpace = 0;
    int _sizeOfColumns = 0;
    int _sizeOfElements = 0;
    double[] _values;

    public CompressedMatrix() {
    }

    public CompressedMatrix(double d) {
        super(d);
    }

    public CompressedMatrix(double[][] dArray) {
        boolean bl = false;
        boolean bl2 = false;
        int n = 0;
        while (n < dArray.length) {
            double[] dArray2 = dArray[n];
            if (dArray2 != null) {
                this._sizeOfElements += dArray2.length;
                if (dArray2.length > this._sizeOfColumns) {
                    this._sizeOfColumns = dArray2.length;
                }
            }
            ++n;
        }
    }

    public CompressedMatrix(double[][] dArray, double d) {
        super(d);
        boolean bl = false;
        boolean bl2 = false;
        int n = 0;
        while (n < dArray.length) {
            double[] dArray2 = dArray[n];
            if (dArray2 != null) {
                int n2 = 0;
                while (n2 < dArray2.length) {
                    double d2 = dArray2[n2];
                    if (!this.equals(0.0, d2)) {
                        ++this._sizeOfElements;
                    }
                    ++n2;
                }
                if (dArray2.length > this._sizeOfColumns) {
                    this._sizeOfColumns = dArray2.length;
                }
            }
            ++n;
        }
    }

    public abstract void addColumn(VectorI var1);

    public abstract void addRow(VectorI var1);

    public abstract int capacityOfColumns();

    public abstract int capacityOfRows();

    public double[] getValueArray() {
        return this._values;
    }

    public abstract void setCapacity(int var1, int var2);

    public void setCapacityOfElements(int n) {
        if (this._values.length < n) {
            Array.resize(n, this._values);
        }
    }

    public void setElements(double d) {
        Array.copy(this._values.length, this._values, 0, 1, d);
    }

    public abstract void setSize(int var1, int var2);

    public int sizeOfColumns() {
        return this._sizeOfColumns;
    }

    public int sizeOfRows() {
        return this._sizeOfRows;
    }
}

