/*
 * Decompiled with CFR 0.152.
 */
package drasys.or.geom.rect3;

import drasys.or.geom.GeomError;
import drasys.or.geom.rect3.Point;
import drasys.or.geom.rect3.PointI;
import drasys.or.geom.rect3.RangeI;
import drasys.or.geom.rect3.Rect3;
import java.io.Serializable;

public class Range
extends Rect3
implements RangeI,
Serializable {
    Point _min;
    Point _max;
    Point _minX_maxY_minZ = null;
    Point _maxX_minY_minZ = null;
    Point _minX_maxY_maxZ = null;
    Point _maxX_minY_maxZ = null;
    Point _minX_minY_maxZ = null;
    Point _maxX_maxY_minZ = null;

    public Range(double d, double d2, double d3, double d4, double d5, double d6) {
        double d7 = Math.min(d, d4);
        double d8 = Math.max(d, d4);
        double d9 = Math.min(d2, d5);
        double d10 = Math.max(d2, d5);
        double d11 = Math.min(d3, d6);
        double d12 = Math.max(d3, d6);
        this._min = new Point(d7, d9, d11);
        this._max = new Point(d8, d10, d12);
    }

    public Range(PointI pointI, PointI pointI2) {
        this(pointI.x(), pointI.y(), pointI.z(), pointI2.x(), pointI2.y(), pointI2.z());
    }

    public Range(RangeI rangeI) {
        this(rangeI.min(), rangeI.max());
    }

    public PointI bound(PointI pointI) {
        boolean bl = false;
        double d = pointI.x();
        double d2 = pointI.y();
        double d3 = pointI.z();
        if (d < this.minX()) {
            d = this.minX();
            bl = true;
        } else if (d > this.maxX()) {
            d = this.maxX();
            bl = true;
        }
        if (d2 < this.minY()) {
            d2 = this.minY();
            bl = true;
        } else if (d2 > this.maxY()) {
            d2 = this.maxY();
            bl = true;
        }
        if (d3 < this.minZ()) {
            d3 = this.minZ();
            bl = true;
        } else if (d3 > this.maxZ()) {
            d3 = this.maxZ();
            bl = true;
        }
        return bl ? new Point(d, d2, d3) : pointI;
    }

    public drasys.or.geom.PointI boundPoint(drasys.or.geom.PointI pointI) {
        return this.bound((PointI)pointI);
    }

    public PointI centroid() {
        return new Point((this.minX() + this.maxX()) * 0.5, (this.minY() + this.maxY()) * 0.5, (this.minZ() + this.maxZ()) * 0.5);
    }

    public double distanceProxyTo(PointI pointI) {
        PointI pointI2 = pointI;
        return pointI2.distanceProxyTo(this.nearestPointTo(pointI2));
    }

    public double distanceTo(PointI pointI) {
        PointI pointI2 = pointI;
        return pointI2.distanceTo(this.nearestPointTo(pointI2));
    }

    public boolean equals(Object object) {
        if (!(object instanceof RangeI)) {
            return false;
        }
        RangeI rangeI = (RangeI)object;
        if (!this._min.equals(rangeI.min())) {
            return false;
        }
        return this._max.equals(rangeI.max());
    }

    public drasys.or.geom.RangeI getExpandedRange(drasys.or.geom.PointI pointI) {
        if (this.includes(pointI)) {
            return this;
        }
        PointI pointI2 = (PointI)pointI;
        return new Range(Math.min(this._min.x(), pointI2.x()), Math.min(this._min.y(), pointI2.y()), Math.min(this._min.z(), pointI2.z()), Math.max(this._max.x(), pointI2.x()), Math.max(this._max.y(), pointI2.y()), Math.max(this._max.z(), pointI2.z()));
    }

    public drasys.or.geom.PointI getMax() {
        return this._max;
    }

    public drasys.or.geom.PointI getMin() {
        return this._min;
    }

    public int hashCode() {
        long l = Double.doubleToLongBits(this.minX()) + Double.doubleToLongBits(this.minY()) + Double.doubleToLongBits(this.minZ()) + Double.doubleToLongBits(this.maxX()) + Double.doubleToLongBits(this.maxY()) + Double.doubleToLongBits(this.maxZ());
        return (int)(l ^ l >> 32);
    }

    public boolean includes(drasys.or.geom.PointI pointI) {
        if (!(pointI instanceof PointI)) {
            throw new GeomError("The point must be on the same coordinate system as the range.");
        }
        PointI pointI2 = (PointI)pointI;
        return this._min.x() <= pointI2.x() && pointI2.x() <= this._max.x() && this._min.y() <= pointI2.y() && pointI2.y() <= this._max.y() && this._min.z() <= pointI2.z() && pointI2.z() <= this._max.z();
    }

    public PointI max() {
        return this._max;
    }

    public double maxX() {
        return this._max.x();
    }

    public double maxY() {
        return this._max.y();
    }

    public double maxZ() {
        return this._max.z();
    }

    public PointI min() {
        return this._min;
    }

    public double minX() {
        return this._min.x();
    }

    public double minY() {
        return this._min.y();
    }

    public double minZ() {
        return this._min.z();
    }

    public PointI nearestPointTo(PointI pointI) {
        PointI pointI2 = this.bound(pointI);
        if (pointI2 != pointI) {
            return pointI2;
        }
        double d = pointI2.x();
        double d2 = pointI2.y();
        double d3 = pointI2.y();
        double d4 = this.maxX() - d;
        double d5 = d - this.minX();
        double d6 = this.maxY() - d2;
        double d7 = d2 - this.minY();
        double d8 = this.maxZ() - d3;
        double d9 = d3 - this.minZ();
        double d10 = Math.min(Math.min(Math.min(d4, d5), Math.min(d6, d7)), Math.min(d8, d9));
        if (d4 == d10) {
            return new Point(this.maxX(), d2, d3);
        }
        if (d5 == d10) {
            return new Point(this.minX(), d2, d3);
        }
        if (d6 == d10) {
            return new Point(d, this.maxY(), d3);
        }
        if (d7 == d10) {
            return new Point(d, this.minY(), d3);
        }
        if (d8 == d10) {
            return new Point(d, d2, this.maxZ());
        }
        return new Point(d, d2, this.minZ());
    }

    public RangeI range() {
        return this;
    }

    public String toString() {
        return "rect3.Range{" + this._min.toString() + "; " + this._max.toString() + "}";
    }
}

