/*
 * Decompiled with CFR 0.152.
 */
package drasys.or.geom.geo;

import drasys.or.geom.geo.EllipsoidI;
import drasys.or.geom.geo.PointI;
import java.io.Serializable;

public class Ellipsoid
implements EllipsoidI,
Serializable {
    private static final double _K00 = 1.0;
    private static final double _K02 = 0.25;
    private static final double _K04 = 0.046875;
    private static final double _K06 = 0.01953125;
    private static final double _K08 = 0.01068115234375;
    private static final double _K22 = 0.75;
    private static final double _K44 = 0.46875;
    private static final double _K46 = 0.013020833333333334;
    private static final double _K48 = 0.007120768229166667;
    private static final double _K66 = 0.3645833333333333;
    private static final double _K68 = 0.005696614583333333;
    private static final double _K88 = 0.3076171875;
    private static Ellipsoid[] _ellipsoids = new Ellipsoid[]{new Ellipsoid("WGS 84", 6378137.0, 0.0033528106647474805), new Ellipsoid("WGS 72", 6378135.0, 0.003352779454167505), new Ellipsoid("WGS 66", 6378145.0, 0.003352891869237217), new Ellipsoid("WGS 60", 6378165.0, 0.003352329869259135), new Ellipsoid("South American 1969", 6378160.0, 0.003352891869237217), new Ellipsoid("Krassovsky 1940", 6378245.0, 0.003352329869259135), new Ellipsoid("Hough 1956", 6378270.0, 0.003367003367003367), new Ellipsoid("GRS 1980", 6378137.0, 0.003352810681182319), new Ellipsoid("GRS 1975", 6378140.0, 0.0033528131778969143), new Ellipsoid("GRS 1967", 6378160.0, 0.003352923712996414), new Ellipsoid("Fischer 1968", 6378150.0, 0.003352329869259135), new Ellipsoid("Fischer 1960", 6378166.0, 0.003352329869259135), new Ellipsoid("Everest 1830", 6377276.345, 0.003324449296662885), new Ellipsoid("Clarke 1880", 6378249.145, 0.003407561378699334), new Ellipsoid("Clarke 1866", 6378206.4, 0.0033900753040885176), new Ellipsoid("Bessel 1841", 6377397.155, 0.003342773182174806), new Ellipsoid("Airy 1830", 6377563.396, 0.0033408506414970775)};
    private String _name;
    private double _flattening;
    private double _meanRadius;
    private double _polarRadius;
    private double _equatorialRadius;
    private double _e;
    private double _e2;
    private double _halfE;
    private double _oneMinusE2;
    private double _ek0;
    private double _ek1;
    private double _ek2;
    private double _ek3;
    private double _ek4;

    public Ellipsoid(String string, double d, double d2) {
        this._name = string;
        this._flattening = d2;
        this._equatorialRadius = d;
        this._polarRadius = d - d2 * d;
        this._meanRadius = (this._polarRadius + this._equatorialRadius) * 0.5;
        this._e2 = 2.0 * d2 - d2 * d2;
        this._e = Math.sqrt(this._e2);
        this._halfE = 0.5 * this._e;
        this._oneMinusE2 = 1.0 - this._e2;
        this._ek0 = 1.0 - this._e2 * (0.25 + this._e2 * (0.046875 + this._e2 * (0.01953125 + this._e2 * 0.01068115234375)));
        this._ek1 = this._e2 * (0.75 - this._e2 * (0.046875 + this._e2 * (0.01953125 + this._e2 * 0.01068115234375)));
        double d3 = this._e2 * this._e2;
        this._ek2 = d3 * (0.46875 - this._e2 * (0.013020833333333334 + this._e2 * 0.007120768229166667));
        this._ek3 = (d3 *= this._e2) * (0.3645833333333333 - this._e2 * 0.005696614583333333);
        this._ek4 = d3 * this._e2 * 0.3076171875;
    }

    public double getEccentricity() {
        return this._e;
    }

    public double getEccentricitySquared() {
        return this._e2;
    }

    public static String[] getEllipsoidNames() {
        String[] stringArray = new String[_ellipsoids.length];
        int n = 0;
        while (n < _ellipsoids.length) {
            stringArray[n] = _ellipsoids[n].getName();
            ++n;
        }
        return stringArray;
    }

    public double getEquatorialRadius() {
        return this._equatorialRadius;
    }

    public double getFlattening() {
        return this._flattening;
    }

    public static Ellipsoid getInstance(String string) {
        int n = 0;
        while (n < _ellipsoids.length) {
            if (string.equals(_ellipsoids[n].getName())) {
                return _ellipsoids[n];
            }
            ++n;
        }
        return null;
    }

    public double getInverseMeridinalDistance(double d) {
        double d2 = d;
        double d3 = 1.0 - this._e2;
        int n = 0;
        while (n < 10) {
            double d4 = Math.sin(d2);
            double d5 = 1.0 - this._e2 * d4 * d4;
            d5 = (this.getMeridinalDistance(d2, d4, Math.cos(d2)) - d) / (d3 * d5 * Math.sqrt(d5));
            d2 -= d5;
            if (Math.abs(d5) < 1.0E-11) break;
            ++n;
        }
        return d2;
    }

    public double getMeanRadius() {
        return this._meanRadius;
    }

    public double getMeridinalDistance(double d) {
        return this.getMeridinalDistance(d, Math.sin(d), Math.cos(d));
    }

    public double getMeridinalDistance(double d, double d2, double d3) {
        d3 *= d2;
        d2 *= d2;
        return this._ek0 * d - d3 * (this._ek1 + d2 * (this._ek2 + d2 * (this._ek3 + d2 * this._ek4)));
    }

    public String getName() {
        return this._name;
    }

    public double getPolarRadius() {
        return this._polarRadius;
    }

    public static double greatCircleAngle(PointI pointI, PointI pointI2) {
        double d = 0.01745329251994 * (90.0 - pointI2.latitude());
        double d2 = 0.01745329251994 * (90.0 - pointI.latitude());
        double d3 = 0.01745329251994 * (pointI2.longitude() - pointI.longitude());
        double d4 = Math.cos(d) * Math.cos(d2) + Math.sin(d) * Math.sin(d2) * Math.cos(d3);
        if (d4 <= -1.0) {
            return 180.0;
        }
        if (d4 >= 1.0) {
            return 0.0;
        }
        return Math.acos(d4);
    }

    public double greatCircleSphericalDistance(PointI pointI, PointI pointI2) {
        double d = 0.01745329251994 * pointI.latitude();
        double d2 = 0.01745329251994 * pointI2.latitude();
        double d3 = Math.cos(0.01745329251994 * pointI.longitude() - 0.01745329251994 * pointI2.longitude());
        double d4 = this._meanRadius * Math.acos(0.5 * ((1.0 + d3) * Math.cos(d - d2) - (1.0 - d3) * Math.cos(d + d2)));
        return d4;
    }
}

