/*
 * Decompiled with CFR 0.152.
 */
package drasys.or.cont;

import drasys.or.CompareI;
import drasys.or.CorruptedError;
import drasys.or.InvalidPriorityException;
import drasys.or.PairI;
import drasys.or.cont.PriorityQueueI;
import java.io.Serializable;
import java.util.Enumeration;

public class BinomialHeap
implements PriorityQueueI,
Serializable {
    int _size = 0;
    _Elem _head;
    CompareI _compare;

    public BinomialHeap(CompareI compareI) {
        this._compare = compareI;
    }

    private static void _binomialLink(_Elem _Elem2, _Elem _Elem3) {
        _Elem2._parent = _Elem3;
        _Elem2._sibling = _Elem3._child;
        _Elem3._child = _Elem2;
        _Elem3._deg = (byte)(_Elem3._deg + 1);
    }

    private void _bubbleUp(_Elem _Elem2, _Elem _Elem3) {
        if (_Elem2 == null || _Elem3 == null || _Elem2 == _Elem3) {
            throw new CorruptedError();
        }
        _Elem _Elem4 = null;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        if (this._head == _Elem2) {
            bl = true;
        } else if (_Elem2._parent == null) {
            _Elem4 = this._getElementReferrer(this._head, _Elem2);
            bl3 = true;
            if (_Elem4 == null) {
                throw new CorruptedError();
            }
        } else if (_Elem2._parent._child == _Elem2) {
            _Elem4 = _Elem2._parent;
            bl2 = true;
        } else {
            _Elem4 = this._getElementReferrer(_Elem2._parent._child, _Elem2);
            bl3 = true;
            if (_Elem4 == null) {
                throw new CorruptedError();
            }
        }
        _Elem _Elem5 = null;
        boolean bl4 = false;
        boolean bl5 = false;
        if (_Elem3._parent._child == _Elem3) {
            _Elem5 = _Elem3._parent;
            bl4 = true;
            if (_Elem5 == null) {
                throw new CorruptedError();
            }
        } else {
            _Elem5 = this._getElementReferrer(_Elem3._parent._child, _Elem3);
            bl5 = true;
            if (_Elem5 == null) {
                throw new CorruptedError();
            }
        }
        byte by = _Elem3._deg;
        byte by2 = _Elem2._deg;
        _Elem _Elem6 = _Elem3._sibling;
        _Elem _Elem7 = _Elem2._sibling;
        _Elem _Elem8 = _Elem3._parent;
        _Elem _Elem9 = _Elem2._parent;
        _Elem _Elem10 = _Elem3._child;
        _Elem _Elem11 = _Elem2._child;
        _Elem3._deg = by2;
        _Elem3._child = _Elem11;
        _Elem3._parent = _Elem9;
        _Elem3._sibling = _Elem7;
        _Elem2._deg = by;
        _Elem2._child = _Elem10;
        _Elem2._parent = _Elem8;
        _Elem2._sibling = _Elem6;
        if (bl) {
            this._head = _Elem3;
        } else if (bl2) {
            _Elem4._child = _Elem3;
        } else if (bl3) {
            _Elem4._sibling = _Elem3;
        } else {
            throw new CorruptedError();
        }
        if (bl4) {
            _Elem3._child = _Elem2;
        } else if (bl5) {
            _Elem5._sibling = _Elem2;
        } else {
            throw new CorruptedError();
        }
        BinomialHeap._setParentInSiblingList(_Elem3._child, _Elem3);
        BinomialHeap._setParentInSiblingList(_Elem2._child, _Elem2);
    }

    private boolean _checkElement(_Elem _Elem2, _Elem _Elem3, int n, int n2) {
        if (_Elem2 == null) {
            return true;
        }
        if (n > 100) {
            return false;
        }
        if (_Elem2._parent != _Elem3) {
            return false;
        }
        if (_Elem2._parent != null && this._compare.compare(_Elem2._priority, _Elem2._parent._priority) == 1) {
            return false;
        }
        if (_Elem2._sibling != null && n == 0 && _Elem2._sibling._deg <= _Elem2._deg) {
            return false;
        }
        if (_Elem2._sibling != null && n != 0 && _Elem2._sibling._deg >= _Elem2._deg) {
            return false;
        }
        if (!this._checkElement(_Elem2._child, _Elem2, n + 1, n2 + 1)) {
            return false;
        }
        return this._checkElement(_Elem2._sibling, _Elem3, n, n2 + 1);
    }

    private _Elem _getElementReferrer(_Elem _Elem2, _Elem _Elem3) throws CorruptedError {
        _Elem _Elem4 = _Elem2;
        int n = 0;
        while (n < 100 && _Elem4 != null) {
            if (_Elem4._sibling == _Elem3) {
                return _Elem4;
            }
            _Elem4 = _Elem4._sibling;
            ++n;
        }
        if (_Elem4 != null) {
            throw new CorruptedError();
        }
        return null;
    }

    private void _insertElement(_Elem _Elem2) {
        _Elem2._sibling = this._head;
        this._head = _Elem2;
        this._joinRoots();
        ++this._size;
    }

    private void _joinRoots() {
        _Elem _Elem2;
        if (this._head == null) {
            return;
        }
        _Elem _Elem3 = null;
        _Elem _Elem4 = this._head;
        while ((_Elem2 = _Elem4._sibling) != null) {
            if (_Elem4._deg != _Elem2._deg) {
                _Elem3 = _Elem4;
                _Elem4 = _Elem2;
                continue;
            }
            if (_Elem2._sibling != null && _Elem2._sibling._deg == _Elem4._deg) {
                _Elem3 = _Elem4;
                _Elem4 = _Elem2;
                continue;
            }
            if (this._compare.compare(_Elem4._priority, _Elem2._priority) == 1) {
                _Elem4._sibling = _Elem2._sibling;
                BinomialHeap._binomialLink(_Elem2, _Elem4);
            } else {
                if (_Elem3 == null) {
                    this._head = _Elem2;
                } else {
                    _Elem3._sibling = _Elem2;
                }
                BinomialHeap._binomialLink(_Elem4, _Elem2);
                _Elem4 = _Elem2;
            }
            _Elem2 = _Elem4._sibling;
        }
    }

    private static void _replaceInSiblingList(_Elem _Elem2, _Elem _Elem3, _Elem _Elem4) {
        _Elem _Elem5 = _Elem2;
        int n = 0;
        while (n < 100 && _Elem5 != null && _Elem5._sibling != _Elem3) {
            _Elem5 = _Elem5._sibling;
            ++n;
        }
        if (_Elem5 == null || _Elem5._sibling != _Elem3) {
            throw new CorruptedError();
        }
        _Elem5._sibling = _Elem4;
    }

    private static _Elem _reverseSiblingList(_Elem _Elem2) {
        if (_Elem2 == null) {
            return null;
        }
        _Elem _Elem3 = null;
        _Elem _Elem4 = _Elem2;
        _Elem _Elem5 = _Elem4._sibling;
        int n = 0;
        while (n < 100 && _Elem4 != null) {
            _Elem4._parent = null;
            _Elem4._sibling = _Elem3;
            _Elem3 = _Elem4;
            _Elem4 = _Elem5;
            if (_Elem5 != null) {
                _Elem5 = _Elem5._sibling;
            }
            ++n;
        }
        if (_Elem4 != null) {
            throw new CorruptedError();
        }
        return _Elem3;
    }

    private static void _setParentInSiblingList(_Elem _Elem2, _Elem _Elem3) {
        if (_Elem2 == null) {
            return;
        }
        _Elem _Elem4 = _Elem2;
        int n = 0;
        while (n < 100 && _Elem4 != null) {
            _Elem4._parent = _Elem3;
            _Elem4 = _Elem4._sibling;
            ++n;
        }
        if (_Elem4 != null) {
            throw new CorruptedError();
        }
    }

    private void _union(_Elem _Elem2) {
        _Elem _Elem3;
        if (this._head == null) {
            this._head = _Elem2;
            return;
        }
        if (_Elem2 == null) {
            return;
        }
        _Elem _Elem4 = this._head;
        _Elem _Elem5 = _Elem2;
        if (_Elem4._deg <= _Elem5._deg) {
            this._head = _Elem3 = _Elem4;
            _Elem4 = _Elem4._sibling;
        } else {
            this._head = _Elem3 = _Elem5;
            _Elem5 = _Elem5._sibling;
        }
        _Elem3._sibling = null;
        while (_Elem3 != null) {
            if (_Elem4 == null && _Elem5 == null) {
                _Elem3._sibling = null;
            } else if (_Elem4 == null) {
                _Elem3._sibling = _Elem5;
                _Elem5 = _Elem5._sibling;
            } else if (_Elem5 == null) {
                _Elem3._sibling = _Elem4;
                _Elem4 = _Elem4._sibling;
            } else if (_Elem4._deg <= _Elem5._deg) {
                _Elem3._sibling = _Elem4;
                _Elem4 = _Elem4._sibling;
            } else {
                _Elem3._sibling = _Elem5;
                _Elem5 = _Elem5._sibling;
            }
            _Elem3 = _Elem3._sibling;
            if (_Elem3 == null) continue;
            _Elem3._sibling = null;
        }
    }

    public void changePriority(PairI pairI, Object object) throws InvalidPriorityException {
        _Elem _Elem2 = (_Elem)pairI;
        int n = this._compare.compare(object, _Elem2._priority);
        if (n == 0) {
            return;
        }
        if (n == -1) {
            throw new InvalidPriorityException();
        }
        _Elem2._priority = object;
        int n2 = 0;
        while (n2 < 100 && _Elem2._parent != null) {
            if (this._compare.compare(_Elem2._priority, _Elem2._parent._priority) != 1) break;
            this._bubbleUp(_Elem2._parent, _Elem2);
            ++n2;
        }
        if (n2 >= 100) {
            throw new CorruptedError();
        }
    }

    public boolean check() {
        return this._checkElement(this._head, null, 0, 0);
    }

    public Enumeration elements() {
        return new _Enum(this._head);
    }

    public void ensureCapacity(int n) {
    }

    public PairI getHead() {
        if (this._head == null) {
            return null;
        }
        _Elem _Elem2 = this._head;
        _Elem _Elem3 = this._head._sibling;
        _Elem _Elem4 = this._head;
        _Elem _Elem5 = null;
        while (_Elem3 != null) {
            if (this._compare.compare(_Elem3._priority, _Elem4._priority) == 1) {
                _Elem4 = _Elem3;
                _Elem5 = _Elem2;
            }
            _Elem2 = _Elem3;
            _Elem3 = _Elem3._sibling;
        }
        return _Elem4;
    }

    public PairI insert(Object object) {
        _Elem _Elem2 = new _Elem(object, null);
        this._insertElement(_Elem2);
        return _Elem2;
    }

    public PairI insert(Object object, Object object2) {
        _Elem _Elem2 = new _Elem(object, object2);
        this._insertElement(_Elem2);
        return _Elem2;
    }

    public PairI popHead() {
        if (this._head == null) {
            return null;
        }
        _Elem _Elem2 = this._head;
        _Elem _Elem3 = this._head._sibling;
        _Elem _Elem4 = this._head;
        _Elem _Elem5 = null;
        while (_Elem3 != null) {
            if (this._compare.compare(_Elem3._priority, _Elem4._priority) == 1) {
                _Elem4 = _Elem3;
                _Elem5 = _Elem2;
            }
            _Elem2 = _Elem3;
            _Elem3 = _Elem3._sibling;
        }
        if (_Elem5 == null) {
            this._head = _Elem4._sibling;
        } else {
            _Elem5._sibling = _Elem4._sibling;
        }
        this._union(BinomialHeap._reverseSiblingList(_Elem4._child));
        --this._size;
        return _Elem4;
    }

    public void removeAllElements() {
        this._size = 0;
        this._head = null;
    }

    public void setCompare(CompareI compareI) {
        this.removeAllElements();
        this._compare = compareI;
    }

    public int size() {
        return this._size;
    }

    class _Elem
    implements PairI,
    Serializable {
        byte _deg = 0;
        Object _value = null;
        Object _priority = null;
        _Elem _child;
        _Elem _parent;
        _Elem _sibling;

        _Elem(Object object, Object object2) {
            this._priority = object;
            this._value = object2;
            this._sibling = null;
            this._parent = null;
            this._child = null;
        }

        public Object getFirst() {
            return this._priority;
        }

        public Object getSecond() {
            return this._value;
        }

        public String toString() {
            return "Element[deg=" + String.valueOf(this._deg) + ",priority=" + this._priority.toString() + "]";
        }
    }

    class _Enum
    implements Enumeration {
        _Elem _element;

        _Enum(_Elem _Elem2) {
            this._element = _Elem2;
        }

        public boolean hasMoreElements() {
            return this._element != null;
        }

        public Object nextElement() {
            if (this._element == null) {
                return null;
            }
            _Elem _Elem2 = this._element;
            if (this._element._child != null) {
                this._element = this._element._child;
                return _Elem2;
            }
            if (this._element._sibling != null) {
                this._element = this._element._sibling;
                return _Elem2;
            }
            this._element = this._element._parent;
            while (this._element != null) {
                if (this._element._sibling == null) continue;
                this._element = this._element._sibling;
            }
            return _Elem2;
        }
    }
}

