/*
 * Decompiled with CFR 0.152.
 */
package drasys.or;

import drasys.or.FunctionsI;
import drasys.or.InvalidArgumentError;
import drasys.or.ORError;
import java.io.Serializable;

public class Functions
implements FunctionsI,
Serializable {
    static double[] _lnFactorial;

    public double binomialCoefficient(int n, int n2) {
        if (n < n2) {
            throw new ORError("'k' can't be greater than 'n'");
        }
        if (n2 < 0) {
            throw new ORError("'k' can't be less than '0'");
        }
        return Math.floor(0.5 + Math.exp(this.lnFactorial(n) - this.lnFactorial(n2) - this.lnFactorial(n - n2)));
    }

    public double lnFactorial(int n) {
        if (n < 0) {
            throw new InvalidArgumentError("Can't compute the factorial for a negative number.");
        }
        if (n <= 1) {
            return 0.0;
        }
        if (n < 100) {
            double d;
            if (_lnFactorial == null) {
                _lnFactorial = new double[100];
            }
            if ((d = _lnFactorial[n]) == 0.0) {
                d = Functions._lnFactorial[n] = this.lnGamma(n + 1);
            }
            return d;
        }
        return this.lnGamma(n + 1);
    }

    public double lnGamma(double d) {
        if (d <= 0.0) {
            throw new InvalidArgumentError("The argument to 'lnGama' must be greater than zero.");
        }
        double d2 = d + 5.5;
        return Math.log((1.000000000190015 + 76.18009172947146 / (d + 1.0) - 86.50532032941678 / (d + 2.0) + 24.01409824083091 / (d + 3.0) - 1.231739572450155 / (d + 4.0) + 0.001208650973866179 / (d + 5.0) - 5.395239384953E-6 / (d + 6.0)) * 2.506628274631 / d) - d2 + Math.log(d2) * (d + 0.5);
    }
}

